/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.checker;

import java.io.StringReader;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import nu.validator.checker.Checker;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class SpeculationRulesChecker
extends Checker {
    private static final String HTML_NS = "http://www.w3.org/1999/xhtml";
    private boolean parsingSpeculationRules = false;
    private StringBuilder scriptContent = null;

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        String scriptType;
        if (HTML_NS.equals(uri) && "script".equals(localName) && atts.getIndex("", "type") > -1 && "speculationrules".equals(scriptType = atts.getValue("", "type").toLowerCase())) {
            if (atts.getIndex("", "src") > -1) {
                this.err("A \u201cscript\u201d element with a \u201ctype\u201d attribute whose value is \u201cspeculationrules\u201d must not have a \u201csrc\u201d attribute.");
            }
            this.parsingSpeculationRules = true;
            this.scriptContent = new StringBuilder();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.parsingSpeculationRules && this.scriptContent != null) {
            this.scriptContent.append(ch, start, length);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (HTML_NS.equals(uri) && "script".equals(localName) && this.parsingSpeculationRules) {
            this.isSpeculationRulesValid(this.scriptContent.toString());
            this.parsingSpeculationRules = false;
            this.scriptContent = null;
        }
    }

    private boolean isSpeculationRulesValid(String content) throws SAXException {
        JsonStructure speculationRules;
        try {
            JsonReader reader = Json.createReader(new StringReader(content));
            speculationRules = reader.read();
        }
        catch (JsonException e) {
            this.err("A \u201cscript\u201d element with a \u201ctype\u201d attribute whose value is \u201cspeculationrules\u201d must have valid JSON content.");
            return false;
        }
        if (!(speculationRules instanceof JsonObject)) {
            this.err("A \u201cscript\u201d element with a \u201ctype\u201d attribute whose value is \u201cspeculationrules\u201d must contain a JSON object.");
            return false;
        }
        JsonObject speculationRulesObject = (JsonObject)speculationRules;
        if (!speculationRulesObject.containsKey("prefetch") && !speculationRulesObject.containsKey("prerender")) {
            this.err("A \u201cscript\u201d element with a \u201ctype\u201d attribute whose value is \u201cspeculationrules\u201d must contain a JSON object with at least one of the properties \u201cprefetch\u201d or \u201cprerender\u201d.");
            return false;
        }
        for (String key : speculationRulesObject.keySet()) {
            if ("prefetch".equals(key) || "prerender".equals(key)) continue;
            this.err("A \u201cscript\u201d element with a \u201ctype\u201d attribute whose value is \u201cspeculationrules\u201d must contain a JSON object with only \u201cprefetch\u201d and/or \u201cprerender\u201d as properties.");
            return false;
        }
        if (speculationRulesObject.containsKey("prefetch") && !this.isSpeculationRuleArrayValid("prefetch", (JsonValue)speculationRulesObject.get("prefetch"))) {
            return false;
        }
        return !speculationRulesObject.containsKey("prerender") || this.isSpeculationRuleArrayValid("prerender", (JsonValue)speculationRulesObject.get("prerender"));
    }

    private boolean isSpeculationRuleArrayValid(String ruleType, JsonValue ruleValue) throws SAXException {
        if (!(ruleValue instanceof JsonArray)) {
            this.err("The \u201c" + ruleType + "\u201d property within the content of a \u201cscript\u201d element with a \u201ctype\u201d attribute whose value is \u201cspeculationrules\u201d must be a JSON array.");
            return false;
        }
        JsonArray rulesArray = (JsonArray)ruleValue;
        for (JsonValue rule : rulesArray) {
            if (this.isSpeculationRuleObjectValid(ruleType, rule)) continue;
            return false;
        }
        return true;
    }

    private boolean isSpeculationRuleObjectValid(String ruleType, JsonValue ruleValue) throws SAXException {
        if (!(ruleValue instanceof JsonObject)) {
            this.err("Each item in the \u201c" + ruleType + "\u201d array within the content of a \u201cscript\u201d element with a \u201ctype\u201d attribute whose value is \u201cspeculationrules\u201d must be a JSON object.");
            return false;
        }
        JsonObject ruleObject = (JsonObject)ruleValue;
        String source = null;
        if (ruleObject.containsKey("source")) {
            JsonValue sourceValue = (JsonValue)ruleObject.get("source");
            if (!(sourceValue instanceof JsonString)) {
                this.err("The \u201csource\u201d property in a speculation rule must be a string.");
                return false;
            }
            source = ((JsonString)sourceValue).getString();
            if (!"list".equals(source) && !"document".equals(source)) {
                this.err("The \u201csource\u201d property in a speculation rule must be either \u201clist\u201d or \u201cdocument\u201d.");
                return false;
            }
        } else if (ruleObject.containsKey("urls")) {
            source = "list";
        } else if (ruleObject.containsKey("where")) {
            source = "document";
        } else {
            this.err("A speculation rule must have a \u201csource\u201d property, or a \u201curls\u201d property (for list rules), or a \u201cwhere\u201d property (for document rules).");
            return false;
        }
        for (String key : ruleObject.keySet()) {
            if ("source".equals(key) || "urls".equals(key) || "where".equals(key) || "eagerness".equals(key)) continue;
            this.err("Each rule in the \u201c" + ruleType + "\u201d array must only contain the properties \u201csource\u201d, \u201curls\u201d, \u201cwhere\u201d, and \u201ceagerness\u201d.");
            return false;
        }
        if ("list".equals(source)) {
            if (!ruleObject.containsKey("urls")) {
                this.err("A speculation rule with \u201csource\u201d set to \u201clist\u201d must have a \u201curls\u201d property.");
                return false;
            }
            if (ruleObject.containsKey("where")) {
                this.err("A speculation rule with \u201csource\u201d set to \u201clist\u201d must not have a \u201cwhere\u201d property.");
                return false;
            }
            if (!this.isUrlsArrayValid((JsonValue)ruleObject.get("urls"))) {
                return false;
            }
        } else if ("document".equals(source)) {
            if (!ruleObject.containsKey("where")) {
                this.err("A speculation rule with \u201csource\u201d set to \u201cdocument\u201d must have a \u201cwhere\u201d property.");
                return false;
            }
            if (ruleObject.containsKey("urls")) {
                this.err("A speculation rule with \u201csource\u201d set to \u201cdocument\u201d must not have a \u201curls\u201d property.");
                return false;
            }
            if (!this.isDocumentRuleValid((JsonValue)ruleObject.get("where"))) {
                return false;
            }
        }
        if (ruleObject.containsKey("eagerness")) {
            JsonValue eagernessValue = (JsonValue)ruleObject.get("eagerness");
            if (!(eagernessValue instanceof JsonString)) {
                this.err("The \u201ceagerness\u201d property in a speculation rule must be a string.");
                return false;
            }
            String eagerness = ((JsonString)eagernessValue).getString();
            if (!("eager".equals(eagerness) || "moderate".equals(eagerness) || "conservative".equals(eagerness))) {
                this.err("The \u201ceagerness\u201d property in a speculation rule must be one of \u201ceager\u201d, \u201cmoderate\u201d, or \u201cconservative\u201d.");
                return false;
            }
        }
        return true;
    }

    private boolean isUrlsArrayValid(JsonValue urlsValue) throws SAXException {
        if (!(urlsValue instanceof JsonArray)) {
            this.err("The \u201curls\u201d property in a speculation rule must be a JSON array.");
            return false;
        }
        JsonArray urlsArray = (JsonArray)urlsValue;
        if (urlsArray.isEmpty()) {
            this.err("The \u201curls\u201d property in a speculation rule must contain at least one URL.");
            return false;
        }
        for (JsonValue urlValue : urlsArray) {
            if (!(urlValue instanceof JsonString)) {
                this.err("Each item in the \u201curls\u201d array must be a string.");
                return false;
            }
            String url = ((JsonString)urlValue).getString();
            if (!url.isEmpty()) continue;
            this.err("Each URL in the \u201curls\u201d array must be a non-empty string.");
            return false;
        }
        return true;
    }

    private boolean isDocumentRuleValid(JsonValue whereValue) throws SAXException {
        if (!(whereValue instanceof JsonObject)) {
            this.err("The \u201cwhere\u201d property in a speculation rule must be a JSON object.");
            return false;
        }
        JsonObject whereObject = (JsonObject)whereValue;
        int predicateCount = 0;
        if (whereObject.containsKey("and")) {
            ++predicateCount;
        }
        if (whereObject.containsKey("or")) {
            ++predicateCount;
        }
        if (whereObject.containsKey("not")) {
            ++predicateCount;
        }
        if (whereObject.containsKey("href_matches")) {
            ++predicateCount;
        }
        if (whereObject.containsKey("selector_matches")) {
            ++predicateCount;
        }
        if (predicateCount == 0) {
            this.err("A document rule predicate must have one of the properties \u201cand\u201d, \u201cor\u201d, \u201cnot\u201d, \u201chref_matches\u201d, or \u201cselector_matches\u201d.");
            return false;
        }
        if (predicateCount > 1) {
            this.err("A document rule predicate must have only one of the properties \u201cand\u201d, \u201cor\u201d, \u201cnot\u201d, \u201chref_matches\u201d, or \u201cselector_matches\u201d.");
            return false;
        }
        for (String key : whereObject.keySet()) {
            if ("and".equals(key) || "or".equals(key) || "not".equals(key) || "href_matches".equals(key) || "selector_matches".equals(key)) continue;
            this.err("A document rule predicate must only contain one of the properties \u201cand\u201d, \u201cor\u201d, \u201cnot\u201d, \u201chref_matches\u201d, or \u201cselector_matches\u201d.");
            return false;
        }
        if (whereObject.containsKey("and")) {
            return this.isAndOrRuleValid("and", (JsonValue)whereObject.get("and"));
        }
        if (whereObject.containsKey("or")) {
            return this.isAndOrRuleValid("or", (JsonValue)whereObject.get("or"));
        }
        if (whereObject.containsKey("not")) {
            return this.isNotRuleValid((JsonValue)whereObject.get("not"));
        }
        if (whereObject.containsKey("href_matches")) {
            return this.isHrefMatchesRuleValid((JsonValue)whereObject.get("href_matches"));
        }
        if (whereObject.containsKey("selector_matches")) {
            return this.isSelectorMatchesRuleValid((JsonValue)whereObject.get("selector_matches"));
        }
        return true;
    }

    private boolean isAndOrRuleValid(String ruleType, JsonValue ruleValue) throws SAXException {
        if (!(ruleValue instanceof JsonArray)) {
            this.err("The \u201c" + ruleType + "\u201d property in a document rule must be a JSON array.");
            return false;
        }
        JsonArray rulesArray = (JsonArray)ruleValue;
        if (rulesArray.isEmpty()) {
            this.err("The \u201c" + ruleType + "\u201d property in a document rule must contain at least one item.");
            return false;
        }
        for (JsonValue rule : rulesArray) {
            if (this.isDocumentRuleValid(rule)) continue;
            return false;
        }
        return true;
    }

    private boolean isNotRuleValid(JsonValue ruleValue) throws SAXException {
        return this.isDocumentRuleValid(ruleValue);
    }

    private boolean isHrefMatchesRuleValid(JsonValue ruleValue) throws SAXException {
        if (ruleValue instanceof JsonString) {
            String pattern = ((JsonString)ruleValue).getString();
            if (pattern.isEmpty()) {
                this.err("The \u201chref_matches\u201d property in a document rule must be a non-empty string.");
                return false;
            }
            return true;
        }
        if (ruleValue instanceof JsonArray) {
            JsonArray patternsArray = (JsonArray)ruleValue;
            if (patternsArray.isEmpty()) {
                this.err("The \u201chref_matches\u201d property in a document rule must contain at least one pattern.");
                return false;
            }
            for (JsonValue patternValue : patternsArray) {
                if (!(patternValue instanceof JsonString)) {
                    this.err("Each item in the \u201chref_matches\u201d array must be a string.");
                    return false;
                }
                String pattern = ((JsonString)patternValue).getString();
                if (!pattern.isEmpty()) continue;
                this.err("Each item in the \u201chref_matches\u201d array must be a non-empty string.");
                return false;
            }
            return true;
        }
        this.err("The \u201chref_matches\u201d property in a document rule must be a string or an array of strings.");
        return false;
    }

    private boolean isSelectorMatchesRuleValid(JsonValue ruleValue) throws SAXException {
        if (ruleValue instanceof JsonString) {
            String selector = ((JsonString)ruleValue).getString();
            if (selector.isEmpty()) {
                this.err("The \u201cselector_matches\u201d property in a document rule must be a non-empty string.");
                return false;
            }
            return true;
        }
        if (ruleValue instanceof JsonArray) {
            JsonArray selectorsArray = (JsonArray)ruleValue;
            if (selectorsArray.isEmpty()) {
                this.err("The \u201cselector_matches\u201d property in a document rule must contain at least one selector.");
                return false;
            }
            for (JsonValue selectorValue : selectorsArray) {
                if (!(selectorValue instanceof JsonString)) {
                    this.err("Each item in the \u201cselector_matches\u201d array must be a string.");
                    return false;
                }
                String selector = ((JsonString)selectorValue).getString();
                if (!selector.isEmpty()) continue;
                this.err("Each item in the \u201cselector_matches\u201d array must be a non-empty string.");
                return false;
            }
            return true;
        }
        this.err("The \u201cselector_matches\u201d property in a document rule must be a string or an array of strings.");
        return false;
    }
}

