/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.opentelemetry.metric;

import com.google.api.MonitoredResource;
import com.google.cloud.opentelemetry.metric.MonitoredResourceDescription;
import com.google.cloud.opentelemetry.resource.GcpResource;
import com.google.common.base.Strings;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.sdk.resources.Resource;
import java.util.Set;
import java.util.logging.Logger;

public class ResourceTranslator {
    private static final String CUSTOM_MR_KEY = "gcp.resource_type";
    private static final Logger LOGGER = Logger.getLogger(ResourceTranslator.class.getCanonicalName());

    private ResourceTranslator() {
    }

    @Deprecated
    public static MonitoredResource mapResource(Resource resource) {
        GcpResource gcpResource = com.google.cloud.opentelemetry.resource.ResourceTranslator.mapResource((Resource)resource);
        MonitoredResource.Builder mr = MonitoredResource.newBuilder();
        mr.setType(gcpResource.getResourceType());
        gcpResource.getResourceLabels().getLabels().forEach((arg_0, arg_1) -> ((MonitoredResource.Builder)mr).putLabels(arg_0, arg_1));
        return mr.build();
    }

    static MonitoredResource mapResource(Resource resource, MonitoredResourceDescription mrDescription) {
        String mrTypeToMap = (String)resource.getAttributes().get(AttributeKey.stringKey((String)CUSTOM_MR_KEY));
        if (Strings.isNullOrEmpty((String)mrTypeToMap)) {
            return ResourceTranslator.mapResourceUsingCustomerMappings(resource);
        }
        if (!mrTypeToMap.equals(mrDescription.getMonitoredResourceType())) {
            LOGGER.warning(String.format("MonitoredResource type mismatch: Description provided for %s, but found %s in resource attributes. Defaulting to standard mappings.", mrDescription.getMonitoredResourceType(), mrTypeToMap));
            return ResourceTranslator.mapResourceUsingCustomerMappings(resource);
        }
        return ResourceTranslator.mapResourceUsingPlatformMappings(resource, mrTypeToMap, mrDescription);
    }

    private static MonitoredResource mapResourceUsingPlatformMappings(Resource resource, String mrTypeToMap, MonitoredResourceDescription monitoredResourceDescription) {
        Set<String> expectedMRLabels = monitoredResourceDescription.getMonitoredResourceLabels();
        MonitoredResource.Builder mr = MonitoredResource.newBuilder();
        mr.setType(mrTypeToMap);
        expectedMRLabels.forEach(expectedLabel -> {
            String foundValue = (String)resource.getAttribute(AttributeKey.stringKey((String)expectedLabel));
            if (foundValue != null) {
                mr.putLabels(expectedLabel, foundValue);
            }
        });
        return mr.build();
    }

    private static MonitoredResource mapResourceUsingCustomerMappings(Resource resource) {
        GcpResource gcpResource = com.google.cloud.opentelemetry.resource.ResourceTranslator.mapResource((Resource)resource);
        MonitoredResource.Builder mr = MonitoredResource.newBuilder();
        mr.setType(gcpResource.getResourceType());
        gcpResource.getResourceLabels().getLabels().forEach((arg_0, arg_1) -> ((MonitoredResource.Builder)mr).putLabels(arg_0, arg_1));
        return mr.build();
    }
}

