/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_Profile;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.image.EPSImage;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.TIFFImage;
import org.apache.fop.pdf.BitmapImage;
import org.apache.fop.pdf.CCFFilter;
import org.apache.fop.pdf.DCTFilter;
import org.apache.fop.pdf.PDFColor;
import org.apache.fop.pdf.PDFConformanceException;
import org.apache.fop.pdf.PDFDeviceColorSpace;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFFilter;
import org.apache.fop.pdf.PDFICCBasedColorSpace;
import org.apache.fop.pdf.PDFICCStream;
import org.apache.fop.pdf.PDFImage;
import org.apache.fop.pdf.PDFXObject;
import org.apache.fop.util.ColorProfileUtil;

public class FopPDFImage
implements PDFImage {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$fop$render$pdf$FopPDFImage == null ? (class$org$apache$fop$render$pdf$FopPDFImage = FopPDFImage.class$("org.apache.fop.render.pdf.FopPDFImage")) : class$org$apache$fop$render$pdf$FopPDFImage));
    private FopImage fopImage;
    private PDFICCStream pdfICCStream = null;
    private PDFFilter pdfFilter = null;
    private String maskRef;
    private String softMaskRef;
    private boolean isPS = false;
    private boolean isCCF = false;
    private boolean isDCT = false;
    private String key;
    static /* synthetic */ Class class$org$apache$fop$render$pdf$FopPDFImage;

    public FopPDFImage(FopImage image, String key) {
        this.fopImage = image;
        this.key = key;
        this.isPS = this.fopImage instanceof EPSImage;
    }

    public String getKey() {
        return this.key;
    }

    public void setup(PDFDocument doc) {
        int comp;
        TIFFImage tiffImage;
        if ("image/jpeg".equals(this.fopImage.getMimeType())) {
            this.pdfFilter = new DCTFilter();
            this.pdfFilter.setApplied(true);
            this.isDCT = true;
        } else if ("image/tiff".equals(this.fopImage.getMimeType()) && this.fopImage instanceof TIFFImage && (tiffImage = (TIFFImage)this.fopImage).getStripCount() == 1 && (comp = tiffImage.getCompression()) != 1) {
            if (comp == 3) {
                this.pdfFilter = new CCFFilter();
                this.pdfFilter.setApplied(true);
                this.isCCF = true;
            } else if (comp == 4) {
                this.pdfFilter = new CCFFilter();
                this.pdfFilter.setApplied(true);
                ((CCFFilter)this.pdfFilter).setDecodeParms("<< /K -1 /Columns " + tiffImage.getWidth() + " >>");
                this.isCCF = true;
            } else if (comp == 6) {
                this.pdfFilter = new DCTFilter();
                this.pdfFilter.setApplied(true);
                this.isDCT = true;
            }
        }
        if (this.isPS || this.isDCT || this.isCCF) {
            this.fopImage.load(2);
        } else {
            this.fopImage.load(4);
        }
        ICC_Profile prof = this.fopImage.getICCProfile();
        PDFDeviceColorSpace pdfCS = FopPDFImage.toPDFColorSpace(this.fopImage.getColorSpace());
        if (prof != null) {
            boolean defaultsRGB = ColorProfileUtil.isDefaultsRGB(prof);
            String desc = ColorProfileUtil.getICCProfileDescription(prof);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Image returns ICC profile: " + desc + ", default sRGB=" + defaultsRGB));
            }
            PDFICCBasedColorSpace cs = doc.getResources().getICCColorSpaceByProfileName(desc);
            if (!defaultsRGB) {
                if (cs == null) {
                    this.pdfICCStream = doc.getFactory().makePDFICCStream();
                    this.pdfICCStream.setColorSpace(prof, pdfCS);
                    cs = doc.getFactory().makeICCBasedColorSpace(null, null, this.pdfICCStream);
                } else {
                    this.pdfICCStream = cs.getICCStream();
                }
            } else {
                if (cs == null && "sRGB".equals(desc)) {
                    cs = doc.getResources().getColorSpace("DefaultRGB");
                }
                this.pdfICCStream = cs.getICCStream();
            }
        }
        if (this.fopImage.hasSoftMask()) {
            doc.getProfile().verifyTransparencyAllowed(this.fopImage.getOriginalURI());
            byte[] softMask = this.fopImage.getSoftMask();
            if (softMask == null) {
                return;
            }
            BitmapImage fopimg = new BitmapImage("Mask:" + this.key, this.fopImage.getWidth(), this.fopImage.getHeight(), softMask, null);
            fopimg.setColorSpace(new PDFDeviceColorSpace(1));
            PDFXObject xobj = doc.addImage(null, fopimg);
            this.softMaskRef = xobj.referencePDF();
        }
        if (doc.getProfile().getPDFAMode().isPDFA1LevelB() && pdfCS != null && pdfCS.getColorSpace() != 2 && pdfCS.getColorSpace() != 1 && prof == null) {
            throw new PDFConformanceException("PDF/A-1 does not allow mixing DeviceRGB and DeviceCMYK: " + this.fopImage.getOriginalURI());
        }
    }

    public int getWidth() {
        return this.fopImage.getWidth();
    }

    public int getHeight() {
        return this.fopImage.getHeight();
    }

    public PDFDeviceColorSpace getColorSpace() {
        if (this.isCCF || this.isDCT || this.isPS) {
            return FopPDFImage.toPDFColorSpace(this.fopImage.getColorSpace());
        }
        return FopPDFImage.toPDFColorSpace(ColorSpace.getInstance(1000));
    }

    public int getBitsPerPixel() {
        if (this.isCCF) {
            return this.fopImage.getBitsPerPixel();
        }
        return 8;
    }

    public boolean isTransparent() {
        return this.fopImage.isTransparent();
    }

    public PDFColor getTransparentColor() {
        return new PDFColor(this.fopImage.getTransparentColor().getRed(), this.fopImage.getTransparentColor().getGreen(), this.fopImage.getTransparentColor().getBlue());
    }

    public String getMask() {
        return this.maskRef;
    }

    public String getSoftMask() {
        return this.softMaskRef;
    }

    public boolean isInverted() {
        return this.fopImage.isInverted();
    }

    public boolean isPS() {
        return this.isPS;
    }

    public PDFFilter getPDFFilter() {
        return this.pdfFilter;
    }

    public void outputContents(OutputStream out) throws IOException {
        if (this.isPS) {
            this.outputPostScriptContents(out);
        } else if (this.fopImage.getBitmapsSize() > 0) {
            out.write(this.fopImage.getBitmaps());
        } else {
            out.write(this.fopImage.getRessourceBytes());
        }
    }

    protected void outputPostScriptContents(OutputStream out) throws IOException {
        EPSImage epsImage = (EPSImage)this.fopImage;
        int[] bbox = epsImage.getBBox();
        int bboxw = bbox[2] - bbox[0];
        int bboxh = bbox[3] - bbox[1];
        StringBuffer preamble = new StringBuffer();
        preamble.append("%%BeginDocument: " + epsImage.getDocName() + "\n");
        preamble.append("userdict begin                 % Push userdict on dict stack\n");
        preamble.append("/PreEPS_state save def\n");
        preamble.append("/dict_stack countdictstack def\n");
        preamble.append("/ops_count count 1 sub def\n");
        preamble.append("/showpage {} def\n");
        preamble.append(1.0 / (double)bboxw + " " + 1.0 / (double)bboxh + " scale\n");
        preamble.append(-bbox[0] + " " + -bbox[1] + " translate\n");
        preamble.append(bbox[0] + " " + bbox[1] + " " + bboxw + " " + bboxh + " rectclip\n");
        preamble.append("newpath\n");
        StringBuffer post = new StringBuffer();
        post.append("%%EndDocument\n");
        post.append("count ops_count sub {pop} repeat\n");
        post.append("countdictstack dict_stack sub {end} repeat\n");
        post.append("PreEPS_state restore\n");
        post.append("end % userdict\n");
        out.write(PDFDocument.encode(preamble.toString()));
        out.write(((EPSImage)this.fopImage).getEPSImage());
        out.write(PDFDocument.encode(post.toString()));
    }

    public PDFICCStream getICCStream() {
        return this.pdfICCStream;
    }

    public static PDFDeviceColorSpace toPDFColorSpace(ColorSpace cs) {
        if (cs == null) {
            return null;
        }
        PDFDeviceColorSpace pdfCS = new PDFDeviceColorSpace(0);
        switch (cs.getType()) {
            case 9: {
                pdfCS.setColorSpace(3);
                break;
            }
            case 5: {
                pdfCS.setColorSpace(2);
                break;
            }
            case 6: {
                pdfCS.setColorSpace(1);
            }
        }
        return pdfCS;
    }

    public String getFilterHint() {
        if (this.isPS) {
            return "content";
        }
        if (this.isDCT) {
            return "jpeg";
        }
        if (this.isCCF) {
            return "tiff";
        }
        return "image";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

