# aws-lc-fips-sys

[![crates.io](https://img.shields.io/crates/v/aws-lc-fips-sys.svg)](https://crates.io/crates/aws-lc-fips-sys)
[![GitHub](https://img.shields.io/badge/GitHub-awslabs%2Faws--lc--rs-blue)](https://github.com/awslabs/aws-lc-rs)

**Autogenerated** low-level AWS-LC FIPS bindings for the Rust programming language. We do not recommend directly relying
on these bindings.

[Documentation](https://github.com/aws/aws-lc).

## FIPS

The aws-lc-fips-sys crate provides bindings to the latest version of the AWS-LC-FIPS module that
has completed FIPS validation testing by an accredited lab and has been submitted to NIST for
certification. This will continue to be the case as we periodically submit new versions of
the AWS-LC-FIPS module to NIST for certification. Currently, aws-lc-fips-sys binds to
[AWS-LC-FIPS 3.0.x](https://github.com/aws/aws-lc/tree/fips-2024-09-27).

Consult with your local FIPS compliance team to determine the version of AWS-LC-FIPS module that you require. Consumers
needing to remain on a previous version of the AWS-LC-FIPS module should pin to specific versions of aws-lc-rs to avoid
automatically being upgraded to a newer module version.
(See [cargo’s documentation](https://doc.rust-lang.org/cargo/reference/specifying-dependencies.html)
on how to specify dependency versions.)

| AWS-LC-FIPS module | aws-lc-rs |
|--------------------|-----------|
| 2.0.x              | \<1.12.0  |
| 3.0.x              | *latest*  |

Refer to the
[NIST Cryptographic Module Validation Program's Modules In Progress List](https://csrc.nist.gov/Projects/cryptographic-module-validation-program/modules-in-process/Modules-In-Process-List)
for the latest status of the static or dynamic AWS-LC Cryptographic Module. Please see the
[FIPS.md in the aws-lc repository](https://github.com/aws/aws-lc/blob/main/crypto/fipsmodule/FIPS.md)
for relevant security policies and information on supported operating environments.
We will also update our release notes and documentation to reflect any changes in FIPS certification status.

## Building and Bindings

This crate contains source code from a FIPS branch of AWS-LC for building and for bindings generation. A
specialized FIPS build is performed. Bindings for some platforms are pre-generated.

### Pregenerated Bindings Availability

| Targets                    |
|----------------------------|
| aarch64_apple_darwin       |
| aarch64_unknown_linux_gnu  |
| aarch64_unknown_linux_musl |
| x86_64_apple_darwin        |
| x86_64_unknown_linux_gnu   |
| x86_64_unknown_linux_musl  |

### Prebuilt NASM objects

Prebuilt NASM objects are *not* available for this crate.

### Tested AWS-LC FIPS Build Environments

`aws-lc-fips-sys` currently relies on the AWS-LC FIPS static build, please see our CI documentation
at [AWS-LC](https://github.com/aws/aws-lc/tree/main/tests/ci#unit-tests).

## Build Prerequisites

Since this crate builds AWS-LC as a native library, all build tools needed to build AWS-LC are applicable to
`aws-lc-fips-sys` as well. This includes Go and Perl, which are hard dependencies for the AWS-LC FIPS build.

[Building AWS-LC](https://github.com/aws/aws-lc/blob/main/BUILDING.md)

If you use a different build combination for FIPS and would like us to support it, please open an issue to us
at [AWS-LC](https://github.com/aws/aws-lc/issues/new?assignees=&labels=&template=build-issue.md&title=).

## Security Notification Process

If you discover a potential security issue in *AWS-LC* or *aws-lc-fips-sys*, we ask that you notify AWS
Security via our
[vulnerability reporting page](https://aws.amazon.com/security/vulnerability-reporting/).
Please do **not** create a public GitHub issue.

If you package or distribute *aws-lc-fips-sys*, or use *aws-lc-fips-sys* as part of a large multi-user service,
you may be eligible for pre-notification of future *aws-lc-fips-sys* releases.
Please contact aws-lc-pre-notifications@amazon.com.

## Contribution

See contributing file at [AWS-LC](https://github.com/aws/aws-lc/blob/main/CONTRIBUTING.md)

## Licensing

See license at [AWS-LC](https://github.com/aws/aws-lc/blob/main/LICENSE)
