/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.turboproject;

import java.util.Date;
import net.sf.mpxj.common.DateHelper;

final class PEPUtility {
    private static final long EPOCH = 946598400000L;

    PEPUtility() {
    }

    public static final int getInt(byte[] byArray, int n) {
        int n2 = 0;
        int n3 = n;
        for (int i = 0; i < 32; i += 8) {
            n2 |= (byArray[n3] & 0xFF) << i;
            ++n3;
        }
        return n2;
    }

    public static final int getShort(byte[] byArray, int n) {
        int n2 = 0;
        int n3 = n;
        for (int i = 0; i < 16; i += 8) {
            n2 |= (byArray[n3] & 0xFF) << i;
            ++n3;
        }
        return n2;
    }

    public static final String getString(byte[] byArray, int n) {
        return PEPUtility.getString(byArray, n, byArray.length - n);
    }

    public static final String getString(byte[] byArray, int n, int n2) {
        char c;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n2 && (c = (char)byArray[n + i]) != '\u0000'; ++i) {
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static final Date getStartDate(byte[] byArray, int n) {
        long l = PEPUtility.getShort(byArray, n);
        Date date = l == 32768L ? null : DateHelper.getDateFromLong(946598400000L + l * 86400000L);
        return date;
    }

    public static final Date getFinishDate(byte[] byArray, int n) {
        long l = PEPUtility.getShort(byArray, n);
        Date date = l == 32768L ? null : DateHelper.getDateFromLong(946598400000L + (l - 1L) * 86400000L);
        return date;
    }
}

