/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * abs(dvec2(-1.5lf, -0.75lf)) => dvec2(1.5lf, 0.75lf)
 * abs(dvec2(0.0lf, 0.75lf)) => dvec2(0.0lf, 0.75lf)
 * abs(dvec2(1.5lf, -1.5lf)) => dvec2(1.5lf, 1.5lf)
 */
#version 400

void main()
{
  double[distance(abs(dvec2(-1.5lf, -0.75lf)), dvec2(1.5lf, 0.75lf)) <= 1.6770509831248427e-05lf ? 1 : -1] array0;
  double[distance(abs(dvec2(0.0lf, 0.75lf)), dvec2(0.0lf, 0.75lf)) <= 7.500000000000001e-06lf ? 1 : -1] array1;
  double[distance(abs(dvec2(1.5lf, -1.5lf)), dvec2(1.5lf, 1.5lf)) <= 2.1213203435596428e-05lf ? 1 : -1] array2;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length());
}
