/**
 * vis-network
 * https://visjs.github.io/vis-network/
 *
 * A dynamic, browser-based visualization library.
 *
 * @version 9.1.11
 * @date    2025-06-08T10:30:35.172Z
 *
 * @copyright (c) 2011-2017 Almende B.V, http://almende.com
 * @copyright (c) 2017-2019 visjs contributors, https://github.com/visjs
 *
 * @license
 * vis.js is dual licensed under both
 *
 *   1. The Apache 2.0 License
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *   and
 *
 *   2. The MIT License
 *      http://opensource.org/licenses/MIT
 *
 * vis.js may be distributed under either license.
 */

import { isDataViewLike, DataSet } from 'vis-data/peer/esm/vis-data.js';

var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

function getDefaultExportFromCjs (x) {
	return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
}

var check = function (it) {
  return it && it.Math === Math && it;
};

// https://github.com/zloirock/core-js/issues/86#issuecomment-115759028
var global$n =
  // eslint-disable-next-line es/no-global-this -- safe
  check(typeof globalThis == 'object' && globalThis) ||
  check(typeof window == 'object' && window) ||
  // eslint-disable-next-line no-restricted-globals -- safe
  check(typeof self == 'object' && self) ||
  check(typeof commonjsGlobal == 'object' && commonjsGlobal) ||
  // eslint-disable-next-line no-new-func -- fallback
  (function () { return this; })() || commonjsGlobal || Function('return this')();

var fails$u = function (exec) {
  try {
    return !!exec();
  } catch (error) {
    return true;
  }
};

var fails$t = fails$u;

var functionBindNative = !fails$t(function () {
  // eslint-disable-next-line es/no-function-prototype-bind -- safe
  var test = (function () { /* empty */ }).bind();
  // eslint-disable-next-line no-prototype-builtins -- safe
  return typeof test != 'function' || test.hasOwnProperty('prototype');
});

var NATIVE_BIND$4 = functionBindNative;

var FunctionPrototype$4 = Function.prototype;
var apply$4 = FunctionPrototype$4.apply;
var call$d = FunctionPrototype$4.call;

// eslint-disable-next-line es/no-reflect -- safe
var functionApply = typeof Reflect == 'object' && Reflect.apply || (NATIVE_BIND$4 ? call$d.bind(apply$4) : function () {
  return call$d.apply(apply$4, arguments);
});

var NATIVE_BIND$3 = functionBindNative;

var FunctionPrototype$3 = Function.prototype;
var call$c = FunctionPrototype$3.call;
var uncurryThisWithBind = NATIVE_BIND$3 && FunctionPrototype$3.bind.bind(call$c, call$c);

var functionUncurryThis = NATIVE_BIND$3 ? uncurryThisWithBind : function (fn) {
  return function () {
    return call$c.apply(fn, arguments);
  };
};

var uncurryThis$w = functionUncurryThis;

var toString$c = uncurryThis$w({}.toString);
var stringSlice$1 = uncurryThis$w(''.slice);

var classofRaw$2 = function (it) {
  return stringSlice$1(toString$c(it), 8, -1);
};

var classofRaw$1 = classofRaw$2;
var uncurryThis$v = functionUncurryThis;

var functionUncurryThisClause = function (fn) {
  // Nashorn bug:
  //   https://github.com/zloirock/core-js/issues/1128
  //   https://github.com/zloirock/core-js/issues/1130
  if (classofRaw$1(fn) === 'Function') return uncurryThis$v(fn);
};

var documentAll$2 = typeof document == 'object' && document.all;

// https://tc39.es/ecma262/#sec-IsHTMLDDA-internal-slot
// eslint-disable-next-line unicorn/no-typeof-undefined -- required for testing
var IS_HTMLDDA = typeof documentAll$2 == 'undefined' && documentAll$2 !== undefined;

var documentAll_1 = {
  all: documentAll$2,
  IS_HTMLDDA: IS_HTMLDDA
};

var $documentAll$1 = documentAll_1;

var documentAll$1 = $documentAll$1.all;

// `IsCallable` abstract operation
// https://tc39.es/ecma262/#sec-iscallable
var isCallable$h = $documentAll$1.IS_HTMLDDA ? function (argument) {
  return typeof argument == 'function' || argument === documentAll$1;
} : function (argument) {
  return typeof argument == 'function';
};

var objectGetOwnPropertyDescriptor = {};

var fails$s = fails$u;

// Detect IE8's incomplete defineProperty implementation
var descriptors = !fails$s(function () {
  // eslint-disable-next-line es/no-object-defineproperty -- required for testing
  return Object.defineProperty({}, 1, { get: function () { return 7; } })[1] !== 7;
});

var NATIVE_BIND$2 = functionBindNative;

var call$b = Function.prototype.call;

var functionCall = NATIVE_BIND$2 ? call$b.bind(call$b) : function () {
  return call$b.apply(call$b, arguments);
};

var objectPropertyIsEnumerable = {};

var $propertyIsEnumerable$1 = {}.propertyIsEnumerable;
// eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
var getOwnPropertyDescriptor$6 = Object.getOwnPropertyDescriptor;

// Nashorn ~ JDK8 bug
var NASHORN_BUG = getOwnPropertyDescriptor$6 && !$propertyIsEnumerable$1.call({ 1: 2 }, 1);

// `Object.prototype.propertyIsEnumerable` method implementation
// https://tc39.es/ecma262/#sec-object.prototype.propertyisenumerable
objectPropertyIsEnumerable.f = NASHORN_BUG ? function propertyIsEnumerable(V) {
  var descriptor = getOwnPropertyDescriptor$6(this, V);
  return !!descriptor && descriptor.enumerable;
} : $propertyIsEnumerable$1;

var createPropertyDescriptor$5 = function (bitmap, value) {
  return {
    enumerable: !(bitmap & 1),
    configurable: !(bitmap & 2),
    writable: !(bitmap & 4),
    value: value
  };
};

var uncurryThis$u = functionUncurryThis;
var fails$r = fails$u;
var classof$e = classofRaw$2;

var $Object$5 = Object;
var split = uncurryThis$u(''.split);

// fallback for non-array-like ES3 and non-enumerable old V8 strings
var indexedObject = fails$r(function () {
  // throws an error in rhino, see https://github.com/mozilla/rhino/issues/346
  // eslint-disable-next-line no-prototype-builtins -- safe
  return !$Object$5('z').propertyIsEnumerable(0);
}) ? function (it) {
  return classof$e(it) === 'String' ? split(it, '') : $Object$5(it);
} : $Object$5;

// we can't use just `it == null` since of `document.all` special case
// https://tc39.es/ecma262/#sec-IsHTMLDDA-internal-slot-aec
var isNullOrUndefined$6 = function (it) {
  return it === null || it === undefined;
};

var isNullOrUndefined$5 = isNullOrUndefined$6;

var $TypeError$e = TypeError;

// `RequireObjectCoercible` abstract operation
// https://tc39.es/ecma262/#sec-requireobjectcoercible
var requireObjectCoercible$5 = function (it) {
  if (isNullOrUndefined$5(it)) throw new $TypeError$e("Can't call method on " + it);
  return it;
};

// toObject with fallback for non-array-like ES3 strings
var IndexedObject$3 = indexedObject;
var requireObjectCoercible$4 = requireObjectCoercible$5;

var toIndexedObject$a = function (it) {
  return IndexedObject$3(requireObjectCoercible$4(it));
};

var isCallable$g = isCallable$h;
var $documentAll = documentAll_1;

var documentAll = $documentAll.all;

var isObject$h = $documentAll.IS_HTMLDDA ? function (it) {
  return typeof it == 'object' ? it !== null : isCallable$g(it) || it === documentAll;
} : function (it) {
  return typeof it == 'object' ? it !== null : isCallable$g(it);
};

var path$s = {};

var path$r = path$s;
var global$m = global$n;
var isCallable$f = isCallable$h;

var aFunction = function (variable) {
  return isCallable$f(variable) ? variable : undefined;
};

var getBuiltIn$b = function (namespace, method) {
  return arguments.length < 2 ? aFunction(path$r[namespace]) || aFunction(global$m[namespace])
    : path$r[namespace] && path$r[namespace][method] || global$m[namespace] && global$m[namespace][method];
};

var uncurryThis$t = functionUncurryThis;

var objectIsPrototypeOf = uncurryThis$t({}.isPrototypeOf);

var engineUserAgent = typeof navigator != 'undefined' && String(navigator.userAgent) || '';

var global$l = global$n;
var userAgent$2 = engineUserAgent;

var process = global$l.process;
var Deno = global$l.Deno;
var versions = process && process.versions || Deno && Deno.version;
var v8 = versions && versions.v8;
var match, version;

if (v8) {
  match = v8.split('.');
  // in old Chrome, versions of V8 isn't V8 = Chrome / 10
  // but their correct versions are not interesting for us
  version = match[0] > 0 && match[0] < 4 ? 1 : +(match[0] + match[1]);
}

// BrowserFS NodeJS `process` polyfill incorrectly set `.v8` to `0.0`
// so check `userAgent` even if `.v8` exists, but 0
if (!version && userAgent$2) {
  match = userAgent$2.match(/Edge\/(\d+)/);
  if (!match || match[1] >= 74) {
    match = userAgent$2.match(/Chrome\/(\d+)/);
    if (match) version = +match[1];
  }
}

var engineV8Version = version;

/* eslint-disable es/no-symbol -- required for testing */
var V8_VERSION$2 = engineV8Version;
var fails$q = fails$u;
var global$k = global$n;

var $String$4 = global$k.String;

// eslint-disable-next-line es/no-object-getownpropertysymbols -- required for testing
var symbolConstructorDetection = !!Object.getOwnPropertySymbols && !fails$q(function () {
  var symbol = Symbol('symbol detection');
  // Chrome 38 Symbol has incorrect toString conversion
  // `get-own-property-symbols` polyfill symbols converted to object are not Symbol instances
  // nb: Do not call `String` directly to avoid this being optimized out to `symbol+''` which will,
  // of course, fail.
  return !$String$4(symbol) || !(Object(symbol) instanceof Symbol) ||
    // Chrome 38-40 symbols are not inherited from DOM collections prototypes to instances
    !Symbol.sham && V8_VERSION$2 && V8_VERSION$2 < 41;
});

/* eslint-disable es/no-symbol -- required for testing */
var NATIVE_SYMBOL$5 = symbolConstructorDetection;

var useSymbolAsUid = NATIVE_SYMBOL$5
  && !Symbol.sham
  && typeof Symbol.iterator == 'symbol';

var getBuiltIn$a = getBuiltIn$b;
var isCallable$e = isCallable$h;
var isPrototypeOf$j = objectIsPrototypeOf;
var USE_SYMBOL_AS_UID$1 = useSymbolAsUid;

var $Object$4 = Object;

var isSymbol$5 = USE_SYMBOL_AS_UID$1 ? function (it) {
  return typeof it == 'symbol';
} : function (it) {
  var $Symbol = getBuiltIn$a('Symbol');
  return isCallable$e($Symbol) && isPrototypeOf$j($Symbol.prototype, $Object$4(it));
};

var $String$3 = String;

var tryToString$5 = function (argument) {
  try {
    return $String$3(argument);
  } catch (error) {
    return 'Object';
  }
};

var isCallable$d = isCallable$h;
var tryToString$4 = tryToString$5;

var $TypeError$d = TypeError;

// `Assert: IsCallable(argument) is true`
var aCallable$6 = function (argument) {
  if (isCallable$d(argument)) return argument;
  throw new $TypeError$d(tryToString$4(argument) + ' is not a function');
};

var aCallable$5 = aCallable$6;
var isNullOrUndefined$4 = isNullOrUndefined$6;

// `GetMethod` abstract operation
// https://tc39.es/ecma262/#sec-getmethod
var getMethod$3 = function (V, P) {
  var func = V[P];
  return isNullOrUndefined$4(func) ? undefined : aCallable$5(func);
};

var call$a = functionCall;
var isCallable$c = isCallable$h;
var isObject$g = isObject$h;

var $TypeError$c = TypeError;

// `OrdinaryToPrimitive` abstract operation
// https://tc39.es/ecma262/#sec-ordinarytoprimitive
var ordinaryToPrimitive$1 = function (input, pref) {
  var fn, val;
  if (pref === 'string' && isCallable$c(fn = input.toString) && !isObject$g(val = call$a(fn, input))) return val;
  if (isCallable$c(fn = input.valueOf) && !isObject$g(val = call$a(fn, input))) return val;
  if (pref !== 'string' && isCallable$c(fn = input.toString) && !isObject$g(val = call$a(fn, input))) return val;
  throw new $TypeError$c("Can't convert object to primitive value");
};

var shared$7 = {exports: {}};

var global$j = global$n;

// eslint-disable-next-line es/no-object-defineproperty -- safe
var defineProperty$f = Object.defineProperty;

var defineGlobalProperty$1 = function (key, value) {
  try {
    defineProperty$f(global$j, key, { value: value, configurable: true, writable: true });
  } catch (error) {
    global$j[key] = value;
  } return value;
};

var global$i = global$n;
var defineGlobalProperty = defineGlobalProperty$1;

var SHARED = '__core-js_shared__';
var store$3 = global$i[SHARED] || defineGlobalProperty(SHARED, {});

var sharedStore = store$3;

var store$2 = sharedStore;

(shared$7.exports = function (key, value) {
  return store$2[key] || (store$2[key] = value !== undefined ? value : {});
})('versions', []).push({
  version: '3.33.0',
  mode: 'pure' ,
  copyright: '© 2014-2023 Denis Pushkarev (zloirock.ru)',
  license: 'https://github.com/zloirock/core-js/blob/v3.33.0/LICENSE',
  source: 'https://github.com/zloirock/core-js'
});

var sharedExports = shared$7.exports;

var requireObjectCoercible$3 = requireObjectCoercible$5;

var $Object$3 = Object;

// `ToObject` abstract operation
// https://tc39.es/ecma262/#sec-toobject
var toObject$c = function (argument) {
  return $Object$3(requireObjectCoercible$3(argument));
};

var uncurryThis$s = functionUncurryThis;
var toObject$b = toObject$c;

var hasOwnProperty = uncurryThis$s({}.hasOwnProperty);

// `HasOwnProperty` abstract operation
// https://tc39.es/ecma262/#sec-hasownproperty
// eslint-disable-next-line es/no-object-hasown -- safe
var hasOwnProperty_1 = Object.hasOwn || function hasOwn(it, key) {
  return hasOwnProperty(toObject$b(it), key);
};

var uncurryThis$r = functionUncurryThis;

var id$2 = 0;
var postfix = Math.random();
var toString$b = uncurryThis$r(1.0.toString);

var uid$4 = function (key) {
  return 'Symbol(' + (key === undefined ? '' : key) + ')_' + toString$b(++id$2 + postfix, 36);
};

var global$h = global$n;
var shared$6 = sharedExports;
var hasOwn$g = hasOwnProperty_1;
var uid$3 = uid$4;
var NATIVE_SYMBOL$4 = symbolConstructorDetection;
var USE_SYMBOL_AS_UID = useSymbolAsUid;

var Symbol$5 = global$h.Symbol;
var WellKnownSymbolsStore$2 = shared$6('wks');
var createWellKnownSymbol = USE_SYMBOL_AS_UID ? Symbol$5['for'] || Symbol$5 : Symbol$5 && Symbol$5.withoutSetter || uid$3;

var wellKnownSymbol$l = function (name) {
  if (!hasOwn$g(WellKnownSymbolsStore$2, name)) {
    WellKnownSymbolsStore$2[name] = NATIVE_SYMBOL$4 && hasOwn$g(Symbol$5, name)
      ? Symbol$5[name]
      : createWellKnownSymbol('Symbol.' + name);
  } return WellKnownSymbolsStore$2[name];
};

var call$9 = functionCall;
var isObject$f = isObject$h;
var isSymbol$4 = isSymbol$5;
var getMethod$2 = getMethod$3;
var ordinaryToPrimitive = ordinaryToPrimitive$1;
var wellKnownSymbol$k = wellKnownSymbol$l;

var $TypeError$b = TypeError;
var TO_PRIMITIVE = wellKnownSymbol$k('toPrimitive');

// `ToPrimitive` abstract operation
// https://tc39.es/ecma262/#sec-toprimitive
var toPrimitive$6 = function (input, pref) {
  if (!isObject$f(input) || isSymbol$4(input)) return input;
  var exoticToPrim = getMethod$2(input, TO_PRIMITIVE);
  var result;
  if (exoticToPrim) {
    if (pref === undefined) pref = 'default';
    result = call$9(exoticToPrim, input, pref);
    if (!isObject$f(result) || isSymbol$4(result)) return result;
    throw new $TypeError$b("Can't convert object to primitive value");
  }
  if (pref === undefined) pref = 'number';
  return ordinaryToPrimitive(input, pref);
};

var toPrimitive$5 = toPrimitive$6;
var isSymbol$3 = isSymbol$5;

// `ToPropertyKey` abstract operation
// https://tc39.es/ecma262/#sec-topropertykey
var toPropertyKey$4 = function (argument) {
  var key = toPrimitive$5(argument, 'string');
  return isSymbol$3(key) ? key : key + '';
};

var global$g = global$n;
var isObject$e = isObject$h;

var document$1 = global$g.document;
// typeof document.createElement is 'object' in old IE
var EXISTS$1 = isObject$e(document$1) && isObject$e(document$1.createElement);

var documentCreateElement$1 = function (it) {
  return EXISTS$1 ? document$1.createElement(it) : {};
};

var DESCRIPTORS$h = descriptors;
var fails$p = fails$u;
var createElement = documentCreateElement$1;

// Thanks to IE8 for its funny defineProperty
var ie8DomDefine = !DESCRIPTORS$h && !fails$p(function () {
  // eslint-disable-next-line es/no-object-defineproperty -- required for testing
  return Object.defineProperty(createElement('div'), 'a', {
    get: function () { return 7; }
  }).a !== 7;
});

var DESCRIPTORS$g = descriptors;
var call$8 = functionCall;
var propertyIsEnumerableModule$2 = objectPropertyIsEnumerable;
var createPropertyDescriptor$4 = createPropertyDescriptor$5;
var toIndexedObject$9 = toIndexedObject$a;
var toPropertyKey$3 = toPropertyKey$4;
var hasOwn$f = hasOwnProperty_1;
var IE8_DOM_DEFINE$1 = ie8DomDefine;

// eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
var $getOwnPropertyDescriptor$2 = Object.getOwnPropertyDescriptor;

// `Object.getOwnPropertyDescriptor` method
// https://tc39.es/ecma262/#sec-object.getownpropertydescriptor
objectGetOwnPropertyDescriptor.f = DESCRIPTORS$g ? $getOwnPropertyDescriptor$2 : function getOwnPropertyDescriptor(O, P) {
  O = toIndexedObject$9(O);
  P = toPropertyKey$3(P);
  if (IE8_DOM_DEFINE$1) try {
    return $getOwnPropertyDescriptor$2(O, P);
  } catch (error) { /* empty */ }
  if (hasOwn$f(O, P)) return createPropertyDescriptor$4(!call$8(propertyIsEnumerableModule$2.f, O, P), O[P]);
};

var fails$o = fails$u;
var isCallable$b = isCallable$h;

var replacement = /#|\.prototype\./;

var isForced$1 = function (feature, detection) {
  var value = data[normalize(feature)];
  return value === POLYFILL ? true
    : value === NATIVE ? false
    : isCallable$b(detection) ? fails$o(detection)
    : !!detection;
};

var normalize = isForced$1.normalize = function (string) {
  return String(string).replace(replacement, '.').toLowerCase();
};

var data = isForced$1.data = {};
var NATIVE = isForced$1.NATIVE = 'N';
var POLYFILL = isForced$1.POLYFILL = 'P';

var isForced_1 = isForced$1;

var uncurryThis$q = functionUncurryThisClause;
var aCallable$4 = aCallable$6;
var NATIVE_BIND$1 = functionBindNative;

var bind$9 = uncurryThis$q(uncurryThis$q.bind);

// optional / simple context binding
var functionBindContext = function (fn, that) {
  aCallable$4(fn);
  return that === undefined ? fn : NATIVE_BIND$1 ? bind$9(fn, that) : function (/* ...args */) {
    return fn.apply(that, arguments);
  };
};

var objectDefineProperty = {};

var DESCRIPTORS$f = descriptors;
var fails$n = fails$u;

// V8 ~ Chrome 36-
// https://bugs.chromium.org/p/v8/issues/detail?id=3334
var v8PrototypeDefineBug = DESCRIPTORS$f && fails$n(function () {
  // eslint-disable-next-line es/no-object-defineproperty -- required for testing
  return Object.defineProperty(function () { /* empty */ }, 'prototype', {
    value: 42,
    writable: false
  }).prototype !== 42;
});

var isObject$d = isObject$h;

var $String$2 = String;
var $TypeError$a = TypeError;

// `Assert: Type(argument) is Object`
var anObject$9 = function (argument) {
  if (isObject$d(argument)) return argument;
  throw new $TypeError$a($String$2(argument) + ' is not an object');
};

var DESCRIPTORS$e = descriptors;
var IE8_DOM_DEFINE = ie8DomDefine;
var V8_PROTOTYPE_DEFINE_BUG$1 = v8PrototypeDefineBug;
var anObject$8 = anObject$9;
var toPropertyKey$2 = toPropertyKey$4;

var $TypeError$9 = TypeError;
// eslint-disable-next-line es/no-object-defineproperty -- safe
var $defineProperty$1 = Object.defineProperty;
// eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
var $getOwnPropertyDescriptor$1 = Object.getOwnPropertyDescriptor;
var ENUMERABLE = 'enumerable';
var CONFIGURABLE$1 = 'configurable';
var WRITABLE = 'writable';

// `Object.defineProperty` method
// https://tc39.es/ecma262/#sec-object.defineproperty
objectDefineProperty.f = DESCRIPTORS$e ? V8_PROTOTYPE_DEFINE_BUG$1 ? function defineProperty(O, P, Attributes) {
  anObject$8(O);
  P = toPropertyKey$2(P);
  anObject$8(Attributes);
  if (typeof O === 'function' && P === 'prototype' && 'value' in Attributes && WRITABLE in Attributes && !Attributes[WRITABLE]) {
    var current = $getOwnPropertyDescriptor$1(O, P);
    if (current && current[WRITABLE]) {
      O[P] = Attributes.value;
      Attributes = {
        configurable: CONFIGURABLE$1 in Attributes ? Attributes[CONFIGURABLE$1] : current[CONFIGURABLE$1],
        enumerable: ENUMERABLE in Attributes ? Attributes[ENUMERABLE] : current[ENUMERABLE],
        writable: false
      };
    }
  } return $defineProperty$1(O, P, Attributes);
} : $defineProperty$1 : function defineProperty(O, P, Attributes) {
  anObject$8(O);
  P = toPropertyKey$2(P);
  anObject$8(Attributes);
  if (IE8_DOM_DEFINE) try {
    return $defineProperty$1(O, P, Attributes);
  } catch (error) { /* empty */ }
  if ('get' in Attributes || 'set' in Attributes) throw new $TypeError$9('Accessors not supported');
  if ('value' in Attributes) O[P] = Attributes.value;
  return O;
};

var DESCRIPTORS$d = descriptors;
var definePropertyModule$3 = objectDefineProperty;
var createPropertyDescriptor$3 = createPropertyDescriptor$5;

var createNonEnumerableProperty$6 = DESCRIPTORS$d ? function (object, key, value) {
  return definePropertyModule$3.f(object, key, createPropertyDescriptor$3(1, value));
} : function (object, key, value) {
  object[key] = value;
  return object;
};

var global$f = global$n;
var apply$3 = functionApply;
var uncurryThis$p = functionUncurryThisClause;
var isCallable$a = isCallable$h;
var getOwnPropertyDescriptor$5 = objectGetOwnPropertyDescriptor.f;
var isForced = isForced_1;
var path$q = path$s;
var bind$8 = functionBindContext;
var createNonEnumerableProperty$5 = createNonEnumerableProperty$6;
var hasOwn$e = hasOwnProperty_1;

var wrapConstructor = function (NativeConstructor) {
  var Wrapper = function (a, b, c) {
    if (this instanceof Wrapper) {
      switch (arguments.length) {
        case 0: return new NativeConstructor();
        case 1: return new NativeConstructor(a);
        case 2: return new NativeConstructor(a, b);
      } return new NativeConstructor(a, b, c);
    } return apply$3(NativeConstructor, this, arguments);
  };
  Wrapper.prototype = NativeConstructor.prototype;
  return Wrapper;
};

/*
  options.target         - name of the target object
  options.global         - target is the global object
  options.stat           - export as static methods of target
  options.proto          - export as prototype methods of target
  options.real           - real prototype method for the `pure` version
  options.forced         - export even if the native feature is available
  options.bind           - bind methods to the target, required for the `pure` version
  options.wrap           - wrap constructors to preventing global pollution, required for the `pure` version
  options.unsafe         - use the simple assignment of property instead of delete + defineProperty
  options.sham           - add a flag to not completely full polyfills
  options.enumerable     - export as enumerable property
  options.dontCallGetSet - prevent calling a getter on target
  options.name           - the .name of the function if it does not match the key
*/
var _export = function (options, source) {
  var TARGET = options.target;
  var GLOBAL = options.global;
  var STATIC = options.stat;
  var PROTO = options.proto;

  var nativeSource = GLOBAL ? global$f : STATIC ? global$f[TARGET] : (global$f[TARGET] || {}).prototype;

  var target = GLOBAL ? path$q : path$q[TARGET] || createNonEnumerableProperty$5(path$q, TARGET, {})[TARGET];
  var targetPrototype = target.prototype;

  var FORCED, USE_NATIVE, VIRTUAL_PROTOTYPE;
  var key, sourceProperty, targetProperty, nativeProperty, resultProperty, descriptor;

  for (key in source) {
    FORCED = isForced(GLOBAL ? key : TARGET + (STATIC ? '.' : '#') + key, options.forced);
    // contains in native
    USE_NATIVE = !FORCED && nativeSource && hasOwn$e(nativeSource, key);

    targetProperty = target[key];

    if (USE_NATIVE) if (options.dontCallGetSet) {
      descriptor = getOwnPropertyDescriptor$5(nativeSource, key);
      nativeProperty = descriptor && descriptor.value;
    } else nativeProperty = nativeSource[key];

    // export native or implementation
    sourceProperty = (USE_NATIVE && nativeProperty) ? nativeProperty : source[key];

    if (USE_NATIVE && typeof targetProperty == typeof sourceProperty) continue;

    // bind methods to global for calling from export context
    if (options.bind && USE_NATIVE) resultProperty = bind$8(sourceProperty, global$f);
    // wrap global constructors for prevent changes in this version
    else if (options.wrap && USE_NATIVE) resultProperty = wrapConstructor(sourceProperty);
    // make static versions for prototype methods
    else if (PROTO && isCallable$a(sourceProperty)) resultProperty = uncurryThis$p(sourceProperty);
    // default case
    else resultProperty = sourceProperty;

    // add a flag to not completely full polyfills
    if (options.sham || (sourceProperty && sourceProperty.sham) || (targetProperty && targetProperty.sham)) {
      createNonEnumerableProperty$5(resultProperty, 'sham', true);
    }

    createNonEnumerableProperty$5(target, key, resultProperty);

    if (PROTO) {
      VIRTUAL_PROTOTYPE = TARGET + 'Prototype';
      if (!hasOwn$e(path$q, VIRTUAL_PROTOTYPE)) {
        createNonEnumerableProperty$5(path$q, VIRTUAL_PROTOTYPE, {});
      }
      // export virtual prototype methods
      createNonEnumerableProperty$5(path$q[VIRTUAL_PROTOTYPE], key, sourceProperty);
      // export real prototype methods
      if (options.real && targetPrototype && (FORCED || !targetPrototype[key])) {
        createNonEnumerableProperty$5(targetPrototype, key, sourceProperty);
      }
    }
  }
};

var ceil = Math.ceil;
var floor$1 = Math.floor;

// `Math.trunc` method
// https://tc39.es/ecma262/#sec-math.trunc
// eslint-disable-next-line es/no-math-trunc -- safe
var mathTrunc = Math.trunc || function trunc(x) {
  var n = +x;
  return (n > 0 ? floor$1 : ceil)(n);
};

var trunc = mathTrunc;

// `ToIntegerOrInfinity` abstract operation
// https://tc39.es/ecma262/#sec-tointegerorinfinity
var toIntegerOrInfinity$4 = function (argument) {
  var number = +argument;
  // eslint-disable-next-line no-self-compare -- NaN check
  return number !== number || number === 0 ? 0 : trunc(number);
};

var toIntegerOrInfinity$3 = toIntegerOrInfinity$4;

var max$3 = Math.max;
var min$2 = Math.min;

// Helper for a popular repeating case of the spec:
// Let integer be ? ToInteger(index).
// If integer < 0, let result be max((length + integer), 0); else let result be min(integer, length).
var toAbsoluteIndex$5 = function (index, length) {
  var integer = toIntegerOrInfinity$3(index);
  return integer < 0 ? max$3(integer + length, 0) : min$2(integer, length);
};

var toIntegerOrInfinity$2 = toIntegerOrInfinity$4;

var min$1 = Math.min;

// `ToLength` abstract operation
// https://tc39.es/ecma262/#sec-tolength
var toLength$1 = function (argument) {
  return argument > 0 ? min$1(toIntegerOrInfinity$2(argument), 0x1FFFFFFFFFFFFF) : 0; // 2 ** 53 - 1 == 9007199254740991
};

var toLength = toLength$1;

// `LengthOfArrayLike` abstract operation
// https://tc39.es/ecma262/#sec-lengthofarraylike
var lengthOfArrayLike$a = function (obj) {
  return toLength(obj.length);
};

var toIndexedObject$8 = toIndexedObject$a;
var toAbsoluteIndex$4 = toAbsoluteIndex$5;
var lengthOfArrayLike$9 = lengthOfArrayLike$a;

// `Array.prototype.{ indexOf, includes }` methods implementation
var createMethod$4 = function (IS_INCLUDES) {
  return function ($this, el, fromIndex) {
    var O = toIndexedObject$8($this);
    var length = lengthOfArrayLike$9(O);
    var index = toAbsoluteIndex$4(fromIndex, length);
    var value;
    // Array#includes uses SameValueZero equality algorithm
    // eslint-disable-next-line no-self-compare -- NaN check
    if (IS_INCLUDES && el !== el) while (length > index) {
      value = O[index++];
      // eslint-disable-next-line no-self-compare -- NaN check
      if (value !== value) return true;
    // Array#indexOf ignores holes, Array#includes - not
    } else for (;length > index; index++) {
      if ((IS_INCLUDES || index in O) && O[index] === el) return IS_INCLUDES || index || 0;
    } return !IS_INCLUDES && -1;
  };
};

var arrayIncludes = {
  // `Array.prototype.includes` method
  // https://tc39.es/ecma262/#sec-array.prototype.includes
  includes: createMethod$4(true),
  // `Array.prototype.indexOf` method
  // https://tc39.es/ecma262/#sec-array.prototype.indexof
  indexOf: createMethod$4(false)
};

var hiddenKeys$6 = {};

var uncurryThis$o = functionUncurryThis;
var hasOwn$d = hasOwnProperty_1;
var toIndexedObject$7 = toIndexedObject$a;
var indexOf$4 = arrayIncludes.indexOf;
var hiddenKeys$5 = hiddenKeys$6;

var push$4 = uncurryThis$o([].push);

var objectKeysInternal = function (object, names) {
  var O = toIndexedObject$7(object);
  var i = 0;
  var result = [];
  var key;
  for (key in O) !hasOwn$d(hiddenKeys$5, key) && hasOwn$d(O, key) && push$4(result, key);
  // Don't enum bug & hidden keys
  while (names.length > i) if (hasOwn$d(O, key = names[i++])) {
    ~indexOf$4(result, key) || push$4(result, key);
  }
  return result;
};

// IE8- don't enum bug keys
var enumBugKeys$3 = [
  'constructor',
  'hasOwnProperty',
  'isPrototypeOf',
  'propertyIsEnumerable',
  'toLocaleString',
  'toString',
  'valueOf'
];

var internalObjectKeys$1 = objectKeysInternal;
var enumBugKeys$2 = enumBugKeys$3;

// `Object.keys` method
// https://tc39.es/ecma262/#sec-object.keys
// eslint-disable-next-line es/no-object-keys -- safe
var objectKeys$3 = Object.keys || function keys(O) {
  return internalObjectKeys$1(O, enumBugKeys$2);
};

var objectGetOwnPropertySymbols = {};

// eslint-disable-next-line es/no-object-getownpropertysymbols -- safe
objectGetOwnPropertySymbols.f = Object.getOwnPropertySymbols;

var DESCRIPTORS$c = descriptors;
var uncurryThis$n = functionUncurryThis;
var call$7 = functionCall;
var fails$m = fails$u;
var objectKeys$2 = objectKeys$3;
var getOwnPropertySymbolsModule$3 = objectGetOwnPropertySymbols;
var propertyIsEnumerableModule$1 = objectPropertyIsEnumerable;
var toObject$a = toObject$c;
var IndexedObject$2 = indexedObject;

// eslint-disable-next-line es/no-object-assign -- safe
var $assign = Object.assign;
// eslint-disable-next-line es/no-object-defineproperty -- required for testing
var defineProperty$e = Object.defineProperty;
var concat$6 = uncurryThis$n([].concat);

// `Object.assign` method
// https://tc39.es/ecma262/#sec-object.assign
var objectAssign = !$assign || fails$m(function () {
  // should have correct order of operations (Edge bug)
  if (DESCRIPTORS$c && $assign({ b: 1 }, $assign(defineProperty$e({}, 'a', {
    enumerable: true,
    get: function () {
      defineProperty$e(this, 'b', {
        value: 3,
        enumerable: false
      });
    }
  }), { b: 2 })).b !== 1) return true;
  // should work with symbols and should have deterministic property order (V8 bug)
  var A = {};
  var B = {};
  // eslint-disable-next-line es/no-symbol -- safe
  var symbol = Symbol('assign detection');
  var alphabet = 'abcdefghijklmnopqrst';
  A[symbol] = 7;
  alphabet.split('').forEach(function (chr) { B[chr] = chr; });
  return $assign({}, A)[symbol] !== 7 || objectKeys$2($assign({}, B)).join('') !== alphabet;
}) ? function assign(target, source) { // eslint-disable-line no-unused-vars -- required for `.length`
  var T = toObject$a(target);
  var argumentsLength = arguments.length;
  var index = 1;
  var getOwnPropertySymbols = getOwnPropertySymbolsModule$3.f;
  var propertyIsEnumerable = propertyIsEnumerableModule$1.f;
  while (argumentsLength > index) {
    var S = IndexedObject$2(arguments[index++]);
    var keys = getOwnPropertySymbols ? concat$6(objectKeys$2(S), getOwnPropertySymbols(S)) : objectKeys$2(S);
    var length = keys.length;
    var j = 0;
    var key;
    while (length > j) {
      key = keys[j++];
      if (!DESCRIPTORS$c || call$7(propertyIsEnumerable, S, key)) T[key] = S[key];
    }
  } return T;
} : $assign;

var $$J = _export;
var assign$5 = objectAssign;

// `Object.assign` method
// https://tc39.es/ecma262/#sec-object.assign
// eslint-disable-next-line es/no-object-assign -- required for testing
$$J({ target: 'Object', stat: true, arity: 2, forced: Object.assign !== assign$5 }, {
  assign: assign$5
});

var path$p = path$s;

var assign$4 = path$p.Object.assign;

var parent$L = assign$4;

var assign$3 = parent$L;

var assign$2 = assign$3;

var _Object$assign = /*@__PURE__*/getDefaultExportFromCjs(assign$2);

var uncurryThis$m = functionUncurryThis;

var arraySlice$5 = uncurryThis$m([].slice);

var uncurryThis$l = functionUncurryThis;
var aCallable$3 = aCallable$6;
var isObject$c = isObject$h;
var hasOwn$c = hasOwnProperty_1;
var arraySlice$4 = arraySlice$5;
var NATIVE_BIND = functionBindNative;

var $Function = Function;
var concat$5 = uncurryThis$l([].concat);
var join = uncurryThis$l([].join);
var factories = {};

var construct$1 = function (C, argsLength, args) {
  if (!hasOwn$c(factories, argsLength)) {
    var list = [];
    var i = 0;
    for (; i < argsLength; i++) list[i] = 'a[' + i + ']';
    factories[argsLength] = $Function('C,a', 'return new C(' + join(list, ',') + ')');
  } return factories[argsLength](C, args);
};

// `Function.prototype.bind` method implementation
// https://tc39.es/ecma262/#sec-function.prototype.bind
// eslint-disable-next-line es/no-function-prototype-bind -- detection
var functionBind = NATIVE_BIND ? $Function.bind : function bind(that /* , ...args */) {
  var F = aCallable$3(this);
  var Prototype = F.prototype;
  var partArgs = arraySlice$4(arguments, 1);
  var boundFunction = function bound(/* args... */) {
    var args = concat$5(partArgs, arraySlice$4(arguments));
    return this instanceof boundFunction ? construct$1(F, args.length, args) : F.apply(that, args);
  };
  if (isObject$c(Prototype)) boundFunction.prototype = Prototype;
  return boundFunction;
};

// TODO: Remove from `core-js@4`
var $$I = _export;
var bind$7 = functionBind;

// `Function.prototype.bind` method
// https://tc39.es/ecma262/#sec-function.prototype.bind
// eslint-disable-next-line es/no-function-prototype-bind -- detection
$$I({ target: 'Function', proto: true, forced: Function.bind !== bind$7 }, {
  bind: bind$7
});

var path$o = path$s;

var entryVirtual$h = function (CONSTRUCTOR) {
  return path$o[CONSTRUCTOR + 'Prototype'];
};

var entryVirtual$g = entryVirtual$h;

var bind$6 = entryVirtual$g('Function').bind;

var isPrototypeOf$i = objectIsPrototypeOf;
var method$e = bind$6;

var FunctionPrototype$2 = Function.prototype;

var bind$5 = function (it) {
  var own = it.bind;
  return it === FunctionPrototype$2 || (isPrototypeOf$i(FunctionPrototype$2, it) && own === FunctionPrototype$2.bind) ? method$e : own;
};

var parent$K = bind$5;

var bind$4 = parent$K;

var bind$3 = bind$4;

var _bindInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(bind$3);

/**
 * Draw a circle.
 * @param ctx - The context this shape will be rendered to.
 * @param x - The position of the center on the x axis.
 * @param y - The position of the center on the y axis.
 * @param r - The radius of the circle.
 */
function drawCircle(ctx, x, y, r) {
  ctx.beginPath();
  ctx.arc(x, y, r, 0, 2 * Math.PI, false);
  ctx.closePath();
}
/**
 * Draw a square.
 * @param ctx - The context this shape will be rendered to.
 * @param x - The position of the center on the x axis.
 * @param y - The position of the center on the y axis.
 * @param r - Half of the width and height of the square.
 */
function drawSquare(ctx, x, y, r) {
  ctx.beginPath();
  ctx.rect(x - r, y - r, r * 2, r * 2);
  ctx.closePath();
}
/**
 * Draw an equilateral triangle standing on a side.
 * @param ctx - The context this shape will be rendered to.
 * @param x - The position of the center on the x axis.
 * @param y - The position of the center on the y axis.
 * @param r - Half of the length of the sides.
 * @remarks
 * http://en.wikipedia.org/wiki/Equilateral_triangle
 */
function drawTriangle(ctx, x, y, r) {
  ctx.beginPath();
  // the change in radius and the offset is here to center the shape
  r *= 1.15;
  y += 0.275 * r;
  const s = r * 2;
  const s2 = s / 2;
  const ir = Math.sqrt(3) / 6 * s; // radius of inner circle
  const h = Math.sqrt(s * s - s2 * s2); // height
  ctx.moveTo(x, y - (h - ir));
  ctx.lineTo(x + s2, y + ir);
  ctx.lineTo(x - s2, y + ir);
  ctx.lineTo(x, y - (h - ir));
  ctx.closePath();
}
/**
 * Draw an equilateral triangle standing on a vertex.
 * @param ctx - The context this shape will be rendered to.
 * @param x - The position of the center on the x axis.
 * @param y - The position of the center on the y axis.
 * @param r - Half of the length of the sides.
 * @remarks
 * http://en.wikipedia.org/wiki/Equilateral_triangle
 */
function drawTriangleDown(ctx, x, y, r) {
  ctx.beginPath();
  // the change in radius and the offset is here to center the shape
  r *= 1.15;
  y -= 0.275 * r;
  const s = r * 2;
  const s2 = s / 2;
  const ir = Math.sqrt(3) / 6 * s; // radius of inner circle
  const h = Math.sqrt(s * s - s2 * s2); // height
  ctx.moveTo(x, y + (h - ir));
  ctx.lineTo(x + s2, y - ir);
  ctx.lineTo(x - s2, y - ir);
  ctx.lineTo(x, y + (h - ir));
  ctx.closePath();
}
/**
 * Draw a star.
 * @param ctx - The context this shape will be rendered to.
 * @param x - The position of the center on the x axis.
 * @param y - The position of the center on the y axis.
 * @param r - The outer radius of the star.
 */
function drawStar(ctx, x, y, r) {
  // http://www.html5canvastutorials.com/labs/html5-canvas-star-spinner/
  ctx.beginPath();
  // the change in radius and the offset is here to center the shape
  r *= 0.82;
  y += 0.1 * r;
  for (let n = 0; n < 10; n++) {
    const radius = n % 2 === 0 ? r * 1.3 : r * 0.5;
    ctx.lineTo(x + radius * Math.sin(n * 2 * Math.PI / 10), y - radius * Math.cos(n * 2 * Math.PI / 10));
  }
  ctx.closePath();
}
/**
 * Draw a diamond.
 * @param ctx - The context this shape will be rendered to.
 * @param x - The position of the center on the x axis.
 * @param y - The position of the center on the y axis.
 * @param r - Half of the width and height of the diamond.
 * @remarks
 * http://www.html5canvastutorials.com/labs/html5-canvas-star-spinner/
 */
function drawDiamond(ctx, x, y, r) {
  ctx.beginPath();
  ctx.lineTo(x, y + r);
  ctx.lineTo(x + r, y);
  ctx.lineTo(x, y - r);
  ctx.lineTo(x - r, y);
  ctx.closePath();
}
/**
 * Draw a rectangle with rounded corners.
 * @param ctx - The context this shape will be rendered to.
 * @param x - The position of the center on the x axis.
 * @param y - The position of the center on the y axis.
 * @param w - The width of the rectangle.
 * @param h - The height of the rectangle.
 * @param r - The radius of the corners.
 * @remarks
 * http://stackoverflow.com/questions/1255512/how-to-draw-a-rounded-rectangle-on-html-canvas
 */
function drawRoundRect(ctx, x, y, w, h, r) {
  const r2d = Math.PI / 180;
  if (w - 2 * r < 0) {
    r = w / 2;
  } //ensure that the radius isn't too large for x
  if (h - 2 * r < 0) {
    r = h / 2;
  } //ensure that the radius isn't too large for y
  ctx.beginPath();
  ctx.moveTo(x + r, y);
  ctx.lineTo(x + w - r, y);
  ctx.arc(x + w - r, y + r, r, r2d * 270, r2d * 360, false);
  ctx.lineTo(x + w, y + h - r);
  ctx.arc(x + w - r, y + h - r, r, 0, r2d * 90, false);
  ctx.lineTo(x + r, y + h);
  ctx.arc(x + r, y + h - r, r, r2d * 90, r2d * 180, false);
  ctx.lineTo(x, y + r);
  ctx.arc(x + r, y + r, r, r2d * 180, r2d * 270, false);
  ctx.closePath();
}
/**
 * Draw an ellipse.
 * @param ctx - The context this shape will be rendered to.
 * @param x - The position of the center on the x axis.
 * @param y - The position of the center on the y axis.
 * @param w - The width of the ellipse.
 * @param h - The height of the ellipse.
 * @remarks
 * http://stackoverflow.com/questions/2172798/how-to-draw-an-oval-in-html5-canvas
 *
 * Postfix '_vis' added to discern it from standard method ellipse().
 */
function drawEllipse(ctx, x, y, w, h) {
  const kappa = 0.5522848,
    ox = w / 2 * kappa,
    // control point offset horizontal
    oy = h / 2 * kappa,
    // control point offset vertical
    xe = x + w,
    // x-end
    ye = y + h,
    // y-end
    xm = x + w / 2,
    // x-middle
    ym = y + h / 2; // y-middle
  ctx.beginPath();
  ctx.moveTo(x, ym);
  ctx.bezierCurveTo(x, ym - oy, xm - ox, y, xm, y);
  ctx.bezierCurveTo(xm + ox, y, xe, ym - oy, xe, ym);
  ctx.bezierCurveTo(xe, ym + oy, xm + ox, ye, xm, ye);
  ctx.bezierCurveTo(xm - ox, ye, x, ym + oy, x, ym);
  ctx.closePath();
}
/**
 * Draw an isometric cylinder.
 * @param ctx - The context this shape will be rendered to.
 * @param x - The position of the center on the x axis.
 * @param y - The position of the center on the y axis.
 * @param w - The width of the database.
 * @param h - The height of the database.
 * @remarks
 * http://stackoverflow.com/questions/2172798/how-to-draw-an-oval-in-html5-canvas
 */
function drawDatabase(ctx, x, y, w, h) {
  const f = 1 / 3;
  const wEllipse = w;
  const hEllipse = h * f;
  const kappa = 0.5522848,
    ox = wEllipse / 2 * kappa,
    // control point offset horizontal
    oy = hEllipse / 2 * kappa,
    // control point offset vertical
    xe = x + wEllipse,
    // x-end
    ye = y + hEllipse,
    // y-end
    xm = x + wEllipse / 2,
    // x-middle
    ym = y + hEllipse / 2,
    // y-middle
    ymb = y + (h - hEllipse / 2),
    // y-midlle, bottom ellipse
    yeb = y + h; // y-end, bottom ellipse
  ctx.beginPath();
  ctx.moveTo(xe, ym);
  ctx.bezierCurveTo(xe, ym + oy, xm + ox, ye, xm, ye);
  ctx.bezierCurveTo(xm - ox, ye, x, ym + oy, x, ym);
  ctx.bezierCurveTo(x, ym - oy, xm - ox, y, xm, y);
  ctx.bezierCurveTo(xm + ox, y, xe, ym - oy, xe, ym);
  ctx.lineTo(xe, ymb);
  ctx.bezierCurveTo(xe, ymb + oy, xm + ox, yeb, xm, yeb);
  ctx.bezierCurveTo(xm - ox, yeb, x, ymb + oy, x, ymb);
  ctx.lineTo(x, ym);
}
/**
 * Draw a dashed line.
 * @param ctx - The context this shape will be rendered to.
 * @param x - The start position on the x axis.
 * @param y - The start position on the y axis.
 * @param x2 - The end position on the x axis.
 * @param y2 - The end position on the y axis.
 * @param pattern - List of lengths starting with line and then alternating between space and line.
 * @author David Jordan
 * @remarks
 * date 2012-08-08
 * http://stackoverflow.com/questions/4576724/dotted-stroke-in-canvas
 */
function drawDashedLine(ctx, x, y, x2, y2, pattern) {
  ctx.beginPath();
  ctx.moveTo(x, y);
  const patternLength = pattern.length;
  const dx = x2 - x;
  const dy = y2 - y;
  const slope = dy / dx;
  let distRemaining = Math.sqrt(dx * dx + dy * dy);
  let patternIndex = 0;
  let draw = true;
  let xStep = 0;
  let dashLength = +pattern[0];
  while (distRemaining >= 0.1) {
    dashLength = +pattern[patternIndex++ % patternLength];
    if (dashLength > distRemaining) {
      dashLength = distRemaining;
    }
    xStep = Math.sqrt(dashLength * dashLength / (1 + slope * slope));
    xStep = dx < 0 ? -xStep : xStep;
    x += xStep;
    y += slope * xStep;
    if (draw === true) {
      ctx.lineTo(x, y);
    } else {
      ctx.moveTo(x, y);
    }
    distRemaining -= dashLength;
    draw = !draw;
  }
}
/**
 * Draw a hexagon.
 * @param ctx - The context this shape will be rendered to.
 * @param x - The position of the center on the x axis.
 * @param y - The position of the center on the y axis.
 * @param r - The radius of the hexagon.
 */
function drawHexagon(ctx, x, y, r) {
  ctx.beginPath();
  const sides = 6;
  const a = Math.PI * 2 / sides;
  ctx.moveTo(x + r, y);
  for (let i = 1; i < sides; i++) {
    ctx.lineTo(x + r * Math.cos(a * i), y + r * Math.sin(a * i));
  }
  ctx.closePath();
}
const shapeMap = {
  circle: drawCircle,
  dashedLine: drawDashedLine,
  database: drawDatabase,
  diamond: drawDiamond,
  ellipse: drawEllipse,
  ellipse_vis: drawEllipse,
  hexagon: drawHexagon,
  roundRect: drawRoundRect,
  square: drawSquare,
  star: drawStar,
  triangle: drawTriangle,
  triangleDown: drawTriangleDown
};
/**
 * Returns either custom or native drawing function base on supplied name.
 * @param name - The name of the function. Either the name of a
 * CanvasRenderingContext2D property or an export from shapes.ts without the
 * draw prefix.
 * @returns The function that can be used for rendering. In case of native
 * CanvasRenderingContext2D function the API is normalized to
 * `(ctx: CanvasRenderingContext2D, ...originalArgs) => void`.
 */
function getShape(name) {
  if (Object.prototype.hasOwnProperty.call(shapeMap, name)) {
    return shapeMap[name];
  } else {
    return function (ctx) {
      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }
      CanvasRenderingContext2D.prototype[name].call(ctx, args);
    };
  }
}

var componentEmitter = {exports: {}};

(function (module) {
	/**
	 * Expose `Emitter`.
	 */

	{
	  module.exports = Emitter;
	}

	/**
	 * Initialize a new `Emitter`.
	 *
	 * @api public
	 */

	function Emitter(obj) {
	  if (obj) return mixin(obj);
	}
	/**
	 * Mixin the emitter properties.
	 *
	 * @param {Object} obj
	 * @return {Object}
	 * @api private
	 */

	function mixin(obj) {
	  for (var key in Emitter.prototype) {
	    obj[key] = Emitter.prototype[key];
	  }
	  return obj;
	}

	/**
	 * Listen on the given `event` with `fn`.
	 *
	 * @param {String} event
	 * @param {Function} fn
	 * @return {Emitter}
	 * @api public
	 */

	Emitter.prototype.on =
	Emitter.prototype.addEventListener = function(event, fn){
	  this._callbacks = this._callbacks || {};
	  (this._callbacks['$' + event] = this._callbacks['$' + event] || [])
	    .push(fn);
	  return this;
	};

	/**
	 * Adds an `event` listener that will be invoked a single
	 * time then automatically removed.
	 *
	 * @param {String} event
	 * @param {Function} fn
	 * @return {Emitter}
	 * @api public
	 */

	Emitter.prototype.once = function(event, fn){
	  function on() {
	    this.off(event, on);
	    fn.apply(this, arguments);
	  }

	  on.fn = fn;
	  this.on(event, on);
	  return this;
	};

	/**
	 * Remove the given callback for `event` or all
	 * registered callbacks.
	 *
	 * @param {String} event
	 * @param {Function} fn
	 * @return {Emitter}
	 * @api public
	 */

	Emitter.prototype.off =
	Emitter.prototype.removeListener =
	Emitter.prototype.removeAllListeners =
	Emitter.prototype.removeEventListener = function(event, fn){
	  this._callbacks = this._callbacks || {};

	  // all
	  if (0 == arguments.length) {
	    this._callbacks = {};
	    return this;
	  }

	  // specific event
	  var callbacks = this._callbacks['$' + event];
	  if (!callbacks) return this;

	  // remove all handlers
	  if (1 == arguments.length) {
	    delete this._callbacks['$' + event];
	    return this;
	  }

	  // remove specific handler
	  var cb;
	  for (var i = 0; i < callbacks.length; i++) {
	    cb = callbacks[i];
	    if (cb === fn || cb.fn === fn) {
	      callbacks.splice(i, 1);
	      break;
	    }
	  }

	  // Remove event specific arrays for event types that no
	  // one is subscribed for to avoid memory leak.
	  if (callbacks.length === 0) {
	    delete this._callbacks['$' + event];
	  }

	  return this;
	};

	/**
	 * Emit `event` with the given args.
	 *
	 * @param {String} event
	 * @param {Mixed} ...
	 * @return {Emitter}
	 */

	Emitter.prototype.emit = function(event){
	  this._callbacks = this._callbacks || {};

	  var args = new Array(arguments.length - 1)
	    , callbacks = this._callbacks['$' + event];

	  for (var i = 1; i < arguments.length; i++) {
	    args[i - 1] = arguments[i];
	  }

	  if (callbacks) {
	    callbacks = callbacks.slice(0);
	    for (var i = 0, len = callbacks.length; i < len; ++i) {
	      callbacks[i].apply(this, args);
	    }
	  }

	  return this;
	};

	/**
	 * Return array of callbacks for `event`.
	 *
	 * @param {String} event
	 * @return {Array}
	 * @api public
	 */

	Emitter.prototype.listeners = function(event){
	  this._callbacks = this._callbacks || {};
	  return this._callbacks['$' + event] || [];
	};

	/**
	 * Check if this emitter has `event` handlers.
	 *
	 * @param {String} event
	 * @return {Boolean}
	 * @api public
	 */

	Emitter.prototype.hasListeners = function(event){
	  return !! this.listeners(event).length;
	}; 
} (componentEmitter));

var componentEmitterExports = componentEmitter.exports;
var Emitter = /*@__PURE__*/getDefaultExportFromCjs(componentEmitterExports);

var classof$d = classofRaw$2;

// `IsArray` abstract operation
// https://tc39.es/ecma262/#sec-isarray
// eslint-disable-next-line es/no-array-isarray -- safe
var isArray$b = Array.isArray || function isArray(argument) {
  return classof$d(argument) === 'Array';
};

var $TypeError$8 = TypeError;
var MAX_SAFE_INTEGER = 0x1FFFFFFFFFFFFF; // 2 ** 53 - 1 == 9007199254740991

var doesNotExceedSafeInteger$2 = function (it) {
  if (it > MAX_SAFE_INTEGER) throw $TypeError$8('Maximum allowed index exceeded');
  return it;
};

var toPropertyKey$1 = toPropertyKey$4;
var definePropertyModule$2 = objectDefineProperty;
var createPropertyDescriptor$2 = createPropertyDescriptor$5;

var createProperty$5 = function (object, key, value) {
  var propertyKey = toPropertyKey$1(key);
  if (propertyKey in object) definePropertyModule$2.f(object, propertyKey, createPropertyDescriptor$2(0, value));
  else object[propertyKey] = value;
};

var wellKnownSymbol$j = wellKnownSymbol$l;

var TO_STRING_TAG$3 = wellKnownSymbol$j('toStringTag');
var test$2 = {};

test$2[TO_STRING_TAG$3] = 'z';

var toStringTagSupport = String(test$2) === '[object z]';

var TO_STRING_TAG_SUPPORT$2 = toStringTagSupport;
var isCallable$9 = isCallable$h;
var classofRaw = classofRaw$2;
var wellKnownSymbol$i = wellKnownSymbol$l;

var TO_STRING_TAG$2 = wellKnownSymbol$i('toStringTag');
var $Object$2 = Object;

// ES3 wrong here
var CORRECT_ARGUMENTS = classofRaw(function () { return arguments; }()) === 'Arguments';

// fallback for IE11 Script Access Denied error
var tryGet = function (it, key) {
  try {
    return it[key];
  } catch (error) { /* empty */ }
};

// getting tag from ES6+ `Object.prototype.toString`
var classof$c = TO_STRING_TAG_SUPPORT$2 ? classofRaw : function (it) {
  var O, tag, result;
  return it === undefined ? 'Undefined' : it === null ? 'Null'
    // @@toStringTag case
    : typeof (tag = tryGet(O = $Object$2(it), TO_STRING_TAG$2)) == 'string' ? tag
    // builtinTag case
    : CORRECT_ARGUMENTS ? classofRaw(O)
    // ES3 arguments fallback
    : (result = classofRaw(O)) === 'Object' && isCallable$9(O.callee) ? 'Arguments' : result;
};

var uncurryThis$k = functionUncurryThis;
var isCallable$8 = isCallable$h;
var store$1 = sharedStore;

var functionToString = uncurryThis$k(Function.toString);

// this helper broken in `core-js@3.4.1-3.4.4`, so we can't use `shared` helper
if (!isCallable$8(store$1.inspectSource)) {
  store$1.inspectSource = function (it) {
    return functionToString(it);
  };
}

var inspectSource$1 = store$1.inspectSource;

var uncurryThis$j = functionUncurryThis;
var fails$l = fails$u;
var isCallable$7 = isCallable$h;
var classof$b = classof$c;
var getBuiltIn$9 = getBuiltIn$b;
var inspectSource = inspectSource$1;

var noop = function () { /* empty */ };
var empty = [];
var construct = getBuiltIn$9('Reflect', 'construct');
var constructorRegExp = /^\s*(?:class|function)\b/;
var exec$2 = uncurryThis$j(constructorRegExp.exec);
var INCORRECT_TO_STRING = !constructorRegExp.test(noop);

var isConstructorModern = function isConstructor(argument) {
  if (!isCallable$7(argument)) return false;
  try {
    construct(noop, empty, argument);
    return true;
  } catch (error) {
    return false;
  }
};

var isConstructorLegacy = function isConstructor(argument) {
  if (!isCallable$7(argument)) return false;
  switch (classof$b(argument)) {
    case 'AsyncFunction':
    case 'GeneratorFunction':
    case 'AsyncGeneratorFunction': return false;
  }
  try {
    // we can't check .prototype since constructors produced by .bind haven't it
    // `Function#toString` throws on some built-it function in some legacy engines
    // (for example, `DOMQuad` and similar in FF41-)
    return INCORRECT_TO_STRING || !!exec$2(constructorRegExp, inspectSource(argument));
  } catch (error) {
    return true;
  }
};

isConstructorLegacy.sham = true;

// `IsConstructor` abstract operation
// https://tc39.es/ecma262/#sec-isconstructor
var isConstructor$2 = !construct || fails$l(function () {
  var called;
  return isConstructorModern(isConstructorModern.call)
    || !isConstructorModern(Object)
    || !isConstructorModern(function () { called = true; })
    || called;
}) ? isConstructorLegacy : isConstructorModern;

var isArray$a = isArray$b;
var isConstructor$1 = isConstructor$2;
var isObject$b = isObject$h;
var wellKnownSymbol$h = wellKnownSymbol$l;

var SPECIES$3 = wellKnownSymbol$h('species');
var $Array$2 = Array;

// a part of `ArraySpeciesCreate` abstract operation
// https://tc39.es/ecma262/#sec-arrayspeciescreate
var arraySpeciesConstructor$1 = function (originalArray) {
  var C;
  if (isArray$a(originalArray)) {
    C = originalArray.constructor;
    // cross-realm fallback
    if (isConstructor$1(C) && (C === $Array$2 || isArray$a(C.prototype))) C = undefined;
    else if (isObject$b(C)) {
      C = C[SPECIES$3];
      if (C === null) C = undefined;
    }
  } return C === undefined ? $Array$2 : C;
};

var arraySpeciesConstructor = arraySpeciesConstructor$1;

// `ArraySpeciesCreate` abstract operation
// https://tc39.es/ecma262/#sec-arrayspeciescreate
var arraySpeciesCreate$3 = function (originalArray, length) {
  return new (arraySpeciesConstructor(originalArray))(length === 0 ? 0 : length);
};

var fails$k = fails$u;
var wellKnownSymbol$g = wellKnownSymbol$l;
var V8_VERSION$1 = engineV8Version;

var SPECIES$2 = wellKnownSymbol$g('species');

var arrayMethodHasSpeciesSupport$5 = function (METHOD_NAME) {
  // We can't use this feature detection in V8 since it causes
  // deoptimization and serious performance degradation
  // https://github.com/zloirock/core-js/issues/677
  return V8_VERSION$1 >= 51 || !fails$k(function () {
    var array = [];
    var constructor = array.constructor = {};
    constructor[SPECIES$2] = function () {
      return { foo: 1 };
    };
    return array[METHOD_NAME](Boolean).foo !== 1;
  });
};

var $$H = _export;
var fails$j = fails$u;
var isArray$9 = isArray$b;
var isObject$a = isObject$h;
var toObject$9 = toObject$c;
var lengthOfArrayLike$8 = lengthOfArrayLike$a;
var doesNotExceedSafeInteger$1 = doesNotExceedSafeInteger$2;
var createProperty$4 = createProperty$5;
var arraySpeciesCreate$2 = arraySpeciesCreate$3;
var arrayMethodHasSpeciesSupport$4 = arrayMethodHasSpeciesSupport$5;
var wellKnownSymbol$f = wellKnownSymbol$l;
var V8_VERSION = engineV8Version;

var IS_CONCAT_SPREADABLE = wellKnownSymbol$f('isConcatSpreadable');

// We can't use this feature detection in V8 since it causes
// deoptimization and serious performance degradation
// https://github.com/zloirock/core-js/issues/679
var IS_CONCAT_SPREADABLE_SUPPORT = V8_VERSION >= 51 || !fails$j(function () {
  var array = [];
  array[IS_CONCAT_SPREADABLE] = false;
  return array.concat()[0] !== array;
});

var isConcatSpreadable = function (O) {
  if (!isObject$a(O)) return false;
  var spreadable = O[IS_CONCAT_SPREADABLE];
  return spreadable !== undefined ? !!spreadable : isArray$9(O);
};

var FORCED$8 = !IS_CONCAT_SPREADABLE_SUPPORT || !arrayMethodHasSpeciesSupport$4('concat');

// `Array.prototype.concat` method
// https://tc39.es/ecma262/#sec-array.prototype.concat
// with adding support of @@isConcatSpreadable and @@species
$$H({ target: 'Array', proto: true, arity: 1, forced: FORCED$8 }, {
  // eslint-disable-next-line no-unused-vars -- required for `.length`
  concat: function concat(arg) {
    var O = toObject$9(this);
    var A = arraySpeciesCreate$2(O, 0);
    var n = 0;
    var i, k, length, len, E;
    for (i = -1, length = arguments.length; i < length; i++) {
      E = i === -1 ? O : arguments[i];
      if (isConcatSpreadable(E)) {
        len = lengthOfArrayLike$8(E);
        doesNotExceedSafeInteger$1(n + len);
        for (k = 0; k < len; k++, n++) if (k in E) createProperty$4(A, n, E[k]);
      } else {
        doesNotExceedSafeInteger$1(n + 1);
        createProperty$4(A, n++, E);
      }
    }
    A.length = n;
    return A;
  }
});

var classof$a = classof$c;

var $String$1 = String;

var toString$a = function (argument) {
  if (classof$a(argument) === 'Symbol') throw new TypeError('Cannot convert a Symbol value to a string');
  return $String$1(argument);
};

var objectDefineProperties = {};

var DESCRIPTORS$b = descriptors;
var V8_PROTOTYPE_DEFINE_BUG = v8PrototypeDefineBug;
var definePropertyModule$1 = objectDefineProperty;
var anObject$7 = anObject$9;
var toIndexedObject$6 = toIndexedObject$a;
var objectKeys$1 = objectKeys$3;

// `Object.defineProperties` method
// https://tc39.es/ecma262/#sec-object.defineproperties
// eslint-disable-next-line es/no-object-defineproperties -- safe
objectDefineProperties.f = DESCRIPTORS$b && !V8_PROTOTYPE_DEFINE_BUG ? Object.defineProperties : function defineProperties(O, Properties) {
  anObject$7(O);
  var props = toIndexedObject$6(Properties);
  var keys = objectKeys$1(Properties);
  var length = keys.length;
  var index = 0;
  var key;
  while (length > index) definePropertyModule$1.f(O, key = keys[index++], props[key]);
  return O;
};

var getBuiltIn$8 = getBuiltIn$b;

var html$1 = getBuiltIn$8('document', 'documentElement');

var shared$5 = sharedExports;
var uid$2 = uid$4;

var keys$3 = shared$5('keys');

var sharedKey$4 = function (key) {
  return keys$3[key] || (keys$3[key] = uid$2(key));
};

/* global ActiveXObject -- old IE, WSH */
var anObject$6 = anObject$9;
var definePropertiesModule$1 = objectDefineProperties;
var enumBugKeys$1 = enumBugKeys$3;
var hiddenKeys$4 = hiddenKeys$6;
var html = html$1;
var documentCreateElement = documentCreateElement$1;
var sharedKey$3 = sharedKey$4;

var GT = '>';
var LT = '<';
var PROTOTYPE$1 = 'prototype';
var SCRIPT = 'script';
var IE_PROTO$1 = sharedKey$3('IE_PROTO');

var EmptyConstructor = function () { /* empty */ };

var scriptTag = function (content) {
  return LT + SCRIPT + GT + content + LT + '/' + SCRIPT + GT;
};

// Create object with fake `null` prototype: use ActiveX Object with cleared prototype
var NullProtoObjectViaActiveX = function (activeXDocument) {
  activeXDocument.write(scriptTag(''));
  activeXDocument.close();
  var temp = activeXDocument.parentWindow.Object;
  activeXDocument = null; // avoid memory leak
  return temp;
};

// Create object with fake `null` prototype: use iframe Object with cleared prototype
var NullProtoObjectViaIFrame = function () {
  // Thrash, waste and sodomy: IE GC bug
  var iframe = documentCreateElement('iframe');
  var JS = 'java' + SCRIPT + ':';
  var iframeDocument;
  iframe.style.display = 'none';
  html.appendChild(iframe);
  // https://github.com/zloirock/core-js/issues/475
  iframe.src = String(JS);
  iframeDocument = iframe.contentWindow.document;
  iframeDocument.open();
  iframeDocument.write(scriptTag('document.F=Object'));
  iframeDocument.close();
  return iframeDocument.F;
};

// Check for document.domain and active x support
// No need to use active x approach when document.domain is not set
// see https://github.com/es-shims/es5-shim/issues/150
// variation of https://github.com/kitcambridge/es5-shim/commit/4f738ac066346
// avoid IE GC bug
var activeXDocument;
var NullProtoObject = function () {
  try {
    activeXDocument = new ActiveXObject('htmlfile');
  } catch (error) { /* ignore */ }
  NullProtoObject = typeof document != 'undefined'
    ? document.domain && activeXDocument
      ? NullProtoObjectViaActiveX(activeXDocument) // old IE
      : NullProtoObjectViaIFrame()
    : NullProtoObjectViaActiveX(activeXDocument); // WSH
  var length = enumBugKeys$1.length;
  while (length--) delete NullProtoObject[PROTOTYPE$1][enumBugKeys$1[length]];
  return NullProtoObject();
};

hiddenKeys$4[IE_PROTO$1] = true;

// `Object.create` method
// https://tc39.es/ecma262/#sec-object.create
// eslint-disable-next-line es/no-object-create -- safe
var objectCreate = Object.create || function create(O, Properties) {
  var result;
  if (O !== null) {
    EmptyConstructor[PROTOTYPE$1] = anObject$6(O);
    result = new EmptyConstructor();
    EmptyConstructor[PROTOTYPE$1] = null;
    // add "__proto__" for Object.getPrototypeOf polyfill
    result[IE_PROTO$1] = O;
  } else result = NullProtoObject();
  return Properties === undefined ? result : definePropertiesModule$1.f(result, Properties);
};

var objectGetOwnPropertyNames = {};

var internalObjectKeys = objectKeysInternal;
var enumBugKeys = enumBugKeys$3;

var hiddenKeys$3 = enumBugKeys.concat('length', 'prototype');

// `Object.getOwnPropertyNames` method
// https://tc39.es/ecma262/#sec-object.getownpropertynames
// eslint-disable-next-line es/no-object-getownpropertynames -- safe
objectGetOwnPropertyNames.f = Object.getOwnPropertyNames || function getOwnPropertyNames(O) {
  return internalObjectKeys(O, hiddenKeys$3);
};

var objectGetOwnPropertyNamesExternal = {};

var toAbsoluteIndex$3 = toAbsoluteIndex$5;
var lengthOfArrayLike$7 = lengthOfArrayLike$a;
var createProperty$3 = createProperty$5;

var $Array$1 = Array;
var max$2 = Math.max;

var arraySliceSimple = function (O, start, end) {
  var length = lengthOfArrayLike$7(O);
  var k = toAbsoluteIndex$3(start, length);
  var fin = toAbsoluteIndex$3(end === undefined ? length : end, length);
  var result = $Array$1(max$2(fin - k, 0));
  var n = 0;
  for (; k < fin; k++, n++) createProperty$3(result, n, O[k]);
  result.length = n;
  return result;
};

/* eslint-disable es/no-object-getownpropertynames -- safe */
var classof$9 = classofRaw$2;
var toIndexedObject$5 = toIndexedObject$a;
var $getOwnPropertyNames$1 = objectGetOwnPropertyNames.f;
var arraySlice$3 = arraySliceSimple;

var windowNames = typeof window == 'object' && window && Object.getOwnPropertyNames
  ? Object.getOwnPropertyNames(window) : [];

var getWindowNames = function (it) {
  try {
    return $getOwnPropertyNames$1(it);
  } catch (error) {
    return arraySlice$3(windowNames);
  }
};

// fallback for IE11 buggy Object.getOwnPropertyNames with iframe and window
objectGetOwnPropertyNamesExternal.f = function getOwnPropertyNames(it) {
  return windowNames && classof$9(it) === 'Window'
    ? getWindowNames(it)
    : $getOwnPropertyNames$1(toIndexedObject$5(it));
};

var createNonEnumerableProperty$4 = createNonEnumerableProperty$6;

var defineBuiltIn$5 = function (target, key, value, options) {
  if (options && options.enumerable) target[key] = value;
  else createNonEnumerableProperty$4(target, key, value);
  return target;
};

var defineProperty$d = objectDefineProperty;

var defineBuiltInAccessor$3 = function (target, name, descriptor) {
  return defineProperty$d.f(target, name, descriptor);
};

var wellKnownSymbolWrapped = {};

var wellKnownSymbol$e = wellKnownSymbol$l;

wellKnownSymbolWrapped.f = wellKnownSymbol$e;

var path$n = path$s;
var hasOwn$b = hasOwnProperty_1;
var wrappedWellKnownSymbolModule$1 = wellKnownSymbolWrapped;
var defineProperty$c = objectDefineProperty.f;

var wellKnownSymbolDefine = function (NAME) {
  var Symbol = path$n.Symbol || (path$n.Symbol = {});
  if (!hasOwn$b(Symbol, NAME)) defineProperty$c(Symbol, NAME, {
    value: wrappedWellKnownSymbolModule$1.f(NAME)
  });
};

var call$6 = functionCall;
var getBuiltIn$7 = getBuiltIn$b;
var wellKnownSymbol$d = wellKnownSymbol$l;
var defineBuiltIn$4 = defineBuiltIn$5;

var symbolDefineToPrimitive = function () {
  var Symbol = getBuiltIn$7('Symbol');
  var SymbolPrototype = Symbol && Symbol.prototype;
  var valueOf = SymbolPrototype && SymbolPrototype.valueOf;
  var TO_PRIMITIVE = wellKnownSymbol$d('toPrimitive');

  if (SymbolPrototype && !SymbolPrototype[TO_PRIMITIVE]) {
    // `Symbol.prototype[@@toPrimitive]` method
    // https://tc39.es/ecma262/#sec-symbol.prototype-@@toprimitive
    // eslint-disable-next-line no-unused-vars -- required for .length
    defineBuiltIn$4(SymbolPrototype, TO_PRIMITIVE, function (hint) {
      return call$6(valueOf, this);
    }, { arity: 1 });
  }
};

var TO_STRING_TAG_SUPPORT$1 = toStringTagSupport;
var classof$8 = classof$c;

// `Object.prototype.toString` method implementation
// https://tc39.es/ecma262/#sec-object.prototype.tostring
var objectToString = TO_STRING_TAG_SUPPORT$1 ? {}.toString : function toString() {
  return '[object ' + classof$8(this) + ']';
};

var TO_STRING_TAG_SUPPORT = toStringTagSupport;
var defineProperty$b = objectDefineProperty.f;
var createNonEnumerableProperty$3 = createNonEnumerableProperty$6;
var hasOwn$a = hasOwnProperty_1;
var toString$9 = objectToString;
var wellKnownSymbol$c = wellKnownSymbol$l;

var TO_STRING_TAG$1 = wellKnownSymbol$c('toStringTag');

var setToStringTag$6 = function (it, TAG, STATIC, SET_METHOD) {
  if (it) {
    var target = STATIC ? it : it.prototype;
    if (!hasOwn$a(target, TO_STRING_TAG$1)) {
      defineProperty$b(target, TO_STRING_TAG$1, { configurable: true, value: TAG });
    }
    if (SET_METHOD && !TO_STRING_TAG_SUPPORT) {
      createNonEnumerableProperty$3(target, 'toString', toString$9);
    }
  }
};

var global$e = global$n;
var isCallable$6 = isCallable$h;

var WeakMap$1 = global$e.WeakMap;

var weakMapBasicDetection = isCallable$6(WeakMap$1) && /native code/.test(String(WeakMap$1));

var NATIVE_WEAK_MAP$1 = weakMapBasicDetection;
var global$d = global$n;
var isObject$9 = isObject$h;
var createNonEnumerableProperty$2 = createNonEnumerableProperty$6;
var hasOwn$9 = hasOwnProperty_1;
var shared$4 = sharedStore;
var sharedKey$2 = sharedKey$4;
var hiddenKeys$2 = hiddenKeys$6;

var OBJECT_ALREADY_INITIALIZED = 'Object already initialized';
var TypeError$2 = global$d.TypeError;
var WeakMap = global$d.WeakMap;
var set$3, get, has;

var enforce = function (it) {
  return has(it) ? get(it) : set$3(it, {});
};

var getterFor = function (TYPE) {
  return function (it) {
    var state;
    if (!isObject$9(it) || (state = get(it)).type !== TYPE) {
      throw new TypeError$2('Incompatible receiver, ' + TYPE + ' required');
    } return state;
  };
};

if (NATIVE_WEAK_MAP$1 || shared$4.state) {
  var store = shared$4.state || (shared$4.state = new WeakMap());
  /* eslint-disable no-self-assign -- prototype methods protection */
  store.get = store.get;
  store.has = store.has;
  store.set = store.set;
  /* eslint-enable no-self-assign -- prototype methods protection */
  set$3 = function (it, metadata) {
    if (store.has(it)) throw new TypeError$2(OBJECT_ALREADY_INITIALIZED);
    metadata.facade = it;
    store.set(it, metadata);
    return metadata;
  };
  get = function (it) {
    return store.get(it) || {};
  };
  has = function (it) {
    return store.has(it);
  };
} else {
  var STATE = sharedKey$2('state');
  hiddenKeys$2[STATE] = true;
  set$3 = function (it, metadata) {
    if (hasOwn$9(it, STATE)) throw new TypeError$2(OBJECT_ALREADY_INITIALIZED);
    metadata.facade = it;
    createNonEnumerableProperty$2(it, STATE, metadata);
    return metadata;
  };
  get = function (it) {
    return hasOwn$9(it, STATE) ? it[STATE] : {};
  };
  has = function (it) {
    return hasOwn$9(it, STATE);
  };
}

var internalState = {
  set: set$3,
  get: get,
  has: has,
  enforce: enforce,
  getterFor: getterFor
};

var bind$2 = functionBindContext;
var uncurryThis$i = functionUncurryThis;
var IndexedObject$1 = indexedObject;
var toObject$8 = toObject$c;
var lengthOfArrayLike$6 = lengthOfArrayLike$a;
var arraySpeciesCreate$1 = arraySpeciesCreate$3;

var push$3 = uncurryThis$i([].push);

// `Array.prototype.{ forEach, map, filter, some, every, find, findIndex, filterReject }` methods implementation
var createMethod$3 = function (TYPE) {
  var IS_MAP = TYPE === 1;
  var IS_FILTER = TYPE === 2;
  var IS_SOME = TYPE === 3;
  var IS_EVERY = TYPE === 4;
  var IS_FIND_INDEX = TYPE === 6;
  var IS_FILTER_REJECT = TYPE === 7;
  var NO_HOLES = TYPE === 5 || IS_FIND_INDEX;
  return function ($this, callbackfn, that, specificCreate) {
    var O = toObject$8($this);
    var self = IndexedObject$1(O);
    var boundFunction = bind$2(callbackfn, that);
    var length = lengthOfArrayLike$6(self);
    var index = 0;
    var create = specificCreate || arraySpeciesCreate$1;
    var target = IS_MAP ? create($this, length) : IS_FILTER || IS_FILTER_REJECT ? create($this, 0) : undefined;
    var value, result;
    for (;length > index; index++) if (NO_HOLES || index in self) {
      value = self[index];
      result = boundFunction(value, index, O);
      if (TYPE) {
        if (IS_MAP) target[index] = result; // map
        else if (result) switch (TYPE) {
          case 3: return true;              // some
          case 5: return value;             // find
          case 6: return index;             // findIndex
          case 2: push$3(target, value);      // filter
        } else switch (TYPE) {
          case 4: return false;             // every
          case 7: push$3(target, value);      // filterReject
        }
      }
    }
    return IS_FIND_INDEX ? -1 : IS_SOME || IS_EVERY ? IS_EVERY : target;
  };
};

var arrayIteration = {
  // `Array.prototype.forEach` method
  // https://tc39.es/ecma262/#sec-array.prototype.foreach
  forEach: createMethod$3(0),
  // `Array.prototype.map` method
  // https://tc39.es/ecma262/#sec-array.prototype.map
  map: createMethod$3(1),
  // `Array.prototype.filter` method
  // https://tc39.es/ecma262/#sec-array.prototype.filter
  filter: createMethod$3(2),
  // `Array.prototype.some` method
  // https://tc39.es/ecma262/#sec-array.prototype.some
  some: createMethod$3(3),
  // `Array.prototype.every` method
  // https://tc39.es/ecma262/#sec-array.prototype.every
  every: createMethod$3(4),
  // `Array.prototype.find` method
  // https://tc39.es/ecma262/#sec-array.prototype.find
  find: createMethod$3(5),
  // `Array.prototype.findIndex` method
  // https://tc39.es/ecma262/#sec-array.prototype.findIndex
  findIndex: createMethod$3(6),
  // `Array.prototype.filterReject` method
  // https://github.com/tc39/proposal-array-filtering
  filterReject: createMethod$3(7)
};

var $$G = _export;
var global$c = global$n;
var call$5 = functionCall;
var uncurryThis$h = functionUncurryThis;
var DESCRIPTORS$a = descriptors;
var NATIVE_SYMBOL$3 = symbolConstructorDetection;
var fails$i = fails$u;
var hasOwn$8 = hasOwnProperty_1;
var isPrototypeOf$h = objectIsPrototypeOf;
var anObject$5 = anObject$9;
var toIndexedObject$4 = toIndexedObject$a;
var toPropertyKey = toPropertyKey$4;
var $toString = toString$a;
var createPropertyDescriptor$1 = createPropertyDescriptor$5;
var nativeObjectCreate = objectCreate;
var objectKeys = objectKeys$3;
var getOwnPropertyNamesModule$2 = objectGetOwnPropertyNames;
var getOwnPropertyNamesExternal = objectGetOwnPropertyNamesExternal;
var getOwnPropertySymbolsModule$2 = objectGetOwnPropertySymbols;
var getOwnPropertyDescriptorModule$1 = objectGetOwnPropertyDescriptor;
var definePropertyModule = objectDefineProperty;
var definePropertiesModule = objectDefineProperties;
var propertyIsEnumerableModule = objectPropertyIsEnumerable;
var defineBuiltIn$3 = defineBuiltIn$5;
var defineBuiltInAccessor$2 = defineBuiltInAccessor$3;
var shared$3 = sharedExports;
var sharedKey$1 = sharedKey$4;
var hiddenKeys$1 = hiddenKeys$6;
var uid$1 = uid$4;
var wellKnownSymbol$b = wellKnownSymbol$l;
var wrappedWellKnownSymbolModule = wellKnownSymbolWrapped;
var defineWellKnownSymbol$l = wellKnownSymbolDefine;
var defineSymbolToPrimitive$1 = symbolDefineToPrimitive;
var setToStringTag$5 = setToStringTag$6;
var InternalStateModule$5 = internalState;
var $forEach$1 = arrayIteration.forEach;

var HIDDEN = sharedKey$1('hidden');
var SYMBOL = 'Symbol';
var PROTOTYPE = 'prototype';

var setInternalState$5 = InternalStateModule$5.set;
var getInternalState$2 = InternalStateModule$5.getterFor(SYMBOL);

var ObjectPrototype$1 = Object[PROTOTYPE];
var $Symbol = global$c.Symbol;
var SymbolPrototype = $Symbol && $Symbol[PROTOTYPE];
var RangeError$1 = global$c.RangeError;
var TypeError$1 = global$c.TypeError;
var QObject = global$c.QObject;
var nativeGetOwnPropertyDescriptor$1 = getOwnPropertyDescriptorModule$1.f;
var nativeDefineProperty = definePropertyModule.f;
var nativeGetOwnPropertyNames = getOwnPropertyNamesExternal.f;
var nativePropertyIsEnumerable = propertyIsEnumerableModule.f;
var push$2 = uncurryThis$h([].push);

var AllSymbols = shared$3('symbols');
var ObjectPrototypeSymbols = shared$3('op-symbols');
var WellKnownSymbolsStore$1 = shared$3('wks');

// Don't use setters in Qt Script, https://github.com/zloirock/core-js/issues/173
var USE_SETTER = !QObject || !QObject[PROTOTYPE] || !QObject[PROTOTYPE].findChild;

// fallback for old Android, https://code.google.com/p/v8/issues/detail?id=687
var fallbackDefineProperty = function (O, P, Attributes) {
  var ObjectPrototypeDescriptor = nativeGetOwnPropertyDescriptor$1(ObjectPrototype$1, P);
  if (ObjectPrototypeDescriptor) delete ObjectPrototype$1[P];
  nativeDefineProperty(O, P, Attributes);
  if (ObjectPrototypeDescriptor && O !== ObjectPrototype$1) {
    nativeDefineProperty(ObjectPrototype$1, P, ObjectPrototypeDescriptor);
  }
};

var setSymbolDescriptor = DESCRIPTORS$a && fails$i(function () {
  return nativeObjectCreate(nativeDefineProperty({}, 'a', {
    get: function () { return nativeDefineProperty(this, 'a', { value: 7 }).a; }
  })).a !== 7;
}) ? fallbackDefineProperty : nativeDefineProperty;

var wrap = function (tag, description) {
  var symbol = AllSymbols[tag] = nativeObjectCreate(SymbolPrototype);
  setInternalState$5(symbol, {
    type: SYMBOL,
    tag: tag,
    description: description
  });
  if (!DESCRIPTORS$a) symbol.description = description;
  return symbol;
};

var $defineProperty = function defineProperty(O, P, Attributes) {
  if (O === ObjectPrototype$1) $defineProperty(ObjectPrototypeSymbols, P, Attributes);
  anObject$5(O);
  var key = toPropertyKey(P);
  anObject$5(Attributes);
  if (hasOwn$8(AllSymbols, key)) {
    if (!Attributes.enumerable) {
      if (!hasOwn$8(O, HIDDEN)) nativeDefineProperty(O, HIDDEN, createPropertyDescriptor$1(1, {}));
      O[HIDDEN][key] = true;
    } else {
      if (hasOwn$8(O, HIDDEN) && O[HIDDEN][key]) O[HIDDEN][key] = false;
      Attributes = nativeObjectCreate(Attributes, { enumerable: createPropertyDescriptor$1(0, false) });
    } return setSymbolDescriptor(O, key, Attributes);
  } return nativeDefineProperty(O, key, Attributes);
};

var $defineProperties = function defineProperties(O, Properties) {
  anObject$5(O);
  var properties = toIndexedObject$4(Properties);
  var keys = objectKeys(properties).concat($getOwnPropertySymbols(properties));
  $forEach$1(keys, function (key) {
    if (!DESCRIPTORS$a || call$5($propertyIsEnumerable, properties, key)) $defineProperty(O, key, properties[key]);
  });
  return O;
};

var $create = function create(O, Properties) {
  return Properties === undefined ? nativeObjectCreate(O) : $defineProperties(nativeObjectCreate(O), Properties);
};

var $propertyIsEnumerable = function propertyIsEnumerable(V) {
  var P = toPropertyKey(V);
  var enumerable = call$5(nativePropertyIsEnumerable, this, P);
  if (this === ObjectPrototype$1 && hasOwn$8(AllSymbols, P) && !hasOwn$8(ObjectPrototypeSymbols, P)) return false;
  return enumerable || !hasOwn$8(this, P) || !hasOwn$8(AllSymbols, P) || hasOwn$8(this, HIDDEN) && this[HIDDEN][P]
    ? enumerable : true;
};

var $getOwnPropertyDescriptor = function getOwnPropertyDescriptor(O, P) {
  var it = toIndexedObject$4(O);
  var key = toPropertyKey(P);
  if (it === ObjectPrototype$1 && hasOwn$8(AllSymbols, key) && !hasOwn$8(ObjectPrototypeSymbols, key)) return;
  var descriptor = nativeGetOwnPropertyDescriptor$1(it, key);
  if (descriptor && hasOwn$8(AllSymbols, key) && !(hasOwn$8(it, HIDDEN) && it[HIDDEN][key])) {
    descriptor.enumerable = true;
  }
  return descriptor;
};

var $getOwnPropertyNames = function getOwnPropertyNames(O) {
  var names = nativeGetOwnPropertyNames(toIndexedObject$4(O));
  var result = [];
  $forEach$1(names, function (key) {
    if (!hasOwn$8(AllSymbols, key) && !hasOwn$8(hiddenKeys$1, key)) push$2(result, key);
  });
  return result;
};

var $getOwnPropertySymbols = function (O) {
  var IS_OBJECT_PROTOTYPE = O === ObjectPrototype$1;
  var names = nativeGetOwnPropertyNames(IS_OBJECT_PROTOTYPE ? ObjectPrototypeSymbols : toIndexedObject$4(O));
  var result = [];
  $forEach$1(names, function (key) {
    if (hasOwn$8(AllSymbols, key) && (!IS_OBJECT_PROTOTYPE || hasOwn$8(ObjectPrototype$1, key))) {
      push$2(result, AllSymbols[key]);
    }
  });
  return result;
};

// `Symbol` constructor
// https://tc39.es/ecma262/#sec-symbol-constructor
if (!NATIVE_SYMBOL$3) {
  $Symbol = function Symbol() {
    if (isPrototypeOf$h(SymbolPrototype, this)) throw new TypeError$1('Symbol is not a constructor');
    var description = !arguments.length || arguments[0] === undefined ? undefined : $toString(arguments[0]);
    var tag = uid$1(description);
    var setter = function (value) {
      if (this === ObjectPrototype$1) call$5(setter, ObjectPrototypeSymbols, value);
      if (hasOwn$8(this, HIDDEN) && hasOwn$8(this[HIDDEN], tag)) this[HIDDEN][tag] = false;
      var descriptor = createPropertyDescriptor$1(1, value);
      try {
        setSymbolDescriptor(this, tag, descriptor);
      } catch (error) {
        if (!(error instanceof RangeError$1)) throw error;
        fallbackDefineProperty(this, tag, descriptor);
      }
    };
    if (DESCRIPTORS$a && USE_SETTER) setSymbolDescriptor(ObjectPrototype$1, tag, { configurable: true, set: setter });
    return wrap(tag, description);
  };

  SymbolPrototype = $Symbol[PROTOTYPE];

  defineBuiltIn$3(SymbolPrototype, 'toString', function toString() {
    return getInternalState$2(this).tag;
  });

  defineBuiltIn$3($Symbol, 'withoutSetter', function (description) {
    return wrap(uid$1(description), description);
  });

  propertyIsEnumerableModule.f = $propertyIsEnumerable;
  definePropertyModule.f = $defineProperty;
  definePropertiesModule.f = $defineProperties;
  getOwnPropertyDescriptorModule$1.f = $getOwnPropertyDescriptor;
  getOwnPropertyNamesModule$2.f = getOwnPropertyNamesExternal.f = $getOwnPropertyNames;
  getOwnPropertySymbolsModule$2.f = $getOwnPropertySymbols;

  wrappedWellKnownSymbolModule.f = function (name) {
    return wrap(wellKnownSymbol$b(name), name);
  };

  if (DESCRIPTORS$a) {
    // https://github.com/tc39/proposal-Symbol-description
    defineBuiltInAccessor$2(SymbolPrototype, 'description', {
      configurable: true,
      get: function description() {
        return getInternalState$2(this).description;
      }
    });
  }
}

$$G({ global: true, constructor: true, wrap: true, forced: !NATIVE_SYMBOL$3, sham: !NATIVE_SYMBOL$3 }, {
  Symbol: $Symbol
});

$forEach$1(objectKeys(WellKnownSymbolsStore$1), function (name) {
  defineWellKnownSymbol$l(name);
});

$$G({ target: SYMBOL, stat: true, forced: !NATIVE_SYMBOL$3 }, {
  useSetter: function () { USE_SETTER = true; },
  useSimple: function () { USE_SETTER = false; }
});

$$G({ target: 'Object', stat: true, forced: !NATIVE_SYMBOL$3, sham: !DESCRIPTORS$a }, {
  // `Object.create` method
  // https://tc39.es/ecma262/#sec-object.create
  create: $create,
  // `Object.defineProperty` method
  // https://tc39.es/ecma262/#sec-object.defineproperty
  defineProperty: $defineProperty,
  // `Object.defineProperties` method
  // https://tc39.es/ecma262/#sec-object.defineproperties
  defineProperties: $defineProperties,
  // `Object.getOwnPropertyDescriptor` method
  // https://tc39.es/ecma262/#sec-object.getownpropertydescriptors
  getOwnPropertyDescriptor: $getOwnPropertyDescriptor
});

$$G({ target: 'Object', stat: true, forced: !NATIVE_SYMBOL$3 }, {
  // `Object.getOwnPropertyNames` method
  // https://tc39.es/ecma262/#sec-object.getownpropertynames
  getOwnPropertyNames: $getOwnPropertyNames
});

// `Symbol.prototype[@@toPrimitive]` method
// https://tc39.es/ecma262/#sec-symbol.prototype-@@toprimitive
defineSymbolToPrimitive$1();

// `Symbol.prototype[@@toStringTag]` property
// https://tc39.es/ecma262/#sec-symbol.prototype-@@tostringtag
setToStringTag$5($Symbol, SYMBOL);

hiddenKeys$1[HIDDEN] = true;

var NATIVE_SYMBOL$2 = symbolConstructorDetection;

/* eslint-disable es/no-symbol -- safe */
var symbolRegistryDetection = NATIVE_SYMBOL$2 && !!Symbol['for'] && !!Symbol.keyFor;

var $$F = _export;
var getBuiltIn$6 = getBuiltIn$b;
var hasOwn$7 = hasOwnProperty_1;
var toString$8 = toString$a;
var shared$2 = sharedExports;
var NATIVE_SYMBOL_REGISTRY$1 = symbolRegistryDetection;

var StringToSymbolRegistry = shared$2('string-to-symbol-registry');
var SymbolToStringRegistry$1 = shared$2('symbol-to-string-registry');

// `Symbol.for` method
// https://tc39.es/ecma262/#sec-symbol.for
$$F({ target: 'Symbol', stat: true, forced: !NATIVE_SYMBOL_REGISTRY$1 }, {
  'for': function (key) {
    var string = toString$8(key);
    if (hasOwn$7(StringToSymbolRegistry, string)) return StringToSymbolRegistry[string];
    var symbol = getBuiltIn$6('Symbol')(string);
    StringToSymbolRegistry[string] = symbol;
    SymbolToStringRegistry$1[symbol] = string;
    return symbol;
  }
});

var $$E = _export;
var hasOwn$6 = hasOwnProperty_1;
var isSymbol$2 = isSymbol$5;
var tryToString$3 = tryToString$5;
var shared$1 = sharedExports;
var NATIVE_SYMBOL_REGISTRY = symbolRegistryDetection;

var SymbolToStringRegistry = shared$1('symbol-to-string-registry');

// `Symbol.keyFor` method
// https://tc39.es/ecma262/#sec-symbol.keyfor
$$E({ target: 'Symbol', stat: true, forced: !NATIVE_SYMBOL_REGISTRY }, {
  keyFor: function keyFor(sym) {
    if (!isSymbol$2(sym)) throw new TypeError(tryToString$3(sym) + ' is not a symbol');
    if (hasOwn$6(SymbolToStringRegistry, sym)) return SymbolToStringRegistry[sym];
  }
});

var uncurryThis$g = functionUncurryThis;
var isArray$8 = isArray$b;
var isCallable$5 = isCallable$h;
var classof$7 = classofRaw$2;
var toString$7 = toString$a;

var push$1 = uncurryThis$g([].push);

var getJsonReplacerFunction = function (replacer) {
  if (isCallable$5(replacer)) return replacer;
  if (!isArray$8(replacer)) return;
  var rawLength = replacer.length;
  var keys = [];
  for (var i = 0; i < rawLength; i++) {
    var element = replacer[i];
    if (typeof element == 'string') push$1(keys, element);
    else if (typeof element == 'number' || classof$7(element) === 'Number' || classof$7(element) === 'String') push$1(keys, toString$7(element));
  }
  var keysLength = keys.length;
  var root = true;
  return function (key, value) {
    if (root) {
      root = false;
      return value;
    }
    if (isArray$8(this)) return value;
    for (var j = 0; j < keysLength; j++) if (keys[j] === key) return value;
  };
};

var $$D = _export;
var getBuiltIn$5 = getBuiltIn$b;
var apply$2 = functionApply;
var call$4 = functionCall;
var uncurryThis$f = functionUncurryThis;
var fails$h = fails$u;
var isCallable$4 = isCallable$h;
var isSymbol$1 = isSymbol$5;
var arraySlice$2 = arraySlice$5;
var getReplacerFunction = getJsonReplacerFunction;
var NATIVE_SYMBOL$1 = symbolConstructorDetection;

var $String = String;
var $stringify = getBuiltIn$5('JSON', 'stringify');
var exec$1 = uncurryThis$f(/./.exec);
var charAt$3 = uncurryThis$f(''.charAt);
var charCodeAt$1 = uncurryThis$f(''.charCodeAt);
var replace$1 = uncurryThis$f(''.replace);
var numberToString = uncurryThis$f(1.0.toString);

var tester = /[\uD800-\uDFFF]/g;
var low = /^[\uD800-\uDBFF]$/;
var hi = /^[\uDC00-\uDFFF]$/;

var WRONG_SYMBOLS_CONVERSION = !NATIVE_SYMBOL$1 || fails$h(function () {
  var symbol = getBuiltIn$5('Symbol')('stringify detection');
  // MS Edge converts symbol values to JSON as {}
  return $stringify([symbol]) !== '[null]'
    // WebKit converts symbol values to JSON as null
    || $stringify({ a: symbol }) !== '{}'
    // V8 throws on boxed symbols
    || $stringify(Object(symbol)) !== '{}';
});

// https://github.com/tc39/proposal-well-formed-stringify
var ILL_FORMED_UNICODE = fails$h(function () {
  return $stringify('\uDF06\uD834') !== '"\\udf06\\ud834"'
    || $stringify('\uDEAD') !== '"\\udead"';
});

var stringifyWithSymbolsFix = function (it, replacer) {
  var args = arraySlice$2(arguments);
  var $replacer = getReplacerFunction(replacer);
  if (!isCallable$4($replacer) && (it === undefined || isSymbol$1(it))) return; // IE8 returns string on undefined
  args[1] = function (key, value) {
    // some old implementations (like WebKit) could pass numbers as keys
    if (isCallable$4($replacer)) value = call$4($replacer, this, $String(key), value);
    if (!isSymbol$1(value)) return value;
  };
  return apply$2($stringify, null, args);
};

var fixIllFormed = function (match, offset, string) {
  var prev = charAt$3(string, offset - 1);
  var next = charAt$3(string, offset + 1);
  if ((exec$1(low, match) && !exec$1(hi, next)) || (exec$1(hi, match) && !exec$1(low, prev))) {
    return '\\u' + numberToString(charCodeAt$1(match, 0), 16);
  } return match;
};

if ($stringify) {
  // `JSON.stringify` method
  // https://tc39.es/ecma262/#sec-json.stringify
  $$D({ target: 'JSON', stat: true, arity: 3, forced: WRONG_SYMBOLS_CONVERSION || ILL_FORMED_UNICODE }, {
    // eslint-disable-next-line no-unused-vars -- required for `.length`
    stringify: function stringify(it, replacer, space) {
      var args = arraySlice$2(arguments);
      var result = apply$2(WRONG_SYMBOLS_CONVERSION ? stringifyWithSymbolsFix : $stringify, null, args);
      return ILL_FORMED_UNICODE && typeof result == 'string' ? replace$1(result, tester, fixIllFormed) : result;
    }
  });
}

var $$C = _export;
var NATIVE_SYMBOL = symbolConstructorDetection;
var fails$g = fails$u;
var getOwnPropertySymbolsModule$1 = objectGetOwnPropertySymbols;
var toObject$7 = toObject$c;

// V8 ~ Chrome 38 and 39 `Object.getOwnPropertySymbols` fails on primitives
// https://bugs.chromium.org/p/v8/issues/detail?id=3443
var FORCED$7 = !NATIVE_SYMBOL || fails$g(function () { getOwnPropertySymbolsModule$1.f(1); });

// `Object.getOwnPropertySymbols` method
// https://tc39.es/ecma262/#sec-object.getownpropertysymbols
$$C({ target: 'Object', stat: true, forced: FORCED$7 }, {
  getOwnPropertySymbols: function getOwnPropertySymbols(it) {
    var $getOwnPropertySymbols = getOwnPropertySymbolsModule$1.f;
    return $getOwnPropertySymbols ? $getOwnPropertySymbols(toObject$7(it)) : [];
  }
});

var defineWellKnownSymbol$k = wellKnownSymbolDefine;

// `Symbol.asyncIterator` well-known symbol
// https://tc39.es/ecma262/#sec-symbol.asynciterator
defineWellKnownSymbol$k('asyncIterator');

var defineWellKnownSymbol$j = wellKnownSymbolDefine;

// `Symbol.hasInstance` well-known symbol
// https://tc39.es/ecma262/#sec-symbol.hasinstance
defineWellKnownSymbol$j('hasInstance');

var defineWellKnownSymbol$i = wellKnownSymbolDefine;

// `Symbol.isConcatSpreadable` well-known symbol
// https://tc39.es/ecma262/#sec-symbol.isconcatspreadable
defineWellKnownSymbol$i('isConcatSpreadable');

var defineWellKnownSymbol$h = wellKnownSymbolDefine;

// `Symbol.iterator` well-known symbol
// https://tc39.es/ecma262/#sec-symbol.iterator
defineWellKnownSymbol$h('iterator');

var defineWellKnownSymbol$g = wellKnownSymbolDefine;

// `Symbol.match` well-known symbol
// https://tc39.es/ecma262/#sec-symbol.match
defineWellKnownSymbol$g('match');

var defineWellKnownSymbol$f = wellKnownSymbolDefine;

// `Symbol.matchAll` well-known symbol
// https://tc39.es/ecma262/#sec-symbol.matchall
defineWellKnownSymbol$f('matchAll');

var defineWellKnownSymbol$e = wellKnownSymbolDefine;

// `Symbol.replace` well-known symbol
// https://tc39.es/ecma262/#sec-symbol.replace
defineWellKnownSymbol$e('replace');

var defineWellKnownSymbol$d = wellKnownSymbolDefine;

// `Symbol.search` well-known symbol
// https://tc39.es/ecma262/#sec-symbol.search
defineWellKnownSymbol$d('search');

var defineWellKnownSymbol$c = wellKnownSymbolDefine;

// `Symbol.species` well-known symbol
// https://tc39.es/ecma262/#sec-symbol.species
defineWellKnownSymbol$c('species');

var defineWellKnownSymbol$b = wellKnownSymbolDefine;

// `Symbol.split` well-known symbol
// https://tc39.es/ecma262/#sec-symbol.split
defineWellKnownSymbol$b('split');

var defineWellKnownSymbol$a = wellKnownSymbolDefine;
var defineSymbolToPrimitive = symbolDefineToPrimitive;

// `Symbol.toPrimitive` well-known symbol
// https://tc39.es/ecma262/#sec-symbol.toprimitive
defineWellKnownSymbol$a('toPrimitive');

// `Symbol.prototype[@@toPrimitive]` method
// https://tc39.es/ecma262/#sec-symbol.prototype-@@toprimitive
defineSymbolToPrimitive();

var getBuiltIn$4 = getBuiltIn$b;
var defineWellKnownSymbol$9 = wellKnownSymbolDefine;
var setToStringTag$4 = setToStringTag$6;

// `Symbol.toStringTag` well-known symbol
// https://tc39.es/ecma262/#sec-symbol.tostringtag
defineWellKnownSymbol$9('toStringTag');

// `Symbol.prototype[@@toStringTag]` property
// https://tc39.es/ecma262/#sec-symbol.prototype-@@tostringtag
setToStringTag$4(getBuiltIn$4('Symbol'), 'Symbol');

var defineWellKnownSymbol$8 = wellKnownSymbolDefine;

// `Symbol.unscopables` well-known symbol
// https://tc39.es/ecma262/#sec-symbol.unscopables
defineWellKnownSymbol$8('unscopables');

var global$b = global$n;
var setToStringTag$3 = setToStringTag$6;

// JSON[@@toStringTag] property
// https://tc39.es/ecma262/#sec-json-@@tostringtag
setToStringTag$3(global$b.JSON, 'JSON', true);

var path$m = path$s;

var symbol$5 = path$m.Symbol;

var iterators = {};

var DESCRIPTORS$9 = descriptors;
var hasOwn$5 = hasOwnProperty_1;

var FunctionPrototype$1 = Function.prototype;
// eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
var getDescriptor = DESCRIPTORS$9 && Object.getOwnPropertyDescriptor;

var EXISTS = hasOwn$5(FunctionPrototype$1, 'name');
// additional protection from minified / mangled / dropped function names
var PROPER = EXISTS && (function something() { /* empty */ }).name === 'something';
var CONFIGURABLE = EXISTS && (!DESCRIPTORS$9 || (DESCRIPTORS$9 && getDescriptor(FunctionPrototype$1, 'name').configurable));

var functionName = {
  EXISTS: EXISTS,
  PROPER: PROPER,
  CONFIGURABLE: CONFIGURABLE
};

var fails$f = fails$u;

var correctPrototypeGetter = !fails$f(function () {
  function F() { /* empty */ }
  F.prototype.constructor = null;
  // eslint-disable-next-line es/no-object-getprototypeof -- required for testing
  return Object.getPrototypeOf(new F()) !== F.prototype;
});

var hasOwn$4 = hasOwnProperty_1;
var isCallable$3 = isCallable$h;
var toObject$6 = toObject$c;
var sharedKey = sharedKey$4;
var CORRECT_PROTOTYPE_GETTER$1 = correctPrototypeGetter;

var IE_PROTO = sharedKey('IE_PROTO');
var $Object$1 = Object;
var ObjectPrototype = $Object$1.prototype;

// `Object.getPrototypeOf` method
// https://tc39.es/ecma262/#sec-object.getprototypeof
// eslint-disable-next-line es/no-object-getprototypeof -- safe
var objectGetPrototypeOf = CORRECT_PROTOTYPE_GETTER$1 ? $Object$1.getPrototypeOf : function (O) {
  var object = toObject$6(O);
  if (hasOwn$4(object, IE_PROTO)) return object[IE_PROTO];
  var constructor = object.constructor;
  if (isCallable$3(constructor) && object instanceof constructor) {
    return constructor.prototype;
  } return object instanceof $Object$1 ? ObjectPrototype : null;
};

var fails$e = fails$u;
var isCallable$2 = isCallable$h;
var isObject$8 = isObject$h;
var create$6 = objectCreate;
var getPrototypeOf$4 = objectGetPrototypeOf;
var defineBuiltIn$2 = defineBuiltIn$5;
var wellKnownSymbol$a = wellKnownSymbol$l;

var ITERATOR$5 = wellKnownSymbol$a('iterator');
var BUGGY_SAFARI_ITERATORS$1 = false;

// `%IteratorPrototype%` object
// https://tc39.es/ecma262/#sec-%iteratorprototype%-object
var IteratorPrototype$1, PrototypeOfArrayIteratorPrototype, arrayIterator;

/* eslint-disable es/no-array-prototype-keys -- safe */
if ([].keys) {
  arrayIterator = [].keys();
  // Safari 8 has buggy iterators w/o `next`
  if (!('next' in arrayIterator)) BUGGY_SAFARI_ITERATORS$1 = true;
  else {
    PrototypeOfArrayIteratorPrototype = getPrototypeOf$4(getPrototypeOf$4(arrayIterator));
    if (PrototypeOfArrayIteratorPrototype !== Object.prototype) IteratorPrototype$1 = PrototypeOfArrayIteratorPrototype;
  }
}

var NEW_ITERATOR_PROTOTYPE = !isObject$8(IteratorPrototype$1) || fails$e(function () {
  var test = {};
  // FF44- legacy iterators case
  return IteratorPrototype$1[ITERATOR$5].call(test) !== test;
});

if (NEW_ITERATOR_PROTOTYPE) IteratorPrototype$1 = {};
else IteratorPrototype$1 = create$6(IteratorPrototype$1);

// `%IteratorPrototype%[@@iterator]()` method
// https://tc39.es/ecma262/#sec-%iteratorprototype%-@@iterator
if (!isCallable$2(IteratorPrototype$1[ITERATOR$5])) {
  defineBuiltIn$2(IteratorPrototype$1, ITERATOR$5, function () {
    return this;
  });
}

var iteratorsCore = {
  IteratorPrototype: IteratorPrototype$1,
  BUGGY_SAFARI_ITERATORS: BUGGY_SAFARI_ITERATORS$1
};

var IteratorPrototype = iteratorsCore.IteratorPrototype;
var create$5 = objectCreate;
var createPropertyDescriptor = createPropertyDescriptor$5;
var setToStringTag$2 = setToStringTag$6;
var Iterators$5 = iterators;

var returnThis$1 = function () { return this; };

var iteratorCreateConstructor = function (IteratorConstructor, NAME, next, ENUMERABLE_NEXT) {
  var TO_STRING_TAG = NAME + ' Iterator';
  IteratorConstructor.prototype = create$5(IteratorPrototype, { next: createPropertyDescriptor(+!ENUMERABLE_NEXT, next) });
  setToStringTag$2(IteratorConstructor, TO_STRING_TAG, false, true);
  Iterators$5[TO_STRING_TAG] = returnThis$1;
  return IteratorConstructor;
};

var $$B = _export;
var call$3 = functionCall;
var FunctionName = functionName;
var createIteratorConstructor = iteratorCreateConstructor;
var getPrototypeOf$3 = objectGetPrototypeOf;
var setToStringTag$1 = setToStringTag$6;
var defineBuiltIn$1 = defineBuiltIn$5;
var wellKnownSymbol$9 = wellKnownSymbol$l;
var Iterators$4 = iterators;
var IteratorsCore = iteratorsCore;

var PROPER_FUNCTION_NAME = FunctionName.PROPER;
FunctionName.CONFIGURABLE;
IteratorsCore.IteratorPrototype;
var BUGGY_SAFARI_ITERATORS = IteratorsCore.BUGGY_SAFARI_ITERATORS;
var ITERATOR$4 = wellKnownSymbol$9('iterator');
var KEYS = 'keys';
var VALUES = 'values';
var ENTRIES = 'entries';

var returnThis = function () { return this; };

var iteratorDefine = function (Iterable, NAME, IteratorConstructor, next, DEFAULT, IS_SET, FORCED) {
  createIteratorConstructor(IteratorConstructor, NAME, next);

  var getIterationMethod = function (KIND) {
    if (KIND === DEFAULT && defaultIterator) return defaultIterator;
    if (!BUGGY_SAFARI_ITERATORS && KIND && KIND in IterablePrototype) return IterablePrototype[KIND];

    switch (KIND) {
      case KEYS: return function keys() { return new IteratorConstructor(this, KIND); };
      case VALUES: return function values() { return new IteratorConstructor(this, KIND); };
      case ENTRIES: return function entries() { return new IteratorConstructor(this, KIND); };
    }

    return function () { return new IteratorConstructor(this); };
  };

  var TO_STRING_TAG = NAME + ' Iterator';
  var INCORRECT_VALUES_NAME = false;
  var IterablePrototype = Iterable.prototype;
  var nativeIterator = IterablePrototype[ITERATOR$4]
    || IterablePrototype['@@iterator']
    || DEFAULT && IterablePrototype[DEFAULT];
  var defaultIterator = !BUGGY_SAFARI_ITERATORS && nativeIterator || getIterationMethod(DEFAULT);
  var anyNativeIterator = NAME === 'Array' ? IterablePrototype.entries || nativeIterator : nativeIterator;
  var CurrentIteratorPrototype, methods, KEY;

  // fix native
  if (anyNativeIterator) {
    CurrentIteratorPrototype = getPrototypeOf$3(anyNativeIterator.call(new Iterable()));
    if (CurrentIteratorPrototype !== Object.prototype && CurrentIteratorPrototype.next) {
      // Set @@toStringTag to native iterators
      setToStringTag$1(CurrentIteratorPrototype, TO_STRING_TAG, true, true);
      Iterators$4[TO_STRING_TAG] = returnThis;
    }
  }

  // fix Array.prototype.{ values, @@iterator }.name in V8 / FF
  if (PROPER_FUNCTION_NAME && DEFAULT === VALUES && nativeIterator && nativeIterator.name !== VALUES) {
    {
      INCORRECT_VALUES_NAME = true;
      defaultIterator = function values() { return call$3(nativeIterator, this); };
    }
  }

  // export additional methods
  if (DEFAULT) {
    methods = {
      values: getIterationMethod(VALUES),
      keys: IS_SET ? defaultIterator : getIterationMethod(KEYS),
      entries: getIterationMethod(ENTRIES)
    };
    if (FORCED) for (KEY in methods) {
      if (BUGGY_SAFARI_ITERATORS || INCORRECT_VALUES_NAME || !(KEY in IterablePrototype)) {
        defineBuiltIn$1(IterablePrototype, KEY, methods[KEY]);
      }
    } else $$B({ target: NAME, proto: true, forced: BUGGY_SAFARI_ITERATORS || INCORRECT_VALUES_NAME }, methods);
  }

  // define iterator
  if ((FORCED) && IterablePrototype[ITERATOR$4] !== defaultIterator) {
    defineBuiltIn$1(IterablePrototype, ITERATOR$4, defaultIterator, { name: DEFAULT });
  }
  Iterators$4[NAME] = defaultIterator;

  return methods;
};

// `CreateIterResultObject` abstract operation
// https://tc39.es/ecma262/#sec-createiterresultobject
var createIterResultObject$3 = function (value, done) {
  return { value: value, done: done };
};

var toIndexedObject$3 = toIndexedObject$a;
var Iterators$3 = iterators;
var InternalStateModule$4 = internalState;
objectDefineProperty.f;
var defineIterator$2 = iteratorDefine;
var createIterResultObject$2 = createIterResultObject$3;

var ARRAY_ITERATOR = 'Array Iterator';
var setInternalState$4 = InternalStateModule$4.set;
var getInternalState$1 = InternalStateModule$4.getterFor(ARRAY_ITERATOR);

// `Array.prototype.entries` method
// https://tc39.es/ecma262/#sec-array.prototype.entries
// `Array.prototype.keys` method
// https://tc39.es/ecma262/#sec-array.prototype.keys
// `Array.prototype.values` method
// https://tc39.es/ecma262/#sec-array.prototype.values
// `Array.prototype[@@iterator]` method
// https://tc39.es/ecma262/#sec-array.prototype-@@iterator
// `CreateArrayIterator` internal method
// https://tc39.es/ecma262/#sec-createarrayiterator
defineIterator$2(Array, 'Array', function (iterated, kind) {
  setInternalState$4(this, {
    type: ARRAY_ITERATOR,
    target: toIndexedObject$3(iterated), // target
    index: 0,                          // next index
    kind: kind                         // kind
  });
// `%ArrayIteratorPrototype%.next` method
// https://tc39.es/ecma262/#sec-%arrayiteratorprototype%.next
}, function () {
  var state = getInternalState$1(this);
  var target = state.target;
  var kind = state.kind;
  var index = state.index++;
  if (!target || index >= target.length) {
    state.target = undefined;
    return createIterResultObject$2(undefined, true);
  }
  switch (kind) {
    case 'keys': return createIterResultObject$2(index, false);
    case 'values': return createIterResultObject$2(target[index], false);
  } return createIterResultObject$2([index, target[index]], false);
}, 'values');

// argumentsList[@@iterator] is %ArrayProto_values%
// https://tc39.es/ecma262/#sec-createunmappedargumentsobject
// https://tc39.es/ecma262/#sec-createmappedargumentsobject
Iterators$3.Arguments = Iterators$3.Array;

// iterable DOM collections
// flag - `iterable` interface - 'entries', 'keys', 'values', 'forEach' methods
var domIterables = {
  CSSRuleList: 0,
  CSSStyleDeclaration: 0,
  CSSValueList: 0,
  ClientRectList: 0,
  DOMRectList: 0,
  DOMStringList: 0,
  DOMTokenList: 1,
  DataTransferItemList: 0,
  FileList: 0,
  HTMLAllCollection: 0,
  HTMLCollection: 0,
  HTMLFormElement: 0,
  HTMLSelectElement: 0,
  MediaList: 0,
  MimeTypeArray: 0,
  NamedNodeMap: 0,
  NodeList: 1,
  PaintRequestList: 0,
  Plugin: 0,
  PluginArray: 0,
  SVGLengthList: 0,
  SVGNumberList: 0,
  SVGPathSegList: 0,
  SVGPointList: 0,
  SVGStringList: 0,
  SVGTransformList: 0,
  SourceBufferList: 0,
  StyleSheetList: 0,
  TextTrackCueList: 0,
  TextTrackList: 0,
  TouchList: 0
};

var DOMIterables$2 = domIterables;
var global$a = global$n;
var classof$6 = classof$c;
var createNonEnumerableProperty$1 = createNonEnumerableProperty$6;
var Iterators$2 = iterators;
var wellKnownSymbol$8 = wellKnownSymbol$l;

var TO_STRING_TAG = wellKnownSymbol$8('toStringTag');

for (var COLLECTION_NAME in DOMIterables$2) {
  var Collection = global$a[COLLECTION_NAME];
  var CollectionPrototype = Collection && Collection.prototype;
  if (CollectionPrototype && classof$6(CollectionPrototype) !== TO_STRING_TAG) {
    createNonEnumerableProperty$1(CollectionPrototype, TO_STRING_TAG, COLLECTION_NAME);
  }
  Iterators$2[COLLECTION_NAME] = Iterators$2.Array;
}

var parent$J = symbol$5;


var symbol$4 = parent$J;

var symbol$3 = symbol$4;

var _Symbol$1 = /*@__PURE__*/getDefaultExportFromCjs(symbol$3);

var $$A = _export;
var isArray$7 = isArray$b;
var isConstructor = isConstructor$2;
var isObject$7 = isObject$h;
var toAbsoluteIndex$2 = toAbsoluteIndex$5;
var lengthOfArrayLike$5 = lengthOfArrayLike$a;
var toIndexedObject$2 = toIndexedObject$a;
var createProperty$2 = createProperty$5;
var wellKnownSymbol$7 = wellKnownSymbol$l;
var arrayMethodHasSpeciesSupport$3 = arrayMethodHasSpeciesSupport$5;
var nativeSlice = arraySlice$5;

var HAS_SPECIES_SUPPORT$3 = arrayMethodHasSpeciesSupport$3('slice');

var SPECIES$1 = wellKnownSymbol$7('species');
var $Array = Array;
var max$1 = Math.max;

// `Array.prototype.slice` method
// https://tc39.es/ecma262/#sec-array.prototype.slice
// fallback for not array-like ES3 strings and DOM objects
$$A({ target: 'Array', proto: true, forced: !HAS_SPECIES_SUPPORT$3 }, {
  slice: function slice(start, end) {
    var O = toIndexedObject$2(this);
    var length = lengthOfArrayLike$5(O);
    var k = toAbsoluteIndex$2(start, length);
    var fin = toAbsoluteIndex$2(end === undefined ? length : end, length);
    // inline `ArraySpeciesCreate` for usage native `Array#slice` where it's possible
    var Constructor, result, n;
    if (isArray$7(O)) {
      Constructor = O.constructor;
      // cross-realm fallback
      if (isConstructor(Constructor) && (Constructor === $Array || isArray$7(Constructor.prototype))) {
        Constructor = undefined;
      } else if (isObject$7(Constructor)) {
        Constructor = Constructor[SPECIES$1];
        if (Constructor === null) Constructor = undefined;
      }
      if (Constructor === $Array || Constructor === undefined) {
        return nativeSlice(O, k, fin);
      }
    }
    result = new (Constructor === undefined ? $Array : Constructor)(max$1(fin - k, 0));
    for (n = 0; k < fin; k++, n++) if (k in O) createProperty$2(result, n, O[k]);
    result.length = n;
    return result;
  }
});

var entryVirtual$f = entryVirtual$h;

var slice$3 = entryVirtual$f('Array').slice;

var isPrototypeOf$g = objectIsPrototypeOf;
var method$d = slice$3;

var ArrayPrototype$f = Array.prototype;

var slice$2 = function (it) {
  var own = it.slice;
  return it === ArrayPrototype$f || (isPrototypeOf$g(ArrayPrototype$f, it) && own === ArrayPrototype$f.slice) ? method$d : own;
};

var parent$I = slice$2;

var slice$1 = parent$I;

var slice = slice$1;

var _sliceInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(slice);

var getBuiltIn$3 = getBuiltIn$b;
var uncurryThis$e = functionUncurryThis;
var getOwnPropertyNamesModule$1 = objectGetOwnPropertyNames;
var getOwnPropertySymbolsModule = objectGetOwnPropertySymbols;
var anObject$4 = anObject$9;

var concat$4 = uncurryThis$e([].concat);

// all object keys, includes non-enumerable and symbols
var ownKeys$5 = getBuiltIn$3('Reflect', 'ownKeys') || function ownKeys(it) {
  var keys = getOwnPropertyNamesModule$1.f(anObject$4(it));
  var getOwnPropertySymbols = getOwnPropertySymbolsModule.f;
  return getOwnPropertySymbols ? concat$4(keys, getOwnPropertySymbols(it)) : keys;
};

var $$z = _export;
var isArray$6 = isArray$b;

// `Array.isArray` method
// https://tc39.es/ecma262/#sec-array.isarray
$$z({ target: 'Array', stat: true }, {
  isArray: isArray$6
});

var path$l = path$s;

var isArray$5 = path$l.Array.isArray;

var parent$H = isArray$5;

var isArray$4 = parent$H;

var isArray$3 = isArray$4;

var _Array$isArray = /*@__PURE__*/getDefaultExportFromCjs(isArray$3);

var $$y = _export;
var $map = arrayIteration.map;
var arrayMethodHasSpeciesSupport$2 = arrayMethodHasSpeciesSupport$5;

var HAS_SPECIES_SUPPORT$2 = arrayMethodHasSpeciesSupport$2('map');

// `Array.prototype.map` method
// https://tc39.es/ecma262/#sec-array.prototype.map
// with adding support of @@species
$$y({ target: 'Array', proto: true, forced: !HAS_SPECIES_SUPPORT$2 }, {
  map: function map(callbackfn /* , thisArg */) {
    return $map(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
  }
});

var entryVirtual$e = entryVirtual$h;

var map$6 = entryVirtual$e('Array').map;

var isPrototypeOf$f = objectIsPrototypeOf;
var method$c = map$6;

var ArrayPrototype$e = Array.prototype;

var map$5 = function (it) {
  var own = it.map;
  return it === ArrayPrototype$e || (isPrototypeOf$f(ArrayPrototype$e, it) && own === ArrayPrototype$e.map) ? method$c : own;
};

var parent$G = map$5;

var map$4 = parent$G;

var map$3 = map$4;

var _mapInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(map$3);

var $$x = _export;
var toObject$5 = toObject$c;
var nativeKeys = objectKeys$3;
var fails$d = fails$u;

var FAILS_ON_PRIMITIVES$3 = fails$d(function () { nativeKeys(1); });

// `Object.keys` method
// https://tc39.es/ecma262/#sec-object.keys
$$x({ target: 'Object', stat: true, forced: FAILS_ON_PRIMITIVES$3 }, {
  keys: function keys(it) {
    return nativeKeys(toObject$5(it));
  }
});

var path$k = path$s;

var keys$2 = path$k.Object.keys;

var parent$F = keys$2;

var keys$1 = parent$F;

var keys = keys$1;

var _Object$keys = /*@__PURE__*/getDefaultExportFromCjs(keys);

// TODO: Remove from `core-js@4`
var $$w = _export;
var uncurryThis$d = functionUncurryThis;

var $Date = Date;
var thisTimeValue = uncurryThis$d($Date.prototype.getTime);

// `Date.now` method
// https://tc39.es/ecma262/#sec-date.now
$$w({ target: 'Date', stat: true }, {
  now: function now() {
    return thisTimeValue(new $Date());
  }
});

var path$j = path$s;

var now$3 = path$j.Date.now;

var parent$E = now$3;

var now$2 = parent$E;

var now$1 = now$2;

var _Date$now = /*@__PURE__*/getDefaultExportFromCjs(now$1);

var fails$c = fails$u;

var arrayMethodIsStrict$6 = function (METHOD_NAME, argument) {
  var method = [][METHOD_NAME];
  return !!method && fails$c(function () {
    // eslint-disable-next-line no-useless-call -- required for testing
    method.call(null, argument || function () { return 1; }, 1);
  });
};

var $forEach = arrayIteration.forEach;
var arrayMethodIsStrict$5 = arrayMethodIsStrict$6;

var STRICT_METHOD$3 = arrayMethodIsStrict$5('forEach');

// `Array.prototype.forEach` method implementation
// https://tc39.es/ecma262/#sec-array.prototype.foreach
var arrayForEach = !STRICT_METHOD$3 ? function forEach(callbackfn /* , thisArg */) {
  return $forEach(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
// eslint-disable-next-line es/no-array-prototype-foreach -- safe
} : [].forEach;

var $$v = _export;
var forEach$6 = arrayForEach;

// `Array.prototype.forEach` method
// https://tc39.es/ecma262/#sec-array.prototype.foreach
// eslint-disable-next-line es/no-array-prototype-foreach -- safe
$$v({ target: 'Array', proto: true, forced: [].forEach !== forEach$6 }, {
  forEach: forEach$6
});

var entryVirtual$d = entryVirtual$h;

var forEach$5 = entryVirtual$d('Array').forEach;

var parent$D = forEach$5;

var forEach$4 = parent$D;

var classof$5 = classof$c;
var hasOwn$3 = hasOwnProperty_1;
var isPrototypeOf$e = objectIsPrototypeOf;
var method$b = forEach$4;

var ArrayPrototype$d = Array.prototype;

var DOMIterables$1 = {
  DOMTokenList: true,
  NodeList: true
};

var forEach$3 = function (it) {
  var own = it.forEach;
  return it === ArrayPrototype$d || (isPrototypeOf$e(ArrayPrototype$d, it) && own === ArrayPrototype$d.forEach)
    || hasOwn$3(DOMIterables$1, classof$5(it)) ? method$b : own;
};

var forEach$2 = forEach$3;

var _forEachInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(forEach$2);

var $$u = _export;
var uncurryThis$c = functionUncurryThis;
var isArray$2 = isArray$b;

var nativeReverse = uncurryThis$c([].reverse);
var test$1 = [1, 2];

// `Array.prototype.reverse` method
// https://tc39.es/ecma262/#sec-array.prototype.reverse
// fix for Safari 12.0 bug
// https://bugs.webkit.org/show_bug.cgi?id=188794
$$u({ target: 'Array', proto: true, forced: String(test$1) === String(test$1.reverse()) }, {
  reverse: function reverse() {
    // eslint-disable-next-line no-self-assign -- dirty hack
    if (isArray$2(this)) this.length = this.length;
    return nativeReverse(this);
  }
});

var entryVirtual$c = entryVirtual$h;

var reverse$3 = entryVirtual$c('Array').reverse;

var isPrototypeOf$d = objectIsPrototypeOf;
var method$a = reverse$3;

var ArrayPrototype$c = Array.prototype;

var reverse$2 = function (it) {
  var own = it.reverse;
  return it === ArrayPrototype$c || (isPrototypeOf$d(ArrayPrototype$c, it) && own === ArrayPrototype$c.reverse) ? method$a : own;
};

var parent$C = reverse$2;

var reverse$1 = parent$C;

var reverse = reverse$1;

var _reverseInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(reverse);

var DESCRIPTORS$8 = descriptors;
var isArray$1 = isArray$b;

var $TypeError$7 = TypeError;
// eslint-disable-next-line es/no-object-getownpropertydescriptor -- safe
var getOwnPropertyDescriptor$4 = Object.getOwnPropertyDescriptor;

// Safari < 13 does not throw an error in this case
var SILENT_ON_NON_WRITABLE_LENGTH_SET = DESCRIPTORS$8 && !function () {
  // makes no sense without proper strict mode support
  if (this !== undefined) return true;
  try {
    // eslint-disable-next-line es/no-object-defineproperty -- safe
    Object.defineProperty([], 'length', { writable: false }).length = 1;
  } catch (error) {
    return error instanceof TypeError;
  }
}();

var arraySetLength = SILENT_ON_NON_WRITABLE_LENGTH_SET ? function (O, length) {
  if (isArray$1(O) && !getOwnPropertyDescriptor$4(O, 'length').writable) {
    throw new $TypeError$7('Cannot set read only .length');
  } return O.length = length;
} : function (O, length) {
  return O.length = length;
};

var tryToString$2 = tryToString$5;

var $TypeError$6 = TypeError;

var deletePropertyOrThrow$2 = function (O, P) {
  if (!delete O[P]) throw new $TypeError$6('Cannot delete property ' + tryToString$2(P) + ' of ' + tryToString$2(O));
};

var $$t = _export;
var toObject$4 = toObject$c;
var toAbsoluteIndex$1 = toAbsoluteIndex$5;
var toIntegerOrInfinity$1 = toIntegerOrInfinity$4;
var lengthOfArrayLike$4 = lengthOfArrayLike$a;
var setArrayLength = arraySetLength;
var doesNotExceedSafeInteger = doesNotExceedSafeInteger$2;
var arraySpeciesCreate = arraySpeciesCreate$3;
var createProperty$1 = createProperty$5;
var deletePropertyOrThrow$1 = deletePropertyOrThrow$2;
var arrayMethodHasSpeciesSupport$1 = arrayMethodHasSpeciesSupport$5;

var HAS_SPECIES_SUPPORT$1 = arrayMethodHasSpeciesSupport$1('splice');

var max = Math.max;
var min = Math.min;

// `Array.prototype.splice` method
// https://tc39.es/ecma262/#sec-array.prototype.splice
// with adding support of @@species
$$t({ target: 'Array', proto: true, forced: !HAS_SPECIES_SUPPORT$1 }, {
  splice: function splice(start, deleteCount /* , ...items */) {
    var O = toObject$4(this);
    var len = lengthOfArrayLike$4(O);
    var actualStart = toAbsoluteIndex$1(start, len);
    var argumentsLength = arguments.length;
    var insertCount, actualDeleteCount, A, k, from, to;
    if (argumentsLength === 0) {
      insertCount = actualDeleteCount = 0;
    } else if (argumentsLength === 1) {
      insertCount = 0;
      actualDeleteCount = len - actualStart;
    } else {
      insertCount = argumentsLength - 2;
      actualDeleteCount = min(max(toIntegerOrInfinity$1(deleteCount), 0), len - actualStart);
    }
    doesNotExceedSafeInteger(len + insertCount - actualDeleteCount);
    A = arraySpeciesCreate(O, actualDeleteCount);
    for (k = 0; k < actualDeleteCount; k++) {
      from = actualStart + k;
      if (from in O) createProperty$1(A, k, O[from]);
    }
    A.length = actualDeleteCount;
    if (insertCount < actualDeleteCount) {
      for (k = actualStart; k < len - actualDeleteCount; k++) {
        from = k + actualDeleteCount;
        to = k + insertCount;
        if (from in O) O[to] = O[from];
        else deletePropertyOrThrow$1(O, to);
      }
      for (k = len; k > len - actualDeleteCount + insertCount; k--) deletePropertyOrThrow$1(O, k - 1);
    } else if (insertCount > actualDeleteCount) {
      for (k = len - actualDeleteCount; k > actualStart; k--) {
        from = k + actualDeleteCount - 1;
        to = k + insertCount - 1;
        if (from in O) O[to] = O[from];
        else deletePropertyOrThrow$1(O, to);
      }
    }
    for (k = 0; k < insertCount; k++) {
      O[k + actualStart] = arguments[k + 2];
    }
    setArrayLength(O, len - actualDeleteCount + insertCount);
    return A;
  }
});

var entryVirtual$b = entryVirtual$h;

var splice$4 = entryVirtual$b('Array').splice;

var isPrototypeOf$c = objectIsPrototypeOf;
var method$9 = splice$4;

var ArrayPrototype$b = Array.prototype;

var splice$3 = function (it) {
  var own = it.splice;
  return it === ArrayPrototype$b || (isPrototypeOf$c(ArrayPrototype$b, it) && own === ArrayPrototype$b.splice) ? method$9 : own;
};

var parent$B = splice$3;

var splice$2 = parent$B;

var splice$1 = splice$2;

var _spliceInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(splice$1);

var $$s = _export;
var $includes = arrayIncludes.includes;
var fails$b = fails$u;

// FF99+ bug
var BROKEN_ON_SPARSE = fails$b(function () {
  // eslint-disable-next-line es/no-array-prototype-includes -- detection
  return !Array(1).includes();
});

// `Array.prototype.includes` method
// https://tc39.es/ecma262/#sec-array.prototype.includes
$$s({ target: 'Array', proto: true, forced: BROKEN_ON_SPARSE }, {
  includes: function includes(el /* , fromIndex = 0 */) {
    return $includes(this, el, arguments.length > 1 ? arguments[1] : undefined);
  }
});

var entryVirtual$a = entryVirtual$h;

var includes$4 = entryVirtual$a('Array').includes;

var isObject$6 = isObject$h;
var classof$4 = classofRaw$2;
var wellKnownSymbol$6 = wellKnownSymbol$l;

var MATCH$1 = wellKnownSymbol$6('match');

// `IsRegExp` abstract operation
// https://tc39.es/ecma262/#sec-isregexp
var isRegexp = function (it) {
  var isRegExp;
  return isObject$6(it) && ((isRegExp = it[MATCH$1]) !== undefined ? !!isRegExp : classof$4(it) === 'RegExp');
};

var isRegExp = isRegexp;

var $TypeError$5 = TypeError;

var notARegexp = function (it) {
  if (isRegExp(it)) {
    throw new $TypeError$5("The method doesn't accept regular expressions");
  } return it;
};

var wellKnownSymbol$5 = wellKnownSymbol$l;

var MATCH = wellKnownSymbol$5('match');

var correctIsRegexpLogic = function (METHOD_NAME) {
  var regexp = /./;
  try {
    '/./'[METHOD_NAME](regexp);
  } catch (error1) {
    try {
      regexp[MATCH] = false;
      return '/./'[METHOD_NAME](regexp);
    } catch (error2) { /* empty */ }
  } return false;
};

var $$r = _export;
var uncurryThis$b = functionUncurryThis;
var notARegExp = notARegexp;
var requireObjectCoercible$2 = requireObjectCoercible$5;
var toString$6 = toString$a;
var correctIsRegExpLogic = correctIsRegexpLogic;

var stringIndexOf = uncurryThis$b(''.indexOf);

// `String.prototype.includes` method
// https://tc39.es/ecma262/#sec-string.prototype.includes
$$r({ target: 'String', proto: true, forced: !correctIsRegExpLogic('includes') }, {
  includes: function includes(searchString /* , position = 0 */) {
    return !!~stringIndexOf(
      toString$6(requireObjectCoercible$2(this)),
      toString$6(notARegExp(searchString)),
      arguments.length > 1 ? arguments[1] : undefined
    );
  }
});

var entryVirtual$9 = entryVirtual$h;

var includes$3 = entryVirtual$9('String').includes;

var isPrototypeOf$b = objectIsPrototypeOf;
var arrayMethod = includes$4;
var stringMethod = includes$3;

var ArrayPrototype$a = Array.prototype;
var StringPrototype = String.prototype;

var includes$2 = function (it) {
  var own = it.includes;
  if (it === ArrayPrototype$a || (isPrototypeOf$b(ArrayPrototype$a, it) && own === ArrayPrototype$a.includes)) return arrayMethod;
  if (typeof it == 'string' || it === StringPrototype || (isPrototypeOf$b(StringPrototype, it) && own === StringPrototype.includes)) {
    return stringMethod;
  } return own;
};

var parent$A = includes$2;

var includes$1 = parent$A;

var includes = includes$1;

var _includesInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(includes);

var $$q = _export;
var fails$a = fails$u;
var toObject$3 = toObject$c;
var nativeGetPrototypeOf = objectGetPrototypeOf;
var CORRECT_PROTOTYPE_GETTER = correctPrototypeGetter;

var FAILS_ON_PRIMITIVES$2 = fails$a(function () { nativeGetPrototypeOf(1); });

// `Object.getPrototypeOf` method
// https://tc39.es/ecma262/#sec-object.getprototypeof
$$q({ target: 'Object', stat: true, forced: FAILS_ON_PRIMITIVES$2, sham: !CORRECT_PROTOTYPE_GETTER }, {
  getPrototypeOf: function getPrototypeOf(it) {
    return nativeGetPrototypeOf(toObject$3(it));
  }
});

var path$i = path$s;

var getPrototypeOf$2 = path$i.Object.getPrototypeOf;

var parent$z = getPrototypeOf$2;

var getPrototypeOf$1 = parent$z;

var getPrototypeOf = getPrototypeOf$1;

var _Object$getPrototypeOf = /*@__PURE__*/getDefaultExportFromCjs(getPrototypeOf);

var entryVirtual$8 = entryVirtual$h;

var concat$3 = entryVirtual$8('Array').concat;

var isPrototypeOf$a = objectIsPrototypeOf;
var method$8 = concat$3;

var ArrayPrototype$9 = Array.prototype;

var concat$2 = function (it) {
  var own = it.concat;
  return it === ArrayPrototype$9 || (isPrototypeOf$a(ArrayPrototype$9, it) && own === ArrayPrototype$9.concat) ? method$8 : own;
};

var parent$y = concat$2;

var concat$1 = parent$y;

var concat = concat$1;

var _concatInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(concat);

var $$p = _export;
var $filter = arrayIteration.filter;
var arrayMethodHasSpeciesSupport = arrayMethodHasSpeciesSupport$5;

var HAS_SPECIES_SUPPORT = arrayMethodHasSpeciesSupport('filter');

// `Array.prototype.filter` method
// https://tc39.es/ecma262/#sec-array.prototype.filter
// with adding support of @@species
$$p({ target: 'Array', proto: true, forced: !HAS_SPECIES_SUPPORT }, {
  filter: function filter(callbackfn /* , thisArg */) {
    return $filter(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
  }
});

var entryVirtual$7 = entryVirtual$h;

var filter$3 = entryVirtual$7('Array').filter;

var isPrototypeOf$9 = objectIsPrototypeOf;
var method$7 = filter$3;

var ArrayPrototype$8 = Array.prototype;

var filter$2 = function (it) {
  var own = it.filter;
  return it === ArrayPrototype$8 || (isPrototypeOf$9(ArrayPrototype$8, it) && own === ArrayPrototype$8.filter) ? method$7 : own;
};

var parent$x = filter$2;

var filter$1 = parent$x;

var filter = filter$1;

var _filterInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(filter);

// a string of all valid unicode whitespaces
var whitespaces$3 = '\u0009\u000A\u000B\u000C\u000D\u0020\u00A0\u1680\u2000\u2001\u2002' +
  '\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200A\u202F\u205F\u3000\u2028\u2029\uFEFF';

var uncurryThis$a = functionUncurryThis;
var requireObjectCoercible$1 = requireObjectCoercible$5;
var toString$5 = toString$a;
var whitespaces$2 = whitespaces$3;

var replace = uncurryThis$a(''.replace);
var ltrim = RegExp('^[' + whitespaces$2 + ']+');
var rtrim = RegExp('(^|[^' + whitespaces$2 + '])[' + whitespaces$2 + ']+$');

// `String.prototype.{ trim, trimStart, trimEnd, trimLeft, trimRight }` methods implementation
var createMethod$2 = function (TYPE) {
  return function ($this) {
    var string = toString$5(requireObjectCoercible$1($this));
    if (TYPE & 1) string = replace(string, ltrim, '');
    if (TYPE & 2) string = replace(string, rtrim, '$1');
    return string;
  };
};

var stringTrim = {
  // `String.prototype.{ trimLeft, trimStart }` methods
  // https://tc39.es/ecma262/#sec-string.prototype.trimstart
  start: createMethod$2(1),
  // `String.prototype.{ trimRight, trimEnd }` methods
  // https://tc39.es/ecma262/#sec-string.prototype.trimend
  end: createMethod$2(2),
  // `String.prototype.trim` method
  // https://tc39.es/ecma262/#sec-string.prototype.trim
  trim: createMethod$2(3)
};

var global$9 = global$n;
var fails$9 = fails$u;
var uncurryThis$9 = functionUncurryThis;
var toString$4 = toString$a;
var trim$1 = stringTrim.trim;
var whitespaces$1 = whitespaces$3;

var $parseInt$1 = global$9.parseInt;
var Symbol$4 = global$9.Symbol;
var ITERATOR$3 = Symbol$4 && Symbol$4.iterator;
var hex = /^[+-]?0x/i;
var exec = uncurryThis$9(hex.exec);
var FORCED$6 = $parseInt$1(whitespaces$1 + '08') !== 8 || $parseInt$1(whitespaces$1 + '0x16') !== 22
  // MS Edge 18- broken with boxed symbols
  || (ITERATOR$3 && !fails$9(function () { $parseInt$1(Object(ITERATOR$3)); }));

// `parseInt` method
// https://tc39.es/ecma262/#sec-parseint-string-radix
var numberParseInt = FORCED$6 ? function parseInt(string, radix) {
  var S = trim$1(toString$4(string));
  return $parseInt$1(S, (radix >>> 0) || (exec(hex, S) ? 16 : 10));
} : $parseInt$1;

var $$o = _export;
var $parseInt = numberParseInt;

// `parseInt` method
// https://tc39.es/ecma262/#sec-parseint-string-radix
$$o({ global: true, forced: parseInt !== $parseInt }, {
  parseInt: $parseInt
});

var path$h = path$s;

var _parseInt$3 = path$h.parseInt;

var parent$w = _parseInt$3;

var _parseInt$2 = parent$w;

var _parseInt = _parseInt$2;

var _parseInt$1 = /*@__PURE__*/getDefaultExportFromCjs(_parseInt);

/* eslint-disable es/no-array-prototype-indexof -- required for testing */
var $$n = _export;
var uncurryThis$8 = functionUncurryThisClause;
var $indexOf = arrayIncludes.indexOf;
var arrayMethodIsStrict$4 = arrayMethodIsStrict$6;

var nativeIndexOf = uncurryThis$8([].indexOf);

var NEGATIVE_ZERO = !!nativeIndexOf && 1 / nativeIndexOf([1], 1, -0) < 0;
var FORCED$5 = NEGATIVE_ZERO || !arrayMethodIsStrict$4('indexOf');

// `Array.prototype.indexOf` method
// https://tc39.es/ecma262/#sec-array.prototype.indexof
$$n({ target: 'Array', proto: true, forced: FORCED$5 }, {
  indexOf: function indexOf(searchElement /* , fromIndex = 0 */) {
    var fromIndex = arguments.length > 1 ? arguments[1] : undefined;
    return NEGATIVE_ZERO
      // convert -0 to +0
      ? nativeIndexOf(this, searchElement, fromIndex) || 0
      : $indexOf(this, searchElement, fromIndex);
  }
});

var entryVirtual$6 = entryVirtual$h;

var indexOf$3 = entryVirtual$6('Array').indexOf;

var isPrototypeOf$8 = objectIsPrototypeOf;
var method$6 = indexOf$3;

var ArrayPrototype$7 = Array.prototype;

var indexOf$2 = function (it) {
  var own = it.indexOf;
  return it === ArrayPrototype$7 || (isPrototypeOf$8(ArrayPrototype$7, it) && own === ArrayPrototype$7.indexOf) ? method$6 : own;
};

var parent$v = indexOf$2;

var indexOf$1 = parent$v;

var indexOf = indexOf$1;

var _indexOfInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(indexOf);

// TODO: Remove from `core-js@4`
var $$m = _export;
var DESCRIPTORS$7 = descriptors;
var create$4 = objectCreate;

// `Object.create` method
// https://tc39.es/ecma262/#sec-object.create
$$m({ target: 'Object', stat: true, sham: !DESCRIPTORS$7 }, {
  create: create$4
});

var path$g = path$s;

var Object$5 = path$g.Object;

var create$3 = function create(P, D) {
  return Object$5.create(P, D);
};

var parent$u = create$3;

var create$2 = parent$u;

var create$1 = create$2;

var _Object$create = /*@__PURE__*/getDefaultExportFromCjs(create$1);

var path$f = path$s;
var apply$1 = functionApply;

// eslint-disable-next-line es/no-json -- safe
if (!path$f.JSON) path$f.JSON = { stringify: JSON.stringify };

// eslint-disable-next-line no-unused-vars -- required for `.length`
var stringify$2 = function stringify(it, replacer, space) {
  return apply$1(path$f.JSON.stringify, null, arguments);
};

var parent$t = stringify$2;

var stringify$1 = parent$t;

var stringify = stringify$1;

var _JSON$stringify = /*@__PURE__*/getDefaultExportFromCjs(stringify);

/* global Bun -- Deno case */
var engineIsBun = typeof Bun == 'function' && Bun && typeof Bun.version == 'string';

var $TypeError$4 = TypeError;

var validateArgumentsLength$1 = function (passed, required) {
  if (passed < required) throw new $TypeError$4('Not enough arguments');
  return passed;
};

var global$8 = global$n;
var apply = functionApply;
var isCallable$1 = isCallable$h;
var ENGINE_IS_BUN = engineIsBun;
var USER_AGENT = engineUserAgent;
var arraySlice$1 = arraySlice$5;
var validateArgumentsLength = validateArgumentsLength$1;

var Function$1 = global$8.Function;
// dirty IE9- and Bun 0.3.0- checks
var WRAP = /MSIE .\./.test(USER_AGENT) || ENGINE_IS_BUN && (function () {
  var version = global$8.Bun.version.split('.');
  return version.length < 3 || version[0] === '0' && (version[1] < 3 || version[1] === '3' && version[2] === '0');
})();

// IE9- / Bun 0.3.0- setTimeout / setInterval / setImmediate additional parameters fix
// https://html.spec.whatwg.org/multipage/timers-and-user-prompts.html#timers
// https://github.com/oven-sh/bun/issues/1633
var schedulersFix$2 = function (scheduler, hasTimeArg) {
  var firstParamIndex = hasTimeArg ? 2 : 1;
  return WRAP ? function (handler, timeout /* , ...arguments */) {
    var boundArgs = validateArgumentsLength(arguments.length, 1) > firstParamIndex;
    var fn = isCallable$1(handler) ? handler : Function$1(handler);
    var params = boundArgs ? arraySlice$1(arguments, firstParamIndex) : [];
    var callback = boundArgs ? function () {
      apply(fn, this, params);
    } : fn;
    return hasTimeArg ? scheduler(callback, timeout) : scheduler(callback);
  } : scheduler;
};

var $$l = _export;
var global$7 = global$n;
var schedulersFix$1 = schedulersFix$2;

var setInterval$2 = schedulersFix$1(global$7.setInterval, true);

// Bun / IE9- setInterval additional parameters fix
// https://html.spec.whatwg.org/multipage/timers-and-user-prompts.html#dom-setinterval
$$l({ global: true, bind: true, forced: global$7.setInterval !== setInterval$2 }, {
  setInterval: setInterval$2
});

var $$k = _export;
var global$6 = global$n;
var schedulersFix = schedulersFix$2;

var setTimeout$3 = schedulersFix(global$6.setTimeout, true);

// Bun / IE9- setTimeout additional parameters fix
// https://html.spec.whatwg.org/multipage/timers-and-user-prompts.html#dom-settimeout
$$k({ global: true, bind: true, forced: global$6.setTimeout !== setTimeout$3 }, {
  setTimeout: setTimeout$3
});

var path$e = path$s;

var setTimeout$2 = path$e.setTimeout;

var setTimeout$1 = setTimeout$2;

var _setTimeout = /*@__PURE__*/getDefaultExportFromCjs(setTimeout$1);

var toObject$2 = toObject$c;
var toAbsoluteIndex = toAbsoluteIndex$5;
var lengthOfArrayLike$3 = lengthOfArrayLike$a;

// `Array.prototype.fill` method implementation
// https://tc39.es/ecma262/#sec-array.prototype.fill
var arrayFill = function fill(value /* , start = 0, end = @length */) {
  var O = toObject$2(this);
  var length = lengthOfArrayLike$3(O);
  var argumentsLength = arguments.length;
  var index = toAbsoluteIndex(argumentsLength > 1 ? arguments[1] : undefined, length);
  var end = argumentsLength > 2 ? arguments[2] : undefined;
  var endPos = end === undefined ? length : toAbsoluteIndex(end, length);
  while (endPos > index) O[index++] = value;
  return O;
};

var $$j = _export;
var fill$4 = arrayFill;

// `Array.prototype.fill` method
// https://tc39.es/ecma262/#sec-array.prototype.fill
$$j({ target: 'Array', proto: true }, {
  fill: fill$4
});

var entryVirtual$5 = entryVirtual$h;

var fill$3 = entryVirtual$5('Array').fill;

var isPrototypeOf$7 = objectIsPrototypeOf;
var method$5 = fill$3;

var ArrayPrototype$6 = Array.prototype;

var fill$2 = function (it) {
  var own = it.fill;
  return it === ArrayPrototype$6 || (isPrototypeOf$7(ArrayPrototype$6, it) && own === ArrayPrototype$6.fill) ? method$5 : own;
};

var parent$s = fill$2;

var fill$1 = parent$s;

var fill = fill$1;

var _fillInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(fill);

/*! Hammer.JS - v2.0.17-rc - 2019-12-16
 * http://naver.github.io/egjs
 *
 * Forked By Naver egjs
 * Copyright (c) hammerjs
 * Licensed under the MIT license */
function _extends() {
  _extends = Object.assign || function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];

      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }

    return target;
  };

  return _extends.apply(this, arguments);
}

function _inheritsLoose(subClass, superClass) {
  subClass.prototype = Object.create(superClass.prototype);
  subClass.prototype.constructor = subClass;
  subClass.__proto__ = superClass;
}

function _assertThisInitialized(self) {
  if (self === void 0) {
    throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
  }

  return self;
}

/**
 * @private
 * extend object.
 * means that properties in dest will be overwritten by the ones in src.
 * @param {Object} target
 * @param {...Object} objects_to_assign
 * @returns {Object} target
 */
var assign;

if (typeof Object.assign !== 'function') {
  assign = function assign(target) {
    if (target === undefined || target === null) {
      throw new TypeError('Cannot convert undefined or null to object');
    }

    var output = Object(target);

    for (var index = 1; index < arguments.length; index++) {
      var source = arguments[index];

      if (source !== undefined && source !== null) {
        for (var nextKey in source) {
          if (source.hasOwnProperty(nextKey)) {
            output[nextKey] = source[nextKey];
          }
        }
      }
    }

    return output;
  };
} else {
  assign = Object.assign;
}

var assign$1 = assign;

var VENDOR_PREFIXES = ['', 'webkit', 'Moz', 'MS', 'ms', 'o'];
var TEST_ELEMENT = typeof document === "undefined" ? {
  style: {}
} : document.createElement('div');
var TYPE_FUNCTION = 'function';
var round = Math.round,
    abs$1 = Math.abs;
var now = Date.now;

/**
 * @private
 * get the prefixed property
 * @param {Object} obj
 * @param {String} property
 * @returns {String|Undefined} prefixed
 */

function prefixed(obj, property) {
  var prefix;
  var prop;
  var camelProp = property[0].toUpperCase() + property.slice(1);
  var i = 0;

  while (i < VENDOR_PREFIXES.length) {
    prefix = VENDOR_PREFIXES[i];
    prop = prefix ? prefix + camelProp : property;

    if (prop in obj) {
      return prop;
    }

    i++;
  }

  return undefined;
}

/* eslint-disable no-new-func, no-nested-ternary */
var win;

if (typeof window === "undefined") {
  // window is undefined in node.js
  win = {};
} else {
  win = window;
}

var PREFIXED_TOUCH_ACTION = prefixed(TEST_ELEMENT.style, 'touchAction');
var NATIVE_TOUCH_ACTION = PREFIXED_TOUCH_ACTION !== undefined;
function getTouchActionProps() {
  if (!NATIVE_TOUCH_ACTION) {
    return false;
  }

  var touchMap = {};
  var cssSupports = win.CSS && win.CSS.supports;
  ['auto', 'manipulation', 'pan-y', 'pan-x', 'pan-x pan-y', 'none'].forEach(function (val) {
    // If css.supports is not supported but there is native touch-action assume it supports
    // all values. This is the case for IE 10 and 11.
    return touchMap[val] = cssSupports ? win.CSS.supports('touch-action', val) : true;
  });
  return touchMap;
}

var TOUCH_ACTION_COMPUTE = 'compute';
var TOUCH_ACTION_AUTO = 'auto';
var TOUCH_ACTION_MANIPULATION = 'manipulation'; // not implemented

var TOUCH_ACTION_NONE = 'none';
var TOUCH_ACTION_PAN_X = 'pan-x';
var TOUCH_ACTION_PAN_Y = 'pan-y';
var TOUCH_ACTION_MAP = getTouchActionProps();

var MOBILE_REGEX = /mobile|tablet|ip(ad|hone|od)|android/i;
var SUPPORT_TOUCH = 'ontouchstart' in win;
var SUPPORT_POINTER_EVENTS = prefixed(win, 'PointerEvent') !== undefined;
var SUPPORT_ONLY_TOUCH = SUPPORT_TOUCH && MOBILE_REGEX.test(navigator.userAgent);
var INPUT_TYPE_TOUCH = 'touch';
var INPUT_TYPE_PEN = 'pen';
var INPUT_TYPE_MOUSE = 'mouse';
var INPUT_TYPE_KINECT = 'kinect';
var COMPUTE_INTERVAL = 25;
var INPUT_START = 1;
var INPUT_MOVE = 2;
var INPUT_END = 4;
var INPUT_CANCEL = 8;
var DIRECTION_NONE = 1;
var DIRECTION_LEFT = 2;
var DIRECTION_RIGHT = 4;
var DIRECTION_UP = 8;
var DIRECTION_DOWN = 16;
var DIRECTION_HORIZONTAL = DIRECTION_LEFT | DIRECTION_RIGHT;
var DIRECTION_VERTICAL = DIRECTION_UP | DIRECTION_DOWN;
var DIRECTION_ALL = DIRECTION_HORIZONTAL | DIRECTION_VERTICAL;
var PROPS_XY = ['x', 'y'];
var PROPS_CLIENT_XY = ['clientX', 'clientY'];

/**
 * @private
 * walk objects and arrays
 * @param {Object} obj
 * @param {Function} iterator
 * @param {Object} context
 */
function each(obj, iterator, context) {
  var i;

  if (!obj) {
    return;
  }

  if (obj.forEach) {
    obj.forEach(iterator, context);
  } else if (obj.length !== undefined) {
    i = 0;

    while (i < obj.length) {
      iterator.call(context, obj[i], i, obj);
      i++;
    }
  } else {
    for (i in obj) {
      obj.hasOwnProperty(i) && iterator.call(context, obj[i], i, obj);
    }
  }
}

/**
 * @private
 * let a boolean value also be a function that must return a boolean
 * this first item in args will be used as the context
 * @param {Boolean|Function} val
 * @param {Array} [args]
 * @returns {Boolean}
 */

function boolOrFn(val, args) {
  if (typeof val === TYPE_FUNCTION) {
    return val.apply(args ? args[0] || undefined : undefined, args);
  }

  return val;
}

/**
 * @private
 * small indexOf wrapper
 * @param {String} str
 * @param {String} find
 * @returns {Boolean} found
 */
function inStr(str, find) {
  return str.indexOf(find) > -1;
}

/**
 * @private
 * when the touchActions are collected they are not a valid value, so we need to clean things up. *
 * @param {String} actions
 * @returns {*}
 */

function cleanTouchActions(actions) {
  // none
  if (inStr(actions, TOUCH_ACTION_NONE)) {
    return TOUCH_ACTION_NONE;
  }

  var hasPanX = inStr(actions, TOUCH_ACTION_PAN_X);
  var hasPanY = inStr(actions, TOUCH_ACTION_PAN_Y); // if both pan-x and pan-y are set (different recognizers
  // for different directions, e.g. horizontal pan but vertical swipe?)
  // we need none (as otherwise with pan-x pan-y combined none of these
  // recognizers will work, since the browser would handle all panning

  if (hasPanX && hasPanY) {
    return TOUCH_ACTION_NONE;
  } // pan-x OR pan-y


  if (hasPanX || hasPanY) {
    return hasPanX ? TOUCH_ACTION_PAN_X : TOUCH_ACTION_PAN_Y;
  } // manipulation


  if (inStr(actions, TOUCH_ACTION_MANIPULATION)) {
    return TOUCH_ACTION_MANIPULATION;
  }

  return TOUCH_ACTION_AUTO;
}

/**
 * @private
 * Touch Action
 * sets the touchAction property or uses the js alternative
 * @param {Manager} manager
 * @param {String} value
 * @constructor
 */

var TouchAction =
/*#__PURE__*/
function () {
  function TouchAction(manager, value) {
    this.manager = manager;
    this.set(value);
  }
  /**
   * @private
   * set the touchAction value on the element or enable the polyfill
   * @param {String} value
   */


  var _proto = TouchAction.prototype;

  _proto.set = function set(value) {
    // find out the touch-action by the event handlers
    if (value === TOUCH_ACTION_COMPUTE) {
      value = this.compute();
    }

    if (NATIVE_TOUCH_ACTION && this.manager.element.style && TOUCH_ACTION_MAP[value]) {
      this.manager.element.style[PREFIXED_TOUCH_ACTION] = value;
    }

    this.actions = value.toLowerCase().trim();
  };
  /**
   * @private
   * just re-set the touchAction value
   */


  _proto.update = function update() {
    this.set(this.manager.options.touchAction);
  };
  /**
   * @private
   * compute the value for the touchAction property based on the recognizer's settings
   * @returns {String} value
   */


  _proto.compute = function compute() {
    var actions = [];
    each(this.manager.recognizers, function (recognizer) {
      if (boolOrFn(recognizer.options.enable, [recognizer])) {
        actions = actions.concat(recognizer.getTouchAction());
      }
    });
    return cleanTouchActions(actions.join(' '));
  };
  /**
   * @private
   * this method is called on each input cycle and provides the preventing of the browser behavior
   * @param {Object} input
   */


  _proto.preventDefaults = function preventDefaults(input) {
    var srcEvent = input.srcEvent;
    var direction = input.offsetDirection; // if the touch action did prevented once this session

    if (this.manager.session.prevented) {
      srcEvent.preventDefault();
      return;
    }

    var actions = this.actions;
    var hasNone = inStr(actions, TOUCH_ACTION_NONE) && !TOUCH_ACTION_MAP[TOUCH_ACTION_NONE];
    var hasPanY = inStr(actions, TOUCH_ACTION_PAN_Y) && !TOUCH_ACTION_MAP[TOUCH_ACTION_PAN_Y];
    var hasPanX = inStr(actions, TOUCH_ACTION_PAN_X) && !TOUCH_ACTION_MAP[TOUCH_ACTION_PAN_X];

    if (hasNone) {
      // do not prevent defaults if this is a tap gesture
      var isTapPointer = input.pointers.length === 1;
      var isTapMovement = input.distance < 2;
      var isTapTouchTime = input.deltaTime < 250;

      if (isTapPointer && isTapMovement && isTapTouchTime) {
        return;
      }
    }

    if (hasPanX && hasPanY) {
      // `pan-x pan-y` means browser handles all scrolling/panning, do not prevent
      return;
    }

    if (hasNone || hasPanY && direction & DIRECTION_HORIZONTAL || hasPanX && direction & DIRECTION_VERTICAL) {
      return this.preventSrc(srcEvent);
    }
  };
  /**
   * @private
   * call preventDefault to prevent the browser's default behavior (scrolling in most cases)
   * @param {Object} srcEvent
   */


  _proto.preventSrc = function preventSrc(srcEvent) {
    this.manager.session.prevented = true;
    srcEvent.preventDefault();
  };

  return TouchAction;
}();

/**
 * @private
 * find if a node is in the given parent
 * @method hasParent
 * @param {HTMLElement} node
 * @param {HTMLElement} parent
 * @return {Boolean} found
 */
function hasParent(node, parent) {
  while (node) {
    if (node === parent) {
      return true;
    }

    node = node.parentNode;
  }

  return false;
}

/**
 * @private
 * get the center of all the pointers
 * @param {Array} pointers
 * @return {Object} center contains `x` and `y` properties
 */

function getCenter(pointers) {
  var pointersLength = pointers.length; // no need to loop when only one touch

  if (pointersLength === 1) {
    return {
      x: round(pointers[0].clientX),
      y: round(pointers[0].clientY)
    };
  }

  var x = 0;
  var y = 0;
  var i = 0;

  while (i < pointersLength) {
    x += pointers[i].clientX;
    y += pointers[i].clientY;
    i++;
  }

  return {
    x: round(x / pointersLength),
    y: round(y / pointersLength)
  };
}

/**
 * @private
 * create a simple clone from the input used for storage of firstInput and firstMultiple
 * @param {Object} input
 * @returns {Object} clonedInputData
 */

function simpleCloneInputData(input) {
  // make a simple copy of the pointers because we will get a reference if we don't
  // we only need clientXY for the calculations
  var pointers = [];
  var i = 0;

  while (i < input.pointers.length) {
    pointers[i] = {
      clientX: round(input.pointers[i].clientX),
      clientY: round(input.pointers[i].clientY)
    };
    i++;
  }

  return {
    timeStamp: now(),
    pointers: pointers,
    center: getCenter(pointers),
    deltaX: input.deltaX,
    deltaY: input.deltaY
  };
}

/**
 * @private
 * calculate the absolute distance between two points
 * @param {Object} p1 {x, y}
 * @param {Object} p2 {x, y}
 * @param {Array} [props] containing x and y keys
 * @return {Number} distance
 */

function getDistance(p1, p2, props) {
  if (!props) {
    props = PROPS_XY;
  }

  var x = p2[props[0]] - p1[props[0]];
  var y = p2[props[1]] - p1[props[1]];
  return Math.sqrt(x * x + y * y);
}

/**
 * @private
 * calculate the angle between two coordinates
 * @param {Object} p1
 * @param {Object} p2
 * @param {Array} [props] containing x and y keys
 * @return {Number} angle
 */

function getAngle(p1, p2, props) {
  if (!props) {
    props = PROPS_XY;
  }

  var x = p2[props[0]] - p1[props[0]];
  var y = p2[props[1]] - p1[props[1]];
  return Math.atan2(y, x) * 180 / Math.PI;
}

/**
 * @private
 * get the direction between two points
 * @param {Number} x
 * @param {Number} y
 * @return {Number} direction
 */

function getDirection(x, y) {
  if (x === y) {
    return DIRECTION_NONE;
  }

  if (abs$1(x) >= abs$1(y)) {
    return x < 0 ? DIRECTION_LEFT : DIRECTION_RIGHT;
  }

  return y < 0 ? DIRECTION_UP : DIRECTION_DOWN;
}

function computeDeltaXY(session, input) {
  var center = input.center; // let { offsetDelta:offset = {}, prevDelta = {}, prevInput = {} } = session;
  // jscs throwing error on defalut destructured values and without defaults tests fail

  var offset = session.offsetDelta || {};
  var prevDelta = session.prevDelta || {};
  var prevInput = session.prevInput || {};

  if (input.eventType === INPUT_START || prevInput.eventType === INPUT_END) {
    prevDelta = session.prevDelta = {
      x: prevInput.deltaX || 0,
      y: prevInput.deltaY || 0
    };
    offset = session.offsetDelta = {
      x: center.x,
      y: center.y
    };
  }

  input.deltaX = prevDelta.x + (center.x - offset.x);
  input.deltaY = prevDelta.y + (center.y - offset.y);
}

/**
 * @private
 * calculate the velocity between two points. unit is in px per ms.
 * @param {Number} deltaTime
 * @param {Number} x
 * @param {Number} y
 * @return {Object} velocity `x` and `y`
 */
function getVelocity(deltaTime, x, y) {
  return {
    x: x / deltaTime || 0,
    y: y / deltaTime || 0
  };
}

/**
 * @private
 * calculate the scale factor between two pointersets
 * no scale is 1, and goes down to 0 when pinched together, and bigger when pinched out
 * @param {Array} start array of pointers
 * @param {Array} end array of pointers
 * @return {Number} scale
 */

function getScale(start, end) {
  return getDistance(end[0], end[1], PROPS_CLIENT_XY) / getDistance(start[0], start[1], PROPS_CLIENT_XY);
}

/**
 * @private
 * calculate the rotation degrees between two pointersets
 * @param {Array} start array of pointers
 * @param {Array} end array of pointers
 * @return {Number} rotation
 */

function getRotation(start, end) {
  return getAngle(end[1], end[0], PROPS_CLIENT_XY) + getAngle(start[1], start[0], PROPS_CLIENT_XY);
}

/**
 * @private
 * velocity is calculated every x ms
 * @param {Object} session
 * @param {Object} input
 */

function computeIntervalInputData(session, input) {
  var last = session.lastInterval || input;
  var deltaTime = input.timeStamp - last.timeStamp;
  var velocity;
  var velocityX;
  var velocityY;
  var direction;

  if (input.eventType !== INPUT_CANCEL && (deltaTime > COMPUTE_INTERVAL || last.velocity === undefined)) {
    var deltaX = input.deltaX - last.deltaX;
    var deltaY = input.deltaY - last.deltaY;
    var v = getVelocity(deltaTime, deltaX, deltaY);
    velocityX = v.x;
    velocityY = v.y;
    velocity = abs$1(v.x) > abs$1(v.y) ? v.x : v.y;
    direction = getDirection(deltaX, deltaY);
    session.lastInterval = input;
  } else {
    // use latest velocity info if it doesn't overtake a minimum period
    velocity = last.velocity;
    velocityX = last.velocityX;
    velocityY = last.velocityY;
    direction = last.direction;
  }

  input.velocity = velocity;
  input.velocityX = velocityX;
  input.velocityY = velocityY;
  input.direction = direction;
}

/**
* @private
 * extend the data with some usable properties like scale, rotate, velocity etc
 * @param {Object} manager
 * @param {Object} input
 */

function computeInputData(manager, input) {
  var session = manager.session;
  var pointers = input.pointers;
  var pointersLength = pointers.length; // store the first input to calculate the distance and direction

  if (!session.firstInput) {
    session.firstInput = simpleCloneInputData(input);
  } // to compute scale and rotation we need to store the multiple touches


  if (pointersLength > 1 && !session.firstMultiple) {
    session.firstMultiple = simpleCloneInputData(input);
  } else if (pointersLength === 1) {
    session.firstMultiple = false;
  }

  var firstInput = session.firstInput,
      firstMultiple = session.firstMultiple;
  var offsetCenter = firstMultiple ? firstMultiple.center : firstInput.center;
  var center = input.center = getCenter(pointers);
  input.timeStamp = now();
  input.deltaTime = input.timeStamp - firstInput.timeStamp;
  input.angle = getAngle(offsetCenter, center);
  input.distance = getDistance(offsetCenter, center);
  computeDeltaXY(session, input);
  input.offsetDirection = getDirection(input.deltaX, input.deltaY);
  var overallVelocity = getVelocity(input.deltaTime, input.deltaX, input.deltaY);
  input.overallVelocityX = overallVelocity.x;
  input.overallVelocityY = overallVelocity.y;
  input.overallVelocity = abs$1(overallVelocity.x) > abs$1(overallVelocity.y) ? overallVelocity.x : overallVelocity.y;
  input.scale = firstMultiple ? getScale(firstMultiple.pointers, pointers) : 1;
  input.rotation = firstMultiple ? getRotation(firstMultiple.pointers, pointers) : 0;
  input.maxPointers = !session.prevInput ? input.pointers.length : input.pointers.length > session.prevInput.maxPointers ? input.pointers.length : session.prevInput.maxPointers;
  computeIntervalInputData(session, input); // find the correct target

  var target = manager.element;
  var srcEvent = input.srcEvent;
  var srcEventTarget;

  if (srcEvent.composedPath) {
    srcEventTarget = srcEvent.composedPath()[0];
  } else if (srcEvent.path) {
    srcEventTarget = srcEvent.path[0];
  } else {
    srcEventTarget = srcEvent.target;
  }

  if (hasParent(srcEventTarget, target)) {
    target = srcEventTarget;
  }

  input.target = target;
}

/**
 * @private
 * handle input events
 * @param {Manager} manager
 * @param {String} eventType
 * @param {Object} input
 */

function inputHandler(manager, eventType, input) {
  var pointersLen = input.pointers.length;
  var changedPointersLen = input.changedPointers.length;
  var isFirst = eventType & INPUT_START && pointersLen - changedPointersLen === 0;
  var isFinal = eventType & (INPUT_END | INPUT_CANCEL) && pointersLen - changedPointersLen === 0;
  input.isFirst = !!isFirst;
  input.isFinal = !!isFinal;

  if (isFirst) {
    manager.session = {};
  } // source event is the normalized value of the domEvents
  // like 'touchstart, mouseup, pointerdown'


  input.eventType = eventType; // compute scale, rotation etc

  computeInputData(manager, input); // emit secret event

  manager.emit('hammer.input', input);
  manager.recognize(input);
  manager.session.prevInput = input;
}

/**
 * @private
 * split string on whitespace
 * @param {String} str
 * @returns {Array} words
 */
function splitStr(str) {
  return str.trim().split(/\s+/g);
}

/**
 * @private
 * addEventListener with multiple events at once
 * @param {EventTarget} target
 * @param {String} types
 * @param {Function} handler
 */

function addEventListeners(target, types, handler) {
  each(splitStr(types), function (type) {
    target.addEventListener(type, handler, false);
  });
}

/**
 * @private
 * removeEventListener with multiple events at once
 * @param {EventTarget} target
 * @param {String} types
 * @param {Function} handler
 */

function removeEventListeners(target, types, handler) {
  each(splitStr(types), function (type) {
    target.removeEventListener(type, handler, false);
  });
}

/**
 * @private
 * get the window object of an element
 * @param {HTMLElement} element
 * @returns {DocumentView|Window}
 */
function getWindowForElement(element) {
  var doc = element.ownerDocument || element;
  return doc.defaultView || doc.parentWindow || window;
}

/**
 * @private
 * create new input type manager
 * @param {Manager} manager
 * @param {Function} callback
 * @returns {Input}
 * @constructor
 */

var Input =
/*#__PURE__*/
function () {
  function Input(manager, callback) {
    var self = this;
    this.manager = manager;
    this.callback = callback;
    this.element = manager.element;
    this.target = manager.options.inputTarget; // smaller wrapper around the handler, for the scope and the enabled state of the manager,
    // so when disabled the input events are completely bypassed.

    this.domHandler = function (ev) {
      if (boolOrFn(manager.options.enable, [manager])) {
        self.handler(ev);
      }
    };

    this.init();
  }
  /**
   * @private
   * should handle the inputEvent data and trigger the callback
   * @virtual
   */


  var _proto = Input.prototype;

  _proto.handler = function handler() {};
  /**
   * @private
   * bind the events
   */


  _proto.init = function init() {
    this.evEl && addEventListeners(this.element, this.evEl, this.domHandler);
    this.evTarget && addEventListeners(this.target, this.evTarget, this.domHandler);
    this.evWin && addEventListeners(getWindowForElement(this.element), this.evWin, this.domHandler);
  };
  /**
   * @private
   * unbind the events
   */


  _proto.destroy = function destroy() {
    this.evEl && removeEventListeners(this.element, this.evEl, this.domHandler);
    this.evTarget && removeEventListeners(this.target, this.evTarget, this.domHandler);
    this.evWin && removeEventListeners(getWindowForElement(this.element), this.evWin, this.domHandler);
  };

  return Input;
}();

/**
 * @private
 * find if a array contains the object using indexOf or a simple polyFill
 * @param {Array} src
 * @param {String} find
 * @param {String} [findByKey]
 * @return {Boolean|Number} false when not found, or the index
 */
function inArray(src, find, findByKey) {
  if (src.indexOf && !findByKey) {
    return src.indexOf(find);
  } else {
    var i = 0;

    while (i < src.length) {
      if (findByKey && src[i][findByKey] == find || !findByKey && src[i] === find) {
        // do not use === here, test fails
        return i;
      }

      i++;
    }

    return -1;
  }
}

var POINTER_INPUT_MAP = {
  pointerdown: INPUT_START,
  pointermove: INPUT_MOVE,
  pointerup: INPUT_END,
  pointercancel: INPUT_CANCEL,
  pointerout: INPUT_CANCEL
}; // in IE10 the pointer types is defined as an enum

var IE10_POINTER_TYPE_ENUM = {
  2: INPUT_TYPE_TOUCH,
  3: INPUT_TYPE_PEN,
  4: INPUT_TYPE_MOUSE,
  5: INPUT_TYPE_KINECT // see https://twitter.com/jacobrossi/status/480596438489890816

};
var POINTER_ELEMENT_EVENTS = 'pointerdown';
var POINTER_WINDOW_EVENTS = 'pointermove pointerup pointercancel'; // IE10 has prefixed support, and case-sensitive

if (win.MSPointerEvent && !win.PointerEvent) {
  POINTER_ELEMENT_EVENTS = 'MSPointerDown';
  POINTER_WINDOW_EVENTS = 'MSPointerMove MSPointerUp MSPointerCancel';
}
/**
 * @private
 * Pointer events input
 * @constructor
 * @extends Input
 */


var PointerEventInput =
/*#__PURE__*/
function (_Input) {
  _inheritsLoose(PointerEventInput, _Input);

  function PointerEventInput() {
    var _this;

    var proto = PointerEventInput.prototype;
    proto.evEl = POINTER_ELEMENT_EVENTS;
    proto.evWin = POINTER_WINDOW_EVENTS;
    _this = _Input.apply(this, arguments) || this;
    _this.store = _this.manager.session.pointerEvents = [];
    return _this;
  }
  /**
   * @private
   * handle mouse events
   * @param {Object} ev
   */


  var _proto = PointerEventInput.prototype;

  _proto.handler = function handler(ev) {
    var store = this.store;
    var removePointer = false;
    var eventTypeNormalized = ev.type.toLowerCase().replace('ms', '');
    var eventType = POINTER_INPUT_MAP[eventTypeNormalized];
    var pointerType = IE10_POINTER_TYPE_ENUM[ev.pointerType] || ev.pointerType;
    var isTouch = pointerType === INPUT_TYPE_TOUCH; // get index of the event in the store

    var storeIndex = inArray(store, ev.pointerId, 'pointerId'); // start and mouse must be down

    if (eventType & INPUT_START && (ev.button === 0 || isTouch)) {
      if (storeIndex < 0) {
        store.push(ev);
        storeIndex = store.length - 1;
      }
    } else if (eventType & (INPUT_END | INPUT_CANCEL)) {
      removePointer = true;
    } // it not found, so the pointer hasn't been down (so it's probably a hover)


    if (storeIndex < 0) {
      return;
    } // update the event in the store


    store[storeIndex] = ev;
    this.callback(this.manager, eventType, {
      pointers: store,
      changedPointers: [ev],
      pointerType: pointerType,
      srcEvent: ev
    });

    if (removePointer) {
      // remove from the store
      store.splice(storeIndex, 1);
    }
  };

  return PointerEventInput;
}(Input);

/**
 * @private
 * convert array-like objects to real arrays
 * @param {Object} obj
 * @returns {Array}
 */
function toArray(obj) {
  return Array.prototype.slice.call(obj, 0);
}

/**
 * @private
 * unique array with objects based on a key (like 'id') or just by the array's value
 * @param {Array} src [{id:1},{id:2},{id:1}]
 * @param {String} [key]
 * @param {Boolean} [sort=False]
 * @returns {Array} [{id:1},{id:2}]
 */

function uniqueArray(src, key, sort) {
  var results = [];
  var values = [];
  var i = 0;

  while (i < src.length) {
    var val = key ? src[i][key] : src[i];

    if (inArray(values, val) < 0) {
      results.push(src[i]);
    }

    values[i] = val;
    i++;
  }

  if (sort) {
    if (!key) {
      results = results.sort();
    } else {
      results = results.sort(function (a, b) {
        return a[key] > b[key];
      });
    }
  }

  return results;
}

var TOUCH_INPUT_MAP = {
  touchstart: INPUT_START,
  touchmove: INPUT_MOVE,
  touchend: INPUT_END,
  touchcancel: INPUT_CANCEL
};
var TOUCH_TARGET_EVENTS = 'touchstart touchmove touchend touchcancel';
/**
 * @private
 * Multi-user touch events input
 * @constructor
 * @extends Input
 */

var TouchInput =
/*#__PURE__*/
function (_Input) {
  _inheritsLoose(TouchInput, _Input);

  function TouchInput() {
    var _this;

    TouchInput.prototype.evTarget = TOUCH_TARGET_EVENTS;
    _this = _Input.apply(this, arguments) || this;
    _this.targetIds = {}; // this.evTarget = TOUCH_TARGET_EVENTS;

    return _this;
  }

  var _proto = TouchInput.prototype;

  _proto.handler = function handler(ev) {
    var type = TOUCH_INPUT_MAP[ev.type];
    var touches = getTouches.call(this, ev, type);

    if (!touches) {
      return;
    }

    this.callback(this.manager, type, {
      pointers: touches[0],
      changedPointers: touches[1],
      pointerType: INPUT_TYPE_TOUCH,
      srcEvent: ev
    });
  };

  return TouchInput;
}(Input);

function getTouches(ev, type) {
  var allTouches = toArray(ev.touches);
  var targetIds = this.targetIds; // when there is only one touch, the process can be simplified

  if (type & (INPUT_START | INPUT_MOVE) && allTouches.length === 1) {
    targetIds[allTouches[0].identifier] = true;
    return [allTouches, allTouches];
  }

  var i;
  var targetTouches;
  var changedTouches = toArray(ev.changedTouches);
  var changedTargetTouches = [];
  var target = this.target; // get target touches from touches

  targetTouches = allTouches.filter(function (touch) {
    return hasParent(touch.target, target);
  }); // collect touches

  if (type === INPUT_START) {
    i = 0;

    while (i < targetTouches.length) {
      targetIds[targetTouches[i].identifier] = true;
      i++;
    }
  } // filter changed touches to only contain touches that exist in the collected target ids


  i = 0;

  while (i < changedTouches.length) {
    if (targetIds[changedTouches[i].identifier]) {
      changedTargetTouches.push(changedTouches[i]);
    } // cleanup removed touches


    if (type & (INPUT_END | INPUT_CANCEL)) {
      delete targetIds[changedTouches[i].identifier];
    }

    i++;
  }

  if (!changedTargetTouches.length) {
    return;
  }

  return [// merge targetTouches with changedTargetTouches so it contains ALL touches, including 'end' and 'cancel'
  uniqueArray(targetTouches.concat(changedTargetTouches), 'identifier', true), changedTargetTouches];
}

var MOUSE_INPUT_MAP = {
  mousedown: INPUT_START,
  mousemove: INPUT_MOVE,
  mouseup: INPUT_END
};
var MOUSE_ELEMENT_EVENTS = 'mousedown';
var MOUSE_WINDOW_EVENTS = 'mousemove mouseup';
/**
 * @private
 * Mouse events input
 * @constructor
 * @extends Input
 */

var MouseInput =
/*#__PURE__*/
function (_Input) {
  _inheritsLoose(MouseInput, _Input);

  function MouseInput() {
    var _this;

    var proto = MouseInput.prototype;
    proto.evEl = MOUSE_ELEMENT_EVENTS;
    proto.evWin = MOUSE_WINDOW_EVENTS;
    _this = _Input.apply(this, arguments) || this;
    _this.pressed = false; // mousedown state

    return _this;
  }
  /**
   * @private
   * handle mouse events
   * @param {Object} ev
   */


  var _proto = MouseInput.prototype;

  _proto.handler = function handler(ev) {
    var eventType = MOUSE_INPUT_MAP[ev.type]; // on start we want to have the left mouse button down

    if (eventType & INPUT_START && ev.button === 0) {
      this.pressed = true;
    }

    if (eventType & INPUT_MOVE && ev.which !== 1) {
      eventType = INPUT_END;
    } // mouse must be down


    if (!this.pressed) {
      return;
    }

    if (eventType & INPUT_END) {
      this.pressed = false;
    }

    this.callback(this.manager, eventType, {
      pointers: [ev],
      changedPointers: [ev],
      pointerType: INPUT_TYPE_MOUSE,
      srcEvent: ev
    });
  };

  return MouseInput;
}(Input);

/**
 * @private
 * Combined touch and mouse input
 *
 * Touch has a higher priority then mouse, and while touching no mouse events are allowed.
 * This because touch devices also emit mouse events while doing a touch.
 *
 * @constructor
 * @extends Input
 */

var DEDUP_TIMEOUT = 2500;
var DEDUP_DISTANCE = 25;

function setLastTouch(eventData) {
  var _eventData$changedPoi = eventData.changedPointers,
      touch = _eventData$changedPoi[0];

  if (touch.identifier === this.primaryTouch) {
    var lastTouch = {
      x: touch.clientX,
      y: touch.clientY
    };
    var lts = this.lastTouches;
    this.lastTouches.push(lastTouch);

    var removeLastTouch = function removeLastTouch() {
      var i = lts.indexOf(lastTouch);

      if (i > -1) {
        lts.splice(i, 1);
      }
    };

    setTimeout(removeLastTouch, DEDUP_TIMEOUT);
  }
}

function recordTouches(eventType, eventData) {
  if (eventType & INPUT_START) {
    this.primaryTouch = eventData.changedPointers[0].identifier;
    setLastTouch.call(this, eventData);
  } else if (eventType & (INPUT_END | INPUT_CANCEL)) {
    setLastTouch.call(this, eventData);
  }
}

function isSyntheticEvent(eventData) {
  var x = eventData.srcEvent.clientX;
  var y = eventData.srcEvent.clientY;

  for (var i = 0; i < this.lastTouches.length; i++) {
    var t = this.lastTouches[i];
    var dx = Math.abs(x - t.x);
    var dy = Math.abs(y - t.y);

    if (dx <= DEDUP_DISTANCE && dy <= DEDUP_DISTANCE) {
      return true;
    }
  }

  return false;
}

var TouchMouseInput =
/*#__PURE__*/
function () {
  var TouchMouseInput =
  /*#__PURE__*/
  function (_Input) {
    _inheritsLoose(TouchMouseInput, _Input);

    function TouchMouseInput(_manager, callback) {
      var _this;

      _this = _Input.call(this, _manager, callback) || this;

      _this.handler = function (manager, inputEvent, inputData) {
        var isTouch = inputData.pointerType === INPUT_TYPE_TOUCH;
        var isMouse = inputData.pointerType === INPUT_TYPE_MOUSE;

        if (isMouse && inputData.sourceCapabilities && inputData.sourceCapabilities.firesTouchEvents) {
          return;
        } // when we're in a touch event, record touches to  de-dupe synthetic mouse event


        if (isTouch) {
          recordTouches.call(_assertThisInitialized(_assertThisInitialized(_this)), inputEvent, inputData);
        } else if (isMouse && isSyntheticEvent.call(_assertThisInitialized(_assertThisInitialized(_this)), inputData)) {
          return;
        }

        _this.callback(manager, inputEvent, inputData);
      };

      _this.touch = new TouchInput(_this.manager, _this.handler);
      _this.mouse = new MouseInput(_this.manager, _this.handler);
      _this.primaryTouch = null;
      _this.lastTouches = [];
      return _this;
    }
    /**
     * @private
     * handle mouse and touch events
     * @param {Hammer} manager
     * @param {String} inputEvent
     * @param {Object} inputData
     */


    var _proto = TouchMouseInput.prototype;

    /**
     * @private
     * remove the event listeners
     */
    _proto.destroy = function destroy() {
      this.touch.destroy();
      this.mouse.destroy();
    };

    return TouchMouseInput;
  }(Input);

  return TouchMouseInput;
}();

/**
 * @private
 * create new input type manager
 * called by the Manager constructor
 * @param {Hammer} manager
 * @returns {Input}
 */

function createInputInstance(manager) {
  var Type; // let inputClass = manager.options.inputClass;

  var inputClass = manager.options.inputClass;

  if (inputClass) {
    Type = inputClass;
  } else if (SUPPORT_POINTER_EVENTS) {
    Type = PointerEventInput;
  } else if (SUPPORT_ONLY_TOUCH) {
    Type = TouchInput;
  } else if (!SUPPORT_TOUCH) {
    Type = MouseInput;
  } else {
    Type = TouchMouseInput;
  }

  return new Type(manager, inputHandler);
}

/**
 * @private
 * if the argument is an array, we want to execute the fn on each entry
 * if it aint an array we don't want to do a thing.
 * this is used by all the methods that accept a single and array argument.
 * @param {*|Array} arg
 * @param {String} fn
 * @param {Object} [context]
 * @returns {Boolean}
 */

function invokeArrayArg(arg, fn, context) {
  if (Array.isArray(arg)) {
    each(arg, context[fn], context);
    return true;
  }

  return false;
}

var STATE_POSSIBLE = 1;
var STATE_BEGAN = 2;
var STATE_CHANGED = 4;
var STATE_ENDED = 8;
var STATE_RECOGNIZED = STATE_ENDED;
var STATE_CANCELLED = 16;
var STATE_FAILED = 32;

/**
 * @private
 * get a unique id
 * @returns {number} uniqueId
 */
var _uniqueId = 1;
function uniqueId() {
  return _uniqueId++;
}

/**
 * @private
 * get a recognizer by name if it is bound to a manager
 * @param {Recognizer|String} otherRecognizer
 * @param {Recognizer} recognizer
 * @returns {Recognizer}
 */
function getRecognizerByNameIfManager(otherRecognizer, recognizer) {
  var manager = recognizer.manager;

  if (manager) {
    return manager.get(otherRecognizer);
  }

  return otherRecognizer;
}

/**
 * @private
 * get a usable string, used as event postfix
 * @param {constant} state
 * @returns {String} state
 */

function stateStr(state) {
  if (state & STATE_CANCELLED) {
    return 'cancel';
  } else if (state & STATE_ENDED) {
    return 'end';
  } else if (state & STATE_CHANGED) {
    return 'move';
  } else if (state & STATE_BEGAN) {
    return 'start';
  }

  return '';
}

/**
 * @private
 * Recognizer flow explained; *
 * All recognizers have the initial state of POSSIBLE when a input session starts.
 * The definition of a input session is from the first input until the last input, with all it's movement in it. *
 * Example session for mouse-input: mousedown -> mousemove -> mouseup
 *
 * On each recognizing cycle (see Manager.recognize) the .recognize() method is executed
 * which determines with state it should be.
 *
 * If the recognizer has the state FAILED, CANCELLED or RECOGNIZED (equals ENDED), it is reset to
 * POSSIBLE to give it another change on the next cycle.
 *
 *               Possible
 *                  |
 *            +-----+---------------+
 *            |                     |
 *      +-----+-----+               |
 *      |           |               |
 *   Failed      Cancelled          |
 *                          +-------+------+
 *                          |              |
 *                      Recognized       Began
 *                                         |
 *                                      Changed
 *                                         |
 *                                  Ended/Recognized
 */

/**
 * @private
 * Recognizer
 * Every recognizer needs to extend from this class.
 * @constructor
 * @param {Object} options
 */

var Recognizer =
/*#__PURE__*/
function () {
  function Recognizer(options) {
    if (options === void 0) {
      options = {};
    }

    this.options = _extends({
      enable: true
    }, options);
    this.id = uniqueId();
    this.manager = null; // default is enable true

    this.state = STATE_POSSIBLE;
    this.simultaneous = {};
    this.requireFail = [];
  }
  /**
   * @private
   * set options
   * @param {Object} options
   * @return {Recognizer}
   */


  var _proto = Recognizer.prototype;

  _proto.set = function set(options) {
    assign$1(this.options, options); // also update the touchAction, in case something changed about the directions/enabled state

    this.manager && this.manager.touchAction.update();
    return this;
  };
  /**
   * @private
   * recognize simultaneous with an other recognizer.
   * @param {Recognizer} otherRecognizer
   * @returns {Recognizer} this
   */


  _proto.recognizeWith = function recognizeWith(otherRecognizer) {
    if (invokeArrayArg(otherRecognizer, 'recognizeWith', this)) {
      return this;
    }

    var simultaneous = this.simultaneous;
    otherRecognizer = getRecognizerByNameIfManager(otherRecognizer, this);

    if (!simultaneous[otherRecognizer.id]) {
      simultaneous[otherRecognizer.id] = otherRecognizer;
      otherRecognizer.recognizeWith(this);
    }

    return this;
  };
  /**
   * @private
   * drop the simultaneous link. it doesnt remove the link on the other recognizer.
   * @param {Recognizer} otherRecognizer
   * @returns {Recognizer} this
   */


  _proto.dropRecognizeWith = function dropRecognizeWith(otherRecognizer) {
    if (invokeArrayArg(otherRecognizer, 'dropRecognizeWith', this)) {
      return this;
    }

    otherRecognizer = getRecognizerByNameIfManager(otherRecognizer, this);
    delete this.simultaneous[otherRecognizer.id];
    return this;
  };
  /**
   * @private
   * recognizer can only run when an other is failing
   * @param {Recognizer} otherRecognizer
   * @returns {Recognizer} this
   */


  _proto.requireFailure = function requireFailure(otherRecognizer) {
    if (invokeArrayArg(otherRecognizer, 'requireFailure', this)) {
      return this;
    }

    var requireFail = this.requireFail;
    otherRecognizer = getRecognizerByNameIfManager(otherRecognizer, this);

    if (inArray(requireFail, otherRecognizer) === -1) {
      requireFail.push(otherRecognizer);
      otherRecognizer.requireFailure(this);
    }

    return this;
  };
  /**
   * @private
   * drop the requireFailure link. it does not remove the link on the other recognizer.
   * @param {Recognizer} otherRecognizer
   * @returns {Recognizer} this
   */


  _proto.dropRequireFailure = function dropRequireFailure(otherRecognizer) {
    if (invokeArrayArg(otherRecognizer, 'dropRequireFailure', this)) {
      return this;
    }

    otherRecognizer = getRecognizerByNameIfManager(otherRecognizer, this);
    var index = inArray(this.requireFail, otherRecognizer);

    if (index > -1) {
      this.requireFail.splice(index, 1);
    }

    return this;
  };
  /**
   * @private
   * has require failures boolean
   * @returns {boolean}
   */


  _proto.hasRequireFailures = function hasRequireFailures() {
    return this.requireFail.length > 0;
  };
  /**
   * @private
   * if the recognizer can recognize simultaneous with an other recognizer
   * @param {Recognizer} otherRecognizer
   * @returns {Boolean}
   */


  _proto.canRecognizeWith = function canRecognizeWith(otherRecognizer) {
    return !!this.simultaneous[otherRecognizer.id];
  };
  /**
   * @private
   * You should use `tryEmit` instead of `emit` directly to check
   * that all the needed recognizers has failed before emitting.
   * @param {Object} input
   */


  _proto.emit = function emit(input) {
    var self = this;
    var state = this.state;

    function emit(event) {
      self.manager.emit(event, input);
    } // 'panstart' and 'panmove'


    if (state < STATE_ENDED) {
      emit(self.options.event + stateStr(state));
    }

    emit(self.options.event); // simple 'eventName' events

    if (input.additionalEvent) {
      // additional event(panleft, panright, pinchin, pinchout...)
      emit(input.additionalEvent);
    } // panend and pancancel


    if (state >= STATE_ENDED) {
      emit(self.options.event + stateStr(state));
    }
  };
  /**
   * @private
   * Check that all the require failure recognizers has failed,
   * if true, it emits a gesture event,
   * otherwise, setup the state to FAILED.
   * @param {Object} input
   */


  _proto.tryEmit = function tryEmit(input) {
    if (this.canEmit()) {
      return this.emit(input);
    } // it's failing anyway


    this.state = STATE_FAILED;
  };
  /**
   * @private
   * can we emit?
   * @returns {boolean}
   */


  _proto.canEmit = function canEmit() {
    var i = 0;

    while (i < this.requireFail.length) {
      if (!(this.requireFail[i].state & (STATE_FAILED | STATE_POSSIBLE))) {
        return false;
      }

      i++;
    }

    return true;
  };
  /**
   * @private
   * update the recognizer
   * @param {Object} inputData
   */


  _proto.recognize = function recognize(inputData) {
    // make a new copy of the inputData
    // so we can change the inputData without messing up the other recognizers
    var inputDataClone = assign$1({}, inputData); // is is enabled and allow recognizing?

    if (!boolOrFn(this.options.enable, [this, inputDataClone])) {
      this.reset();
      this.state = STATE_FAILED;
      return;
    } // reset when we've reached the end


    if (this.state & (STATE_RECOGNIZED | STATE_CANCELLED | STATE_FAILED)) {
      this.state = STATE_POSSIBLE;
    }

    this.state = this.process(inputDataClone); // the recognizer has recognized a gesture
    // so trigger an event

    if (this.state & (STATE_BEGAN | STATE_CHANGED | STATE_ENDED | STATE_CANCELLED)) {
      this.tryEmit(inputDataClone);
    }
  };
  /**
   * @private
   * return the state of the recognizer
   * the actual recognizing happens in this method
   * @virtual
   * @param {Object} inputData
   * @returns {constant} STATE
   */

  /* jshint ignore:start */


  _proto.process = function process(inputData) {};
  /* jshint ignore:end */

  /**
   * @private
   * return the preferred touch-action
   * @virtual
   * @returns {Array}
   */


  _proto.getTouchAction = function getTouchAction() {};
  /**
   * @private
   * called when the gesture isn't allowed to recognize
   * like when another is being recognized or it is disabled
   * @virtual
   */


  _proto.reset = function reset() {};

  return Recognizer;
}();

/**
 * @private
 * A tap is recognized when the pointer is doing a small tap/click. Multiple taps are recognized if they occur
 * between the given interval and position. The delay option can be used to recognize multi-taps without firing
 * a single tap.
 *
 * The eventData from the emitted event contains the property `tapCount`, which contains the amount of
 * multi-taps being recognized.
 * @constructor
 * @extends Recognizer
 */

var TapRecognizer =
/*#__PURE__*/
function (_Recognizer) {
  _inheritsLoose(TapRecognizer, _Recognizer);

  function TapRecognizer(options) {
    var _this;

    if (options === void 0) {
      options = {};
    }

    _this = _Recognizer.call(this, _extends({
      event: 'tap',
      pointers: 1,
      taps: 1,
      interval: 300,
      // max time between the multi-tap taps
      time: 250,
      // max time of the pointer to be down (like finger on the screen)
      threshold: 9,
      // a minimal movement is ok, but keep it low
      posThreshold: 10
    }, options)) || this; // previous time and center,
    // used for tap counting

    _this.pTime = false;
    _this.pCenter = false;
    _this._timer = null;
    _this._input = null;
    _this.count = 0;
    return _this;
  }

  var _proto = TapRecognizer.prototype;

  _proto.getTouchAction = function getTouchAction() {
    return [TOUCH_ACTION_MANIPULATION];
  };

  _proto.process = function process(input) {
    var _this2 = this;

    var options = this.options;
    var validPointers = input.pointers.length === options.pointers;
    var validMovement = input.distance < options.threshold;
    var validTouchTime = input.deltaTime < options.time;
    this.reset();

    if (input.eventType & INPUT_START && this.count === 0) {
      return this.failTimeout();
    } // we only allow little movement
    // and we've reached an end event, so a tap is possible


    if (validMovement && validTouchTime && validPointers) {
      if (input.eventType !== INPUT_END) {
        return this.failTimeout();
      }

      var validInterval = this.pTime ? input.timeStamp - this.pTime < options.interval : true;
      var validMultiTap = !this.pCenter || getDistance(this.pCenter, input.center) < options.posThreshold;
      this.pTime = input.timeStamp;
      this.pCenter = input.center;

      if (!validMultiTap || !validInterval) {
        this.count = 1;
      } else {
        this.count += 1;
      }

      this._input = input; // if tap count matches we have recognized it,
      // else it has began recognizing...

      var tapCount = this.count % options.taps;

      if (tapCount === 0) {
        // no failing requirements, immediately trigger the tap event
        // or wait as long as the multitap interval to trigger
        if (!this.hasRequireFailures()) {
          return STATE_RECOGNIZED;
        } else {
          this._timer = setTimeout(function () {
            _this2.state = STATE_RECOGNIZED;

            _this2.tryEmit();
          }, options.interval);
          return STATE_BEGAN;
        }
      }
    }

    return STATE_FAILED;
  };

  _proto.failTimeout = function failTimeout() {
    var _this3 = this;

    this._timer = setTimeout(function () {
      _this3.state = STATE_FAILED;
    }, this.options.interval);
    return STATE_FAILED;
  };

  _proto.reset = function reset() {
    clearTimeout(this._timer);
  };

  _proto.emit = function emit() {
    if (this.state === STATE_RECOGNIZED) {
      this._input.tapCount = this.count;
      this.manager.emit(this.options.event, this._input);
    }
  };

  return TapRecognizer;
}(Recognizer);

/**
 * @private
 * This recognizer is just used as a base for the simple attribute recognizers.
 * @constructor
 * @extends Recognizer
 */

var AttrRecognizer =
/*#__PURE__*/
function (_Recognizer) {
  _inheritsLoose(AttrRecognizer, _Recognizer);

  function AttrRecognizer(options) {
    if (options === void 0) {
      options = {};
    }

    return _Recognizer.call(this, _extends({
      pointers: 1
    }, options)) || this;
  }
  /**
   * @private
   * Used to check if it the recognizer receives valid input, like input.distance > 10.
   * @memberof AttrRecognizer
   * @param {Object} input
   * @returns {Boolean} recognized
   */


  var _proto = AttrRecognizer.prototype;

  _proto.attrTest = function attrTest(input) {
    var optionPointers = this.options.pointers;
    return optionPointers === 0 || input.pointers.length === optionPointers;
  };
  /**
   * @private
   * Process the input and return the state for the recognizer
   * @memberof AttrRecognizer
   * @param {Object} input
   * @returns {*} State
   */


  _proto.process = function process(input) {
    var state = this.state;
    var eventType = input.eventType;
    var isRecognized = state & (STATE_BEGAN | STATE_CHANGED);
    var isValid = this.attrTest(input); // on cancel input and we've recognized before, return STATE_CANCELLED

    if (isRecognized && (eventType & INPUT_CANCEL || !isValid)) {
      return state | STATE_CANCELLED;
    } else if (isRecognized || isValid) {
      if (eventType & INPUT_END) {
        return state | STATE_ENDED;
      } else if (!(state & STATE_BEGAN)) {
        return STATE_BEGAN;
      }

      return state | STATE_CHANGED;
    }

    return STATE_FAILED;
  };

  return AttrRecognizer;
}(Recognizer);

/**
 * @private
 * direction cons to string
 * @param {constant} direction
 * @returns {String}
 */

function directionStr(direction) {
  if (direction === DIRECTION_DOWN) {
    return 'down';
  } else if (direction === DIRECTION_UP) {
    return 'up';
  } else if (direction === DIRECTION_LEFT) {
    return 'left';
  } else if (direction === DIRECTION_RIGHT) {
    return 'right';
  }

  return '';
}

/**
 * @private
 * Pan
 * Recognized when the pointer is down and moved in the allowed direction.
 * @constructor
 * @extends AttrRecognizer
 */

var PanRecognizer =
/*#__PURE__*/
function (_AttrRecognizer) {
  _inheritsLoose(PanRecognizer, _AttrRecognizer);

  function PanRecognizer(options) {
    var _this;

    if (options === void 0) {
      options = {};
    }

    _this = _AttrRecognizer.call(this, _extends({
      event: 'pan',
      threshold: 10,
      pointers: 1,
      direction: DIRECTION_ALL
    }, options)) || this;
    _this.pX = null;
    _this.pY = null;
    return _this;
  }

  var _proto = PanRecognizer.prototype;

  _proto.getTouchAction = function getTouchAction() {
    var direction = this.options.direction;
    var actions = [];

    if (direction & DIRECTION_HORIZONTAL) {
      actions.push(TOUCH_ACTION_PAN_Y);
    }

    if (direction & DIRECTION_VERTICAL) {
      actions.push(TOUCH_ACTION_PAN_X);
    }

    return actions;
  };

  _proto.directionTest = function directionTest(input) {
    var options = this.options;
    var hasMoved = true;
    var distance = input.distance;
    var direction = input.direction;
    var x = input.deltaX;
    var y = input.deltaY; // lock to axis?

    if (!(direction & options.direction)) {
      if (options.direction & DIRECTION_HORIZONTAL) {
        direction = x === 0 ? DIRECTION_NONE : x < 0 ? DIRECTION_LEFT : DIRECTION_RIGHT;
        hasMoved = x !== this.pX;
        distance = Math.abs(input.deltaX);
      } else {
        direction = y === 0 ? DIRECTION_NONE : y < 0 ? DIRECTION_UP : DIRECTION_DOWN;
        hasMoved = y !== this.pY;
        distance = Math.abs(input.deltaY);
      }
    }

    input.direction = direction;
    return hasMoved && distance > options.threshold && direction & options.direction;
  };

  _proto.attrTest = function attrTest(input) {
    return AttrRecognizer.prototype.attrTest.call(this, input) && ( // replace with a super call
    this.state & STATE_BEGAN || !(this.state & STATE_BEGAN) && this.directionTest(input));
  };

  _proto.emit = function emit(input) {
    this.pX = input.deltaX;
    this.pY = input.deltaY;
    var direction = directionStr(input.direction);

    if (direction) {
      input.additionalEvent = this.options.event + direction;
    }

    _AttrRecognizer.prototype.emit.call(this, input);
  };

  return PanRecognizer;
}(AttrRecognizer);

/**
 * @private
 * Swipe
 * Recognized when the pointer is moving fast (velocity), with enough distance in the allowed direction.
 * @constructor
 * @extends AttrRecognizer
 */

var SwipeRecognizer =
/*#__PURE__*/
function (_AttrRecognizer) {
  _inheritsLoose(SwipeRecognizer, _AttrRecognizer);

  function SwipeRecognizer(options) {
    if (options === void 0) {
      options = {};
    }

    return _AttrRecognizer.call(this, _extends({
      event: 'swipe',
      threshold: 10,
      velocity: 0.3,
      direction: DIRECTION_HORIZONTAL | DIRECTION_VERTICAL,
      pointers: 1
    }, options)) || this;
  }

  var _proto = SwipeRecognizer.prototype;

  _proto.getTouchAction = function getTouchAction() {
    return PanRecognizer.prototype.getTouchAction.call(this);
  };

  _proto.attrTest = function attrTest(input) {
    var direction = this.options.direction;
    var velocity;

    if (direction & (DIRECTION_HORIZONTAL | DIRECTION_VERTICAL)) {
      velocity = input.overallVelocity;
    } else if (direction & DIRECTION_HORIZONTAL) {
      velocity = input.overallVelocityX;
    } else if (direction & DIRECTION_VERTICAL) {
      velocity = input.overallVelocityY;
    }

    return _AttrRecognizer.prototype.attrTest.call(this, input) && direction & input.offsetDirection && input.distance > this.options.threshold && input.maxPointers === this.options.pointers && abs$1(velocity) > this.options.velocity && input.eventType & INPUT_END;
  };

  _proto.emit = function emit(input) {
    var direction = directionStr(input.offsetDirection);

    if (direction) {
      this.manager.emit(this.options.event + direction, input);
    }

    this.manager.emit(this.options.event, input);
  };

  return SwipeRecognizer;
}(AttrRecognizer);

/**
 * @private
 * Pinch
 * Recognized when two or more pointers are moving toward (zoom-in) or away from each other (zoom-out).
 * @constructor
 * @extends AttrRecognizer
 */

var PinchRecognizer =
/*#__PURE__*/
function (_AttrRecognizer) {
  _inheritsLoose(PinchRecognizer, _AttrRecognizer);

  function PinchRecognizer(options) {
    if (options === void 0) {
      options = {};
    }

    return _AttrRecognizer.call(this, _extends({
      event: 'pinch',
      threshold: 0,
      pointers: 2
    }, options)) || this;
  }

  var _proto = PinchRecognizer.prototype;

  _proto.getTouchAction = function getTouchAction() {
    return [TOUCH_ACTION_NONE];
  };

  _proto.attrTest = function attrTest(input) {
    return _AttrRecognizer.prototype.attrTest.call(this, input) && (Math.abs(input.scale - 1) > this.options.threshold || this.state & STATE_BEGAN);
  };

  _proto.emit = function emit(input) {
    if (input.scale !== 1) {
      var inOut = input.scale < 1 ? 'in' : 'out';
      input.additionalEvent = this.options.event + inOut;
    }

    _AttrRecognizer.prototype.emit.call(this, input);
  };

  return PinchRecognizer;
}(AttrRecognizer);

/**
 * @private
 * Rotate
 * Recognized when two or more pointer are moving in a circular motion.
 * @constructor
 * @extends AttrRecognizer
 */

var RotateRecognizer =
/*#__PURE__*/
function (_AttrRecognizer) {
  _inheritsLoose(RotateRecognizer, _AttrRecognizer);

  function RotateRecognizer(options) {
    if (options === void 0) {
      options = {};
    }

    return _AttrRecognizer.call(this, _extends({
      event: 'rotate',
      threshold: 0,
      pointers: 2
    }, options)) || this;
  }

  var _proto = RotateRecognizer.prototype;

  _proto.getTouchAction = function getTouchAction() {
    return [TOUCH_ACTION_NONE];
  };

  _proto.attrTest = function attrTest(input) {
    return _AttrRecognizer.prototype.attrTest.call(this, input) && (Math.abs(input.rotation) > this.options.threshold || this.state & STATE_BEGAN);
  };

  return RotateRecognizer;
}(AttrRecognizer);

/**
 * @private
 * Press
 * Recognized when the pointer is down for x ms without any movement.
 * @constructor
 * @extends Recognizer
 */

var PressRecognizer =
/*#__PURE__*/
function (_Recognizer) {
  _inheritsLoose(PressRecognizer, _Recognizer);

  function PressRecognizer(options) {
    var _this;

    if (options === void 0) {
      options = {};
    }

    _this = _Recognizer.call(this, _extends({
      event: 'press',
      pointers: 1,
      time: 251,
      // minimal time of the pointer to be pressed
      threshold: 9
    }, options)) || this;
    _this._timer = null;
    _this._input = null;
    return _this;
  }

  var _proto = PressRecognizer.prototype;

  _proto.getTouchAction = function getTouchAction() {
    return [TOUCH_ACTION_AUTO];
  };

  _proto.process = function process(input) {
    var _this2 = this;

    var options = this.options;
    var validPointers = input.pointers.length === options.pointers;
    var validMovement = input.distance < options.threshold;
    var validTime = input.deltaTime > options.time;
    this._input = input; // we only allow little movement
    // and we've reached an end event, so a tap is possible

    if (!validMovement || !validPointers || input.eventType & (INPUT_END | INPUT_CANCEL) && !validTime) {
      this.reset();
    } else if (input.eventType & INPUT_START) {
      this.reset();
      this._timer = setTimeout(function () {
        _this2.state = STATE_RECOGNIZED;

        _this2.tryEmit();
      }, options.time);
    } else if (input.eventType & INPUT_END) {
      return STATE_RECOGNIZED;
    }

    return STATE_FAILED;
  };

  _proto.reset = function reset() {
    clearTimeout(this._timer);
  };

  _proto.emit = function emit(input) {
    if (this.state !== STATE_RECOGNIZED) {
      return;
    }

    if (input && input.eventType & INPUT_END) {
      this.manager.emit(this.options.event + "up", input);
    } else {
      this._input.timeStamp = now();
      this.manager.emit(this.options.event, this._input);
    }
  };

  return PressRecognizer;
}(Recognizer);

var defaults = {
  /**
   * @private
   * set if DOM events are being triggered.
   * But this is slower and unused by simple implementations, so disabled by default.
   * @type {Boolean}
   * @default false
   */
  domEvents: false,

  /**
   * @private
   * The value for the touchAction property/fallback.
   * When set to `compute` it will magically set the correct value based on the added recognizers.
   * @type {String}
   * @default compute
   */
  touchAction: TOUCH_ACTION_COMPUTE,

  /**
   * @private
   * @type {Boolean}
   * @default true
   */
  enable: true,

  /**
   * @private
   * EXPERIMENTAL FEATURE -- can be removed/changed
   * Change the parent input target element.
   * If Null, then it is being set the to main element.
   * @type {Null|EventTarget}
   * @default null
   */
  inputTarget: null,

  /**
   * @private
   * force an input class
   * @type {Null|Function}
   * @default null
   */
  inputClass: null,

  /**
   * @private
   * Some CSS properties can be used to improve the working of Hammer.
   * Add them to this method and they will be set when creating a new Manager.
   * @namespace
   */
  cssProps: {
    /**
     * @private
     * Disables text selection to improve the dragging gesture. Mainly for desktop browsers.
     * @type {String}
     * @default 'none'
     */
    userSelect: "none",

    /**
     * @private
     * Disable the Windows Phone grippers when pressing an element.
     * @type {String}
     * @default 'none'
     */
    touchSelect: "none",

    /**
     * @private
     * Disables the default callout shown when you touch and hold a touch target.
     * On iOS, when you touch and hold a touch target such as a link, Safari displays
     * a callout containing information about the link. This property allows you to disable that callout.
     * @type {String}
     * @default 'none'
     */
    touchCallout: "none",

    /**
     * @private
     * Specifies whether zooming is enabled. Used by IE10>
     * @type {String}
     * @default 'none'
     */
    contentZooming: "none",

    /**
     * @private
     * Specifies that an entire element should be draggable instead of its contents. Mainly for desktop browsers.
     * @type {String}
     * @default 'none'
     */
    userDrag: "none",

    /**
     * @private
     * Overrides the highlight color shown when the user taps a link or a JavaScript
     * clickable element in iOS. This property obeys the alpha value, if specified.
     * @type {String}
     * @default 'rgba(0,0,0,0)'
     */
    tapHighlightColor: "rgba(0,0,0,0)"
  }
};
/**
 * @private
 * Default recognizer setup when calling `Hammer()`
 * When creating a new Manager these will be skipped.
 * This is separated with other defaults because of tree-shaking.
 * @type {Array}
 */

var preset = [[RotateRecognizer, {
  enable: false
}], [PinchRecognizer, {
  enable: false
}, ['rotate']], [SwipeRecognizer, {
  direction: DIRECTION_HORIZONTAL
}], [PanRecognizer, {
  direction: DIRECTION_HORIZONTAL
}, ['swipe']], [TapRecognizer], [TapRecognizer, {
  event: 'doubletap',
  taps: 2
}, ['tap']], [PressRecognizer]];

var STOP = 1;
var FORCED_STOP = 2;
/**
 * @private
 * add/remove the css properties as defined in manager.options.cssProps
 * @param {Manager} manager
 * @param {Boolean} add
 */

function toggleCssProps(manager, add) {
  var element = manager.element;

  if (!element.style) {
    return;
  }

  var prop;
  each(manager.options.cssProps, function (value, name) {
    prop = prefixed(element.style, name);

    if (add) {
      manager.oldCssProps[prop] = element.style[prop];
      element.style[prop] = value;
    } else {
      element.style[prop] = manager.oldCssProps[prop] || "";
    }
  });

  if (!add) {
    manager.oldCssProps = {};
  }
}
/**
 * @private
 * trigger dom event
 * @param {String} event
 * @param {Object} data
 */


function triggerDomEvent(event, data) {
  var gestureEvent = document.createEvent("Event");
  gestureEvent.initEvent(event, true, true);
  gestureEvent.gesture = data;
  data.target.dispatchEvent(gestureEvent);
}
/**
* @private
 * Manager
 * @param {HTMLElement} element
 * @param {Object} [options]
 * @constructor
 */


var Manager =
/*#__PURE__*/
function () {
  function Manager(element, options) {
    var _this = this;

    this.options = assign$1({}, defaults, options || {});
    this.options.inputTarget = this.options.inputTarget || element;
    this.handlers = {};
    this.session = {};
    this.recognizers = [];
    this.oldCssProps = {};
    this.element = element;
    this.input = createInputInstance(this);
    this.touchAction = new TouchAction(this, this.options.touchAction);
    toggleCssProps(this, true);
    each(this.options.recognizers, function (item) {
      var recognizer = _this.add(new item[0](item[1]));

      item[2] && recognizer.recognizeWith(item[2]);
      item[3] && recognizer.requireFailure(item[3]);
    }, this);
  }
  /**
   * @private
   * set options
   * @param {Object} options
   * @returns {Manager}
   */


  var _proto = Manager.prototype;

  _proto.set = function set(options) {
    assign$1(this.options, options); // Options that need a little more setup

    if (options.touchAction) {
      this.touchAction.update();
    }

    if (options.inputTarget) {
      // Clean up existing event listeners and reinitialize
      this.input.destroy();
      this.input.target = options.inputTarget;
      this.input.init();
    }

    return this;
  };
  /**
   * @private
   * stop recognizing for this session.
   * This session will be discarded, when a new [input]start event is fired.
   * When forced, the recognizer cycle is stopped immediately.
   * @param {Boolean} [force]
   */


  _proto.stop = function stop(force) {
    this.session.stopped = force ? FORCED_STOP : STOP;
  };
  /**
   * @private
   * run the recognizers!
   * called by the inputHandler function on every movement of the pointers (touches)
   * it walks through all the recognizers and tries to detect the gesture that is being made
   * @param {Object} inputData
   */


  _proto.recognize = function recognize(inputData) {
    var session = this.session;

    if (session.stopped) {
      return;
    } // run the touch-action polyfill


    this.touchAction.preventDefaults(inputData);
    var recognizer;
    var recognizers = this.recognizers; // this holds the recognizer that is being recognized.
    // so the recognizer's state needs to be BEGAN, CHANGED, ENDED or RECOGNIZED
    // if no recognizer is detecting a thing, it is set to `null`

    var curRecognizer = session.curRecognizer; // reset when the last recognizer is recognized
    // or when we're in a new session

    if (!curRecognizer || curRecognizer && curRecognizer.state & STATE_RECOGNIZED) {
      session.curRecognizer = null;
      curRecognizer = null;
    }

    var i = 0;

    while (i < recognizers.length) {
      recognizer = recognizers[i]; // find out if we are allowed try to recognize the input for this one.
      // 1.   allow if the session is NOT forced stopped (see the .stop() method)
      // 2.   allow if we still haven't recognized a gesture in this session, or the this recognizer is the one
      //      that is being recognized.
      // 3.   allow if the recognizer is allowed to run simultaneous with the current recognized recognizer.
      //      this can be setup with the `recognizeWith()` method on the recognizer.

      if (session.stopped !== FORCED_STOP && ( // 1
      !curRecognizer || recognizer === curRecognizer || // 2
      recognizer.canRecognizeWith(curRecognizer))) {
        // 3
        recognizer.recognize(inputData);
      } else {
        recognizer.reset();
      } // if the recognizer has been recognizing the input as a valid gesture, we want to store this one as the
      // current active recognizer. but only if we don't already have an active recognizer


      if (!curRecognizer && recognizer.state & (STATE_BEGAN | STATE_CHANGED | STATE_ENDED)) {
        session.curRecognizer = recognizer;
        curRecognizer = recognizer;
      }

      i++;
    }
  };
  /**
   * @private
   * get a recognizer by its event name.
   * @param {Recognizer|String} recognizer
   * @returns {Recognizer|Null}
   */


  _proto.get = function get(recognizer) {
    if (recognizer instanceof Recognizer) {
      return recognizer;
    }

    var recognizers = this.recognizers;

    for (var i = 0; i < recognizers.length; i++) {
      if (recognizers[i].options.event === recognizer) {
        return recognizers[i];
      }
    }

    return null;
  };
  /**
   * @private add a recognizer to the manager
   * existing recognizers with the same event name will be removed
   * @param {Recognizer} recognizer
   * @returns {Recognizer|Manager}
   */


  _proto.add = function add(recognizer) {
    if (invokeArrayArg(recognizer, "add", this)) {
      return this;
    } // remove existing


    var existing = this.get(recognizer.options.event);

    if (existing) {
      this.remove(existing);
    }

    this.recognizers.push(recognizer);
    recognizer.manager = this;
    this.touchAction.update();
    return recognizer;
  };
  /**
   * @private
   * remove a recognizer by name or instance
   * @param {Recognizer|String} recognizer
   * @returns {Manager}
   */


  _proto.remove = function remove(recognizer) {
    if (invokeArrayArg(recognizer, "remove", this)) {
      return this;
    }

    var targetRecognizer = this.get(recognizer); // let's make sure this recognizer exists

    if (recognizer) {
      var recognizers = this.recognizers;
      var index = inArray(recognizers, targetRecognizer);

      if (index !== -1) {
        recognizers.splice(index, 1);
        this.touchAction.update();
      }
    }

    return this;
  };
  /**
   * @private
   * bind event
   * @param {String} events
   * @param {Function} handler
   * @returns {EventEmitter} this
   */


  _proto.on = function on(events, handler) {
    if (events === undefined || handler === undefined) {
      return this;
    }

    var handlers = this.handlers;
    each(splitStr(events), function (event) {
      handlers[event] = handlers[event] || [];
      handlers[event].push(handler);
    });
    return this;
  };
  /**
   * @private unbind event, leave emit blank to remove all handlers
   * @param {String} events
   * @param {Function} [handler]
   * @returns {EventEmitter} this
   */


  _proto.off = function off(events, handler) {
    if (events === undefined) {
      return this;
    }

    var handlers = this.handlers;
    each(splitStr(events), function (event) {
      if (!handler) {
        delete handlers[event];
      } else {
        handlers[event] && handlers[event].splice(inArray(handlers[event], handler), 1);
      }
    });
    return this;
  };
  /**
   * @private emit event to the listeners
   * @param {String} event
   * @param {Object} data
   */


  _proto.emit = function emit(event, data) {
    // we also want to trigger dom events
    if (this.options.domEvents) {
      triggerDomEvent(event, data);
    } // no handlers, so skip it all


    var handlers = this.handlers[event] && this.handlers[event].slice();

    if (!handlers || !handlers.length) {
      return;
    }

    data.type = event;

    data.preventDefault = function () {
      data.srcEvent.preventDefault();
    };

    var i = 0;

    while (i < handlers.length) {
      handlers[i](data);
      i++;
    }
  };
  /**
   * @private
   * destroy the manager and unbinds all events
   * it doesn't unbind dom events, that is the user own responsibility
   */


  _proto.destroy = function destroy() {
    this.element && toggleCssProps(this, false);
    this.handlers = {};
    this.session = {};
    this.input.destroy();
    this.element = null;
  };

  return Manager;
}();

var SINGLE_TOUCH_INPUT_MAP = {
  touchstart: INPUT_START,
  touchmove: INPUT_MOVE,
  touchend: INPUT_END,
  touchcancel: INPUT_CANCEL
};
var SINGLE_TOUCH_TARGET_EVENTS = 'touchstart';
var SINGLE_TOUCH_WINDOW_EVENTS = 'touchstart touchmove touchend touchcancel';
/**
 * @private
 * Touch events input
 * @constructor
 * @extends Input
 */

var SingleTouchInput =
/*#__PURE__*/
function (_Input) {
  _inheritsLoose(SingleTouchInput, _Input);

  function SingleTouchInput() {
    var _this;

    var proto = SingleTouchInput.prototype;
    proto.evTarget = SINGLE_TOUCH_TARGET_EVENTS;
    proto.evWin = SINGLE_TOUCH_WINDOW_EVENTS;
    _this = _Input.apply(this, arguments) || this;
    _this.started = false;
    return _this;
  }

  var _proto = SingleTouchInput.prototype;

  _proto.handler = function handler(ev) {
    var type = SINGLE_TOUCH_INPUT_MAP[ev.type]; // should we handle the touch events?

    if (type === INPUT_START) {
      this.started = true;
    }

    if (!this.started) {
      return;
    }

    var touches = normalizeSingleTouches.call(this, ev, type); // when done, reset the started state

    if (type & (INPUT_END | INPUT_CANCEL) && touches[0].length - touches[1].length === 0) {
      this.started = false;
    }

    this.callback(this.manager, type, {
      pointers: touches[0],
      changedPointers: touches[1],
      pointerType: INPUT_TYPE_TOUCH,
      srcEvent: ev
    });
  };

  return SingleTouchInput;
}(Input);

function normalizeSingleTouches(ev, type) {
  var all = toArray(ev.touches);
  var changed = toArray(ev.changedTouches);

  if (type & (INPUT_END | INPUT_CANCEL)) {
    all = uniqueArray(all.concat(changed), 'identifier', true);
  }

  return [all, changed];
}

/**
 * @private
 * wrap a method with a deprecation warning and stack trace
 * @param {Function} method
 * @param {String} name
 * @param {String} message
 * @returns {Function} A new function wrapping the supplied method.
 */
function deprecate(method, name, message) {
  var deprecationMessage = "DEPRECATED METHOD: " + name + "\n" + message + " AT \n";
  return function () {
    var e = new Error('get-stack-trace');
    var stack = e && e.stack ? e.stack.replace(/^[^\(]+?[\n$]/gm, '').replace(/^\s+at\s+/gm, '').replace(/^Object.<anonymous>\s*\(/gm, '{anonymous}()@') : 'Unknown Stack Trace';
    var log = window.console && (window.console.warn || window.console.log);

    if (log) {
      log.call(window.console, deprecationMessage, stack);
    }

    return method.apply(this, arguments);
  };
}

/**
 * @private
 * extend object.
 * means that properties in dest will be overwritten by the ones in src.
 * @param {Object} dest
 * @param {Object} src
 * @param {Boolean} [merge=false]
 * @returns {Object} dest
 */

var extend = deprecate(function (dest, src, merge) {
  var keys = Object.keys(src);
  var i = 0;

  while (i < keys.length) {
    if (!merge || merge && dest[keys[i]] === undefined) {
      dest[keys[i]] = src[keys[i]];
    }

    i++;
  }

  return dest;
}, 'extend', 'Use `assign`.');

/**
 * @private
 * merge the values from src in the dest.
 * means that properties that exist in dest will not be overwritten by src
 * @param {Object} dest
 * @param {Object} src
 * @returns {Object} dest
 */

var merge$2 = deprecate(function (dest, src) {
  return extend(dest, src, true);
}, 'merge', 'Use `assign`.');

/**
 * @private
 * simple class inheritance
 * @param {Function} child
 * @param {Function} base
 * @param {Object} [properties]
 */

function inherit(child, base, properties) {
  var baseP = base.prototype;
  var childP;
  childP = child.prototype = Object.create(baseP);
  childP.constructor = child;
  childP._super = baseP;

  if (properties) {
    assign$1(childP, properties);
  }
}

/**
 * @private
 * simple function bind
 * @param {Function} fn
 * @param {Object} context
 * @returns {Function}
 */
function bindFn(fn, context) {
  return function boundFn() {
    return fn.apply(context, arguments);
  };
}

/**
 * @private
 * Simple way to create a manager with a default set of recognizers.
 * @param {HTMLElement} element
 * @param {Object} [options]
 * @constructor
 */

var Hammer$2 =
/*#__PURE__*/
function () {
  var Hammer =
  /**
    * @private
    * @const {string}
    */
  function Hammer(element, options) {
    if (options === void 0) {
      options = {};
    }

    return new Manager(element, _extends({
      recognizers: preset.concat()
    }, options));
  };

  Hammer.VERSION = "2.0.17-rc";
  Hammer.DIRECTION_ALL = DIRECTION_ALL;
  Hammer.DIRECTION_DOWN = DIRECTION_DOWN;
  Hammer.DIRECTION_LEFT = DIRECTION_LEFT;
  Hammer.DIRECTION_RIGHT = DIRECTION_RIGHT;
  Hammer.DIRECTION_UP = DIRECTION_UP;
  Hammer.DIRECTION_HORIZONTAL = DIRECTION_HORIZONTAL;
  Hammer.DIRECTION_VERTICAL = DIRECTION_VERTICAL;
  Hammer.DIRECTION_NONE = DIRECTION_NONE;
  Hammer.DIRECTION_DOWN = DIRECTION_DOWN;
  Hammer.INPUT_START = INPUT_START;
  Hammer.INPUT_MOVE = INPUT_MOVE;
  Hammer.INPUT_END = INPUT_END;
  Hammer.INPUT_CANCEL = INPUT_CANCEL;
  Hammer.STATE_POSSIBLE = STATE_POSSIBLE;
  Hammer.STATE_BEGAN = STATE_BEGAN;
  Hammer.STATE_CHANGED = STATE_CHANGED;
  Hammer.STATE_ENDED = STATE_ENDED;
  Hammer.STATE_RECOGNIZED = STATE_RECOGNIZED;
  Hammer.STATE_CANCELLED = STATE_CANCELLED;
  Hammer.STATE_FAILED = STATE_FAILED;
  Hammer.Manager = Manager;
  Hammer.Input = Input;
  Hammer.TouchAction = TouchAction;
  Hammer.TouchInput = TouchInput;
  Hammer.MouseInput = MouseInput;
  Hammer.PointerEventInput = PointerEventInput;
  Hammer.TouchMouseInput = TouchMouseInput;
  Hammer.SingleTouchInput = SingleTouchInput;
  Hammer.Recognizer = Recognizer;
  Hammer.AttrRecognizer = AttrRecognizer;
  Hammer.Tap = TapRecognizer;
  Hammer.Pan = PanRecognizer;
  Hammer.Swipe = SwipeRecognizer;
  Hammer.Pinch = PinchRecognizer;
  Hammer.Rotate = RotateRecognizer;
  Hammer.Press = PressRecognizer;
  Hammer.on = addEventListeners;
  Hammer.off = removeEventListeners;
  Hammer.each = each;
  Hammer.merge = merge$2;
  Hammer.extend = extend;
  Hammer.bindFn = bindFn;
  Hammer.assign = assign$1;
  Hammer.inherit = inherit;
  Hammer.bindFn = bindFn;
  Hammer.prefixed = prefixed;
  Hammer.toArray = toArray;
  Hammer.inArray = inArray;
  Hammer.uniqueArray = uniqueArray;
  Hammer.splitStr = splitStr;
  Hammer.boolOrFn = boolOrFn;
  Hammer.hasParent = hasParent;
  Hammer.addEventListeners = addEventListeners;
  Hammer.removeEventListeners = removeEventListeners;
  Hammer.defaults = assign$1({}, defaults, {
    preset: preset
  });
  return Hammer;
}();

//  style loader but by script tag, not by the loader.

Hammer$2.defaults;

var RealHammer = Hammer$2;

/**
 * Use this symbol to delete properies in deepObjectAssign.
 */
_Symbol$1("DELETE");

/**
 * Seedable, fast and reasonably good (not crypto but more than okay for our
 * needs) random number generator.
 *
 * @remarks
 * Adapted from {@link https://web.archive.org/web/20110429100736/http://baagoe.com:80/en/RandomMusings/javascript}.
 * Original algorithm created by Johannes Baagøe \<baagoe\@baagoe.com\> in 2010.
 */
/**
 * Create a seeded pseudo random generator based on Alea by Johannes Baagøe.
 *
 * @param seed - All supplied arguments will be used as a seed. In case nothing
 * is supplied the current time will be used to seed the generator.
 * @returns A ready to use seeded generator.
 */
function Alea() {
  for (var _len3 = arguments.length, seed = new Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
    seed[_key3] = arguments[_key3];
  }
  return AleaImplementation(seed.length ? seed : [_Date$now()]);
}
/**
 * An implementation of [[Alea]] without user input validation.
 *
 * @param seed - The data that will be used to seed the generator.
 * @returns A ready to use seeded generator.
 */
function AleaImplementation(seed) {
  let [s0, s1, s2] = mashSeed(seed);
  let c = 1;
  const random = () => {
    const t = 2091639 * s0 + c * 2.3283064365386963e-10; // 2^-32
    s0 = s1;
    s1 = s2;
    return s2 = t - (c = t | 0);
  };
  random.uint32 = () => random() * 0x100000000; // 2^32
  random.fract53 = () => random() + (random() * 0x200000 | 0) * 1.1102230246251565e-16; // 2^-53
  random.algorithm = "Alea";
  random.seed = seed;
  random.version = "0.9";
  return random;
}
/**
 * Turn arbitrary data into values [[AleaImplementation]] can use to generate
 * random numbers.
 *
 * @param seed - Arbitrary data that will be used as the seed.
 * @returns Three numbers to use as initial values for [[AleaImplementation]].
 */
function mashSeed() {
  const mash = Mash();
  let s0 = mash(" ");
  let s1 = mash(" ");
  let s2 = mash(" ");
  for (let i = 0; i < arguments.length; i++) {
    s0 -= mash(i < 0 || arguments.length <= i ? undefined : arguments[i]);
    if (s0 < 0) {
      s0 += 1;
    }
    s1 -= mash(i < 0 || arguments.length <= i ? undefined : arguments[i]);
    if (s1 < 0) {
      s1 += 1;
    }
    s2 -= mash(i < 0 || arguments.length <= i ? undefined : arguments[i]);
    if (s2 < 0) {
      s2 += 1;
    }
  }
  return [s0, s1, s2];
}
/**
 * Create a new mash function.
 *
 * @returns A nonpure function that takes arbitrary [[Mashable]] data and turns
 * them into numbers.
 */
function Mash() {
  let n = 0xefc8249d;
  return function (data) {
    const string = data.toString();
    for (let i = 0; i < string.length; i++) {
      n += string.charCodeAt(i);
      let h = 0.02519603282416938 * n;
      n = h >>> 0;
      h -= n;
      h *= n;
      n = h >>> 0;
      h -= n;
      n += h * 0x100000000; // 2^32
    }

    return (n >>> 0) * 2.3283064365386963e-10; // 2^-32
  };
}

/**
 * Setup a mock hammer.js object, for unit testing.
 *
 * Inspiration: https://github.com/uber/deck.gl/pull/658
 *
 * @returns {{on: noop, off: noop, destroy: noop, emit: noop, get: get}}
 */
function hammerMock() {
  const noop = () => {};
  return {
    on: noop,
    off: noop,
    destroy: noop,
    emit: noop,
    get() {
      return {
        set: noop
      };
    }
  };
}
const Hammer$1 = typeof window !== "undefined" ? window.Hammer || RealHammer : function () {
  // hammer.js is only available in a browser, not in node.js. Replacing it with a mock object.
  return hammerMock();
};

/**
 * Turn an element into an clickToUse element.
 * When not active, the element has a transparent overlay. When the overlay is
 * clicked, the mode is changed to active.
 * When active, the element is displayed with a blue border around it, and
 * the interactive contents of the element can be used. When clicked outside
 * the element, the elements mode is changed to inactive.
 *
 * @param {Element} container
 * @class Activator
 */
function Activator$1(container) {
  var _context;
  this._cleanupQueue = [];
  this.active = false;
  this._dom = {
    container,
    overlay: document.createElement("div")
  };
  this._dom.overlay.classList.add("vis-overlay");
  this._dom.container.appendChild(this._dom.overlay);
  this._cleanupQueue.push(() => {
    this._dom.overlay.parentNode.removeChild(this._dom.overlay);
  });
  const hammer = Hammer$1(this._dom.overlay);
  hammer.on("tap", _bindInstanceProperty(_context = this._onTapOverlay).call(_context, this));
  this._cleanupQueue.push(() => {
    hammer.destroy();
    // FIXME: cleaning up hammer instances doesn't work (Timeline not removed
    // from memory)
  });

  // block all touch events (except tap)
  const events = ["tap", "doubletap", "press", "pinch", "pan", "panstart", "panmove", "panend"];
  _forEachInstanceProperty(events).call(events, event => {
    hammer.on(event, event => {
      event.srcEvent.stopPropagation();
    });
  });

  // attach a click event to the window, in order to deactivate when clicking outside the timeline
  if (document && document.body) {
    this._onClick = event => {
      if (!_hasParent(event.target, container)) {
        this.deactivate();
      }
    };
    document.body.addEventListener("click", this._onClick);
    this._cleanupQueue.push(() => {
      document.body.removeEventListener("click", this._onClick);
    });
  }

  // prepare escape key listener for deactivating when active
  this._escListener = event => {
    if ("key" in event ? event.key === "Escape" : event.keyCode === 27 /* the keyCode is for IE11 */) {
      this.deactivate();
    }
  };
}

// turn into an event emitter
Emitter(Activator$1.prototype);

// The currently active activator
Activator$1.current = null;

/**
 * Destroy the activator. Cleans up all created DOM and event listeners
 */
Activator$1.prototype.destroy = function () {
  this.deactivate();
  for (const callback of _reverseInstanceProperty(_context2 = _spliceInstanceProperty(_context3 = this._cleanupQueue).call(_context3, 0)).call(_context2)) {
    var _context2, _context3;
    callback();
  }
};

/**
 * Activate the element
 * Overlay is hidden, element is decorated with a blue shadow border
 */
Activator$1.prototype.activate = function () {
  // we allow only one active activator at a time
  if (Activator$1.current) {
    Activator$1.current.deactivate();
  }
  Activator$1.current = this;
  this.active = true;
  this._dom.overlay.style.display = "none";
  this._dom.container.classList.add("vis-active");
  this.emit("change");
  this.emit("activate");

  // ugly hack: bind ESC after emitting the events, as the Network rebinds all
  // keyboard events on a 'change' event
  document.body.addEventListener("keydown", this._escListener);
};

/**
 * Deactivate the element
 * Overlay is displayed on top of the element
 */
Activator$1.prototype.deactivate = function () {
  this.active = false;
  this._dom.overlay.style.display = "block";
  this._dom.container.classList.remove("vis-active");
  document.body.removeEventListener("keydown", this._escListener);
  this.emit("change");
  this.emit("deactivate");
};

/**
 * Handle a tap event: activate the container
 *
 * @param {Event}  event   The event
 * @private
 */
Activator$1.prototype._onTapOverlay = function (event) {
  // activate the container
  this.activate();
  event.srcEvent.stopPropagation();
};

/**
 * Test whether the element has the requested parent element somewhere in
 * its chain of parent nodes.
 *
 * @param {HTMLElement} element
 * @param {HTMLElement} parent
 * @returns {boolean} Returns true when the parent is found somewhere in the
 *                    chain of parent nodes.
 * @private
 */
function _hasParent(element, parent) {
  while (element) {
    if (element === parent) {
      return true;
    }
    element = element.parentNode;
  }
  return false;
}
// Color REs
const fullHexRE = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i;
const shortHexRE = /^#?([a-f\d])([a-f\d])([a-f\d])$/i;
const rgbRE = /^rgb\( *(1?\d{1,2}|2[0-4]\d|25[0-5]) *, *(1?\d{1,2}|2[0-4]\d|25[0-5]) *, *(1?\d{1,2}|2[0-4]\d|25[0-5]) *\)$/i;
const rgbaRE = /^rgba\( *(1?\d{1,2}|2[0-4]\d|25[0-5]) *, *(1?\d{1,2}|2[0-4]\d|25[0-5]) *, *(1?\d{1,2}|2[0-4]\d|25[0-5]) *, *([01]|0?\.\d+) *\)$/i;
/**
 * Remove everything in the DOM object.
 *
 * @param DOMobject - Node whose child nodes will be recursively deleted.
 */
function recursiveDOMDelete(DOMobject) {
  if (DOMobject) {
    while (DOMobject.hasChildNodes() === true) {
      const child = DOMobject.firstChild;
      if (child) {
        recursiveDOMDelete(child);
        DOMobject.removeChild(child);
      }
    }
  }
}
/**
 * Test whether given object is a string.
 *
 * @param value - Input value of unknown type.
 * @returns True if string, false otherwise.
 */
function isString(value) {
  return value instanceof String || typeof value === "string";
}
/**
 * Test whether given object is a object (not primitive or null).
 *
 * @param value - Input value of unknown type.
 * @returns True if not null object, false otherwise.
 */
function isObject$5(value) {
  return typeof value === "object" && value !== null;
}
/**
 * Copy property from b to a if property present in a.
 * If property in b explicitly set to null, delete it if `allowDeletion` set.
 *
 * Internal helper routine, should not be exported. Not added to `exports` for that reason.
 *
 * @param a - Target object.
 * @param b - Source object.
 * @param prop - Name of property to copy from b to a.
 * @param allowDeletion - If true, delete property in a if explicitly set to null in b.
 */
function copyOrDelete(a, b, prop, allowDeletion) {
  let doDeletion = false;
  if (allowDeletion === true) {
    doDeletion = b[prop] === null && a[prop] !== undefined;
  }
  if (doDeletion) {
    delete a[prop];
  } else {
    a[prop] = b[prop]; // Remember, this is a reference copy!
  }
}
/**
 * Fill an object with a possibly partially defined other object.
 *
 * Only copies values for the properties already present in a.
 * That means an object is not created on a property if only the b object has it.
 *
 * @param a - The object that will have it's properties updated.
 * @param b - The object with property updates.
 * @param allowDeletion - If true, delete properties in a that are explicitly set to null in b.
 */
function fillIfDefined(a, b) {
  let allowDeletion = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
  // NOTE: iteration of properties of a
  // NOTE: prototype properties iterated over as well
  for (const prop in a) {
    if (b[prop] !== undefined) {
      if (b[prop] === null || typeof b[prop] !== "object") {
        // Note: typeof null === 'object'
        copyOrDelete(a, b, prop, allowDeletion);
      } else {
        const aProp = a[prop];
        const bProp = b[prop];
        if (isObject$5(aProp) && isObject$5(bProp)) {
          fillIfDefined(aProp, bProp, allowDeletion);
        }
      }
    }
  }
}
/**
 * Extend object a with selected properties of object b.
 * Only properties with defined values are copied.
 *
 * @remarks
 * Previous version of this routine implied that multiple source objects could
 * be used; however, the implementation was **wrong**. Since multiple (\>1)
 * sources weren't used anywhere in the `vis.js` code, this has been removed
 * @param props - Names of first-level properties to copy over.
 * @param a - Target object.
 * @param b - Source object.
 * @param allowDeletion - If true, delete property in a if explicitly set to null in b.
 * @returns Argument a.
 */
function selectiveDeepExtend(props, a, b) {
  let allowDeletion = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;
  // TODO: add support for Arrays to deepExtend
  if (_Array$isArray(b)) {
    throw new TypeError("Arrays are not supported by deepExtend");
  }
  for (let p = 0; p < props.length; p++) {
    const prop = props[p];
    if (Object.prototype.hasOwnProperty.call(b, prop)) {
      if (b[prop] && b[prop].constructor === Object) {
        if (a[prop] === undefined) {
          a[prop] = {};
        }
        if (a[prop].constructor === Object) {
          deepExtend(a[prop], b[prop], false, allowDeletion);
        } else {
          copyOrDelete(a, b, prop, allowDeletion);
        }
      } else if (_Array$isArray(b[prop])) {
        throw new TypeError("Arrays are not supported by deepExtend");
      } else {
        copyOrDelete(a, b, prop, allowDeletion);
      }
    }
  }
  return a;
}
/**
 * Extend object `a` with properties of object `b`, ignoring properties which
 * are explicitly specified to be excluded.
 *
 * @remarks
 * The properties of `b` are considered for copying. Properties which are
 * themselves objects are are also extended. Only properties with defined
 * values are copied.
 * @param propsToExclude - Names of properties which should *not* be copied.
 * @param a - Object to extend.
 * @param b - Object to take properties from for extension.
 * @param allowDeletion - If true, delete properties in a that are explicitly
 * set to null in b.
 * @returns Argument a.
 */
function selectiveNotDeepExtend(propsToExclude, a, b) {
  let allowDeletion = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;
  // TODO: add support for Arrays to deepExtend
  // NOTE: array properties have an else-below; apparently, there is a problem here.
  if (_Array$isArray(b)) {
    throw new TypeError("Arrays are not supported by deepExtend");
  }
  for (const prop in b) {
    if (!Object.prototype.hasOwnProperty.call(b, prop)) {
      continue;
    } // Handle local properties only
    if (_includesInstanceProperty(propsToExclude).call(propsToExclude, prop)) {
      continue;
    } // In exclusion list, skip
    if (b[prop] && b[prop].constructor === Object) {
      if (a[prop] === undefined) {
        a[prop] = {};
      }
      if (a[prop].constructor === Object) {
        deepExtend(a[prop], b[prop]); // NOTE: allowDeletion not propagated!
      } else {
        copyOrDelete(a, b, prop, allowDeletion);
      }
    } else if (_Array$isArray(b[prop])) {
      a[prop] = [];
      for (let i = 0; i < b[prop].length; i++) {
        a[prop].push(b[prop][i]);
      }
    } else {
      copyOrDelete(a, b, prop, allowDeletion);
    }
  }
  return a;
}
/**
 * Deep extend an object a with the properties of object b.
 *
 * @param a - Target object.
 * @param b - Source object.
 * @param protoExtend - If true, the prototype values will also be extended.
 * (That is the options objects that inherit from others will also get the
 * inherited options).
 * @param allowDeletion - If true, the values of fields that are null will be deleted.
 * @returns Argument a.
 */
function deepExtend(a, b) {
  let protoExtend = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
  let allowDeletion = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;
  for (const prop in b) {
    if (Object.prototype.hasOwnProperty.call(b, prop) || protoExtend === true) {
      if (typeof b[prop] === "object" && b[prop] !== null && _Object$getPrototypeOf(b[prop]) === Object.prototype) {
        if (a[prop] === undefined) {
          a[prop] = deepExtend({}, b[prop], protoExtend); // NOTE: allowDeletion not propagated!
        } else if (typeof a[prop] === "object" && a[prop] !== null && _Object$getPrototypeOf(a[prop]) === Object.prototype) {
          deepExtend(a[prop], b[prop], protoExtend); // NOTE: allowDeletion not propagated!
        } else {
          copyOrDelete(a, b, prop, allowDeletion);
        }
      } else if (_Array$isArray(b[prop])) {
        var _context4;
        a[prop] = _sliceInstanceProperty(_context4 = b[prop]).call(_context4);
      } else {
        copyOrDelete(a, b, prop, allowDeletion);
      }
    }
  }
  return a;
}
/**
 * Used to extend an array and copy it. This is used to propagate paths recursively.
 *
 * @param arr - First part.
 * @param newValue - The value to be aadded into the array.
 * @returns A new array with all items from arr and newValue (which is last).
 */
function copyAndExtendArray(arr, newValue) {
  return [...arr, newValue];
}
/**
 * Used to extend an array and copy it. This is used to propagate paths recursively.
 *
 * @param arr - The array to be copied.
 * @returns Shallow copy of arr.
 */
function copyArray(arr) {
  return _sliceInstanceProperty(arr).call(arr);
}
/**
 * Retrieve the absolute left value of a DOM element.
 *
 * @param elem - A dom element, for example a div.
 * @returns The absolute left position of this element in the browser page.
 */
function getAbsoluteLeft(elem) {
  return elem.getBoundingClientRect().left;
}
/**
 * Retrieve the absolute top value of a DOM element.
 *
 * @param elem - A dom element, for example a div.
 * @returns The absolute top position of this element in the browser page.
 */
function getAbsoluteTop(elem) {
  return elem.getBoundingClientRect().top;
}
/**
 * For each method for both arrays and objects.
 * In case of an array, the built-in Array.forEach() is applied (**No, it's not!**).
 * In case of an Object, the method loops over all properties of the object.
 *
 * @param object - An Object or Array to be iterated over.
 * @param callback - Array.forEach-like callback.
 */
function forEach$1(object, callback) {
  if (_Array$isArray(object)) {
    // array
    const len = object.length;
    for (let i = 0; i < len; i++) {
      callback(object[i], i, object);
    }
  } else {
    // object
    for (const key in object) {
      if (Object.prototype.hasOwnProperty.call(object, key)) {
        callback(object[key], key, object);
      }
    }
  }
}
/**
 * Convert hex color string into RGB color object.
 *
 * @remarks
 * {@link http://stackoverflow.com/questions/5623838/rgb-to-hex-and-hex-to-rgb}
 * @param hex - Hex color string (3 or 6 digits, with or without #).
 * @returns RGB color object.
 */
function hexToRGB(hex) {
  let result;
  switch (hex.length) {
    case 3:
    case 4:
      result = shortHexRE.exec(hex);
      return result ? {
        r: _parseInt$1(result[1] + result[1], 16),
        g: _parseInt$1(result[2] + result[2], 16),
        b: _parseInt$1(result[3] + result[3], 16)
      } : null;
    case 6:
    case 7:
      result = fullHexRE.exec(hex);
      return result ? {
        r: _parseInt$1(result[1], 16),
        g: _parseInt$1(result[2], 16),
        b: _parseInt$1(result[3], 16)
      } : null;
    default:
      return null;
  }
}
/**
 * This function takes string color in hex or RGB format and adds the opacity, RGBA is passed through unchanged.
 *
 * @param color - The color string (hex, RGB, RGBA).
 * @param opacity - The new opacity.
 * @returns RGBA string, for example 'rgba(255, 0, 127, 0.3)'.
 */
function overrideOpacity(color, opacity) {
  if (_includesInstanceProperty(color).call(color, "rgba")) {
    return color;
  } else if (_includesInstanceProperty(color).call(color, "rgb")) {
    const rgb = color.substr(_indexOfInstanceProperty(color).call(color, "(") + 1).replace(")", "").split(",");
    return "rgba(" + rgb[0] + "," + rgb[1] + "," + rgb[2] + "," + opacity + ")";
  } else {
    const rgb = hexToRGB(color);
    if (rgb == null) {
      return color;
    } else {
      return "rgba(" + rgb.r + "," + rgb.g + "," + rgb.b + "," + opacity + ")";
    }
  }
}
/**
 * Convert RGB \<0, 255\> into hex color string.
 *
 * @param red - Red channel.
 * @param green - Green channel.
 * @param blue - Blue channel.
 * @returns Hex color string (for example: '#0acdc0').
 */
function RGBToHex(red, green, blue) {
  var _context5;
  return "#" + _sliceInstanceProperty(_context5 = ((1 << 24) + (red << 16) + (green << 8) + blue).toString(16)).call(_context5, 1);
}
/**
 * Parse a color property into an object with border, background, and highlight colors.
 *
 * @param inputColor - Shorthand color string or input color object.
 * @param defaultColor - Full color object to fill in missing values in inputColor.
 * @returns Color object.
 */
function parseColor(inputColor, defaultColor) {
  if (isString(inputColor)) {
    let colorStr = inputColor;
    if (isValidRGB(colorStr)) {
      var _context6;
      const rgb = _mapInstanceProperty(_context6 = colorStr.substr(4).substr(0, colorStr.length - 5).split(",")).call(_context6, function (value) {
        return _parseInt$1(value);
      });
      colorStr = RGBToHex(rgb[0], rgb[1], rgb[2]);
    }
    if (isValidHex(colorStr) === true) {
      const hsv = hexToHSV(colorStr);
      const lighterColorHSV = {
        h: hsv.h,
        s: hsv.s * 0.8,
        v: Math.min(1, hsv.v * 1.02)
      };
      const darkerColorHSV = {
        h: hsv.h,
        s: Math.min(1, hsv.s * 1.25),
        v: hsv.v * 0.8
      };
      const darkerColorHex = HSVToHex(darkerColorHSV.h, darkerColorHSV.s, darkerColorHSV.v);
      const lighterColorHex = HSVToHex(lighterColorHSV.h, lighterColorHSV.s, lighterColorHSV.v);
      return {
        background: colorStr,
        border: darkerColorHex,
        highlight: {
          background: lighterColorHex,
          border: darkerColorHex
        },
        hover: {
          background: lighterColorHex,
          border: darkerColorHex
        }
      };
    } else {
      return {
        background: colorStr,
        border: colorStr,
        highlight: {
          background: colorStr,
          border: colorStr
        },
        hover: {
          background: colorStr,
          border: colorStr
        }
      };
    }
  } else {
    if (defaultColor) {
      const color = {
        background: inputColor.background || defaultColor.background,
        border: inputColor.border || defaultColor.border,
        highlight: isString(inputColor.highlight) ? {
          border: inputColor.highlight,
          background: inputColor.highlight
        } : {
          background: inputColor.highlight && inputColor.highlight.background || defaultColor.highlight.background,
          border: inputColor.highlight && inputColor.highlight.border || defaultColor.highlight.border
        },
        hover: isString(inputColor.hover) ? {
          border: inputColor.hover,
          background: inputColor.hover
        } : {
          border: inputColor.hover && inputColor.hover.border || defaultColor.hover.border,
          background: inputColor.hover && inputColor.hover.background || defaultColor.hover.background
        }
      };
      return color;
    } else {
      const color = {
        background: inputColor.background || undefined,
        border: inputColor.border || undefined,
        highlight: isString(inputColor.highlight) ? {
          border: inputColor.highlight,
          background: inputColor.highlight
        } : {
          background: inputColor.highlight && inputColor.highlight.background || undefined,
          border: inputColor.highlight && inputColor.highlight.border || undefined
        },
        hover: isString(inputColor.hover) ? {
          border: inputColor.hover,
          background: inputColor.hover
        } : {
          border: inputColor.hover && inputColor.hover.border || undefined,
          background: inputColor.hover && inputColor.hover.background || undefined
        }
      };
      return color;
    }
  }
}
/**
 * Convert RGB \<0, 255\> into HSV object.
 *
 * @remarks
 * {@link http://www.javascripter.net/faq/rgb2hsv.htm}
 * @param red - Red channel.
 * @param green - Green channel.
 * @param blue - Blue channel.
 * @returns HSV color object.
 */
function RGBToHSV(red, green, blue) {
  red = red / 255;
  green = green / 255;
  blue = blue / 255;
  const minRGB = Math.min(red, Math.min(green, blue));
  const maxRGB = Math.max(red, Math.max(green, blue));
  // Black-gray-white
  if (minRGB === maxRGB) {
    return {
      h: 0,
      s: 0,
      v: minRGB
    };
  }
  // Colors other than black-gray-white:
  const d = red === minRGB ? green - blue : blue === minRGB ? red - green : blue - red;
  const h = red === minRGB ? 3 : blue === minRGB ? 1 : 5;
  const hue = 60 * (h - d / (maxRGB - minRGB)) / 360;
  const saturation = (maxRGB - minRGB) / maxRGB;
  const value = maxRGB;
  return {
    h: hue,
    s: saturation,
    v: value
  };
}
/**
 * Convert HSV \<0, 1\> into RGB color object.
 *
 * @remarks
 * {@link https://gist.github.com/mjijackson/5311256}
 * @param h - Hue.
 * @param s - Saturation.
 * @param v - Value.
 * @returns RGB color object.
 */
function HSVToRGB(h, s, v) {
  let r;
  let g;
  let b;
  const i = Math.floor(h * 6);
  const f = h * 6 - i;
  const p = v * (1 - s);
  const q = v * (1 - f * s);
  const t = v * (1 - (1 - f) * s);
  switch (i % 6) {
    case 0:
      r = v, g = t, b = p;
      break;
    case 1:
      r = q, g = v, b = p;
      break;
    case 2:
      r = p, g = v, b = t;
      break;
    case 3:
      r = p, g = q, b = v;
      break;
    case 4:
      r = t, g = p, b = v;
      break;
    case 5:
      r = v, g = p, b = q;
      break;
  }
  return {
    r: Math.floor(r * 255),
    g: Math.floor(g * 255),
    b: Math.floor(b * 255)
  };
}
/**
 * Convert HSV \<0, 1\> into hex color string.
 *
 * @param h - Hue.
 * @param s - Saturation.
 * @param v - Value.
 * @returns Hex color string.
 */
function HSVToHex(h, s, v) {
  const rgb = HSVToRGB(h, s, v);
  return RGBToHex(rgb.r, rgb.g, rgb.b);
}
/**
 * Convert hex color string into HSV \<0, 1\>.
 *
 * @param hex - Hex color string.
 * @returns HSV color object.
 */
function hexToHSV(hex) {
  const rgb = hexToRGB(hex);
  if (!rgb) {
    throw new TypeError("'".concat(hex, "' is not a valid color."));
  }
  return RGBToHSV(rgb.r, rgb.g, rgb.b);
}
/**
 * Validate hex color string.
 *
 * @param hex - Unknown string that may contain a color.
 * @returns True if the string is valid, false otherwise.
 */
function isValidHex(hex) {
  const isOk = /(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i.test(hex);
  return isOk;
}
/**
 * Validate RGB color string.
 *
 * @param rgb - Unknown string that may contain a color.
 * @returns True if the string is valid, false otherwise.
 */
function isValidRGB(rgb) {
  return rgbRE.test(rgb);
}
/**
 * Validate RGBA color string.
 *
 * @param rgba - Unknown string that may contain a color.
 * @returns True if the string is valid, false otherwise.
 */
function isValidRGBA(rgba) {
  return rgbaRE.test(rgba);
}
/**
 * This recursively redirects the prototype of JSON objects to the referenceObject.
 * This is used for default options.
 *
 * @param referenceObject - The original object.
 * @returns The Element if the referenceObject is an Element, or a new object inheriting from the referenceObject.
 */
function bridgeObject(referenceObject) {
  if (referenceObject === null || typeof referenceObject !== "object") {
    return null;
  }
  if (referenceObject instanceof Element) {
    // Avoid bridging DOM objects
    return referenceObject;
  }
  const objectTo = _Object$create(referenceObject);
  for (const i in referenceObject) {
    if (Object.prototype.hasOwnProperty.call(referenceObject, i)) {
      if (typeof referenceObject[i] == "object") {
        objectTo[i] = bridgeObject(referenceObject[i]);
      }
    }
  }
  return objectTo;
}
/**
 * This is used to set the options of subobjects in the options object.
 *
 * A requirement of these subobjects is that they have an 'enabled' element
 * which is optional for the user but mandatory for the program.
 *
 * The added value here of the merge is that option 'enabled' is set as required.
 *
 * @param mergeTarget - Either this.options or the options used for the groups.
 * @param options - Options.
 * @param option - Option key in the options argument.
 * @param globalOptions - Global options, passed in to determine value of option 'enabled'.
 */
function mergeOptions(mergeTarget, options, option) {
  let globalOptions = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};
  // Local helpers
  const isPresent = function (obj) {
    return obj !== null && obj !== undefined;
  };
  const isObject = function (obj) {
    return obj !== null && typeof obj === "object";
  };
  // https://stackoverflow.com/a/34491287/1223531
  const isEmpty = function (obj) {
    for (const x in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, x)) {
        return false;
      }
    }
    return true;
  };
  // Guards
  if (!isObject(mergeTarget)) {
    throw new Error("Parameter mergeTarget must be an object");
  }
  if (!isObject(options)) {
    throw new Error("Parameter options must be an object");
  }
  if (!isPresent(option)) {
    throw new Error("Parameter option must have a value");
  }
  if (!isObject(globalOptions)) {
    throw new Error("Parameter globalOptions must be an object");
  }
  //
  // Actual merge routine, separated from main logic
  // Only a single level of options is merged. Deeper levels are ref'd. This may actually be an issue.
  //
  const doMerge = function (target, options, option) {
    if (!isObject(target[option])) {
      target[option] = {};
    }
    const src = options[option];
    const dst = target[option];
    for (const prop in src) {
      if (Object.prototype.hasOwnProperty.call(src, prop)) {
        dst[prop] = src[prop];
      }
    }
  };
  // Local initialization
  const srcOption = options[option];
  const globalPassed = isObject(globalOptions) && !isEmpty(globalOptions);
  const globalOption = globalPassed ? globalOptions[option] : undefined;
  const globalEnabled = globalOption ? globalOption.enabled : undefined;
  /////////////////////////////////////////
  // Main routine
  /////////////////////////////////////////
  if (srcOption === undefined) {
    return; // Nothing to do
  }

  if (typeof srcOption === "boolean") {
    if (!isObject(mergeTarget[option])) {
      mergeTarget[option] = {};
    }
    mergeTarget[option].enabled = srcOption;
    return;
  }
  if (srcOption === null && !isObject(mergeTarget[option])) {
    // If possible, explicit copy from globals
    if (isPresent(globalOption)) {
      mergeTarget[option] = _Object$create(globalOption);
    } else {
      return; // Nothing to do
    }
  }

  if (!isObject(srcOption)) {
    return;
  }
  //
  // Ensure that 'enabled' is properly set. It is required internally
  // Note that the value from options will always overwrite the existing value
  //
  let enabled = true; // default value
  if (srcOption.enabled !== undefined) {
    enabled = srcOption.enabled;
  } else {
    // Take from globals, if present
    if (globalEnabled !== undefined) {
      enabled = globalOption.enabled;
    }
  }
  doMerge(mergeTarget, options, option);
  mergeTarget[option].enabled = enabled;
}
/*
 * Easing Functions.
 * Only considering the t value for the range [0, 1] => [0, 1].
 *
 * Inspiration: from http://gizma.com/easing/
 * https://gist.github.com/gre/1650294
 */
const easingFunctions = {
  /**
   * Provides no easing and no acceleration.
   *
   * @param t - Time.
   * @returns Value at time t.
   */
  linear(t) {
    return t;
  },
  /**
   * Accelerate from zero velocity.
   *
   * @param t - Time.
   * @returns Value at time t.
   */
  easeInQuad(t) {
    return t * t;
  },
  /**
   * Decelerate to zero velocity.
   *
   * @param t - Time.
   * @returns Value at time t.
   */
  easeOutQuad(t) {
    return t * (2 - t);
  },
  /**
   * Accelerate until halfway, then decelerate.
   *
   * @param t - Time.
   * @returns Value at time t.
   */
  easeInOutQuad(t) {
    return t < 0.5 ? 2 * t * t : -1 + (4 - 2 * t) * t;
  },
  /**
   * Accelerate from zero velocity.
   *
   * @param t - Time.
   * @returns Value at time t.
   */
  easeInCubic(t) {
    return t * t * t;
  },
  /**
   * Decelerate to zero velocity.
   *
   * @param t - Time.
   * @returns Value at time t.
   */
  easeOutCubic(t) {
    return --t * t * t + 1;
  },
  /**
   * Accelerate until halfway, then decelerate.
   *
   * @param t - Time.
   * @returns Value at time t.
   */
  easeInOutCubic(t) {
    return t < 0.5 ? 4 * t * t * t : (t - 1) * (2 * t - 2) * (2 * t - 2) + 1;
  },
  /**
   * Accelerate from zero velocity.
   *
   * @param t - Time.
   * @returns Value at time t.
   */
  easeInQuart(t) {
    return t * t * t * t;
  },
  /**
   * Decelerate to zero velocity.
   *
   * @param t - Time.
   * @returns Value at time t.
   */
  easeOutQuart(t) {
    return 1 - --t * t * t * t;
  },
  /**
   * Accelerate until halfway, then decelerate.
   *
   * @param t - Time.
   * @returns Value at time t.
   */
  easeInOutQuart(t) {
    return t < 0.5 ? 8 * t * t * t * t : 1 - 8 * --t * t * t * t;
  },
  /**
   * Accelerate from zero velocity.
   *
   * @param t - Time.
   * @returns Value at time t.
   */
  easeInQuint(t) {
    return t * t * t * t * t;
  },
  /**
   * Decelerate to zero velocity.
   *
   * @param t - Time.
   * @returns Value at time t.
   */
  easeOutQuint(t) {
    return 1 + --t * t * t * t * t;
  },
  /**
   * Accelerate until halfway, then decelerate.
   *
   * @param t - Time.
   * @returns Value at time t.
   */
  easeInOutQuint(t) {
    return t < 0.5 ? 16 * t * t * t * t * t : 1 + 16 * --t * t * t * t * t;
  }
};
// @TODO: This doesn't work properly.
// It works only for single property objects,
// otherwise it combines all of the types in a union.
// export function topMost<K1 extends string, V1> (
//   pile: Record<K1, undefined | V1>[],
//   accessors: K1 | [K1]
// ): undefined | V1
// export function topMost<K1 extends string, K2 extends string, V1, V2> (
//   pile: Record<K1, undefined | V1 | Record<K2, undefined | V2>>[],
//   accessors: [K1, K2]
// ): undefined | V1 | V2
// export function topMost<K1 extends string, K2 extends string, K3 extends string, V1, V2, V3> (
//   pile: Record<K1, undefined | V1 | Record<K2, undefined | V2 | Record<K3, undefined | V3>>>[],
//   accessors: [K1, K2, K3]
// ): undefined | V1 | V2 | V3
/**
 * Get the top most property value from a pile of objects.
 *
 * @param pile - Array of objects, no required format.
 * @param accessors - Array of property names.
 * For example `object['foo']['bar']` → `['foo', 'bar']`.
 * @returns Value of the property with given accessors path from the first pile item where it's not undefined.
 */
function topMost(pile, accessors) {
  let candidate;
  if (!_Array$isArray(accessors)) {
    accessors = [accessors];
  }
  for (const member of pile) {
    if (member) {
      candidate = member[accessors[0]];
      for (let i = 1; i < accessors.length; i++) {
        if (candidate) {
          candidate = candidate[accessors[i]];
        }
      }
      if (typeof candidate !== "undefined") {
        break;
      }
    }
  }
  return candidate;
}
const htmlColors = {
  black: "#000000",
  navy: "#000080",
  darkblue: "#00008B",
  mediumblue: "#0000CD",
  blue: "#0000FF",
  darkgreen: "#006400",
  green: "#008000",
  teal: "#008080",
  darkcyan: "#008B8B",
  deepskyblue: "#00BFFF",
  darkturquoise: "#00CED1",
  mediumspringgreen: "#00FA9A",
  lime: "#00FF00",
  springgreen: "#00FF7F",
  aqua: "#00FFFF",
  cyan: "#00FFFF",
  midnightblue: "#191970",
  dodgerblue: "#1E90FF",
  lightseagreen: "#20B2AA",
  forestgreen: "#228B22",
  seagreen: "#2E8B57",
  darkslategray: "#2F4F4F",
  limegreen: "#32CD32",
  mediumseagreen: "#3CB371",
  turquoise: "#40E0D0",
  royalblue: "#4169E1",
  steelblue: "#4682B4",
  darkslateblue: "#483D8B",
  mediumturquoise: "#48D1CC",
  indigo: "#4B0082",
  darkolivegreen: "#556B2F",
  cadetblue: "#5F9EA0",
  cornflowerblue: "#6495ED",
  mediumaquamarine: "#66CDAA",
  dimgray: "#696969",
  slateblue: "#6A5ACD",
  olivedrab: "#6B8E23",
  slategray: "#708090",
  lightslategray: "#778899",
  mediumslateblue: "#7B68EE",
  lawngreen: "#7CFC00",
  chartreuse: "#7FFF00",
  aquamarine: "#7FFFD4",
  maroon: "#800000",
  purple: "#800080",
  olive: "#808000",
  gray: "#808080",
  skyblue: "#87CEEB",
  lightskyblue: "#87CEFA",
  blueviolet: "#8A2BE2",
  darkred: "#8B0000",
  darkmagenta: "#8B008B",
  saddlebrown: "#8B4513",
  darkseagreen: "#8FBC8F",
  lightgreen: "#90EE90",
  mediumpurple: "#9370D8",
  darkviolet: "#9400D3",
  palegreen: "#98FB98",
  darkorchid: "#9932CC",
  yellowgreen: "#9ACD32",
  sienna: "#A0522D",
  brown: "#A52A2A",
  darkgray: "#A9A9A9",
  lightblue: "#ADD8E6",
  greenyellow: "#ADFF2F",
  paleturquoise: "#AFEEEE",
  lightsteelblue: "#B0C4DE",
  powderblue: "#B0E0E6",
  firebrick: "#B22222",
  darkgoldenrod: "#B8860B",
  mediumorchid: "#BA55D3",
  rosybrown: "#BC8F8F",
  darkkhaki: "#BDB76B",
  silver: "#C0C0C0",
  mediumvioletred: "#C71585",
  indianred: "#CD5C5C",
  peru: "#CD853F",
  chocolate: "#D2691E",
  tan: "#D2B48C",
  lightgrey: "#D3D3D3",
  palevioletred: "#D87093",
  thistle: "#D8BFD8",
  orchid: "#DA70D6",
  goldenrod: "#DAA520",
  crimson: "#DC143C",
  gainsboro: "#DCDCDC",
  plum: "#DDA0DD",
  burlywood: "#DEB887",
  lightcyan: "#E0FFFF",
  lavender: "#E6E6FA",
  darksalmon: "#E9967A",
  violet: "#EE82EE",
  palegoldenrod: "#EEE8AA",
  lightcoral: "#F08080",
  khaki: "#F0E68C",
  aliceblue: "#F0F8FF",
  honeydew: "#F0FFF0",
  azure: "#F0FFFF",
  sandybrown: "#F4A460",
  wheat: "#F5DEB3",
  beige: "#F5F5DC",
  whitesmoke: "#F5F5F5",
  mintcream: "#F5FFFA",
  ghostwhite: "#F8F8FF",
  salmon: "#FA8072",
  antiquewhite: "#FAEBD7",
  linen: "#FAF0E6",
  lightgoldenrodyellow: "#FAFAD2",
  oldlace: "#FDF5E6",
  red: "#FF0000",
  fuchsia: "#FF00FF",
  magenta: "#FF00FF",
  deeppink: "#FF1493",
  orangered: "#FF4500",
  tomato: "#FF6347",
  hotpink: "#FF69B4",
  coral: "#FF7F50",
  darkorange: "#FF8C00",
  lightsalmon: "#FFA07A",
  orange: "#FFA500",
  lightpink: "#FFB6C1",
  pink: "#FFC0CB",
  gold: "#FFD700",
  peachpuff: "#FFDAB9",
  navajowhite: "#FFDEAD",
  moccasin: "#FFE4B5",
  bisque: "#FFE4C4",
  mistyrose: "#FFE4E1",
  blanchedalmond: "#FFEBCD",
  papayawhip: "#FFEFD5",
  lavenderblush: "#FFF0F5",
  seashell: "#FFF5EE",
  cornsilk: "#FFF8DC",
  lemonchiffon: "#FFFACD",
  floralwhite: "#FFFAF0",
  snow: "#FFFAFA",
  yellow: "#FFFF00",
  lightyellow: "#FFFFE0",
  ivory: "#FFFFF0",
  white: "#FFFFFF"
};

/**
 * @param {number} [pixelRatio=1]
 */
let ColorPicker$1 = class ColorPicker {
  /**
   * @param {number} [pixelRatio=1]
   */
  constructor() {
    let pixelRatio = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 1;
    this.pixelRatio = pixelRatio;
    this.generated = false;
    this.centerCoordinates = {
      x: 289 / 2,
      y: 289 / 2
    };
    this.r = 289 * 0.49;
    this.color = {
      r: 255,
      g: 255,
      b: 255,
      a: 1.0
    };
    this.hueCircle = undefined;
    this.initialColor = {
      r: 255,
      g: 255,
      b: 255,
      a: 1.0
    };
    this.previousColor = undefined;
    this.applied = false;

    // bound by
    this.updateCallback = () => {};
    this.closeCallback = () => {};

    // create all DOM elements
    this._create();
  }

  /**
   * this inserts the colorPicker into a div from the DOM
   *
   * @param {Element} container
   */
  insertTo(container) {
    if (this.hammer !== undefined) {
      this.hammer.destroy();
      this.hammer = undefined;
    }
    this.container = container;
    this.container.appendChild(this.frame);
    this._bindHammer();
    this._setSize();
  }

  /**
   * the callback is executed on apply and save. Bind it to the application
   *
   * @param {Function} callback
   */
  setUpdateCallback(callback) {
    if (typeof callback === "function") {
      this.updateCallback = callback;
    } else {
      throw new Error("Function attempted to set as colorPicker update callback is not a function.");
    }
  }

  /**
   * the callback is executed on apply and save. Bind it to the application
   *
   * @param {Function} callback
   */
  setCloseCallback(callback) {
    if (typeof callback === "function") {
      this.closeCallback = callback;
    } else {
      throw new Error("Function attempted to set as colorPicker closing callback is not a function.");
    }
  }

  /**
   *
   * @param {string} color
   * @returns {string}
   * @private
   */
  _isColorString(color) {
    if (typeof color === "string") {
      return htmlColors[color];
    }
  }

  /**
   * Set the color of the colorPicker
   * Supported formats:
   * 'red'                   --> HTML color string
   * '#ffffff'               --> hex string
   * 'rgb(255,255,255)'      --> rgb string
   * 'rgba(255,255,255,1.0)' --> rgba string
   * {r:255,g:255,b:255}     --> rgb object
   * {r:255,g:255,b:255,a:1.0} --> rgba object
   *
   * @param {string | object} color
   * @param {boolean} [setInitial=true]
   */
  setColor(color) {
    let setInitial = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
    if (color === "none") {
      return;
    }
    let rgba;

    // if a html color shorthand is used, convert to hex
    const htmlColor = this._isColorString(color);
    if (htmlColor !== undefined) {
      color = htmlColor;
    }

    // check format
    if (isString(color) === true) {
      if (isValidRGB(color) === true) {
        const rgbaArray = color.substr(4).substr(0, color.length - 5).split(",");
        rgba = {
          r: rgbaArray[0],
          g: rgbaArray[1],
          b: rgbaArray[2],
          a: 1.0
        };
      } else if (isValidRGBA(color) === true) {
        const rgbaArray = color.substr(5).substr(0, color.length - 6).split(",");
        rgba = {
          r: rgbaArray[0],
          g: rgbaArray[1],
          b: rgbaArray[2],
          a: rgbaArray[3]
        };
      } else if (isValidHex(color) === true) {
        const rgbObj = hexToRGB(color);
        rgba = {
          r: rgbObj.r,
          g: rgbObj.g,
          b: rgbObj.b,
          a: 1.0
        };
      }
    } else {
      if (color instanceof Object) {
        if (color.r !== undefined && color.g !== undefined && color.b !== undefined) {
          const alpha = color.a !== undefined ? color.a : "1.0";
          rgba = {
            r: color.r,
            g: color.g,
            b: color.b,
            a: alpha
          };
        }
      }
    }

    // set color
    if (rgba === undefined) {
      throw new Error("Unknown color passed to the colorPicker. Supported are strings: rgb, hex, rgba. Object: rgb ({r:r,g:g,b:b,[a:a]}). Supplied: " + _JSON$stringify(color));
    } else {
      this._setColor(rgba, setInitial);
    }
  }

  /**
   * this shows the color picker.
   * The hue circle is constructed once and stored.
   */
  show() {
    if (this.closeCallback !== undefined) {
      this.closeCallback();
      this.closeCallback = undefined;
    }
    this.applied = false;
    this.frame.style.display = "block";
    this._generateHueCircle();
  }

  // ------------------------------------------ PRIVATE ----------------------------- //

  /**
   * Hide the picker. Is called by the cancel button.
   * Optional boolean to store the previous color for easy access later on.
   *
   * @param {boolean} [storePrevious=true]
   * @private
   */
  _hide() {
    let storePrevious = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;
    // store the previous color for next time;
    if (storePrevious === true) {
      this.previousColor = _Object$assign({}, this.color);
    }
    if (this.applied === true) {
      this.updateCallback(this.initialColor);
    }
    this.frame.style.display = "none";

    // call the closing callback, restoring the onclick method.
    // this is in a setTimeout because it will trigger the show again before the click is done.
    _setTimeout(() => {
      if (this.closeCallback !== undefined) {
        this.closeCallback();
        this.closeCallback = undefined;
      }
    }, 0);
  }

  /**
   * bound to the save button. Saves and hides.
   *
   * @private
   */
  _save() {
    this.updateCallback(this.color);
    this.applied = false;
    this._hide();
  }

  /**
   * Bound to apply button. Saves but does not close. Is undone by the cancel button.
   *
   * @private
   */
  _apply() {
    this.applied = true;
    this.updateCallback(this.color);
    this._updatePicker(this.color);
  }

  /**
   * load the color from the previous session.
   *
   * @private
   */
  _loadLast() {
    if (this.previousColor !== undefined) {
      this.setColor(this.previousColor, false);
    } else {
      alert("There is no last color to load...");
    }
  }

  /**
   * set the color, place the picker
   *
   * @param {object} rgba
   * @param {boolean} [setInitial=true]
   * @private
   */
  _setColor(rgba) {
    let setInitial = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
    // store the initial color
    if (setInitial === true) {
      this.initialColor = _Object$assign({}, rgba);
    }
    this.color = rgba;
    const hsv = RGBToHSV(rgba.r, rgba.g, rgba.b);
    const angleConvert = 2 * Math.PI;
    const radius = this.r * hsv.s;
    const x = this.centerCoordinates.x + radius * Math.sin(angleConvert * hsv.h);
    const y = this.centerCoordinates.y + radius * Math.cos(angleConvert * hsv.h);
    this.colorPickerSelector.style.left = x - 0.5 * this.colorPickerSelector.clientWidth + "px";
    this.colorPickerSelector.style.top = y - 0.5 * this.colorPickerSelector.clientHeight + "px";
    this._updatePicker(rgba);
  }

  /**
   * bound to opacity control
   *
   * @param {number} value
   * @private
   */
  _setOpacity(value) {
    this.color.a = value / 100;
    this._updatePicker(this.color);
  }

  /**
   * bound to brightness control
   *
   * @param {number} value
   * @private
   */
  _setBrightness(value) {
    const hsv = RGBToHSV(this.color.r, this.color.g, this.color.b);
    hsv.v = value / 100;
    const rgba = HSVToRGB(hsv.h, hsv.s, hsv.v);
    rgba["a"] = this.color.a;
    this.color = rgba;
    this._updatePicker();
  }

  /**
   * update the color picker. A black circle overlays the hue circle to mimic the brightness decreasing.
   *
   * @param {object} rgba
   * @private
   */
  _updatePicker() {
    let rgba = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.color;
    const hsv = RGBToHSV(rgba.r, rgba.g, rgba.b);
    const ctx = this.colorPickerCanvas.getContext("2d");
    if (this.pixelRation === undefined) {
      this.pixelRatio = (window.devicePixelRatio || 1) / (ctx.webkitBackingStorePixelRatio || ctx.mozBackingStorePixelRatio || ctx.msBackingStorePixelRatio || ctx.oBackingStorePixelRatio || ctx.backingStorePixelRatio || 1);
    }
    ctx.setTransform(this.pixelRatio, 0, 0, this.pixelRatio, 0, 0);

    // clear the canvas
    const w = this.colorPickerCanvas.clientWidth;
    const h = this.colorPickerCanvas.clientHeight;
    ctx.clearRect(0, 0, w, h);
    ctx.putImageData(this.hueCircle, 0, 0);
    ctx.fillStyle = "rgba(0,0,0," + (1 - hsv.v) + ")";
    ctx.circle(this.centerCoordinates.x, this.centerCoordinates.y, this.r);
    _fillInstanceProperty(ctx).call(ctx);
    this.brightnessRange.value = 100 * hsv.v;
    this.opacityRange.value = 100 * rgba.a;
    this.initialColorDiv.style.backgroundColor = "rgba(" + this.initialColor.r + "," + this.initialColor.g + "," + this.initialColor.b + "," + this.initialColor.a + ")";
    this.newColorDiv.style.backgroundColor = "rgba(" + this.color.r + "," + this.color.g + "," + this.color.b + "," + this.color.a + ")";
  }

  /**
   * used by create to set the size of the canvas.
   *
   * @private
   */
  _setSize() {
    this.colorPickerCanvas.style.width = "100%";
    this.colorPickerCanvas.style.height = "100%";
    this.colorPickerCanvas.width = 289 * this.pixelRatio;
    this.colorPickerCanvas.height = 289 * this.pixelRatio;
  }

  /**
   * create all dom elements
   * TODO: cleanup, lots of similar dom elements
   *
   * @private
   */
  _create() {
    var _context7, _context8, _context9, _context10;
    this.frame = document.createElement("div");
    this.frame.className = "vis-color-picker";
    this.colorPickerDiv = document.createElement("div");
    this.colorPickerSelector = document.createElement("div");
    this.colorPickerSelector.className = "vis-selector";
    this.colorPickerDiv.appendChild(this.colorPickerSelector);
    this.colorPickerCanvas = document.createElement("canvas");
    this.colorPickerDiv.appendChild(this.colorPickerCanvas);
    if (!this.colorPickerCanvas.getContext) {
      const noCanvas = document.createElement("DIV");
      noCanvas.style.color = "red";
      noCanvas.style.fontWeight = "bold";
      noCanvas.style.padding = "10px";
      noCanvas.innerText = "Error: your browser does not support HTML canvas";
      this.colorPickerCanvas.appendChild(noCanvas);
    } else {
      const ctx = this.colorPickerCanvas.getContext("2d");
      this.pixelRatio = (window.devicePixelRatio || 1) / (ctx.webkitBackingStorePixelRatio || ctx.mozBackingStorePixelRatio || ctx.msBackingStorePixelRatio || ctx.oBackingStorePixelRatio || ctx.backingStorePixelRatio || 1);
      this.colorPickerCanvas.getContext("2d").setTransform(this.pixelRatio, 0, 0, this.pixelRatio, 0, 0);
    }
    this.colorPickerDiv.className = "vis-color";
    this.opacityDiv = document.createElement("div");
    this.opacityDiv.className = "vis-opacity";
    this.brightnessDiv = document.createElement("div");
    this.brightnessDiv.className = "vis-brightness";
    this.arrowDiv = document.createElement("div");
    this.arrowDiv.className = "vis-arrow";
    this.opacityRange = document.createElement("input");
    try {
      this.opacityRange.type = "range"; // Not supported on IE9
      this.opacityRange.min = "0";
      this.opacityRange.max = "100";
    } catch (err) {
      // TODO: Add some error handling.
    }
    this.opacityRange.value = "100";
    this.opacityRange.className = "vis-range";
    this.brightnessRange = document.createElement("input");
    try {
      this.brightnessRange.type = "range"; // Not supported on IE9
      this.brightnessRange.min = "0";
      this.brightnessRange.max = "100";
    } catch (err) {
      // TODO: Add some error handling.
    }
    this.brightnessRange.value = "100";
    this.brightnessRange.className = "vis-range";
    this.opacityDiv.appendChild(this.opacityRange);
    this.brightnessDiv.appendChild(this.brightnessRange);
    const me = this;
    this.opacityRange.onchange = function () {
      me._setOpacity(this.value);
    };
    this.opacityRange.oninput = function () {
      me._setOpacity(this.value);
    };
    this.brightnessRange.onchange = function () {
      me._setBrightness(this.value);
    };
    this.brightnessRange.oninput = function () {
      me._setBrightness(this.value);
    };
    this.brightnessLabel = document.createElement("div");
    this.brightnessLabel.className = "vis-label vis-brightness";
    this.brightnessLabel.innerText = "brightness:";
    this.opacityLabel = document.createElement("div");
    this.opacityLabel.className = "vis-label vis-opacity";
    this.opacityLabel.innerText = "opacity:";
    this.newColorDiv = document.createElement("div");
    this.newColorDiv.className = "vis-new-color";
    this.newColorDiv.innerText = "new";
    this.initialColorDiv = document.createElement("div");
    this.initialColorDiv.className = "vis-initial-color";
    this.initialColorDiv.innerText = "initial";
    this.cancelButton = document.createElement("div");
    this.cancelButton.className = "vis-button vis-cancel";
    this.cancelButton.innerText = "cancel";
    this.cancelButton.onclick = _bindInstanceProperty(_context7 = this._hide).call(_context7, this, false);
    this.applyButton = document.createElement("div");
    this.applyButton.className = "vis-button vis-apply";
    this.applyButton.innerText = "apply";
    this.applyButton.onclick = _bindInstanceProperty(_context8 = this._apply).call(_context8, this);
    this.saveButton = document.createElement("div");
    this.saveButton.className = "vis-button vis-save";
    this.saveButton.innerText = "save";
    this.saveButton.onclick = _bindInstanceProperty(_context9 = this._save).call(_context9, this);
    this.loadButton = document.createElement("div");
    this.loadButton.className = "vis-button vis-load";
    this.loadButton.innerText = "load last";
    this.loadButton.onclick = _bindInstanceProperty(_context10 = this._loadLast).call(_context10, this);
    this.frame.appendChild(this.colorPickerDiv);
    this.frame.appendChild(this.arrowDiv);
    this.frame.appendChild(this.brightnessLabel);
    this.frame.appendChild(this.brightnessDiv);
    this.frame.appendChild(this.opacityLabel);
    this.frame.appendChild(this.opacityDiv);
    this.frame.appendChild(this.newColorDiv);
    this.frame.appendChild(this.initialColorDiv);
    this.frame.appendChild(this.cancelButton);
    this.frame.appendChild(this.applyButton);
    this.frame.appendChild(this.saveButton);
    this.frame.appendChild(this.loadButton);
  }

  /**
   * bind hammer to the color picker
   *
   * @private
   */
  _bindHammer() {
    this.drag = {};
    this.pinch = {};
    this.hammer = new Hammer$1(this.colorPickerCanvas);
    this.hammer.get("pinch").set({
      enable: true
    });
    this.hammer.on("hammer.input", event => {
      if (event.isFirst) {
        this._moveSelector(event);
      }
    });
    this.hammer.on("tap", event => {
      this._moveSelector(event);
    });
    this.hammer.on("panstart", event => {
      this._moveSelector(event);
    });
    this.hammer.on("panmove", event => {
      this._moveSelector(event);
    });
    this.hammer.on("panend", event => {
      this._moveSelector(event);
    });
  }

  /**
   * generate the hue circle. This is relatively heavy (200ms) and is done only once on the first time it is shown.
   *
   * @private
   */
  _generateHueCircle() {
    if (this.generated === false) {
      const ctx = this.colorPickerCanvas.getContext("2d");
      if (this.pixelRation === undefined) {
        this.pixelRatio = (window.devicePixelRatio || 1) / (ctx.webkitBackingStorePixelRatio || ctx.mozBackingStorePixelRatio || ctx.msBackingStorePixelRatio || ctx.oBackingStorePixelRatio || ctx.backingStorePixelRatio || 1);
      }
      ctx.setTransform(this.pixelRatio, 0, 0, this.pixelRatio, 0, 0);

      // clear the canvas
      const w = this.colorPickerCanvas.clientWidth;
      const h = this.colorPickerCanvas.clientHeight;
      ctx.clearRect(0, 0, w, h);

      // draw hue circle
      let x, y, hue, sat;
      this.centerCoordinates = {
        x: w * 0.5,
        y: h * 0.5
      };
      this.r = 0.49 * w;
      const angleConvert = 2 * Math.PI / 360;
      const hfac = 1 / 360;
      const sfac = 1 / this.r;
      let rgb;
      for (hue = 0; hue < 360; hue++) {
        for (sat = 0; sat < this.r; sat++) {
          x = this.centerCoordinates.x + sat * Math.sin(angleConvert * hue);
          y = this.centerCoordinates.y + sat * Math.cos(angleConvert * hue);
          rgb = HSVToRGB(hue * hfac, sat * sfac, 1);
          ctx.fillStyle = "rgb(" + rgb.r + "," + rgb.g + "," + rgb.b + ")";
          ctx.fillRect(x - 0.5, y - 0.5, 2, 2);
        }
      }
      ctx.strokeStyle = "rgba(0,0,0,1)";
      ctx.circle(this.centerCoordinates.x, this.centerCoordinates.y, this.r);
      ctx.stroke();
      this.hueCircle = ctx.getImageData(0, 0, w, h);
    }
    this.generated = true;
  }

  /**
   * move the selector. This is called by hammer functions.
   *
   * @param {Event}  event   The event
   * @private
   */
  _moveSelector(event) {
    const rect = this.colorPickerDiv.getBoundingClientRect();
    const left = event.center.x - rect.left;
    const top = event.center.y - rect.top;
    const centerY = 0.5 * this.colorPickerDiv.clientHeight;
    const centerX = 0.5 * this.colorPickerDiv.clientWidth;
    const x = left - centerX;
    const y = top - centerY;
    const angle = Math.atan2(x, y);
    const radius = 0.98 * Math.min(Math.sqrt(x * x + y * y), centerX);
    const newTop = Math.cos(angle) * radius + centerY;
    const newLeft = Math.sin(angle) * radius + centerX;
    this.colorPickerSelector.style.top = newTop - 0.5 * this.colorPickerSelector.clientHeight + "px";
    this.colorPickerSelector.style.left = newLeft - 0.5 * this.colorPickerSelector.clientWidth + "px";

    // set color
    let h = angle / (2 * Math.PI);
    h = h < 0 ? h + 1 : h;
    const s = radius / this.r;
    const hsv = RGBToHSV(this.color.r, this.color.g, this.color.b);
    hsv.h = h;
    hsv.s = s;
    const rgba = HSVToRGB(hsv.h, hsv.s, hsv.v);
    rgba["a"] = this.color.a;
    this.color = rgba;

    // update previews
    this.initialColorDiv.style.backgroundColor = "rgba(" + this.initialColor.r + "," + this.initialColor.g + "," + this.initialColor.b + "," + this.initialColor.a + ")";
    this.newColorDiv.style.backgroundColor = "rgba(" + this.color.r + "," + this.color.g + "," + this.color.b + "," + this.color.a + ")";
  }
};

/**
 * Wrap given text (last argument) in HTML elements (all preceding arguments).
 *
 * @param {...any} rest - List of tag names followed by inner text.
 * @returns An element or a text node.
 */
function wrapInTag() {
  for (var _len5 = arguments.length, rest = new Array(_len5), _key5 = 0; _key5 < _len5; _key5++) {
    rest[_key5] = arguments[_key5];
  }
  if (rest.length < 1) {
    throw new TypeError("Invalid arguments.");
  } else if (rest.length === 1) {
    return document.createTextNode(rest[0]);
  } else {
    const element = document.createElement(rest[0]);
    element.appendChild(wrapInTag(..._sliceInstanceProperty(rest).call(rest, 1)));
    return element;
  }
}

/**
 * The way this works is for all properties of this.possible options, you can supply the property name in any form to list the options.
 * Boolean options are recognised as Boolean
 * Number options should be written as array: [default value, min value, max value, stepsize]
 * Colors should be written as array: ['color', '#ffffff']
 * Strings with should be written as array: [option1, option2, option3, ..]
 *
 * The options are matched with their counterparts in each of the modules and the values used in the configuration are
 */
let Configurator$1 = class Configurator {
  /**
   * @param {object} parentModule        | the location where parentModule.setOptions() can be called
   * @param {object} defaultContainer    | the default container of the module
   * @param {object} configureOptions    | the fully configured and predefined options set found in allOptions.js
   * @param {number} pixelRatio          | canvas pixel ratio
   * @param {Function} hideOption        | custom logic to dynamically hide options
   */
  constructor(parentModule, defaultContainer, configureOptions) {
    let pixelRatio = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 1;
    let hideOption = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : () => false;
    this.parent = parentModule;
    this.changedOptions = [];
    this.container = defaultContainer;
    this.allowCreation = false;
    this.hideOption = hideOption;
    this.options = {};
    this.initialized = false;
    this.popupCounter = 0;
    this.defaultOptions = {
      enabled: false,
      filter: true,
      container: undefined,
      showButton: true
    };
    _Object$assign(this.options, this.defaultOptions);
    this.configureOptions = configureOptions;
    this.moduleOptions = {};
    this.domElements = [];
    this.popupDiv = {};
    this.popupLimit = 5;
    this.popupHistory = {};
    this.colorPicker = new ColorPicker$1(pixelRatio);
    this.wrapper = undefined;
  }

  /**
   * refresh all options.
   * Because all modules parse their options by themselves, we just use their options. We copy them here.
   *
   * @param {object} options
   */
  setOptions(options) {
    if (options !== undefined) {
      // reset the popup history because the indices may have been changed.
      this.popupHistory = {};
      this._removePopup();
      let enabled = true;
      if (typeof options === "string") {
        this.options.filter = options;
      } else if (_Array$isArray(options)) {
        this.options.filter = options.join();
      } else if (typeof options === "object") {
        if (options == null) {
          throw new TypeError("options cannot be null");
        }
        if (options.container !== undefined) {
          this.options.container = options.container;
        }
        if (_filterInstanceProperty(options) !== undefined) {
          this.options.filter = _filterInstanceProperty(options);
        }
        if (options.showButton !== undefined) {
          this.options.showButton = options.showButton;
        }
        if (options.enabled !== undefined) {
          enabled = options.enabled;
        }
      } else if (typeof options === "boolean") {
        this.options.filter = true;
        enabled = options;
      } else if (typeof options === "function") {
        this.options.filter = options;
        enabled = true;
      }
      if (_filterInstanceProperty(this.options) === false) {
        enabled = false;
      }
      this.options.enabled = enabled;
    }
    this._clean();
  }

  /**
   *
   * @param {object} moduleOptions
   */
  setModuleOptions(moduleOptions) {
    this.moduleOptions = moduleOptions;
    if (this.options.enabled === true) {
      this._clean();
      if (this.options.container !== undefined) {
        this.container = this.options.container;
      }
      this._create();
    }
  }

  /**
   * Create all DOM elements
   *
   * @private
   */
  _create() {
    this._clean();
    this.changedOptions = [];
    const filter = _filterInstanceProperty(this.options);
    let counter = 0;
    let show = false;
    for (const option in this.configureOptions) {
      if (Object.prototype.hasOwnProperty.call(this.configureOptions, option)) {
        this.allowCreation = false;
        show = false;
        if (typeof filter === "function") {
          show = filter(option, []);
          show = show || this._handleObject(this.configureOptions[option], [option], true);
        } else if (filter === true || _indexOfInstanceProperty(filter).call(filter, option) !== -1) {
          show = true;
        }
        if (show !== false) {
          this.allowCreation = true;

          // linebreak between categories
          if (counter > 0) {
            this._makeItem([]);
          }
          // a header for the category
          this._makeHeader(option);

          // get the sub options
          this._handleObject(this.configureOptions[option], [option]);
        }
        counter++;
      }
    }
    this._makeButton();
    this._push();
    //~ this.colorPicker.insertTo(this.container);
  }

  /**
   * draw all DOM elements on the screen
   *
   * @private
   */
  _push() {
    this.wrapper = document.createElement("div");
    this.wrapper.className = "vis-configuration-wrapper";
    this.container.appendChild(this.wrapper);
    for (let i = 0; i < this.domElements.length; i++) {
      this.wrapper.appendChild(this.domElements[i]);
    }
    this._showPopupIfNeeded();
  }

  /**
   * delete all DOM elements
   *
   * @private
   */
  _clean() {
    for (let i = 0; i < this.domElements.length; i++) {
      this.wrapper.removeChild(this.domElements[i]);
    }
    if (this.wrapper !== undefined) {
      this.container.removeChild(this.wrapper);
      this.wrapper = undefined;
    }
    this.domElements = [];
    this._removePopup();
  }

  /**
   * get the value from the actualOptions if it exists
   *
   * @param {Array} path    | where to look for the actual option
   * @returns {*}
   * @private
   */
  _getValue(path) {
    let base = this.moduleOptions;
    for (let i = 0; i < path.length; i++) {
      if (base[path[i]] !== undefined) {
        base = base[path[i]];
      } else {
        base = undefined;
        break;
      }
    }
    return base;
  }

  /**
   * all option elements are wrapped in an item
   *
   * @param {Array} path    | where to look for the actual option
   * @param {Array.<Element>} domElements
   * @returns {number}
   * @private
   */
  _makeItem(path) {
    if (this.allowCreation === true) {
      const item = document.createElement("div");
      item.className = "vis-configuration vis-config-item vis-config-s" + path.length;
      for (var _len6 = arguments.length, domElements = new Array(_len6 > 1 ? _len6 - 1 : 0), _key6 = 1; _key6 < _len6; _key6++) {
        domElements[_key6 - 1] = arguments[_key6];
      }
      _forEachInstanceProperty(domElements).call(domElements, element => {
        item.appendChild(element);
      });
      this.domElements.push(item);
      return this.domElements.length;
    }
    return 0;
  }

  /**
   * header for major subjects
   *
   * @param {string} name
   * @private
   */
  _makeHeader(name) {
    const div = document.createElement("div");
    div.className = "vis-configuration vis-config-header";
    div.innerText = name;
    this._makeItem([], div);
  }

  /**
   * make a label, if it is an object label, it gets different styling.
   *
   * @param {string} name
   * @param {Array} path    | where to look for the actual option
   * @param {string} objectLabel
   * @returns {HTMLElement}
   * @private
   */
  _makeLabel(name, path) {
    let objectLabel = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
    const div = document.createElement("div");
    div.className = "vis-configuration vis-config-label vis-config-s" + path.length;
    if (objectLabel === true) {
      while (div.firstChild) {
        div.removeChild(div.firstChild);
      }
      div.appendChild(wrapInTag("i", "b", name));
    } else {
      div.innerText = name + ":";
    }
    return div;
  }

  /**
   * make a dropdown list for multiple possible string optoins
   *
   * @param {Array.<number>} arr
   * @param {number} value
   * @param {Array} path    | where to look for the actual option
   * @private
   */
  _makeDropdown(arr, value, path) {
    const select = document.createElement("select");
    select.className = "vis-configuration vis-config-select";
    let selectedValue = 0;
    if (value !== undefined) {
      if (_indexOfInstanceProperty(arr).call(arr, value) !== -1) {
        selectedValue = _indexOfInstanceProperty(arr).call(arr, value);
      }
    }
    for (let i = 0; i < arr.length; i++) {
      const option = document.createElement("option");
      option.value = arr[i];
      if (i === selectedValue) {
        option.selected = "selected";
      }
      option.innerText = arr[i];
      select.appendChild(option);
    }
    const me = this;
    select.onchange = function () {
      me._update(this.value, path);
    };
    const label = this._makeLabel(path[path.length - 1], path);
    this._makeItem(path, label, select);
  }

  /**
   * make a range object for numeric options
   *
   * @param {Array.<number>} arr
   * @param {number} value
   * @param {Array} path    | where to look for the actual option
   * @private
   */
  _makeRange(arr, value, path) {
    const defaultValue = arr[0];
    const min = arr[1];
    const max = arr[2];
    const step = arr[3];
    const range = document.createElement("input");
    range.className = "vis-configuration vis-config-range";
    try {
      range.type = "range"; // not supported on IE9
      range.min = min;
      range.max = max;
    } catch (err) {
      // TODO: Add some error handling.
    }
    range.step = step;

    // set up the popup settings in case they are needed.
    let popupString = "";
    let popupValue = 0;
    if (value !== undefined) {
      const factor = 1.2;
      if (value < 0 && value * factor < min) {
        range.min = Math.ceil(value * factor);
        popupValue = range.min;
        popupString = "range increased";
      } else if (value / factor < min) {
        range.min = Math.ceil(value / factor);
        popupValue = range.min;
        popupString = "range increased";
      }
      if (value * factor > max && max !== 1) {
        range.max = Math.ceil(value * factor);
        popupValue = range.max;
        popupString = "range increased";
      }
      range.value = value;
    } else {
      range.value = defaultValue;
    }
    const input = document.createElement("input");
    input.className = "vis-configuration vis-config-rangeinput";
    input.value = range.value;
    const me = this;
    range.onchange = function () {
      input.value = this.value;
      me._update(Number(this.value), path);
    };
    range.oninput = function () {
      input.value = this.value;
    };
    const label = this._makeLabel(path[path.length - 1], path);
    const itemIndex = this._makeItem(path, label, range, input);

    // if a popup is needed AND it has not been shown for this value, show it.
    if (popupString !== "" && this.popupHistory[itemIndex] !== popupValue) {
      this.popupHistory[itemIndex] = popupValue;
      this._setupPopup(popupString, itemIndex);
    }
  }

  /**
   * make a button object
   *
   * @private
   */
  _makeButton() {
    if (this.options.showButton === true) {
      const generateButton = document.createElement("div");
      generateButton.className = "vis-configuration vis-config-button";
      generateButton.innerText = "generate options";
      generateButton.onclick = () => {
        this._printOptions();
      };
      generateButton.onmouseover = () => {
        generateButton.className = "vis-configuration vis-config-button hover";
      };
      generateButton.onmouseout = () => {
        generateButton.className = "vis-configuration vis-config-button";
      };
      this.optionsContainer = document.createElement("div");
      this.optionsContainer.className = "vis-configuration vis-config-option-container";
      this.domElements.push(this.optionsContainer);
      this.domElements.push(generateButton);
    }
  }

  /**
   * prepare the popup
   *
   * @param {string} string
   * @param {number} index
   * @private
   */
  _setupPopup(string, index) {
    if (this.initialized === true && this.allowCreation === true && this.popupCounter < this.popupLimit) {
      const div = document.createElement("div");
      div.id = "vis-configuration-popup";
      div.className = "vis-configuration-popup";
      div.innerText = string;
      div.onclick = () => {
        this._removePopup();
      };
      this.popupCounter += 1;
      this.popupDiv = {
        html: div,
        index: index
      };
    }
  }

  /**
   * remove the popup from the dom
   *
   * @private
   */
  _removePopup() {
    if (this.popupDiv.html !== undefined) {
      this.popupDiv.html.parentNode.removeChild(this.popupDiv.html);
      clearTimeout(this.popupDiv.hideTimeout);
      clearTimeout(this.popupDiv.deleteTimeout);
      this.popupDiv = {};
    }
  }

  /**
   * Show the popup if it is needed.
   *
   * @private
   */
  _showPopupIfNeeded() {
    if (this.popupDiv.html !== undefined) {
      const correspondingElement = this.domElements[this.popupDiv.index];
      const rect = correspondingElement.getBoundingClientRect();
      this.popupDiv.html.style.left = rect.left + "px";
      this.popupDiv.html.style.top = rect.top - 30 + "px"; // 30 is the height;
      document.body.appendChild(this.popupDiv.html);
      this.popupDiv.hideTimeout = _setTimeout(() => {
        this.popupDiv.html.style.opacity = 0;
      }, 1500);
      this.popupDiv.deleteTimeout = _setTimeout(() => {
        this._removePopup();
      }, 1800);
    }
  }

  /**
   * make a checkbox for boolean options.
   *
   * @param {number} defaultValue
   * @param {number} value
   * @param {Array} path    | where to look for the actual option
   * @private
   */
  _makeCheckbox(defaultValue, value, path) {
    const checkbox = document.createElement("input");
    checkbox.type = "checkbox";
    checkbox.className = "vis-configuration vis-config-checkbox";
    checkbox.checked = defaultValue;
    if (value !== undefined) {
      checkbox.checked = value;
      if (value !== defaultValue) {
        if (typeof defaultValue === "object") {
          if (value !== defaultValue.enabled) {
            this.changedOptions.push({
              path: path,
              value: value
            });
          }
        } else {
          this.changedOptions.push({
            path: path,
            value: value
          });
        }
      }
    }
    const me = this;
    checkbox.onchange = function () {
      me._update(this.checked, path);
    };
    const label = this._makeLabel(path[path.length - 1], path);
    this._makeItem(path, label, checkbox);
  }

  /**
   * make a text input field for string options.
   *
   * @param {number} defaultValue
   * @param {number} value
   * @param {Array} path    | where to look for the actual option
   * @private
   */
  _makeTextInput(defaultValue, value, path) {
    const checkbox = document.createElement("input");
    checkbox.type = "text";
    checkbox.className = "vis-configuration vis-config-text";
    checkbox.value = value;
    if (value !== defaultValue) {
      this.changedOptions.push({
        path: path,
        value: value
      });
    }
    const me = this;
    checkbox.onchange = function () {
      me._update(this.value, path);
    };
    const label = this._makeLabel(path[path.length - 1], path);
    this._makeItem(path, label, checkbox);
  }

  /**
   * make a color field with a color picker for color fields
   *
   * @param {Array.<number>} arr
   * @param {number} value
   * @param {Array} path    | where to look for the actual option
   * @private
   */
  _makeColorField(arr, value, path) {
    const defaultColor = arr[1];
    const div = document.createElement("div");
    value = value === undefined ? defaultColor : value;
    if (value !== "none") {
      div.className = "vis-configuration vis-config-colorBlock";
      div.style.backgroundColor = value;
    } else {
      div.className = "vis-configuration vis-config-colorBlock none";
    }
    value = value === undefined ? defaultColor : value;
    div.onclick = () => {
      this._showColorPicker(value, div, path);
    };
    const label = this._makeLabel(path[path.length - 1], path);
    this._makeItem(path, label, div);
  }

  /**
   * used by the color buttons to call the color picker.
   *
   * @param {number} value
   * @param {HTMLElement} div
   * @param {Array} path    | where to look for the actual option
   * @private
   */
  _showColorPicker(value, div, path) {
    // clear the callback from this div
    div.onclick = function () {};
    this.colorPicker.insertTo(div);
    this.colorPicker.show();
    this.colorPicker.setColor(value);
    this.colorPicker.setUpdateCallback(color => {
      const colorString = "rgba(" + color.r + "," + color.g + "," + color.b + "," + color.a + ")";
      div.style.backgroundColor = colorString;
      this._update(colorString, path);
    });

    // on close of the colorpicker, restore the callback.
    this.colorPicker.setCloseCallback(() => {
      div.onclick = () => {
        this._showColorPicker(value, div, path);
      };
    });
  }

  /**
   * parse an object and draw the correct items
   *
   * @param {object} obj
   * @param {Array} [path=[]]    | where to look for the actual option
   * @param {boolean} [checkOnly=false]
   * @returns {boolean}
   * @private
   */
  _handleObject(obj) {
    let path = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
    let checkOnly = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
    let show = false;
    const filter = _filterInstanceProperty(this.options);
    let visibleInSet = false;
    for (const subObj in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, subObj)) {
        show = true;
        const item = obj[subObj];
        const newPath = copyAndExtendArray(path, subObj);
        if (typeof filter === "function") {
          show = filter(subObj, path);

          // if needed we must go deeper into the object.
          if (show === false) {
            if (!_Array$isArray(item) && typeof item !== "string" && typeof item !== "boolean" && item instanceof Object) {
              this.allowCreation = false;
              show = this._handleObject(item, newPath, true);
              this.allowCreation = checkOnly === false;
            }
          }
        }
        if (show !== false) {
          visibleInSet = true;
          const value = this._getValue(newPath);
          if (_Array$isArray(item)) {
            this._handleArray(item, value, newPath);
          } else if (typeof item === "string") {
            this._makeTextInput(item, value, newPath);
          } else if (typeof item === "boolean") {
            this._makeCheckbox(item, value, newPath);
          } else if (item instanceof Object) {
            // skip the options that are not enabled
            if (!this.hideOption(path, subObj, this.moduleOptions)) {
              // initially collapse options with an disabled enabled option.
              if (item.enabled !== undefined) {
                const enabledPath = copyAndExtendArray(newPath, "enabled");
                const enabledValue = this._getValue(enabledPath);
                if (enabledValue === true) {
                  const label = this._makeLabel(subObj, newPath, true);
                  this._makeItem(newPath, label);
                  visibleInSet = this._handleObject(item, newPath) || visibleInSet;
                } else {
                  this._makeCheckbox(item, enabledValue, newPath);
                }
              } else {
                const label = this._makeLabel(subObj, newPath, true);
                this._makeItem(newPath, label);
                visibleInSet = this._handleObject(item, newPath) || visibleInSet;
              }
            }
          } else {
            console.error("dont know how to handle", item, subObj, newPath);
          }
        }
      }
    }
    return visibleInSet;
  }

  /**
   * handle the array type of option
   *
   * @param {Array.<number>} arr
   * @param {number} value
   * @param {Array} path    | where to look for the actual option
   * @private
   */
  _handleArray(arr, value, path) {
    if (typeof arr[0] === "string" && arr[0] === "color") {
      this._makeColorField(arr, value, path);
      if (arr[1] !== value) {
        this.changedOptions.push({
          path: path,
          value: value
        });
      }
    } else if (typeof arr[0] === "string") {
      this._makeDropdown(arr, value, path);
      if (arr[0] !== value) {
        this.changedOptions.push({
          path: path,
          value: value
        });
      }
    } else if (typeof arr[0] === "number") {
      this._makeRange(arr, value, path);
      if (arr[0] !== value) {
        this.changedOptions.push({
          path: path,
          value: Number(value)
        });
      }
    }
  }

  /**
   * called to update the network with the new settings.
   *
   * @param {number} value
   * @param {Array} path    | where to look for the actual option
   * @private
   */
  _update(value, path) {
    const options = this._constructOptions(value, path);
    if (this.parent.body && this.parent.body.emitter && this.parent.body.emitter.emit) {
      this.parent.body.emitter.emit("configChange", options);
    }
    this.initialized = true;
    this.parent.setOptions(options);
  }

  /**
   *
   * @param {string | boolean} value
   * @param {Array.<string>} path
   * @param {{}} optionsObj
   * @returns {{}}
   * @private
   */
  _constructOptions(value, path) {
    let optionsObj = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    let pointer = optionsObj;

    // when dropdown boxes can be string or boolean, we typecast it into correct types
    value = value === "true" ? true : value;
    value = value === "false" ? false : value;
    for (let i = 0; i < path.length; i++) {
      if (path[i] !== "global") {
        if (pointer[path[i]] === undefined) {
          pointer[path[i]] = {};
        }
        if (i !== path.length - 1) {
          pointer = pointer[path[i]];
        } else {
          pointer[path[i]] = value;
        }
      }
    }
    return optionsObj;
  }

  /**
   * @private
   */
  _printOptions() {
    const options = this.getOptions();
    while (this.optionsContainer.firstChild) {
      this.optionsContainer.removeChild(this.optionsContainer.firstChild);
    }
    this.optionsContainer.appendChild(wrapInTag("pre", "const options = " + _JSON$stringify(options, null, 2)));
  }

  /**
   *
   * @returns {{}} options
   */
  getOptions() {
    const options = {};
    for (let i = 0; i < this.changedOptions.length; i++) {
      this._constructOptions(this.changedOptions[i].value, this.changedOptions[i].path, options);
    }
    return options;
  }
};

/**
 * Popup is a class to create a popup window with some text
 */
let Popup$1 = class Popup {
  /**
   * @param {Element} container       The container object.
   * @param {string}  overflowMethod  How the popup should act to overflowing ('flip' or 'cap')
   */
  constructor(container, overflowMethod) {
    this.container = container;
    this.overflowMethod = overflowMethod || "cap";
    this.x = 0;
    this.y = 0;
    this.padding = 5;
    this.hidden = false;

    // create the frame
    this.frame = document.createElement("div");
    this.frame.className = "vis-tooltip";
    this.container.appendChild(this.frame);
  }

  /**
   * @param {number} x   Horizontal position of the popup window
   * @param {number} y   Vertical position of the popup window
   */
  setPosition(x, y) {
    this.x = _parseInt$1(x);
    this.y = _parseInt$1(y);
  }

  /**
   * Set the content for the popup window. This can be HTML code or text.
   *
   * @param {string | Element} content
   */
  setText(content) {
    if (content instanceof Element) {
      while (this.frame.firstChild) {
        this.frame.removeChild(this.frame.firstChild);
      }
      this.frame.appendChild(content);
    } else {
      // String containing literal text, element has to be used for HTML due to
      // XSS risks associated with innerHTML (i.e. prevent XSS by accident).
      this.frame.innerText = content;
    }
  }

  /**
   * Show the popup window
   *
   * @param {boolean} [doShow]    Show or hide the window
   */
  show(doShow) {
    if (doShow === undefined) {
      doShow = true;
    }
    if (doShow === true) {
      const height = this.frame.clientHeight;
      const width = this.frame.clientWidth;
      const maxHeight = this.frame.parentNode.clientHeight;
      const maxWidth = this.frame.parentNode.clientWidth;
      let left = 0,
        top = 0;
      if (this.overflowMethod == "flip") {
        let isLeft = false,
          isTop = true; // Where around the position it's located

        if (this.y - height < this.padding) {
          isTop = false;
        }
        if (this.x + width > maxWidth - this.padding) {
          isLeft = true;
        }
        if (isLeft) {
          left = this.x - width;
        } else {
          left = this.x;
        }
        if (isTop) {
          top = this.y - height;
        } else {
          top = this.y;
        }
      } else {
        top = this.y - height;
        if (top + height + this.padding > maxHeight) {
          top = maxHeight - height - this.padding;
        }
        if (top < this.padding) {
          top = this.padding;
        }
        left = this.x;
        if (left + width + this.padding > maxWidth) {
          left = maxWidth - width - this.padding;
        }
        if (left < this.padding) {
          left = this.padding;
        }
      }
      this.frame.style.left = left + "px";
      this.frame.style.top = top + "px";
      this.frame.style.visibility = "visible";
      this.hidden = false;
    } else {
      this.hide();
    }
  }

  /**
   * Hide the popup window
   */
  hide() {
    this.hidden = true;
    this.frame.style.left = "0";
    this.frame.style.top = "0";
    this.frame.style.visibility = "hidden";
  }

  /**
   * Remove the popup window
   */
  destroy() {
    this.frame.parentNode.removeChild(this.frame); // Remove element from DOM
  }
};

let errorFound = false;
let allOptions$1;
const VALIDATOR_PRINT_STYLE$1 = "background: #FFeeee; color: #dd0000";

/**
 *  Used to validate options.
 */
let Validator$1 = class Validator {
  /**
   * Main function to be called
   *
   * @param {object} options
   * @param {object} referenceOptions
   * @param {object} subObject
   * @returns {boolean}
   * @static
   */
  static validate(options, referenceOptions, subObject) {
    errorFound = false;
    allOptions$1 = referenceOptions;
    let usedOptions = referenceOptions;
    if (subObject !== undefined) {
      usedOptions = referenceOptions[subObject];
    }
    Validator.parse(options, usedOptions, []);
    return errorFound;
  }

  /**
   * Will traverse an object recursively and check every value
   *
   * @param {object} options
   * @param {object} referenceOptions
   * @param {Array} path    | where to look for the actual option
   * @static
   */
  static parse(options, referenceOptions, path) {
    for (const option in options) {
      if (Object.prototype.hasOwnProperty.call(options, option)) {
        Validator.check(option, options, referenceOptions, path);
      }
    }
  }

  /**
   * Check every value. If the value is an object, call the parse function on that object.
   *
   * @param {string} option
   * @param {object} options
   * @param {object} referenceOptions
   * @param {Array} path    | where to look for the actual option
   * @static
   */
  static check(option, options, referenceOptions, path) {
    if (referenceOptions[option] === undefined && referenceOptions.__any__ === undefined) {
      Validator.getSuggestion(option, referenceOptions, path);
      return;
    }
    let referenceOption = option;
    let is_object = true;
    if (referenceOptions[option] === undefined && referenceOptions.__any__ !== undefined) {
      // NOTE: This only triggers if the __any__ is in the top level of the options object.
      //       THAT'S A REALLY BAD PLACE TO ALLOW IT!!!!
      // TODO: Examine if needed, remove if possible

      // __any__ is a wildcard. Any value is accepted and will be further analysed by reference.
      referenceOption = "__any__";

      // if the any-subgroup is not a predefined object in the configurator,
      // we do not look deeper into the object.
      is_object = Validator.getType(options[option]) === "object";
    }
    let refOptionObj = referenceOptions[referenceOption];
    if (is_object && refOptionObj.__type__ !== undefined) {
      refOptionObj = refOptionObj.__type__;
    }
    Validator.checkFields(option, options, referenceOptions, referenceOption, refOptionObj, path);
  }

  /**
   *
   * @param {string}  option           | the option property
   * @param {object}  options          | The supplied options object
   * @param {object}  referenceOptions | The reference options containing all options and their allowed formats
   * @param {string}  referenceOption  | Usually this is the same as option, except when handling an __any__ tag.
   * @param {string}  refOptionObj     | This is the type object from the reference options
   * @param {Array}   path             | where in the object is the option
   * @static
   */
  static checkFields(option, options, referenceOptions, referenceOption, refOptionObj, path) {
    const log = function (message) {
      console.error("%c" + message + Validator.printLocation(path, option), VALIDATOR_PRINT_STYLE$1);
    };
    const optionType = Validator.getType(options[option]);
    const refOptionType = refOptionObj[optionType];
    if (refOptionType !== undefined) {
      // if the type is correct, we check if it is supposed to be one of a few select values
      if (Validator.getType(refOptionType) === "array" && _indexOfInstanceProperty(refOptionType).call(refOptionType, options[option]) === -1) {
        log('Invalid option detected in "' + option + '".' + " Allowed values are:" + Validator.print(refOptionType) + ' not "' + options[option] + '". ');
        errorFound = true;
      } else if (optionType === "object" && referenceOption !== "__any__") {
        path = copyAndExtendArray(path, option);
        Validator.parse(options[option], referenceOptions[referenceOption], path);
      }
    } else if (refOptionObj["any"] === undefined) {
      // type of the field is incorrect and the field cannot be any
      log('Invalid type received for "' + option + '". Expected: ' + Validator.print(_Object$keys(refOptionObj)) + ". Received [" + optionType + '] "' + options[option] + '"');
      errorFound = true;
    }
  }

  /**
   *
   * @param {object | boolean | number | string | Array.<number> | Date | Node | Moment | undefined | null} object
   * @returns {string}
   * @static
   */
  static getType(object) {
    const type = typeof object;
    if (type === "object") {
      if (object === null) {
        return "null";
      }
      if (object instanceof Boolean) {
        return "boolean";
      }
      if (object instanceof Number) {
        return "number";
      }
      if (object instanceof String) {
        return "string";
      }
      if (_Array$isArray(object)) {
        return "array";
      }
      if (object instanceof Date) {
        return "date";
      }
      if (object.nodeType !== undefined) {
        return "dom";
      }
      if (object._isAMomentObject === true) {
        return "moment";
      }
      return "object";
    } else if (type === "number") {
      return "number";
    } else if (type === "boolean") {
      return "boolean";
    } else if (type === "string") {
      return "string";
    } else if (type === undefined) {
      return "undefined";
    }
    return type;
  }

  /**
   * @param {string} option
   * @param {object} options
   * @param {Array.<string>} path
   * @static
   */
  static getSuggestion(option, options, path) {
    const localSearch = Validator.findInOptions(option, options, path, false);
    const globalSearch = Validator.findInOptions(option, allOptions$1, [], true);
    const localSearchThreshold = 8;
    const globalSearchThreshold = 4;
    let msg;
    if (localSearch.indexMatch !== undefined) {
      msg = " in " + Validator.printLocation(localSearch.path, option, "") + 'Perhaps it was incomplete? Did you mean: "' + localSearch.indexMatch + '"?\n\n';
    } else if (globalSearch.distance <= globalSearchThreshold && localSearch.distance > globalSearch.distance) {
      msg = " in " + Validator.printLocation(localSearch.path, option, "") + "Perhaps it was misplaced? Matching option found at: " + Validator.printLocation(globalSearch.path, globalSearch.closestMatch, "");
    } else if (localSearch.distance <= localSearchThreshold) {
      msg = '. Did you mean "' + localSearch.closestMatch + '"?' + Validator.printLocation(localSearch.path, option);
    } else {
      msg = ". Did you mean one of these: " + Validator.print(_Object$keys(options)) + Validator.printLocation(path, option);
    }
    console.error('%cUnknown option detected: "' + option + '"' + msg, VALIDATOR_PRINT_STYLE$1);
    errorFound = true;
  }

  /**
   * traverse the options in search for a match.
   *
   * @param {string} option
   * @param {object} options
   * @param {Array} path    | where to look for the actual option
   * @param {boolean} [recursive=false]
   * @returns {{closestMatch: string, path: Array, distance: number}}
   * @static
   */
  static findInOptions(option, options, path) {
    let recursive = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;
    let min = 1e9;
    let closestMatch = "";
    let closestMatchPath = [];
    const lowerCaseOption = option.toLowerCase();
    let indexMatch = undefined;
    for (const op in options) {
      let distance;
      if (options[op].__type__ !== undefined && recursive === true) {
        const result = Validator.findInOptions(option, options[op], copyAndExtendArray(path, op));
        if (min > result.distance) {
          closestMatch = result.closestMatch;
          closestMatchPath = result.path;
          min = result.distance;
          indexMatch = result.indexMatch;
        }
      } else {
        var _context11;
        if (_indexOfInstanceProperty(_context11 = op.toLowerCase()).call(_context11, lowerCaseOption) !== -1) {
          indexMatch = op;
        }
        distance = Validator.levenshteinDistance(option, op);
        if (min > distance) {
          closestMatch = op;
          closestMatchPath = copyArray(path);
          min = distance;
        }
      }
    }
    return {
      closestMatch: closestMatch,
      path: closestMatchPath,
      distance: min,
      indexMatch: indexMatch
    };
  }

  /**
   * @param {Array.<string>} path
   * @param {object} option
   * @param {string} prefix
   * @returns {string}
   * @static
   */
  static printLocation(path, option) {
    let prefix = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : "Problem value found at: \n";
    let str = "\n\n" + prefix + "options = {\n";
    for (let i = 0; i < path.length; i++) {
      for (let j = 0; j < i + 1; j++) {
        str += "  ";
      }
      str += path[i] + ": {\n";
    }
    for (let j = 0; j < path.length + 1; j++) {
      str += "  ";
    }
    str += option + "\n";
    for (let i = 0; i < path.length + 1; i++) {
      for (let j = 0; j < path.length - i; j++) {
        str += "  ";
      }
      str += "}\n";
    }
    return str + "\n\n";
  }

  /**
   * @param {object} options
   * @returns {string}
   * @static
   */
  static print(options) {
    return _JSON$stringify(options).replace(/(")|(\[)|(\])|(,"__type__")/g, "").replace(/(,)/g, ", ");
  }

  /**
   *  Compute the edit distance between the two given strings
   * http://en.wikibooks.org/wiki/Algorithm_Implementation/Strings/Levenshtein_distance#JavaScript
   *
   * Copyright (c) 2011 Andrei Mackenzie
   *
   * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
   *
   * The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
   *
   * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
   *
   * @param {string} a
   * @param {string} b
   * @returns {Array.<Array.<number>>}}
   * @static
   */
  static levenshteinDistance(a, b) {
    if (a.length === 0) return b.length;
    if (b.length === 0) return a.length;
    const matrix = [];

    // increment along the first column of each row
    let i;
    for (i = 0; i <= b.length; i++) {
      matrix[i] = [i];
    }

    // increment each column in the first row
    let j;
    for (j = 0; j <= a.length; j++) {
      matrix[0][j] = j;
    }

    // Fill in the rest of the matrix
    for (i = 1; i <= b.length; i++) {
      for (j = 1; j <= a.length; j++) {
        if (b.charAt(i - 1) == a.charAt(j - 1)) {
          matrix[i][j] = matrix[i - 1][j - 1];
        } else {
          matrix[i][j] = Math.min(matrix[i - 1][j - 1] + 1,
          // substitution
          Math.min(matrix[i][j - 1] + 1,
          // insertion
          matrix[i - 1][j] + 1)); // deletion
        }
      }
    }

    return matrix[b.length][a.length];
  }
};
const Activator = Activator$1;
const Configurator = Configurator$1;
const Hammer = Hammer$1;
const Popup = Popup$1;
const VALIDATOR_PRINT_STYLE = VALIDATOR_PRINT_STYLE$1;
const Validator = Validator$1;

/* eslint-disable no-prototype-builtins */
/* eslint-disable no-unused-vars */
/* eslint-disable no-var */

/**
 * Parse a text source containing data in DOT language into a JSON object.
 * The object contains two lists: one with nodes and one with edges.
 *
 * DOT language reference: http://www.graphviz.org/doc/info/lang.html
 *
 * DOT language attributes: http://graphviz.org/content/attrs
 * @param {string} data     Text containing a graph in DOT-notation
 * @returns {object} graph   An object containing two parameters:
 *                          {Object[]} nodes
 *                          {Object[]} edges
 *
 * -------------------------------------------
 * TODO
 * ====
 *
 * For label handling, this is an incomplete implementation. From docs (quote #3015):
 *
 * > the escape sequences "\n", "\l" and "\r" divide the label into lines, centered,
 * > left-justified, and right-justified, respectively.
 *
 * Source: http://www.graphviz.org/content/attrs#kescString
 *
 * > As another aid for readability, dot allows double-quoted strings to span multiple physical
 * > lines using the standard C convention of a backslash immediately preceding a newline
 * > character
 * > In addition, double-quoted strings can be concatenated using a '+' operator.
 * > As HTML strings can contain newline characters, which are used solely for formatting,
 * > the language does not allow escaped newlines or concatenation operators to be used
 * > within them.
 *
 * - Currently, only '\\n' is handled
 * - Note that text explicitly says 'labels'; the dot parser currently handles escape
 *   sequences in **all** strings.
 */
function parseDOT(data) {
  dot = data;
  return parseGraph();
}

// mapping of attributes from DOT (the keys) to vis.js (the values)
var NODE_ATTR_MAPPING = {
  fontsize: "font.size",
  fontcolor: "font.color",
  labelfontcolor: "font.color",
  fontname: "font.face",
  color: ["color.border", "color.background"],
  fillcolor: "color.background",
  tooltip: "title",
  labeltooltip: "title"
};
var EDGE_ATTR_MAPPING = _Object$create(NODE_ATTR_MAPPING);
EDGE_ATTR_MAPPING.color = "color.color";
EDGE_ATTR_MAPPING.style = "dashes";

// token types enumeration
var TOKENTYPE = {
  NULL: 0,
  DELIMITER: 1,
  IDENTIFIER: 2,
  UNKNOWN: 3
};

// map with all delimiters
var DELIMITERS = {
  "{": true,
  "}": true,
  "[": true,
  "]": true,
  ";": true,
  "=": true,
  ",": true,
  "->": true,
  "--": true
};
var dot = ""; // current dot file
var index = 0; // current index in dot file
var c = ""; // current token character in expr
var token = ""; // current token
var tokenType = TOKENTYPE.NULL; // type of the token

/**
 * Get the first character from the dot file.
 * The character is stored into the char c. If the end of the dot file is
 * reached, the function puts an empty string in c.
 */
function first() {
  index = 0;
  c = dot.charAt(0);
}

/**
 * Get the next character from the dot file.
 * The character is stored into the char c. If the end of the dot file is
 * reached, the function puts an empty string in c.
 */
function next() {
  index++;
  c = dot.charAt(index);
}

/**
 * Preview the next character from the dot file.
 * @returns {string} cNext
 */
function nextPreview() {
  return dot.charAt(index + 1);
}

/**
 * Test whether given character is alphabetic or numeric ( a-zA-Z_0-9.:# )
 * @param {string} c
 * @returns {boolean} isAlphaNumeric
 */
function isAlphaNumeric(c) {
  var charCode = c.charCodeAt(0);
  if (charCode < 47) {
    // #.
    return charCode === 35 || charCode === 46;
  }
  if (charCode < 59) {
    // 0-9 and :
    return charCode > 47;
  }
  if (charCode < 91) {
    // A-Z
    return charCode > 64;
  }
  if (charCode < 96) {
    // _
    return charCode === 95;
  }
  if (charCode < 123) {
    // a-z
    return charCode > 96;
  }
  return false;
}

/**
 * Merge all options of object b into object b
 * @param {object} a
 * @param {object} b
 * @returns {object} a
 */
function merge$1(a, b) {
  if (!a) {
    a = {};
  }
  if (b) {
    for (var name in b) {
      if (b.hasOwnProperty(name)) {
        a[name] = b[name];
      }
    }
  }
  return a;
}

/**
 * Set a value in an object, where the provided parameter name can be a
 * path with nested parameters. For example:
 *
 * var obj = {a: 2};
 * setValue(obj, 'b.c', 3);     // obj = {a: 2, b: {c: 3}}
 * @param {object} obj
 * @param {string} path  A parameter name or dot-separated parameter path,
 *                      like "color.highlight.border".
 * @param {*} value
 */
function setValue(obj, path, value) {
  var keys = path.split(".");
  var o = obj;
  while (keys.length) {
    var key = keys.shift();
    if (keys.length) {
      // this isn't the end point
      if (!o[key]) {
        o[key] = {};
      }
      o = o[key];
    } else {
      // this is the end point
      o[key] = value;
    }
  }
}

/**
 * Add a node to a graph object. If there is already a node with
 * the same id, their attributes will be merged.
 * @param {object} graph
 * @param {object} node
 */
function addNode(graph, node) {
  var i, len;
  var current = null;

  // find root graph (in case of subgraph)
  var graphs = [graph]; // list with all graphs from current graph to root graph
  var root = graph;
  while (root.parent) {
    graphs.push(root.parent);
    root = root.parent;
  }

  // find existing node (at root level) by its id
  if (root.nodes) {
    for (i = 0, len = root.nodes.length; i < len; i++) {
      if (node.id === root.nodes[i].id) {
        current = root.nodes[i];
        break;
      }
    }
  }
  if (!current) {
    // this is a new node
    current = {
      id: node.id
    };
    if (graph.node) {
      // clone default attributes
      current.attr = merge$1(current.attr, graph.node);
    }
  }

  // add node to this (sub)graph and all its parent graphs
  for (i = graphs.length - 1; i >= 0; i--) {
    var _context;
    var g = graphs[i];
    if (!g.nodes) {
      g.nodes = [];
    }
    if (_indexOfInstanceProperty(_context = g.nodes).call(_context, current) === -1) {
      g.nodes.push(current);
    }
  }

  // merge attributes
  if (node.attr) {
    current.attr = merge$1(current.attr, node.attr);
  }
}

/**
 * Add an edge to a graph object
 * @param {object} graph
 * @param {object} edge
 */
function addEdge(graph, edge) {
  if (!graph.edges) {
    graph.edges = [];
  }
  graph.edges.push(edge);
  if (graph.edge) {
    var attr = merge$1({}, graph.edge); // clone default attributes
    edge.attr = merge$1(attr, edge.attr); // merge attributes
  }
}

/**
 * Create an edge to a graph object
 * @param {object} graph
 * @param {string | number | object} from
 * @param {string | number | object} to
 * @param {string} type
 * @param {object | null} attr
 * @returns {object} edge
 */
function createEdge(graph, from, to, type, attr) {
  var edge = {
    from: from,
    to: to,
    type: type
  };
  if (graph.edge) {
    edge.attr = merge$1({}, graph.edge); // clone default attributes
  }

  edge.attr = merge$1(edge.attr || {}, attr); // merge attributes

  // Move arrows attribute from attr to edge temporally created in
  // parseAttributeList().
  if (attr != null) {
    if (attr.hasOwnProperty("arrows") && attr["arrows"] != null) {
      edge["arrows"] = {
        to: {
          enabled: true,
          type: attr.arrows.type
        }
      };
      attr["arrows"] = null;
    }
  }
  return edge;
}

/**
 * Get next token in the current dot file.
 * The token and token type are available as token and tokenType
 */
function getToken() {
  tokenType = TOKENTYPE.NULL;
  token = "";

  // skip over whitespaces
  while (c === " " || c === "\t" || c === "\n" || c === "\r") {
    // space, tab, enter
    next();
  }
  do {
    var isComment = false;

    // skip comment
    if (c === "#") {
      // find the previous non-space character
      var i = index - 1;
      while (dot.charAt(i) === " " || dot.charAt(i) === "\t") {
        i--;
      }
      if (dot.charAt(i) === "\n" || dot.charAt(i) === "") {
        // the # is at the start of a line, this is indeed a line comment
        while (c != "" && c != "\n") {
          next();
        }
        isComment = true;
      }
    }
    if (c === "/" && nextPreview() === "/") {
      // skip line comment
      while (c != "" && c != "\n") {
        next();
      }
      isComment = true;
    }
    if (c === "/" && nextPreview() === "*") {
      // skip block comment
      while (c != "") {
        if (c === "*" && nextPreview() === "/") {
          // end of block comment found. skip these last two characters
          next();
          next();
          break;
        } else {
          next();
        }
      }
      isComment = true;
    }

    // skip over whitespaces
    while (c === " " || c === "\t" || c === "\n" || c === "\r") {
      // space, tab, enter
      next();
    }
  } while (isComment);

  // check for end of dot file
  if (c === "") {
    // token is still empty
    tokenType = TOKENTYPE.DELIMITER;
    return;
  }

  // check for delimiters consisting of 2 characters
  var c2 = c + nextPreview();
  if (DELIMITERS[c2]) {
    tokenType = TOKENTYPE.DELIMITER;
    token = c2;
    next();
    next();
    return;
  }

  // check for delimiters consisting of 1 character
  if (DELIMITERS[c]) {
    tokenType = TOKENTYPE.DELIMITER;
    token = c;
    next();
    return;
  }

  // check for an identifier (number or string)
  // TODO: more precise parsing of numbers/strings (and the port separator ':')
  if (isAlphaNumeric(c) || c === "-") {
    token += c;
    next();
    while (isAlphaNumeric(c)) {
      token += c;
      next();
    }
    if (token === "false") {
      token = false; // convert to boolean
    } else if (token === "true") {
      token = true; // convert to boolean
    } else if (!isNaN(Number(token))) {
      token = Number(token); // convert to number
    }

    tokenType = TOKENTYPE.IDENTIFIER;
    return;
  }

  // check for a string enclosed by double quotes
  if (c === '"') {
    next();
    while (c != "" && (c != '"' || c === '"' && nextPreview() === '"')) {
      if (c === '"') {
        // skip the escape character
        token += c;
        next();
      } else if (c === "\\" && nextPreview() === "n") {
        // Honor a newline escape sequence
        token += "\n";
        next();
      } else {
        token += c;
      }
      next();
    }
    if (c != '"') {
      throw newSyntaxError('End of string " expected');
    }
    next();
    tokenType = TOKENTYPE.IDENTIFIER;
    return;
  }

  // something unknown is found, wrong characters, a syntax error
  tokenType = TOKENTYPE.UNKNOWN;
  while (c != "") {
    token += c;
    next();
  }
  throw new SyntaxError('Syntax error in part "' + chop(token, 30) + '"');
}

/**
 * Parse a graph.
 * @returns {object} graph
 */
function parseGraph() {
  var graph = {};
  first();
  getToken();

  // optional strict keyword
  if (token === "strict") {
    graph.strict = true;
    getToken();
  }

  // graph or digraph keyword
  if (token === "graph" || token === "digraph") {
    graph.type = token;
    getToken();
  }

  // optional graph id
  if (tokenType === TOKENTYPE.IDENTIFIER) {
    graph.id = token;
    getToken();
  }

  // open angle bracket
  if (token != "{") {
    throw newSyntaxError("Angle bracket { expected");
  }
  getToken();

  // statements
  parseStatements(graph);

  // close angle bracket
  if (token != "}") {
    throw newSyntaxError("Angle bracket } expected");
  }
  getToken();

  // end of file
  if (token !== "") {
    throw newSyntaxError("End of file expected");
  }
  getToken();

  // remove temporary default options
  delete graph.node;
  delete graph.edge;
  delete graph.graph;
  return graph;
}

/**
 * Parse a list with statements.
 * @param {object} graph
 */
function parseStatements(graph) {
  while (token !== "" && token != "}") {
    parseStatement(graph);
    if (token === ";") {
      getToken();
    }
  }
}

/**
 * Parse a single statement. Can be a an attribute statement, node
 * statement, a series of node statements and edge statements, or a
 * parameter.
 * @param {object} graph
 */
function parseStatement(graph) {
  // parse subgraph
  var subgraph = parseSubgraph(graph);
  if (subgraph) {
    // edge statements
    parseEdge(graph, subgraph);
    return;
  }

  // parse an attribute statement
  var attr = parseAttributeStatement(graph);
  if (attr) {
    return;
  }

  // parse node
  if (tokenType != TOKENTYPE.IDENTIFIER) {
    throw newSyntaxError("Identifier expected");
  }
  var id = token; // id can be a string or a number
  getToken();
  if (token === "=") {
    // id statement
    getToken();
    if (tokenType != TOKENTYPE.IDENTIFIER) {
      throw newSyntaxError("Identifier expected");
    }
    graph[id] = token;
    getToken();
    // TODO: implement comma separated list with "a_list: ID=ID [','] [a_list] "
  } else {
    parseNodeStatement(graph, id);
  }
}

/**
 * Parse a subgraph
 * @param {object} graph    parent graph object
 * @returns {object | null} subgraph
 */
function parseSubgraph(graph) {
  var subgraph = null;

  // optional subgraph keyword
  if (token === "subgraph") {
    subgraph = {};
    subgraph.type = "subgraph";
    getToken();

    // optional graph id
    if (tokenType === TOKENTYPE.IDENTIFIER) {
      subgraph.id = token;
      getToken();
    }
  }

  // open angle bracket
  if (token === "{") {
    getToken();
    if (!subgraph) {
      subgraph = {};
    }
    subgraph.parent = graph;
    subgraph.node = graph.node;
    subgraph.edge = graph.edge;
    subgraph.graph = graph.graph;

    // statements
    parseStatements(subgraph);

    // close angle bracket
    if (token != "}") {
      throw newSyntaxError("Angle bracket } expected");
    }
    getToken();

    // remove temporary default options
    delete subgraph.node;
    delete subgraph.edge;
    delete subgraph.graph;
    delete subgraph.parent;

    // register at the parent graph
    if (!graph.subgraphs) {
      graph.subgraphs = [];
    }
    graph.subgraphs.push(subgraph);
  }
  return subgraph;
}

/**
 * parse an attribute statement like "node [shape=circle fontSize=16]".
 * Available keywords are 'node', 'edge', 'graph'.
 * The previous list with default attributes will be replaced
 * @param {object} graph
 * @returns {string | null} keyword Returns the name of the parsed attribute
 *                                  (node, edge, graph), or null if nothing
 *                                  is parsed.
 */
function parseAttributeStatement(graph) {
  // attribute statements
  if (token === "node") {
    getToken();

    // node attributes
    graph.node = parseAttributeList();
    return "node";
  } else if (token === "edge") {
    getToken();

    // edge attributes
    graph.edge = parseAttributeList();
    return "edge";
  } else if (token === "graph") {
    getToken();

    // graph attributes
    graph.graph = parseAttributeList();
    return "graph";
  }
  return null;
}

/**
 * parse a node statement
 * @param {object} graph
 * @param {string | number} id
 */
function parseNodeStatement(graph, id) {
  // node statement
  var node = {
    id: id
  };
  var attr = parseAttributeList();
  if (attr) {
    node.attr = attr;
  }
  addNode(graph, node);

  // edge statements
  parseEdge(graph, id);
}

/**
 * Parse an edge or a series of edges
 * @param {object} graph
 * @param {string | number} from        Id of the from node
 */
function parseEdge(graph, from) {
  while (token === "->" || token === "--") {
    var to;
    var type = token;
    getToken();
    var subgraph = parseSubgraph(graph);
    if (subgraph) {
      to = subgraph;
    } else {
      if (tokenType != TOKENTYPE.IDENTIFIER) {
        throw newSyntaxError("Identifier or subgraph expected");
      }
      to = token;
      addNode(graph, {
        id: to
      });
      getToken();
    }

    // parse edge attributes
    var attr = parseAttributeList();

    // create edge
    var edge = createEdge(graph, from, to, type, attr);
    addEdge(graph, edge);
    from = to;
  }
}

/**
 * Parse a set with attributes,
 * for example [label="1.000", shape=solid]
 * @returns {object | null} attr
 */
function parseAttributeList() {
  var i;
  var attr = null;

  // edge styles of dot and vis
  var edgeStyles = {
    dashed: true,
    solid: false,
    dotted: [1, 5]
  };

  /**
   * Define arrow types.
   * vis currently supports types defined in 'arrowTypes'.
   * Details of arrow shapes are described in
   * http://www.graphviz.org/content/arrow-shapes
   */
  var arrowTypes = {
    dot: "circle",
    box: "box",
    crow: "crow",
    curve: "curve",
    icurve: "inv_curve",
    normal: "triangle",
    inv: "inv_triangle",
    diamond: "diamond",
    tee: "bar",
    vee: "vee"
  };

  /**
   * 'attr_list' contains attributes for checking if some of them are affected
   * later. For instance, both of 'arrowhead' and 'dir' (edge style defined
   * in DOT) make changes to 'arrows' attribute in vis.
   */
  var attr_list = new Array();
  var attr_names = new Array(); // used for checking the case.

  // parse attributes
  while (token === "[") {
    getToken();
    attr = {};
    while (token !== "" && token != "]") {
      if (tokenType != TOKENTYPE.IDENTIFIER) {
        throw newSyntaxError("Attribute name expected");
      }
      var name = token;
      getToken();
      if (token != "=") {
        throw newSyntaxError("Equal sign = expected");
      }
      getToken();
      if (tokenType != TOKENTYPE.IDENTIFIER) {
        throw newSyntaxError("Attribute value expected");
      }
      var value = token;

      // convert from dot style to vis
      if (name === "style") {
        value = edgeStyles[value];
      }
      var arrowType;
      if (name === "arrowhead") {
        arrowType = arrowTypes[value];
        name = "arrows";
        value = {
          to: {
            enabled: true,
            type: arrowType
          }
        };
      }
      if (name === "arrowtail") {
        arrowType = arrowTypes[value];
        name = "arrows";
        value = {
          from: {
            enabled: true,
            type: arrowType
          }
        };
      }
      attr_list.push({
        attr: attr,
        name: name,
        value: value
      });
      attr_names.push(name);
      getToken();
      if (token == ",") {
        getToken();
      }
    }
    if (token != "]") {
      throw newSyntaxError("Bracket ] expected");
    }
    getToken();
  }

  /**
   * As explained in [1], graphviz has limitations for combination of
   * arrow[head|tail] and dir. If attribute list includes 'dir',
   * following cases just be supported.
   *   1. both or none + arrowhead, arrowtail
   *   2. forward + arrowhead (arrowtail is not affedted)
   *   3. back + arrowtail (arrowhead is not affected)
   * [1] https://www.graphviz.org/doc/info/attrs.html#h:undir_note
   */
  if (_includesInstanceProperty(attr_names).call(attr_names, "dir")) {
    var idx = {}; // get index of 'arrows' and 'dir'
    idx.arrows = {};
    for (i = 0; i < attr_list.length; i++) {
      if (attr_list[i].name === "arrows") {
        if (attr_list[i].value.to != null) {
          idx.arrows.to = i;
        } else if (attr_list[i].value.from != null) {
          idx.arrows.from = i;
        } else {
          throw newSyntaxError("Invalid value of arrows");
        }
      } else if (attr_list[i].name === "dir") {
        idx.dir = i;
      }
    }

    // first, add default arrow shape if it is not assigned to avoid error
    var dir_type = attr_list[idx.dir].value;
    if (!_includesInstanceProperty(attr_names).call(attr_names, "arrows")) {
      if (dir_type === "both") {
        attr_list.push({
          attr: attr_list[idx.dir].attr,
          name: "arrows",
          value: {
            to: {
              enabled: true
            }
          }
        });
        idx.arrows.to = attr_list.length - 1;
        attr_list.push({
          attr: attr_list[idx.dir].attr,
          name: "arrows",
          value: {
            from: {
              enabled: true
            }
          }
        });
        idx.arrows.from = attr_list.length - 1;
      } else if (dir_type === "forward") {
        attr_list.push({
          attr: attr_list[idx.dir].attr,
          name: "arrows",
          value: {
            to: {
              enabled: true
            }
          }
        });
        idx.arrows.to = attr_list.length - 1;
      } else if (dir_type === "back") {
        attr_list.push({
          attr: attr_list[idx.dir].attr,
          name: "arrows",
          value: {
            from: {
              enabled: true
            }
          }
        });
        idx.arrows.from = attr_list.length - 1;
      } else if (dir_type === "none") {
        attr_list.push({
          attr: attr_list[idx.dir].attr,
          name: "arrows",
          value: ""
        });
        idx.arrows.to = attr_list.length - 1;
      } else {
        throw newSyntaxError('Invalid dir type "' + dir_type + '"');
      }
    }
    var from_type;
    var to_type;
    // update 'arrows' attribute from 'dir'.
    if (dir_type === "both") {
      // both of shapes of 'from' and 'to' are given
      if (idx.arrows.to && idx.arrows.from) {
        to_type = attr_list[idx.arrows.to].value.to.type;
        from_type = attr_list[idx.arrows.from].value.from.type;
        attr_list[idx.arrows.to] = {
          attr: attr_list[idx.arrows.to].attr,
          name: attr_list[idx.arrows.to].name,
          value: {
            to: {
              enabled: true,
              type: to_type
            },
            from: {
              enabled: true,
              type: from_type
            }
          }
        };
        _spliceInstanceProperty(attr_list).call(attr_list, idx.arrows.from, 1);

        // shape of 'to' is assigned and use default to 'from'
      } else if (idx.arrows.to) {
        to_type = attr_list[idx.arrows.to].value.to.type;
        from_type = "arrow";
        attr_list[idx.arrows.to] = {
          attr: attr_list[idx.arrows.to].attr,
          name: attr_list[idx.arrows.to].name,
          value: {
            to: {
              enabled: true,
              type: to_type
            },
            from: {
              enabled: true,
              type: from_type
            }
          }
        };

        // only shape of 'from' is assigned and use default for 'to'
      } else if (idx.arrows.from) {
        to_type = "arrow";
        from_type = attr_list[idx.arrows.from].value.from.type;
        attr_list[idx.arrows.from] = {
          attr: attr_list[idx.arrows.from].attr,
          name: attr_list[idx.arrows.from].name,
          value: {
            to: {
              enabled: true,
              type: to_type
            },
            from: {
              enabled: true,
              type: from_type
            }
          }
        };
      }
    } else if (dir_type === "back") {
      // given both of shapes, but use only 'from'
      if (idx.arrows.to && idx.arrows.from) {
        to_type = "";
        from_type = attr_list[idx.arrows.from].value.from.type;
        attr_list[idx.arrows.from] = {
          attr: attr_list[idx.arrows.from].attr,
          name: attr_list[idx.arrows.from].name,
          value: {
            to: {
              enabled: true,
              type: to_type
            },
            from: {
              enabled: true,
              type: from_type
            }
          }
        };

        // given shape of 'to', but does not use it
      } else if (idx.arrows.to) {
        to_type = "";
        from_type = "arrow";
        idx.arrows.from = idx.arrows.to;
        attr_list[idx.arrows.from] = {
          attr: attr_list[idx.arrows.from].attr,
          name: attr_list[idx.arrows.from].name,
          value: {
            to: {
              enabled: true,
              type: to_type
            },
            from: {
              enabled: true,
              type: from_type
            }
          }
        };

        // assign given 'from' shape
      } else if (idx.arrows.from) {
        to_type = "";
        from_type = attr_list[idx.arrows.from].value.from.type;
        attr_list[idx.arrows.to] = {
          attr: attr_list[idx.arrows.from].attr,
          name: attr_list[idx.arrows.from].name,
          value: {
            to: {
              enabled: true,
              type: to_type
            },
            from: {
              enabled: true,
              type: from_type
            }
          }
        };
      }
      attr_list[idx.arrows.from] = {
        attr: attr_list[idx.arrows.from].attr,
        name: attr_list[idx.arrows.from].name,
        value: {
          from: {
            enabled: true,
            type: attr_list[idx.arrows.from].value.from.type
          }
        }
      };
    } else if (dir_type === "none") {
      var idx_arrow;
      if (idx.arrows.to) {
        idx_arrow = idx.arrows.to;
      } else {
        idx_arrow = idx.arrows.from;
      }
      attr_list[idx_arrow] = {
        attr: attr_list[idx_arrow].attr,
        name: attr_list[idx_arrow].name,
        value: ""
      };
    } else if (dir_type === "forward") {
      // given both of shapes, but use only 'to'
      if (idx.arrows.to && idx.arrows.from) {
        to_type = attr_list[idx.arrows.to].value.to.type;
        from_type = "";
        attr_list[idx.arrows.to] = {
          attr: attr_list[idx.arrows.to].attr,
          name: attr_list[idx.arrows.to].name,
          value: {
            to: {
              enabled: true,
              type: to_type
            },
            from: {
              enabled: true,
              type: from_type
            }
          }
        };

        // assign given 'to' shape
      } else if (idx.arrows.to) {
        to_type = attr_list[idx.arrows.to].value.to.type;
        from_type = "";
        attr_list[idx.arrows.to] = {
          attr: attr_list[idx.arrows.to].attr,
          name: attr_list[idx.arrows.to].name,
          value: {
            to: {
              enabled: true,
              type: to_type
            },
            from: {
              enabled: true,
              type: from_type
            }
          }
        };

        // given shape of 'from', but does not use it
      } else if (idx.arrows.from) {
        to_type = "arrow";
        from_type = "";
        idx.arrows.to = idx.arrows.from;
        attr_list[idx.arrows.to] = {
          attr: attr_list[idx.arrows.to].attr,
          name: attr_list[idx.arrows.to].name,
          value: {
            to: {
              enabled: true,
              type: to_type
            },
            from: {
              enabled: true,
              type: from_type
            }
          }
        };
      }
      attr_list[idx.arrows.to] = {
        attr: attr_list[idx.arrows.to].attr,
        name: attr_list[idx.arrows.to].name,
        value: {
          to: {
            enabled: true,
            type: attr_list[idx.arrows.to].value.to.type
          }
        }
      };
    } else {
      throw newSyntaxError('Invalid dir type "' + dir_type + '"');
    }

    // remove 'dir' attribute no need anymore
    _spliceInstanceProperty(attr_list).call(attr_list, idx.dir, 1);
  }

  // parse 'penwidth'
  var nof_attr_list;
  if (_includesInstanceProperty(attr_names).call(attr_names, "penwidth")) {
    var tmp_attr_list = [];
    nof_attr_list = attr_list.length;
    for (i = 0; i < nof_attr_list; i++) {
      // exclude 'width' from attr_list if 'penwidth' exists
      if (attr_list[i].name !== "width") {
        if (attr_list[i].name === "penwidth") {
          attr_list[i].name = "width";
        }
        tmp_attr_list.push(attr_list[i]);
      }
    }
    attr_list = tmp_attr_list;
  }
  nof_attr_list = attr_list.length;
  for (i = 0; i < nof_attr_list; i++) {
    setValue(attr_list[i].attr, attr_list[i].name, attr_list[i].value);
  }
  return attr;
}

/**
 * Create a syntax error with extra information on current token and index.
 * @param {string} message
 * @returns {SyntaxError} err
 */
function newSyntaxError(message) {
  return new SyntaxError(message + ', got "' + chop(token, 30) + '" (char ' + index + ")");
}

/**
 * Chop off text after a maximum length
 * @param {string} text
 * @param {number} maxLength
 * @returns {string}
 */
function chop(text, maxLength) {
  return text.length <= maxLength ? text : text.substr(0, 27) + "...";
}

/**
 * Execute a function fn for each pair of elements in two arrays
 * @param {Array | *} array1
 * @param {Array | *} array2
 * @param {Function} fn
 */
function forEach2(array1, array2, fn) {
  if (_Array$isArray(array1)) {
    _forEachInstanceProperty(array1).call(array1, function (elem1) {
      if (_Array$isArray(array2)) {
        _forEachInstanceProperty(array2).call(array2, function (elem2) {
          fn(elem1, elem2);
        });
      } else {
        fn(elem1, array2);
      }
    });
  } else {
    if (_Array$isArray(array2)) {
      _forEachInstanceProperty(array2).call(array2, function (elem2) {
        fn(array1, elem2);
      });
    } else {
      fn(array1, array2);
    }
  }
}

/**
 * Set a nested property on an object
 * When nested objects are missing, they will be created.
 * For example setProp({}, 'font.color', 'red') will return {font: {color: 'red'}}
 * @param {object} object
 * @param {string} path   A dot separated string like 'font.color'
 * @param {*} value       Value for the property
 * @returns {object} Returns the original object, allows for chaining.
 */
function setProp(object, path, value) {
  var names = path.split(".");
  var prop = names.pop();

  // traverse over the nested objects
  var obj = object;
  for (var i = 0; i < names.length; i++) {
    var name = names[i];
    if (!(name in obj)) {
      obj[name] = {};
    }
    obj = obj[name];
  }

  // set the property value
  obj[prop] = value;
  return object;
}

/**
 * Convert an object with DOT attributes to their vis.js equivalents.
 * @param {object} attr     Object with DOT attributes
 * @param {object} mapping
 * @returns {object}         Returns an object with vis.js attributes
 */
function convertAttr(attr, mapping) {
  var converted = {};
  for (var prop in attr) {
    if (attr.hasOwnProperty(prop)) {
      var visProp = mapping[prop];
      if (_Array$isArray(visProp)) {
        _forEachInstanceProperty(visProp).call(visProp, function (visPropI) {
          setProp(converted, visPropI, attr[prop]);
        });
      } else if (typeof visProp === "string") {
        setProp(converted, visProp, attr[prop]);
      } else {
        setProp(converted, prop, attr[prop]);
      }
    }
  }
  return converted;
}

/**
 * Convert a string containing a graph in DOT language into a map containing
 * with nodes and edges in the format of graph.
 * @param {string} data         Text containing a graph in DOT-notation
 * @returns {object} graphData
 */
function DOTToGraph(data) {
  // parse the DOT file
  var dotData = parseDOT(data);
  var graphData = {
    nodes: [],
    edges: [],
    options: {}
  };

  // copy the nodes
  if (dotData.nodes) {
    var _context2;
    _forEachInstanceProperty(_context2 = dotData.nodes).call(_context2, function (dotNode) {
      var graphNode = {
        id: dotNode.id,
        label: String(dotNode.label || dotNode.id)
      };
      merge$1(graphNode, convertAttr(dotNode.attr, NODE_ATTR_MAPPING));
      if (graphNode.image) {
        graphNode.shape = "image";
      }
      graphData.nodes.push(graphNode);
    });
  }

  // copy the edges
  if (dotData.edges) {
    var _context3;
    /**
     * Convert an edge in DOT format to an edge with VisGraph format
     * @param {object} dotEdge
     * @returns {object} graphEdge
     */
    var convertEdge = function (dotEdge) {
      var graphEdge = {
        from: dotEdge.from,
        to: dotEdge.to
      };
      merge$1(graphEdge, convertAttr(dotEdge.attr, EDGE_ATTR_MAPPING));

      // Add arrows attribute to default styled arrow.
      // The reason why default style is not added in parseAttributeList() is
      // because only default is cleared before here.
      if (graphEdge.arrows == null && dotEdge.type === "->") {
        graphEdge.arrows = "to";
      }
      return graphEdge;
    };
    _forEachInstanceProperty(_context3 = dotData.edges).call(_context3, function (dotEdge) {
      var from, to;
      if (dotEdge.from instanceof Object) {
        from = dotEdge.from.nodes;
      } else {
        from = {
          id: dotEdge.from
        };
      }
      if (dotEdge.to instanceof Object) {
        to = dotEdge.to.nodes;
      } else {
        to = {
          id: dotEdge.to
        };
      }
      if (dotEdge.from instanceof Object && dotEdge.from.edges) {
        var _context4;
        _forEachInstanceProperty(_context4 = dotEdge.from.edges).call(_context4, function (subEdge) {
          var graphEdge = convertEdge(subEdge);
          graphData.edges.push(graphEdge);
        });
      }
      forEach2(from, to, function (from, to) {
        var subEdge = createEdge(graphData, from.id, to.id, dotEdge.type, dotEdge.attr);
        var graphEdge = convertEdge(subEdge);
        graphData.edges.push(graphEdge);
      });
      if (dotEdge.to instanceof Object && dotEdge.to.edges) {
        var _context5;
        _forEachInstanceProperty(_context5 = dotEdge.to.edges).call(_context5, function (subEdge) {
          var graphEdge = convertEdge(subEdge);
          graphData.edges.push(graphEdge);
        });
      }
    });
  }

  // copy the options
  if (dotData.attr) {
    graphData.options = dotData.attr;
  }
  return graphData;
}

/* eslint-enable no-var */
/* eslint-enable no-unused-vars */
/* eslint-enable no-prototype-builtins */

var dotparser = /*#__PURE__*/Object.freeze({
	__proto__: null,
	DOTToGraph: DOTToGraph,
	parseDOT: parseDOT
});

/**
 * Convert Gephi to Vis.
 * @param gephiJSON - The parsed JSON data in Gephi format.
 * @param optionsObj - Additional options.
 * @returns The converted data ready to be used in Vis.
 */
function parseGephi(gephiJSON, optionsObj) {
  var _context;
  const options = {
    edges: {
      inheritColor: false
    },
    nodes: {
      fixed: false,
      parseColor: false
    }
  };
  if (optionsObj != null) {
    if (optionsObj.fixed != null) {
      options.nodes.fixed = optionsObj.fixed;
    }
    if (optionsObj.parseColor != null) {
      options.nodes.parseColor = optionsObj.parseColor;
    }
    if (optionsObj.inheritColor != null) {
      options.edges.inheritColor = optionsObj.inheritColor;
    }
  }
  const gEdges = gephiJSON.edges;
  const vEdges = _mapInstanceProperty(gEdges).call(gEdges, gEdge => {
    const vEdge = {
      from: gEdge.source,
      id: gEdge.id,
      to: gEdge.target
    };
    if (gEdge.attributes != null) {
      vEdge.attributes = gEdge.attributes;
    }
    if (gEdge.label != null) {
      vEdge.label = gEdge.label;
    }
    if (gEdge.attributes != null && gEdge.attributes.title != null) {
      vEdge.title = gEdge.attributes.title;
    }
    if (gEdge.type === "Directed") {
      vEdge.arrows = "to";
    }
    // edge['value'] = gEdge.attributes != null ? gEdge.attributes.Weight : undefined;
    // edge['width'] = edge['value'] != null ? undefined : edgegEdge.size;
    if (gEdge.color && options.edges.inheritColor === false) {
      vEdge.color = gEdge.color;
    }
    return vEdge;
  });
  const vNodes = _mapInstanceProperty(_context = gephiJSON.nodes).call(_context, gNode => {
    const vNode = {
      id: gNode.id,
      fixed: options.nodes.fixed && gNode.x != null && gNode.y != null
    };
    if (gNode.attributes != null) {
      vNode.attributes = gNode.attributes;
    }
    if (gNode.label != null) {
      vNode.label = gNode.label;
    }
    if (gNode.size != null) {
      vNode.size = gNode.size;
    }
    if (gNode.attributes != null && gNode.attributes.title != null) {
      vNode.title = gNode.attributes.title;
    }
    if (gNode.title != null) {
      vNode.title = gNode.title;
    }
    if (gNode.x != null) {
      vNode.x = gNode.x;
    }
    if (gNode.y != null) {
      vNode.y = gNode.y;
    }
    if (gNode.color != null) {
      if (options.nodes.parseColor === true) {
        vNode.color = gNode.color;
      } else {
        vNode.color = {
          background: gNode.color,
          border: gNode.color,
          highlight: {
            background: gNode.color,
            border: gNode.color
          },
          hover: {
            background: gNode.color,
            border: gNode.color
          }
        };
      }
    }
    return vNode;
  });
  return {
    nodes: vNodes,
    edges: vEdges
  };
}

var gephiParser = /*#__PURE__*/Object.freeze({
	__proto__: null,
	parseGephi: parseGephi
});

// English
const en = {
  addDescription: "Click in an empty space to place a new node.",
  addEdge: "Add Edge",
  addNode: "Add Node",
  back: "Back",
  close: "Close",
  createEdgeError: "Cannot link edges to a cluster.",
  del: "Delete selected",
  deleteClusterError: "Clusters cannot be deleted.",
  edgeDescription: "Click on a node and drag the edge to another node to connect them.",
  edit: "Edit",
  editClusterError: "Clusters cannot be edited.",
  editEdge: "Edit Edge",
  editEdgeDescription: "Click on the control points and drag them to a node to connect to it.",
  editNode: "Edit Node"
};
// German
const de = {
  addDescription: "Klicke auf eine freie Stelle, um einen neuen Knoten zu plazieren.",
  addEdge: "Kante hinzuf\u00fcgen",
  addNode: "Knoten hinzuf\u00fcgen",
  back: "Zur\u00fcck",
  close: "Schließen",
  createEdgeError: "Es ist nicht m\u00f6glich, Kanten mit Clustern zu verbinden.",
  del: "L\u00f6sche Auswahl",
  deleteClusterError: "Cluster k\u00f6nnen nicht gel\u00f6scht werden.",
  edgeDescription: "Klicke auf einen Knoten und ziehe die Kante zu einem anderen Knoten, um diese zu verbinden.",
  edit: "Editieren",
  editClusterError: "Cluster k\u00f6nnen nicht editiert werden.",
  editEdge: "Kante editieren",
  editEdgeDescription: "Klicke auf die Verbindungspunkte und ziehe diese auf einen Knoten, um sie zu verbinden.",
  editNode: "Knoten editieren"
};
// Spanish
const es = {
  addDescription: "Haga clic en un lugar vac\u00edo para colocar un nuevo nodo.",
  addEdge: "A\u00f1adir arista",
  addNode: "A\u00f1adir nodo",
  back: "Atr\u00e1s",
  close: "Cerrar",
  createEdgeError: "No se puede conectar una arista a un grupo.",
  del: "Eliminar selecci\u00f3n",
  deleteClusterError: "No es posible eliminar grupos.",
  edgeDescription: "Haga clic en un nodo y arrastre la arista hacia otro nodo para conectarlos.",
  edit: "Editar",
  editClusterError: "No es posible editar grupos.",
  editEdge: "Editar arista",
  editEdgeDescription: "Haga clic en un punto de control y arrastrelo a un nodo para conectarlo.",
  editNode: "Editar nodo"
};
//Italiano
const it = {
  addDescription: "Clicca per aggiungere un nuovo nodo",
  addEdge: "Aggiungi un vertice",
  addNode: "Aggiungi un nodo",
  back: "Indietro",
  close: "Chiudere",
  createEdgeError: "Non si possono collegare vertici ad un cluster",
  del: "Cancella la selezione",
  deleteClusterError: "I cluster non possono essere cancellati",
  edgeDescription: "Clicca su un nodo e trascinalo ad un altro nodo per connetterli.",
  edit: "Modifica",
  editClusterError: "I clusters non possono essere modificati.",
  editEdge: "Modifica il vertice",
  editEdgeDescription: "Clicca sui Punti di controllo e trascinali ad un nodo per connetterli.",
  editNode: "Modifica il nodo"
};
// Dutch
const nl = {
  addDescription: "Klik op een leeg gebied om een nieuwe node te maken.",
  addEdge: "Link toevoegen",
  addNode: "Node toevoegen",
  back: "Terug",
  close: "Sluiten",
  createEdgeError: "Kan geen link maken naar een cluster.",
  del: "Selectie verwijderen",
  deleteClusterError: "Clusters kunnen niet worden verwijderd.",
  edgeDescription: "Klik op een node en sleep de link naar een andere node om ze te verbinden.",
  edit: "Wijzigen",
  editClusterError: "Clusters kunnen niet worden aangepast.",
  editEdge: "Link wijzigen",
  editEdgeDescription: "Klik op de verbindingspunten en sleep ze naar een node om daarmee te verbinden.",
  editNode: "Node wijzigen"
};
// Portuguese Brazil
const pt = {
  addDescription: "Clique em um espaço em branco para adicionar um novo nó",
  addEdge: "Adicionar aresta",
  addNode: "Adicionar nó",
  back: "Voltar",
  close: "Fechar",
  createEdgeError: "Não foi possível linkar arestas a um cluster.",
  del: "Remover selecionado",
  deleteClusterError: "Clusters não puderam ser removidos.",
  edgeDescription: "Clique em um nó e arraste a aresta até outro nó para conectá-los",
  edit: "Editar",
  editClusterError: "Clusters não puderam ser editados.",
  editEdge: "Editar aresta",
  editEdgeDescription: "Clique nos pontos de controle e os arraste para um nó para conectá-los",
  editNode: "Editar nó"
};
// Russian
const ru = {
  addDescription: "Кликните в свободное место, чтобы добавить новый узел.",
  addEdge: "Добавить ребро",
  addNode: "Добавить узел",
  back: "Назад",
  close: "Закрывать",
  createEdgeError: "Невозможно соединить ребра в кластер.",
  del: "Удалить выбранное",
  deleteClusterError: "Кластеры не могут быть удалены",
  edgeDescription: "Кликните на узел и протяните ребро к другому узлу, чтобы соединить их.",
  edit: "Редактировать",
  editClusterError: "Кластеры недоступны для редактирования.",
  editEdge: "Редактировать ребро",
  editEdgeDescription: "Кликните на контрольные точки и перетащите их в узел, чтобы подключиться к нему.",
  editNode: "Редактировать узел"
};
// Chinese
const cn = {
  addDescription: "单击空白处放置新节点。",
  addEdge: "添加连接线",
  addNode: "添加节点",
  back: "返回",
  close: "關閉",
  createEdgeError: "无法将连接线连接到群集。",
  del: "删除选定",
  deleteClusterError: "无法删除群集。",
  edgeDescription: "单击某个节点并将该连接线拖动到另一个节点以连接它们。",
  edit: "编辑",
  editClusterError: "无法编辑群集。",
  editEdge: "编辑连接线",
  editEdgeDescription: "单击控制节点并将它们拖到节点上连接。",
  editNode: "编辑节点"
};
// Ukrainian
const uk = {
  addDescription: "Kлікніть на вільне місце, щоб додати новий вузол.",
  addEdge: "Додати край",
  addNode: "Додати вузол",
  back: "Назад",
  close: "Закрити",
  createEdgeError: "Не можливо об'єднати краї в групу.",
  del: "Видалити обране",
  deleteClusterError: "Групи не можуть бути видалені.",
  edgeDescription: "Клікніть на вузол і перетягніть край до іншого вузла, щоб їх з'єднати.",
  edit: "Редагувати",
  editClusterError: "Групи недоступні для редагування.",
  editEdge: "Редагувати край",
  editEdgeDescription: "Клікніть на контрольні точки і перетягніть їх у вузол, щоб підключитися до нього.",
  editNode: "Редагувати вузол"
};
// French
const fr = {
  addDescription: "Cliquez dans un endroit vide pour placer un nœud.",
  addEdge: "Ajouter un lien",
  addNode: "Ajouter un nœud",
  back: "Retour",
  close: "Fermer",
  createEdgeError: "Impossible de créer un lien vers un cluster.",
  del: "Effacer la sélection",
  deleteClusterError: "Les clusters ne peuvent pas être effacés.",
  edgeDescription: "Cliquez sur un nœud et glissez le lien vers un autre nœud pour les connecter.",
  edit: "Éditer",
  editClusterError: "Les clusters ne peuvent pas être édités.",
  editEdge: "Éditer le lien",
  editEdgeDescription: "Cliquez sur les points de contrôle et glissez-les pour connecter un nœud.",
  editNode: "Éditer le nœud"
};
// Czech
const cs = {
  addDescription: "Kluknutím do prázdného prostoru můžete přidat nový vrchol.",
  addEdge: "Přidat hranu",
  addNode: "Přidat vrchol",
  back: "Zpět",
  close: "Zavřít",
  createEdgeError: "Nelze připojit hranu ke shluku.",
  del: "Smazat výběr",
  deleteClusterError: "Nelze mazat shluky.",
  edgeDescription: "Přetažením z jednoho vrcholu do druhého můžete spojit tyto vrcholy novou hranou.",
  edit: "Upravit",
  editClusterError: "Nelze upravovat shluky.",
  editEdge: "Upravit hranu",
  editEdgeDescription: "Přetažením kontrolního vrcholu hrany ji můžete připojit k jinému vrcholu.",
  editNode: "Upravit vrchol"
};

var locales = /*#__PURE__*/Object.freeze({
	__proto__: null,
	cn: cn,
	cs: cs,
	de: de,
	en: en,
	es: es,
	fr: fr,
	it: it,
	nl: nl,
	pt: pt,
	ru: ru,
	uk: uk
});

/**
 * Normalizes language code into the format used internally.
 * @param locales - All the available locales.
 * @param rawCode - The original code as supplied by the user.
 * @returns Language code in the format language-COUNTRY or language, eventually
 * fallbacks to en.
 */
function normalizeLanguageCode(locales, rawCode) {
  try {
    const [rawLanguage, rawCountry] = rawCode.split(/[-_ /]/, 2);
    const language = rawLanguage != null ? rawLanguage.toLowerCase() : null;
    const country = rawCountry != null ? rawCountry.toUpperCase() : null;
    if (language && country) {
      const code = language + "-" + country;
      if (Object.prototype.hasOwnProperty.call(locales, code)) {
        return code;
      } else {
        var _context;
        console.warn(_concatInstanceProperty(_context = "Unknown variant ".concat(country, " of language ")).call(_context, language, "."));
      }
    }
    if (language) {
      const code = language;
      if (Object.prototype.hasOwnProperty.call(locales, code)) {
        return code;
      } else {
        console.warn("Unknown language ".concat(language));
      }
    }
    console.warn("Unknown locale ".concat(rawCode, ", falling back to English."));
    return "en";
  } catch (error) {
    console.error(error);
    console.warn("Unexpected error while normalizing locale ".concat(rawCode, ", falling back to English."));
    return "en";
  }
}

/**
 * Associates a canvas to a given image, containing a number of renderings
 * of the image at various sizes.
 *
 * This technique is known as 'mipmapping'.
 *
 * NOTE: Images can also be of type 'data:svg+xml`. This code also works
 * for svg, but the mipmapping may not be necessary.
 * @param {Image} image
 */
class CachedImage {
  /**
   * @ignore
   */
  constructor() {
    this.NUM_ITERATIONS = 4; // Number of items in the coordinates array

    this.image = new Image();
    this.canvas = document.createElement("canvas");
  }

  /**
   * Called when the image has been successfully loaded.
   */
  init() {
    if (this.initialized()) return;
    this.src = this.image.src; // For same interface with Image
    const w = this.image.width;
    const h = this.image.height;

    // Ease external access
    this.width = w;
    this.height = h;
    const h2 = Math.floor(h / 2);
    const h4 = Math.floor(h / 4);
    const h8 = Math.floor(h / 8);
    const h16 = Math.floor(h / 16);
    const w2 = Math.floor(w / 2);
    const w4 = Math.floor(w / 4);
    const w8 = Math.floor(w / 8);
    const w16 = Math.floor(w / 16);

    // Make canvas as small as possible
    this.canvas.width = 3 * w4;
    this.canvas.height = h2;

    // Coordinates and sizes of images contained in the canvas
    // Values per row:  [top x, left y, width, height]

    this.coordinates = [[0, 0, w2, h2], [w2, 0, w4, h4], [w2, h4, w8, h8], [5 * w8, h4, w16, h16]];
    this._fillMipMap();
  }

  /**
   * @returns {boolean} true if init() has been called, false otherwise.
   */
  initialized() {
    return this.coordinates !== undefined;
  }

  /**
   * Redraw main image in various sizes to the context.
   *
   * The rationale behind this is to reduce artefacts due to interpolation
   * at differing zoom levels.
   *
   * Source: http://stackoverflow.com/q/18761404/1223531
   *
   * This methods takes the resizing out of the drawing loop, in order to
   * reduce performance overhead.
   *
   * TODO: The code assumes that a 2D context can always be gotten. This is
   * not necessarily true! OTOH, if not true then usage of this class
   * is senseless.
   * @private
   */
  _fillMipMap() {
    const ctx = this.canvas.getContext("2d");

    // First zoom-level comes from the image
    const to = this.coordinates[0];
    ctx.drawImage(this.image, to[0], to[1], to[2], to[3]);

    // The rest are copy actions internal to the canvas/context
    for (let iterations = 1; iterations < this.NUM_ITERATIONS; iterations++) {
      const from = this.coordinates[iterations - 1];
      const to = this.coordinates[iterations];
      ctx.drawImage(this.canvas, from[0], from[1], from[2], from[3], to[0], to[1], to[2], to[3]);
    }
  }

  /**
   * Draw the image, using the mipmap if necessary.
   *
   * MipMap is only used if param factor > 2; otherwise, original bitmap
   * is resized. This is also used to skip mipmap usage, e.g. by setting factor = 1
   *
   * Credits to 'Alex de Mulder' for original implementation.
   * @param {CanvasRenderingContext2D} ctx  context on which to draw zoomed image
   * @param {Float} factor scale factor at which to draw
   * @param {number} left
   * @param {number} top
   * @param {number} width
   * @param {number} height
   */
  drawImageAtPosition(ctx, factor, left, top, width, height) {
    if (!this.initialized()) return; //can't draw image yet not intialized

    if (factor > 2) {
      // Determine which zoomed image to use
      factor *= 0.5;
      let iterations = 0;
      while (factor > 2 && iterations < this.NUM_ITERATIONS) {
        factor *= 0.5;
        iterations += 1;
      }
      if (iterations >= this.NUM_ITERATIONS) {
        iterations = this.NUM_ITERATIONS - 1;
      }
      //console.log("iterations: " + iterations);

      const from = this.coordinates[iterations];
      ctx.drawImage(this.canvas, from[0], from[1], from[2], from[3], left, top, width, height);
    } else {
      // Draw image directly
      ctx.drawImage(this.image, left, top, width, height);
    }
  }
}

/**
 * This callback is a callback that accepts an Image.
 * @callback ImageCallback
 * @param {Image} image
 */

/**
 * This class loads images and keeps them stored.
 * @param {ImageCallback} callback
 */
class Images {
  /**
   * @param {ImageCallback} callback
   */
  constructor(callback) {
    this.images = {};
    this.imageBroken = {};
    this.callback = callback;
  }

  /**
   * @param {string} url                      The original Url that failed to load, if the broken image is successfully loaded it will be added to the cache using this Url as the key so that subsequent requests for this Url will return the broken image
   * @param {string} brokenUrl                Url the broken image to try and load
   * @param {Image} imageToLoadBrokenUrlOn   The image object
   */
  _tryloadBrokenUrl(url, brokenUrl, imageToLoadBrokenUrlOn) {
    //If these parameters aren't specified then exit the function because nothing constructive can be done
    if (url === undefined || imageToLoadBrokenUrlOn === undefined) return;
    if (brokenUrl === undefined) {
      console.warn("No broken url image defined");
      return;
    }

    //Clear the old subscription to the error event and put a new in place that only handle errors in loading the brokenImageUrl
    imageToLoadBrokenUrlOn.image.onerror = () => {
      console.error("Could not load brokenImage:", brokenUrl);
      // cache item will contain empty image, this should be OK for default
    };

    //Set the source of the image to the brokenUrl, this is actually what kicks off the loading of the broken image
    imageToLoadBrokenUrlOn.image.src = brokenUrl;
  }

  /**
   *
   * @param {vis.Image} imageToRedrawWith
   * @private
   */
  _redrawWithImage(imageToRedrawWith) {
    if (this.callback) {
      this.callback(imageToRedrawWith);
    }
  }

  /**
   * @param {string} url          Url of the image
   * @param {string} brokenUrl    Url of an image to use if the url image is not found
   * @returns {Image} img          The image object
   */
  load(url, brokenUrl) {
    //Try and get the image from the cache, if successful then return the cached image
    const cachedImage = this.images[url];
    if (cachedImage) return cachedImage;

    //Create a new image
    const img = new CachedImage();

    // Need to add to cache here, otherwise final return will spawn different copies of the same image,
    // Also, there will be multiple loads of the same image.
    this.images[url] = img;

    //Subscribe to the event that is raised if the image loads successfully
    img.image.onload = () => {
      // Properly init the cached item and then request a redraw
      this._fixImageCoordinates(img.image);
      img.init();
      this._redrawWithImage(img);
    };

    //Subscribe to the event that is raised if the image fails to load
    img.image.onerror = () => {
      console.error("Could not load image:", url);
      //Try and load the image specified by the brokenUrl using
      this._tryloadBrokenUrl(url, brokenUrl, img);
    };

    //Set the source of the image to the url, this is what actually kicks off the loading of the image
    img.image.src = url;

    //Return the new image
    return img;
  }

  /**
   * IE11 fix -- thanks dponch!
   *
   * Local helper function
   * @param {vis.Image} imageToCache
   * @private
   */
  _fixImageCoordinates(imageToCache) {
    if (imageToCache.width === 0) {
      document.body.appendChild(imageToCache);
      imageToCache.width = imageToCache.offsetWidth;
      imageToCache.height = imageToCache.offsetHeight;
      document.body.removeChild(imageToCache);
    }
  }
}

var internalMetadata = {exports: {}};

// FF26- bug: ArrayBuffers are non-extensible, but Object.isExtensible does not report it
var fails$8 = fails$u;

var arrayBufferNonExtensible = fails$8(function () {
  if (typeof ArrayBuffer == 'function') {
    var buffer = new ArrayBuffer(8);
    // eslint-disable-next-line es/no-object-isextensible, es/no-object-defineproperty -- safe
    if (Object.isExtensible(buffer)) Object.defineProperty(buffer, 'a', { value: 8 });
  }
});

var fails$7 = fails$u;
var isObject$4 = isObject$h;
var classof$3 = classofRaw$2;
var ARRAY_BUFFER_NON_EXTENSIBLE = arrayBufferNonExtensible;

// eslint-disable-next-line es/no-object-isextensible -- safe
var $isExtensible = Object.isExtensible;
var FAILS_ON_PRIMITIVES$1 = fails$7(function () { $isExtensible(1); });

// `Object.isExtensible` method
// https://tc39.es/ecma262/#sec-object.isextensible
var objectIsExtensible = (FAILS_ON_PRIMITIVES$1 || ARRAY_BUFFER_NON_EXTENSIBLE) ? function isExtensible(it) {
  if (!isObject$4(it)) return false;
  if (ARRAY_BUFFER_NON_EXTENSIBLE && classof$3(it) === 'ArrayBuffer') return false;
  return $isExtensible ? $isExtensible(it) : true;
} : $isExtensible;

var fails$6 = fails$u;

var freezing = !fails$6(function () {
  // eslint-disable-next-line es/no-object-isextensible, es/no-object-preventextensions -- required for testing
  return Object.isExtensible(Object.preventExtensions({}));
});

var $$i = _export;
var uncurryThis$7 = functionUncurryThis;
var hiddenKeys = hiddenKeys$6;
var isObject$3 = isObject$h;
var hasOwn$2 = hasOwnProperty_1;
var defineProperty$a = objectDefineProperty.f;
var getOwnPropertyNamesModule = objectGetOwnPropertyNames;
var getOwnPropertyNamesExternalModule = objectGetOwnPropertyNamesExternal;
var isExtensible$1 = objectIsExtensible;
var uid = uid$4;
var FREEZING$1 = freezing;

var REQUIRED = false;
var METADATA$1 = uid('meta');
var id$1 = 0;

var setMetadata = function (it) {
  defineProperty$a(it, METADATA$1, { value: {
    objectID: 'O' + id$1++, // object ID
    weakData: {}          // weak collections IDs
  } });
};

var fastKey$1 = function (it, create) {
  // return a primitive with prefix
  if (!isObject$3(it)) return typeof it == 'symbol' ? it : (typeof it == 'string' ? 'S' : 'P') + it;
  if (!hasOwn$2(it, METADATA$1)) {
    // can't set metadata to uncaught frozen object
    if (!isExtensible$1(it)) return 'F';
    // not necessary to add metadata
    if (!create) return 'E';
    // add missing metadata
    setMetadata(it);
  // return object ID
  } return it[METADATA$1].objectID;
};

var getWeakData$1 = function (it, create) {
  if (!hasOwn$2(it, METADATA$1)) {
    // can't set metadata to uncaught frozen object
    if (!isExtensible$1(it)) return true;
    // not necessary to add metadata
    if (!create) return false;
    // add missing metadata
    setMetadata(it);
  // return the store of weak collections IDs
  } return it[METADATA$1].weakData;
};

// add metadata on freeze-family methods calling
var onFreeze = function (it) {
  if (FREEZING$1 && REQUIRED && isExtensible$1(it) && !hasOwn$2(it, METADATA$1)) setMetadata(it);
  return it;
};

var enable = function () {
  meta.enable = function () { /* empty */ };
  REQUIRED = true;
  var getOwnPropertyNames = getOwnPropertyNamesModule.f;
  var splice = uncurryThis$7([].splice);
  var test = {};
  test[METADATA$1] = 1;

  // prevent exposing of metadata key
  if (getOwnPropertyNames(test).length) {
    getOwnPropertyNamesModule.f = function (it) {
      var result = getOwnPropertyNames(it);
      for (var i = 0, length = result.length; i < length; i++) {
        if (result[i] === METADATA$1) {
          splice(result, i, 1);
          break;
        }
      } return result;
    };

    $$i({ target: 'Object', stat: true, forced: true }, {
      getOwnPropertyNames: getOwnPropertyNamesExternalModule.f
    });
  }
};

var meta = internalMetadata.exports = {
  enable: enable,
  fastKey: fastKey$1,
  getWeakData: getWeakData$1,
  onFreeze: onFreeze
};

hiddenKeys[METADATA$1] = true;

var internalMetadataExports = internalMetadata.exports;

var wellKnownSymbol$4 = wellKnownSymbol$l;
var Iterators$1 = iterators;

var ITERATOR$2 = wellKnownSymbol$4('iterator');
var ArrayPrototype$5 = Array.prototype;

// check on default Array iterator
var isArrayIteratorMethod$1 = function (it) {
  return it !== undefined && (Iterators$1.Array === it || ArrayPrototype$5[ITERATOR$2] === it);
};

var classof$2 = classof$c;
var getMethod$1 = getMethod$3;
var isNullOrUndefined$3 = isNullOrUndefined$6;
var Iterators = iterators;
var wellKnownSymbol$3 = wellKnownSymbol$l;

var ITERATOR$1 = wellKnownSymbol$3('iterator');

var getIteratorMethod$2 = function (it) {
  if (!isNullOrUndefined$3(it)) return getMethod$1(it, ITERATOR$1)
    || getMethod$1(it, '@@iterator')
    || Iterators[classof$2(it)];
};

var call$2 = functionCall;
var aCallable$2 = aCallable$6;
var anObject$3 = anObject$9;
var tryToString$1 = tryToString$5;
var getIteratorMethod$1 = getIteratorMethod$2;

var $TypeError$3 = TypeError;

var getIterator$1 = function (argument, usingIterator) {
  var iteratorMethod = arguments.length < 2 ? getIteratorMethod$1(argument) : usingIterator;
  if (aCallable$2(iteratorMethod)) return anObject$3(call$2(iteratorMethod, argument));
  throw new $TypeError$3(tryToString$1(argument) + ' is not iterable');
};

var call$1 = functionCall;
var anObject$2 = anObject$9;
var getMethod = getMethod$3;

var iteratorClose$1 = function (iterator, kind, value) {
  var innerResult, innerError;
  anObject$2(iterator);
  try {
    innerResult = getMethod(iterator, 'return');
    if (!innerResult) {
      if (kind === 'throw') throw value;
      return value;
    }
    innerResult = call$1(innerResult, iterator);
  } catch (error) {
    innerError = true;
    innerResult = error;
  }
  if (kind === 'throw') throw value;
  if (innerError) throw innerResult;
  anObject$2(innerResult);
  return value;
};

var bind$1 = functionBindContext;
var call = functionCall;
var anObject$1 = anObject$9;
var tryToString = tryToString$5;
var isArrayIteratorMethod = isArrayIteratorMethod$1;
var lengthOfArrayLike$2 = lengthOfArrayLike$a;
var isPrototypeOf$6 = objectIsPrototypeOf;
var getIterator = getIterator$1;
var getIteratorMethod = getIteratorMethod$2;
var iteratorClose = iteratorClose$1;

var $TypeError$2 = TypeError;

var Result = function (stopped, result) {
  this.stopped = stopped;
  this.result = result;
};

var ResultPrototype = Result.prototype;

var iterate$3 = function (iterable, unboundFunction, options) {
  var that = options && options.that;
  var AS_ENTRIES = !!(options && options.AS_ENTRIES);
  var IS_RECORD = !!(options && options.IS_RECORD);
  var IS_ITERATOR = !!(options && options.IS_ITERATOR);
  var INTERRUPTED = !!(options && options.INTERRUPTED);
  var fn = bind$1(unboundFunction, that);
  var iterator, iterFn, index, length, result, next, step;

  var stop = function (condition) {
    if (iterator) iteratorClose(iterator, 'normal', condition);
    return new Result(true, condition);
  };

  var callFn = function (value) {
    if (AS_ENTRIES) {
      anObject$1(value);
      return INTERRUPTED ? fn(value[0], value[1], stop) : fn(value[0], value[1]);
    } return INTERRUPTED ? fn(value, stop) : fn(value);
  };

  if (IS_RECORD) {
    iterator = iterable.iterator;
  } else if (IS_ITERATOR) {
    iterator = iterable;
  } else {
    iterFn = getIteratorMethod(iterable);
    if (!iterFn) throw new $TypeError$2(tryToString(iterable) + ' is not iterable');
    // optimisation for array iterators
    if (isArrayIteratorMethod(iterFn)) {
      for (index = 0, length = lengthOfArrayLike$2(iterable); length > index; index++) {
        result = callFn(iterable[index]);
        if (result && isPrototypeOf$6(ResultPrototype, result)) return result;
      } return new Result(false);
    }
    iterator = getIterator(iterable, iterFn);
  }

  next = IS_RECORD ? iterable.next : iterator.next;
  while (!(step = call(next, iterator)).done) {
    try {
      result = callFn(step.value);
    } catch (error) {
      iteratorClose(iterator, 'throw', error);
    }
    if (typeof result == 'object' && result && isPrototypeOf$6(ResultPrototype, result)) return result;
  } return new Result(false);
};

var isPrototypeOf$5 = objectIsPrototypeOf;

var $TypeError$1 = TypeError;

var anInstance$3 = function (it, Prototype) {
  if (isPrototypeOf$5(Prototype, it)) return it;
  throw new $TypeError$1('Incorrect invocation');
};

var $$h = _export;
var global$5 = global$n;
var InternalMetadataModule$1 = internalMetadataExports;
var fails$5 = fails$u;
var createNonEnumerableProperty = createNonEnumerableProperty$6;
var iterate$2 = iterate$3;
var anInstance$2 = anInstance$3;
var isCallable = isCallable$h;
var isObject$2 = isObject$h;
var isNullOrUndefined$2 = isNullOrUndefined$6;
var setToStringTag = setToStringTag$6;
var defineProperty$9 = objectDefineProperty.f;
var forEach = arrayIteration.forEach;
var DESCRIPTORS$6 = descriptors;
var InternalStateModule$3 = internalState;

var setInternalState$3 = InternalStateModule$3.set;
var internalStateGetterFor$2 = InternalStateModule$3.getterFor;

var collection$3 = function (CONSTRUCTOR_NAME, wrapper, common) {
  var IS_MAP = CONSTRUCTOR_NAME.indexOf('Map') !== -1;
  var IS_WEAK = CONSTRUCTOR_NAME.indexOf('Weak') !== -1;
  var ADDER = IS_MAP ? 'set' : 'add';
  var NativeConstructor = global$5[CONSTRUCTOR_NAME];
  var NativePrototype = NativeConstructor && NativeConstructor.prototype;
  var exported = {};
  var Constructor;

  if (!DESCRIPTORS$6 || !isCallable(NativeConstructor)
    || !(IS_WEAK || NativePrototype.forEach && !fails$5(function () { new NativeConstructor().entries().next(); }))
  ) {
    // create collection constructor
    Constructor = common.getConstructor(wrapper, CONSTRUCTOR_NAME, IS_MAP, ADDER);
    InternalMetadataModule$1.enable();
  } else {
    Constructor = wrapper(function (target, iterable) {
      setInternalState$3(anInstance$2(target, Prototype), {
        type: CONSTRUCTOR_NAME,
        collection: new NativeConstructor()
      });
      if (!isNullOrUndefined$2(iterable)) iterate$2(iterable, target[ADDER], { that: target, AS_ENTRIES: IS_MAP });
    });

    var Prototype = Constructor.prototype;

    var getInternalState = internalStateGetterFor$2(CONSTRUCTOR_NAME);

    forEach(['add', 'clear', 'delete', 'forEach', 'get', 'has', 'set', 'keys', 'values', 'entries'], function (KEY) {
      var IS_ADDER = KEY === 'add' || KEY === 'set';
      if (KEY in NativePrototype && !(IS_WEAK && KEY === 'clear')) {
        createNonEnumerableProperty(Prototype, KEY, function (a, b) {
          var collection = getInternalState(this).collection;
          if (!IS_ADDER && IS_WEAK && !isObject$2(a)) return KEY === 'get' ? undefined : false;
          var result = collection[KEY](a === 0 ? 0 : a, b);
          return IS_ADDER ? this : result;
        });
      }
    });

    IS_WEAK || defineProperty$9(Prototype, 'size', {
      configurable: true,
      get: function () {
        return getInternalState(this).collection.size;
      }
    });
  }

  setToStringTag(Constructor, CONSTRUCTOR_NAME, false, true);

  exported[CONSTRUCTOR_NAME] = Constructor;
  $$h({ global: true, forced: true }, exported);

  if (!IS_WEAK) common.setStrong(Constructor, CONSTRUCTOR_NAME, IS_MAP);

  return Constructor;
};

var defineBuiltIn = defineBuiltIn$5;

var defineBuiltIns$3 = function (target, src, options) {
  for (var key in src) {
    if (options && options.unsafe && target[key]) target[key] = src[key];
    else defineBuiltIn(target, key, src[key], options);
  } return target;
};

var getBuiltIn$2 = getBuiltIn$b;
var defineBuiltInAccessor$1 = defineBuiltInAccessor$3;
var wellKnownSymbol$2 = wellKnownSymbol$l;
var DESCRIPTORS$5 = descriptors;

var SPECIES = wellKnownSymbol$2('species');

var setSpecies$1 = function (CONSTRUCTOR_NAME) {
  var Constructor = getBuiltIn$2(CONSTRUCTOR_NAME);

  if (DESCRIPTORS$5 && Constructor && !Constructor[SPECIES]) {
    defineBuiltInAccessor$1(Constructor, SPECIES, {
      configurable: true,
      get: function () { return this; }
    });
  }
};

var create = objectCreate;
var defineBuiltInAccessor = defineBuiltInAccessor$3;
var defineBuiltIns$2 = defineBuiltIns$3;
var bind = functionBindContext;
var anInstance$1 = anInstance$3;
var isNullOrUndefined$1 = isNullOrUndefined$6;
var iterate$1 = iterate$3;
var defineIterator$1 = iteratorDefine;
var createIterResultObject$1 = createIterResultObject$3;
var setSpecies = setSpecies$1;
var DESCRIPTORS$4 = descriptors;
var fastKey = internalMetadataExports.fastKey;
var InternalStateModule$2 = internalState;

var setInternalState$2 = InternalStateModule$2.set;
var internalStateGetterFor$1 = InternalStateModule$2.getterFor;

var collectionStrong$2 = {
  getConstructor: function (wrapper, CONSTRUCTOR_NAME, IS_MAP, ADDER) {
    var Constructor = wrapper(function (that, iterable) {
      anInstance$1(that, Prototype);
      setInternalState$2(that, {
        type: CONSTRUCTOR_NAME,
        index: create(null),
        first: undefined,
        last: undefined,
        size: 0
      });
      if (!DESCRIPTORS$4) that.size = 0;
      if (!isNullOrUndefined$1(iterable)) iterate$1(iterable, that[ADDER], { that: that, AS_ENTRIES: IS_MAP });
    });

    var Prototype = Constructor.prototype;

    var getInternalState = internalStateGetterFor$1(CONSTRUCTOR_NAME);

    var define = function (that, key, value) {
      var state = getInternalState(that);
      var entry = getEntry(that, key);
      var previous, index;
      // change existing entry
      if (entry) {
        entry.value = value;
      // create new entry
      } else {
        state.last = entry = {
          index: index = fastKey(key, true),
          key: key,
          value: value,
          previous: previous = state.last,
          next: undefined,
          removed: false
        };
        if (!state.first) state.first = entry;
        if (previous) previous.next = entry;
        if (DESCRIPTORS$4) state.size++;
        else that.size++;
        // add to index
        if (index !== 'F') state.index[index] = entry;
      } return that;
    };

    var getEntry = function (that, key) {
      var state = getInternalState(that);
      // fast case
      var index = fastKey(key);
      var entry;
      if (index !== 'F') return state.index[index];
      // frozen object case
      for (entry = state.first; entry; entry = entry.next) {
        if (entry.key === key) return entry;
      }
    };

    defineBuiltIns$2(Prototype, {
      // `{ Map, Set }.prototype.clear()` methods
      // https://tc39.es/ecma262/#sec-map.prototype.clear
      // https://tc39.es/ecma262/#sec-set.prototype.clear
      clear: function clear() {
        var that = this;
        var state = getInternalState(that);
        var data = state.index;
        var entry = state.first;
        while (entry) {
          entry.removed = true;
          if (entry.previous) entry.previous = entry.previous.next = undefined;
          delete data[entry.index];
          entry = entry.next;
        }
        state.first = state.last = undefined;
        if (DESCRIPTORS$4) state.size = 0;
        else that.size = 0;
      },
      // `{ Map, Set }.prototype.delete(key)` methods
      // https://tc39.es/ecma262/#sec-map.prototype.delete
      // https://tc39.es/ecma262/#sec-set.prototype.delete
      'delete': function (key) {
        var that = this;
        var state = getInternalState(that);
        var entry = getEntry(that, key);
        if (entry) {
          var next = entry.next;
          var prev = entry.previous;
          delete state.index[entry.index];
          entry.removed = true;
          if (prev) prev.next = next;
          if (next) next.previous = prev;
          if (state.first === entry) state.first = next;
          if (state.last === entry) state.last = prev;
          if (DESCRIPTORS$4) state.size--;
          else that.size--;
        } return !!entry;
      },
      // `{ Map, Set }.prototype.forEach(callbackfn, thisArg = undefined)` methods
      // https://tc39.es/ecma262/#sec-map.prototype.foreach
      // https://tc39.es/ecma262/#sec-set.prototype.foreach
      forEach: function forEach(callbackfn /* , that = undefined */) {
        var state = getInternalState(this);
        var boundFunction = bind(callbackfn, arguments.length > 1 ? arguments[1] : undefined);
        var entry;
        while (entry = entry ? entry.next : state.first) {
          boundFunction(entry.value, entry.key, this);
          // revert to the last existing entry
          while (entry && entry.removed) entry = entry.previous;
        }
      },
      // `{ Map, Set}.prototype.has(key)` methods
      // https://tc39.es/ecma262/#sec-map.prototype.has
      // https://tc39.es/ecma262/#sec-set.prototype.has
      has: function has(key) {
        return !!getEntry(this, key);
      }
    });

    defineBuiltIns$2(Prototype, IS_MAP ? {
      // `Map.prototype.get(key)` method
      // https://tc39.es/ecma262/#sec-map.prototype.get
      get: function get(key) {
        var entry = getEntry(this, key);
        return entry && entry.value;
      },
      // `Map.prototype.set(key, value)` method
      // https://tc39.es/ecma262/#sec-map.prototype.set
      set: function set(key, value) {
        return define(this, key === 0 ? 0 : key, value);
      }
    } : {
      // `Set.prototype.add(value)` method
      // https://tc39.es/ecma262/#sec-set.prototype.add
      add: function add(value) {
        return define(this, value = value === 0 ? 0 : value, value);
      }
    });
    if (DESCRIPTORS$4) defineBuiltInAccessor(Prototype, 'size', {
      configurable: true,
      get: function () {
        return getInternalState(this).size;
      }
    });
    return Constructor;
  },
  setStrong: function (Constructor, CONSTRUCTOR_NAME, IS_MAP) {
    var ITERATOR_NAME = CONSTRUCTOR_NAME + ' Iterator';
    var getInternalCollectionState = internalStateGetterFor$1(CONSTRUCTOR_NAME);
    var getInternalIteratorState = internalStateGetterFor$1(ITERATOR_NAME);
    // `{ Map, Set }.prototype.{ keys, values, entries, @@iterator }()` methods
    // https://tc39.es/ecma262/#sec-map.prototype.entries
    // https://tc39.es/ecma262/#sec-map.prototype.keys
    // https://tc39.es/ecma262/#sec-map.prototype.values
    // https://tc39.es/ecma262/#sec-map.prototype-@@iterator
    // https://tc39.es/ecma262/#sec-set.prototype.entries
    // https://tc39.es/ecma262/#sec-set.prototype.keys
    // https://tc39.es/ecma262/#sec-set.prototype.values
    // https://tc39.es/ecma262/#sec-set.prototype-@@iterator
    defineIterator$1(Constructor, CONSTRUCTOR_NAME, function (iterated, kind) {
      setInternalState$2(this, {
        type: ITERATOR_NAME,
        target: iterated,
        state: getInternalCollectionState(iterated),
        kind: kind,
        last: undefined
      });
    }, function () {
      var state = getInternalIteratorState(this);
      var kind = state.kind;
      var entry = state.last;
      // revert to the last existing entry
      while (entry && entry.removed) entry = entry.previous;
      // get next entry
      if (!state.target || !(state.last = entry = entry ? entry.next : state.state.first)) {
        // or finish the iteration
        state.target = undefined;
        return createIterResultObject$1(undefined, true);
      }
      // return step by kind
      if (kind === 'keys') return createIterResultObject$1(entry.key, false);
      if (kind === 'values') return createIterResultObject$1(entry.value, false);
      return createIterResultObject$1([entry.key, entry.value], false);
    }, IS_MAP ? 'entries' : 'values', !IS_MAP, true);

    // `{ Map, Set }.prototype[@@species]` accessors
    // https://tc39.es/ecma262/#sec-get-map-@@species
    // https://tc39.es/ecma262/#sec-get-set-@@species
    setSpecies(CONSTRUCTOR_NAME);
  }
};

var collection$2 = collection$3;
var collectionStrong$1 = collectionStrong$2;

// `Map` constructor
// https://tc39.es/ecma262/#sec-map-objects
collection$2('Map', function (init) {
  return function Map() { return init(this, arguments.length ? arguments[0] : undefined); };
}, collectionStrong$1);

var uncurryThis$6 = functionUncurryThis;
var toIntegerOrInfinity = toIntegerOrInfinity$4;
var toString$3 = toString$a;
var requireObjectCoercible = requireObjectCoercible$5;

var charAt$2 = uncurryThis$6(''.charAt);
var charCodeAt = uncurryThis$6(''.charCodeAt);
var stringSlice = uncurryThis$6(''.slice);

var createMethod$1 = function (CONVERT_TO_STRING) {
  return function ($this, pos) {
    var S = toString$3(requireObjectCoercible($this));
    var position = toIntegerOrInfinity(pos);
    var size = S.length;
    var first, second;
    if (position < 0 || position >= size) return CONVERT_TO_STRING ? '' : undefined;
    first = charCodeAt(S, position);
    return first < 0xD800 || first > 0xDBFF || position + 1 === size
      || (second = charCodeAt(S, position + 1)) < 0xDC00 || second > 0xDFFF
        ? CONVERT_TO_STRING
          ? charAt$2(S, position)
          : first
        : CONVERT_TO_STRING
          ? stringSlice(S, position, position + 2)
          : (first - 0xD800 << 10) + (second - 0xDC00) + 0x10000;
  };
};

var stringMultibyte = {
  // `String.prototype.codePointAt` method
  // https://tc39.es/ecma262/#sec-string.prototype.codepointat
  codeAt: createMethod$1(false),
  // `String.prototype.at` method
  // https://github.com/mathiasbynens/String.prototype.at
  charAt: createMethod$1(true)
};

var charAt$1 = stringMultibyte.charAt;
var toString$2 = toString$a;
var InternalStateModule$1 = internalState;
var defineIterator = iteratorDefine;
var createIterResultObject = createIterResultObject$3;

var STRING_ITERATOR = 'String Iterator';
var setInternalState$1 = InternalStateModule$1.set;
var getInternalState = InternalStateModule$1.getterFor(STRING_ITERATOR);

// `String.prototype[@@iterator]` method
// https://tc39.es/ecma262/#sec-string.prototype-@@iterator
defineIterator(String, 'String', function (iterated) {
  setInternalState$1(this, {
    type: STRING_ITERATOR,
    string: toString$2(iterated),
    index: 0
  });
// `%StringIteratorPrototype%.next` method
// https://tc39.es/ecma262/#sec-%stringiteratorprototype%.next
}, function next() {
  var state = getInternalState(this);
  var string = state.string;
  var index = state.index;
  var point;
  if (index >= string.length) return createIterResultObject(undefined, true);
  point = charAt$1(string, index);
  state.index += point.length;
  return createIterResultObject(point, false);
});

var path$d = path$s;

var map$2 = path$d.Map;

var parent$r = map$2;


var map$1 = parent$r;

var map = map$1;

var _Map = /*@__PURE__*/getDefaultExportFromCjs(map);

/**
 * This class can store groups and options specific for groups.
 */
class Groups {
  /**
   * @ignore
   */
  constructor() {
    this.clear();
    this._defaultIndex = 0;
    this._groupIndex = 0;
    this._defaultGroups = [{
      border: "#2B7CE9",
      background: "#97C2FC",
      highlight: {
        border: "#2B7CE9",
        background: "#D2E5FF"
      },
      hover: {
        border: "#2B7CE9",
        background: "#D2E5FF"
      }
    },
    // 0: blue
    {
      border: "#FFA500",
      background: "#FFFF00",
      highlight: {
        border: "#FFA500",
        background: "#FFFFA3"
      },
      hover: {
        border: "#FFA500",
        background: "#FFFFA3"
      }
    },
    // 1: yellow
    {
      border: "#FA0A10",
      background: "#FB7E81",
      highlight: {
        border: "#FA0A10",
        background: "#FFAFB1"
      },
      hover: {
        border: "#FA0A10",
        background: "#FFAFB1"
      }
    },
    // 2: red
    {
      border: "#41A906",
      background: "#7BE141",
      highlight: {
        border: "#41A906",
        background: "#A1EC76"
      },
      hover: {
        border: "#41A906",
        background: "#A1EC76"
      }
    },
    // 3: green
    {
      border: "#E129F0",
      background: "#EB7DF4",
      highlight: {
        border: "#E129F0",
        background: "#F0B3F5"
      },
      hover: {
        border: "#E129F0",
        background: "#F0B3F5"
      }
    },
    // 4: magenta
    {
      border: "#7C29F0",
      background: "#AD85E4",
      highlight: {
        border: "#7C29F0",
        background: "#D3BDF0"
      },
      hover: {
        border: "#7C29F0",
        background: "#D3BDF0"
      }
    },
    // 5: purple
    {
      border: "#C37F00",
      background: "#FFA807",
      highlight: {
        border: "#C37F00",
        background: "#FFCA66"
      },
      hover: {
        border: "#C37F00",
        background: "#FFCA66"
      }
    },
    // 6: orange
    {
      border: "#4220FB",
      background: "#6E6EFD",
      highlight: {
        border: "#4220FB",
        background: "#9B9BFD"
      },
      hover: {
        border: "#4220FB",
        background: "#9B9BFD"
      }
    },
    // 7: darkblue
    {
      border: "#FD5A77",
      background: "#FFC0CB",
      highlight: {
        border: "#FD5A77",
        background: "#FFD1D9"
      },
      hover: {
        border: "#FD5A77",
        background: "#FFD1D9"
      }
    },
    // 8: pink
    {
      border: "#4AD63A",
      background: "#C2FABC",
      highlight: {
        border: "#4AD63A",
        background: "#E6FFE3"
      },
      hover: {
        border: "#4AD63A",
        background: "#E6FFE3"
      }
    },
    // 9: mint

    {
      border: "#990000",
      background: "#EE0000",
      highlight: {
        border: "#BB0000",
        background: "#FF3333"
      },
      hover: {
        border: "#BB0000",
        background: "#FF3333"
      }
    },
    // 10:bright red

    {
      border: "#FF6000",
      background: "#FF6000",
      highlight: {
        border: "#FF6000",
        background: "#FF6000"
      },
      hover: {
        border: "#FF6000",
        background: "#FF6000"
      }
    },
    // 12: real orange
    {
      border: "#97C2FC",
      background: "#2B7CE9",
      highlight: {
        border: "#D2E5FF",
        background: "#2B7CE9"
      },
      hover: {
        border: "#D2E5FF",
        background: "#2B7CE9"
      }
    },
    // 13: blue
    {
      border: "#399605",
      background: "#255C03",
      highlight: {
        border: "#399605",
        background: "#255C03"
      },
      hover: {
        border: "#399605",
        background: "#255C03"
      }
    },
    // 14: green
    {
      border: "#B70054",
      background: "#FF007E",
      highlight: {
        border: "#B70054",
        background: "#FF007E"
      },
      hover: {
        border: "#B70054",
        background: "#FF007E"
      }
    },
    // 15: magenta
    {
      border: "#AD85E4",
      background: "#7C29F0",
      highlight: {
        border: "#D3BDF0",
        background: "#7C29F0"
      },
      hover: {
        border: "#D3BDF0",
        background: "#7C29F0"
      }
    },
    // 16: purple
    {
      border: "#4557FA",
      background: "#000EA1",
      highlight: {
        border: "#6E6EFD",
        background: "#000EA1"
      },
      hover: {
        border: "#6E6EFD",
        background: "#000EA1"
      }
    },
    // 17: darkblue
    {
      border: "#FFC0CB",
      background: "#FD5A77",
      highlight: {
        border: "#FFD1D9",
        background: "#FD5A77"
      },
      hover: {
        border: "#FFD1D9",
        background: "#FD5A77"
      }
    },
    // 18: pink
    {
      border: "#C2FABC",
      background: "#74D66A",
      highlight: {
        border: "#E6FFE3",
        background: "#74D66A"
      },
      hover: {
        border: "#E6FFE3",
        background: "#74D66A"
      }
    },
    // 19: mint

    {
      border: "#EE0000",
      background: "#990000",
      highlight: {
        border: "#FF3333",
        background: "#BB0000"
      },
      hover: {
        border: "#FF3333",
        background: "#BB0000"
      }
    } // 20:bright red
    ];

    this.options = {};
    this.defaultOptions = {
      useDefaultGroups: true
    };
    _Object$assign(this.options, this.defaultOptions);
  }

  /**
   *
   * @param {object} options
   */
  setOptions(options) {
    const optionFields = ["useDefaultGroups"];
    if (options !== undefined) {
      for (const groupName in options) {
        if (Object.prototype.hasOwnProperty.call(options, groupName)) {
          if (_indexOfInstanceProperty(optionFields).call(optionFields, groupName) === -1) {
            const group = options[groupName];
            this.add(groupName, group);
          }
        }
      }
    }
  }

  /**
   * Clear all groups
   */
  clear() {
    this._groups = new _Map();
    this._groupNames = [];
  }

  /**
   * Get group options of a groupname.
   * If groupname is not found, a new group may be created.
   * @param {*}       groupname     Can be a number, string, Date, etc.
   * @param {boolean} [shouldCreate] If true, create a new group
   * @returns {object} The found or created group
   */
  get(groupname) {
    let shouldCreate = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
    let group = this._groups.get(groupname);
    if (group === undefined && shouldCreate) {
      if (this.options.useDefaultGroups === false && this._groupNames.length > 0) {
        // create new group
        const index = this._groupIndex % this._groupNames.length;
        ++this._groupIndex;
        group = {};
        group.color = this._groups.get(this._groupNames[index]);
        this._groups.set(groupname, group);
      } else {
        // create new group
        const index = this._defaultIndex % this._defaultGroups.length;
        this._defaultIndex++;
        group = {};
        group.color = this._defaultGroups[index];
        this._groups.set(groupname, group);
      }
    }
    return group;
  }

  /**
   * Add custom group style.
   * @param {string} groupName - The name of the group, a new group will be
   * created if a group with the same name doesn't exist, otherwise the old
   * groups style will be overwritten.
   * @param {object} style - An object containing borderColor, backgroundColor,
   * etc.
   * @returns {object} The created group object.
   */
  add(groupName, style) {
    // Only push group name once to prevent duplicates which would consume more
    // RAM and also skew the distribution towards more often updated groups,
    // neither of which is desirable.
    if (!this._groups.has(groupName)) {
      this._groupNames.push(groupName);
    }
    this._groups.set(groupName, style);
    return style;
  }
}

var $$g = _export;

// `Number.isNaN` method
// https://tc39.es/ecma262/#sec-number.isnan
$$g({ target: 'Number', stat: true }, {
  isNaN: function isNaN(number) {
    // eslint-disable-next-line no-self-compare -- NaN check
    return number !== number;
  }
});

var path$c = path$s;

var isNan$2 = path$c.Number.isNaN;

var parent$q = isNan$2;

var isNan$1 = parent$q;

var isNan = isNan$1;

var _Number$isNaN = /*@__PURE__*/getDefaultExportFromCjs(isNan);

var global$4 = global$n;

var globalIsFinite = global$4.isFinite;

// `Number.isFinite` method
// https://tc39.es/ecma262/#sec-number.isfinite
// eslint-disable-next-line es/no-number-isfinite -- safe
var numberIsFinite$1 = Number.isFinite || function isFinite(it) {
  return typeof it == 'number' && globalIsFinite(it);
};

var $$f = _export;
var numberIsFinite = numberIsFinite$1;

// `Number.isFinite` method
// https://tc39.es/ecma262/#sec-number.isfinite
$$f({ target: 'Number', stat: true }, { isFinite: numberIsFinite });

var path$b = path$s;

var _isFinite$2 = path$b.Number.isFinite;

var parent$p = _isFinite$2;

var _isFinite$1 = parent$p;

var _isFinite = _isFinite$1;

var _Number$isFinite = /*@__PURE__*/getDefaultExportFromCjs(_isFinite);

var $$e = _export;
var $some = arrayIteration.some;
var arrayMethodIsStrict$3 = arrayMethodIsStrict$6;

var STRICT_METHOD$2 = arrayMethodIsStrict$3('some');

// `Array.prototype.some` method
// https://tc39.es/ecma262/#sec-array.prototype.some
$$e({ target: 'Array', proto: true, forced: !STRICT_METHOD$2 }, {
  some: function some(callbackfn /* , thisArg */) {
    return $some(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
  }
});

var entryVirtual$4 = entryVirtual$h;

var some$3 = entryVirtual$4('Array').some;

var isPrototypeOf$4 = objectIsPrototypeOf;
var method$4 = some$3;

var ArrayPrototype$4 = Array.prototype;

var some$2 = function (it) {
  var own = it.some;
  return it === ArrayPrototype$4 || (isPrototypeOf$4(ArrayPrototype$4, it) && own === ArrayPrototype$4.some) ? method$4 : own;
};

var parent$o = some$2;

var some$1 = parent$o;

var some = some$1;

var _someInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(some);

var defineProperty$8 = {exports: {}};

var $$d = _export;
var DESCRIPTORS$3 = descriptors;
var defineProperty$7 = objectDefineProperty.f;

// `Object.defineProperty` method
// https://tc39.es/ecma262/#sec-object.defineproperty
// eslint-disable-next-line es/no-object-defineproperty -- safe
$$d({ target: 'Object', stat: true, forced: Object.defineProperty !== defineProperty$7, sham: !DESCRIPTORS$3 }, {
  defineProperty: defineProperty$7
});

var path$a = path$s;

var Object$4 = path$a.Object;

var defineProperty$6 = defineProperty$8.exports = function defineProperty(it, key, desc) {
  return Object$4.defineProperty(it, key, desc);
};

if (Object$4.defineProperty.sham) defineProperty$6.sham = true;

var definePropertyExports = defineProperty$8.exports;

var parent$n = definePropertyExports;

var defineProperty$5 = parent$n;

var parent$m = defineProperty$5;

var defineProperty$4 = parent$m;

var parent$l = defineProperty$4;

var defineProperty$3 = parent$l;

var defineProperty$2 = defineProperty$3;

var _Object$defineProperty$1 = /*@__PURE__*/getDefaultExportFromCjs(defineProperty$2);

var wellKnownSymbol$1 = wellKnownSymbol$l;
var defineProperty$1 = objectDefineProperty.f;

var METADATA = wellKnownSymbol$1('metadata');
var FunctionPrototype = Function.prototype;

// Function.prototype[@@metadata]
// https://github.com/tc39/proposal-decorator-metadata
if (FunctionPrototype[METADATA] === undefined) {
  defineProperty$1(FunctionPrototype, METADATA, {
    value: null
  });
}

var defineWellKnownSymbol$7 = wellKnownSymbolDefine;

// `Symbol.asyncDispose` well-known symbol
// https://github.com/tc39/proposal-async-explicit-resource-management
defineWellKnownSymbol$7('asyncDispose');

var defineWellKnownSymbol$6 = wellKnownSymbolDefine;

// `Symbol.dispose` well-known symbol
// https://github.com/tc39/proposal-explicit-resource-management
defineWellKnownSymbol$6('dispose');

// TODO: Remove from `core-js@4`
var defineWellKnownSymbol$5 = wellKnownSymbolDefine;

// `Symbol.metadata` well-known symbol
// https://github.com/tc39/proposal-decorators
defineWellKnownSymbol$5('metadata');

var parent$k = symbol$4;






var symbol$2 = parent$k;

var getBuiltIn$1 = getBuiltIn$b;
var uncurryThis$5 = functionUncurryThis;

var Symbol$3 = getBuiltIn$1('Symbol');
var keyFor = Symbol$3.keyFor;
var thisSymbolValue$1 = uncurryThis$5(Symbol$3.prototype.valueOf);

// `Symbol.isRegisteredSymbol` method
// https://tc39.es/proposal-symbol-predicates/#sec-symbol-isregisteredsymbol
var symbolIsRegistered = Symbol$3.isRegisteredSymbol || function isRegisteredSymbol(value) {
  try {
    return keyFor(thisSymbolValue$1(value)) !== undefined;
  } catch (error) {
    return false;
  }
};

var $$c = _export;
var isRegisteredSymbol$1 = symbolIsRegistered;

// `Symbol.isRegisteredSymbol` method
// https://tc39.es/proposal-symbol-predicates/#sec-symbol-isregisteredsymbol
$$c({ target: 'Symbol', stat: true }, {
  isRegisteredSymbol: isRegisteredSymbol$1
});

var shared = sharedExports;
var getBuiltIn = getBuiltIn$b;
var uncurryThis$4 = functionUncurryThis;
var isSymbol = isSymbol$5;
var wellKnownSymbol = wellKnownSymbol$l;

var Symbol$2 = getBuiltIn('Symbol');
var $isWellKnownSymbol = Symbol$2.isWellKnownSymbol;
var getOwnPropertyNames$4 = getBuiltIn('Object', 'getOwnPropertyNames');
var thisSymbolValue = uncurryThis$4(Symbol$2.prototype.valueOf);
var WellKnownSymbolsStore = shared('wks');

for (var i = 0, symbolKeys = getOwnPropertyNames$4(Symbol$2), symbolKeysLength = symbolKeys.length; i < symbolKeysLength; i++) {
  // some old engines throws on access to some keys like `arguments` or `caller`
  try {
    var symbolKey = symbolKeys[i];
    if (isSymbol(Symbol$2[symbolKey])) wellKnownSymbol(symbolKey);
  } catch (error) { /* empty */ }
}

// `Symbol.isWellKnownSymbol` method
// https://tc39.es/proposal-symbol-predicates/#sec-symbol-iswellknownsymbol
// We should patch it for newly added well-known symbols. If it's not required, this module just will not be injected
var symbolIsWellKnown = function isWellKnownSymbol(value) {
  if ($isWellKnownSymbol && $isWellKnownSymbol(value)) return true;
  try {
    var symbol = thisSymbolValue(value);
    for (var j = 0, keys = getOwnPropertyNames$4(WellKnownSymbolsStore), keysLength = keys.length; j < keysLength; j++) {
      // eslint-disable-next-line eqeqeq -- polyfilled symbols case
      if (WellKnownSymbolsStore[keys[j]] == symbol) return true;
    }
  } catch (error) { /* empty */ }
  return false;
};

var $$b = _export;
var isWellKnownSymbol$1 = symbolIsWellKnown;

// `Symbol.isWellKnownSymbol` method
// https://tc39.es/proposal-symbol-predicates/#sec-symbol-iswellknownsymbol
// We should patch it for newly added well-known symbols. If it's not required, this module just will not be injected
$$b({ target: 'Symbol', stat: true, forced: true }, {
  isWellKnownSymbol: isWellKnownSymbol$1
});

var defineWellKnownSymbol$4 = wellKnownSymbolDefine;

// `Symbol.matcher` well-known symbol
// https://github.com/tc39/proposal-pattern-matching
defineWellKnownSymbol$4('matcher');

var defineWellKnownSymbol$3 = wellKnownSymbolDefine;

// `Symbol.observable` well-known symbol
// https://github.com/tc39/proposal-observable
defineWellKnownSymbol$3('observable');

var $$a = _export;
var isRegisteredSymbol = symbolIsRegistered;

// `Symbol.isRegistered` method
// obsolete version of https://tc39.es/proposal-symbol-predicates/#sec-symbol-isregisteredsymbol
$$a({ target: 'Symbol', stat: true, name: 'isRegisteredSymbol' }, {
  isRegistered: isRegisteredSymbol
});

var $$9 = _export;
var isWellKnownSymbol = symbolIsWellKnown;

// `Symbol.isWellKnown` method
// obsolete version of https://tc39.es/proposal-symbol-predicates/#sec-symbol-iswellknownsymbol
// We should patch it for newly added well-known symbols. If it's not required, this module just will not be injected
$$9({ target: 'Symbol', stat: true, name: 'isWellKnownSymbol', forced: true }, {
  isWellKnown: isWellKnownSymbol
});

var defineWellKnownSymbol$2 = wellKnownSymbolDefine;

// `Symbol.metadataKey` well-known symbol
// https://github.com/tc39/proposal-decorator-metadata
defineWellKnownSymbol$2('metadataKey');

// TODO: remove from `core-js@4`
var defineWellKnownSymbol$1 = wellKnownSymbolDefine;

// `Symbol.patternMatch` well-known symbol
// https://github.com/tc39/proposal-pattern-matching
defineWellKnownSymbol$1('patternMatch');

// TODO: remove from `core-js@4`
var defineWellKnownSymbol = wellKnownSymbolDefine;

defineWellKnownSymbol('replaceAll');

var parent$j = symbol$2;




// TODO: Remove from `core-js@4`






var symbol$1 = parent$j;

var symbol = symbol$1;

var _Symbol = /*@__PURE__*/getDefaultExportFromCjs(symbol);

var WrappedWellKnownSymbolModule$1 = wellKnownSymbolWrapped;

var iterator$4 = WrappedWellKnownSymbolModule$1.f('iterator');

var parent$i = iterator$4;


var iterator$3 = parent$i;

var parent$h = iterator$3;

var iterator$2 = parent$h;

var parent$g = iterator$2;

var iterator$1 = parent$g;

var iterator = iterator$1;

var _Symbol$iterator = /*@__PURE__*/getDefaultExportFromCjs(iterator);

function _typeof(o) {
  "@babel/helpers - typeof";

  return _typeof = "function" == typeof _Symbol && "symbol" == typeof _Symbol$iterator ? function (o) {
    return typeof o;
  } : function (o) {
    return o && "function" == typeof _Symbol && o.constructor === _Symbol && o !== _Symbol.prototype ? "symbol" : typeof o;
  }, _typeof(o);
}

var WrappedWellKnownSymbolModule = wellKnownSymbolWrapped;

var toPrimitive$4 = WrappedWellKnownSymbolModule.f('toPrimitive');

var parent$f = toPrimitive$4;

var toPrimitive$3 = parent$f;

var parent$e = toPrimitive$3;

var toPrimitive$2 = parent$e;

var parent$d = toPrimitive$2;

var toPrimitive$1 = parent$d;

var toPrimitive = toPrimitive$1;

var _Symbol$toPrimitive = /*@__PURE__*/getDefaultExportFromCjs(toPrimitive);

function _toPrimitive(input, hint) {
  if (_typeof(input) !== "object" || input === null) return input;
  var prim = input[_Symbol$toPrimitive];
  if (prim !== undefined) {
    var res = prim.call(input, hint || "default");
    if (_typeof(res) !== "object") return res;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return (hint === "string" ? String : Number)(input);
}

function _toPropertyKey(arg) {
  var key = _toPrimitive(arg, "string");
  return _typeof(key) === "symbol" ? key : String(key);
}

function _defineProperty(obj, key, value) {
  key = _toPropertyKey(key);
  if (key in obj) {
    _Object$defineProperty$1(obj, key, {
      value: value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }
  return obj;
}

var global$3 = global$n;
var fails$4 = fails$u;
var uncurryThis$3 = functionUncurryThis;
var toString$1 = toString$a;
var trim = stringTrim.trim;
var whitespaces = whitespaces$3;

var charAt = uncurryThis$3(''.charAt);
var $parseFloat$1 = global$3.parseFloat;
var Symbol$1 = global$3.Symbol;
var ITERATOR = Symbol$1 && Symbol$1.iterator;
var FORCED$4 = 1 / $parseFloat$1(whitespaces + '-0') !== -Infinity
  // MS Edge 18- broken with boxed symbols
  || (ITERATOR && !fails$4(function () { $parseFloat$1(Object(ITERATOR)); }));

// `parseFloat` method
// https://tc39.es/ecma262/#sec-parsefloat-string
var numberParseFloat = FORCED$4 ? function parseFloat(string) {
  var trimmedString = trim(toString$1(string));
  var result = $parseFloat$1(trimmedString);
  return result === 0 && charAt(trimmedString, 0) === '-' ? -0 : result;
} : $parseFloat$1;

var $$8 = _export;
var $parseFloat = numberParseFloat;

// `parseFloat` method
// https://tc39.es/ecma262/#sec-parsefloat-string
$$8({ global: true, forced: parseFloat !== $parseFloat }, {
  parseFloat: $parseFloat
});

var path$9 = path$s;

var _parseFloat$3 = path$9.parseFloat;

var parent$c = _parseFloat$3;

var _parseFloat$2 = parent$c;

var _parseFloat = _parseFloat$2;

var _parseFloat$1 = /*@__PURE__*/getDefaultExportFromCjs(_parseFloat);

var $$7 = _export;
var fails$3 = fails$u;
var getOwnPropertyNames$3 = objectGetOwnPropertyNamesExternal.f;

// eslint-disable-next-line es/no-object-getownpropertynames -- required for testing
var FAILS_ON_PRIMITIVES = fails$3(function () { return !Object.getOwnPropertyNames(1); });

// `Object.getOwnPropertyNames` method
// https://tc39.es/ecma262/#sec-object.getownpropertynames
$$7({ target: 'Object', stat: true, forced: FAILS_ON_PRIMITIVES }, {
  getOwnPropertyNames: getOwnPropertyNames$3
});

var path$8 = path$s;

var Object$3 = path$8.Object;

var getOwnPropertyNames$2 = function getOwnPropertyNames(it) {
  return Object$3.getOwnPropertyNames(it);
};

var parent$b = getOwnPropertyNames$2;

var getOwnPropertyNames$1 = parent$b;

var getOwnPropertyNames = getOwnPropertyNames$1;

var _Object$getOwnPropertyNames = /*@__PURE__*/getDefaultExportFromCjs(getOwnPropertyNames);

var path$7 = path$s;

var getOwnPropertySymbols$2 = path$7.Object.getOwnPropertySymbols;

var parent$a = getOwnPropertySymbols$2;

var getOwnPropertySymbols$1 = parent$a;

var getOwnPropertySymbols = getOwnPropertySymbols$1;

var _Object$getOwnPropertySymbols = /*@__PURE__*/getDefaultExportFromCjs(getOwnPropertySymbols);

var getOwnPropertyDescriptor$3 = {exports: {}};

var $$6 = _export;
var fails$2 = fails$u;
var toIndexedObject$1 = toIndexedObject$a;
var nativeGetOwnPropertyDescriptor = objectGetOwnPropertyDescriptor.f;
var DESCRIPTORS$2 = descriptors;

var FORCED$3 = !DESCRIPTORS$2 || fails$2(function () { nativeGetOwnPropertyDescriptor(1); });

// `Object.getOwnPropertyDescriptor` method
// https://tc39.es/ecma262/#sec-object.getownpropertydescriptor
$$6({ target: 'Object', stat: true, forced: FORCED$3, sham: !DESCRIPTORS$2 }, {
  getOwnPropertyDescriptor: function getOwnPropertyDescriptor(it, key) {
    return nativeGetOwnPropertyDescriptor(toIndexedObject$1(it), key);
  }
});

var path$6 = path$s;

var Object$2 = path$6.Object;

var getOwnPropertyDescriptor$2 = getOwnPropertyDescriptor$3.exports = function getOwnPropertyDescriptor(it, key) {
  return Object$2.getOwnPropertyDescriptor(it, key);
};

if (Object$2.getOwnPropertyDescriptor.sham) getOwnPropertyDescriptor$2.sham = true;

var getOwnPropertyDescriptorExports = getOwnPropertyDescriptor$3.exports;

var parent$9 = getOwnPropertyDescriptorExports;

var getOwnPropertyDescriptor$1 = parent$9;

var getOwnPropertyDescriptor = getOwnPropertyDescriptor$1;

var _Object$getOwnPropertyDescriptor = /*@__PURE__*/getDefaultExportFromCjs(getOwnPropertyDescriptor);

var $$5 = _export;
var DESCRIPTORS$1 = descriptors;
var ownKeys$4 = ownKeys$5;
var toIndexedObject = toIndexedObject$a;
var getOwnPropertyDescriptorModule = objectGetOwnPropertyDescriptor;
var createProperty = createProperty$5;

// `Object.getOwnPropertyDescriptors` method
// https://tc39.es/ecma262/#sec-object.getownpropertydescriptors
$$5({ target: 'Object', stat: true, sham: !DESCRIPTORS$1 }, {
  getOwnPropertyDescriptors: function getOwnPropertyDescriptors(object) {
    var O = toIndexedObject(object);
    var getOwnPropertyDescriptor = getOwnPropertyDescriptorModule.f;
    var keys = ownKeys$4(O);
    var result = {};
    var index = 0;
    var key, descriptor;
    while (keys.length > index) {
      descriptor = getOwnPropertyDescriptor(O, key = keys[index++]);
      if (descriptor !== undefined) createProperty(result, key, descriptor);
    }
    return result;
  }
});

var path$5 = path$s;

var getOwnPropertyDescriptors$2 = path$5.Object.getOwnPropertyDescriptors;

var parent$8 = getOwnPropertyDescriptors$2;

var getOwnPropertyDescriptors$1 = parent$8;

var getOwnPropertyDescriptors = getOwnPropertyDescriptors$1;

var _Object$getOwnPropertyDescriptors = /*@__PURE__*/getDefaultExportFromCjs(getOwnPropertyDescriptors);

var defineProperties$4 = {exports: {}};

var $$4 = _export;
var DESCRIPTORS = descriptors;
var defineProperties$3 = objectDefineProperties.f;

// `Object.defineProperties` method
// https://tc39.es/ecma262/#sec-object.defineproperties
// eslint-disable-next-line es/no-object-defineproperties -- safe
$$4({ target: 'Object', stat: true, forced: Object.defineProperties !== defineProperties$3, sham: !DESCRIPTORS }, {
  defineProperties: defineProperties$3
});

var path$4 = path$s;

var Object$1 = path$4.Object;

var defineProperties$2 = defineProperties$4.exports = function defineProperties(T, D) {
  return Object$1.defineProperties(T, D);
};

if (Object$1.defineProperties.sham) defineProperties$2.sham = true;

var definePropertiesExports = defineProperties$4.exports;

var parent$7 = definePropertiesExports;

var defineProperties$1 = parent$7;

var defineProperties = defineProperties$1;

var _Object$defineProperties = /*@__PURE__*/getDefaultExportFromCjs(defineProperties);

var defineProperty = defineProperty$5;

var _Object$defineProperty = /*@__PURE__*/getDefaultExportFromCjs(defineProperty);

/**
 * Helper functions for components
 */

/**
 * Determine values to use for (sub)options of 'chosen'.
 *
 * This option is either a boolean or an object whose values should be examined further.
 * The relevant structures are:
 *
 * - chosen: <boolean value>
 * - chosen: { subOption: <boolean or function> }
 *
 * Where subOption is 'node', 'edge' or 'label'.
 *
 * The intention of this method appears to be to set a specific priority to the options;
 * Since most properties are either bridged or merged into the local options objects, there
 * is not much point in handling them separately.
 * TODO: examine if 'most' in previous sentence can be replaced with 'all'. In that case, we
 * should be able to get rid of this method.
 * @param {string}  subOption  option within object 'chosen' to consider; either 'node', 'edge' or 'label'
 * @param {object}  pile       array of options objects to consider
 * @returns {boolean | Function}  value for passed subOption of 'chosen' to use
 */
function choosify(subOption, pile) {
  // allowed values for subOption
  const allowed = ["node", "edge", "label"];
  let value = true;
  const chosen = topMost(pile, "chosen");
  if (typeof chosen === "boolean") {
    value = chosen;
  } else if (typeof chosen === "object") {
    if (_indexOfInstanceProperty(allowed).call(allowed, subOption) === -1) {
      throw new Error("choosify: subOption '" + subOption + "' should be one of " + "'" + allowed.join("', '") + "'");
    }
    const chosenEdge = topMost(pile, ["chosen", subOption]);
    if (typeof chosenEdge === "boolean" || typeof chosenEdge === "function") {
      value = chosenEdge;
    }
  }
  return value;
}

/**
 * Check if the point falls within the given rectangle.
 * @param {rect} rect
 * @param {point} point
 * @param {rotationPoint} [rotationPoint] if specified, the rotation that applies to the rectangle.
 * @returns {boolean}  true if point within rectangle, false otherwise
 */
function pointInRect(rect, point, rotationPoint) {
  if (rect.width <= 0 || rect.height <= 0) {
    return false; // early out
  }

  if (rotationPoint !== undefined) {
    // Rotate the point the same amount as the rectangle
    const tmp = {
      x: point.x - rotationPoint.x,
      y: point.y - rotationPoint.y
    };
    if (rotationPoint.angle !== 0) {
      // In order to get the coordinates the same, you need to
      // rotate in the reverse direction
      const angle = -rotationPoint.angle;
      const tmp2 = {
        x: Math.cos(angle) * tmp.x - Math.sin(angle) * tmp.y,
        y: Math.sin(angle) * tmp.x + Math.cos(angle) * tmp.y
      };
      point = tmp2;
    } else {
      point = tmp;
    }

    // Note that if a rotation is specified, the rectangle coordinates
    // are **not* the full canvas coordinates. They are relative to the
    // rotationPoint. Hence, the point coordinates need not be translated
    // back in this case.
  }

  const right = rect.x + rect.width;
  const bottom = rect.y + rect.width;
  return rect.left < point.x && right > point.x && rect.top < point.y && bottom > point.y;
}

/**
 * Check if given value is acceptable as a label text.
 * @param {*} text value to check; can be anything at this point
 * @returns {boolean} true if valid label value, false otherwise
 */
function isValidLabel(text) {
  // Note that this is quite strict: types that *might* be converted to string are disallowed
  return typeof text === "string" && text !== "";
}

/**
 * Returns x, y of self reference circle based on provided angle
 * @param {object} ctx
 * @param {number} angle
 * @param {number} radius
 * @param {VisNode} node
 * @returns {object} x and y coordinates
 */
function getSelfRefCoordinates(ctx, angle, radius, node) {
  let x = node.x;
  let y = node.y;
  if (typeof node.distanceToBorder === "function") {
    //calculating opposite and adjacent
    //distaneToBorder becomes Hypotenuse.
    //Formulas sin(a) = Opposite / Hypotenuse and cos(a) = Adjacent / Hypotenuse
    const toBorderDist = node.distanceToBorder(ctx, angle);
    const yFromNodeCenter = Math.sin(angle) * toBorderDist;
    const xFromNodeCenter = Math.cos(angle) * toBorderDist;
    //xFromNodeCenter is basically x and if xFromNodeCenter equals to the distance to border then it means
    //that y does not need calculation because it is equal node.height / 2 or node.y
    //same thing with yFromNodeCenter and if yFromNodeCenter equals to the distance to border then it means
    //that x is equal node.width / 2 or node.x
    if (xFromNodeCenter === toBorderDist) {
      x += toBorderDist;
      y = node.y;
    } else if (yFromNodeCenter === toBorderDist) {
      x = node.x;
      y -= toBorderDist;
    } else {
      x += xFromNodeCenter;
      y -= yFromNodeCenter;
    }
  } else if (node.shape.width > node.shape.height) {
    x = node.x + node.shape.width * 0.5;
    y = node.y - radius;
  } else {
    x = node.x + radius;
    y = node.y - node.shape.height * 0.5;
  }
  return {
    x,
    y
  };
}

var entryVirtual$3 = entryVirtual$h;

var values$3 = entryVirtual$3('Array').values;

var parent$6 = values$3;

var values$2 = parent$6;

var classof$1 = classof$c;
var hasOwn$1 = hasOwnProperty_1;
var isPrototypeOf$3 = objectIsPrototypeOf;
var method$3 = values$2;

var ArrayPrototype$3 = Array.prototype;

var DOMIterables = {
  DOMTokenList: true,
  NodeList: true
};

var values$1 = function (it) {
  var own = it.values;
  return it === ArrayPrototype$3 || (isPrototypeOf$3(ArrayPrototype$3, it) && own === ArrayPrototype$3.values)
    || hasOwn$1(DOMIterables, classof$1(it)) ? method$3 : own;
};

var values = values$1;

var _valuesInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(values);

/**
 * Callback to determine text dimensions, using the parent label settings.
 * @callback MeasureText
 * @param {text} text
 * @param {text} mod
 * @returns {object} { width, values} width in pixels and font attributes
 */

/**
 * Helper class for Label which collects results of splitting labels into lines and blocks.
 * @private
 */
class LabelAccumulator {
  /**
   * @param {MeasureText} measureText
   */
  constructor(measureText) {
    this.measureText = measureText;
    this.current = 0;
    this.width = 0;
    this.height = 0;
    this.lines = [];
  }

  /**
   * Append given text to the given line.
   * @param {number}  l    index of line to add to
   * @param {string}  text string to append to line
   * @param {'bold'|'ital'|'boldital'|'mono'|'normal'} [mod]
   * @private
   */
  _add(l, text) {
    let mod = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : "normal";
    if (this.lines[l] === undefined) {
      this.lines[l] = {
        width: 0,
        height: 0,
        blocks: []
      };
    }

    // We still need to set a block for undefined and empty texts, hence return at this point
    // This is necessary because we don't know at this point if we're at the
    // start of an empty line or not.
    // To compensate, empty blocks are removed in `finalize()`.
    //
    // Empty strings should still have a height
    let tmpText = text;
    if (text === undefined || text === "") tmpText = " ";

    // Determine width and get the font properties
    const result = this.measureText(tmpText, mod);
    const block = _Object$assign({}, _valuesInstanceProperty(result));
    block.text = text;
    block.width = result.width;
    block.mod = mod;
    if (text === undefined || text === "") {
      block.width = 0;
    }
    this.lines[l].blocks.push(block);

    // Update the line width. We need this for determining if a string goes over max width
    this.lines[l].width += block.width;
  }

  /**
   * Returns the width in pixels of the current line.
   * @returns {number}
   */
  curWidth() {
    const line = this.lines[this.current];
    if (line === undefined) return 0;
    return line.width;
  }

  /**
   * Add text in block to current line
   * @param {string} text
   * @param {'bold'|'ital'|'boldital'|'mono'|'normal'} [mod]
   */
  append(text) {
    let mod = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : "normal";
    this._add(this.current, text, mod);
  }

  /**
   * Add text in block to current line and start a new line
   * @param {string} text
   * @param {'bold'|'ital'|'boldital'|'mono'|'normal'} [mod]
   */
  newLine(text) {
    let mod = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : "normal";
    this._add(this.current, text, mod);
    this.current++;
  }

  /**
   * Determine and set the heights of all the lines currently contained in this instance
   *
   * Note that width has already been set.
   * @private
   */
  determineLineHeights() {
    for (let k = 0; k < this.lines.length; k++) {
      const line = this.lines[k];

      // Looking for max height of blocks in line
      let height = 0;
      if (line.blocks !== undefined) {
        // Can happen if text contains e.g. '\n '
        for (let l = 0; l < line.blocks.length; l++) {
          const block = line.blocks[l];
          if (height < block.height) {
            height = block.height;
          }
        }
      }
      line.height = height;
    }
  }

  /**
   * Determine the full size of the label text, as determined by current lines and blocks
   * @private
   */
  determineLabelSize() {
    let width = 0;
    let height = 0;
    for (let k = 0; k < this.lines.length; k++) {
      const line = this.lines[k];
      if (line.width > width) {
        width = line.width;
      }
      height += line.height;
    }
    this.width = width;
    this.height = height;
  }

  /**
   * Remove all empty blocks and empty lines we don't need
   *
   * This must be done after the width/height determination,
   * so that these are set properly for processing here.
   * @returns {Array<Line>} Lines with empty blocks (and some empty lines) removed
   * @private
   */
  removeEmptyBlocks() {
    const tmpLines = [];
    for (let k = 0; k < this.lines.length; k++) {
      const line = this.lines[k];

      // Note: an empty line in between text has width zero but is still relevant to layout.
      // So we can't use width for testing empty line here
      if (line.blocks.length === 0) continue;

      // Discard final empty line always
      if (k === this.lines.length - 1) {
        if (line.width === 0) continue;
      }
      const tmpLine = {};
      _Object$assign(tmpLine, line);
      tmpLine.blocks = [];
      let firstEmptyBlock;
      const tmpBlocks = [];
      for (let l = 0; l < line.blocks.length; l++) {
        const block = line.blocks[l];
        if (block.width !== 0) {
          tmpBlocks.push(block);
        } else {
          if (firstEmptyBlock === undefined) {
            firstEmptyBlock = block;
          }
        }
      }

      // Ensure that there is *some* text present
      if (tmpBlocks.length === 0 && firstEmptyBlock !== undefined) {
        tmpBlocks.push(firstEmptyBlock);
      }
      tmpLine.blocks = tmpBlocks;
      tmpLines.push(tmpLine);
    }
    return tmpLines;
  }

  /**
   * Set the sizes for all lines and the whole thing.
   * @returns {{width: (number|*), height: (number|*), lines: Array}}
   */
  finalize() {
    //console.log(JSON.stringify(this.lines, null, 2));

    this.determineLineHeights();
    this.determineLabelSize();
    const tmpLines = this.removeEmptyBlocks();

    // Return a simple hash object for further processing.
    return {
      width: this.width,
      height: this.height,
      lines: tmpLines
    };
  }
}

// Hash of prepared regexp's for tags
const tagPattern = {
  // HTML
  "<b>": /<b>/,
  "<i>": /<i>/,
  "<code>": /<code>/,
  "</b>": /<\/b>/,
  "</i>": /<\/i>/,
  "</code>": /<\/code>/,
  // Markdown
  "*": /\*/,
  // bold
  _: /_/,
  // ital
  "`": /`/,
  // mono
  afterBold: /[^*]/,
  afterItal: /[^_]/,
  afterMono: /[^`]/
};

/**
 * Internal helper class for parsing the markup tags for HTML and Markdown.
 *
 * NOTE: Sequences of tabs and spaces are reduced to single space.
 *       Scan usage of `this.spacing` within method
 */
class MarkupAccumulator {
  /**
   * Create an instance
   * @param {string} text  text to parse for markup
   */
  constructor(text) {
    this.text = text;
    this.bold = false;
    this.ital = false;
    this.mono = false;
    this.spacing = false;
    this.position = 0;
    this.buffer = "";
    this.modStack = [];
    this.blocks = [];
  }

  /**
   * Return the mod label currently on the top of the stack
   * @returns {string}  label of topmost mod
   * @private
   */
  mod() {
    return this.modStack.length === 0 ? "normal" : this.modStack[0];
  }

  /**
   * Return the mod label currently active
   * @returns {string}  label of active mod
   * @private
   */
  modName() {
    if (this.modStack.length === 0) return "normal";else if (this.modStack[0] === "mono") return "mono";else {
      if (this.bold && this.ital) {
        return "boldital";
      } else if (this.bold) {
        return "bold";
      } else if (this.ital) {
        return "ital";
      }
    }
  }

  /**
   * @private
   */
  emitBlock() {
    if (this.spacing) {
      this.add(" ");
      this.spacing = false;
    }
    if (this.buffer.length > 0) {
      this.blocks.push({
        text: this.buffer,
        mod: this.modName()
      });
      this.buffer = "";
    }
  }

  /**
   * Output text to buffer
   * @param {string} text  text to add
   * @private
   */
  add(text) {
    if (text === " ") {
      this.spacing = true;
    }
    if (this.spacing) {
      this.buffer += " ";
      this.spacing = false;
    }
    if (text != " ") {
      this.buffer += text;
    }
  }

  /**
   * Handle parsing of whitespace
   * @param {string} ch  the character to check
   * @returns {boolean} true if the character was processed as whitespace, false otherwise
   */
  parseWS(ch) {
    if (/[ \t]/.test(ch)) {
      if (!this.mono) {
        this.spacing = true;
      } else {
        this.add(ch);
      }
      return true;
    }
    return false;
  }

  /**
   * @param {string} tagName  label for block type to set
   * @private
   */
  setTag(tagName) {
    this.emitBlock();
    this[tagName] = true;
    this.modStack.unshift(tagName);
  }

  /**
   * @param {string} tagName  label for block type to unset
   * @private
   */
  unsetTag(tagName) {
    this.emitBlock();
    this[tagName] = false;
    this.modStack.shift();
  }

  /**
   * @param {string} tagName label for block type we are currently processing
   * @param {string|RegExp} tag string to match in text
   * @returns {boolean} true if the tag was processed, false otherwise
   */
  parseStartTag(tagName, tag) {
    // Note: if 'mono' passed as tagName, there is a double check here. This is OK
    if (!this.mono && !this[tagName] && this.match(tag)) {
      this.setTag(tagName);
      return true;
    }
    return false;
  }

  /**
   * @param {string|RegExp} tag
   * @param {number} [advance] if set, advance current position in text
   * @returns {boolean} true if match at given position, false otherwise
   * @private
   */
  match(tag) {
    let advance = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
    const [regExp, length] = this.prepareRegExp(tag);
    const matched = regExp.test(this.text.substr(this.position, length));
    if (matched && advance) {
      this.position += length - 1;
    }
    return matched;
  }

  /**
   * @param {string} tagName label for block type we are currently processing
   * @param {string|RegExp} tag string to match in text
   * @param {RegExp} [nextTag] regular expression to match for characters *following* the current tag
   * @returns {boolean} true if the tag was processed, false otherwise
   */
  parseEndTag(tagName, tag, nextTag) {
    let checkTag = this.mod() === tagName;
    if (tagName === "mono") {
      // special handling for 'mono'
      checkTag = checkTag && this.mono;
    } else {
      checkTag = checkTag && !this.mono;
    }
    if (checkTag && this.match(tag)) {
      if (nextTag !== undefined) {
        // Purpose of the following match is to prevent a direct unset/set of a given tag
        // E.g. '*bold **still bold*' => '*bold still bold*'
        if (this.position === this.text.length - 1 || this.match(nextTag, false)) {
          this.unsetTag(tagName);
        }
      } else {
        this.unsetTag(tagName);
      }
      return true;
    }
    return false;
  }

  /**
   * @param {string|RegExp} tag  string to match in text
   * @param {value} value  string to replace tag with, if found at current position
   * @returns {boolean} true if the tag was processed, false otherwise
   */
  replace(tag, value) {
    if (this.match(tag)) {
      this.add(value);
      this.position += length - 1;
      return true;
    }
    return false;
  }

  /**
   * Create a regular expression for the tag if it isn't already one.
   *
   * The return value is an array `[RegExp, number]`, with exactly two value, where:
   * - RegExp is the regular expression to use
   * - number is the lenth of the input string to match
   * @param {string|RegExp} tag  string to match in text
   * @returns {Array}  regular expression to use and length of input string to match
   * @private
   */
  prepareRegExp(tag) {
    let length;
    let regExp;
    if (tag instanceof RegExp) {
      regExp = tag;
      length = 1; // ASSUMPTION: regexp only tests one character
    } else {
      // use prepared regexp if present
      const prepared = tagPattern[tag];
      if (prepared !== undefined) {
        regExp = prepared;
      } else {
        regExp = new RegExp(tag);
      }
      length = tag.length;
    }
    return [regExp, length];
  }
}

/**
 * Helper class for Label which explodes the label text into lines and blocks within lines
 * @private
 */
class LabelSplitter {
  /**
   * @param {CanvasRenderingContext2D} ctx Canvas rendering context
   * @param {Label} parent reference to the Label instance using current instance
   * @param {boolean} selected
   * @param {boolean} hover
   */
  constructor(ctx, parent, selected, hover) {
    this.ctx = ctx;
    this.parent = parent;
    this.selected = selected;
    this.hover = hover;

    /**
     * Callback to determine text width; passed to LabelAccumulator instance
     * @param  {string} text string to determine width of
     * @param  {string} mod  font type to use for this text
     * @returns {object} { width, values} width in pixels and font attributes
     */
    const textWidth = (text, mod) => {
      if (text === undefined) return 0;

      // TODO: This can be done more efficiently with caching
      // This will set the ctx.font correctly, depending on selected/hover and mod - so that ctx.measureText() will be accurate.
      const values = this.parent.getFormattingValues(ctx, selected, hover, mod);
      let width = 0;
      if (text !== "") {
        const measure = this.ctx.measureText(text);
        width = measure.width;
      }
      return {
        width,
        values: values
      };
    };
    this.lines = new LabelAccumulator(textWidth);
  }

  /**
   * Split passed text of a label into lines and blocks.
   *
   * # NOTE
   *
   * The handling of spacing is option dependent:
   *
   * - if `font.multi : false`, all spaces are retained
   * - if `font.multi : true`, every sequence of spaces is compressed to a single space
   *
   * This might not be the best way to do it, but this is as it has been working till now.
   * In order not to break existing functionality, for the time being this behaviour will
   * be retained in any code changes.
   * @param {string} text  text to split
   * @returns {Array<line>}
   */
  process(text) {
    if (!isValidLabel(text)) {
      return this.lines.finalize();
    }
    const font = this.parent.fontOptions;

    // Normalize the end-of-line's to a single representation - order important
    text = text.replace(/\r\n/g, "\n"); // Dos EOL's
    text = text.replace(/\r/g, "\n"); // Mac EOL's

    // Note that at this point, there can be no \r's in the text.
    // This is used later on splitStringIntoLines() to split multifont texts.

    const nlLines = String(text).split("\n");
    const lineCount = nlLines.length;
    if (font.multi) {
      // Multi-font case: styling tags active
      for (let i = 0; i < lineCount; i++) {
        const blocks = this.splitBlocks(nlLines[i], font.multi);
        // Post: Sequences of tabs and spaces are reduced to single space

        if (blocks === undefined) continue;
        if (blocks.length === 0) {
          this.lines.newLine("");
          continue;
        }
        if (font.maxWdt > 0) {
          // widthConstraint.maximum defined
          //console.log('Running widthConstraint multi, max: ' + this.fontOptions.maxWdt);
          for (let j = 0; j < blocks.length; j++) {
            const mod = blocks[j].mod;
            const text = blocks[j].text;
            this.splitStringIntoLines(text, mod, true);
          }
        } else {
          // widthConstraint.maximum NOT defined
          for (let j = 0; j < blocks.length; j++) {
            const mod = blocks[j].mod;
            const text = blocks[j].text;
            this.lines.append(text, mod);
          }
        }
        this.lines.newLine();
      }
    } else {
      // Single-font case
      if (font.maxWdt > 0) {
        // widthConstraint.maximum defined
        // console.log('Running widthConstraint normal, max: ' + this.fontOptions.maxWdt);
        for (let i = 0; i < lineCount; i++) {
          this.splitStringIntoLines(nlLines[i]);
        }
      } else {
        // widthConstraint.maximum NOT defined
        for (let i = 0; i < lineCount; i++) {
          this.lines.newLine(nlLines[i]);
        }
      }
    }
    return this.lines.finalize();
  }

  /**
   * normalize the markup system
   * @param {boolean|'md'|'markdown'|'html'} markupSystem
   * @returns {string}
   */
  decodeMarkupSystem(markupSystem) {
    let system = "none";
    if (markupSystem === "markdown" || markupSystem === "md") {
      system = "markdown";
    } else if (markupSystem === true || markupSystem === "html") {
      system = "html";
    }
    return system;
  }

  /**
   *
   * @param {string} text
   * @returns {Array}
   */
  splitHtmlBlocks(text) {
    const s = new MarkupAccumulator(text);
    const parseEntities = ch => {
      if (/&/.test(ch)) {
        const parsed = s.replace(s.text, "&lt;", "<") || s.replace(s.text, "&amp;", "&");
        if (!parsed) {
          s.add("&");
        }
        return true;
      }
      return false;
    };
    while (s.position < s.text.length) {
      const ch = s.text.charAt(s.position);
      const parsed = s.parseWS(ch) || /</.test(ch) && (s.parseStartTag("bold", "<b>") || s.parseStartTag("ital", "<i>") || s.parseStartTag("mono", "<code>") || s.parseEndTag("bold", "</b>") || s.parseEndTag("ital", "</i>") || s.parseEndTag("mono", "</code>")) || parseEntities(ch);
      if (!parsed) {
        s.add(ch);
      }
      s.position++;
    }
    s.emitBlock();
    return s.blocks;
  }

  /**
   *
   * @param {string} text
   * @returns {Array}
   */
  splitMarkdownBlocks(text) {
    const s = new MarkupAccumulator(text);
    let beginable = true;
    const parseOverride = ch => {
      if (/\\/.test(ch)) {
        if (s.position < this.text.length + 1) {
          s.position++;
          ch = this.text.charAt(s.position);
          if (/ \t/.test(ch)) {
            s.spacing = true;
          } else {
            s.add(ch);
            beginable = false;
          }
        }
        return true;
      }
      return false;
    };
    while (s.position < s.text.length) {
      const ch = s.text.charAt(s.position);
      const parsed = s.parseWS(ch) || parseOverride(ch) || (beginable || s.spacing) && (s.parseStartTag("bold", "*") || s.parseStartTag("ital", "_") || s.parseStartTag("mono", "`")) || s.parseEndTag("bold", "*", "afterBold") || s.parseEndTag("ital", "_", "afterItal") || s.parseEndTag("mono", "`", "afterMono");
      if (!parsed) {
        s.add(ch);
        beginable = false;
      }
      s.position++;
    }
    s.emitBlock();
    return s.blocks;
  }

  /**
   * Explodes a piece of text into single-font blocks using a given markup
   * @param {string} text
   * @param {boolean|'md'|'markdown'|'html'} markupSystem
   * @returns {Array.<{text: string, mod: string}>}
   * @private
   */
  splitBlocks(text, markupSystem) {
    const system = this.decodeMarkupSystem(markupSystem);
    if (system === "none") {
      return [{
        text: text,
        mod: "normal"
      }];
    } else if (system === "markdown") {
      return this.splitMarkdownBlocks(text);
    } else if (system === "html") {
      return this.splitHtmlBlocks(text);
    }
  }

  /**
   * @param {string} text
   * @returns {boolean} true if text length over the current max with
   * @private
   */
  overMaxWidth(text) {
    const width = this.ctx.measureText(text).width;
    return this.lines.curWidth() + width > this.parent.fontOptions.maxWdt;
  }

  /**
   * Determine the longest part of the sentence which still fits in the
   * current max width.
   * @param {Array} words  Array of strings signifying a text lines
   * @returns {number}      index of first item in string making string go over max
   * @private
   */
  getLongestFit(words) {
    let text = "";
    let w = 0;
    while (w < words.length) {
      const pre = text === "" ? "" : " ";
      const newText = text + pre + words[w];
      if (this.overMaxWidth(newText)) break;
      text = newText;
      w++;
    }
    return w;
  }

  /**
   * Determine the longest part of the string which still fits in the
   * current max width.
   * @param {Array} words Array of strings signifying a text lines
   * @returns {number} index of first item in string making string go over max
   */
  getLongestFitWord(words) {
    let w = 0;
    while (w < words.length) {
      if (this.overMaxWidth(_sliceInstanceProperty(words).call(words, 0, w))) break;
      w++;
    }
    return w;
  }

  /**
   * Split the passed text into lines, according to width constraint (if any).
   *
   * The method assumes that the input string is a single line, i.e. without lines break.
   *
   * This method retains spaces, if still present (case `font.multi: false`).
   * A space which falls on an internal line break, will be replaced by a newline.
   * There is no special handling of tabs; these go along with the flow.
   * @param {string} str
   * @param {string} [mod]
   * @param {boolean} [appendLast]
   * @private
   */
  splitStringIntoLines(str) {
    let mod = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : "normal";
    let appendLast = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
    // Set the canvas context font, based upon the current selected/hover state
    // and the provided mod, so the text measurement performed by getLongestFit
    // will be accurate - and not just use the font of whoever last used the canvas.
    this.parent.getFormattingValues(this.ctx, this.selected, this.hover, mod);

    // Still-present spaces are relevant, retain them
    str = str.replace(/^( +)/g, "$1\r");
    str = str.replace(/([^\r][^ ]*)( +)/g, "$1\r$2\r");
    let words = str.split("\r");
    while (words.length > 0) {
      let w = this.getLongestFit(words);
      if (w === 0) {
        // Special case: the first word is already larger than the max width.
        const word = words[0];

        // Break the word to the largest part that fits the line
        const x = this.getLongestFitWord(word);
        this.lines.newLine(_sliceInstanceProperty(word).call(word, 0, x), mod);

        // Adjust the word, so that the rest will be done next iteration
        words[0] = _sliceInstanceProperty(word).call(word, x);
      } else {
        // skip any space that is replaced by a newline
        let newW = w;
        if (words[w - 1] === " ") {
          w--;
        } else if (words[newW] === " ") {
          newW++;
        }
        const text = _sliceInstanceProperty(words).call(words, 0, w).join("");
        if (w == words.length && appendLast) {
          this.lines.append(text, mod);
        } else {
          this.lines.newLine(text, mod);
        }

        // Adjust the word, so that the rest will be done next iteration
        words = _sliceInstanceProperty(words).call(words, newW);
      }
    }
  }
}

/**
 * List of special styles for multi-fonts
 * @private
 */
const multiFontStyle = ["bold", "ital", "boldital", "mono"];

/**
 * A Label to be used for Nodes or Edges.
 */
class Label {
  /**
   * @param {object} body
   * @param {object} options
   * @param {boolean} [edgelabel]
   */
  constructor(body, options) {
    let edgelabel = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
    this.body = body;
    this.pointToSelf = false;
    this.baseSize = undefined;
    this.fontOptions = {}; // instance variable containing the *instance-local* font options
    this.setOptions(options);
    this.size = {
      top: 0,
      left: 0,
      width: 0,
      height: 0,
      yLine: 0
    };
    this.isEdgeLabel = edgelabel;
  }

  /**
   * @param {object} options the options of the parent Node-instance
   */
  setOptions(options) {
    this.elementOptions = options; // Reference to the options of the parent Node-instance

    this.initFontOptions(options.font);
    if (isValidLabel(options.label)) {
      this.labelDirty = true;
    } else {
      // Bad label! Change the option value to prevent bad stuff happening
      options.label = undefined;
    }
    if (options.font !== undefined && options.font !== null) {
      // font options can be deleted at various levels
      if (typeof options.font === "string") {
        this.baseSize = this.fontOptions.size;
      } else if (typeof options.font === "object") {
        const size = options.font.size;
        if (size !== undefined) {
          this.baseSize = size;
        }
      }
    }
  }

  /**
   * Init the font Options structure.
   *
   * Member fontOptions serves as an accumulator for the current font options.
   * As such, it needs to be completely separated from the node options.
   * @param {object} newFontOptions the new font options to process
   * @private
   */
  initFontOptions(newFontOptions) {
    // Prepare the multi-font option objects.
    // These will be filled in propagateFonts(), if required
    forEach$1(multiFontStyle, style => {
      this.fontOptions[style] = {};
    });

    // Handle shorthand option, if present
    if (Label.parseFontString(this.fontOptions, newFontOptions)) {
      this.fontOptions.vadjust = 0;
      return;
    }

    // Copy over the non-multifont options, if specified
    forEach$1(newFontOptions, (prop, n) => {
      if (prop !== undefined && prop !== null && typeof prop !== "object") {
        this.fontOptions[n] = prop;
      }
    });
  }

  /**
   * If in-variable is a string, parse it as a font specifier.
   *
   * Note that following is not done here and have to be done after the call:
   * - Not all font options are set (vadjust, mod)
   * @param {object} outOptions  out-parameter, object in which to store the parse results (if any)
   * @param {object} inOptions  font options to parse
   * @returns {boolean} true if font parsed as string, false otherwise
   * @static
   */
  static parseFontString(outOptions, inOptions) {
    if (!inOptions || typeof inOptions !== "string") return false;
    const newOptionsArray = inOptions.split(" ");
    outOptions.size = +newOptionsArray[0].replace("px", "");
    outOptions.face = newOptionsArray[1];
    outOptions.color = newOptionsArray[2];
    return true;
  }

  /**
   * Set the width and height constraints based on 'nearest' value
   * @param {Array} pile array of option objects to consider
   * @returns {object} the actual constraint values to use
   * @private
   */
  constrain(pile) {
    // NOTE: constrainWidth and  constrainHeight never set!
    // NOTE: for edge labels, only 'maxWdt' set
    // Node labels can set all the fields
    const fontOptions = {
      constrainWidth: false,
      maxWdt: -1,
      minWdt: -1,
      constrainHeight: false,
      minHgt: -1,
      valign: "middle"
    };
    const widthConstraint = topMost(pile, "widthConstraint");
    if (typeof widthConstraint === "number") {
      fontOptions.maxWdt = Number(widthConstraint);
      fontOptions.minWdt = Number(widthConstraint);
    } else if (typeof widthConstraint === "object") {
      const widthConstraintMaximum = topMost(pile, ["widthConstraint", "maximum"]);
      if (typeof widthConstraintMaximum === "number") {
        fontOptions.maxWdt = Number(widthConstraintMaximum);
      }
      const widthConstraintMinimum = topMost(pile, ["widthConstraint", "minimum"]);
      if (typeof widthConstraintMinimum === "number") {
        fontOptions.minWdt = Number(widthConstraintMinimum);
      }
    }
    const heightConstraint = topMost(pile, "heightConstraint");
    if (typeof heightConstraint === "number") {
      fontOptions.minHgt = Number(heightConstraint);
    } else if (typeof heightConstraint === "object") {
      const heightConstraintMinimum = topMost(pile, ["heightConstraint", "minimum"]);
      if (typeof heightConstraintMinimum === "number") {
        fontOptions.minHgt = Number(heightConstraintMinimum);
      }
      const heightConstraintValign = topMost(pile, ["heightConstraint", "valign"]);
      if (typeof heightConstraintValign === "string") {
        if (heightConstraintValign === "top" || heightConstraintValign === "bottom") {
          fontOptions.valign = heightConstraintValign;
        }
      }
    }
    return fontOptions;
  }

  /**
   * Set options and update internal state
   * @param {object} options  options to set
   * @param {Array}  pile     array of option objects to consider for option 'chosen'
   */
  update(options, pile) {
    this.setOptions(options, true);
    this.propagateFonts(pile);
    deepExtend(this.fontOptions, this.constrain(pile));
    this.fontOptions.chooser = choosify("label", pile);
  }

  /**
   * When margins are set in an element, adjust sizes is called to remove them
   * from the width/height constraints. This must be done prior to label sizing.
   * @param {{top: number, right: number, bottom: number, left: number}} margins
   */
  adjustSizes(margins) {
    const widthBias = margins ? margins.right + margins.left : 0;
    if (this.fontOptions.constrainWidth) {
      this.fontOptions.maxWdt -= widthBias;
      this.fontOptions.minWdt -= widthBias;
    }
    const heightBias = margins ? margins.top + margins.bottom : 0;
    if (this.fontOptions.constrainHeight) {
      this.fontOptions.minHgt -= heightBias;
    }
  }

  /////////////////////////////////////////////////////////
  // Methods for handling options piles
  // Eventually, these will be moved to a separate class
  /////////////////////////////////////////////////////////

  /**
   * Add the font members of the passed list of option objects to the pile.
   * @param {Pile} dstPile  pile of option objects add to
   * @param {Pile} srcPile  pile of option objects to take font options from
   * @private
   */
  addFontOptionsToPile(dstPile, srcPile) {
    for (let i = 0; i < srcPile.length; ++i) {
      this.addFontToPile(dstPile, srcPile[i]);
    }
  }

  /**
   * Add given font option object to the list of objects (the 'pile') to consider for determining
   * multi-font option values.
   * @param {Pile} pile  pile of option objects to use
   * @param {object} options  instance to add to pile
   * @private
   */
  addFontToPile(pile, options) {
    if (options === undefined) return;
    if (options.font === undefined || options.font === null) return;
    const item = options.font;
    pile.push(item);
  }

  /**
   * Collect all own-property values from the font pile that aren't multi-font option objectss.
   * @param {Pile} pile  pile of option objects to use
   * @returns {object} object with all current own basic font properties
   * @private
   */
  getBasicOptions(pile) {
    const ret = {};

    // Scans the whole pile to get all options present
    for (let n = 0; n < pile.length; ++n) {
      let fontOptions = pile[n];

      // Convert shorthand if necessary
      const tmpShorthand = {};
      if (Label.parseFontString(tmpShorthand, fontOptions)) {
        fontOptions = tmpShorthand;
      }
      forEach$1(fontOptions, (opt, name) => {
        if (opt === undefined) return; // multi-font option need not be present
        if (Object.prototype.hasOwnProperty.call(ret, name)) return; // Keep first value we encounter

        if (_indexOfInstanceProperty(multiFontStyle).call(multiFontStyle, name) !== -1) {
          // Skip multi-font properties but we do need the structure
          ret[name] = {};
        } else {
          ret[name] = opt;
        }
      });
    }
    return ret;
  }

  /**
   * Return the value for given option for the given multi-font.
   *
   * All available option objects are trawled in the set order to construct the option values.
   *
   * ---------------------------------------------------------------------
   * ## Traversal of pile for multi-fonts
   *
   * The determination of multi-font option values is a special case, because any values not
   * present in the multi-font options should by definition be taken from the main font options,
   * i.e. from the current 'parent' object of the multi-font option.
   *
   * ### Search order for multi-fonts
   *
   * 'bold' used as example:
   *
   * - search in option group 'bold' in local properties
   * - search in main font option group in local properties
   *
   * ---------------------------------------------------------------------
   * @param {Pile} pile  pile of option objects to use
   * @param {MultiFontStyle} multiName sub path for the multi-font
   * @param {string} option  the option to search for, for the given multi-font
   * @returns {string|number} the value for the given option
   * @private
   */
  getFontOption(pile, multiName, option) {
    let multiFont;

    // Search multi font in local properties
    for (let n = 0; n < pile.length; ++n) {
      const fontOptions = pile[n];
      if (Object.prototype.hasOwnProperty.call(fontOptions, multiName)) {
        multiFont = fontOptions[multiName];
        if (multiFont === undefined || multiFont === null) continue;

        // Convert shorthand if necessary
        // TODO: inefficient to do this conversion every time; find a better way.
        const tmpShorthand = {};
        if (Label.parseFontString(tmpShorthand, multiFont)) {
          multiFont = tmpShorthand;
        }
        if (Object.prototype.hasOwnProperty.call(multiFont, option)) {
          return multiFont[option];
        }
      }
    }

    // Option is not mentioned in the multi font options; take it from the parent font options.
    // These have already been converted with getBasicOptions(), so use the converted values.
    if (Object.prototype.hasOwnProperty.call(this.fontOptions, option)) {
      return this.fontOptions[option];
    }

    // A value **must** be found; you should never get here.
    throw new Error("Did not find value for multi-font for property: '" + option + "'");
  }

  /**
   * Return all options values for the given multi-font.
   *
   * All available option objects are trawled in the set order to construct the option values.
   * @param {Pile} pile  pile of option objects to use
   * @param {MultiFontStyle} multiName sub path for the mod-font
   * @returns {MultiFontOptions}
   * @private
   */
  getFontOptions(pile, multiName) {
    const result = {};
    const optionNames = ["color", "size", "face", "mod", "vadjust"]; // List of allowed options per multi-font

    for (let i = 0; i < optionNames.length; ++i) {
      const mod = optionNames[i];
      result[mod] = this.getFontOption(pile, multiName, mod);
    }
    return result;
  }

  /////////////////////////////////////////////////////////
  // End methods for handling options piles
  /////////////////////////////////////////////////////////

  /**
   * Collapse the font options for the multi-font to single objects, from
   * the chain of option objects passed (the 'pile').
   * @param {Pile} pile  sequence of option objects to consider.
   *                     First item in list assumed to be the newly set options.
   */
  propagateFonts(pile) {
    const fontPile = []; // sequence of font objects to consider, order important

    // Note that this.elementOptions is not used here.
    this.addFontOptionsToPile(fontPile, pile);
    this.fontOptions = this.getBasicOptions(fontPile);

    // We set multifont values even if multi === false, for consistency (things break otherwise)
    for (let i = 0; i < multiFontStyle.length; ++i) {
      const mod = multiFontStyle[i];
      const modOptions = this.fontOptions[mod];
      const tmpMultiFontOptions = this.getFontOptions(fontPile, mod);

      // Copy over found values
      forEach$1(tmpMultiFontOptions, (option, n) => {
        modOptions[n] = option;
      });
      modOptions.size = Number(modOptions.size);
      modOptions.vadjust = Number(modOptions.vadjust);
    }
  }

  /**
   * Main function. This is called from anything that wants to draw a label.
   * @param {CanvasRenderingContext2D} ctx
   * @param {number} x
   * @param {number} y
   * @param {boolean} selected
   * @param {boolean} hover
   * @param {string} [baseline]
   */
  draw(ctx, x, y, selected, hover) {
    let baseline = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : "middle";
    // if no label, return
    if (this.elementOptions.label === undefined) return;

    // check if we have to render the label
    let viewFontSize = this.fontOptions.size * this.body.view.scale;
    if (this.elementOptions.label && viewFontSize < this.elementOptions.scaling.label.drawThreshold - 1) return;

    // This ensures that there will not be HUGE letters on screen
    // by setting an upper limit on the visible text size (regardless of zoomLevel)
    if (viewFontSize >= this.elementOptions.scaling.label.maxVisible) {
      viewFontSize = Number(this.elementOptions.scaling.label.maxVisible) / this.body.view.scale;
    }

    // update the size cache if required
    this.calculateLabelSize(ctx, selected, hover, x, y, baseline);
    this._drawBackground(ctx);
    this._drawText(ctx, x, this.size.yLine, baseline, viewFontSize);
  }

  /**
   * Draws the label background
   * @param {CanvasRenderingContext2D} ctx
   * @private
   */
  _drawBackground(ctx) {
    if (this.fontOptions.background !== undefined && this.fontOptions.background !== "none") {
      ctx.fillStyle = this.fontOptions.background;
      const size = this.getSize();
      ctx.fillRect(size.left, size.top, size.width, size.height);
    }
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {number} x
   * @param {number} y
   * @param {string} [baseline]
   * @param {number} viewFontSize
   * @private
   */
  _drawText(ctx, x, y) {
    let baseline = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : "middle";
    let viewFontSize = arguments.length > 4 ? arguments[4] : undefined;
    [x, y] = this._setAlignment(ctx, x, y, baseline);
    ctx.textAlign = "left";
    x = x - this.size.width / 2; // Shift label 1/2-distance to the left
    if (this.fontOptions.valign && this.size.height > this.size.labelHeight) {
      if (this.fontOptions.valign === "top") {
        y -= (this.size.height - this.size.labelHeight) / 2;
      }
      if (this.fontOptions.valign === "bottom") {
        y += (this.size.height - this.size.labelHeight) / 2;
      }
    }

    // draw the text
    for (let i = 0; i < this.lineCount; i++) {
      const line = this.lines[i];
      if (line && line.blocks) {
        let width = 0;
        if (this.isEdgeLabel || this.fontOptions.align === "center") {
          width += (this.size.width - line.width) / 2;
        } else if (this.fontOptions.align === "right") {
          width += this.size.width - line.width;
        }
        for (let j = 0; j < line.blocks.length; j++) {
          const block = line.blocks[j];
          ctx.font = block.font;
          const [fontColor, strokeColor] = this._getColor(block.color, viewFontSize, block.strokeColor);
          if (block.strokeWidth > 0) {
            ctx.lineWidth = block.strokeWidth;
            ctx.strokeStyle = strokeColor;
            ctx.lineJoin = "round";
          }
          ctx.fillStyle = fontColor;
          if (block.strokeWidth > 0) {
            ctx.strokeText(block.text, x + width, y + block.vadjust);
          }
          ctx.fillText(block.text, x + width, y + block.vadjust);
          width += block.width;
        }
        y += line.height;
      }
    }
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {number} x
   * @param {number} y
   * @param {string} baseline
   * @returns {Array.<number>}
   * @private
   */
  _setAlignment(ctx, x, y, baseline) {
    // check for label alignment (for edges)
    // TODO: make alignment for nodes
    if (this.isEdgeLabel && this.fontOptions.align !== "horizontal" && this.pointToSelf === false) {
      x = 0;
      y = 0;
      const lineMargin = 2;
      if (this.fontOptions.align === "top") {
        ctx.textBaseline = "alphabetic";
        y -= 2 * lineMargin; // distance from edge, required because we use alphabetic. Alphabetic has less difference between browsers
      } else if (this.fontOptions.align === "bottom") {
        ctx.textBaseline = "hanging";
        y += 2 * lineMargin; // distance from edge, required because we use hanging. Hanging has less difference between browsers
      } else {
        ctx.textBaseline = "middle";
      }
    } else {
      ctx.textBaseline = baseline;
    }
    return [x, y];
  }

  /**
   * fade in when relative scale is between threshold and threshold - 1.
   * If the relative scale would be smaller than threshold -1 the draw function would have returned before coming here.
   * @param {string} color  The font color to use
   * @param {number} viewFontSize
   * @param {string} initialStrokeColor
   * @returns {Array.<string>} An array containing the font color and stroke color
   * @private
   */
  _getColor(color, viewFontSize, initialStrokeColor) {
    let fontColor = color || "#000000";
    let strokeColor = initialStrokeColor || "#ffffff";
    if (viewFontSize <= this.elementOptions.scaling.label.drawThreshold) {
      const opacity = Math.max(0, Math.min(1, 1 - (this.elementOptions.scaling.label.drawThreshold - viewFontSize)));
      fontColor = overrideOpacity(fontColor, opacity);
      strokeColor = overrideOpacity(strokeColor, opacity);
    }
    return [fontColor, strokeColor];
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {boolean} selected
   * @param {boolean} hover
   * @returns {{width: number, height: number}}
   */
  getTextSize(ctx) {
    let selected = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
    let hover = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
    this._processLabel(ctx, selected, hover);
    return {
      width: this.size.width,
      height: this.size.height,
      lineCount: this.lineCount
    };
  }

  /**
   * Get the current dimensions of the label
   * @returns {rect}
   */
  getSize() {
    const lineMargin = 2;
    let x = this.size.left; // default values which might be overridden below
    let y = this.size.top - 0.5 * lineMargin; // idem

    if (this.isEdgeLabel) {
      const x2 = -this.size.width * 0.5;
      switch (this.fontOptions.align) {
        case "middle":
          x = x2;
          y = -this.size.height * 0.5;
          break;
        case "top":
          x = x2;
          y = -(this.size.height + lineMargin);
          break;
        case "bottom":
          x = x2;
          y = lineMargin;
          break;
      }
    }
    const ret = {
      left: x,
      top: y,
      width: this.size.width,
      height: this.size.height
    };
    return ret;
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {boolean} selected
   * @param {boolean} hover
   * @param {number} [x]
   * @param {number} [y]
   * @param {'middle'|'hanging'} [baseline]
   */
  calculateLabelSize(ctx, selected, hover) {
    let x = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 0;
    let y = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : 0;
    let baseline = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : "middle";
    this._processLabel(ctx, selected, hover);
    this.size.left = x - this.size.width * 0.5;
    this.size.top = y - this.size.height * 0.5;
    this.size.yLine = y + (1 - this.lineCount) * 0.5 * this.fontOptions.size;
    if (baseline === "hanging") {
      this.size.top += 0.5 * this.fontOptions.size;
      this.size.top += 4; // distance from node, required because we use hanging. Hanging has less difference between browsers
      this.size.yLine += 4; // distance from node
    }
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {boolean} selected
   * @param {boolean} hover
   * @param {string} mod
   * @returns {{color, size, face, mod, vadjust, strokeWidth: *, strokeColor: (*|string|allOptions.edges.font.strokeColor|{string}|allOptions.nodes.font.strokeColor|Array)}}
   */
  getFormattingValues(ctx, selected, hover, mod) {
    const getValue = function (fontOptions, mod, option) {
      if (mod === "normal") {
        if (option === "mod") return "";
        return fontOptions[option];
      }
      if (fontOptions[mod][option] !== undefined) {
        // Grumbl leaving out test on undefined equals false for ""
        return fontOptions[mod][option];
      } else {
        // Take from parent font option
        return fontOptions[option];
      }
    };
    const values = {
      color: getValue(this.fontOptions, mod, "color"),
      size: getValue(this.fontOptions, mod, "size"),
      face: getValue(this.fontOptions, mod, "face"),
      mod: getValue(this.fontOptions, mod, "mod"),
      vadjust: getValue(this.fontOptions, mod, "vadjust"),
      strokeWidth: this.fontOptions.strokeWidth,
      strokeColor: this.fontOptions.strokeColor
    };
    if (selected || hover) {
      if (mod === "normal" && this.fontOptions.chooser === true && this.elementOptions.labelHighlightBold) {
        values.mod = "bold";
      } else {
        if (typeof this.fontOptions.chooser === "function") {
          this.fontOptions.chooser(values, this.elementOptions.id, selected, hover);
        }
      }
    }
    let fontString = "";
    if (values.mod !== undefined && values.mod !== "") {
      // safeguard for undefined - this happened
      fontString += values.mod + " ";
    }
    fontString += values.size + "px " + values.face;
    ctx.font = fontString.replace(/"/g, "");
    values.font = ctx.font;
    values.height = values.size;
    return values;
  }

  /**
   *
   * @param {boolean} selected
   * @param {boolean} hover
   * @returns {boolean}
   */
  differentState(selected, hover) {
    return selected !== this.selectedState || hover !== this.hoverState;
  }

  /**
   * This explodes the passed text into lines and determines the width, height and number of lines.
   * @param {CanvasRenderingContext2D} ctx
   * @param {boolean} selected
   * @param {boolean} hover
   * @param {string} inText  the text to explode
   * @returns {{width, height, lines}|*}
   * @private
   */
  _processLabelText(ctx, selected, hover, inText) {
    const splitter = new LabelSplitter(ctx, this, selected, hover);
    return splitter.process(inText);
  }

  /**
   * This explodes the label string into lines and sets the width, height and number of lines.
   * @param {CanvasRenderingContext2D} ctx
   * @param {boolean} selected
   * @param {boolean} hover
   * @private
   */
  _processLabel(ctx, selected, hover) {
    if (this.labelDirty === false && !this.differentState(selected, hover)) return;
    const state = this._processLabelText(ctx, selected, hover, this.elementOptions.label);
    if (this.fontOptions.minWdt > 0 && state.width < this.fontOptions.minWdt) {
      state.width = this.fontOptions.minWdt;
    }
    this.size.labelHeight = state.height;
    if (this.fontOptions.minHgt > 0 && state.height < this.fontOptions.minHgt) {
      state.height = this.fontOptions.minHgt;
    }
    this.lines = state.lines;
    this.lineCount = state.lines.length;
    this.size.width = state.width;
    this.size.height = state.height;
    this.selectedState = selected;
    this.hoverState = hover;
    this.labelDirty = false;
  }

  /**
   * Check if this label is visible
   * @returns {boolean} true if this label will be show, false otherwise
   */
  visible() {
    if (this.size.width === 0 || this.size.height === 0 || this.elementOptions.label === undefined) {
      return false; // nothing to display
    }

    const viewFontSize = this.fontOptions.size * this.body.view.scale;
    if (viewFontSize < this.elementOptions.scaling.label.drawThreshold - 1) {
      return false; // Too small or too far away to show
    }

    return true;
  }
}

/**
 * The Base class for all Nodes.
 */
class NodeBase {
  /**
   * @param {object} options
   * @param {object} body
   * @param {Label} labelModule
   */
  constructor(options, body, labelModule) {
    this.body = body;
    this.labelModule = labelModule;
    this.setOptions(options);
    this.top = undefined;
    this.left = undefined;
    this.height = undefined;
    this.width = undefined;
    this.radius = undefined;
    this.margin = undefined;
    this.refreshNeeded = true;
    this.boundingBox = {
      top: 0,
      left: 0,
      right: 0,
      bottom: 0
    };
  }

  /**
   *
   * @param {object} options
   */
  setOptions(options) {
    this.options = options;
  }

  /**
   *
   * @param {Label} labelModule
   * @private
   */
  _setMargins(labelModule) {
    this.margin = {};
    if (this.options.margin) {
      if (typeof this.options.margin == "object") {
        this.margin.top = this.options.margin.top;
        this.margin.right = this.options.margin.right;
        this.margin.bottom = this.options.margin.bottom;
        this.margin.left = this.options.margin.left;
      } else {
        this.margin.top = this.options.margin;
        this.margin.right = this.options.margin;
        this.margin.bottom = this.options.margin;
        this.margin.left = this.options.margin;
      }
    }
    labelModule.adjustSizes(this.margin);
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {number} angle
   * @returns {number}
   * @private
   */
  _distanceToBorder(ctx, angle) {
    const borderWidth = this.options.borderWidth;
    if (ctx) {
      this.resize(ctx);
    }
    return Math.min(Math.abs(this.width / 2 / Math.cos(angle)), Math.abs(this.height / 2 / Math.sin(angle))) + borderWidth;
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {ArrowOptions} values
   */
  enableShadow(ctx, values) {
    if (values.shadow) {
      ctx.shadowColor = values.shadowColor;
      ctx.shadowBlur = values.shadowSize;
      ctx.shadowOffsetX = values.shadowX;
      ctx.shadowOffsetY = values.shadowY;
    }
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {ArrowOptions} values
   */
  disableShadow(ctx, values) {
    if (values.shadow) {
      ctx.shadowColor = "rgba(0,0,0,0)";
      ctx.shadowBlur = 0;
      ctx.shadowOffsetX = 0;
      ctx.shadowOffsetY = 0;
    }
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {ArrowOptions} values
   */
  enableBorderDashes(ctx, values) {
    if (values.borderDashes !== false) {
      if (ctx.setLineDash !== undefined) {
        let dashes = values.borderDashes;
        if (dashes === true) {
          dashes = [5, 15];
        }
        ctx.setLineDash(dashes);
      } else {
        console.warn("setLineDash is not supported in this browser. The dashed borders cannot be used.");
        this.options.shapeProperties.borderDashes = false;
        values.borderDashes = false;
      }
    }
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {ArrowOptions} values
   */
  disableBorderDashes(ctx, values) {
    if (values.borderDashes !== false) {
      if (ctx.setLineDash !== undefined) {
        ctx.setLineDash([0]);
      } else {
        console.warn("setLineDash is not supported in this browser. The dashed borders cannot be used.");
        this.options.shapeProperties.borderDashes = false;
        values.borderDashes = false;
      }
    }
  }

  /**
   * Determine if the shape of a node needs to be recalculated.
   * @param {boolean} selected
   * @param {boolean} hover
   * @returns {boolean}
   * @protected
   */
  needsRefresh(selected, hover) {
    if (this.refreshNeeded === true) {
      // This is probably not the best location to reset this member.
      // However, in the current logic, it is the most convenient one.
      this.refreshNeeded = false;
      return true;
    }
    return this.width === undefined || this.labelModule.differentState(selected, hover);
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {ArrowOptions} values
   */
  initContextForDraw(ctx, values) {
    const borderWidth = values.borderWidth / this.body.view.scale;
    ctx.lineWidth = Math.min(this.width, borderWidth);
    ctx.strokeStyle = values.borderColor;
    ctx.fillStyle = values.color;
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {ArrowOptions} values
   */
  performStroke(ctx, values) {
    const borderWidth = values.borderWidth / this.body.view.scale;

    //draw dashed border if enabled, save and restore is required for firefox not to crash on unix.
    ctx.save();
    // if borders are zero width, they will be drawn with width 1 by default. This prevents that
    if (borderWidth > 0) {
      this.enableBorderDashes(ctx, values);
      //draw the border
      ctx.stroke();
      //disable dashed border for other elements
      this.disableBorderDashes(ctx, values);
    }
    ctx.restore();
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {ArrowOptions} values
   */
  performFill(ctx, values) {
    ctx.save();
    ctx.fillStyle = values.color;
    // draw shadow if enabled
    this.enableShadow(ctx, values);
    // draw the background
    _fillInstanceProperty(ctx).call(ctx);
    // disable shadows for other elements.
    this.disableShadow(ctx, values);
    ctx.restore();
    this.performStroke(ctx, values);
  }

  /**
   *
   * @param {number} margin
   * @private
   */
  _addBoundingBoxMargin(margin) {
    this.boundingBox.left -= margin;
    this.boundingBox.top -= margin;
    this.boundingBox.bottom += margin;
    this.boundingBox.right += margin;
  }

  /**
   * Actual implementation of this method call.
   *
   * Doing it like this makes it easier to override
   * in the child classes.
   * @param {number} x width
   * @param {number} y height
   * @param {CanvasRenderingContext2D} ctx
   * @param {boolean} selected
   * @param {boolean} hover
   * @private
   */
  _updateBoundingBox(x, y, ctx, selected, hover) {
    if (ctx !== undefined) {
      this.resize(ctx, selected, hover);
    }
    this.left = x - this.width / 2;
    this.top = y - this.height / 2;
    this.boundingBox.left = this.left;
    this.boundingBox.top = this.top;
    this.boundingBox.bottom = this.top + this.height;
    this.boundingBox.right = this.left + this.width;
  }

  /**
   * Default implementation of this method call.
   * This acts as a stub which can be overridden.
   * @param {number} x width
   * @param {number} y height
   * @param {CanvasRenderingContext2D} ctx
   * @param {boolean} selected
   * @param {boolean} hover
   */
  updateBoundingBox(x, y, ctx, selected, hover) {
    this._updateBoundingBox(x, y, ctx, selected, hover);
  }

  /**
   * Determine the dimensions to use for nodes with an internal label
   *
   * Currently, these are: Circle, Ellipse, Database, Box
   * The other nodes have external labels, and will not call this method
   *
   * If there is no label, decent default values are supplied.
   * @param {CanvasRenderingContext2D} ctx
   * @param {boolean} [selected]
   * @param {boolean} [hover]
   * @returns {{width:number, height:number}}
   */
  getDimensionsFromLabel(ctx, selected, hover) {
    // NOTE: previously 'textSize' was not put in 'this' for Ellipse
    // TODO: examine the consequences.
    this.textSize = this.labelModule.getTextSize(ctx, selected, hover);
    let width = this.textSize.width;
    let height = this.textSize.height;
    const DEFAULT_SIZE = 14;
    if (width === 0) {
      // This happens when there is no label text set
      width = DEFAULT_SIZE; // use a decent default
      height = DEFAULT_SIZE; // if width zero, then height also always zero
    }

    return {
      width: width,
      height: height
    };
  }
}

/**
 * A Box Node/Cluster shape.
 * @augments NodeBase
 */
let Box$1 = class Box extends NodeBase {
  /**
   * @param {object} options
   * @param {object} body
   * @param {Label} labelModule
   */
  constructor(options, body, labelModule) {
    super(options, body, labelModule);
    this._setMargins(labelModule);
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {boolean} [selected]
   * @param {boolean} [hover]
   */
  resize(ctx) {
    let selected = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.selected;
    let hover = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : this.hover;
    if (this.needsRefresh(selected, hover)) {
      const dimensions = this.getDimensionsFromLabel(ctx, selected, hover);
      this.width = dimensions.width + this.margin.right + this.margin.left;
      this.height = dimensions.height + this.margin.top + this.margin.bottom;
      this.radius = this.width / 2;
    }
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {number} x width
   * @param {number} y height
   * @param {boolean} selected
   * @param {boolean} hover
   * @param {ArrowOptions} values
   */
  draw(ctx, x, y, selected, hover, values) {
    this.resize(ctx, selected, hover);
    this.left = x - this.width / 2;
    this.top = y - this.height / 2;
    this.initContextForDraw(ctx, values);
    drawRoundRect(ctx, this.left, this.top, this.width, this.height, values.borderRadius);
    this.performFill(ctx, values);
    this.updateBoundingBox(x, y, ctx, selected, hover);
    this.labelModule.draw(ctx, this.left + this.textSize.width / 2 + this.margin.left, this.top + this.textSize.height / 2 + this.margin.top, selected, hover);
  }

  /**
   *
   * @param {number} x width
   * @param {number} y height
   * @param {CanvasRenderingContext2D} ctx
   * @param {boolean} selected
   * @param {boolean} hover
   */
  updateBoundingBox(x, y, ctx, selected, hover) {
    this._updateBoundingBox(x, y, ctx, selected, hover);
    const borderRadius = this.options.shapeProperties.borderRadius; // only effective for box
    this._addBoundingBoxMargin(borderRadius);
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {number} angle
   * @returns {number}
   */
  distanceToBorder(ctx, angle) {
    if (ctx) {
      this.resize(ctx);
    }
    const borderWidth = this.options.borderWidth;
    return Math.min(Math.abs(this.width / 2 / Math.cos(angle)), Math.abs(this.height / 2 / Math.sin(angle))) + borderWidth;
  }
};

/**
 * NOTE: This is a bad base class
 *
 * Child classes are:
 *
 * Image       - uses *only* image methods
 * Circle      - uses *only* _drawRawCircle
 * CircleImage - uses all
 *
 * TODO: Refactor, move _drawRawCircle to different module, derive Circle from NodeBase
 * Rename this to ImageBase
 * Consolidate common code in Image and CircleImage to base class
 * @augments NodeBase
 */
class CircleImageBase extends NodeBase {
  /**
   * @param {object} options
   * @param {object} body
   * @param {Label} labelModule
   */
  constructor(options, body, labelModule) {
    super(options, body, labelModule);
    this.labelOffset = 0;
    this.selected = false;
  }

  /**
   *
   * @param {object} options
   * @param {object} [imageObj]
   * @param {object} [imageObjAlt]
   */
  setOptions(options, imageObj, imageObjAlt) {
    this.options = options;
    if (!(imageObj === undefined && imageObjAlt === undefined)) {
      this.setImages(imageObj, imageObjAlt);
    }
  }

  /**
   * Set the images for this node.
   *
   * The images can be updated after the initial setting of options;
   * therefore, this method needs to be reentrant.
   *
   * For correct working in error cases, it is necessary to properly set
   * field 'nodes.brokenImage' in the options.
   * @param {Image} imageObj  required; main image to show for this node
   * @param {Image|undefined} imageObjAlt optional; image to show when node is selected
   */
  setImages(imageObj, imageObjAlt) {
    if (imageObjAlt && this.selected) {
      this.imageObj = imageObjAlt;
      this.imageObjAlt = imageObj;
    } else {
      this.imageObj = imageObj;
      this.imageObjAlt = imageObjAlt;
    }
  }

  /**
   * Set selection and switch between the base and the selected image.
   *
   * Do the switch only if imageObjAlt exists.
   * @param {boolean} selected value of new selected state for current node
   */
  switchImages(selected) {
    const selection_changed = selected && !this.selected || !selected && this.selected;
    this.selected = selected; // Remember new selection

    if (this.imageObjAlt !== undefined && selection_changed) {
      const imageTmp = this.imageObj;
      this.imageObj = this.imageObjAlt;
      this.imageObjAlt = imageTmp;
    }
  }

  /**
   * Returns Image Padding from node options
   * @returns {{top: number,left: number,bottom: number,right: number}} image padding inside this shape
   * @private
   */
  _getImagePadding() {
    const imgPadding = {
      top: 0,
      right: 0,
      bottom: 0,
      left: 0
    };
    if (this.options.imagePadding) {
      const optImgPadding = this.options.imagePadding;
      if (typeof optImgPadding == "object") {
        imgPadding.top = optImgPadding.top;
        imgPadding.right = optImgPadding.right;
        imgPadding.bottom = optImgPadding.bottom;
        imgPadding.left = optImgPadding.left;
      } else {
        imgPadding.top = optImgPadding;
        imgPadding.right = optImgPadding;
        imgPadding.bottom = optImgPadding;
        imgPadding.left = optImgPadding;
      }
    }
    return imgPadding;
  }

  /**
   * Adjust the node dimensions for a loaded image.
   *
   * Pre: this.imageObj is valid
   */
  _resizeImage() {
    let width, height;
    if (this.options.shapeProperties.useImageSize === false) {
      // Use the size property
      let ratio_width = 1;
      let ratio_height = 1;

      // Only calculate the proper ratio if both width and height not zero
      if (this.imageObj.width && this.imageObj.height) {
        if (this.imageObj.width > this.imageObj.height) {
          ratio_width = this.imageObj.width / this.imageObj.height;
        } else {
          ratio_height = this.imageObj.height / this.imageObj.width;
        }
      }
      width = this.options.size * 2 * ratio_width;
      height = this.options.size * 2 * ratio_height;
    } else {
      // Use the image size with image padding
      const imgPadding = this._getImagePadding();
      width = this.imageObj.width + imgPadding.left + imgPadding.right;
      height = this.imageObj.height + imgPadding.top + imgPadding.bottom;
    }
    this.width = width;
    this.height = height;
    this.radius = 0.5 * this.width;
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {number} x width
   * @param {number} y height
   * @param {ArrowOptions} values
   * @private
   */
  _drawRawCircle(ctx, x, y, values) {
    this.initContextForDraw(ctx, values);
    drawCircle(ctx, x, y, values.size);
    this.performFill(ctx, values);
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {ArrowOptions} values
   * @private
   */
  _drawImageAtPosition(ctx, values) {
    if (this.imageObj.width != 0) {
      // draw the image
      ctx.globalAlpha = values.opacity !== undefined ? values.opacity : 1;

      // draw shadow if enabled
      this.enableShadow(ctx, values);
      let factor = 1;
      if (this.options.shapeProperties.interpolation === true) {
        factor = this.imageObj.width / this.width / this.body.view.scale;
      }
      const imgPadding = this._getImagePadding();
      const imgPosLeft = this.left + imgPadding.left;
      const imgPosTop = this.top + imgPadding.top;
      const imgWidth = this.width - imgPadding.left - imgPadding.right;
      const imgHeight = this.height - imgPadding.top - imgPadding.bottom;
      this.imageObj.drawImageAtPosition(ctx, factor, imgPosLeft, imgPosTop, imgWidth, imgHeight);

      // disable shadows for other elements.
      this.disableShadow(ctx, values);
    }
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {number} x width
   * @param {number} y height
   * @param {boolean} selected
   * @param {boolean} hover
   * @private
   */
  _drawImageLabel(ctx, x, y, selected, hover) {
    let offset = 0;
    if (this.height !== undefined) {
      offset = this.height * 0.5;
      const labelDimensions = this.labelModule.getTextSize(ctx, selected, hover);
      if (labelDimensions.lineCount >= 1) {
        offset += labelDimensions.height / 2;
      }
    }
    const yLabel = y + offset;
    if (this.options.label) {
      this.labelOffset = offset;
    }
    this.labelModule.draw(ctx, x, yLabel, selected, hover, "hanging");
  }
}

/**
 * A Circle Node/Cluster shape.
 * @augments CircleImageBase
 */
let Circle$1 = class Circle extends CircleImageBase {
  /**
   * @param {object} options
   * @param {object} body
   * @param {Label} labelModule
   */
  constructor(options, body, labelModule) {
    super(options, body, labelModule);
    this._setMargins(labelModule);
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {boolean} [selected]
   * @param {boolean} [hover]
   */
  resize(ctx) {
    let selected = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.selected;
    let hover = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : this.hover;
    if (this.needsRefresh(selected, hover)) {
      const dimensions = this.getDimensionsFromLabel(ctx, selected, hover);
      const diameter = Math.max(dimensions.width + this.margin.right + this.margin.left, dimensions.height + this.margin.top + this.margin.bottom);
      this.options.size = diameter / 2; // NOTE: this size field only set here, not in Ellipse, Database, Box
      this.width = diameter;
      this.height = diameter;
      this.radius = this.width / 2;
    }
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {number} x width
   * @param {number} y height
   * @param {boolean} selected
   * @param {boolean} hover
   * @param {ArrowOptions} values
   */
  draw(ctx, x, y, selected, hover, values) {
    this.resize(ctx, selected, hover);
    this.left = x - this.width / 2;
    this.top = y - this.height / 2;
    this._drawRawCircle(ctx, x, y, values);
    this.updateBoundingBox(x, y);
    this.labelModule.draw(ctx, this.left + this.textSize.width / 2 + this.margin.left, y, selected, hover);
  }

  /**
   *
   * @param {number} x width
   * @param {number} y height
   */
  updateBoundingBox(x, y) {
    this.boundingBox.top = y - this.options.size;
    this.boundingBox.left = x - this.options.size;
    this.boundingBox.right = x + this.options.size;
    this.boundingBox.bottom = y + this.options.size;
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @returns {number}
   */
  distanceToBorder(ctx) {
    if (ctx) {
      this.resize(ctx);
    }
    return this.width * 0.5;
  }
};

/**
 * A CircularImage Node/Cluster shape.
 * @augments CircleImageBase
 */
class CircularImage extends CircleImageBase {
  /**
   * @param {object} options
   * @param {object} body
   * @param {Label} labelModule
   * @param {Image} imageObj
   * @param {Image} imageObjAlt
   */
  constructor(options, body, labelModule, imageObj, imageObjAlt) {
    super(options, body, labelModule);
    this.setImages(imageObj, imageObjAlt);
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {boolean} [selected]
   * @param {boolean} [hover]
   */
  resize(ctx) {
    let selected = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.selected;
    let hover = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : this.hover;
    const imageAbsent = this.imageObj.src === undefined || this.imageObj.width === undefined || this.imageObj.height === undefined;
    if (imageAbsent) {
      const diameter = this.options.size * 2;
      this.width = diameter;
      this.height = diameter;
      this.radius = 0.5 * this.width;
      return;
    }

    // At this point, an image is present, i.e. this.imageObj is valid.
    if (this.needsRefresh(selected, hover)) {
      this._resizeImage();
    }
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {number} x width
   * @param {number} y height
   * @param {boolean} selected
   * @param {boolean} hover
   * @param {ArrowOptions} values
   */
  draw(ctx, x, y, selected, hover, values) {
    this.switchImages(selected);
    this.resize();
    let labelX = x,
      labelY = y;
    if (this.options.shapeProperties.coordinateOrigin === "top-left") {
      this.left = x;
      this.top = y;
      labelX += this.width / 2;
      labelY += this.height / 2;
    } else {
      this.left = x - this.width / 2;
      this.top = y - this.height / 2;
    }

    // draw the background circle. IMPORTANT: the stroke in this method is used by the clip method below.
    this._drawRawCircle(ctx, labelX, labelY, values);

    // now we draw in the circle, we save so we can revert the clip operation after drawing.
    ctx.save();
    // clip is used to use the stroke in drawRawCircle as an area that we can draw in.
    ctx.clip();
    // draw the image
    this._drawImageAtPosition(ctx, values);
    // restore so we can again draw on the full canvas
    ctx.restore();
    this._drawImageLabel(ctx, labelX, labelY, selected, hover);
    this.updateBoundingBox(x, y);
  }

  // TODO: compare with Circle.updateBoundingBox(), consolidate? More stuff is happening here
  /**
   *
   * @param {number} x width
   * @param {number} y height
   */
  updateBoundingBox(x, y) {
    if (this.options.shapeProperties.coordinateOrigin === "top-left") {
      this.boundingBox.top = y;
      this.boundingBox.left = x;
      this.boundingBox.right = x + this.options.size * 2;
      this.boundingBox.bottom = y + this.options.size * 2;
    } else {
      this.boundingBox.top = y - this.options.size;
      this.boundingBox.left = x - this.options.size;
      this.boundingBox.right = x + this.options.size;
      this.boundingBox.bottom = y + this.options.size;
    }

    // TODO: compare with Image.updateBoundingBox(), consolidate?
    this.boundingBox.left = Math.min(this.boundingBox.left, this.labelModule.size.left);
    this.boundingBox.right = Math.max(this.boundingBox.right, this.labelModule.size.left + this.labelModule.size.width);
    this.boundingBox.bottom = Math.max(this.boundingBox.bottom, this.boundingBox.bottom + this.labelOffset);
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @returns {number}
   */
  distanceToBorder(ctx) {
    if (ctx) {
      this.resize(ctx);
    }
    return this.width * 0.5;
  }
}

/**
 * Base class for constructing Node/Cluster Shapes.
 * @augments NodeBase
 */
class ShapeBase extends NodeBase {
  /**
   * @param {object} options
   * @param {object} body
   * @param {Label} labelModule
   */
  constructor(options, body, labelModule) {
    super(options, body, labelModule);
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {boolean} [selected]
   * @param {boolean} [hover]
   * @param {object} [values]
   */
  resize(ctx) {
    let selected = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.selected;
    let hover = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : this.hover;
    let values = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {
      size: this.options.size
    };
    if (this.needsRefresh(selected, hover)) {
      var _this$customSizeWidth, _this$customSizeHeigh;
      this.labelModule.getTextSize(ctx, selected, hover);
      const size = 2 * values.size;
      this.width = (_this$customSizeWidth = this.customSizeWidth) !== null && _this$customSizeWidth !== void 0 ? _this$customSizeWidth : size;
      this.height = (_this$customSizeHeigh = this.customSizeHeight) !== null && _this$customSizeHeigh !== void 0 ? _this$customSizeHeigh : size;
      this.radius = 0.5 * this.width;
    }
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {string} shape
   * @param {number} sizeMultiplier - Unused! TODO: Remove next major release
   * @param {number} x
   * @param {number} y
   * @param {boolean} selected
   * @param {boolean} hover
   * @param {ArrowOptions} values
   * @private
   * @returns {object} Callbacks to draw later on higher layers.
   */
  _drawShape(ctx, shape, sizeMultiplier, x, y, selected, hover, values) {
    this.resize(ctx, selected, hover, values);
    this.left = x - this.width / 2;
    this.top = y - this.height / 2;
    this.initContextForDraw(ctx, values);
    getShape(shape)(ctx, x, y, values.size);
    this.performFill(ctx, values);
    if (this.options.icon !== undefined) {
      if (this.options.icon.code !== undefined) {
        ctx.font = (selected ? "bold " : "") + this.height / 2 + "px " + (this.options.icon.face || "FontAwesome");
        ctx.fillStyle = this.options.icon.color || "black";
        ctx.textAlign = "center";
        ctx.textBaseline = "middle";
        ctx.fillText(this.options.icon.code, x, y);
      }
    }
    return {
      drawExternalLabel: () => {
        if (this.options.label !== undefined) {
          // Need to call following here in order to ensure value for
          // `this.labelModule.size.height`.
          this.labelModule.calculateLabelSize(ctx, selected, hover, x, y, "hanging");
          const yLabel = y + 0.5 * this.height + 0.5 * this.labelModule.size.height;
          this.labelModule.draw(ctx, x, yLabel, selected, hover, "hanging");
        }
        this.updateBoundingBox(x, y);
      }
    };
  }

  /**
   *
   * @param {number} x
   * @param {number} y
   */
  updateBoundingBox(x, y) {
    this.boundingBox.top = y - this.options.size;
    this.boundingBox.left = x - this.options.size;
    this.boundingBox.right = x + this.options.size;
    this.boundingBox.bottom = y + this.options.size;
    if (this.options.label !== undefined && this.labelModule.size.width > 0) {
      this.boundingBox.left = Math.min(this.boundingBox.left, this.labelModule.size.left);
      this.boundingBox.right = Math.max(this.boundingBox.right, this.labelModule.size.left + this.labelModule.size.width);
      this.boundingBox.bottom = Math.max(this.boundingBox.bottom, this.boundingBox.bottom + this.labelModule.size.height);
    }
  }
}

function ownKeys$3(e, r) { var t = _Object$keys(e); if (_Object$getOwnPropertySymbols) { var o = _Object$getOwnPropertySymbols(e); r && (o = _filterInstanceProperty(o).call(o, function (r) { return _Object$getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread$3(e) { for (var r = 1; r < arguments.length; r++) { var _context, _context2; var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? _forEachInstanceProperty(_context = ownKeys$3(Object(t), !0)).call(_context, function (r) { _defineProperty(e, r, t[r]); }) : _Object$getOwnPropertyDescriptors ? _Object$defineProperties(e, _Object$getOwnPropertyDescriptors(t)) : _forEachInstanceProperty(_context2 = ownKeys$3(Object(t))).call(_context2, function (r) { _Object$defineProperty(e, r, _Object$getOwnPropertyDescriptor(t, r)); }); } return e; }

/**
 * A CustomShape Node/Cluster shape.
 * @augments ShapeBase
 */
class CustomShape extends ShapeBase {
  /**
   * @param {object} options
   * @param {object} body
   * @param {Label} labelModule
   * @param {Function} ctxRenderer
   */
  constructor(options, body, labelModule, ctxRenderer) {
    super(options, body, labelModule, ctxRenderer);
    this.ctxRenderer = ctxRenderer;
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {number} x width
   * @param {number} y height
   * @param {boolean} selected
   * @param {boolean} hover
   * @param {ArrowOptions} values
   * @returns {object} Callbacks to draw later on different layers.
   */
  draw(ctx, x, y, selected, hover, values) {
    this.resize(ctx, selected, hover, values);
    this.left = x - this.width / 2;
    this.top = y - this.height / 2;

    // Guard right away because someone may just draw in the function itself.
    ctx.save();
    const drawLater = this.ctxRenderer({
      ctx,
      id: this.options.id,
      x,
      y,
      state: {
        selected,
        hover
      },
      style: _objectSpread$3({}, values),
      label: this.options.label
    });
    // Render the node shape bellow arrows.
    if (drawLater.drawNode != null) {
      drawLater.drawNode();
    }
    ctx.restore();
    if (drawLater.drawExternalLabel) {
      // Guard the external label (above arrows) drawing function.
      const drawExternalLabel = drawLater.drawExternalLabel;
      drawLater.drawExternalLabel = () => {
        ctx.save();
        drawExternalLabel();
        ctx.restore();
      };
    }
    if (drawLater.nodeDimensions) {
      this.customSizeWidth = drawLater.nodeDimensions.width;
      this.customSizeHeight = drawLater.nodeDimensions.height;
    }
    return drawLater;
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {number} angle
   * @returns {number}
   */
  distanceToBorder(ctx, angle) {
    return this._distanceToBorder(ctx, angle);
  }
}

/**
 * A Database Node/Cluster shape.
 * @augments NodeBase
 */
class Database extends NodeBase {
  /**
   * @param {object} options
   * @param {object} body
   * @param {Label} labelModule
   */
  constructor(options, body, labelModule) {
    super(options, body, labelModule);
    this._setMargins(labelModule);
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {boolean} selected
   * @param {boolean} hover
   */
  resize(ctx, selected, hover) {
    if (this.needsRefresh(selected, hover)) {
      const dimensions = this.getDimensionsFromLabel(ctx, selected, hover);
      const size = dimensions.width + this.margin.right + this.margin.left;
      this.width = size;
      this.height = size;
      this.radius = this.width / 2;
    }
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {number} x width
   * @param {number} y height
   * @param {boolean} selected
   * @param {boolean} hover
   * @param {ArrowOptions} values
   */
  draw(ctx, x, y, selected, hover, values) {
    this.resize(ctx, selected, hover);
    this.left = x - this.width / 2;
    this.top = y - this.height / 2;
    this.initContextForDraw(ctx, values);
    drawDatabase(ctx, x - this.width / 2, y - this.height / 2, this.width, this.height);
    this.performFill(ctx, values);
    this.updateBoundingBox(x, y, ctx, selected, hover);
    this.labelModule.draw(ctx, this.left + this.textSize.width / 2 + this.margin.left, this.top + this.textSize.height / 2 + this.margin.top, selected, hover);
  }
  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {number} angle
   * @returns {number}
   */
  distanceToBorder(ctx, angle) {
    return this._distanceToBorder(ctx, angle);
  }
}

/**
 * A Diamond Node/Cluster shape.
 * @augments ShapeBase
 */
let Diamond$1 = class Diamond extends ShapeBase {
  /**
   * @param {object} options
   * @param {object} body
   * @param {Label} labelModule
   */
  constructor(options, body, labelModule) {
    super(options, body, labelModule);
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {number} x width
   * @param {number} y height
   * @param {boolean} selected
   * @param {boolean} hover
   * @param {ArrowOptions} values
   * @returns {object} Callbacks to draw later on higher layers.
   */
  draw(ctx, x, y, selected, hover, values) {
    return this._drawShape(ctx, "diamond", 4, x, y, selected, hover, values);
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {number} angle
   * @returns {number}
   */
  distanceToBorder(ctx, angle) {
    return this._distanceToBorder(ctx, angle);
  }
};

/**
 * A Dot Node/Cluster shape.
 * @augments ShapeBase
 */
class Dot extends ShapeBase {
  /**
   * @param {object} options
   * @param {object} body
   * @param {Label} labelModule
   */
  constructor(options, body, labelModule) {
    super(options, body, labelModule);
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {number} x width
   * @param {number} y height
   * @param {boolean} selected
   * @param {boolean} hover
   * @param {ArrowOptions} values
   * @returns {object} Callbacks to draw later on higher layers.
   */
  draw(ctx, x, y, selected, hover, values) {
    return this._drawShape(ctx, "circle", 2, x, y, selected, hover, values);
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @returns {number}
   */
  distanceToBorder(ctx) {
    if (ctx) {
      this.resize(ctx);
    }
    return this.options.size;
  }
}

/**
 * Am Ellipse Node/Cluster shape.
 * @augments NodeBase
 */
class Ellipse extends NodeBase {
  /**
   * @param {object} options
   * @param {object} body
   * @param {Label} labelModule
   */
  constructor(options, body, labelModule) {
    super(options, body, labelModule);
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {boolean} [selected]
   * @param {boolean} [hover]
   */
  resize(ctx) {
    let selected = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.selected;
    let hover = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : this.hover;
    if (this.needsRefresh(selected, hover)) {
      const dimensions = this.getDimensionsFromLabel(ctx, selected, hover);
      this.height = dimensions.height * 2;
      this.width = dimensions.width + dimensions.height;
      this.radius = 0.5 * this.width;
    }
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {number} x width
   * @param {number} y height
   * @param {boolean} selected
   * @param {boolean} hover
   * @param {ArrowOptions} values
   */
  draw(ctx, x, y, selected, hover, values) {
    this.resize(ctx, selected, hover);
    this.left = x - this.width * 0.5;
    this.top = y - this.height * 0.5;
    this.initContextForDraw(ctx, values);
    drawEllipse(ctx, this.left, this.top, this.width, this.height);
    this.performFill(ctx, values);
    this.updateBoundingBox(x, y, ctx, selected, hover);
    this.labelModule.draw(ctx, x, y, selected, hover);
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {number} angle
   * @returns {number}
   */
  distanceToBorder(ctx, angle) {
    if (ctx) {
      this.resize(ctx);
    }
    const a = this.width * 0.5;
    const b = this.height * 0.5;
    const w = Math.sin(angle) * a;
    const h = Math.cos(angle) * b;
    return a * b / Math.sqrt(w * w + h * h);
  }
}

/**
 * An icon replacement for the default Node shape.
 * @augments NodeBase
 */
class Icon extends NodeBase {
  /**
   * @param {object} options
   * @param {object} body
   * @param {Label} labelModule
   */
  constructor(options, body, labelModule) {
    super(options, body, labelModule);
    this._setMargins(labelModule);
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx - Unused.
   * @param {boolean} [selected]
   * @param {boolean} [hover]
   */
  resize(ctx, selected, hover) {
    if (this.needsRefresh(selected, hover)) {
      this.iconSize = {
        width: Number(this.options.icon.size),
        height: Number(this.options.icon.size)
      };
      this.width = this.iconSize.width + this.margin.right + this.margin.left;
      this.height = this.iconSize.height + this.margin.top + this.margin.bottom;
      this.radius = 0.5 * this.width;
    }
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {number} x width
   * @param {number} y height
   * @param {boolean} selected
   * @param {boolean} hover
   * @param {ArrowOptions} values
   * @returns {object} Callbacks to draw later on higher layers.
   */
  draw(ctx, x, y, selected, hover, values) {
    this.resize(ctx, selected, hover);
    this.options.icon.size = this.options.icon.size || 50;
    this.left = x - this.width / 2;
    this.top = y - this.height / 2;
    this._icon(ctx, x, y, selected, hover, values);
    return {
      drawExternalLabel: () => {
        if (this.options.label !== undefined) {
          const iconTextSpacing = 5;
          this.labelModule.draw(ctx, this.left + this.iconSize.width / 2 + this.margin.left, y + this.height / 2 + iconTextSpacing, selected);
        }
        this.updateBoundingBox(x, y);
      }
    };
  }

  /**
   *
   * @param {number} x
   * @param {number} y
   */
  updateBoundingBox(x, y) {
    this.boundingBox.top = y - this.options.icon.size * 0.5;
    this.boundingBox.left = x - this.options.icon.size * 0.5;
    this.boundingBox.right = x + this.options.icon.size * 0.5;
    this.boundingBox.bottom = y + this.options.icon.size * 0.5;
    if (this.options.label !== undefined && this.labelModule.size.width > 0) {
      const iconTextSpacing = 5;
      this.boundingBox.left = Math.min(this.boundingBox.left, this.labelModule.size.left);
      this.boundingBox.right = Math.max(this.boundingBox.right, this.labelModule.size.left + this.labelModule.size.width);
      this.boundingBox.bottom = Math.max(this.boundingBox.bottom, this.boundingBox.bottom + this.labelModule.size.height + iconTextSpacing);
    }
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {number} x width
   * @param {number} y height
   * @param {boolean} selected
   * @param {boolean} hover - Unused
   * @param {ArrowOptions} values
   */
  _icon(ctx, x, y, selected, hover, values) {
    const iconSize = Number(this.options.icon.size);
    if (this.options.icon.code !== undefined) {
      ctx.font = [this.options.icon.weight != null ? this.options.icon.weight : selected ? "bold" : "",
      // If the weight is forced (for example to make Font Awesome 5 work
      // properly) substitute slightly bigger size for bold font face.
      (this.options.icon.weight != null && selected ? 5 : 0) + iconSize + "px", this.options.icon.face].join(" ");

      // draw icon
      ctx.fillStyle = this.options.icon.color || "black";
      ctx.textAlign = "center";
      ctx.textBaseline = "middle";

      // draw shadow if enabled
      this.enableShadow(ctx, values);
      ctx.fillText(this.options.icon.code, x, y);

      // disable shadows for other elements.
      this.disableShadow(ctx, values);
    } else {
      console.error("When using the icon shape, you need to define the code in the icon options object. This can be done per node or globally.");
    }
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {number} angle
   * @returns {number}
   */
  distanceToBorder(ctx, angle) {
    return this._distanceToBorder(ctx, angle);
  }
}

/**
 * An image-based replacement for the default Node shape.
 * @augments CircleImageBase
 */
let Image$2 = class Image extends CircleImageBase {
  /**
   * @param {object} options
   * @param {object} body
   * @param {Label} labelModule
   * @param {Image} imageObj
   * @param {Image} imageObjAlt
   */
  constructor(options, body, labelModule, imageObj, imageObjAlt) {
    super(options, body, labelModule);
    this.setImages(imageObj, imageObjAlt);
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx - Unused.
   * @param {boolean} [selected]
   * @param {boolean} [hover]
   */
  resize(ctx) {
    let selected = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.selected;
    let hover = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : this.hover;
    const imageAbsent = this.imageObj.src === undefined || this.imageObj.width === undefined || this.imageObj.height === undefined;
    if (imageAbsent) {
      const side = this.options.size * 2;
      this.width = side;
      this.height = side;
      return;
    }
    if (this.needsRefresh(selected, hover)) {
      this._resizeImage();
    }
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {number} x width
   * @param {number} y height
   * @param {boolean} selected
   * @param {boolean} hover
   * @param {ArrowOptions} values
   */
  draw(ctx, x, y, selected, hover, values) {
    ctx.save();
    this.switchImages(selected);
    this.resize();
    let labelX = x,
      labelY = y;
    if (this.options.shapeProperties.coordinateOrigin === "top-left") {
      this.left = x;
      this.top = y;
      labelX += this.width / 2;
      labelY += this.height / 2;
    } else {
      this.left = x - this.width / 2;
      this.top = y - this.height / 2;
    }
    if (this.options.shapeProperties.useBorderWithImage === true) {
      const neutralborderWidth = this.options.borderWidth;
      const selectionLineWidth = this.options.borderWidthSelected || 2 * this.options.borderWidth;
      const borderWidth = (selected ? selectionLineWidth : neutralborderWidth) / this.body.view.scale;
      ctx.lineWidth = Math.min(this.width, borderWidth);
      ctx.beginPath();
      let strokeStyle = selected ? this.options.color.highlight.border : hover ? this.options.color.hover.border : this.options.color.border;
      let fillStyle = selected ? this.options.color.highlight.background : hover ? this.options.color.hover.background : this.options.color.background;
      if (values.opacity !== undefined) {
        strokeStyle = overrideOpacity(strokeStyle, values.opacity);
        fillStyle = overrideOpacity(fillStyle, values.opacity);
      }
      // setup the line properties.
      ctx.strokeStyle = strokeStyle;

      // set a fillstyle
      ctx.fillStyle = fillStyle;

      // draw a rectangle to form the border around. This rectangle is filled so the opacity of a picture (in future vis releases?) can be used to tint the image
      ctx.rect(this.left - 0.5 * ctx.lineWidth, this.top - 0.5 * ctx.lineWidth, this.width + ctx.lineWidth, this.height + ctx.lineWidth);
      _fillInstanceProperty(ctx).call(ctx);
      this.performStroke(ctx, values);
      ctx.closePath();
    }
    this._drawImageAtPosition(ctx, values);
    this._drawImageLabel(ctx, labelX, labelY, selected, hover);
    this.updateBoundingBox(x, y);
    ctx.restore();
  }

  /**
   *
   * @param {number} x
   * @param {number} y
   */
  updateBoundingBox(x, y) {
    this.resize();
    if (this.options.shapeProperties.coordinateOrigin === "top-left") {
      this.left = x;
      this.top = y;
    } else {
      this.left = x - this.width / 2;
      this.top = y - this.height / 2;
    }
    this.boundingBox.left = this.left;
    this.boundingBox.top = this.top;
    this.boundingBox.bottom = this.top + this.height;
    this.boundingBox.right = this.left + this.width;
    if (this.options.label !== undefined && this.labelModule.size.width > 0) {
      this.boundingBox.left = Math.min(this.boundingBox.left, this.labelModule.size.left);
      this.boundingBox.right = Math.max(this.boundingBox.right, this.labelModule.size.left + this.labelModule.size.width);
      this.boundingBox.bottom = Math.max(this.boundingBox.bottom, this.boundingBox.bottom + this.labelOffset);
    }
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {number} angle
   * @returns {number}
   */
  distanceToBorder(ctx, angle) {
    return this._distanceToBorder(ctx, angle);
  }
};

/**
 * A Square Node/Cluster shape.
 * @augments ShapeBase
 */
class Square extends ShapeBase {
  /**
   * @param {object} options
   * @param {object} body
   * @param {Label} labelModule
   */
  constructor(options, body, labelModule) {
    super(options, body, labelModule);
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {number} x width
   * @param {number} y height
   * @param {boolean} selected
   * @param {boolean} hover
   * @param {ArrowOptions} values
   * @returns {object} Callbacks to draw later on higher layers.
   */
  draw(ctx, x, y, selected, hover, values) {
    return this._drawShape(ctx, "square", 2, x, y, selected, hover, values);
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {number} angle
   * @returns {number}
   */
  distanceToBorder(ctx, angle) {
    return this._distanceToBorder(ctx, angle);
  }
}

/**
 * A Hexagon Node/Cluster shape.
 * @augments ShapeBase
 */
class Hexagon extends ShapeBase {
  /**
   * @param {object} options
   * @param {object} body
   * @param {Label} labelModule
   */
  constructor(options, body, labelModule) {
    super(options, body, labelModule);
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {number} x width
   * @param {number} y height
   * @param {boolean} selected
   * @param {boolean} hover
   * @param {ArrowOptions} values
   * @returns {object} Callbacks to draw later on higher layers.
   */
  draw(ctx, x, y, selected, hover, values) {
    return this._drawShape(ctx, "hexagon", 4, x, y, selected, hover, values);
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {number} angle
   * @returns {number}
   */
  distanceToBorder(ctx, angle) {
    return this._distanceToBorder(ctx, angle);
  }
}

/**
 * A Star Node/Cluster shape.
 * @augments ShapeBase
 */
class Star extends ShapeBase {
  /**
   * @param {object} options
   * @param {object} body
   * @param {Label} labelModule
   */
  constructor(options, body, labelModule) {
    super(options, body, labelModule);
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {number} x width
   * @param {number} y height
   * @param {boolean} selected
   * @param {boolean} hover
   * @param {ArrowOptions} values
   * @returns {object} Callbacks to draw later on higher layers.
   */
  draw(ctx, x, y, selected, hover, values) {
    return this._drawShape(ctx, "star", 4, x, y, selected, hover, values);
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {number} angle
   * @returns {number}
   */
  distanceToBorder(ctx, angle) {
    return this._distanceToBorder(ctx, angle);
  }
}

/**
 * A text-based replacement for the default Node shape.
 * @augments NodeBase
 */
class Text extends NodeBase {
  /**
   * @param {object} options
   * @param {object} body
   * @param {Label} labelModule
   */
  constructor(options, body, labelModule) {
    super(options, body, labelModule);
    this._setMargins(labelModule);
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {boolean} selected
   * @param {boolean} hover
   */
  resize(ctx, selected, hover) {
    if (this.needsRefresh(selected, hover)) {
      this.textSize = this.labelModule.getTextSize(ctx, selected, hover);
      this.width = this.textSize.width + this.margin.right + this.margin.left;
      this.height = this.textSize.height + this.margin.top + this.margin.bottom;
      this.radius = 0.5 * this.width;
    }
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {number} x width
   * @param {number} y height
   * @param {boolean} selected
   * @param {boolean} hover
   * @param {ArrowOptions} values
   */
  draw(ctx, x, y, selected, hover, values) {
    this.resize(ctx, selected, hover);
    this.left = x - this.width / 2;
    this.top = y - this.height / 2;

    // draw shadow if enabled
    this.enableShadow(ctx, values);
    this.labelModule.draw(ctx, this.left + this.textSize.width / 2 + this.margin.left, this.top + this.textSize.height / 2 + this.margin.top, selected, hover);

    // disable shadows for other elements.
    this.disableShadow(ctx, values);
    this.updateBoundingBox(x, y, ctx, selected, hover);
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {number} angle
   * @returns {number}
   */
  distanceToBorder(ctx, angle) {
    return this._distanceToBorder(ctx, angle);
  }
}

/**
 * A Triangle Node/Cluster shape.
 * @augments ShapeBase
 */
let Triangle$1 = class Triangle extends ShapeBase {
  /**
   * @param {object} options
   * @param {object} body
   * @param {Label} labelModule
   */
  constructor(options, body, labelModule) {
    super(options, body, labelModule);
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {number} x
   * @param {number} y
   * @param {boolean} selected
   * @param {boolean} hover
   * @param {ArrowOptions} values
   * @returns {object} Callbacks to draw later on higher layers.
   */
  draw(ctx, x, y, selected, hover, values) {
    return this._drawShape(ctx, "triangle", 3, x, y, selected, hover, values);
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {number} angle
   * @returns {number}
   */
  distanceToBorder(ctx, angle) {
    return this._distanceToBorder(ctx, angle);
  }
};

/**
 * A downward facing Triangle Node/Cluster shape.
 * @augments ShapeBase
 */
class TriangleDown extends ShapeBase {
  /**
   * @param {object} options
   * @param {object} body
   * @param {Label} labelModule
   */
  constructor(options, body, labelModule) {
    super(options, body, labelModule);
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {number} x
   * @param {number} y
   * @param {boolean} selected
   * @param {boolean} hover
   * @param {ArrowOptions} values
   * @returns {object} Callbacks to draw later on higher layers.
   */
  draw(ctx, x, y, selected, hover, values) {
    return this._drawShape(ctx, "triangleDown", 3, x, y, selected, hover, values);
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {number} angle
   * @returns {number}
   */
  distanceToBorder(ctx, angle) {
    return this._distanceToBorder(ctx, angle);
  }
}

function ownKeys$2(e, r) { var t = _Object$keys(e); if (_Object$getOwnPropertySymbols) { var o = _Object$getOwnPropertySymbols(e); r && (o = _filterInstanceProperty(o).call(o, function (r) { return _Object$getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread$2(e) { for (var r = 1; r < arguments.length; r++) { var _context5, _context6; var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? _forEachInstanceProperty(_context5 = ownKeys$2(Object(t), !0)).call(_context5, function (r) { _defineProperty(e, r, t[r]); }) : _Object$getOwnPropertyDescriptors ? _Object$defineProperties(e, _Object$getOwnPropertyDescriptors(t)) : _forEachInstanceProperty(_context6 = ownKeys$2(Object(t))).call(_context6, function (r) { _Object$defineProperty(e, r, _Object$getOwnPropertyDescriptor(t, r)); }); } return e; }

/**
 * A node. A node can be connected to other nodes via one or multiple edges.
 */
class Node {
  /**
   *
   * @param {object} options An object containing options for the node. All
   *                            options are optional, except for the id.
   *                              {number} id     Id of the node. Required
   *                              {string} label  Text label for the node
   *                              {number} x      Horizontal position of the node
   *                              {number} y      Vertical position of the node
   *                              {string} shape  Node shape
   *                              {string} image  An image url
   *                              {string} title  A title text, can be HTML
   *                              {anytype} group A group name or number
   * @param {object} body               Shared state of current network instance
   * @param {Network.Images} imagelist  A list with images. Only needed when the node has an image
   * @param {Groups} grouplist          A list with groups. Needed for retrieving group options
   * @param {object} globalOptions      Current global node options; these serve as defaults for the node instance
   * @param {object} defaultOptions     Global default options for nodes; note that this is also the prototype
   *                                    for parameter `globalOptions`.
   */
  constructor(options, body, imagelist, grouplist, globalOptions, defaultOptions) {
    this.options = bridgeObject(globalOptions);
    this.globalOptions = globalOptions;
    this.defaultOptions = defaultOptions;
    this.body = body;
    this.edges = []; // all edges connected to this node

    // set defaults for the options
    this.id = undefined;
    this.imagelist = imagelist;
    this.grouplist = grouplist;

    // state options
    this.x = undefined;
    this.y = undefined;
    this.baseSize = this.options.size;
    this.baseFontSize = this.options.font.size;
    this.predefinedPosition = false; // used to check if initial fit should just take the range or approximate
    this.selected = false;
    this.hover = false;
    this.labelModule = new Label(this.body, this.options, false /* Not edge label */);

    this.setOptions(options);
  }

  /**
   * Attach a edge to the node
   * @param {Edge} edge
   */
  attachEdge(edge) {
    var _context;
    if (_indexOfInstanceProperty(_context = this.edges).call(_context, edge) === -1) {
      this.edges.push(edge);
    }
  }

  /**
   * Detach a edge from the node
   * @param {Edge} edge
   */
  detachEdge(edge) {
    var _context2;
    const index = _indexOfInstanceProperty(_context2 = this.edges).call(_context2, edge);
    if (index != -1) {
      var _context3;
      _spliceInstanceProperty(_context3 = this.edges).call(_context3, index, 1);
    }
  }

  /**
   * Set or overwrite options for the node
   * @param {object} options an object with options
   * @returns {null|boolean}
   */
  setOptions(options) {
    const currentShape = this.options.shape;
    if (!options) {
      return; // Note that the return value will be 'undefined'! This is OK.
    }

    // Save the color for later.
    // This is necessary in order to prevent local color from being overwritten by group color.
    // TODO: To prevent such workarounds the way options are handled should be rewritten from scratch.
    // This is not the only problem with current options handling.
    if (typeof options.color !== "undefined") {
      this._localColor = options.color;
    }

    // basic options
    if (options.id !== undefined) {
      this.id = options.id;
    }
    if (this.id === undefined) {
      throw new Error("Node must have an id");
    }
    Node.checkMass(options, this.id);

    // set these options locally
    // clear x and y positions
    if (options.x !== undefined) {
      if (options.x === null) {
        this.x = undefined;
        this.predefinedPosition = false;
      } else {
        this.x = _parseInt$1(options.x);
        this.predefinedPosition = true;
      }
    }
    if (options.y !== undefined) {
      if (options.y === null) {
        this.y = undefined;
        this.predefinedPosition = false;
      } else {
        this.y = _parseInt$1(options.y);
        this.predefinedPosition = true;
      }
    }
    if (options.size !== undefined) {
      this.baseSize = options.size;
    }
    if (options.value !== undefined) {
      options.value = _parseFloat$1(options.value);
    }

    // this transforms all shorthands into fully defined options
    Node.parseOptions(this.options, options, true, this.globalOptions, this.grouplist);
    const pile = [options, this.options, this.defaultOptions];
    this.chooser = choosify("node", pile);
    this._load_images();
    this.updateLabelModule(options);

    // Need to set local opacity after `this.updateLabelModule(options);` because `this.updateLabelModule(options);` overrites local opacity with group opacity
    if (options.opacity !== undefined && Node.checkOpacity(options.opacity)) {
      this.options.opacity = options.opacity;
    }
    this.updateShape(currentShape);
    return options.hidden !== undefined || options.physics !== undefined;
  }

  /**
   * Load the images from the options, for the nodes that need them.
   *
   * Images are always loaded, even if they are not used in the current shape.
   * The user may switch to an image shape later on.
   * @private
   */
  _load_images() {
    if (this.options.shape === "circularImage" || this.options.shape === "image") {
      if (this.options.image === undefined) {
        throw new Error("Option image must be defined for node type '" + this.options.shape + "'");
      }
    }
    if (this.options.image === undefined) {
      return;
    }
    if (this.imagelist === undefined) {
      throw new Error("Internal Error: No images provided");
    }
    if (typeof this.options.image === "string") {
      this.imageObj = this.imagelist.load(this.options.image, this.options.brokenImage, this.id);
    } else {
      if (this.options.image.unselected === undefined) {
        throw new Error("No unselected image provided");
      }
      this.imageObj = this.imagelist.load(this.options.image.unselected, this.options.brokenImage, this.id);
      if (this.options.image.selected !== undefined) {
        this.imageObjAlt = this.imagelist.load(this.options.image.selected, this.options.brokenImage, this.id);
      } else {
        this.imageObjAlt = undefined;
      }
    }
  }

  /**
   * Check that opacity is only between 0 and 1
   * @param {number} opacity
   * @returns {boolean}
   */
  static checkOpacity(opacity) {
    return 0 <= opacity && opacity <= 1;
  }

  /**
   * Check that origin is 'center' or 'top-left'
   * @param {string} origin
   * @returns {boolean}
   */
  static checkCoordinateOrigin(origin) {
    return origin === undefined || origin === "center" || origin === "top-left";
  }

  /**
   * Copy group option values into the node options.
   *
   * The group options override the global node options, so the copy of group options
   * must happen *after* the global node options have been set.
   *
   * This method must also be called also if the global node options have changed and the group options did not.
   * @param {object} parentOptions
   * @param {object} newOptions  new values for the options, currently only passed in for check
   * @param {object} groupList
   */
  static updateGroupOptions(parentOptions, newOptions, groupList) {
    var _context4;
    if (groupList === undefined) return; // No groups, nothing to do

    const group = parentOptions.group;

    // paranoia: the selected group is already merged into node options, check.
    if (newOptions !== undefined && newOptions.group !== undefined && group !== newOptions.group) {
      throw new Error("updateGroupOptions: group values in options don't match.");
    }
    const hasGroup = typeof group === "number" || typeof group === "string" && group != "";
    if (!hasGroup) return; // current node has no group, no need to merge

    const groupObj = groupList.get(group);
    if (groupObj.opacity !== undefined && newOptions.opacity === undefined) {
      if (!Node.checkOpacity(groupObj.opacity)) {
        console.error("Invalid option for node opacity. Value must be between 0 and 1, found: " + groupObj.opacity);
        groupObj.opacity = undefined;
      }
    }

    // Skip any new option to avoid them being overridden by the group options.
    const skipProperties = _filterInstanceProperty(_context4 = _Object$getOwnPropertyNames(newOptions)).call(_context4, p => newOptions[p] != null);
    // Always skip merging group font options into parent; these are required to be distinct for labels
    skipProperties.push("font");
    selectiveNotDeepExtend(skipProperties, parentOptions, groupObj);

    // the color object needs to be completely defined.
    // Since groups can partially overwrite the colors, we parse it again, just in case.
    parentOptions.color = parseColor(parentOptions.color);
  }

  /**
   * This process all possible shorthands in the new options and makes sure that the parentOptions are fully defined.
   * Static so it can also be used by the handler.
   * @param {object} parentOptions
   * @param {object} newOptions
   * @param {boolean} [allowDeletion]
   * @param {object} [globalOptions]
   * @param {object} [groupList]
   * @static
   */
  static parseOptions(parentOptions, newOptions) {
    let allowDeletion = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
    let globalOptions = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};
    let groupList = arguments.length > 4 ? arguments[4] : undefined;
    const fields = ["color", "fixed", "shadow"];
    selectiveNotDeepExtend(fields, parentOptions, newOptions, allowDeletion);
    Node.checkMass(newOptions);
    if (parentOptions.opacity !== undefined) {
      if (!Node.checkOpacity(parentOptions.opacity)) {
        console.error("Invalid option for node opacity. Value must be between 0 and 1, found: " + parentOptions.opacity);
        parentOptions.opacity = undefined;
      }
    }
    if (newOptions.opacity !== undefined) {
      if (!Node.checkOpacity(newOptions.opacity)) {
        console.error("Invalid option for node opacity. Value must be between 0 and 1, found: " + newOptions.opacity);
        newOptions.opacity = undefined;
      }
    }
    if (newOptions.shapeProperties && !Node.checkCoordinateOrigin(newOptions.shapeProperties.coordinateOrigin)) {
      console.error("Invalid option for node coordinateOrigin, found: " + newOptions.shapeProperties.coordinateOrigin);
    }

    // merge the shadow options into the parent.
    mergeOptions(parentOptions, newOptions, "shadow", globalOptions);

    // individual shape newOptions
    if (newOptions.color !== undefined && newOptions.color !== null) {
      const parsedColor = parseColor(newOptions.color);
      fillIfDefined(parentOptions.color, parsedColor);
    } else if (allowDeletion === true && newOptions.color === null) {
      parentOptions.color = bridgeObject(globalOptions.color); // set the object back to the global options
    }

    // handle the fixed options
    if (newOptions.fixed !== undefined && newOptions.fixed !== null) {
      if (typeof newOptions.fixed === "boolean") {
        parentOptions.fixed.x = newOptions.fixed;
        parentOptions.fixed.y = newOptions.fixed;
      } else {
        if (newOptions.fixed.x !== undefined && typeof newOptions.fixed.x === "boolean") {
          parentOptions.fixed.x = newOptions.fixed.x;
        }
        if (newOptions.fixed.y !== undefined && typeof newOptions.fixed.y === "boolean") {
          parentOptions.fixed.y = newOptions.fixed.y;
        }
      }
    }
    if (allowDeletion === true && newOptions.font === null) {
      parentOptions.font = bridgeObject(globalOptions.font); // set the object back to the global options
    }

    Node.updateGroupOptions(parentOptions, newOptions, groupList);

    // handle the scaling options, specifically the label part
    if (newOptions.scaling !== undefined) {
      mergeOptions(parentOptions.scaling, newOptions.scaling, "label", globalOptions.scaling);
    }
  }

  /**
   *
   * @returns {{color: *, borderWidth: *, borderColor: *, size: *, borderDashes: (boolean|Array|allOptions.nodes.shapeProperties.borderDashes|{boolean, array}), borderRadius: (number|allOptions.nodes.shapeProperties.borderRadius|{number}|Array), shadow: *, shadowColor: *, shadowSize: *, shadowX: *, shadowY: *}}
   */
  getFormattingValues() {
    const values = {
      color: this.options.color.background,
      opacity: this.options.opacity,
      borderWidth: this.options.borderWidth,
      borderColor: this.options.color.border,
      size: this.options.size,
      borderDashes: this.options.shapeProperties.borderDashes,
      borderRadius: this.options.shapeProperties.borderRadius,
      shadow: this.options.shadow.enabled,
      shadowColor: this.options.shadow.color,
      shadowSize: this.options.shadow.size,
      shadowX: this.options.shadow.x,
      shadowY: this.options.shadow.y
    };
    if (this.selected || this.hover) {
      if (this.chooser === true) {
        if (this.selected) {
          if (this.options.borderWidthSelected != null) {
            values.borderWidth = this.options.borderWidthSelected;
          } else {
            values.borderWidth *= 2;
          }
          values.color = this.options.color.highlight.background;
          values.borderColor = this.options.color.highlight.border;
          values.shadow = this.options.shadow.enabled;
        } else if (this.hover) {
          values.color = this.options.color.hover.background;
          values.borderColor = this.options.color.hover.border;
          values.shadow = this.options.shadow.enabled;
        }
      } else if (typeof this.chooser === "function") {
        this.chooser(values, this.options.id, this.selected, this.hover);
        if (values.shadow === false) {
          if (values.shadowColor !== this.options.shadow.color || values.shadowSize !== this.options.shadow.size || values.shadowX !== this.options.shadow.x || values.shadowY !== this.options.shadow.y) {
            values.shadow = true;
          }
        }
      }
    } else {
      values.shadow = this.options.shadow.enabled;
    }
    if (this.options.opacity !== undefined) {
      const opacity = this.options.opacity;
      values.borderColor = overrideOpacity(values.borderColor, opacity);
      values.color = overrideOpacity(values.color, opacity);
      values.shadowColor = overrideOpacity(values.shadowColor, opacity);
    }
    return values;
  }

  /**
   *
   * @param {object} options
   */
  updateLabelModule(options) {
    if (this.options.label === undefined || this.options.label === null) {
      this.options.label = "";
    }
    Node.updateGroupOptions(this.options, _objectSpread$2(_objectSpread$2({}, options), {}, {
      color: options && options.color || this._localColor || undefined
    }), this.grouplist);

    //
    // Note:The prototype chain for this.options is:
    //
    // this.options ->    NodesHandler.options    -> NodesHandler.defaultOptions
    //                 (also: this.globalOptions)
    //
    // Note that the prototypes are mentioned explicitly in the pile list below;
    // WE DON'T WANT THE ORDER OF THE PROTOTYPES!!!! At least, not for font handling of labels.
    // This is a good indication that the prototype usage of options is deficient.
    //
    const currentGroup = this.grouplist.get(this.options.group, false);
    const pile = [options,
    // new options
    this.options,
    // current node options, see comment above for prototype
    currentGroup,
    // group options, if any
    this.globalOptions,
    // Currently set global node options
    this.defaultOptions // Default global node options
    ];

    this.labelModule.update(this.options, pile);
    if (this.labelModule.baseSize !== undefined) {
      this.baseFontSize = this.labelModule.baseSize;
    }
  }

  /**
   *
   * @param {string} currentShape
   */
  updateShape(currentShape) {
    if (currentShape === this.options.shape && this.shape) {
      this.shape.setOptions(this.options, this.imageObj, this.imageObjAlt);
    } else {
      // choose draw method depending on the shape
      switch (this.options.shape) {
        case "box":
          this.shape = new Box$1(this.options, this.body, this.labelModule);
          break;
        case "circle":
          this.shape = new Circle$1(this.options, this.body, this.labelModule);
          break;
        case "circularImage":
          this.shape = new CircularImage(this.options, this.body, this.labelModule, this.imageObj, this.imageObjAlt);
          break;
        case "custom":
          this.shape = new CustomShape(this.options, this.body, this.labelModule, this.options.ctxRenderer);
          break;
        case "database":
          this.shape = new Database(this.options, this.body, this.labelModule);
          break;
        case "diamond":
          this.shape = new Diamond$1(this.options, this.body, this.labelModule);
          break;
        case "dot":
          this.shape = new Dot(this.options, this.body, this.labelModule);
          break;
        case "ellipse":
          this.shape = new Ellipse(this.options, this.body, this.labelModule);
          break;
        case "icon":
          this.shape = new Icon(this.options, this.body, this.labelModule);
          break;
        case "image":
          this.shape = new Image$2(this.options, this.body, this.labelModule, this.imageObj, this.imageObjAlt);
          break;
        case "square":
          this.shape = new Square(this.options, this.body, this.labelModule);
          break;
        case "hexagon":
          this.shape = new Hexagon(this.options, this.body, this.labelModule);
          break;
        case "star":
          this.shape = new Star(this.options, this.body, this.labelModule);
          break;
        case "text":
          this.shape = new Text(this.options, this.body, this.labelModule);
          break;
        case "triangle":
          this.shape = new Triangle$1(this.options, this.body, this.labelModule);
          break;
        case "triangleDown":
          this.shape = new TriangleDown(this.options, this.body, this.labelModule);
          break;
        default:
          this.shape = new Ellipse(this.options, this.body, this.labelModule);
          break;
      }
    }
    this.needsRefresh();
  }

  /**
   * select this node
   */
  select() {
    this.selected = true;
    this.needsRefresh();
  }

  /**
   * unselect this node
   */
  unselect() {
    this.selected = false;
    this.needsRefresh();
  }

  /**
   * Reset the calculated size of the node, forces it to recalculate its size
   */
  needsRefresh() {
    this.shape.refreshNeeded = true;
  }

  /**
   * get the title of this node.
   * @returns {string} title    The title of the node, or undefined when no title
   *                           has been set.
   */
  getTitle() {
    return this.options.title;
  }

  /**
   * Calculate the distance to the border of the Node
   * @param {CanvasRenderingContext2D}   ctx
   * @param {number} angle        Angle in radians
   * @returns {number} distance   Distance to the border in pixels
   */
  distanceToBorder(ctx, angle) {
    return this.shape.distanceToBorder(ctx, angle);
  }

  /**
   * Check if this node has a fixed x and y position
   * @returns {boolean}      true if fixed, false if not
   */
  isFixed() {
    return this.options.fixed.x && this.options.fixed.y;
  }

  /**
   * check if this node is selecte
   * @returns {boolean} selected   True if node is selected, else false
   */
  isSelected() {
    return this.selected;
  }

  /**
   * Retrieve the value of the node. Can be undefined
   * @returns {number} value
   */
  getValue() {
    return this.options.value;
  }

  /**
   * Get the current dimensions of the label
   * @returns {rect}
   */
  getLabelSize() {
    return this.labelModule.size();
  }

  /**
   * Adjust the value range of the node. The node will adjust it's size
   * based on its value.
   * @param {number} min
   * @param {number} max
   * @param {number} total
   */
  setValueRange(min, max, total) {
    if (this.options.value !== undefined) {
      const scale = this.options.scaling.customScalingFunction(min, max, total, this.options.value);
      const sizeDiff = this.options.scaling.max - this.options.scaling.min;
      if (this.options.scaling.label.enabled === true) {
        const fontDiff = this.options.scaling.label.max - this.options.scaling.label.min;
        this.options.font.size = this.options.scaling.label.min + scale * fontDiff;
      }
      this.options.size = this.options.scaling.min + scale * sizeDiff;
    } else {
      this.options.size = this.baseSize;
      this.options.font.size = this.baseFontSize;
    }
    this.updateLabelModule();
  }

  /**
   * Draw this node in the given canvas
   * The 2d context of a HTML canvas can be retrieved by canvas.getContext("2d");
   * @param {CanvasRenderingContext2D}   ctx
   * @returns {object} Callbacks to draw later on higher layers.
   */
  draw(ctx) {
    const values = this.getFormattingValues();
    return this.shape.draw(ctx, this.x, this.y, this.selected, this.hover, values) || {};
  }

  /**
   * Update the bounding box of the shape
   * @param {CanvasRenderingContext2D}   ctx
   */
  updateBoundingBox(ctx) {
    this.shape.updateBoundingBox(this.x, this.y, ctx);
  }

  /**
   * Recalculate the size of this node in the given canvas
   * The 2d context of a HTML canvas can be retrieved by canvas.getContext("2d");
   * @param {CanvasRenderingContext2D}   ctx
   */
  resize(ctx) {
    const values = this.getFormattingValues();
    this.shape.resize(ctx, this.selected, this.hover, values);
  }

  /**
   * Determine all visual elements of this node instance, in which the given
   * point falls within the bounding shape.
   * @param {point} point
   * @returns {Array.<nodeClickItem|nodeLabelClickItem>} list with the items which are on the point
   */
  getItemsOnPoint(point) {
    const ret = [];
    if (this.labelModule.visible()) {
      if (pointInRect(this.labelModule.getSize(), point)) {
        ret.push({
          nodeId: this.id,
          labelId: 0
        });
      }
    }
    if (pointInRect(this.shape.boundingBox, point)) {
      ret.push({
        nodeId: this.id
      });
    }
    return ret;
  }

  /**
   * Check if this object is overlapping with the provided object
   * @param {object} obj   an object with parameters left, top, right, bottom
   * @returns {boolean}     True if location is located on node
   */
  isOverlappingWith(obj) {
    return this.shape.left < obj.right && this.shape.left + this.shape.width > obj.left && this.shape.top < obj.bottom && this.shape.top + this.shape.height > obj.top;
  }

  /**
   * Check if this object is overlapping with the provided object
   * @param {object} obj   an object with parameters left, top, right, bottom
   * @returns {boolean}     True if location is located on node
   */
  isBoundingBoxOverlappingWith(obj) {
    return this.shape.boundingBox.left < obj.right && this.shape.boundingBox.right > obj.left && this.shape.boundingBox.top < obj.bottom && this.shape.boundingBox.bottom > obj.top;
  }

  /**
   * Check valid values for mass
   *
   * The mass may not be negative or zero. If it is, reset to 1
   * @param {object} options
   * @param {Node.id} id
   * @static
   */
  static checkMass(options, id) {
    if (options.mass !== undefined && options.mass <= 0) {
      let strId = "";
      if (id !== undefined) {
        strId = " in node id: " + id;
      }
      console.error("%cNegative or zero mass disallowed" + strId + ", setting mass to 1.", VALIDATOR_PRINT_STYLE);
      options.mass = 1;
    }
  }
}

/**
 * Handler for Nodes
 */
class NodesHandler {
  /**
   * @param {object} body
   * @param {Images} images
   * @param {Array.<Group>} groups
   * @param {LayoutEngine} layoutEngine
   */
  constructor(body, images, groups, layoutEngine) {
    var _context;
    this.body = body;
    this.images = images;
    this.groups = groups;
    this.layoutEngine = layoutEngine;

    // create the node API in the body container
    this.body.functions.createNode = _bindInstanceProperty(_context = this.create).call(_context, this);
    this.nodesListeners = {
      add: (event, params) => {
        this.add(params.items);
      },
      update: (event, params) => {
        this.update(params.items, params.data, params.oldData);
      },
      remove: (event, params) => {
        this.remove(params.items);
      }
    };
    this.defaultOptions = {
      borderWidth: 1,
      borderWidthSelected: undefined,
      brokenImage: undefined,
      color: {
        border: "#2B7CE9",
        background: "#97C2FC",
        highlight: {
          border: "#2B7CE9",
          background: "#D2E5FF"
        },
        hover: {
          border: "#2B7CE9",
          background: "#D2E5FF"
        }
      },
      opacity: undefined,
      // number between 0 and 1
      fixed: {
        x: false,
        y: false
      },
      font: {
        color: "#343434",
        size: 14,
        // px
        face: "arial",
        background: "none",
        strokeWidth: 0,
        // px
        strokeColor: "#ffffff",
        align: "center",
        vadjust: 0,
        multi: false,
        bold: {
          mod: "bold"
        },
        boldital: {
          mod: "bold italic"
        },
        ital: {
          mod: "italic"
        },
        mono: {
          mod: "",
          size: 15,
          // px
          face: "monospace",
          vadjust: 2
        }
      },
      group: undefined,
      hidden: false,
      icon: {
        face: "FontAwesome",
        //'FontAwesome',
        code: undefined,
        //'\uf007',
        size: 50,
        //50,
        color: "#2B7CE9" //'#aa00ff'
      },

      image: undefined,
      // --> URL
      imagePadding: {
        // only for image shape
        top: 0,
        right: 0,
        bottom: 0,
        left: 0
      },
      label: undefined,
      labelHighlightBold: true,
      level: undefined,
      margin: {
        top: 5,
        right: 5,
        bottom: 5,
        left: 5
      },
      mass: 1,
      physics: true,
      scaling: {
        min: 10,
        max: 30,
        label: {
          enabled: false,
          min: 14,
          max: 30,
          maxVisible: 30,
          drawThreshold: 5
        },
        customScalingFunction: function (min, max, total, value) {
          if (max === min) {
            return 0.5;
          } else {
            const scale = 1 / (max - min);
            return Math.max(0, (value - min) * scale);
          }
        }
      },
      shadow: {
        enabled: false,
        color: "rgba(0,0,0,0.5)",
        size: 10,
        x: 5,
        y: 5
      },
      shape: "ellipse",
      shapeProperties: {
        borderDashes: false,
        // only for borders
        borderRadius: 6,
        // only for box shape
        interpolation: true,
        // only for image and circularImage shapes
        useImageSize: false,
        // only for image and circularImage shapes
        useBorderWithImage: false,
        // only for image shape
        coordinateOrigin: "center" // only for image and circularImage shapes
      },

      size: 25,
      title: undefined,
      value: undefined,
      x: undefined,
      y: undefined
    };

    // Protect from idiocy
    if (this.defaultOptions.mass <= 0) {
      throw "Internal error: mass in defaultOptions of NodesHandler may not be zero or negative";
    }
    this.options = bridgeObject(this.defaultOptions);
    this.bindEventListeners();
  }

  /**
   * Binds event listeners
   */
  bindEventListeners() {
    var _context2, _context3;
    // refresh the nodes. Used when reverting from hierarchical layout
    this.body.emitter.on("refreshNodes", _bindInstanceProperty(_context2 = this.refresh).call(_context2, this));
    this.body.emitter.on("refresh", _bindInstanceProperty(_context3 = this.refresh).call(_context3, this));
    this.body.emitter.on("destroy", () => {
      forEach$1(this.nodesListeners, (callback, event) => {
        if (this.body.data.nodes) this.body.data.nodes.off(event, callback);
      });
      delete this.body.functions.createNode;
      delete this.nodesListeners.add;
      delete this.nodesListeners.update;
      delete this.nodesListeners.remove;
      delete this.nodesListeners;
    });
  }

  /**
   *
   * @param {object} options
   */
  setOptions(options) {
    if (options !== undefined) {
      Node.parseOptions(this.options, options);

      // Need to set opacity here because Node.parseOptions is also used for groups,
      // if you set opacity in Node.parseOptions it overwrites group opacity.
      if (options.opacity !== undefined) {
        if (_Number$isNaN(options.opacity) || !_Number$isFinite(options.opacity) || options.opacity < 0 || options.opacity > 1) {
          console.error("Invalid option for node opacity. Value must be between 0 and 1, found: " + options.opacity);
        } else {
          this.options.opacity = options.opacity;
        }
      }

      // update the shape in all nodes
      if (options.shape !== undefined) {
        for (const nodeId in this.body.nodes) {
          if (Object.prototype.hasOwnProperty.call(this.body.nodes, nodeId)) {
            this.body.nodes[nodeId].updateShape();
          }
        }
      }

      // Update the labels of nodes if any relevant options changed.
      if (typeof options.font !== "undefined" || typeof options.widthConstraint !== "undefined" || typeof options.heightConstraint !== "undefined") {
        for (const nodeId of _Object$keys(this.body.nodes)) {
          this.body.nodes[nodeId].updateLabelModule();
          this.body.nodes[nodeId].needsRefresh();
        }
      }

      // update the shape size in all nodes
      if (options.size !== undefined) {
        for (const nodeId in this.body.nodes) {
          if (Object.prototype.hasOwnProperty.call(this.body.nodes, nodeId)) {
            this.body.nodes[nodeId].needsRefresh();
          }
        }
      }

      // update the state of the variables if needed
      if (options.hidden !== undefined || options.physics !== undefined) {
        this.body.emitter.emit("_dataChanged");
      }
    }
  }

  /**
   * Set a data set with nodes for the network
   * @param {Array | DataSet | DataView} nodes         The data containing the nodes.
   * @param {boolean} [doNotEmit] - Suppress data changed event.
   * @private
   */
  setData(nodes) {
    let doNotEmit = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
    const oldNodesData = this.body.data.nodes;
    if (isDataViewLike("id", nodes)) {
      this.body.data.nodes = nodes;
    } else if (_Array$isArray(nodes)) {
      this.body.data.nodes = new DataSet();
      this.body.data.nodes.add(nodes);
    } else if (!nodes) {
      this.body.data.nodes = new DataSet();
    } else {
      throw new TypeError("Array or DataSet expected");
    }
    if (oldNodesData) {
      // unsubscribe from old dataset
      forEach$1(this.nodesListeners, function (callback, event) {
        oldNodesData.off(event, callback);
      });
    }

    // remove drawn nodes
    this.body.nodes = {};
    if (this.body.data.nodes) {
      // subscribe to new dataset
      const me = this;
      forEach$1(this.nodesListeners, function (callback, event) {
        me.body.data.nodes.on(event, callback);
      });

      // draw all new nodes
      const ids = this.body.data.nodes.getIds();
      this.add(ids, true);
    }
    if (doNotEmit === false) {
      this.body.emitter.emit("_dataChanged");
    }
  }

  /**
   * Add nodes
   * @param {number[] | string[]} ids
   * @param {boolean} [doNotEmit]
   * @private
   */
  add(ids) {
    let doNotEmit = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
    let id;
    const newNodes = [];
    for (let i = 0; i < ids.length; i++) {
      id = ids[i];
      const properties = this.body.data.nodes.get(id);
      const node = this.create(properties);
      newNodes.push(node);
      this.body.nodes[id] = node; // note: this may replace an existing node
    }

    this.layoutEngine.positionInitially(newNodes);
    if (doNotEmit === false) {
      this.body.emitter.emit("_dataChanged");
    }
  }

  /**
   * Update existing nodes, or create them when not yet existing
   * @param {number[] | string[]} ids id's of changed nodes
   * @param {Array} changedData array with changed data
   * @param {Array|undefined} oldData optional; array with previous data
   * @private
   */
  update(ids, changedData, oldData) {
    const nodes = this.body.nodes;
    let dataChanged = false;
    for (let i = 0; i < ids.length; i++) {
      const id = ids[i];
      let node = nodes[id];
      const data = changedData[i];
      if (node !== undefined) {
        // update node
        if (node.setOptions(data)) {
          dataChanged = true;
        }
      } else {
        dataChanged = true;
        // create node
        node = this.create(data);
        nodes[id] = node;
      }
    }
    if (!dataChanged && oldData !== undefined) {
      // Check for any changes which should trigger a layout recalculation
      // For now, this is just 'level' for hierarchical layout
      // Assumption: old and new data arranged in same order; at time of writing, this holds.
      dataChanged = _someInstanceProperty(changedData).call(changedData, function (newValue, index) {
        const oldValue = oldData[index];
        return oldValue && oldValue.level !== newValue.level;
      });
    }
    if (dataChanged === true) {
      this.body.emitter.emit("_dataChanged");
    } else {
      this.body.emitter.emit("_dataUpdated");
    }
  }

  /**
   * Remove existing nodes. If nodes do not exist, the method will just ignore it.
   * @param {number[] | string[]} ids
   * @private
   */
  remove(ids) {
    const nodes = this.body.nodes;
    for (let i = 0; i < ids.length; i++) {
      const id = ids[i];
      delete nodes[id];
    }
    this.body.emitter.emit("_dataChanged");
  }

  /**
   * create a node
   * @param {object} properties
   * @param {class} [constructorClass]
   * @returns {*}
   */
  create(properties) {
    let constructorClass = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : Node;
    return new constructorClass(properties, this.body, this.images, this.groups, this.options, this.defaultOptions);
  }

  /**
   *
   * @param {boolean} [clearPositions]
   */
  refresh() {
    let clearPositions = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
    forEach$1(this.body.nodes, (node, nodeId) => {
      const data = this.body.data.nodes.get(nodeId);
      if (data !== undefined) {
        if (clearPositions === true) {
          node.setOptions({
            x: null,
            y: null
          });
        }
        node.setOptions({
          fixed: false
        });
        node.setOptions(data);
      }
    });
  }

  /**
   * Returns the positions of the nodes.
   * @param {Array.<Node.id> | string} [ids]  --> optional, can be array of nodeIds, can be string
   * @returns {{}}
   */
  getPositions(ids) {
    const dataArray = {};
    if (ids !== undefined) {
      if (_Array$isArray(ids) === true) {
        for (let i = 0; i < ids.length; i++) {
          if (this.body.nodes[ids[i]] !== undefined) {
            const node = this.body.nodes[ids[i]];
            dataArray[ids[i]] = {
              x: Math.round(node.x),
              y: Math.round(node.y)
            };
          }
        }
      } else {
        if (this.body.nodes[ids] !== undefined) {
          const node = this.body.nodes[ids];
          dataArray[ids] = {
            x: Math.round(node.x),
            y: Math.round(node.y)
          };
        }
      }
    } else {
      for (let i = 0; i < this.body.nodeIndices.length; i++) {
        const node = this.body.nodes[this.body.nodeIndices[i]];
        dataArray[this.body.nodeIndices[i]] = {
          x: Math.round(node.x),
          y: Math.round(node.y)
        };
      }
    }
    return dataArray;
  }

  /**
   * Retrieves the x y position of a specific id.
   * @param {string} id The id to retrieve.
   * @throws {TypeError} If no id is included.
   * @throws {ReferenceError} If an invalid id is provided.
   * @returns {{ x: number, y: number }} Returns X, Y canvas position of the node with given id.
   */
  getPosition(id) {
    if (id == undefined) {
      throw new TypeError("No id was specified for getPosition method.");
    } else if (this.body.nodes[id] == undefined) {
      throw new ReferenceError("NodeId provided for getPosition does not exist. Provided: ".concat(id));
    } else {
      return {
        x: Math.round(this.body.nodes[id].x),
        y: Math.round(this.body.nodes[id].y)
      };
    }
  }

  /**
   * Load the XY positions of the nodes into the dataset.
   */
  storePositions() {
    // todo: add support for clusters and hierarchical.
    const dataArray = [];
    const dataset = this.body.data.nodes.getDataSet();
    for (const dsNode of dataset.get()) {
      const id = dsNode.id;
      const bodyNode = this.body.nodes[id];
      const x = Math.round(bodyNode.x);
      const y = Math.round(bodyNode.y);
      if (dsNode.x !== x || dsNode.y !== y) {
        dataArray.push({
          id,
          x,
          y
        });
      }
    }
    dataset.update(dataArray);
  }

  /**
   * get the bounding box of a node.
   * @param {Node.id} nodeId
   * @returns {j|*}
   */
  getBoundingBox(nodeId) {
    if (this.body.nodes[nodeId] !== undefined) {
      return this.body.nodes[nodeId].shape.boundingBox;
    }
  }

  /**
   * Get the Ids of nodes connected to this node.
   * @param {Node.id} nodeId
   * @param {'to'|'from'|undefined} direction values 'from' and 'to' select respectively parent and child nodes only.
   *                                          Any other value returns both parent and child nodes.
   * @returns {Array}
   */
  getConnectedNodes(nodeId, direction) {
    const nodeList = [];
    if (this.body.nodes[nodeId] !== undefined) {
      const node = this.body.nodes[nodeId];
      const nodeObj = {}; // used to quickly check if node already exists
      for (let i = 0; i < node.edges.length; i++) {
        const edge = node.edges[i];
        if (direction !== "to" && edge.toId == node.id) {
          // these are double equals since ids can be numeric or string
          if (nodeObj[edge.fromId] === undefined) {
            nodeList.push(edge.fromId);
            nodeObj[edge.fromId] = true;
          }
        } else if (direction !== "from" && edge.fromId == node.id) {
          // these are double equals since ids can be numeric or string
          if (nodeObj[edge.toId] === undefined) {
            nodeList.push(edge.toId);
            nodeObj[edge.toId] = true;
          }
        }
      }
    }
    return nodeList;
  }

  /**
   * Get the ids of the edges connected to this node.
   * @param {Node.id} nodeId
   * @returns {*}
   */
  getConnectedEdges(nodeId) {
    const edgeList = [];
    if (this.body.nodes[nodeId] !== undefined) {
      const node = this.body.nodes[nodeId];
      for (let i = 0; i < node.edges.length; i++) {
        edgeList.push(node.edges[i].id);
      }
    } else {
      console.error("NodeId provided for getConnectedEdges does not exist. Provided: ", nodeId);
    }
    return edgeList;
  }

  /**
   * Move a node.
   * @param {Node.id} nodeId
   * @param {number} x
   * @param {number} y
   */
  moveNode(nodeId, x, y) {
    if (this.body.nodes[nodeId] !== undefined) {
      this.body.nodes[nodeId].x = Number(x);
      this.body.nodes[nodeId].y = Number(y);
      _setTimeout(() => {
        this.body.emitter.emit("startSimulation");
      }, 0);
    } else {
      console.error("Node id supplied to moveNode does not exist. Provided: ", nodeId);
    }
  }
}

var $$3 = _export;

// eslint-disable-next-line es/no-math-hypot -- required for testing
var $hypot = Math.hypot;
var abs = Math.abs;
var sqrt = Math.sqrt;

// Chrome 77 bug
// https://bugs.chromium.org/p/v8/issues/detail?id=9546
var FORCED$2 = !!$hypot && $hypot(Infinity, NaN) !== Infinity;

// `Math.hypot` method
// https://tc39.es/ecma262/#sec-math.hypot
$$3({ target: 'Math', stat: true, arity: 2, forced: FORCED$2 }, {
  // eslint-disable-next-line no-unused-vars -- required for `.length`
  hypot: function hypot(value1, value2) {
    var sum = 0;
    var i = 0;
    var aLen = arguments.length;
    var larg = 0;
    var arg, div;
    while (i < aLen) {
      arg = abs(arguments[i++]);
      if (larg < arg) {
        div = larg / arg;
        sum = sum * div * div + 1;
        larg = arg;
      } else if (arg > 0) {
        div = arg / larg;
        sum += div * div;
      } else sum += arg;
    }
    return larg === Infinity ? Infinity : larg * sqrt(sum);
  }
});

var path$3 = path$s;

var hypot$2 = path$3.Math.hypot;

var parent$5 = hypot$2;

var hypot$1 = parent$5;

var hypot = hypot$1;

var _Math$hypot = /*@__PURE__*/getDefaultExportFromCjs(hypot);

/**
 * Common methods for endpoints
 * @class
 */
class EndPoint {
  /**
   * Apply transformation on points for display.
   *
   * The following is done:
   * - rotate by the specified angle
   * - multiply the (normalized) coordinates by the passed length
   * - offset by the target coordinates
   * @param points - The point(s) to be transformed.
   * @param arrowData - The data determining the result of the transformation.
   */
  static transform(points, arrowData) {
    if (!_Array$isArray(points)) {
      points = [points];
    }
    const x = arrowData.point.x;
    const y = arrowData.point.y;
    const angle = arrowData.angle;
    const length = arrowData.length;
    for (let i = 0; i < points.length; ++i) {
      const p = points[i];
      const xt = p.x * Math.cos(angle) - p.y * Math.sin(angle);
      const yt = p.x * Math.sin(angle) + p.y * Math.cos(angle);
      p.x = x + length * xt;
      p.y = y + length * yt;
    }
  }
  /**
   * Draw a closed path using the given real coordinates.
   * @param ctx - The path will be rendered into this context.
   * @param points - The points of the path.
   */
  static drawPath(ctx, points) {
    ctx.beginPath();
    ctx.moveTo(points[0].x, points[0].y);
    for (let i = 1; i < points.length; ++i) {
      ctx.lineTo(points[i].x, points[i].y);
    }
    ctx.closePath();
  }
}
/**
 * Drawing methods for the arrow endpoint.
 */
let Image$1 = class Image extends EndPoint {
  /**
   * Draw this shape at the end of a line.
   * @param ctx - The shape will be rendered into this context.
   * @param arrowData - The data determining the shape.
   * @returns False as there is no way to fill an image.
   */
  static draw(ctx, arrowData) {
    if (arrowData.image) {
      ctx.save();
      ctx.translate(arrowData.point.x, arrowData.point.y);
      ctx.rotate(Math.PI / 2 + arrowData.angle);
      const width = arrowData.imageWidth != null ? arrowData.imageWidth : arrowData.image.width;
      const height = arrowData.imageHeight != null ? arrowData.imageHeight : arrowData.image.height;
      arrowData.image.drawImageAtPosition(ctx, 1,
      // scale
      -width / 2,
      // x
      0,
      // y
      width, height);
      ctx.restore();
    }
    return false;
  }
};
/**
 * Drawing methods for the arrow endpoint.
 */
class Arrow extends EndPoint {
  /**
   * Draw this shape at the end of a line.
   * @param ctx - The shape will be rendered into this context.
   * @param arrowData - The data determining the shape.
   * @returns True because ctx.fill() can be used to fill the arrow.
   */
  static draw(ctx, arrowData) {
    // Normalized points of closed path, in the order that they should be drawn.
    // (0, 0) is the attachment point, and the point around which should be rotated
    const points = [{
      x: 0,
      y: 0
    }, {
      x: -1,
      y: 0.3
    }, {
      x: -0.9,
      y: 0
    }, {
      x: -1,
      y: -0.3
    }];
    EndPoint.transform(points, arrowData);
    EndPoint.drawPath(ctx, points);
    return true;
  }
}
/**
 * Drawing methods for the crow endpoint.
 */
class Crow {
  /**
   * Draw this shape at the end of a line.
   * @param ctx - The shape will be rendered into this context.
   * @param arrowData - The data determining the shape.
   * @returns True because ctx.fill() can be used to fill the arrow.
   */
  static draw(ctx, arrowData) {
    // Normalized points of closed path, in the order that they should be drawn.
    // (0, 0) is the attachment point, and the point around which should be rotated
    const points = [{
      x: -1,
      y: 0
    }, {
      x: 0,
      y: 0.3
    }, {
      x: -0.4,
      y: 0
    }, {
      x: 0,
      y: -0.3
    }];
    EndPoint.transform(points, arrowData);
    EndPoint.drawPath(ctx, points);
    return true;
  }
}
/**
 * Drawing methods for the curve endpoint.
 */
class Curve {
  /**
   * Draw this shape at the end of a line.
   * @param ctx - The shape will be rendered into this context.
   * @param arrowData - The data determining the shape.
   * @returns True because ctx.fill() can be used to fill the arrow.
   */
  static draw(ctx, arrowData) {
    // Normalized points of closed path, in the order that they should be drawn.
    // (0, 0) is the attachment point, and the point around which should be rotated
    const point = {
      x: -0.4,
      y: 0
    };
    EndPoint.transform(point, arrowData);
    // Update endpoint style for drawing transparent arc.
    ctx.strokeStyle = ctx.fillStyle;
    ctx.fillStyle = "rgba(0, 0, 0, 0)";
    // Define curve endpoint as semicircle.
    const pi = Math.PI;
    const startAngle = arrowData.angle - pi / 2;
    const endAngle = arrowData.angle + pi / 2;
    ctx.beginPath();
    ctx.arc(point.x, point.y, arrowData.length * 0.4, startAngle, endAngle, false);
    ctx.stroke();
    return true;
  }
}
/**
 * Drawing methods for the inverted curve endpoint.
 */
class InvertedCurve {
  /**
   * Draw this shape at the end of a line.
   * @param ctx - The shape will be rendered into this context.
   * @param arrowData - The data determining the shape.
   * @returns True because ctx.fill() can be used to fill the arrow.
   */
  static draw(ctx, arrowData) {
    // Normalized points of closed path, in the order that they should be drawn.
    // (0, 0) is the attachment point, and the point around which should be rotated
    const point = {
      x: -0.3,
      y: 0
    };
    EndPoint.transform(point, arrowData);
    // Update endpoint style for drawing transparent arc.
    ctx.strokeStyle = ctx.fillStyle;
    ctx.fillStyle = "rgba(0, 0, 0, 0)";
    // Define inverted curve endpoint as semicircle.
    const pi = Math.PI;
    const startAngle = arrowData.angle + pi / 2;
    const endAngle = arrowData.angle + 3 * pi / 2;
    ctx.beginPath();
    ctx.arc(point.x, point.y, arrowData.length * 0.4, startAngle, endAngle, false);
    ctx.stroke();
    return true;
  }
}
/**
 * Drawing methods for the trinagle endpoint.
 */
class Triangle {
  /**
   * Draw this shape at the end of a line.
   * @param ctx - The shape will be rendered into this context.
   * @param arrowData - The data determining the shape.
   * @returns True because ctx.fill() can be used to fill the arrow.
   */
  static draw(ctx, arrowData) {
    // Normalized points of closed path, in the order that they should be drawn.
    // (0, 0) is the attachment point, and the point around which should be rotated
    const points = [{
      x: 0.02,
      y: 0
    }, {
      x: -1,
      y: 0.3
    }, {
      x: -1,
      y: -0.3
    }];
    EndPoint.transform(points, arrowData);
    EndPoint.drawPath(ctx, points);
    return true;
  }
}
/**
 * Drawing methods for the inverted trinagle endpoint.
 */
class InvertedTriangle {
  /**
   * Draw this shape at the end of a line.
   * @param ctx - The shape will be rendered into this context.
   * @param arrowData - The data determining the shape.
   * @returns True because ctx.fill() can be used to fill the arrow.
   */
  static draw(ctx, arrowData) {
    // Normalized points of closed path, in the order that they should be drawn.
    // (0, 0) is the attachment point, and the point around which should be rotated
    const points = [{
      x: 0,
      y: 0.3
    }, {
      x: 0,
      y: -0.3
    }, {
      x: -1,
      y: 0
    }];
    EndPoint.transform(points, arrowData);
    EndPoint.drawPath(ctx, points);
    return true;
  }
}
/**
 * Drawing methods for the circle endpoint.
 */
class Circle {
  /**
   * Draw this shape at the end of a line.
   * @param ctx - The shape will be rendered into this context.
   * @param arrowData - The data determining the shape.
   * @returns True because ctx.fill() can be used to fill the arrow.
   */
  static draw(ctx, arrowData) {
    const point = {
      x: -0.4,
      y: 0
    };
    EndPoint.transform(point, arrowData);
    drawCircle(ctx, point.x, point.y, arrowData.length * 0.4);
    return true;
  }
}
/**
 * Drawing methods for the bar endpoint.
 */
class Bar {
  /**
   * Draw this shape at the end of a line.
   * @param ctx - The shape will be rendered into this context.
   * @param arrowData - The data determining the shape.
   * @returns True because ctx.fill() can be used to fill the arrow.
   */
  static draw(ctx, arrowData) {
    /*
    var points = [
      {x:0, y:0.5},
      {x:0, y:-0.5}
    ];
         EndPoint.transform(points, arrowData);
    ctx.beginPath();
    ctx.moveTo(points[0].x, points[0].y);
    ctx.lineTo(points[1].x, points[1].y);
    ctx.stroke();
    */
    const points = [{
      x: 0,
      y: 0.5
    }, {
      x: 0,
      y: -0.5
    }, {
      x: -0.15,
      y: -0.5
    }, {
      x: -0.15,
      y: 0.5
    }];
    EndPoint.transform(points, arrowData);
    EndPoint.drawPath(ctx, points);
    return true;
  }
}
/**
 * Drawing methods for the box endpoint.
 */
class Box {
  /**
   * Draw this shape at the end of a line.
   * @param ctx - The shape will be rendered into this context.
   * @param arrowData - The data determining the shape.
   * @returns True because ctx.fill() can be used to fill the arrow.
   */
  static draw(ctx, arrowData) {
    const points = [{
      x: 0,
      y: 0.3
    }, {
      x: 0,
      y: -0.3
    }, {
      x: -0.6,
      y: -0.3
    }, {
      x: -0.6,
      y: 0.3
    }];
    EndPoint.transform(points, arrowData);
    EndPoint.drawPath(ctx, points);
    return true;
  }
}
/**
 * Drawing methods for the diamond endpoint.
 */
class Diamond {
  /**
   * Draw this shape at the end of a line.
   * @param ctx - The shape will be rendered into this context.
   * @param arrowData - The data determining the shape.
   * @returns True because ctx.fill() can be used to fill the arrow.
   */
  static draw(ctx, arrowData) {
    const points = [{
      x: 0,
      y: 0
    }, {
      x: -0.5,
      y: -0.3
    }, {
      x: -1,
      y: 0
    }, {
      x: -0.5,
      y: 0.3
    }];
    EndPoint.transform(points, arrowData);
    EndPoint.drawPath(ctx, points);
    return true;
  }
}
/**
 * Drawing methods for the vee endpoint.
 */
class Vee {
  /**
   * Draw this shape at the end of a line.
   * @param ctx - The shape will be rendered into this context.
   * @param arrowData - The data determining the shape.
   * @returns True because ctx.fill() can be used to fill the arrow.
   */
  static draw(ctx, arrowData) {
    // Normalized points of closed path, in the order that they should be drawn.
    // (0, 0) is the attachment point, and the point around which should be rotated
    const points = [{
      x: -1,
      y: 0.3
    }, {
      x: -0.5,
      y: 0
    }, {
      x: -1,
      y: -0.3
    }, {
      x: 0,
      y: 0
    }];
    EndPoint.transform(points, arrowData);
    EndPoint.drawPath(ctx, points);
    return true;
  }
}
/**
 * Drawing methods for the endpoints.
 */
class EndPoints {
  /**
   * Draw an endpoint.
   * @param ctx - The shape will be rendered into this context.
   * @param arrowData - The data determining the shape.
   * @returns True if ctx.fill() can be used to fill the arrow, false otherwise.
   */
  static draw(ctx, arrowData) {
    let type;
    if (arrowData.type) {
      type = arrowData.type.toLowerCase();
    }
    switch (type) {
      case "image":
        return Image$1.draw(ctx, arrowData);
      case "circle":
        return Circle.draw(ctx, arrowData);
      case "box":
        return Box.draw(ctx, arrowData);
      case "crow":
        return Crow.draw(ctx, arrowData);
      case "curve":
        return Curve.draw(ctx, arrowData);
      case "diamond":
        return Diamond.draw(ctx, arrowData);
      case "inv_curve":
        return InvertedCurve.draw(ctx, arrowData);
      case "triangle":
        return Triangle.draw(ctx, arrowData);
      case "inv_triangle":
        return InvertedTriangle.draw(ctx, arrowData);
      case "bar":
        return Bar.draw(ctx, arrowData);
      case "vee":
        return Vee.draw(ctx, arrowData);
      case "arrow": // fall-through
      default:
        return Arrow.draw(ctx, arrowData);
    }
  }
}

function ownKeys$1(e, r) { var t = _Object$keys(e); if (_Object$getOwnPropertySymbols) { var o = _Object$getOwnPropertySymbols(e); r && (o = _filterInstanceProperty(o).call(o, function (r) { return _Object$getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread$1(e) { for (var r = 1; r < arguments.length; r++) { var _context2, _context3; var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? _forEachInstanceProperty(_context2 = ownKeys$1(Object(t), !0)).call(_context2, function (r) { _defineProperty(e, r, t[r]); }) : _Object$getOwnPropertyDescriptors ? _Object$defineProperties(e, _Object$getOwnPropertyDescriptors(t)) : _forEachInstanceProperty(_context3 = ownKeys$1(Object(t))).call(_context3, function (r) { _Object$defineProperty(e, r, _Object$getOwnPropertyDescriptor(t, r)); }); } return e; }
/**
 * The Base Class for all edges.
 */
class EdgeBase {
  /**
   * Create a new instance.
   * @param options - The options object of given edge.
   * @param _body - The body of the network.
   * @param _labelModule - Label module.
   */
  constructor(options, _body, _labelModule) {
    this._body = _body;
    this._labelModule = _labelModule;
    this.color = {};
    this.colorDirty = true;
    this.hoverWidth = 1.5;
    this.selectionWidth = 2;
    this.setOptions(options);
    this.fromPoint = this.from;
    this.toPoint = this.to;
  }
  /** @inheritDoc */
  connect() {
    this.from = this._body.nodes[this.options.from];
    this.to = this._body.nodes[this.options.to];
  }
  /** @inheritDoc */
  cleanup() {
    return false;
  }
  /**
   * Set new edge options.
   * @param options - The new edge options object.
   */
  setOptions(options) {
    this.options = options;
    this.from = this._body.nodes[this.options.from];
    this.to = this._body.nodes[this.options.to];
    this.id = this.options.id;
  }
  /** @inheritDoc */
  drawLine(ctx, values, _selected, _hover) {
    let viaNode = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : this.getViaNode();
    // set style
    ctx.strokeStyle = this.getColor(ctx, values);
    ctx.lineWidth = values.width;
    if (values.dashes !== false) {
      this._drawDashedLine(ctx, values, viaNode);
    } else {
      this._drawLine(ctx, values, viaNode);
    }
  }
  /**
   * Draw a line with given style between two nodes through supplied node(s).
   * @param ctx - The context that will be used for rendering.
   * @param values - Formatting values like color, opacity or shadow.
   * @param viaNode - Additional control point(s) for the edge.
   * @param fromPoint - TODO: Seems ignored, remove?
   * @param toPoint - TODO: Seems ignored, remove?
   */
  _drawLine(ctx, values, viaNode, fromPoint, toPoint) {
    if (this.from != this.to) {
      // draw line
      this._line(ctx, values, viaNode, fromPoint, toPoint);
    } else {
      const [x, y, radius] = this._getCircleData(ctx);
      this._circle(ctx, values, x, y, radius);
    }
  }
  /**
   * Draw a dashed line with given style between two nodes through supplied node(s).
   * @param ctx - The context that will be used for rendering.
   * @param values - Formatting values like color, opacity or shadow.
   * @param viaNode - Additional control point(s) for the edge.
   * @param _fromPoint - Ignored (TODO: remove in the future).
   * @param _toPoint - Ignored (TODO: remove in the future).
   */
  _drawDashedLine(ctx, values, viaNode, _fromPoint, _toPoint) {
    ctx.lineCap = "round";
    const pattern = _Array$isArray(values.dashes) ? values.dashes : [5, 5];
    // only firefox and chrome support this method, else we use the legacy one.
    if (ctx.setLineDash !== undefined) {
      ctx.save();
      // set dash settings for chrome or firefox
      ctx.setLineDash(pattern);
      ctx.lineDashOffset = 0;
      // draw the line
      if (this.from != this.to) {
        // draw line
        this._line(ctx, values, viaNode);
      } else {
        const [x, y, radius] = this._getCircleData(ctx);
        this._circle(ctx, values, x, y, radius);
      }
      // restore the dash settings.
      ctx.setLineDash([0]);
      ctx.lineDashOffset = 0;
      ctx.restore();
    } else {
      // unsupporting smooth lines
      if (this.from != this.to) {
        // draw line
        drawDashedLine(ctx, this.from.x, this.from.y, this.to.x, this.to.y, pattern);
      } else {
        const [x, y, radius] = this._getCircleData(ctx);
        this._circle(ctx, values, x, y, radius);
      }
      // draw shadow if enabled
      this.enableShadow(ctx, values);
      ctx.stroke();
      // disable shadows for other elements.
      this.disableShadow(ctx, values);
    }
  }
  /**
   * Find the intersection between the border of the node and the edge.
   * @param node - The node (either from or to node of the edge).
   * @param ctx - The context that will be used for rendering.
   * @param options - Additional options.
   * @returns Cartesian coordinates of the intersection between the border of the node and the edge.
   */
  findBorderPosition(node, ctx, options) {
    if (this.from != this.to) {
      return this._findBorderPosition(node, ctx, options);
    } else {
      return this._findBorderPositionCircle(node, ctx, options);
    }
  }
  /** @inheritDoc */
  findBorderPositions(ctx) {
    if (this.from != this.to) {
      return {
        from: this._findBorderPosition(this.from, ctx),
        to: this._findBorderPosition(this.to, ctx)
      };
    } else {
      var _context;
      const [x, y] = _sliceInstanceProperty(_context = this._getCircleData(ctx)).call(_context, 0, 2);
      return {
        from: this._findBorderPositionCircle(this.from, ctx, {
          x,
          y,
          low: 0.25,
          high: 0.6,
          direction: -1
        }),
        to: this._findBorderPositionCircle(this.from, ctx, {
          x,
          y,
          low: 0.6,
          high: 0.8,
          direction: 1
        })
      };
    }
  }
  /**
   * Compute the center point and radius of an edge connected to the same node at both ends.
   * @param ctx - The context that will be used for rendering.
   * @returns `[x, y, radius]`
   */
  _getCircleData(ctx) {
    const radius = this.options.selfReference.size;
    if (ctx !== undefined) {
      if (this.from.shape.width === undefined) {
        this.from.shape.resize(ctx);
      }
    }
    // get circle coordinates
    const coordinates = getSelfRefCoordinates(ctx, this.options.selfReference.angle, radius, this.from);
    return [coordinates.x, coordinates.y, radius];
  }
  /**
   * Get a point on a circle.
   * @param x - Center of the circle on the x axis.
   * @param y - Center of the circle on the y axis.
   * @param radius - Radius of the circle.
   * @param position - Value between 0 (line start) and 1 (line end).
   * @returns Cartesian coordinates of requested point on the circle.
   */
  _pointOnCircle(x, y, radius, position) {
    const angle = position * 2 * Math.PI;
    return {
      x: x + radius * Math.cos(angle),
      y: y - radius * Math.sin(angle)
    };
  }
  /**
   * Find the intersection between the border of the node and the edge.
   * @remarks
   * This function uses binary search to look for the point where the circle crosses the border of the node.
   * @param nearNode - The node (either from or to node of the edge).
   * @param ctx - The context that will be used for rendering.
   * @param options - Additional options.
   * @returns Cartesian coordinates of the intersection between the border of the node and the edge.
   */
  _findBorderPositionCircle(nearNode, ctx, options) {
    const x = options.x;
    const y = options.y;
    let low = options.low;
    let high = options.high;
    const direction = options.direction;
    const maxIterations = 10;
    const radius = this.options.selfReference.size;
    const threshold = 0.05;
    let pos;
    let middle = (low + high) * 0.5;
    let endPointOffset = 0;
    if (this.options.arrowStrikethrough === true) {
      if (direction === -1) {
        endPointOffset = this.options.endPointOffset.from;
      } else if (direction === 1) {
        endPointOffset = this.options.endPointOffset.to;
      }
    }
    let iteration = 0;
    do {
      middle = (low + high) * 0.5;
      pos = this._pointOnCircle(x, y, radius, middle);
      const angle = Math.atan2(nearNode.y - pos.y, nearNode.x - pos.x);
      const distanceToBorder = nearNode.distanceToBorder(ctx, angle) + endPointOffset;
      const distanceToPoint = Math.sqrt(Math.pow(pos.x - nearNode.x, 2) + Math.pow(pos.y - nearNode.y, 2));
      const difference = distanceToBorder - distanceToPoint;
      if (Math.abs(difference) < threshold) {
        break; // found
      } else if (difference > 0) {
        // distance to nodes is larger than distance to border --> t needs to be bigger if we're looking at the to node.
        if (direction > 0) {
          low = middle;
        } else {
          high = middle;
        }
      } else {
        if (direction > 0) {
          high = middle;
        } else {
          low = middle;
        }
      }
      ++iteration;
    } while (low <= high && iteration < maxIterations);
    return _objectSpread$1(_objectSpread$1({}, pos), {}, {
      t: middle
    });
  }
  /**
   * Get the line width of the edge. Depends on width and whether one of the connected nodes is selected.
   * @param selected - Determines wheter the line is selected.
   * @param hover - Determines wheter the line is being hovered, only applies if selected is false.
   * @returns The width of the line.
   */
  getLineWidth(selected, hover) {
    if (selected === true) {
      return Math.max(this.selectionWidth, 0.3 / this._body.view.scale);
    } else if (hover === true) {
      return Math.max(this.hoverWidth, 0.3 / this._body.view.scale);
    } else {
      return Math.max(this.options.width, 0.3 / this._body.view.scale);
    }
  }
  /**
   * Compute the color or gradient for given edge.
   * @param ctx - The context that will be used for rendering.
   * @param values - Formatting values like color, opacity or shadow.
   * @param _selected - Ignored (TODO: remove in the future).
   * @param _hover - Ignored (TODO: remove in the future).
   * @returns Color string if single color is inherited or gradient if two.
   */
  getColor(ctx, values) {
    if (values.inheritsColor !== false) {
      // when this is a loop edge, just use the 'from' method
      if (values.inheritsColor === "both" && this.from.id !== this.to.id) {
        const grd = ctx.createLinearGradient(this.from.x, this.from.y, this.to.x, this.to.y);
        let fromColor = this.from.options.color.highlight.border;
        let toColor = this.to.options.color.highlight.border;
        if (this.from.selected === false && this.to.selected === false) {
          fromColor = overrideOpacity(this.from.options.color.border, values.opacity);
          toColor = overrideOpacity(this.to.options.color.border, values.opacity);
        } else if (this.from.selected === true && this.to.selected === false) {
          toColor = this.to.options.color.border;
        } else if (this.from.selected === false && this.to.selected === true) {
          fromColor = this.from.options.color.border;
        }
        grd.addColorStop(0, fromColor);
        grd.addColorStop(1, toColor);
        // -------------------- this returns -------------------- //
        return grd;
      }
      if (values.inheritsColor === "to") {
        return overrideOpacity(this.to.options.color.border, values.opacity);
      } else {
        // "from"
        return overrideOpacity(this.from.options.color.border, values.opacity);
      }
    } else {
      return overrideOpacity(values.color, values.opacity);
    }
  }
  /**
   * Draw a line from a node to itself, a circle.
   * @param ctx - The context that will be used for rendering.
   * @param values - Formatting values like color, opacity or shadow.
   * @param x - Center of the circle on the x axis.
   * @param y - Center of the circle on the y axis.
   * @param radius - Radius of the circle.
   */
  _circle(ctx, values, x, y, radius) {
    // draw shadow if enabled
    this.enableShadow(ctx, values);
    //full circle
    let angleFrom = 0;
    let angleTo = Math.PI * 2;
    if (!this.options.selfReference.renderBehindTheNode) {
      //render only parts which are not overlaping with parent node
      //need to find x,y of from point and x,y to point
      //calculating radians
      const low = this.options.selfReference.angle;
      const high = this.options.selfReference.angle + Math.PI;
      const pointTFrom = this._findBorderPositionCircle(this.from, ctx, {
        x,
        y,
        low,
        high,
        direction: -1
      });
      const pointTTo = this._findBorderPositionCircle(this.from, ctx, {
        x,
        y,
        low,
        high,
        direction: 1
      });
      angleFrom = Math.atan2(pointTFrom.y - y, pointTFrom.x - x);
      angleTo = Math.atan2(pointTTo.y - y, pointTTo.x - x);
    }
    // draw a circle
    ctx.beginPath();
    ctx.arc(x, y, radius, angleFrom, angleTo, false);
    ctx.stroke();
    // disable shadows for other elements.
    this.disableShadow(ctx, values);
  }
  /**
   * @inheritDoc
   * @remarks
   * http://stackoverflow.com/questions/849211/shortest-distancae-between-a-point-and-a-line-segment
   */
  getDistanceToEdge(x1, y1, x2, y2, x3, y3) {
    if (this.from != this.to) {
      return this._getDistanceToEdge(x1, y1, x2, y2, x3, y3);
    } else {
      const [x, y, radius] = this._getCircleData(undefined);
      const dx = x - x3;
      const dy = y - y3;
      return Math.abs(Math.sqrt(dx * dx + dy * dy) - radius);
    }
  }
  /**
   * Calculate the distance between a point (x3, y3) and a line segment from (x1, y1) to (x2, y2).
   * @param x1 - First end of the line segment on the x axis.
   * @param y1 - First end of the line segment on the y axis.
   * @param x2 - Second end of the line segment on the x axis.
   * @param y2 - Second end of the line segment on the y axis.
   * @param x3 - Position of the point on the x axis.
   * @param y3 - Position of the point on the y axis.
   * @returns The distance between the line segment and the point.
   */
  _getDistanceToLine(x1, y1, x2, y2, x3, y3) {
    const px = x2 - x1;
    const py = y2 - y1;
    const something = px * px + py * py;
    let u = ((x3 - x1) * px + (y3 - y1) * py) / something;
    if (u > 1) {
      u = 1;
    } else if (u < 0) {
      u = 0;
    }
    const x = x1 + u * px;
    const y = y1 + u * py;
    const dx = x - x3;
    const dy = y - y3;
    //# Note: If the actual distance does not matter,
    //# if you only want to compare what this function
    //# returns to other results of this function, you
    //# can just return the squared distance instead
    //# (i.e. remove the sqrt) to gain a little performance
    return Math.sqrt(dx * dx + dy * dy);
  }
  /** @inheritDoc */
  getArrowData(ctx, position, viaNode, _selected, _hover, values) {
    // set lets
    let angle;
    let arrowPoint;
    let node1;
    let node2;
    let reversed;
    let scaleFactor;
    let type;
    const lineWidth = values.width;
    if (position === "from") {
      node1 = this.from;
      node2 = this.to;
      reversed = values.fromArrowScale < 0;
      scaleFactor = Math.abs(values.fromArrowScale);
      type = values.fromArrowType;
    } else if (position === "to") {
      node1 = this.to;
      node2 = this.from;
      reversed = values.toArrowScale < 0;
      scaleFactor = Math.abs(values.toArrowScale);
      type = values.toArrowType;
    } else {
      node1 = this.to;
      node2 = this.from;
      reversed = values.middleArrowScale < 0;
      scaleFactor = Math.abs(values.middleArrowScale);
      type = values.middleArrowType;
    }
    const length = 15 * scaleFactor + 3 * lineWidth; // 3* lineWidth is the width of the edge.
    // if not connected to itself
    if (node1 != node2) {
      const approximateEdgeLength = _Math$hypot(node1.x - node2.x, node1.y - node2.y);
      const relativeLength = length / approximateEdgeLength;
      if (position !== "middle") {
        // draw arrow head
        if (this.options.smooth.enabled === true) {
          const pointT = this._findBorderPosition(node1, ctx, {
            via: viaNode
          });
          const guidePos = this.getPoint(pointT.t + relativeLength * (position === "from" ? 1 : -1), viaNode);
          angle = Math.atan2(pointT.y - guidePos.y, pointT.x - guidePos.x);
          arrowPoint = pointT;
        } else {
          angle = Math.atan2(node1.y - node2.y, node1.x - node2.x);
          arrowPoint = this._findBorderPosition(node1, ctx);
        }
      } else {
        // Negative half length reverses arrow direction.
        const halfLength = (reversed ? -relativeLength : relativeLength) / 2;
        const guidePos1 = this.getPoint(0.5 + halfLength, viaNode);
        const guidePos2 = this.getPoint(0.5 - halfLength, viaNode);
        angle = Math.atan2(guidePos1.y - guidePos2.y, guidePos1.x - guidePos2.x);
        arrowPoint = this.getPoint(0.5, viaNode);
      }
    } else {
      // draw circle
      const [x, y, radius] = this._getCircleData(ctx);
      if (position === "from") {
        const low = this.options.selfReference.angle;
        const high = this.options.selfReference.angle + Math.PI;
        const pointT = this._findBorderPositionCircle(this.from, ctx, {
          x,
          y,
          low,
          high,
          direction: -1
        });
        angle = pointT.t * -2 * Math.PI + 1.5 * Math.PI + 0.1 * Math.PI;
        arrowPoint = pointT;
      } else if (position === "to") {
        const low = this.options.selfReference.angle;
        const high = this.options.selfReference.angle + Math.PI;
        const pointT = this._findBorderPositionCircle(this.from, ctx, {
          x,
          y,
          low,
          high,
          direction: 1
        });
        angle = pointT.t * -2 * Math.PI + 1.5 * Math.PI - 1.1 * Math.PI;
        arrowPoint = pointT;
      } else {
        const pos = this.options.selfReference.angle / (2 * Math.PI);
        arrowPoint = this._pointOnCircle(x, y, radius, pos);
        angle = pos * -2 * Math.PI + 1.5 * Math.PI + 0.1 * Math.PI;
      }
    }
    const xi = arrowPoint.x - length * 0.9 * Math.cos(angle);
    const yi = arrowPoint.y - length * 0.9 * Math.sin(angle);
    const arrowCore = {
      x: xi,
      y: yi
    };
    return {
      point: arrowPoint,
      core: arrowCore,
      angle: angle,
      length: length,
      type: type
    };
  }
  /** @inheritDoc */
  drawArrowHead(ctx, values, _selected, _hover, arrowData) {
    // set style
    ctx.strokeStyle = this.getColor(ctx, values);
    ctx.fillStyle = ctx.strokeStyle;
    ctx.lineWidth = values.width;
    const canFill = EndPoints.draw(ctx, arrowData);
    if (canFill) {
      // draw shadow if enabled
      this.enableShadow(ctx, values);
      _fillInstanceProperty(ctx).call(ctx);
      // disable shadows for other elements.
      this.disableShadow(ctx, values);
    }
  }
  /**
   * Set the shadow formatting values in the context if enabled, do nothing otherwise.
   * @param ctx - The context that will be used for rendering.
   * @param values - Formatting values for the shadow.
   */
  enableShadow(ctx, values) {
    if (values.shadow === true) {
      ctx.shadowColor = values.shadowColor;
      ctx.shadowBlur = values.shadowSize;
      ctx.shadowOffsetX = values.shadowX;
      ctx.shadowOffsetY = values.shadowY;
    }
  }
  /**
   * Reset the shadow formatting values in the context if enabled, do nothing otherwise.
   * @param ctx - The context that will be used for rendering.
   * @param values - Formatting values for the shadow.
   */
  disableShadow(ctx, values) {
    if (values.shadow === true) {
      ctx.shadowColor = "rgba(0,0,0,0)";
      ctx.shadowBlur = 0;
      ctx.shadowOffsetX = 0;
      ctx.shadowOffsetY = 0;
    }
  }
  /**
   * Render the background according to the formatting values.
   * @param ctx - The context that will be used for rendering.
   * @param values - Formatting values for the background.
   */
  drawBackground(ctx, values) {
    if (values.background !== false) {
      // save original line attrs
      const origCtxAttr = {
        strokeStyle: ctx.strokeStyle,
        lineWidth: ctx.lineWidth,
        dashes: ctx.dashes
      };
      ctx.strokeStyle = values.backgroundColor;
      ctx.lineWidth = values.backgroundSize;
      this.setStrokeDashed(ctx, values.backgroundDashes);
      ctx.stroke();
      // restore original line attrs
      ctx.strokeStyle = origCtxAttr.strokeStyle;
      ctx.lineWidth = origCtxAttr.lineWidth;
      ctx.dashes = origCtxAttr.dashes;
      this.setStrokeDashed(ctx, values.dashes);
    }
  }
  /**
   * Set the line dash pattern if supported. Logs a warning to the console if it isn't supported.
   * @param ctx - The context that will be used for rendering.
   * @param dashes - The pattern [line, space, line…], true for default dashed line or false for normal line.
   */
  setStrokeDashed(ctx, dashes) {
    if (dashes !== false) {
      if (ctx.setLineDash !== undefined) {
        const pattern = _Array$isArray(dashes) ? dashes : [5, 5];
        ctx.setLineDash(pattern);
      } else {
        console.warn("setLineDash is not supported in this browser. The dashed stroke cannot be used.");
      }
    } else {
      if (ctx.setLineDash !== undefined) {
        ctx.setLineDash([]);
      } else {
        console.warn("setLineDash is not supported in this browser. The dashed stroke cannot be used.");
      }
    }
  }
}

function ownKeys(e, r) { var t = _Object$keys(e); if (_Object$getOwnPropertySymbols) { var o = _Object$getOwnPropertySymbols(e); r && (o = _filterInstanceProperty(o).call(o, function (r) { return _Object$getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var _context, _context2; var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? _forEachInstanceProperty(_context = ownKeys(Object(t), !0)).call(_context, function (r) { _defineProperty(e, r, t[r]); }) : _Object$getOwnPropertyDescriptors ? _Object$defineProperties(e, _Object$getOwnPropertyDescriptors(t)) : _forEachInstanceProperty(_context2 = ownKeys(Object(t))).call(_context2, function (r) { _Object$defineProperty(e, r, _Object$getOwnPropertyDescriptor(t, r)); }); } return e; }
/**
 * The Base Class for all Bezier edges.
 * Bezier curves are used to model smooth gradual curves in paths between nodes.
 */
class BezierEdgeBase extends EdgeBase {
  /**
   * Create a new instance.
   * @param options - The options object of given edge.
   * @param body - The body of the network.
   * @param labelModule - Label module.
   */
  constructor(options, body, labelModule) {
    super(options, body, labelModule);
  }
  /**
   * Find the intersection between the border of the node and the edge.
   * @remarks
   * This function uses binary search to look for the point where the bezier curve crosses the border of the node.
   * @param nearNode - The node (either from or to node of the edge).
   * @param ctx - The context that will be used for rendering.
   * @param viaNode - Additional node(s) the edge passes through.
   * @returns Cartesian coordinates of the intersection between the border of the node and the edge.
   */
  _findBorderPositionBezier(nearNode, ctx) {
    let viaNode = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : this._getViaCoordinates();
    const maxIterations = 10;
    const threshold = 0.2;
    let from = false;
    let high = 1;
    let low = 0;
    let node = this.to;
    let pos;
    let middle;
    let endPointOffset = this.options.endPointOffset ? this.options.endPointOffset.to : 0;
    if (nearNode.id === this.from.id) {
      node = this.from;
      from = true;
      endPointOffset = this.options.endPointOffset ? this.options.endPointOffset.from : 0;
    }
    if (this.options.arrowStrikethrough === false) {
      endPointOffset = 0;
    }
    let iteration = 0;
    do {
      middle = (low + high) * 0.5;
      pos = this.getPoint(middle, viaNode);
      const angle = Math.atan2(node.y - pos.y, node.x - pos.x);
      const distanceToBorder = node.distanceToBorder(ctx, angle) + endPointOffset;
      const distanceToPoint = Math.sqrt(Math.pow(pos.x - node.x, 2) + Math.pow(pos.y - node.y, 2));
      const difference = distanceToBorder - distanceToPoint;
      if (Math.abs(difference) < threshold) {
        break; // found
      } else if (difference < 0) {
        // distance to nodes is larger than distance to border --> t needs to be bigger if we're looking at the to node.
        if (from === false) {
          low = middle;
        } else {
          high = middle;
        }
      } else {
        if (from === false) {
          high = middle;
        } else {
          low = middle;
        }
      }
      ++iteration;
    } while (low <= high && iteration < maxIterations);
    return _objectSpread(_objectSpread({}, pos), {}, {
      t: middle
    });
  }
  /**
   * Calculate the distance between a point (x3,y3) and a line segment from (x1,y1) to (x2,y2).
   * @remarks
   * http://stackoverflow.com/questions/849211/shortest-distancae-between-a-point-and-a-line-segment
   * @param x1 - First end of the line segment on the x axis.
   * @param y1 - First end of the line segment on the y axis.
   * @param x2 - Second end of the line segment on the x axis.
   * @param y2 - Second end of the line segment on the y axis.
   * @param x3 - Position of the point on the x axis.
   * @param y3 - Position of the point on the y axis.
   * @param via - The control point for the edge.
   * @returns The distance between the line segment and the point.
   */
  _getDistanceToBezierEdge(x1, y1, x2, y2, x3, y3, via) {
    // x3,y3 is the point
    let minDistance = 1e9;
    let distance;
    let i, t, x, y;
    let lastX = x1;
    let lastY = y1;
    for (i = 1; i < 10; i++) {
      t = 0.1 * i;
      x = Math.pow(1 - t, 2) * x1 + 2 * t * (1 - t) * via.x + Math.pow(t, 2) * x2;
      y = Math.pow(1 - t, 2) * y1 + 2 * t * (1 - t) * via.y + Math.pow(t, 2) * y2;
      if (i > 0) {
        distance = this._getDistanceToLine(lastX, lastY, x, y, x3, y3);
        minDistance = distance < minDistance ? distance : minDistance;
      }
      lastX = x;
      lastY = y;
    }
    return minDistance;
  }
  /**
   * Render a bezier curve between two nodes.
   * @remarks
   * The method accepts zero, one or two control points.
   * Passing zero control points just draws a straight line.
   * @param ctx - The context that will be used for rendering.
   * @param values - Style options for edge drawing.
   * @param viaNode1 - First control point for curve drawing.
   * @param viaNode2 - Second control point for curve drawing.
   */
  _bezierCurve(ctx, values, viaNode1, viaNode2) {
    ctx.beginPath();
    ctx.moveTo(this.fromPoint.x, this.fromPoint.y);
    if (viaNode1 != null && viaNode1.x != null) {
      if (viaNode2 != null && viaNode2.x != null) {
        ctx.bezierCurveTo(viaNode1.x, viaNode1.y, viaNode2.x, viaNode2.y, this.toPoint.x, this.toPoint.y);
      } else {
        ctx.quadraticCurveTo(viaNode1.x, viaNode1.y, this.toPoint.x, this.toPoint.y);
      }
    } else {
      // fallback to normal straight edge
      ctx.lineTo(this.toPoint.x, this.toPoint.y);
    }
    // draw a background
    this.drawBackground(ctx, values);
    // draw shadow if enabled
    this.enableShadow(ctx, values);
    ctx.stroke();
    this.disableShadow(ctx, values);
  }
  /** @inheritDoc */
  getViaNode() {
    return this._getViaCoordinates();
  }
}

/**
 * A Dynamic Bezier Edge. Bezier curves are used to model smooth gradual
 * curves in paths between nodes. The Dynamic piece refers to how the curve
 * reacts to physics changes.
 * @augments BezierEdgeBase
 */
class BezierEdgeDynamic extends BezierEdgeBase {
  /**
   * Create a new instance.
   * @param options - The options object of given edge.
   * @param body - The body of the network.
   * @param labelModule - Label module.
   */
  constructor(options, body, labelModule) {
    //this.via = undefined; // Here for completeness but not allowed to defined before super() is invoked.
    super(options, body, labelModule); // --> this calls the setOptions below
    this.via = this.via; // constructor → super → super → setOptions → setupSupportNode
    this._boundFunction = () => {
      this.positionBezierNode();
    };
    this._body.emitter.on("_repositionBezierNodes", this._boundFunction);
  }
  /** @inheritDoc */
  setOptions(options) {
    super.setOptions(options);
    // check if the physics has changed.
    let physicsChange = false;
    if (this.options.physics !== options.physics) {
      physicsChange = true;
    }
    // set the options and the to and from nodes
    this.options = options;
    this.id = this.options.id;
    this.from = this._body.nodes[this.options.from];
    this.to = this._body.nodes[this.options.to];
    // setup the support node and connect
    this.setupSupportNode();
    this.connect();
    // when we change the physics state of the edge, we reposition the support node.
    if (physicsChange === true) {
      this.via.setOptions({
        physics: this.options.physics
      });
      this.positionBezierNode();
    }
  }
  /** @inheritDoc */
  connect() {
    this.from = this._body.nodes[this.options.from];
    this.to = this._body.nodes[this.options.to];
    if (this.from === undefined || this.to === undefined || this.options.physics === false) {
      this.via.setOptions({
        physics: false
      });
    } else {
      // fix weird behaviour where a self referencing node has physics enabled
      if (this.from.id === this.to.id) {
        this.via.setOptions({
          physics: false
        });
      } else {
        this.via.setOptions({
          physics: true
        });
      }
    }
  }
  /** @inheritDoc */
  cleanup() {
    this._body.emitter.off("_repositionBezierNodes", this._boundFunction);
    if (this.via !== undefined) {
      delete this._body.nodes[this.via.id];
      this.via = undefined;
      return true;
    }
    return false;
  }
  /**
   * Create and add a support node if not already present.
   * @remarks
   * Bezier curves require an anchor point to calculate the smooth flow.
   * These points are nodes.
   * These nodes are invisible but are used for the force calculation.
   *
   * The changed data is not called, if needed, it is returned by the main edge constructor.
   */
  setupSupportNode() {
    if (this.via === undefined) {
      const nodeId = "edgeId:" + this.id;
      const node = this._body.functions.createNode({
        id: nodeId,
        shape: "circle",
        physics: true,
        hidden: true
      });
      this._body.nodes[nodeId] = node;
      this.via = node;
      this.via.parentEdgeId = this.id;
      this.positionBezierNode();
    }
  }
  /**
   * Position bezier node.
   */
  positionBezierNode() {
    if (this.via !== undefined && this.from !== undefined && this.to !== undefined) {
      this.via.x = 0.5 * (this.from.x + this.to.x);
      this.via.y = 0.5 * (this.from.y + this.to.y);
    } else if (this.via !== undefined) {
      this.via.x = 0;
      this.via.y = 0;
    }
  }
  /** @inheritDoc */
  _line(ctx, values, viaNode) {
    this._bezierCurve(ctx, values, viaNode);
  }
  /** @inheritDoc */
  _getViaCoordinates() {
    return this.via;
  }
  /** @inheritDoc */
  getViaNode() {
    return this.via;
  }
  /** @inheritDoc */
  getPoint(position) {
    let viaNode = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.via;
    if (this.from === this.to) {
      const [cx, cy, cr] = this._getCircleData();
      const a = 2 * Math.PI * (1 - position);
      return {
        x: cx + cr * Math.sin(a),
        y: cy + cr - cr * (1 - Math.cos(a))
      };
    } else {
      return {
        x: Math.pow(1 - position, 2) * this.fromPoint.x + 2 * position * (1 - position) * viaNode.x + Math.pow(position, 2) * this.toPoint.x,
        y: Math.pow(1 - position, 2) * this.fromPoint.y + 2 * position * (1 - position) * viaNode.y + Math.pow(position, 2) * this.toPoint.y
      };
    }
  }
  /** @inheritDoc */
  _findBorderPosition(nearNode, ctx) {
    return this._findBorderPositionBezier(nearNode, ctx, this.via);
  }
  /** @inheritDoc */
  _getDistanceToEdge(x1, y1, x2, y2, x3, y3) {
    // x3,y3 is the point
    return this._getDistanceToBezierEdge(x1, y1, x2, y2, x3, y3, this.via);
  }
}

/**
 * A Static Bezier Edge. Bezier curves are used to model smooth gradual curves in paths between nodes.
 */
class BezierEdgeStatic extends BezierEdgeBase {
  /**
   * Create a new instance.
   * @param options - The options object of given edge.
   * @param body - The body of the network.
   * @param labelModule - Label module.
   */
  constructor(options, body, labelModule) {
    super(options, body, labelModule);
  }
  /** @inheritDoc */
  _line(ctx, values, viaNode) {
    this._bezierCurve(ctx, values, viaNode);
  }
  /** @inheritDoc */
  getViaNode() {
    return this._getViaCoordinates();
  }
  /**
   * Compute the coordinates of the via node.
   * @remarks
   * We do not use the to and fromPoints here to make the via nodes the same as edges without arrows.
   * @returns Cartesian coordinates of the via node.
   */
  _getViaCoordinates() {
    // Assumption: x/y coordinates in from/to always defined
    const factor = this.options.smooth.roundness;
    const type = this.options.smooth.type;
    let dx = Math.abs(this.from.x - this.to.x);
    let dy = Math.abs(this.from.y - this.to.y);
    if (type === "discrete" || type === "diagonalCross") {
      let stepX;
      let stepY;
      if (dx <= dy) {
        stepX = stepY = factor * dy;
      } else {
        stepX = stepY = factor * dx;
      }
      if (this.from.x > this.to.x) {
        stepX = -stepX;
      }
      if (this.from.y >= this.to.y) {
        stepY = -stepY;
      }
      let xVia = this.from.x + stepX;
      let yVia = this.from.y + stepY;
      if (type === "discrete") {
        if (dx <= dy) {
          xVia = dx < factor * dy ? this.from.x : xVia;
        } else {
          yVia = dy < factor * dx ? this.from.y : yVia;
        }
      }
      return {
        x: xVia,
        y: yVia
      };
    } else if (type === "straightCross") {
      let stepX = (1 - factor) * dx;
      let stepY = (1 - factor) * dy;
      if (dx <= dy) {
        // up - down
        stepX = 0;
        if (this.from.y < this.to.y) {
          stepY = -stepY;
        }
      } else {
        // left - right
        if (this.from.x < this.to.x) {
          stepX = -stepX;
        }
        stepY = 0;
      }
      return {
        x: this.to.x + stepX,
        y: this.to.y + stepY
      };
    } else if (type === "horizontal") {
      let stepX = (1 - factor) * dx;
      if (this.from.x < this.to.x) {
        stepX = -stepX;
      }
      return {
        x: this.to.x + stepX,
        y: this.from.y
      };
    } else if (type === "vertical") {
      let stepY = (1 - factor) * dy;
      if (this.from.y < this.to.y) {
        stepY = -stepY;
      }
      return {
        x: this.from.x,
        y: this.to.y + stepY
      };
    } else if (type === "curvedCW") {
      dx = this.to.x - this.from.x;
      dy = this.from.y - this.to.y;
      const radius = Math.sqrt(dx * dx + dy * dy);
      const pi = Math.PI;
      const originalAngle = Math.atan2(dy, dx);
      const myAngle = (originalAngle + (factor * 0.5 + 0.5) * pi) % (2 * pi);
      return {
        x: this.from.x + (factor * 0.5 + 0.5) * radius * Math.sin(myAngle),
        y: this.from.y + (factor * 0.5 + 0.5) * radius * Math.cos(myAngle)
      };
    } else if (type === "curvedCCW") {
      dx = this.to.x - this.from.x;
      dy = this.from.y - this.to.y;
      const radius = Math.sqrt(dx * dx + dy * dy);
      const pi = Math.PI;
      const originalAngle = Math.atan2(dy, dx);
      const myAngle = (originalAngle + (-factor * 0.5 + 0.5) * pi) % (2 * pi);
      return {
        x: this.from.x + (factor * 0.5 + 0.5) * radius * Math.sin(myAngle),
        y: this.from.y + (factor * 0.5 + 0.5) * radius * Math.cos(myAngle)
      };
    } else {
      // continuous
      let stepX;
      let stepY;
      if (dx <= dy) {
        stepX = stepY = factor * dy;
      } else {
        stepX = stepY = factor * dx;
      }
      if (this.from.x > this.to.x) {
        stepX = -stepX;
      }
      if (this.from.y >= this.to.y) {
        stepY = -stepY;
      }
      let xVia = this.from.x + stepX;
      let yVia = this.from.y + stepY;
      if (dx <= dy) {
        if (this.from.x <= this.to.x) {
          xVia = this.to.x < xVia ? this.to.x : xVia;
        } else {
          xVia = this.to.x > xVia ? this.to.x : xVia;
        }
      } else {
        if (this.from.y >= this.to.y) {
          yVia = this.to.y > yVia ? this.to.y : yVia;
        } else {
          yVia = this.to.y < yVia ? this.to.y : yVia;
        }
      }
      return {
        x: xVia,
        y: yVia
      };
    }
  }
  /** @inheritDoc */
  _findBorderPosition(nearNode, ctx) {
    let options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    return this._findBorderPositionBezier(nearNode, ctx, options.via);
  }
  /** @inheritDoc */
  _getDistanceToEdge(x1, y1, x2, y2, x3, y3) {
    let viaNode = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : this._getViaCoordinates();
    // x3,y3 is the point
    return this._getDistanceToBezierEdge(x1, y1, x2, y2, x3, y3, viaNode);
  }
  /** @inheritDoc */
  getPoint(position) {
    let viaNode = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this._getViaCoordinates();
    const t = position;
    const x = Math.pow(1 - t, 2) * this.fromPoint.x + 2 * t * (1 - t) * viaNode.x + Math.pow(t, 2) * this.toPoint.x;
    const y = Math.pow(1 - t, 2) * this.fromPoint.y + 2 * t * (1 - t) * viaNode.y + Math.pow(t, 2) * this.toPoint.y;
    return {
      x: x,
      y: y
    };
  }
}

/**
 * A Base Class for all Cubic Bezier Edges. Bezier curves are used to model
 * smooth gradual curves in paths between nodes.
 * @augments BezierEdgeBase
 */
class CubicBezierEdgeBase extends BezierEdgeBase {
  /**
   * Create a new instance.
   * @param options - The options object of given edge.
   * @param body - The body of the network.
   * @param labelModule - Label module.
   */
  constructor(options, body, labelModule) {
    super(options, body, labelModule);
  }
  /**
   * Calculate the distance between a point (x3,y3) and a line segment from (x1,y1) to (x2,y2).
   * @remarks
   * http://stackoverflow.com/questions/849211/shortest-distancae-between-a-point-and-a-line-segment
   * https://en.wikipedia.org/wiki/B%C3%A9zier_curve
   * @param x1 - First end of the line segment on the x axis.
   * @param y1 - First end of the line segment on the y axis.
   * @param x2 - Second end of the line segment on the x axis.
   * @param y2 - Second end of the line segment on the y axis.
   * @param x3 - Position of the point on the x axis.
   * @param y3 - Position of the point on the y axis.
   * @param via1 - The first point this edge passes through.
   * @param via2 - The second point this edge passes through.
   * @returns The distance between the line segment and the point.
   */
  _getDistanceToBezierEdge2(x1, y1, x2, y2, x3, y3, via1, via2) {
    // x3,y3 is the point
    let minDistance = 1e9;
    let lastX = x1;
    let lastY = y1;
    const vec = [0, 0, 0, 0];
    for (let i = 1; i < 10; i++) {
      const t = 0.1 * i;
      vec[0] = Math.pow(1 - t, 3);
      vec[1] = 3 * t * Math.pow(1 - t, 2);
      vec[2] = 3 * Math.pow(t, 2) * (1 - t);
      vec[3] = Math.pow(t, 3);
      const x = vec[0] * x1 + vec[1] * via1.x + vec[2] * via2.x + vec[3] * x2;
      const y = vec[0] * y1 + vec[1] * via1.y + vec[2] * via2.y + vec[3] * y2;
      if (i > 0) {
        const distance = this._getDistanceToLine(lastX, lastY, x, y, x3, y3);
        minDistance = distance < minDistance ? distance : minDistance;
      }
      lastX = x;
      lastY = y;
    }
    return minDistance;
  }
}

/**
 * A Cubic Bezier Edge. Bezier curves are used to model smooth gradual curves in paths between nodes.
 */
class CubicBezierEdge extends CubicBezierEdgeBase {
  /**
   * Create a new instance.
   * @param options - The options object of given edge.
   * @param body - The body of the network.
   * @param labelModule - Label module.
   */
  constructor(options, body, labelModule) {
    super(options, body, labelModule);
  }
  /** @inheritDoc */
  _line(ctx, values, viaNodes) {
    // get the coordinates of the support points.
    const via1 = viaNodes[0];
    const via2 = viaNodes[1];
    this._bezierCurve(ctx, values, via1, via2);
  }
  /**
   * Compute the additional points the edge passes through.
   * @returns Cartesian coordinates of the points the edge passes through.
   */
  _getViaCoordinates() {
    const dx = this.from.x - this.to.x;
    const dy = this.from.y - this.to.y;
    let x1;
    let y1;
    let x2;
    let y2;
    const roundness = this.options.smooth.roundness;
    // horizontal if x > y or if direction is forced or if direction is horizontal
    if ((Math.abs(dx) > Math.abs(dy) || this.options.smooth.forceDirection === true || this.options.smooth.forceDirection === "horizontal") && this.options.smooth.forceDirection !== "vertical") {
      y1 = this.from.y;
      y2 = this.to.y;
      x1 = this.from.x - roundness * dx;
      x2 = this.to.x + roundness * dx;
    } else {
      y1 = this.from.y - roundness * dy;
      y2 = this.to.y + roundness * dy;
      x1 = this.from.x;
      x2 = this.to.x;
    }
    return [{
      x: x1,
      y: y1
    }, {
      x: x2,
      y: y2
    }];
  }
  /** @inheritDoc */
  getViaNode() {
    return this._getViaCoordinates();
  }
  /** @inheritDoc */
  _findBorderPosition(nearNode, ctx) {
    return this._findBorderPositionBezier(nearNode, ctx);
  }
  /** @inheritDoc */
  _getDistanceToEdge(x1, y1, x2, y2, x3, y3) {
    let [via1, via2] = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : this._getViaCoordinates();
    // x3,y3 is the point
    return this._getDistanceToBezierEdge2(x1, y1, x2, y2, x3, y3, via1, via2);
  }
  /** @inheritDoc */
  getPoint(position) {
    let [via1, via2] = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this._getViaCoordinates();
    const t = position;
    const vec = [Math.pow(1 - t, 3), 3 * t * Math.pow(1 - t, 2), 3 * Math.pow(t, 2) * (1 - t), Math.pow(t, 3)];
    const x = vec[0] * this.fromPoint.x + vec[1] * via1.x + vec[2] * via2.x + vec[3] * this.toPoint.x;
    const y = vec[0] * this.fromPoint.y + vec[1] * via1.y + vec[2] * via2.y + vec[3] * this.toPoint.y;
    return {
      x: x,
      y: y
    };
  }
}

/**
 * A Straight Edge.
 */
class StraightEdge extends EdgeBase {
  /**
   * Create a new instance.
   * @param options - The options object of given edge.
   * @param body - The body of the network.
   * @param labelModule - Label module.
   */
  constructor(options, body, labelModule) {
    super(options, body, labelModule);
  }
  /** @inheritDoc */
  _line(ctx, values) {
    // draw a straight line
    ctx.beginPath();
    ctx.moveTo(this.fromPoint.x, this.fromPoint.y);
    ctx.lineTo(this.toPoint.x, this.toPoint.y);
    // draw shadow if enabled
    this.enableShadow(ctx, values);
    ctx.stroke();
    this.disableShadow(ctx, values);
  }
  /** @inheritDoc */
  getViaNode() {
    return undefined;
  }
  /** @inheritDoc */
  getPoint(position) {
    return {
      x: (1 - position) * this.fromPoint.x + position * this.toPoint.x,
      y: (1 - position) * this.fromPoint.y + position * this.toPoint.y
    };
  }
  /** @inheritDoc */
  _findBorderPosition(nearNode, ctx) {
    let node1 = this.to;
    let node2 = this.from;
    if (nearNode.id === this.from.id) {
      node1 = this.from;
      node2 = this.to;
    }
    const angle = Math.atan2(node1.y - node2.y, node1.x - node2.x);
    const dx = node1.x - node2.x;
    const dy = node1.y - node2.y;
    const edgeSegmentLength = Math.sqrt(dx * dx + dy * dy);
    const toBorderDist = nearNode.distanceToBorder(ctx, angle);
    const toBorderPoint = (edgeSegmentLength - toBorderDist) / edgeSegmentLength;
    return {
      x: (1 - toBorderPoint) * node2.x + toBorderPoint * node1.x,
      y: (1 - toBorderPoint) * node2.y + toBorderPoint * node1.y,
      t: 0
    };
  }
  /** @inheritDoc */
  _getDistanceToEdge(x1, y1, x2, y2, x3, y3) {
    // x3,y3 is the point
    return this._getDistanceToLine(x1, y1, x2, y2, x3, y3);
  }
}

/**
 * An edge connects two nodes and has a specific direction.
 */
class Edge {
  /**
   * @param {object} options        values specific to this edge, must contain at least 'from' and 'to'
   * @param {object} body           shared state from Network instance
   * @param {Network.Images} imagelist  A list with images. Only needed when the edge has image arrows.
   * @param {object} globalOptions  options from the EdgesHandler instance
   * @param {object} defaultOptions default options from the EdgeHandler instance. Value and reference are constant
   */
  constructor(options, body, imagelist, globalOptions, defaultOptions) {
    if (body === undefined) {
      throw new Error("No body provided");
    }

    // Since globalOptions is constant in values as well as reference,
    // Following needs to be done only once.

    this.options = bridgeObject(globalOptions);
    this.globalOptions = globalOptions;
    this.defaultOptions = defaultOptions;
    this.body = body;
    this.imagelist = imagelist;

    // initialize variables
    this.id = undefined;
    this.fromId = undefined;
    this.toId = undefined;
    this.selected = false;
    this.hover = false;
    this.labelDirty = true;
    this.baseWidth = this.options.width;
    this.baseFontSize = this.options.font.size;
    this.from = undefined; // a node
    this.to = undefined; // a node

    this.edgeType = undefined;
    this.connected = false;
    this.labelModule = new Label(this.body, this.options, true /* It's an edge label */);

    this.setOptions(options);
  }

  /**
   * Set or overwrite options for the edge
   * @param {object} options  an object with options
   * @returns {undefined|boolean} undefined if no options, true if layout affecting data changed, false otherwise.
   */
  setOptions(options) {
    if (!options) {
      return;
    }

    // Following options if changed affect the layout.
    let affectsLayout = typeof options.physics !== "undefined" && this.options.physics !== options.physics || typeof options.hidden !== "undefined" && (this.options.hidden || false) !== (options.hidden || false) || typeof options.from !== "undefined" && this.options.from !== options.from || typeof options.to !== "undefined" && this.options.to !== options.to;
    Edge.parseOptions(this.options, options, true, this.globalOptions);
    if (options.id !== undefined) {
      this.id = options.id;
    }
    if (options.from !== undefined) {
      this.fromId = options.from;
    }
    if (options.to !== undefined) {
      this.toId = options.to;
    }
    if (options.title !== undefined) {
      this.title = options.title;
    }
    if (options.value !== undefined) {
      options.value = _parseFloat$1(options.value);
    }
    const pile = [options, this.options, this.defaultOptions];
    this.chooser = choosify("edge", pile);

    // update label Module
    this.updateLabelModule(options);

    // Update edge type, this if changed affects the layout.
    affectsLayout = this.updateEdgeType() || affectsLayout;

    // if anything has been updates, reset the selection width and the hover width
    this._setInteractionWidths();

    // A node is connected when it has a from and to node that both exist in the network.body.nodes.
    this.connect();
    return affectsLayout;
  }

  /**
   *
   * @param {object} parentOptions
   * @param {object} newOptions
   * @param {boolean} [allowDeletion]
   * @param {object} [globalOptions]
   * @param {boolean} [copyFromGlobals]
   */
  static parseOptions(parentOptions, newOptions) {
    let allowDeletion = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
    let globalOptions = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};
    let copyFromGlobals = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : false;
    const fields = ["endPointOffset", "arrowStrikethrough", "id", "from", "hidden", "hoverWidth", "labelHighlightBold", "length", "line", "opacity", "physics", "scaling", "selectionWidth", "selfReferenceSize", "selfReference", "to", "title", "value", "width", "font", "chosen", "widthConstraint"];

    // only deep extend the items in the field array. These do not have shorthand.
    selectiveDeepExtend(fields, parentOptions, newOptions, allowDeletion);

    // Only use endPointOffset values (from and to) if it's valid values
    if (newOptions.endPointOffset !== undefined && newOptions.endPointOffset.from !== undefined) {
      if (_Number$isFinite(newOptions.endPointOffset.from)) {
        parentOptions.endPointOffset.from = newOptions.endPointOffset.from;
      } else {
        parentOptions.endPointOffset.from = globalOptions.endPointOffset.from !== undefined ? globalOptions.endPointOffset.from : 0;
        console.error("endPointOffset.from is not a valid number");
      }
    }
    if (newOptions.endPointOffset !== undefined && newOptions.endPointOffset.to !== undefined) {
      if (_Number$isFinite(newOptions.endPointOffset.to)) {
        parentOptions.endPointOffset.to = newOptions.endPointOffset.to;
      } else {
        parentOptions.endPointOffset.to = globalOptions.endPointOffset.to !== undefined ? globalOptions.endPointOffset.to : 0;
        console.error("endPointOffset.to is not a valid number");
      }
    }

    // Only copy label if it's a legal value.
    if (isValidLabel(newOptions.label)) {
      parentOptions.label = newOptions.label;
    } else if (!isValidLabel(parentOptions.label)) {
      parentOptions.label = undefined;
    }
    mergeOptions(parentOptions, newOptions, "smooth", globalOptions);
    mergeOptions(parentOptions, newOptions, "shadow", globalOptions);
    mergeOptions(parentOptions, newOptions, "background", globalOptions);
    if (newOptions.dashes !== undefined && newOptions.dashes !== null) {
      parentOptions.dashes = newOptions.dashes;
    } else if (allowDeletion === true && newOptions.dashes === null) {
      parentOptions.dashes = _Object$create(globalOptions.dashes); // this sets the pointer of the option back to the global option.
    }

    // set the scaling newOptions
    if (newOptions.scaling !== undefined && newOptions.scaling !== null) {
      if (newOptions.scaling.min !== undefined) {
        parentOptions.scaling.min = newOptions.scaling.min;
      }
      if (newOptions.scaling.max !== undefined) {
        parentOptions.scaling.max = newOptions.scaling.max;
      }
      mergeOptions(parentOptions.scaling, newOptions.scaling, "label", globalOptions.scaling);
    } else if (allowDeletion === true && newOptions.scaling === null) {
      parentOptions.scaling = _Object$create(globalOptions.scaling); // this sets the pointer of the option back to the global option.
    }

    // handle multiple input cases for arrows
    if (newOptions.arrows !== undefined && newOptions.arrows !== null) {
      if (typeof newOptions.arrows === "string") {
        const arrows = newOptions.arrows.toLowerCase();
        parentOptions.arrows.to.enabled = _indexOfInstanceProperty(arrows).call(arrows, "to") != -1;
        parentOptions.arrows.middle.enabled = _indexOfInstanceProperty(arrows).call(arrows, "middle") != -1;
        parentOptions.arrows.from.enabled = _indexOfInstanceProperty(arrows).call(arrows, "from") != -1;
      } else if (typeof newOptions.arrows === "object") {
        mergeOptions(parentOptions.arrows, newOptions.arrows, "to", globalOptions.arrows);
        mergeOptions(parentOptions.arrows, newOptions.arrows, "middle", globalOptions.arrows);
        mergeOptions(parentOptions.arrows, newOptions.arrows, "from", globalOptions.arrows);
      } else {
        throw new Error("The arrow newOptions can only be an object or a string. Refer to the documentation. You used:" + _JSON$stringify(newOptions.arrows));
      }
    } else if (allowDeletion === true && newOptions.arrows === null) {
      parentOptions.arrows = _Object$create(globalOptions.arrows); // this sets the pointer of the option back to the global option.
    }

    // handle multiple input cases for color
    if (newOptions.color !== undefined && newOptions.color !== null) {
      const fromColor = isString(newOptions.color) ? {
        color: newOptions.color,
        highlight: newOptions.color,
        hover: newOptions.color,
        inherit: false,
        opacity: 1
      } : newOptions.color;
      const toColor = parentOptions.color;

      // If passed, fill in values from default options - required in the case of no prototype bridging
      if (copyFromGlobals) {
        deepExtend(toColor, globalOptions.color, false, allowDeletion);
      } else {
        // Clear local properties - need to do it like this in order to retain prototype bridges
        for (const i in toColor) {
          if (Object.prototype.hasOwnProperty.call(toColor, i)) {
            delete toColor[i];
          }
        }
      }
      if (isString(toColor)) {
        toColor.color = toColor;
        toColor.highlight = toColor;
        toColor.hover = toColor;
        toColor.inherit = false;
        if (fromColor.opacity === undefined) {
          toColor.opacity = 1.0; // set default
        }
      } else {
        let colorsDefined = false;
        if (fromColor.color !== undefined) {
          toColor.color = fromColor.color;
          colorsDefined = true;
        }
        if (fromColor.highlight !== undefined) {
          toColor.highlight = fromColor.highlight;
          colorsDefined = true;
        }
        if (fromColor.hover !== undefined) {
          toColor.hover = fromColor.hover;
          colorsDefined = true;
        }
        if (fromColor.inherit !== undefined) {
          toColor.inherit = fromColor.inherit;
        }
        if (fromColor.opacity !== undefined) {
          toColor.opacity = Math.min(1, Math.max(0, fromColor.opacity));
        }
        if (colorsDefined === true) {
          toColor.inherit = false;
        } else {
          if (toColor.inherit === undefined) {
            toColor.inherit = "from"; // Set default
          }
        }
      }
    } else if (allowDeletion === true && newOptions.color === null) {
      parentOptions.color = bridgeObject(globalOptions.color); // set the object back to the global options
    }

    if (allowDeletion === true && newOptions.font === null) {
      parentOptions.font = bridgeObject(globalOptions.font); // set the object back to the global options
    }

    if (Object.prototype.hasOwnProperty.call(newOptions, "selfReferenceSize")) {
      console.warn("The selfReferenceSize property has been deprecated. Please use selfReference property instead. The selfReference can be set like thise selfReference:{size:30, angle:Math.PI / 4}");
      parentOptions.selfReference.size = newOptions.selfReferenceSize;
    }
  }

  /**
   *
   * @returns {ArrowOptions}
   */
  getFormattingValues() {
    const toArrow = this.options.arrows.to === true || this.options.arrows.to.enabled === true;
    const fromArrow = this.options.arrows.from === true || this.options.arrows.from.enabled === true;
    const middleArrow = this.options.arrows.middle === true || this.options.arrows.middle.enabled === true;
    const inheritsColor = this.options.color.inherit;
    const values = {
      toArrow: toArrow,
      toArrowScale: this.options.arrows.to.scaleFactor,
      toArrowType: this.options.arrows.to.type,
      toArrowSrc: this.options.arrows.to.src,
      toArrowImageWidth: this.options.arrows.to.imageWidth,
      toArrowImageHeight: this.options.arrows.to.imageHeight,
      middleArrow: middleArrow,
      middleArrowScale: this.options.arrows.middle.scaleFactor,
      middleArrowType: this.options.arrows.middle.type,
      middleArrowSrc: this.options.arrows.middle.src,
      middleArrowImageWidth: this.options.arrows.middle.imageWidth,
      middleArrowImageHeight: this.options.arrows.middle.imageHeight,
      fromArrow: fromArrow,
      fromArrowScale: this.options.arrows.from.scaleFactor,
      fromArrowType: this.options.arrows.from.type,
      fromArrowSrc: this.options.arrows.from.src,
      fromArrowImageWidth: this.options.arrows.from.imageWidth,
      fromArrowImageHeight: this.options.arrows.from.imageHeight,
      arrowStrikethrough: this.options.arrowStrikethrough,
      color: inheritsColor ? undefined : this.options.color.color,
      inheritsColor: inheritsColor,
      opacity: this.options.color.opacity,
      hidden: this.options.hidden,
      length: this.options.length,
      shadow: this.options.shadow.enabled,
      shadowColor: this.options.shadow.color,
      shadowSize: this.options.shadow.size,
      shadowX: this.options.shadow.x,
      shadowY: this.options.shadow.y,
      dashes: this.options.dashes,
      width: this.options.width,
      background: this.options.background.enabled,
      backgroundColor: this.options.background.color,
      backgroundSize: this.options.background.size,
      backgroundDashes: this.options.background.dashes
    };
    if (this.selected || this.hover) {
      if (this.chooser === true) {
        if (this.selected) {
          const selectedWidth = this.options.selectionWidth;
          if (typeof selectedWidth === "function") {
            values.width = selectedWidth(values.width);
          } else if (typeof selectedWidth === "number") {
            values.width += selectedWidth;
          }
          values.width = Math.max(values.width, 0.3 / this.body.view.scale);
          values.color = this.options.color.highlight;
          values.shadow = this.options.shadow.enabled;
        } else if (this.hover) {
          const hoverWidth = this.options.hoverWidth;
          if (typeof hoverWidth === "function") {
            values.width = hoverWidth(values.width);
          } else if (typeof hoverWidth === "number") {
            values.width += hoverWidth;
          }
          values.width = Math.max(values.width, 0.3 / this.body.view.scale);
          values.color = this.options.color.hover;
          values.shadow = this.options.shadow.enabled;
        }
      } else if (typeof this.chooser === "function") {
        this.chooser(values, this.options.id, this.selected, this.hover);
        if (values.color !== undefined) {
          values.inheritsColor = false;
        }
        if (values.shadow === false) {
          if (values.shadowColor !== this.options.shadow.color || values.shadowSize !== this.options.shadow.size || values.shadowX !== this.options.shadow.x || values.shadowY !== this.options.shadow.y) {
            values.shadow = true;
          }
        }
      }
    } else {
      values.shadow = this.options.shadow.enabled;
      values.width = Math.max(values.width, 0.3 / this.body.view.scale);
    }
    return values;
  }

  /**
   * update the options in the label module
   * @param {object} options
   */
  updateLabelModule(options) {
    const pile = [options, this.options, this.globalOptions,
    // Currently set global edge options
    this.defaultOptions];
    this.labelModule.update(this.options, pile);
    if (this.labelModule.baseSize !== undefined) {
      this.baseFontSize = this.labelModule.baseSize;
    }
  }

  /**
   * update the edge type, set the options
   * @returns {boolean}
   */
  updateEdgeType() {
    const smooth = this.options.smooth;
    let dataChanged = false;
    let changeInType = true;
    if (this.edgeType !== undefined) {
      if (this.edgeType instanceof BezierEdgeDynamic && smooth.enabled === true && smooth.type === "dynamic" || this.edgeType instanceof CubicBezierEdge && smooth.enabled === true && smooth.type === "cubicBezier" || this.edgeType instanceof BezierEdgeStatic && smooth.enabled === true && smooth.type !== "dynamic" && smooth.type !== "cubicBezier" || this.edgeType instanceof StraightEdge && smooth.type.enabled === false) {
        changeInType = false;
      }
      if (changeInType === true) {
        dataChanged = this.cleanup();
      }
    }
    if (changeInType === true) {
      if (smooth.enabled === true) {
        if (smooth.type === "dynamic") {
          dataChanged = true;
          this.edgeType = new BezierEdgeDynamic(this.options, this.body, this.labelModule);
        } else if (smooth.type === "cubicBezier") {
          this.edgeType = new CubicBezierEdge(this.options, this.body, this.labelModule);
        } else {
          this.edgeType = new BezierEdgeStatic(this.options, this.body, this.labelModule);
        }
      } else {
        this.edgeType = new StraightEdge(this.options, this.body, this.labelModule);
      }
    } else {
      // if nothing changes, we just set the options.
      this.edgeType.setOptions(this.options);
    }
    return dataChanged;
  }

  /**
   * Connect an edge to its nodes
   */
  connect() {
    this.disconnect();
    this.from = this.body.nodes[this.fromId] || undefined;
    this.to = this.body.nodes[this.toId] || undefined;
    this.connected = this.from !== undefined && this.to !== undefined;
    if (this.connected === true) {
      this.from.attachEdge(this);
      this.to.attachEdge(this);
    } else {
      if (this.from) {
        this.from.detachEdge(this);
      }
      if (this.to) {
        this.to.detachEdge(this);
      }
    }
    this.edgeType.connect();
  }

  /**
   * Disconnect an edge from its nodes
   */
  disconnect() {
    if (this.from) {
      this.from.detachEdge(this);
      this.from = undefined;
    }
    if (this.to) {
      this.to.detachEdge(this);
      this.to = undefined;
    }
    this.connected = false;
  }

  /**
   * get the title of this edge.
   * @returns {string} title    The title of the edge, or undefined when no title
   *                           has been set.
   */
  getTitle() {
    return this.title;
  }

  /**
   * check if this node is selecte
   * @returns {boolean} selected   True if node is selected, else false
   */
  isSelected() {
    return this.selected;
  }

  /**
   * Retrieve the value of the edge. Can be undefined
   * @returns {number} value
   */
  getValue() {
    return this.options.value;
  }

  /**
   * Adjust the value range of the edge. The edge will adjust it's width
   * based on its value.
   * @param {number} min
   * @param {number} max
   * @param {number} total
   */
  setValueRange(min, max, total) {
    if (this.options.value !== undefined) {
      const scale = this.options.scaling.customScalingFunction(min, max, total, this.options.value);
      const widthDiff = this.options.scaling.max - this.options.scaling.min;
      if (this.options.scaling.label.enabled === true) {
        const fontDiff = this.options.scaling.label.max - this.options.scaling.label.min;
        this.options.font.size = this.options.scaling.label.min + scale * fontDiff;
      }
      this.options.width = this.options.scaling.min + scale * widthDiff;
    } else {
      this.options.width = this.baseWidth;
      this.options.font.size = this.baseFontSize;
    }
    this._setInteractionWidths();
    this.updateLabelModule();
  }

  /**
   *
   * @private
   */
  _setInteractionWidths() {
    if (typeof this.options.hoverWidth === "function") {
      this.edgeType.hoverWidth = this.options.hoverWidth(this.options.width);
    } else {
      this.edgeType.hoverWidth = this.options.hoverWidth + this.options.width;
    }
    if (typeof this.options.selectionWidth === "function") {
      this.edgeType.selectionWidth = this.options.selectionWidth(this.options.width);
    } else {
      this.edgeType.selectionWidth = this.options.selectionWidth + this.options.width;
    }
  }

  /**
   * Redraw a edge
   * Draw this edge in the given canvas
   * The 2d context of a HTML canvas can be retrieved by canvas.getContext("2d");
   * @param {CanvasRenderingContext2D}   ctx
   */
  draw(ctx) {
    const values = this.getFormattingValues();
    if (values.hidden) {
      return;
    }

    // get the via node from the edge type
    const viaNode = this.edgeType.getViaNode();

    // draw line and label
    this.edgeType.drawLine(ctx, values, this.selected, this.hover, viaNode);
    this.drawLabel(ctx, viaNode);
  }

  /**
   * Redraw arrows
   * Draw this arrows in the given canvas
   * The 2d context of a HTML canvas can be retrieved by canvas.getContext("2d");
   * @param {CanvasRenderingContext2D}   ctx
   */
  drawArrows(ctx) {
    const values = this.getFormattingValues();
    if (values.hidden) {
      return;
    }

    // get the via node from the edge type
    const viaNode = this.edgeType.getViaNode();
    const arrowData = {};

    // restore edge targets to defaults
    this.edgeType.fromPoint = this.edgeType.from;
    this.edgeType.toPoint = this.edgeType.to;

    // from and to arrows give a different end point for edges. we set them here
    if (values.fromArrow) {
      arrowData.from = this.edgeType.getArrowData(ctx, "from", viaNode, this.selected, this.hover, values);
      if (values.arrowStrikethrough === false) this.edgeType.fromPoint = arrowData.from.core;
      if (values.fromArrowSrc) {
        arrowData.from.image = this.imagelist.load(values.fromArrowSrc);
      }
      if (values.fromArrowImageWidth) {
        arrowData.from.imageWidth = values.fromArrowImageWidth;
      }
      if (values.fromArrowImageHeight) {
        arrowData.from.imageHeight = values.fromArrowImageHeight;
      }
    }
    if (values.toArrow) {
      arrowData.to = this.edgeType.getArrowData(ctx, "to", viaNode, this.selected, this.hover, values);
      if (values.arrowStrikethrough === false) this.edgeType.toPoint = arrowData.to.core;
      if (values.toArrowSrc) {
        arrowData.to.image = this.imagelist.load(values.toArrowSrc);
      }
      if (values.toArrowImageWidth) {
        arrowData.to.imageWidth = values.toArrowImageWidth;
      }
      if (values.toArrowImageHeight) {
        arrowData.to.imageHeight = values.toArrowImageHeight;
      }
    }

    // the middle arrow depends on the line, which can depend on the to and from arrows so we do this one lastly.
    if (values.middleArrow) {
      arrowData.middle = this.edgeType.getArrowData(ctx, "middle", viaNode, this.selected, this.hover, values);
      if (values.middleArrowSrc) {
        arrowData.middle.image = this.imagelist.load(values.middleArrowSrc);
      }
      if (values.middleArrowImageWidth) {
        arrowData.middle.imageWidth = values.middleArrowImageWidth;
      }
      if (values.middleArrowImageHeight) {
        arrowData.middle.imageHeight = values.middleArrowImageHeight;
      }
    }
    if (values.fromArrow) {
      this.edgeType.drawArrowHead(ctx, values, this.selected, this.hover, arrowData.from);
    }
    if (values.middleArrow) {
      this.edgeType.drawArrowHead(ctx, values, this.selected, this.hover, arrowData.middle);
    }
    if (values.toArrow) {
      this.edgeType.drawArrowHead(ctx, values, this.selected, this.hover, arrowData.to);
    }
  }

  /**
   *
   * @param {CanvasRenderingContext2D} ctx
   * @param {Node} viaNode
   */
  drawLabel(ctx, viaNode) {
    if (this.options.label !== undefined) {
      // set style
      const node1 = this.from;
      const node2 = this.to;
      if (this.labelModule.differentState(this.selected, this.hover)) {
        this.labelModule.getTextSize(ctx, this.selected, this.hover);
      }
      let point;
      if (node1.id != node2.id) {
        this.labelModule.pointToSelf = false;
        point = this.edgeType.getPoint(0.5, viaNode);
        ctx.save();
        const rotationPoint = this._getRotation(ctx);
        if (rotationPoint.angle != 0) {
          ctx.translate(rotationPoint.x, rotationPoint.y);
          ctx.rotate(rotationPoint.angle);
        }

        // draw the label
        this.labelModule.draw(ctx, point.x, point.y, this.selected, this.hover);

        /*
        // Useful debug code: draw a border around the label
        // This should **not** be enabled in production!
        var size = this.labelModule.getSize();; // ;; intentional so lint catches it
        ctx.strokeStyle = "#ff0000";
        ctx.strokeRect(size.left, size.top, size.width, size.height);
        // End  debug code
        */

        ctx.restore();
      } else {
        // Ignore the orientations.
        this.labelModule.pointToSelf = true;

        // get circle coordinates
        const coordinates = getSelfRefCoordinates(ctx, this.options.selfReference.angle, this.options.selfReference.size, node1);
        point = this._pointOnCircle(coordinates.x, coordinates.y, this.options.selfReference.size, this.options.selfReference.angle);
        this.labelModule.draw(ctx, point.x, point.y, this.selected, this.hover);
      }
    }
  }

  /**
   * Determine all visual elements of this edge instance, in which the given
   * point falls within the bounding shape.
   * @param {point} point
   * @returns {Array.<edgeClickItem|edgeLabelClickItem>} list with the items which are on the point
   */
  getItemsOnPoint(point) {
    const ret = [];
    if (this.labelModule.visible()) {
      const rotationPoint = this._getRotation();
      if (pointInRect(this.labelModule.getSize(), point, rotationPoint)) {
        ret.push({
          edgeId: this.id,
          labelId: 0
        });
      }
    }
    const obj = {
      left: point.x,
      top: point.y
    };
    if (this.isOverlappingWith(obj)) {
      ret.push({
        edgeId: this.id
      });
    }
    return ret;
  }

  /**
   * Check if this object is overlapping with the provided object
   * @param {object} obj   an object with parameters left, top
   * @returns {boolean}     True if location is located on the edge
   */
  isOverlappingWith(obj) {
    if (this.connected) {
      const distMax = 10;
      const xFrom = this.from.x;
      const yFrom = this.from.y;
      const xTo = this.to.x;
      const yTo = this.to.y;
      const xObj = obj.left;
      const yObj = obj.top;
      const dist = this.edgeType.getDistanceToEdge(xFrom, yFrom, xTo, yTo, xObj, yObj);
      return dist < distMax;
    } else {
      return false;
    }
  }

  /**
   * Determine the rotation point, if any.
   * @param {CanvasRenderingContext2D} [ctx] if passed, do a recalculation of the label size
   * @returns {rotationPoint} the point to rotate around and the angle in radians to rotate
   * @private
   */
  _getRotation(ctx) {
    const viaNode = this.edgeType.getViaNode();
    const point = this.edgeType.getPoint(0.5, viaNode);
    if (ctx !== undefined) {
      this.labelModule.calculateLabelSize(ctx, this.selected, this.hover, point.x, point.y);
    }
    const ret = {
      x: point.x,
      y: this.labelModule.size.yLine,
      angle: 0
    };
    if (!this.labelModule.visible()) {
      return ret; // Don't even bother doing the atan2, there's nothing to draw
    }

    if (this.options.font.align === "horizontal") {
      return ret; // No need to calculate angle
    }

    const dy = this.from.y - this.to.y;
    const dx = this.from.x - this.to.x;
    let angle = Math.atan2(dy, dx); // radians

    // rotate so that label is readable
    if (angle < -1 && dx < 0 || angle > 0 && dx < 0) {
      angle += Math.PI;
    }
    ret.angle = angle;
    return ret;
  }

  /**
   * Get a point on a circle
   * @param {number} x
   * @param {number} y
   * @param {number} radius
   * @param {number} angle
   * @returns {object} point
   * @private
   */
  _pointOnCircle(x, y, radius, angle) {
    return {
      x: x + radius * Math.cos(angle),
      y: y - radius * Math.sin(angle)
    };
  }

  /**
   * Sets selected state to true
   */
  select() {
    this.selected = true;
  }

  /**
   * Sets selected state to false
   */
  unselect() {
    this.selected = false;
  }

  /**
   * cleans all required things on delete
   * @returns {*}
   */
  cleanup() {
    return this.edgeType.cleanup();
  }

  /**
   * Remove edge from the list and perform necessary cleanup.
   */
  remove() {
    this.cleanup();
    this.disconnect();
    delete this.body.edges[this.id];
  }

  /**
   * Check if both connecting nodes exist
   * @returns {boolean}
   */
  endPointsValid() {
    return this.body.nodes[this.fromId] !== undefined && this.body.nodes[this.toId] !== undefined;
  }
}

/**
 * Handler for Edges
 */
class EdgesHandler {
  /**
   * @param {object} body
   * @param {Array.<Image>} images
   * @param {Array.<Group>} groups
   */
  constructor(body, images, groups) {
    var _context;
    this.body = body;
    this.images = images;
    this.groups = groups;

    // create the edge API in the body container
    this.body.functions.createEdge = _bindInstanceProperty(_context = this.create).call(_context, this);
    this.edgesListeners = {
      add: (event, params) => {
        this.add(params.items);
      },
      update: (event, params) => {
        this.update(params.items);
      },
      remove: (event, params) => {
        this.remove(params.items);
      }
    };
    this.options = {};
    this.defaultOptions = {
      arrows: {
        to: {
          enabled: false,
          scaleFactor: 1,
          type: "arrow"
        },
        // boolean / {arrowScaleFactor:1} / {enabled: false, arrowScaleFactor:1}
        middle: {
          enabled: false,
          scaleFactor: 1,
          type: "arrow"
        },
        from: {
          enabled: false,
          scaleFactor: 1,
          type: "arrow"
        }
      },
      endPointOffset: {
        from: 0,
        to: 0
      },
      arrowStrikethrough: true,
      color: {
        color: "#848484",
        highlight: "#848484",
        hover: "#848484",
        inherit: "from",
        opacity: 1.0
      },
      dashes: false,
      font: {
        color: "#343434",
        size: 14,
        // px
        face: "arial",
        background: "none",
        strokeWidth: 2,
        // px
        strokeColor: "#ffffff",
        align: "horizontal",
        multi: false,
        vadjust: 0,
        bold: {
          mod: "bold"
        },
        boldital: {
          mod: "bold italic"
        },
        ital: {
          mod: "italic"
        },
        mono: {
          mod: "",
          size: 15,
          // px
          face: "courier new",
          vadjust: 2
        }
      },
      hidden: false,
      hoverWidth: 1.5,
      label: undefined,
      labelHighlightBold: true,
      length: undefined,
      physics: true,
      scaling: {
        min: 1,
        max: 15,
        label: {
          enabled: true,
          min: 14,
          max: 30,
          maxVisible: 30,
          drawThreshold: 5
        },
        customScalingFunction: function (min, max, total, value) {
          if (max === min) {
            return 0.5;
          } else {
            const scale = 1 / (max - min);
            return Math.max(0, (value - min) * scale);
          }
        }
      },
      selectionWidth: 1.5,
      selfReference: {
        size: 20,
        angle: Math.PI / 4,
        renderBehindTheNode: true
      },
      shadow: {
        enabled: false,
        color: "rgba(0,0,0,0.5)",
        size: 10,
        x: 5,
        y: 5
      },
      background: {
        enabled: false,
        color: "rgba(111,111,111,1)",
        size: 10,
        dashes: false
      },
      smooth: {
        enabled: true,
        type: "dynamic",
        forceDirection: "none",
        roundness: 0.5
      },
      title: undefined,
      width: 1,
      value: undefined
    };
    deepExtend(this.options, this.defaultOptions);
    this.bindEventListeners();
  }

  /**
   * Binds event listeners
   */
  bindEventListeners() {
    var _this = this,
      _context2,
      _context3;
    // this allows external modules to force all dynamic curves to turn static.
    this.body.emitter.on("_forceDisableDynamicCurves", function (type) {
      let emit = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
      if (type === "dynamic") {
        type = "continuous";
      }
      let dataChanged = false;
      for (const edgeId in _this.body.edges) {
        if (Object.prototype.hasOwnProperty.call(_this.body.edges, edgeId)) {
          const edge = _this.body.edges[edgeId];
          const edgeData = _this.body.data.edges.get(edgeId);

          // only forcibly remove the smooth curve if the data has been set of the edge has the smooth curves defined.
          // this is because a change in the global would not affect these curves.
          if (edgeData != null) {
            const smoothOptions = edgeData.smooth;
            if (smoothOptions !== undefined) {
              if (smoothOptions.enabled === true && smoothOptions.type === "dynamic") {
                if (type === undefined) {
                  edge.setOptions({
                    smooth: false
                  });
                } else {
                  edge.setOptions({
                    smooth: {
                      type: type
                    }
                  });
                }
                dataChanged = true;
              }
            }
          }
        }
      }
      if (emit === true && dataChanged === true) {
        _this.body.emitter.emit("_dataChanged");
      }
    });

    // this is called when options of EXISTING nodes or edges have changed.
    //
    // NOTE: Not true, called when options have NOT changed, for both existing as well as new nodes.
    //       See update() for logic.
    // TODO: Verify and examine the consequences of this. It might still trigger when
    //       non-option fields have changed, but then reconnecting edges is still useless.
    //       Alternatively, it might also be called when edges are removed.
    //
    this.body.emitter.on("_dataUpdated", () => {
      this.reconnectEdges();
    });

    // refresh the edges. Used when reverting from hierarchical layout
    this.body.emitter.on("refreshEdges", _bindInstanceProperty(_context2 = this.refresh).call(_context2, this));
    this.body.emitter.on("refresh", _bindInstanceProperty(_context3 = this.refresh).call(_context3, this));
    this.body.emitter.on("destroy", () => {
      forEach$1(this.edgesListeners, (callback, event) => {
        if (this.body.data.edges) this.body.data.edges.off(event, callback);
      });
      delete this.body.functions.createEdge;
      delete this.edgesListeners.add;
      delete this.edgesListeners.update;
      delete this.edgesListeners.remove;
      delete this.edgesListeners;
    });
  }

  /**
   *
   * @param {object} options
   */
  setOptions(options) {
    if (options !== undefined) {
      // use the parser from the Edge class to fill in all shorthand notations
      Edge.parseOptions(this.options, options, true, this.defaultOptions, true);

      // update smooth settings in all edges
      let dataChanged = false;
      if (options.smooth !== undefined) {
        for (const edgeId in this.body.edges) {
          if (Object.prototype.hasOwnProperty.call(this.body.edges, edgeId)) {
            dataChanged = this.body.edges[edgeId].updateEdgeType() || dataChanged;
          }
        }
      }

      // update fonts in all edges
      if (options.font !== undefined) {
        for (const edgeId in this.body.edges) {
          if (Object.prototype.hasOwnProperty.call(this.body.edges, edgeId)) {
            this.body.edges[edgeId].updateLabelModule();
          }
        }
      }

      // update the state of the variables if needed
      if (options.hidden !== undefined || options.physics !== undefined || dataChanged === true) {
        this.body.emitter.emit("_dataChanged");
      }
    }
  }

  /**
   * Load edges by reading the data table
   * @param {Array | DataSet | DataView} edges    The data containing the edges.
   * @param {boolean} [doNotEmit] - Suppress data changed event.
   * @private
   */
  setData(edges) {
    let doNotEmit = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
    const oldEdgesData = this.body.data.edges;
    if (isDataViewLike("id", edges)) {
      this.body.data.edges = edges;
    } else if (_Array$isArray(edges)) {
      this.body.data.edges = new DataSet();
      this.body.data.edges.add(edges);
    } else if (!edges) {
      this.body.data.edges = new DataSet();
    } else {
      throw new TypeError("Array or DataSet expected");
    }

    // TODO: is this null or undefined or false?
    if (oldEdgesData) {
      // unsubscribe from old dataset
      forEach$1(this.edgesListeners, (callback, event) => {
        oldEdgesData.off(event, callback);
      });
    }

    // remove drawn edges
    this.body.edges = {};

    // TODO: is this null or undefined or false?
    if (this.body.data.edges) {
      // subscribe to new dataset
      forEach$1(this.edgesListeners, (callback, event) => {
        this.body.data.edges.on(event, callback);
      });

      // draw all new nodes
      const ids = this.body.data.edges.getIds();
      this.add(ids, true);
    }
    this.body.emitter.emit("_adjustEdgesForHierarchicalLayout");
    if (doNotEmit === false) {
      this.body.emitter.emit("_dataChanged");
    }
  }

  /**
   * Add edges
   * @param {number[] | string[]} ids
   * @param {boolean} [doNotEmit]
   * @private
   */
  add(ids) {
    let doNotEmit = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
    const edges = this.body.edges;
    const edgesData = this.body.data.edges;
    for (let i = 0; i < ids.length; i++) {
      const id = ids[i];
      const oldEdge = edges[id];
      if (oldEdge) {
        oldEdge.disconnect();
      }
      const data = edgesData.get(id, {
        showInternalIds: true
      });
      edges[id] = this.create(data);
    }
    this.body.emitter.emit("_adjustEdgesForHierarchicalLayout");
    if (doNotEmit === false) {
      this.body.emitter.emit("_dataChanged");
    }
  }

  /**
   * Update existing edges, or create them when not yet existing
   * @param {number[] | string[]} ids
   * @private
   */
  update(ids) {
    const edges = this.body.edges;
    const edgesData = this.body.data.edges;
    let dataChanged = false;
    for (let i = 0; i < ids.length; i++) {
      const id = ids[i];
      const data = edgesData.get(id);
      const edge = edges[id];
      if (edge !== undefined) {
        // update edge
        edge.disconnect();
        dataChanged = edge.setOptions(data) || dataChanged; // if a support node is added, data can be changed.
        edge.connect();
      } else {
        // create edge
        this.body.edges[id] = this.create(data);
        dataChanged = true;
      }
    }
    if (dataChanged === true) {
      this.body.emitter.emit("_adjustEdgesForHierarchicalLayout");
      this.body.emitter.emit("_dataChanged");
    } else {
      this.body.emitter.emit("_dataUpdated");
    }
  }

  /**
   * Remove existing edges. Non existing ids will be ignored
   * @param {number[] | string[]} ids
   * @param {boolean} [emit]
   * @private
   */
  remove(ids) {
    let emit = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
    if (ids.length === 0) return; // early out

    const edges = this.body.edges;
    forEach$1(ids, id => {
      const edge = edges[id];
      if (edge !== undefined) {
        edge.remove();
      }
    });
    if (emit) {
      this.body.emitter.emit("_dataChanged");
    }
  }

  /**
   * Refreshes Edge Handler
   */
  refresh() {
    forEach$1(this.body.edges, (edge, edgeId) => {
      const data = this.body.data.edges.get(edgeId);
      if (data !== undefined) {
        edge.setOptions(data);
      }
    });
  }

  /**
   *
   * @param {object} properties
   * @returns {Edge}
   */
  create(properties) {
    return new Edge(properties, this.body, this.images, this.options, this.defaultOptions);
  }

  /**
   * Reconnect all edges
   * @private
   */
  reconnectEdges() {
    let id;
    const nodes = this.body.nodes;
    const edges = this.body.edges;
    for (id in nodes) {
      if (Object.prototype.hasOwnProperty.call(nodes, id)) {
        nodes[id].edges = [];
      }
    }
    for (id in edges) {
      if (Object.prototype.hasOwnProperty.call(edges, id)) {
        const edge = edges[id];
        edge.from = null;
        edge.to = null;
        edge.connect();
      }
    }
  }

  /**
   *
   * @param {Edge.id} edgeId
   * @returns {Array}
   */
  getConnectedNodes(edgeId) {
    const nodeList = [];
    if (this.body.edges[edgeId] !== undefined) {
      const edge = this.body.edges[edgeId];
      if (edge.fromId !== undefined) {
        nodeList.push(edge.fromId);
      }
      if (edge.toId !== undefined) {
        nodeList.push(edge.toId);
      }
    }
    return nodeList;
  }

  /**
   * There is no direct relation between the nodes and the edges DataSet,
   * so the right place to do call this is in the handler for event `_dataUpdated`.
   */
  _updateState() {
    this._addMissingEdges();
    this._removeInvalidEdges();
  }

  /**
   * Scan for missing nodes and remove corresponding edges, if any.
   * @private
   */
  _removeInvalidEdges() {
    const edgesToDelete = [];
    forEach$1(this.body.edges, (edge, id) => {
      const toNode = this.body.nodes[edge.toId];
      const fromNode = this.body.nodes[edge.fromId];

      // Skip clustering edges here, let the Clustering module handle those
      if (toNode !== undefined && toNode.isCluster === true || fromNode !== undefined && fromNode.isCluster === true) {
        return;
      }
      if (toNode === undefined || fromNode === undefined) {
        edgesToDelete.push(id);
      }
    });
    this.remove(edgesToDelete, false);
  }

  /**
   * add all edges from dataset that are not in the cached state
   * @private
   */
  _addMissingEdges() {
    const edgesData = this.body.data.edges;
    if (edgesData === undefined || edgesData === null) {
      return; // No edges DataSet yet; can happen on startup
    }

    const edges = this.body.edges;
    const addIds = [];
    _forEachInstanceProperty(edgesData).call(edgesData, (edgeData, edgeId) => {
      const edge = edges[edgeId];
      if (edge === undefined) {
        addIds.push(edgeId);
      }
    });
    this.add(addIds, true);
  }
}

/**
 * Barnes Hut Solver
 */
class BarnesHutSolver {
  /**
   * @param {object} body
   * @param {{physicsNodeIndices: Array, physicsEdgeIndices: Array, forces: {}, velocities: {}}} physicsBody
   * @param {object} options
   */
  constructor(body, physicsBody, options) {
    this.body = body;
    this.physicsBody = physicsBody;
    this.barnesHutTree;
    this.setOptions(options);
    this._rng = Alea("BARNES HUT SOLVER");

    // debug: show grid
    // this.body.emitter.on("afterDrawing", (ctx) => {this._debug(ctx,'#ff0000')})
  }

  /**
   *
   * @param {object} options
   */
  setOptions(options) {
    this.options = options;
    this.thetaInversed = 1 / this.options.theta;

    // if 1 then min distance = 0.5, if 0.5 then min distance = 0.5 + 0.5*node.shape.radius
    this.overlapAvoidanceFactor = 1 - Math.max(0, Math.min(1, this.options.avoidOverlap));
  }

  /**
   * This function calculates the forces the nodes apply on each other based on a gravitational model.
   * The Barnes Hut method is used to speed up this N-body simulation.
   * @private
   */
  solve() {
    if (this.options.gravitationalConstant !== 0 && this.physicsBody.physicsNodeIndices.length > 0) {
      let node;
      const nodes = this.body.nodes;
      const nodeIndices = this.physicsBody.physicsNodeIndices;
      const nodeCount = nodeIndices.length;

      // create the tree
      const barnesHutTree = this._formBarnesHutTree(nodes, nodeIndices);

      // for debugging
      this.barnesHutTree = barnesHutTree;

      // place the nodes one by one recursively
      for (let i = 0; i < nodeCount; i++) {
        node = nodes[nodeIndices[i]];
        if (node.options.mass > 0) {
          // starting with root is irrelevant, it never passes the BarnesHutSolver condition
          this._getForceContributions(barnesHutTree.root, node);
        }
      }
    }
  }

  /**
   * @param {object} parentBranch
   * @param {Node} node
   * @private
   */
  _getForceContributions(parentBranch, node) {
    this._getForceContribution(parentBranch.children.NW, node);
    this._getForceContribution(parentBranch.children.NE, node);
    this._getForceContribution(parentBranch.children.SW, node);
    this._getForceContribution(parentBranch.children.SE, node);
  }

  /**
   * This function traverses the barnesHutTree. It checks when it can approximate distant nodes with their center of mass.
   * If a region contains a single node, we check if it is not itself, then we apply the force.
   * @param {object} parentBranch
   * @param {Node} node
   * @private
   */
  _getForceContribution(parentBranch, node) {
    // we get no force contribution from an empty region
    if (parentBranch.childrenCount > 0) {
      // get the distance from the center of mass to the node.
      const dx = parentBranch.centerOfMass.x - node.x;
      const dy = parentBranch.centerOfMass.y - node.y;
      const distance = Math.sqrt(dx * dx + dy * dy);

      // BarnesHutSolver condition
      // original condition : s/d < theta = passed  ===  d/s > 1/theta = passed
      // calcSize = 1/s --> d * 1/s > 1/theta = passed
      if (distance * parentBranch.calcSize > this.thetaInversed) {
        this._calculateForces(distance, dx, dy, node, parentBranch);
      } else {
        // Did not pass the condition, go into children if available
        if (parentBranch.childrenCount === 4) {
          this._getForceContributions(parentBranch, node);
        } else {
          // parentBranch must have only one node, if it was empty we wouldnt be here
          if (parentBranch.children.data.id != node.id) {
            // if it is not self
            this._calculateForces(distance, dx, dy, node, parentBranch);
          }
        }
      }
    }
  }

  /**
   * Calculate the forces based on the distance.
   * @param {number} distance
   * @param {number} dx
   * @param {number} dy
   * @param {Node} node
   * @param {object} parentBranch
   * @private
   */
  _calculateForces(distance, dx, dy, node, parentBranch) {
    if (distance === 0) {
      distance = 0.1;
      dx = distance;
    }
    if (this.overlapAvoidanceFactor < 1 && node.shape.radius) {
      distance = Math.max(0.1 + this.overlapAvoidanceFactor * node.shape.radius, distance - node.shape.radius);
    }

    // the dividing by the distance cubed instead of squared allows us to get the fx and fy components without sines and cosines
    // it is shorthand for gravityforce with distance squared and fx = dx/distance * gravityForce
    const gravityForce = this.options.gravitationalConstant * parentBranch.mass * node.options.mass / Math.pow(distance, 3);
    const fx = dx * gravityForce;
    const fy = dy * gravityForce;
    this.physicsBody.forces[node.id].x += fx;
    this.physicsBody.forces[node.id].y += fy;
  }

  /**
   * This function constructs the barnesHut tree recursively. It creates the root, splits it and starts placing the nodes.
   * @param {Array.<Node>} nodes
   * @param {Array.<number>} nodeIndices
   * @returns {{root: {centerOfMass: {x: number, y: number}, mass: number, range: {minX: number, maxX: number, minY: number, maxY: number}, size: number, calcSize: number, children: {data: null}, maxWidth: number, level: number, childrenCount: number}}} BarnesHutTree
   * @private
   */
  _formBarnesHutTree(nodes, nodeIndices) {
    let node;
    const nodeCount = nodeIndices.length;
    let minX = nodes[nodeIndices[0]].x;
    let minY = nodes[nodeIndices[0]].y;
    let maxX = nodes[nodeIndices[0]].x;
    let maxY = nodes[nodeIndices[0]].y;

    // get the range of the nodes
    for (let i = 1; i < nodeCount; i++) {
      const node = nodes[nodeIndices[i]];
      const x = node.x;
      const y = node.y;
      if (node.options.mass > 0) {
        if (x < minX) {
          minX = x;
        }
        if (x > maxX) {
          maxX = x;
        }
        if (y < minY) {
          minY = y;
        }
        if (y > maxY) {
          maxY = y;
        }
      }
    }
    // make the range a square
    const sizeDiff = Math.abs(maxX - minX) - Math.abs(maxY - minY); // difference between X and Y
    if (sizeDiff > 0) {
      minY -= 0.5 * sizeDiff;
      maxY += 0.5 * sizeDiff;
    } // xSize > ySize
    else {
      minX += 0.5 * sizeDiff;
      maxX -= 0.5 * sizeDiff;
    } // xSize < ySize

    const minimumTreeSize = 1e-5;
    const rootSize = Math.max(minimumTreeSize, Math.abs(maxX - minX));
    const halfRootSize = 0.5 * rootSize;
    const centerX = 0.5 * (minX + maxX),
      centerY = 0.5 * (minY + maxY);

    // construct the barnesHutTree
    const barnesHutTree = {
      root: {
        centerOfMass: {
          x: 0,
          y: 0
        },
        mass: 0,
        range: {
          minX: centerX - halfRootSize,
          maxX: centerX + halfRootSize,
          minY: centerY - halfRootSize,
          maxY: centerY + halfRootSize
        },
        size: rootSize,
        calcSize: 1 / rootSize,
        children: {
          data: null
        },
        maxWidth: 0,
        level: 0,
        childrenCount: 4
      }
    };
    this._splitBranch(barnesHutTree.root);

    // place the nodes one by one recursively
    for (let i = 0; i < nodeCount; i++) {
      node = nodes[nodeIndices[i]];
      if (node.options.mass > 0) {
        this._placeInTree(barnesHutTree.root, node);
      }
    }

    // make global
    return barnesHutTree;
  }

  /**
   * this updates the mass of a branch. this is increased by adding a node.
   * @param {object} parentBranch
   * @param {Node} node
   * @private
   */
  _updateBranchMass(parentBranch, node) {
    const centerOfMass = parentBranch.centerOfMass;
    const totalMass = parentBranch.mass + node.options.mass;
    const totalMassInv = 1 / totalMass;
    centerOfMass.x = centerOfMass.x * parentBranch.mass + node.x * node.options.mass;
    centerOfMass.x *= totalMassInv;
    centerOfMass.y = centerOfMass.y * parentBranch.mass + node.y * node.options.mass;
    centerOfMass.y *= totalMassInv;
    parentBranch.mass = totalMass;
    const biggestSize = Math.max(Math.max(node.height, node.radius), node.width);
    parentBranch.maxWidth = parentBranch.maxWidth < biggestSize ? biggestSize : parentBranch.maxWidth;
  }

  /**
   * determine in which branch the node will be placed.
   * @param {object} parentBranch
   * @param {Node} node
   * @param {boolean} skipMassUpdate
   * @private
   */
  _placeInTree(parentBranch, node, skipMassUpdate) {
    if (skipMassUpdate != true || skipMassUpdate === undefined) {
      // update the mass of the branch.
      this._updateBranchMass(parentBranch, node);
    }
    const range = parentBranch.children.NW.range;
    let region;
    if (range.maxX > node.x) {
      // in NW or SW
      if (range.maxY > node.y) {
        region = "NW";
      } else {
        region = "SW";
      }
    } else {
      // in NE or SE
      if (range.maxY > node.y) {
        region = "NE";
      } else {
        region = "SE";
      }
    }
    this._placeInRegion(parentBranch, node, region);
  }

  /**
   * actually place the node in a region (or branch)
   * @param {object} parentBranch
   * @param {Node} node
   * @param {'NW'| 'NE' | 'SW' | 'SE'} region
   * @private
   */
  _placeInRegion(parentBranch, node, region) {
    const children = parentBranch.children[region];
    switch (children.childrenCount) {
      case 0:
        // place node here
        children.children.data = node;
        children.childrenCount = 1;
        this._updateBranchMass(children, node);
        break;
      case 1:
        // convert into children
        // if there are two nodes exactly overlapping (on init, on opening of cluster etc.)
        // we move one node a little bit and we do not put it in the tree.
        if (children.children.data.x === node.x && children.children.data.y === node.y) {
          node.x += this._rng();
          node.y += this._rng();
        } else {
          this._splitBranch(children);
          this._placeInTree(children, node);
        }
        break;
      case 4:
        // place in branch
        this._placeInTree(children, node);
        break;
    }
  }

  /**
   * this function splits a branch into 4 sub branches. If the branch contained a node, we place it in the subbranch
   * after the split is complete.
   * @param {object} parentBranch
   * @private
   */
  _splitBranch(parentBranch) {
    // if the branch is shaded with a node, replace the node in the new subset.
    let containedNode = null;
    if (parentBranch.childrenCount === 1) {
      containedNode = parentBranch.children.data;
      parentBranch.mass = 0;
      parentBranch.centerOfMass.x = 0;
      parentBranch.centerOfMass.y = 0;
    }
    parentBranch.childrenCount = 4;
    parentBranch.children.data = null;
    this._insertRegion(parentBranch, "NW");
    this._insertRegion(parentBranch, "NE");
    this._insertRegion(parentBranch, "SW");
    this._insertRegion(parentBranch, "SE");
    if (containedNode != null) {
      this._placeInTree(parentBranch, containedNode);
    }
  }

  /**
   * This function subdivides the region into four new segments.
   * Specifically, this inserts a single new segment.
   * It fills the children section of the parentBranch
   * @param {object} parentBranch
   * @param {'NW'| 'NE' | 'SW' | 'SE'} region
   * @private
   */
  _insertRegion(parentBranch, region) {
    let minX, maxX, minY, maxY;
    const childSize = 0.5 * parentBranch.size;
    switch (region) {
      case "NW":
        minX = parentBranch.range.minX;
        maxX = parentBranch.range.minX + childSize;
        minY = parentBranch.range.minY;
        maxY = parentBranch.range.minY + childSize;
        break;
      case "NE":
        minX = parentBranch.range.minX + childSize;
        maxX = parentBranch.range.maxX;
        minY = parentBranch.range.minY;
        maxY = parentBranch.range.minY + childSize;
        break;
      case "SW":
        minX = parentBranch.range.minX;
        maxX = parentBranch.range.minX + childSize;
        minY = parentBranch.range.minY + childSize;
        maxY = parentBranch.range.maxY;
        break;
      case "SE":
        minX = parentBranch.range.minX + childSize;
        maxX = parentBranch.range.maxX;
        minY = parentBranch.range.minY + childSize;
        maxY = parentBranch.range.maxY;
        break;
    }
    parentBranch.children[region] = {
      centerOfMass: {
        x: 0,
        y: 0
      },
      mass: 0,
      range: {
        minX: minX,
        maxX: maxX,
        minY: minY,
        maxY: maxY
      },
      size: 0.5 * parentBranch.size,
      calcSize: 2 * parentBranch.calcSize,
      children: {
        data: null
      },
      maxWidth: 0,
      level: parentBranch.level + 1,
      childrenCount: 0
    };
  }

  //---------------------------  DEBUGGING BELOW  ---------------------------//

  /**
   * This function is for debugging purposed, it draws the tree.
   * @param {CanvasRenderingContext2D} ctx
   * @param {string} color
   * @private
   */
  _debug(ctx, color) {
    if (this.barnesHutTree !== undefined) {
      ctx.lineWidth = 1;
      this._drawBranch(this.barnesHutTree.root, ctx, color);
    }
  }

  /**
   * This function is for debugging purposes. It draws the branches recursively.
   * @param {object} branch
   * @param {CanvasRenderingContext2D} ctx
   * @param {string} color
   * @private
   */
  _drawBranch(branch, ctx, color) {
    if (color === undefined) {
      color = "#FF0000";
    }
    if (branch.childrenCount === 4) {
      this._drawBranch(branch.children.NW, ctx);
      this._drawBranch(branch.children.NE, ctx);
      this._drawBranch(branch.children.SE, ctx);
      this._drawBranch(branch.children.SW, ctx);
    }
    ctx.strokeStyle = color;
    ctx.beginPath();
    ctx.moveTo(branch.range.minX, branch.range.minY);
    ctx.lineTo(branch.range.maxX, branch.range.minY);
    ctx.stroke();
    ctx.beginPath();
    ctx.moveTo(branch.range.maxX, branch.range.minY);
    ctx.lineTo(branch.range.maxX, branch.range.maxY);
    ctx.stroke();
    ctx.beginPath();
    ctx.moveTo(branch.range.maxX, branch.range.maxY);
    ctx.lineTo(branch.range.minX, branch.range.maxY);
    ctx.stroke();
    ctx.beginPath();
    ctx.moveTo(branch.range.minX, branch.range.maxY);
    ctx.lineTo(branch.range.minX, branch.range.minY);
    ctx.stroke();

    /*
     if (branch.mass > 0) {
     ctx.circle(branch.centerOfMass.x, branch.centerOfMass.y, 3*branch.mass);
     ctx.stroke();
     }
     */
  }
}

/**
 * Repulsion Solver
 */
class RepulsionSolver {
  /**
   * @param {object} body
   * @param {{physicsNodeIndices: Array, physicsEdgeIndices: Array, forces: {}, velocities: {}}} physicsBody
   * @param {object} options
   */
  constructor(body, physicsBody, options) {
    this._rng = Alea("REPULSION SOLVER");
    this.body = body;
    this.physicsBody = physicsBody;
    this.setOptions(options);
  }

  /**
   *
   * @param {object} options
   */
  setOptions(options) {
    this.options = options;
  }

  /**
   * Calculate the forces the nodes apply on each other based on a repulsion field.
   * This field is linearly approximated.
   * @private
   */
  solve() {
    let dx, dy, distance, fx, fy, repulsingForce, node1, node2;
    const nodes = this.body.nodes;
    const nodeIndices = this.physicsBody.physicsNodeIndices;
    const forces = this.physicsBody.forces;

    // repulsing forces between nodes
    const nodeDistance = this.options.nodeDistance;

    // approximation constants
    const a = -2 / 3 / nodeDistance;
    const b = 4 / 3;

    // we loop from i over all but the last entree in the array
    // j loops from i+1 to the last. This way we do not double count any of the indices, nor i === j
    for (let i = 0; i < nodeIndices.length - 1; i++) {
      node1 = nodes[nodeIndices[i]];
      for (let j = i + 1; j < nodeIndices.length; j++) {
        node2 = nodes[nodeIndices[j]];
        dx = node2.x - node1.x;
        dy = node2.y - node1.y;
        distance = Math.sqrt(dx * dx + dy * dy);

        // same condition as BarnesHutSolver, making sure nodes are never 100% overlapping.
        if (distance === 0) {
          distance = 0.1 * this._rng();
          dx = distance;
        }
        if (distance < 2 * nodeDistance) {
          if (distance < 0.5 * nodeDistance) {
            repulsingForce = 1.0;
          } else {
            repulsingForce = a * distance + b; // linear approx of  1 / (1 + Math.exp((distance / nodeDistance - 1) * steepness))
          }

          repulsingForce = repulsingForce / distance;
          fx = dx * repulsingForce;
          fy = dy * repulsingForce;
          forces[node1.id].x -= fx;
          forces[node1.id].y -= fy;
          forces[node2.id].x += fx;
          forces[node2.id].y += fy;
        }
      }
    }
  }
}

/**
 * Hierarchical Repulsion Solver
 */
class HierarchicalRepulsionSolver {
  /**
   * @param {object} body
   * @param {{physicsNodeIndices: Array, physicsEdgeIndices: Array, forces: {}, velocities: {}}} physicsBody
   * @param {object} options
   */
  constructor(body, physicsBody, options) {
    this.body = body;
    this.physicsBody = physicsBody;
    this.setOptions(options);
  }

  /**
   *
   * @param {object} options
   */
  setOptions(options) {
    this.options = options;
    this.overlapAvoidanceFactor = Math.max(0, Math.min(1, this.options.avoidOverlap || 0));
  }

  /**
   * Calculate the forces the nodes apply on each other based on a repulsion field.
   * This field is linearly approximated.
   * @private
   */
  solve() {
    const nodes = this.body.nodes;
    const nodeIndices = this.physicsBody.physicsNodeIndices;
    const forces = this.physicsBody.forces;

    // repulsing forces between nodes
    const nodeDistance = this.options.nodeDistance;

    // we loop from i over all but the last entree in the array
    // j loops from i+1 to the last. This way we do not double count any of the indices, nor i === j
    for (let i = 0; i < nodeIndices.length - 1; i++) {
      const node1 = nodes[nodeIndices[i]];
      for (let j = i + 1; j < nodeIndices.length; j++) {
        const node2 = nodes[nodeIndices[j]];

        // nodes only affect nodes on their level
        if (node1.level === node2.level) {
          const theseNodesDistance = nodeDistance + this.overlapAvoidanceFactor * ((node1.shape.radius || 0) / 2 + (node2.shape.radius || 0) / 2);
          const dx = node2.x - node1.x;
          const dy = node2.y - node1.y;
          const distance = Math.sqrt(dx * dx + dy * dy);
          const steepness = 0.05;
          let repulsingForce;
          if (distance < theseNodesDistance) {
            repulsingForce = -Math.pow(steepness * distance, 2) + Math.pow(steepness * theseNodesDistance, 2);
          } else {
            repulsingForce = 0;
          }
          // normalize force with
          if (distance !== 0) {
            repulsingForce = repulsingForce / distance;
          }
          const fx = dx * repulsingForce;
          const fy = dy * repulsingForce;
          forces[node1.id].x -= fx;
          forces[node1.id].y -= fy;
          forces[node2.id].x += fx;
          forces[node2.id].y += fy;
        }
      }
    }
  }
}

/**
 * Spring Solver
 */
class SpringSolver {
  /**
   * @param {object} body
   * @param {{physicsNodeIndices: Array, physicsEdgeIndices: Array, forces: {}, velocities: {}}} physicsBody
   * @param {object} options
   */
  constructor(body, physicsBody, options) {
    this.body = body;
    this.physicsBody = physicsBody;
    this.setOptions(options);
  }

  /**
   *
   * @param {object} options
   */
  setOptions(options) {
    this.options = options;
  }

  /**
   * This function calculates the springforces on the nodes, accounting for the support nodes.
   * @private
   */
  solve() {
    let edgeLength, edge;
    const edgeIndices = this.physicsBody.physicsEdgeIndices;
    const edges = this.body.edges;
    let node1, node2, node3;

    // forces caused by the edges, modelled as springs
    for (let i = 0; i < edgeIndices.length; i++) {
      edge = edges[edgeIndices[i]];
      if (edge.connected === true && edge.toId !== edge.fromId) {
        // only calculate forces if nodes are in the same sector
        if (this.body.nodes[edge.toId] !== undefined && this.body.nodes[edge.fromId] !== undefined) {
          if (edge.edgeType.via !== undefined) {
            edgeLength = edge.options.length === undefined ? this.options.springLength : edge.options.length;
            node1 = edge.to;
            node2 = edge.edgeType.via;
            node3 = edge.from;
            this._calculateSpringForce(node1, node2, 0.5 * edgeLength);
            this._calculateSpringForce(node2, node3, 0.5 * edgeLength);
          } else {
            // the * 1.5 is here so the edge looks as large as a smooth edge. It does not initially because the smooth edges use
            // the support nodes which exert a repulsive force on the to and from nodes, making the edge appear larger.
            edgeLength = edge.options.length === undefined ? this.options.springLength * 1.5 : edge.options.length;
            this._calculateSpringForce(edge.from, edge.to, edgeLength);
          }
        }
      }
    }
  }

  /**
   * This is the code actually performing the calculation for the function above.
   * @param {Node} node1
   * @param {Node} node2
   * @param {number} edgeLength
   * @private
   */
  _calculateSpringForce(node1, node2, edgeLength) {
    const dx = node1.x - node2.x;
    const dy = node1.y - node2.y;
    const distance = Math.max(Math.sqrt(dx * dx + dy * dy), 0.01);

    // the 1/distance is so the fx and fy can be calculated without sine or cosine.
    const springForce = this.options.springConstant * (edgeLength - distance) / distance;
    const fx = dx * springForce;
    const fy = dy * springForce;

    // handle the case where one node is not part of the physcis
    if (this.physicsBody.forces[node1.id] !== undefined) {
      this.physicsBody.forces[node1.id].x += fx;
      this.physicsBody.forces[node1.id].y += fy;
    }
    if (this.physicsBody.forces[node2.id] !== undefined) {
      this.physicsBody.forces[node2.id].x -= fx;
      this.physicsBody.forces[node2.id].y -= fy;
    }
  }
}

/**
 * Hierarchical Spring Solver
 */
class HierarchicalSpringSolver {
  /**
   * @param {object} body
   * @param {{physicsNodeIndices: Array, physicsEdgeIndices: Array, forces: {}, velocities: {}}} physicsBody
   * @param {object} options
   */
  constructor(body, physicsBody, options) {
    this.body = body;
    this.physicsBody = physicsBody;
    this.setOptions(options);
  }

  /**
   *
   * @param {object} options
   */
  setOptions(options) {
    this.options = options;
  }

  /**
   * This function calculates the springforces on the nodes, accounting for the support nodes.
   * @private
   */
  solve() {
    let edgeLength, edge;
    let dx, dy, fx, fy, springForce, distance;
    const edges = this.body.edges;
    const factor = 0.5;
    const edgeIndices = this.physicsBody.physicsEdgeIndices;
    const nodeIndices = this.physicsBody.physicsNodeIndices;
    const forces = this.physicsBody.forces;

    // initialize the spring force counters
    for (let i = 0; i < nodeIndices.length; i++) {
      const nodeId = nodeIndices[i];
      forces[nodeId].springFx = 0;
      forces[nodeId].springFy = 0;
    }

    // forces caused by the edges, modelled as springs
    for (let i = 0; i < edgeIndices.length; i++) {
      edge = edges[edgeIndices[i]];
      if (edge.connected === true) {
        edgeLength = edge.options.length === undefined ? this.options.springLength : edge.options.length;
        dx = edge.from.x - edge.to.x;
        dy = edge.from.y - edge.to.y;
        distance = Math.sqrt(dx * dx + dy * dy);
        distance = distance === 0 ? 0.01 : distance;

        // the 1/distance is so the fx and fy can be calculated without sine or cosine.
        springForce = this.options.springConstant * (edgeLength - distance) / distance;
        fx = dx * springForce;
        fy = dy * springForce;
        if (edge.to.level != edge.from.level) {
          if (forces[edge.toId] !== undefined) {
            forces[edge.toId].springFx -= fx;
            forces[edge.toId].springFy -= fy;
          }
          if (forces[edge.fromId] !== undefined) {
            forces[edge.fromId].springFx += fx;
            forces[edge.fromId].springFy += fy;
          }
        } else {
          if (forces[edge.toId] !== undefined) {
            forces[edge.toId].x -= factor * fx;
            forces[edge.toId].y -= factor * fy;
          }
          if (forces[edge.fromId] !== undefined) {
            forces[edge.fromId].x += factor * fx;
            forces[edge.fromId].y += factor * fy;
          }
        }
      }
    }

    // normalize spring forces
    springForce = 1;
    let springFx, springFy;
    for (let i = 0; i < nodeIndices.length; i++) {
      const nodeId = nodeIndices[i];
      springFx = Math.min(springForce, Math.max(-springForce, forces[nodeId].springFx));
      springFy = Math.min(springForce, Math.max(-springForce, forces[nodeId].springFy));
      forces[nodeId].x += springFx;
      forces[nodeId].y += springFy;
    }

    // retain energy balance
    let totalFx = 0;
    let totalFy = 0;
    for (let i = 0; i < nodeIndices.length; i++) {
      const nodeId = nodeIndices[i];
      totalFx += forces[nodeId].x;
      totalFy += forces[nodeId].y;
    }
    const correctionFx = totalFx / nodeIndices.length;
    const correctionFy = totalFy / nodeIndices.length;
    for (let i = 0; i < nodeIndices.length; i++) {
      const nodeId = nodeIndices[i];
      forces[nodeId].x -= correctionFx;
      forces[nodeId].y -= correctionFy;
    }
  }
}

/**
 * Central Gravity Solver
 */
class CentralGravitySolver {
  /**
   * @param {object} body
   * @param {{physicsNodeIndices: Array, physicsEdgeIndices: Array, forces: {}, velocities: {}}} physicsBody
   * @param {object} options
   */
  constructor(body, physicsBody, options) {
    this.body = body;
    this.physicsBody = physicsBody;
    this.setOptions(options);
  }

  /**
   *
   * @param {object} options
   */
  setOptions(options) {
    this.options = options;
  }

  /**
   * Calculates forces for each node
   */
  solve() {
    let dx, dy, distance, node;
    const nodes = this.body.nodes;
    const nodeIndices = this.physicsBody.physicsNodeIndices;
    const forces = this.physicsBody.forces;
    for (let i = 0; i < nodeIndices.length; i++) {
      const nodeId = nodeIndices[i];
      node = nodes[nodeId];
      dx = -node.x;
      dy = -node.y;
      distance = Math.sqrt(dx * dx + dy * dy);
      this._calculateForces(distance, dx, dy, forces, node);
    }
  }

  /**
   * Calculate the forces based on the distance.
   * @param {number} distance
   * @param {number} dx
   * @param {number} dy
   * @param {Object<Node.id, vis.Node>} forces
   * @param {Node} node
   * @private
   */
  _calculateForces(distance, dx, dy, forces, node) {
    const gravityForce = distance === 0 ? 0 : this.options.centralGravity / distance;
    forces[node.id].x = dx * gravityForce;
    forces[node.id].y = dy * gravityForce;
  }
}

/**
 * @augments BarnesHutSolver
 */
class ForceAtlas2BasedRepulsionSolver extends BarnesHutSolver {
  /**
   * @param {object} body
   * @param {{physicsNodeIndices: Array, physicsEdgeIndices: Array, forces: {}, velocities: {}}} physicsBody
   * @param {object} options
   */
  constructor(body, physicsBody, options) {
    super(body, physicsBody, options);
    this._rng = Alea("FORCE ATLAS 2 BASED REPULSION SOLVER");
  }

  /**
   * Calculate the forces based on the distance.
   * @param {number} distance
   * @param {number} dx
   * @param {number} dy
   * @param {Node} node
   * @param {object} parentBranch
   * @private
   */
  _calculateForces(distance, dx, dy, node, parentBranch) {
    if (distance === 0) {
      distance = 0.1 * this._rng();
      dx = distance;
    }
    if (this.overlapAvoidanceFactor < 1 && node.shape.radius) {
      distance = Math.max(0.1 + this.overlapAvoidanceFactor * node.shape.radius, distance - node.shape.radius);
    }
    const degree = node.edges.length + 1;
    // the dividing by the distance cubed instead of squared allows us to get the fx and fy components without sines and cosines
    // it is shorthand for gravityforce with distance squared and fx = dx/distance * gravityForce
    const gravityForce = this.options.gravitationalConstant * parentBranch.mass * node.options.mass * degree / Math.pow(distance, 2);
    const fx = dx * gravityForce;
    const fy = dy * gravityForce;
    this.physicsBody.forces[node.id].x += fx;
    this.physicsBody.forces[node.id].y += fy;
  }
}

/**
 * @augments CentralGravitySolver
 */
class ForceAtlas2BasedCentralGravitySolver extends CentralGravitySolver {
  /**
   * @param {object} body
   * @param {{physicsNodeIndices: Array, physicsEdgeIndices: Array, forces: {}, velocities: {}}} physicsBody
   * @param {object} options
   */
  constructor(body, physicsBody, options) {
    super(body, physicsBody, options);
  }

  /**
   * Calculate the forces based on the distance.
   * @param {number} distance
   * @param {number} dx
   * @param {number} dy
   * @param {Object<Node.id, Node>} forces
   * @param {Node} node
   * @private
   */
  _calculateForces(distance, dx, dy, forces, node) {
    if (distance > 0) {
      const degree = node.edges.length + 1;
      const gravityForce = this.options.centralGravity * degree * node.options.mass;
      forces[node.id].x = dx * gravityForce;
      forces[node.id].y = dy * gravityForce;
    }
  }
}

/**
 * The physics engine
 */
class PhysicsEngine {
  /**
   * @param {object} body
   */
  constructor(body) {
    this.body = body;
    this.physicsBody = {
      physicsNodeIndices: [],
      physicsEdgeIndices: [],
      forces: {},
      velocities: {}
    };
    this.physicsEnabled = true;
    this.simulationInterval = 1000 / 60;
    this.requiresTimeout = true;
    this.previousStates = {};
    this.referenceState = {};
    this.freezeCache = {};
    this.renderTimer = undefined;

    // parameters for the adaptive timestep
    this.adaptiveTimestep = false;
    this.adaptiveTimestepEnabled = false;
    this.adaptiveCounter = 0;
    this.adaptiveInterval = 3;
    this.stabilized = false;
    this.startedStabilization = false;
    this.stabilizationIterations = 0;
    this.ready = false; // will be set to true if the stabilize

    // default options
    this.options = {};
    this.defaultOptions = {
      enabled: true,
      barnesHut: {
        theta: 0.5,
        gravitationalConstant: -2000,
        centralGravity: 0.3,
        springLength: 95,
        springConstant: 0.04,
        damping: 0.09,
        avoidOverlap: 0
      },
      forceAtlas2Based: {
        theta: 0.5,
        gravitationalConstant: -50,
        centralGravity: 0.01,
        springConstant: 0.08,
        springLength: 100,
        damping: 0.4,
        avoidOverlap: 0
      },
      repulsion: {
        centralGravity: 0.2,
        springLength: 200,
        springConstant: 0.05,
        nodeDistance: 100,
        damping: 0.09,
        avoidOverlap: 0
      },
      hierarchicalRepulsion: {
        centralGravity: 0.0,
        springLength: 100,
        springConstant: 0.01,
        nodeDistance: 120,
        damping: 0.09
      },
      maxVelocity: 50,
      minVelocity: 0.75,
      // px/s
      solver: "barnesHut",
      stabilization: {
        enabled: true,
        iterations: 1000,
        // maximum number of iteration to stabilize
        updateInterval: 50,
        onlyDynamicEdges: false,
        fit: true
      },
      timestep: 0.5,
      adaptiveTimestep: true,
      wind: {
        x: 0,
        y: 0
      }
    };
    _Object$assign(this.options, this.defaultOptions);
    this.timestep = 0.5;
    this.layoutFailed = false;
    this.bindEventListeners();
  }

  /**
   * Binds event listeners
   */
  bindEventListeners() {
    this.body.emitter.on("initPhysics", () => {
      this.initPhysics();
    });
    this.body.emitter.on("_layoutFailed", () => {
      this.layoutFailed = true;
    });
    this.body.emitter.on("resetPhysics", () => {
      this.stopSimulation();
      this.ready = false;
    });
    this.body.emitter.on("disablePhysics", () => {
      this.physicsEnabled = false;
      this.stopSimulation();
    });
    this.body.emitter.on("restorePhysics", () => {
      this.setOptions(this.options);
      if (this.ready === true) {
        this.startSimulation();
      }
    });
    this.body.emitter.on("startSimulation", () => {
      if (this.ready === true) {
        this.startSimulation();
      }
    });
    this.body.emitter.on("stopSimulation", () => {
      this.stopSimulation();
    });
    this.body.emitter.on("destroy", () => {
      this.stopSimulation(false);
      this.body.emitter.off();
    });
    this.body.emitter.on("_dataChanged", () => {
      // Nodes and/or edges have been added or removed, update shortcut lists.
      this.updatePhysicsData();
    });

    // debug: show forces
    // this.body.emitter.on("afterDrawing", (ctx) => {this._drawForces(ctx);});
  }

  /**
   * set the physics options
   * @param {object} options
   */
  setOptions(options) {
    if (options !== undefined) {
      if (options === false) {
        this.options.enabled = false;
        this.physicsEnabled = false;
        this.stopSimulation();
      } else if (options === true) {
        this.options.enabled = true;
        this.physicsEnabled = true;
        this.startSimulation();
      } else {
        this.physicsEnabled = true;
        selectiveNotDeepExtend(["stabilization"], this.options, options);
        mergeOptions(this.options, options, "stabilization");
        if (options.enabled === undefined) {
          this.options.enabled = true;
        }
        if (this.options.enabled === false) {
          this.physicsEnabled = false;
          this.stopSimulation();
        }
        const wind = this.options.wind;
        if (wind) {
          if (typeof wind.x !== "number" || _Number$isNaN(wind.x)) {
            wind.x = 0;
          }
          if (typeof wind.y !== "number" || _Number$isNaN(wind.y)) {
            wind.y = 0;
          }
        }

        // set the timestep
        this.timestep = this.options.timestep;
      }
    }
    this.init();
  }

  /**
   * configure the engine.
   */
  init() {
    let options;
    if (this.options.solver === "forceAtlas2Based") {
      options = this.options.forceAtlas2Based;
      this.nodesSolver = new ForceAtlas2BasedRepulsionSolver(this.body, this.physicsBody, options);
      this.edgesSolver = new SpringSolver(this.body, this.physicsBody, options);
      this.gravitySolver = new ForceAtlas2BasedCentralGravitySolver(this.body, this.physicsBody, options);
    } else if (this.options.solver === "repulsion") {
      options = this.options.repulsion;
      this.nodesSolver = new RepulsionSolver(this.body, this.physicsBody, options);
      this.edgesSolver = new SpringSolver(this.body, this.physicsBody, options);
      this.gravitySolver = new CentralGravitySolver(this.body, this.physicsBody, options);
    } else if (this.options.solver === "hierarchicalRepulsion") {
      options = this.options.hierarchicalRepulsion;
      this.nodesSolver = new HierarchicalRepulsionSolver(this.body, this.physicsBody, options);
      this.edgesSolver = new HierarchicalSpringSolver(this.body, this.physicsBody, options);
      this.gravitySolver = new CentralGravitySolver(this.body, this.physicsBody, options);
    } else {
      // barnesHut
      options = this.options.barnesHut;
      this.nodesSolver = new BarnesHutSolver(this.body, this.physicsBody, options);
      this.edgesSolver = new SpringSolver(this.body, this.physicsBody, options);
      this.gravitySolver = new CentralGravitySolver(this.body, this.physicsBody, options);
    }
    this.modelOptions = options;
  }

  /**
   * initialize the engine
   */
  initPhysics() {
    if (this.physicsEnabled === true && this.options.enabled === true) {
      if (this.options.stabilization.enabled === true) {
        this.stabilize();
      } else {
        this.stabilized = false;
        this.ready = true;
        this.body.emitter.emit("fit", {}, this.layoutFailed); // if the layout failed, we use the approximation for the zoom
        this.startSimulation();
      }
    } else {
      this.ready = true;
      this.body.emitter.emit("fit");
    }
  }

  /**
   * Start the simulation
   */
  startSimulation() {
    if (this.physicsEnabled === true && this.options.enabled === true) {
      this.stabilized = false;

      // when visible, adaptivity is disabled.
      this.adaptiveTimestep = false;

      // this sets the width of all nodes initially which could be required for the avoidOverlap
      this.body.emitter.emit("_resizeNodes");
      if (this.viewFunction === undefined) {
        var _context;
        this.viewFunction = _bindInstanceProperty(_context = this.simulationStep).call(_context, this);
        this.body.emitter.on("initRedraw", this.viewFunction);
        this.body.emitter.emit("_startRendering");
      }
    } else {
      this.body.emitter.emit("_redraw");
    }
  }

  /**
   * Stop the simulation, force stabilization.
   * @param {boolean} [emit]
   */
  stopSimulation() {
    let emit = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;
    this.stabilized = true;
    if (emit === true) {
      this._emitStabilized();
    }
    if (this.viewFunction !== undefined) {
      this.body.emitter.off("initRedraw", this.viewFunction);
      this.viewFunction = undefined;
      if (emit === true) {
        this.body.emitter.emit("_stopRendering");
      }
    }
  }

  /**
   * The viewFunction inserts this step into each render loop. It calls the physics tick and handles the cleanup at stabilized.
   *
   */
  simulationStep() {
    // check if the physics have settled
    const startTime = _Date$now();
    this.physicsTick();
    const physicsTime = _Date$now() - startTime;

    // run double speed if it is a little graph
    if ((physicsTime < 0.4 * this.simulationInterval || this.runDoubleSpeed === true) && this.stabilized === false) {
      this.physicsTick();

      // this makes sure there is no jitter. The decision is taken once to run it at double speed.
      this.runDoubleSpeed = true;
    }
    if (this.stabilized === true) {
      this.stopSimulation();
    }
  }

  /**
   * trigger the stabilized event.
   * @param {number} [amountOfIterations]
   * @private
   */
  _emitStabilized() {
    let amountOfIterations = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.stabilizationIterations;
    if (this.stabilizationIterations > 1 || this.startedStabilization === true) {
      _setTimeout(() => {
        this.body.emitter.emit("stabilized", {
          iterations: amountOfIterations
        });
        this.startedStabilization = false;
        this.stabilizationIterations = 0;
      }, 0);
    }
  }

  /**
   * Calculate the forces for one physics iteration and move the nodes.
   * @private
   */
  physicsStep() {
    this.gravitySolver.solve();
    this.nodesSolver.solve();
    this.edgesSolver.solve();
    this.moveNodes();
  }

  /**
   * Make dynamic adjustments to the timestep, based on current state.
   *
   * Helper function for physicsTick().
   * @private
   */
  adjustTimeStep() {
    const factor = 1.2; // Factor for increasing the timestep on success.

    // we compare the two steps. if it is acceptable we double the step.
    if (this._evaluateStepQuality() === true) {
      this.timestep = factor * this.timestep;
    } else {
      // if not, we decrease the step to a minimum of the options timestep.
      // if the decreased timestep is smaller than the options step, we do not reset the counter
      // we assume that the options timestep is stable enough.
      if (this.timestep / factor < this.options.timestep) {
        this.timestep = this.options.timestep;
      } else {
        // if the timestep was larger than 2 times the option one we check the adaptivity again to ensure
        // that large instabilities do not form.
        this.adaptiveCounter = -1; // check again next iteration
        this.timestep = Math.max(this.options.timestep, this.timestep / factor);
      }
    }
  }

  /**
   * A single simulation step (or 'tick') in the physics simulation
   * @private
   */
  physicsTick() {
    this._startStabilizing(); // this ensures that there is no start event when the network is already stable.
    if (this.stabilized === true) return;

    // adaptivity means the timestep adapts to the situation, only applicable for stabilization
    if (this.adaptiveTimestep === true && this.adaptiveTimestepEnabled === true) {
      // timestep remains stable for "interval" iterations.
      const doAdaptive = this.adaptiveCounter % this.adaptiveInterval === 0;
      if (doAdaptive) {
        // first the big step and revert.
        this.timestep = 2 * this.timestep;
        this.physicsStep();
        this.revert(); // saves the reference state

        // now the normal step. Since this is the last step, it is the more stable one and we will take this.
        this.timestep = 0.5 * this.timestep;

        // since it's half the step, we do it twice.
        this.physicsStep();
        this.physicsStep();
        this.adjustTimeStep();
      } else {
        this.physicsStep(); // normal step, keeping timestep constant
      }

      this.adaptiveCounter += 1;
    } else {
      // case for the static timestep, we reset it to the one in options and take a normal step.
      this.timestep = this.options.timestep;
      this.physicsStep();
    }
    if (this.stabilized === true) this.revert();
    this.stabilizationIterations++;
  }

  /**
   * Nodes and edges can have the physics toggles on or off. A collection of indices is created here so we can skip the check all the time.
   * @private
   */
  updatePhysicsData() {
    this.physicsBody.forces = {};
    this.physicsBody.physicsNodeIndices = [];
    this.physicsBody.physicsEdgeIndices = [];
    const nodes = this.body.nodes;
    const edges = this.body.edges;

    // get node indices for physics
    for (const nodeId in nodes) {
      if (Object.prototype.hasOwnProperty.call(nodes, nodeId)) {
        if (nodes[nodeId].options.physics === true) {
          this.physicsBody.physicsNodeIndices.push(nodes[nodeId].id);
        }
      }
    }

    // get edge indices for physics
    for (const edgeId in edges) {
      if (Object.prototype.hasOwnProperty.call(edges, edgeId)) {
        if (edges[edgeId].options.physics === true) {
          this.physicsBody.physicsEdgeIndices.push(edges[edgeId].id);
        }
      }
    }

    // get the velocity and the forces vector
    for (let i = 0; i < this.physicsBody.physicsNodeIndices.length; i++) {
      const nodeId = this.physicsBody.physicsNodeIndices[i];
      this.physicsBody.forces[nodeId] = {
        x: 0,
        y: 0
      };

      // forces can be reset because they are recalculated. Velocities have to persist.
      if (this.physicsBody.velocities[nodeId] === undefined) {
        this.physicsBody.velocities[nodeId] = {
          x: 0,
          y: 0
        };
      }
    }

    // clean deleted nodes from the velocity vector
    for (const nodeId in this.physicsBody.velocities) {
      if (nodes[nodeId] === undefined) {
        delete this.physicsBody.velocities[nodeId];
      }
    }
  }

  /**
   * Revert the simulation one step. This is done so after stabilization, every new start of the simulation will also say stabilized.
   */
  revert() {
    const nodeIds = _Object$keys(this.previousStates);
    const nodes = this.body.nodes;
    const velocities = this.physicsBody.velocities;
    this.referenceState = {};
    for (let i = 0; i < nodeIds.length; i++) {
      const nodeId = nodeIds[i];
      if (nodes[nodeId] !== undefined) {
        if (nodes[nodeId].options.physics === true) {
          this.referenceState[nodeId] = {
            positions: {
              x: nodes[nodeId].x,
              y: nodes[nodeId].y
            }
          };
          velocities[nodeId].x = this.previousStates[nodeId].vx;
          velocities[nodeId].y = this.previousStates[nodeId].vy;
          nodes[nodeId].x = this.previousStates[nodeId].x;
          nodes[nodeId].y = this.previousStates[nodeId].y;
        }
      } else {
        delete this.previousStates[nodeId];
      }
    }
  }

  /**
   * This compares the reference state to the current state
   * @returns {boolean}
   * @private
   */
  _evaluateStepQuality() {
    let dx, dy, dpos;
    const nodes = this.body.nodes;
    const reference = this.referenceState;
    const posThreshold = 0.3;
    for (const nodeId in this.referenceState) {
      if (Object.prototype.hasOwnProperty.call(this.referenceState, nodeId) && nodes[nodeId] !== undefined) {
        dx = nodes[nodeId].x - reference[nodeId].positions.x;
        dy = nodes[nodeId].y - reference[nodeId].positions.y;
        dpos = Math.sqrt(Math.pow(dx, 2) + Math.pow(dy, 2));
        if (dpos > posThreshold) {
          return false;
        }
      }
    }
    return true;
  }

  /**
   * move the nodes one timestep and check if they are stabilized
   */
  moveNodes() {
    const nodeIndices = this.physicsBody.physicsNodeIndices;
    let maxNodeVelocity = 0;
    let averageNodeVelocity = 0;

    // the velocity threshold (energy in the system) for the adaptivity toggle
    const velocityAdaptiveThreshold = 5;
    for (let i = 0; i < nodeIndices.length; i++) {
      const nodeId = nodeIndices[i];
      const nodeVelocity = this._performStep(nodeId);
      // stabilized is true if stabilized is true and velocity is smaller than vmin --> all nodes must be stabilized
      maxNodeVelocity = Math.max(maxNodeVelocity, nodeVelocity);
      averageNodeVelocity += nodeVelocity;
    }

    // evaluating the stabilized and adaptiveTimestepEnabled conditions
    this.adaptiveTimestepEnabled = averageNodeVelocity / nodeIndices.length < velocityAdaptiveThreshold;
    this.stabilized = maxNodeVelocity < this.options.minVelocity;
  }

  /**
   * Calculate new velocity for a coordinate direction
   * @param {number} v  velocity for current coordinate
   * @param {number} f  regular force for current coordinate
   * @param {number} m  mass of current node
   * @returns {number} new velocity for current coordinate
   * @private
   */
  calculateComponentVelocity(v, f, m) {
    const df = this.modelOptions.damping * v; // damping force
    const a = (f - df) / m; // acceleration

    v += a * this.timestep;

    // Put a limit on the velocities if it is really high
    const maxV = this.options.maxVelocity || 1e9;
    if (Math.abs(v) > maxV) {
      v = v > 0 ? maxV : -maxV;
    }
    return v;
  }

  /**
   * Perform the actual step
   * @param {Node.id} nodeId
   * @returns {number} the new velocity of given node
   * @private
   */
  _performStep(nodeId) {
    const node = this.body.nodes[nodeId];
    const force = this.physicsBody.forces[nodeId];
    if (this.options.wind) {
      force.x += this.options.wind.x;
      force.y += this.options.wind.y;
    }
    const velocity = this.physicsBody.velocities[nodeId];

    // store the state so we can revert
    this.previousStates[nodeId] = {
      x: node.x,
      y: node.y,
      vx: velocity.x,
      vy: velocity.y
    };
    if (node.options.fixed.x === false) {
      velocity.x = this.calculateComponentVelocity(velocity.x, force.x, node.options.mass);
      node.x += velocity.x * this.timestep;
    } else {
      force.x = 0;
      velocity.x = 0;
    }
    if (node.options.fixed.y === false) {
      velocity.y = this.calculateComponentVelocity(velocity.y, force.y, node.options.mass);
      node.y += velocity.y * this.timestep;
    } else {
      force.y = 0;
      velocity.y = 0;
    }
    const totalVelocity = Math.sqrt(Math.pow(velocity.x, 2) + Math.pow(velocity.y, 2));
    return totalVelocity;
  }

  /**
   * When initializing and stabilizing, we can freeze nodes with a predefined position.
   * This greatly speeds up stabilization because only the supportnodes for the smoothCurves have to settle.
   * @private
   */
  _freezeNodes() {
    const nodes = this.body.nodes;
    for (const id in nodes) {
      if (Object.prototype.hasOwnProperty.call(nodes, id)) {
        if (nodes[id].x && nodes[id].y) {
          const fixed = nodes[id].options.fixed;
          this.freezeCache[id] = {
            x: fixed.x,
            y: fixed.y
          };
          fixed.x = true;
          fixed.y = true;
        }
      }
    }
  }

  /**
   * Unfreezes the nodes that have been frozen by _freezeDefinedNodes.
   * @private
   */
  _restoreFrozenNodes() {
    const nodes = this.body.nodes;
    for (const id in nodes) {
      if (Object.prototype.hasOwnProperty.call(nodes, id)) {
        if (this.freezeCache[id] !== undefined) {
          nodes[id].options.fixed.x = this.freezeCache[id].x;
          nodes[id].options.fixed.y = this.freezeCache[id].y;
        }
      }
    }
    this.freezeCache = {};
  }

  /**
   * Find a stable position for all nodes
   * @param {number} [iterations]
   */
  stabilize() {
    let iterations = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.options.stabilization.iterations;
    if (typeof iterations !== "number") {
      iterations = this.options.stabilization.iterations;
      console.error("The stabilize method needs a numeric amount of iterations. Switching to default: ", iterations);
    }
    if (this.physicsBody.physicsNodeIndices.length === 0) {
      this.ready = true;
      return;
    }

    // enable adaptive timesteps
    this.adaptiveTimestep = this.options.adaptiveTimestep;

    // this sets the width of all nodes initially which could be required for the avoidOverlap
    this.body.emitter.emit("_resizeNodes");
    this.stopSimulation(); // stop the render loop
    this.stabilized = false;

    // block redraw requests
    this.body.emitter.emit("_blockRedraw");
    this.targetIterations = iterations;

    // start the stabilization
    if (this.options.stabilization.onlyDynamicEdges === true) {
      this._freezeNodes();
    }
    this.stabilizationIterations = 0;
    _setTimeout(() => this._stabilizationBatch(), 0);
  }

  /**
   * If not already stabilizing, start it and emit a start event.
   * @returns {boolean} true if stabilization started with this call
   * @private
   */
  _startStabilizing() {
    if (this.startedStabilization === true) return false;
    this.body.emitter.emit("startStabilizing");
    this.startedStabilization = true;
    return true;
  }

  /**
   * One batch of stabilization
   * @private
   */
  _stabilizationBatch() {
    const running = () => this.stabilized === false && this.stabilizationIterations < this.targetIterations;
    const sendProgress = () => {
      this.body.emitter.emit("stabilizationProgress", {
        iterations: this.stabilizationIterations,
        total: this.targetIterations
      });
    };
    if (this._startStabilizing()) {
      sendProgress(); // Ensure that there is at least one start event.
    }

    let count = 0;
    while (running() && count < this.options.stabilization.updateInterval) {
      this.physicsTick();
      count++;
    }
    sendProgress();
    if (running()) {
      var _context2;
      _setTimeout(_bindInstanceProperty(_context2 = this._stabilizationBatch).call(_context2, this), 0);
    } else {
      this._finalizeStabilization();
    }
  }

  /**
   * Wrap up the stabilization, fit and emit the events.
   * @private
   */
  _finalizeStabilization() {
    this.body.emitter.emit("_allowRedraw");
    if (this.options.stabilization.fit === true) {
      this.body.emitter.emit("fit");
    }
    if (this.options.stabilization.onlyDynamicEdges === true) {
      this._restoreFrozenNodes();
    }
    this.body.emitter.emit("stabilizationIterationsDone");
    this.body.emitter.emit("_requestRedraw");
    if (this.stabilized === true) {
      this._emitStabilized();
    } else {
      this.startSimulation();
    }
    this.ready = true;
  }

  //---------------------------  DEBUGGING BELOW  ---------------------------//

  /**
   * Debug function that display arrows for the forces currently active in the network.
   *
   * Use this when debugging only.
   * @param {CanvasRenderingContext2D} ctx
   * @private
   */
  _drawForces(ctx) {
    for (let i = 0; i < this.physicsBody.physicsNodeIndices.length; i++) {
      const index = this.physicsBody.physicsNodeIndices[i];
      const node = this.body.nodes[index];
      const force = this.physicsBody.forces[index];
      const factor = 20;
      const colorFactor = 0.03;
      const forceSize = Math.sqrt(Math.pow(force.x, 2) + Math.pow(force.x, 2));
      const size = Math.min(Math.max(5, forceSize), 15);
      const arrowSize = 3 * size;
      const color = HSVToHex((180 - Math.min(1, Math.max(0, colorFactor * forceSize)) * 180) / 360, 1, 1);
      const point = {
        x: node.x + factor * force.x,
        y: node.y + factor * force.y
      };
      ctx.lineWidth = size;
      ctx.strokeStyle = color;
      ctx.beginPath();
      ctx.moveTo(node.x, node.y);
      ctx.lineTo(point.x, point.y);
      ctx.stroke();
      const angle = Math.atan2(force.y, force.x);
      ctx.fillStyle = color;
      EndPoints.draw(ctx, {
        type: "arrow",
        point: point,
        angle: angle,
        length: arrowSize
      });
      _fillInstanceProperty(ctx).call(ctx);
    }
  }
}

// Unique ID creation requires a high quality random # generator. In the browser we therefore
// require the crypto API and do not support built-in fallback to lower quality random number
// generators (like Math.random()).
let getRandomValues;
const rnds8 = new Uint8Array(16);
function rng() {
  // lazy load so that environments that need to polyfill have a chance to do so
  if (!getRandomValues) {
    // getRandomValues needs to be invoked in a context where "this" is a Crypto implementation.
    getRandomValues = typeof crypto !== 'undefined' && crypto.getRandomValues && crypto.getRandomValues.bind(crypto);

    if (!getRandomValues) {
      throw new Error('crypto.getRandomValues() not supported. See https://github.com/uuidjs/uuid#getrandomvalues-not-supported');
    }
  }

  return getRandomValues(rnds8);
}

/**
 * Convert array of 16 byte values to UUID string format of the form:
 * XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX
 */

const byteToHex = [];

for (let i = 0; i < 256; ++i) {
  byteToHex.push((i + 0x100).toString(16).slice(1));
}

function unsafeStringify(arr, offset = 0) {
  // Note: Be careful editing this code!  It's been tuned for performance
  // and works in ways you may not expect. See https://github.com/uuidjs/uuid/pull/434
  return byteToHex[arr[offset + 0]] + byteToHex[arr[offset + 1]] + byteToHex[arr[offset + 2]] + byteToHex[arr[offset + 3]] + '-' + byteToHex[arr[offset + 4]] + byteToHex[arr[offset + 5]] + '-' + byteToHex[arr[offset + 6]] + byteToHex[arr[offset + 7]] + '-' + byteToHex[arr[offset + 8]] + byteToHex[arr[offset + 9]] + '-' + byteToHex[arr[offset + 10]] + byteToHex[arr[offset + 11]] + byteToHex[arr[offset + 12]] + byteToHex[arr[offset + 13]] + byteToHex[arr[offset + 14]] + byteToHex[arr[offset + 15]];
}

const randomUUID = typeof crypto !== 'undefined' && crypto.randomUUID && crypto.randomUUID.bind(crypto);
var native = {
  randomUUID
};

function v4(options, buf, offset) {
  if (native.randomUUID && !buf && !options) {
    return native.randomUUID();
  }

  options = options || {};
  const rnds = options.random || (options.rng || rng)(); // Per 4.4, set bits for version and `clock_seq_hi_and_reserved`

  rnds[6] = rnds[6] & 0x0f | 0x40;
  rnds[8] = rnds[8] & 0x3f | 0x80; // Copy bytes to buffer, if provided

  if (buf) {
    offset = offset || 0;

    for (let i = 0; i < 16; ++i) {
      buf[offset + i] = rnds[i];
    }

    return buf;
  }

  return unsafeStringify(rnds);
}

/**
 * Utility Class
 */
class NetworkUtil {
  /**
   * @ignore
   */
  constructor() {}

  /**
   * Find the center position of the network considering the bounding boxes
   * @param {Array.<Node>} allNodes
   * @param {Array.<Node>} [specificNodes]
   * @returns {{minX: number, maxX: number, minY: number, maxY: number}}
   * @static
   */
  static getRange(allNodes) {
    let specificNodes = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
    let minY = 1e9,
      maxY = -1e9,
      minX = 1e9,
      maxX = -1e9,
      node;
    if (specificNodes.length > 0) {
      for (let i = 0; i < specificNodes.length; i++) {
        node = allNodes[specificNodes[i]];
        if (minX > node.shape.boundingBox.left) {
          minX = node.shape.boundingBox.left;
        }
        if (maxX < node.shape.boundingBox.right) {
          maxX = node.shape.boundingBox.right;
        }
        if (minY > node.shape.boundingBox.top) {
          minY = node.shape.boundingBox.top;
        } // top is negative, bottom is positive
        if (maxY < node.shape.boundingBox.bottom) {
          maxY = node.shape.boundingBox.bottom;
        } // top is negative, bottom is positive
      }
    }

    if (minX === 1e9 && maxX === -1e9 && minY === 1e9 && maxY === -1e9) {
      minY = 0, maxY = 0, minX = 0, maxX = 0;
    }
    return {
      minX: minX,
      maxX: maxX,
      minY: minY,
      maxY: maxY
    };
  }

  /**
   * Find the center position of the network
   * @param {Array.<Node>} allNodes
   * @param {Array.<Node>} [specificNodes]
   * @returns {{minX: number, maxX: number, minY: number, maxY: number}}
   * @static
   */
  static getRangeCore(allNodes) {
    let specificNodes = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
    let minY = 1e9,
      maxY = -1e9,
      minX = 1e9,
      maxX = -1e9,
      node;
    if (specificNodes.length > 0) {
      for (let i = 0; i < specificNodes.length; i++) {
        node = allNodes[specificNodes[i]];
        if (minX > node.x) {
          minX = node.x;
        }
        if (maxX < node.x) {
          maxX = node.x;
        }
        if (minY > node.y) {
          minY = node.y;
        } // top is negative, bottom is positive
        if (maxY < node.y) {
          maxY = node.y;
        } // top is negative, bottom is positive
      }
    }

    if (minX === 1e9 && maxX === -1e9 && minY === 1e9 && maxY === -1e9) {
      minY = 0, maxY = 0, minX = 0, maxX = 0;
    }
    return {
      minX: minX,
      maxX: maxX,
      minY: minY,
      maxY: maxY
    };
  }

  /**
   * @param {object} range = {minX: minX, maxX: maxX, minY: minY, maxY: maxY};
   * @returns {{x: number, y: number}}
   * @static
   */
  static findCenter(range) {
    return {
      x: 0.5 * (range.maxX + range.minX),
      y: 0.5 * (range.maxY + range.minY)
    };
  }

  /**
   * This returns a clone of the options or options of the edge or node to be used for construction of new edges or check functions for new nodes.
   * @param {vis.Item} item
   * @param {'node'|undefined} type
   * @returns {{}}
   * @static
   */
  static cloneOptions(item, type) {
    const clonedOptions = {};
    if (type === undefined || type === "node") {
      deepExtend(clonedOptions, item.options, true);
      clonedOptions.x = item.x;
      clonedOptions.y = item.y;
      clonedOptions.amountOfConnections = item.edges.length;
    } else {
      deepExtend(clonedOptions, item.options, true);
    }
    return clonedOptions;
  }
}

/**
 * A Cluster is a special Node that allows a group of Nodes positioned closely together
 * to be represented by a single Cluster Node.
 * @augments Node
 */
class Cluster extends Node {
  /**
   * @param {object} options
   * @param {object} body
   * @param {Array.<HTMLImageElement>}imagelist
   * @param {Array} grouplist
   * @param {object} globalOptions
   * @param {object} defaultOptions     Global default options for nodes
   */
  constructor(options, body, imagelist, grouplist, globalOptions, defaultOptions) {
    super(options, body, imagelist, grouplist, globalOptions, defaultOptions);
    this.isCluster = true;
    this.containedNodes = {};
    this.containedEdges = {};
  }

  /**
   * Transfer child cluster data to current and disconnect the child cluster.
   *
   * Please consult the header comment in 'Clustering.js' for the fields set here.
   * @param {string|number} childClusterId  id of child cluster to open
   */
  _openChildCluster(childClusterId) {
    const childCluster = this.body.nodes[childClusterId];
    if (this.containedNodes[childClusterId] === undefined) {
      throw new Error("node with id: " + childClusterId + " not in current cluster");
    }
    if (!childCluster.isCluster) {
      throw new Error("node with id: " + childClusterId + " is not a cluster");
    }

    // Disconnect child cluster from current cluster
    delete this.containedNodes[childClusterId];
    forEach$1(childCluster.edges, edge => {
      delete this.containedEdges[edge.id];
    });

    // Transfer nodes and edges
    forEach$1(childCluster.containedNodes, (node, nodeId) => {
      this.containedNodes[nodeId] = node;
    });
    childCluster.containedNodes = {};
    forEach$1(childCluster.containedEdges, (edge, edgeId) => {
      this.containedEdges[edgeId] = edge;
    });
    childCluster.containedEdges = {};

    // Transfer edges within cluster edges which are clustered
    forEach$1(childCluster.edges, clusterEdge => {
      forEach$1(this.edges, parentClusterEdge => {
        var _context, _context2;
        // Assumption: a clustered edge can only be present in a single clustering edge
        // Not tested here
        const index = _indexOfInstanceProperty(_context = parentClusterEdge.clusteringEdgeReplacingIds).call(_context, clusterEdge.id);
        if (index === -1) return;
        forEach$1(clusterEdge.clusteringEdgeReplacingIds, srcId => {
          parentClusterEdge.clusteringEdgeReplacingIds.push(srcId);

          // Maintain correct bookkeeping for transferred edge
          this.body.edges[srcId].edgeReplacedById = parentClusterEdge.id;
        });

        // Remove cluster edge from parent cluster edge
        _spliceInstanceProperty(_context2 = parentClusterEdge.clusteringEdgeReplacingIds).call(_context2, index, 1);
      });
    });
    childCluster.edges = [];
  }
}

/**
 * The clustering engine
 */
class ClusterEngine {
  /**
   * @param {object} body
   */
  constructor(body) {
    this.body = body;
    this.clusteredNodes = {}; // key: node id, value: { clusterId: <id of cluster>, node: <node instance>}
    this.clusteredEdges = {}; // key: edge id, value: restore information for given edge

    this.options = {};
    this.defaultOptions = {};
    _Object$assign(this.options, this.defaultOptions);
    this.body.emitter.on("_resetData", () => {
      this.clusteredNodes = {};
      this.clusteredEdges = {};
    });
  }

  /**
   *
   * @param {number} hubsize
   * @param {object} options
   */
  clusterByHubsize(hubsize, options) {
    if (hubsize === undefined) {
      hubsize = this._getHubSize();
    } else if (typeof hubsize === "object") {
      options = this._checkOptions(hubsize);
      hubsize = this._getHubSize();
    }
    const nodesToCluster = [];
    for (let i = 0; i < this.body.nodeIndices.length; i++) {
      const node = this.body.nodes[this.body.nodeIndices[i]];
      if (node.edges.length >= hubsize) {
        nodesToCluster.push(node.id);
      }
    }
    for (let i = 0; i < nodesToCluster.length; i++) {
      this.clusterByConnection(nodesToCluster[i], options, true);
    }
    this.body.emitter.emit("_dataChanged");
  }

  /**
   * loop over all nodes, check if they adhere to the condition and cluster if needed.
   * @param {object} options
   * @param {boolean} [refreshData]
   */
  cluster() {
    let options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    let refreshData = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
    if (options.joinCondition === undefined) {
      throw new Error("Cannot call clusterByNodeData without a joinCondition function in the options.");
    }

    // check if the options object is fine, append if needed
    options = this._checkOptions(options);
    const childNodesObj = {};
    const childEdgesObj = {};

    // collect the nodes that will be in the cluster
    forEach$1(this.body.nodes, (node, nodeId) => {
      if (node.options && options.joinCondition(node.options) === true) {
        childNodesObj[nodeId] = node;

        // collect the edges that will be in the cluster
        forEach$1(node.edges, edge => {
          if (this.clusteredEdges[edge.id] === undefined) {
            childEdgesObj[edge.id] = edge;
          }
        });
      }
    });
    this._cluster(childNodesObj, childEdgesObj, options, refreshData);
  }

  /**
   * Cluster all nodes in the network that have only X edges
   * @param {number} edgeCount
   * @param {object} options
   * @param {boolean} [refreshData]
   */
  clusterByEdgeCount(edgeCount, options) {
    let refreshData = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;
    options = this._checkOptions(options);
    const clusters = [];
    const usedNodes = {};
    let edge, edges, relevantEdgeCount;
    // collect the nodes that will be in the cluster
    for (let i = 0; i < this.body.nodeIndices.length; i++) {
      const childNodesObj = {};
      const childEdgesObj = {};
      const nodeId = this.body.nodeIndices[i];
      const node = this.body.nodes[nodeId];

      // if this node is already used in another cluster this session, we do not have to re-evaluate it.
      if (usedNodes[nodeId] === undefined) {
        relevantEdgeCount = 0;
        edges = [];
        for (let j = 0; j < node.edges.length; j++) {
          edge = node.edges[j];
          if (this.clusteredEdges[edge.id] === undefined) {
            if (edge.toId !== edge.fromId) {
              relevantEdgeCount++;
            }
            edges.push(edge);
          }
        }

        // this node qualifies, we collect its neighbours to start the clustering process.
        if (relevantEdgeCount === edgeCount) {
          const checkJoinCondition = function (node) {
            if (options.joinCondition === undefined || options.joinCondition === null) {
              return true;
            }
            const clonedOptions = NetworkUtil.cloneOptions(node);
            return options.joinCondition(clonedOptions);
          };
          let gatheringSuccessful = true;
          for (let j = 0; j < edges.length; j++) {
            edge = edges[j];
            const childNodeId = this._getConnectedId(edge, nodeId);
            // add the nodes to the list by the join condition.
            if (checkJoinCondition(node)) {
              childEdgesObj[edge.id] = edge;
              childNodesObj[nodeId] = node;
              childNodesObj[childNodeId] = this.body.nodes[childNodeId];
              usedNodes[nodeId] = true;
            } else {
              // this node does not qualify after all.
              gatheringSuccessful = false;
              break;
            }
          }

          // add to the cluster queue
          if (_Object$keys(childNodesObj).length > 0 && _Object$keys(childEdgesObj).length > 0 && gatheringSuccessful === true) {
            /**
             * Search for cluster data that contains any of the node id's
             * @returns {boolean} true if no joinCondition, otherwise return value of joinCondition
             */
            const findClusterData = function () {
              for (let n = 0; n < clusters.length; ++n) {
                // Search for a cluster containing any of the node id's
                for (const m in childNodesObj) {
                  if (clusters[n].nodes[m] !== undefined) {
                    return clusters[n];
                  }
                }
              }
              return undefined;
            };

            // If any of the found nodes is part of a cluster found in this method,
            // add the current values to that cluster
            const foundCluster = findClusterData();
            if (foundCluster !== undefined) {
              // Add nodes to found cluster if not present
              for (const m in childNodesObj) {
                if (foundCluster.nodes[m] === undefined) {
                  foundCluster.nodes[m] = childNodesObj[m];
                }
              }

              // Add edges to found cluster, if not present
              for (const m in childEdgesObj) {
                if (foundCluster.edges[m] === undefined) {
                  foundCluster.edges[m] = childEdgesObj[m];
                }
              }
            } else {
              // Create a new cluster group
              clusters.push({
                nodes: childNodesObj,
                edges: childEdgesObj
              });
            }
          }
        }
      }
    }
    for (let i = 0; i < clusters.length; i++) {
      this._cluster(clusters[i].nodes, clusters[i].edges, options, false);
    }
    if (refreshData === true) {
      this.body.emitter.emit("_dataChanged");
    }
  }

  /**
   * Cluster all nodes in the network that have only 1 edge
   * @param {object} options
   * @param {boolean} [refreshData]
   */
  clusterOutliers(options) {
    let refreshData = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
    this.clusterByEdgeCount(1, options, refreshData);
  }

  /**
   * Cluster all nodes in the network that have only 2 edge
   * @param {object} options
   * @param {boolean} [refreshData]
   */
  clusterBridges(options) {
    let refreshData = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
    this.clusterByEdgeCount(2, options, refreshData);
  }

  /**
   * suck all connected nodes of a node into the node.
   * @param {Node.id} nodeId
   * @param {object} options
   * @param {boolean} [refreshData]
   */
  clusterByConnection(nodeId, options) {
    var _context;
    let refreshData = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;
    // kill conditions
    if (nodeId === undefined) {
      throw new Error("No nodeId supplied to clusterByConnection!");
    }
    if (this.body.nodes[nodeId] === undefined) {
      throw new Error("The nodeId given to clusterByConnection does not exist!");
    }
    const node = this.body.nodes[nodeId];
    options = this._checkOptions(options, node);
    if (options.clusterNodeProperties.x === undefined) {
      options.clusterNodeProperties.x = node.x;
    }
    if (options.clusterNodeProperties.y === undefined) {
      options.clusterNodeProperties.y = node.y;
    }
    if (options.clusterNodeProperties.fixed === undefined) {
      options.clusterNodeProperties.fixed = {};
      options.clusterNodeProperties.fixed.x = node.options.fixed.x;
      options.clusterNodeProperties.fixed.y = node.options.fixed.y;
    }
    const childNodesObj = {};
    const childEdgesObj = {};
    const parentNodeId = node.id;
    const parentClonedOptions = NetworkUtil.cloneOptions(node);
    childNodesObj[parentNodeId] = node;

    // collect the nodes that will be in the cluster
    for (let i = 0; i < node.edges.length; i++) {
      const edge = node.edges[i];
      if (this.clusteredEdges[edge.id] === undefined) {
        const childNodeId = this._getConnectedId(edge, parentNodeId);

        // if the child node is not in a cluster
        if (this.clusteredNodes[childNodeId] === undefined) {
          if (childNodeId !== parentNodeId) {
            if (options.joinCondition === undefined) {
              childEdgesObj[edge.id] = edge;
              childNodesObj[childNodeId] = this.body.nodes[childNodeId];
            } else {
              // clone the options and insert some additional parameters that could be interesting.
              const childClonedOptions = NetworkUtil.cloneOptions(this.body.nodes[childNodeId]);
              if (options.joinCondition(parentClonedOptions, childClonedOptions) === true) {
                childEdgesObj[edge.id] = edge;
                childNodesObj[childNodeId] = this.body.nodes[childNodeId];
              }
            }
          } else {
            // swallow the edge if it is self-referencing.
            childEdgesObj[edge.id] = edge;
          }
        }
      }
    }
    const childNodeIDs = _mapInstanceProperty(_context = _Object$keys(childNodesObj)).call(_context, function (childNode) {
      return childNodesObj[childNode].id;
    });
    for (const childNodeKey in childNodesObj) {
      if (!Object.prototype.hasOwnProperty.call(childNodesObj, childNodeKey)) continue;
      const childNode = childNodesObj[childNodeKey];
      for (let y = 0; y < childNode.edges.length; y++) {
        const childEdge = childNode.edges[y];
        if (_indexOfInstanceProperty(childNodeIDs).call(childNodeIDs, this._getConnectedId(childEdge, childNode.id)) > -1) {
          childEdgesObj[childEdge.id] = childEdge;
        }
      }
    }
    this._cluster(childNodesObj, childEdgesObj, options, refreshData);
  }

  /**
   * This function creates the edges that will be attached to the cluster
   * It looks for edges that are connected to the nodes from the "outside' of the cluster.
   * @param {{Node.id: vis.Node}} childNodesObj
   * @param {{vis.Edge.id: vis.Edge}} childEdgesObj
   * @param {object} clusterNodeProperties
   * @param {object} clusterEdgeProperties
   * @private
   */
  _createClusterEdges(childNodesObj, childEdgesObj, clusterNodeProperties, clusterEdgeProperties) {
    let edge, childNodeId, childNode, toId, fromId, otherNodeId;

    // loop over all child nodes and their edges to find edges going out of the cluster
    // these edges will be replaced by clusterEdges.
    const childKeys = _Object$keys(childNodesObj);
    const createEdges = [];
    for (let i = 0; i < childKeys.length; i++) {
      childNodeId = childKeys[i];
      childNode = childNodesObj[childNodeId];

      // construct new edges from the cluster to others
      for (let j = 0; j < childNode.edges.length; j++) {
        edge = childNode.edges[j];
        // we only handle edges that are visible to the system, not the disabled ones from the clustering process.
        if (this.clusteredEdges[edge.id] === undefined) {
          // self-referencing edges will be added to the "hidden" list
          if (edge.toId == edge.fromId) {
            childEdgesObj[edge.id] = edge;
          } else {
            // set up the from and to.
            if (edge.toId == childNodeId) {
              // this is a double equals because ints and strings can be interchanged here.
              toId = clusterNodeProperties.id;
              fromId = edge.fromId;
              otherNodeId = fromId;
            } else {
              toId = edge.toId;
              fromId = clusterNodeProperties.id;
              otherNodeId = toId;
            }
          }

          // Only edges from the cluster outwards are being replaced.
          if (childNodesObj[otherNodeId] === undefined) {
            createEdges.push({
              edge: edge,
              fromId: fromId,
              toId: toId
            });
          }
        }
      }
    }

    //
    // Here we actually create the replacement edges.
    //
    // We could not do this in the loop above as the creation process
    // would add an edge to the edges array we are iterating over.
    //
    // NOTE: a clustered edge can have multiple base edges!
    //
    const newEdges = [];

    /**
     * Find a cluster edge which matches the given created edge.
     * @param {vis.Edge} createdEdge
     * @returns {vis.Edge}
     */
    const getNewEdge = function (createdEdge) {
      for (let j = 0; j < newEdges.length; j++) {
        const newEdge = newEdges[j];

        // We replace both to and from edges with a single cluster edge
        const matchToDirection = createdEdge.fromId === newEdge.fromId && createdEdge.toId === newEdge.toId;
        const matchFromDirection = createdEdge.fromId === newEdge.toId && createdEdge.toId === newEdge.fromId;
        if (matchToDirection || matchFromDirection) {
          return newEdge;
        }
      }
      return null;
    };
    for (let j = 0; j < createEdges.length; j++) {
      const createdEdge = createEdges[j];
      const edge = createdEdge.edge;
      let newEdge = getNewEdge(createdEdge);
      if (newEdge === null) {
        // Create a clustered edge for this connection
        newEdge = this._createClusteredEdge(createdEdge.fromId, createdEdge.toId, edge, clusterEdgeProperties);
        newEdges.push(newEdge);
      } else {
        newEdge.clusteringEdgeReplacingIds.push(edge.id);
      }

      // also reference the new edge in the old edge
      this.body.edges[edge.id].edgeReplacedById = newEdge.id;

      // hide the replaced edge
      this._backupEdgeOptions(edge);
      edge.setOptions({
        physics: false
      });
    }
  }

  /**
   * This function checks the options that can be supplied to the different cluster functions
   * for certain fields and inserts defaults if needed
   * @param {object} options
   * @returns {*}
   * @private
   */
  _checkOptions() {
    let options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    if (options.clusterEdgeProperties === undefined) {
      options.clusterEdgeProperties = {};
    }
    if (options.clusterNodeProperties === undefined) {
      options.clusterNodeProperties = {};
    }
    return options;
  }

  /**
   *
   * @param {object}    childNodesObj         | object with node objects, id as keys, same as childNodes except it also contains a source node
   * @param {object}    childEdgesObj         | object with edge objects, id as keys
   * @param {Array}     options               | object with {clusterNodeProperties, clusterEdgeProperties, processProperties}
   * @param {boolean}   refreshData | when true, do not wrap up
   * @private
   */
  _cluster(childNodesObj, childEdgesObj, options) {
    let refreshData = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : true;
    // Remove nodes which are already clustered
    const tmpNodesToRemove = [];
    for (const nodeId in childNodesObj) {
      if (Object.prototype.hasOwnProperty.call(childNodesObj, nodeId)) {
        if (this.clusteredNodes[nodeId] !== undefined) {
          tmpNodesToRemove.push(nodeId);
        }
      }
    }
    for (let n = 0; n < tmpNodesToRemove.length; ++n) {
      delete childNodesObj[tmpNodesToRemove[n]];
    }

    // kill condition: no nodes don't bother
    if (_Object$keys(childNodesObj).length == 0) {
      return;
    }

    // allow clusters of 1 if options allow
    if (_Object$keys(childNodesObj).length == 1 && options.clusterNodeProperties.allowSingleNodeCluster != true) {
      return;
    }
    let clusterNodeProperties = deepExtend({}, options.clusterNodeProperties);

    // construct the clusterNodeProperties
    if (options.processProperties !== undefined) {
      // get the childNode options
      const childNodesOptions = [];
      for (const nodeId in childNodesObj) {
        if (Object.prototype.hasOwnProperty.call(childNodesObj, nodeId)) {
          const clonedOptions = NetworkUtil.cloneOptions(childNodesObj[nodeId]);
          childNodesOptions.push(clonedOptions);
        }
      }

      // get cluster properties based on childNodes
      const childEdgesOptions = [];
      for (const edgeId in childEdgesObj) {
        if (Object.prototype.hasOwnProperty.call(childEdgesObj, edgeId)) {
          // these cluster edges will be removed on creation of the cluster.
          if (edgeId.substr(0, 12) !== "clusterEdge:") {
            const clonedOptions = NetworkUtil.cloneOptions(childEdgesObj[edgeId], "edge");
            childEdgesOptions.push(clonedOptions);
          }
        }
      }
      clusterNodeProperties = options.processProperties(clusterNodeProperties, childNodesOptions, childEdgesOptions);
      if (!clusterNodeProperties) {
        throw new Error("The processProperties function does not return properties!");
      }
    }

    // check if we have an unique id;
    if (clusterNodeProperties.id === undefined) {
      clusterNodeProperties.id = "cluster:" + v4();
    }
    const clusterId = clusterNodeProperties.id;
    if (clusterNodeProperties.label === undefined) {
      clusterNodeProperties.label = "cluster";
    }

    // give the clusterNode a position if it does not have one.
    let pos = undefined;
    if (clusterNodeProperties.x === undefined) {
      pos = this._getClusterPosition(childNodesObj);
      clusterNodeProperties.x = pos.x;
    }
    if (clusterNodeProperties.y === undefined) {
      if (pos === undefined) {
        pos = this._getClusterPosition(childNodesObj);
      }
      clusterNodeProperties.y = pos.y;
    }

    // force the ID to remain the same
    clusterNodeProperties.id = clusterId;

    // create the cluster Node
    // Note that allowSingleNodeCluster, if present, is stored in the options as well
    const clusterNode = this.body.functions.createNode(clusterNodeProperties, Cluster);
    clusterNode.containedNodes = childNodesObj;
    clusterNode.containedEdges = childEdgesObj;
    // cache a copy from the cluster edge properties if we have to reconnect others later on
    clusterNode.clusterEdgeProperties = options.clusterEdgeProperties;

    // finally put the cluster node into global
    this.body.nodes[clusterNodeProperties.id] = clusterNode;
    this._clusterEdges(childNodesObj, childEdgesObj, clusterNodeProperties, options.clusterEdgeProperties);

    // set ID to undefined so no duplicates arise
    clusterNodeProperties.id = undefined;

    // wrap up
    if (refreshData === true) {
      this.body.emitter.emit("_dataChanged");
    }
  }

  /**
   *
   * @param {Edge} edge
   * @private
   */
  _backupEdgeOptions(edge) {
    if (this.clusteredEdges[edge.id] === undefined) {
      this.clusteredEdges[edge.id] = {
        physics: edge.options.physics
      };
    }
  }

  /**
   *
   * @param {Edge} edge
   * @private
   */
  _restoreEdge(edge) {
    const originalOptions = this.clusteredEdges[edge.id];
    if (originalOptions !== undefined) {
      edge.setOptions({
        physics: originalOptions.physics
      });
      delete this.clusteredEdges[edge.id];
    }
  }

  /**
   * Check if a node is a cluster.
   * @param {Node.id} nodeId
   * @returns {*}
   */
  isCluster(nodeId) {
    if (this.body.nodes[nodeId] !== undefined) {
      return this.body.nodes[nodeId].isCluster === true;
    } else {
      console.error("Node does not exist.");
      return false;
    }
  }

  /**
   * get the position of the cluster node based on what's inside
   * @param {object} childNodesObj    | object with node objects, id as keys
   * @returns {{x: number, y: number}}
   * @private
   */
  _getClusterPosition(childNodesObj) {
    const childKeys = _Object$keys(childNodesObj);
    let minX = childNodesObj[childKeys[0]].x;
    let maxX = childNodesObj[childKeys[0]].x;
    let minY = childNodesObj[childKeys[0]].y;
    let maxY = childNodesObj[childKeys[0]].y;
    let node;
    for (let i = 1; i < childKeys.length; i++) {
      node = childNodesObj[childKeys[i]];
      minX = node.x < minX ? node.x : minX;
      maxX = node.x > maxX ? node.x : maxX;
      minY = node.y < minY ? node.y : minY;
      maxY = node.y > maxY ? node.y : maxY;
    }
    return {
      x: 0.5 * (minX + maxX),
      y: 0.5 * (minY + maxY)
    };
  }

  /**
   * Open a cluster by calling this function.
   * @param {vis.Edge.id}  clusterNodeId | the ID of the cluster node
   * @param {object} options
   * @param {boolean} refreshData | wrap up afterwards if not true
   */
  openCluster(clusterNodeId, options) {
    let refreshData = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;
    // kill conditions
    if (clusterNodeId === undefined) {
      throw new Error("No clusterNodeId supplied to openCluster.");
    }
    const clusterNode = this.body.nodes[clusterNodeId];
    if (clusterNode === undefined) {
      throw new Error("The clusterNodeId supplied to openCluster does not exist.");
    }
    if (clusterNode.isCluster !== true || clusterNode.containedNodes === undefined || clusterNode.containedEdges === undefined) {
      throw new Error("The node:" + clusterNodeId + " is not a valid cluster.");
    }

    // Check if current cluster is clustered itself
    const stack = this.findNode(clusterNodeId);
    const parentIndex = _indexOfInstanceProperty(stack).call(stack, clusterNodeId) - 1;
    if (parentIndex >= 0) {
      // Current cluster is clustered; transfer contained nodes and edges to parent
      const parentClusterNodeId = stack[parentIndex];
      const parentClusterNode = this.body.nodes[parentClusterNodeId];

      // clustering.clusteredNodes and clustering.clusteredEdges remain unchanged
      parentClusterNode._openChildCluster(clusterNodeId);

      // All components of child cluster node have been transferred. It can die now.
      delete this.body.nodes[clusterNodeId];
      if (refreshData === true) {
        this.body.emitter.emit("_dataChanged");
      }
      return;
    }

    // main body
    const containedNodes = clusterNode.containedNodes;
    const containedEdges = clusterNode.containedEdges;

    // allow the user to position the nodes after release.
    if (options !== undefined && options.releaseFunction !== undefined && typeof options.releaseFunction === "function") {
      const positions = {};
      const clusterPosition = {
        x: clusterNode.x,
        y: clusterNode.y
      };
      for (const nodeId in containedNodes) {
        if (Object.prototype.hasOwnProperty.call(containedNodes, nodeId)) {
          const containedNode = this.body.nodes[nodeId];
          positions[nodeId] = {
            x: containedNode.x,
            y: containedNode.y
          };
        }
      }
      const newPositions = options.releaseFunction(clusterPosition, positions);
      for (const nodeId in containedNodes) {
        if (Object.prototype.hasOwnProperty.call(containedNodes, nodeId)) {
          const containedNode = this.body.nodes[nodeId];
          if (newPositions[nodeId] !== undefined) {
            containedNode.x = newPositions[nodeId].x === undefined ? clusterNode.x : newPositions[nodeId].x;
            containedNode.y = newPositions[nodeId].y === undefined ? clusterNode.y : newPositions[nodeId].y;
          }
        }
      }
    } else {
      // copy the position from the cluster
      forEach$1(containedNodes, function (containedNode) {
        // inherit position
        if (containedNode.options.fixed.x === false) {
          containedNode.x = clusterNode.x;
        }
        if (containedNode.options.fixed.y === false) {
          containedNode.y = clusterNode.y;
        }
      });
    }

    // release nodes
    for (const nodeId in containedNodes) {
      if (Object.prototype.hasOwnProperty.call(containedNodes, nodeId)) {
        const containedNode = this.body.nodes[nodeId];

        // inherit speed
        containedNode.vx = clusterNode.vx;
        containedNode.vy = clusterNode.vy;
        containedNode.setOptions({
          physics: true
        });
        delete this.clusteredNodes[nodeId];
      }
    }

    // copy the clusterNode edges because we cannot iterate over an object that we add or remove from.
    const edgesToBeDeleted = [];
    for (let i = 0; i < clusterNode.edges.length; i++) {
      edgesToBeDeleted.push(clusterNode.edges[i]);
    }

    // actually handling the deleting.
    for (let i = 0; i < edgesToBeDeleted.length; i++) {
      const edge = edgesToBeDeleted[i];
      const otherNodeId = this._getConnectedId(edge, clusterNodeId);
      const otherNode = this.clusteredNodes[otherNodeId];
      for (let j = 0; j < edge.clusteringEdgeReplacingIds.length; j++) {
        const transferId = edge.clusteringEdgeReplacingIds[j];
        const transferEdge = this.body.edges[transferId];
        if (transferEdge === undefined) continue;

        // if the other node is in another cluster, we transfer ownership of this edge to the other cluster
        if (otherNode !== undefined) {
          // transfer ownership:
          const otherCluster = this.body.nodes[otherNode.clusterId];
          otherCluster.containedEdges[transferEdge.id] = transferEdge;

          // delete local reference
          delete containedEdges[transferEdge.id];

          // get to and from
          let fromId = transferEdge.fromId;
          let toId = transferEdge.toId;
          if (transferEdge.toId == otherNodeId) {
            toId = otherNode.clusterId;
          } else {
            fromId = otherNode.clusterId;
          }

          // create new cluster edge from the otherCluster
          this._createClusteredEdge(fromId, toId, transferEdge, otherCluster.clusterEdgeProperties, {
            hidden: false,
            physics: true
          });
        } else {
          this._restoreEdge(transferEdge);
        }
      }
      edge.remove();
    }

    // handle the releasing of the edges
    for (const edgeId in containedEdges) {
      if (Object.prototype.hasOwnProperty.call(containedEdges, edgeId)) {
        this._restoreEdge(containedEdges[edgeId]);
      }
    }

    // remove clusterNode
    delete this.body.nodes[clusterNodeId];
    if (refreshData === true) {
      this.body.emitter.emit("_dataChanged");
    }
  }

  /**
   *
   * @param {Cluster.id} clusterId
   * @returns {Array.<Node.id>}
   */
  getNodesInCluster(clusterId) {
    const nodesArray = [];
    if (this.isCluster(clusterId) === true) {
      const containedNodes = this.body.nodes[clusterId].containedNodes;
      for (const nodeId in containedNodes) {
        if (Object.prototype.hasOwnProperty.call(containedNodes, nodeId)) {
          nodesArray.push(this.body.nodes[nodeId].id);
        }
      }
    }
    return nodesArray;
  }

  /**
   * Get the stack clusterId's that a certain node resides in. cluster A -> cluster B -> cluster C -> node
   *
   * If a node can't be found in the chain, return an empty array.
   * @param {string|number} nodeId
   * @returns {Array}
   */
  findNode(nodeId) {
    const stack = [];
    const max = 100;
    let counter = 0;
    let node;
    while (this.clusteredNodes[nodeId] !== undefined && counter < max) {
      node = this.body.nodes[nodeId];
      if (node === undefined) return [];
      stack.push(node.id);
      nodeId = this.clusteredNodes[nodeId].clusterId;
      counter++;
    }
    node = this.body.nodes[nodeId];
    if (node === undefined) return [];
    stack.push(node.id);
    _reverseInstanceProperty(stack).call(stack);
    return stack;
  }

  /**
   * Using a clustered nodeId, update with the new options
   * @param {Node.id} clusteredNodeId
   * @param {object} newOptions
   */
  updateClusteredNode(clusteredNodeId, newOptions) {
    if (clusteredNodeId === undefined) {
      throw new Error("No clusteredNodeId supplied to updateClusteredNode.");
    }
    if (newOptions === undefined) {
      throw new Error("No newOptions supplied to updateClusteredNode.");
    }
    if (this.body.nodes[clusteredNodeId] === undefined) {
      throw new Error("The clusteredNodeId supplied to updateClusteredNode does not exist.");
    }
    this.body.nodes[clusteredNodeId].setOptions(newOptions);
    this.body.emitter.emit("_dataChanged");
  }

  /**
   * Using a base edgeId, update all related clustered edges with the new options
   * @param {vis.Edge.id} startEdgeId
   * @param {object} newOptions
   */
  updateEdge(startEdgeId, newOptions) {
    if (startEdgeId === undefined) {
      throw new Error("No startEdgeId supplied to updateEdge.");
    }
    if (newOptions === undefined) {
      throw new Error("No newOptions supplied to updateEdge.");
    }
    if (this.body.edges[startEdgeId] === undefined) {
      throw new Error("The startEdgeId supplied to updateEdge does not exist.");
    }
    const allEdgeIds = this.getClusteredEdges(startEdgeId);
    for (let i = 0; i < allEdgeIds.length; i++) {
      const edge = this.body.edges[allEdgeIds[i]];
      edge.setOptions(newOptions);
    }
    this.body.emitter.emit("_dataChanged");
  }

  /**
   * Get a stack of clusterEdgeId's (+base edgeid) that a base edge is the same as. cluster edge C -> cluster edge B -> cluster edge A -> base edge(edgeId)
   * @param {vis.Edge.id} edgeId
   * @returns {Array.<vis.Edge.id>}
   */
  getClusteredEdges(edgeId) {
    const stack = [];
    const max = 100;
    let counter = 0;
    while (edgeId !== undefined && this.body.edges[edgeId] !== undefined && counter < max) {
      stack.push(this.body.edges[edgeId].id);
      edgeId = this.body.edges[edgeId].edgeReplacedById;
      counter++;
    }
    _reverseInstanceProperty(stack).call(stack);
    return stack;
  }

  /**
   * Get the base edge id of clusterEdgeId. cluster edge (clusteredEdgeId) -> cluster edge B -> cluster edge C -> base edge
   * @param {vis.Edge.id} clusteredEdgeId
   * @returns {vis.Edge.id} baseEdgeId
   *
   * TODO: deprecate in 5.0.0. Method getBaseEdges() is the correct one to use.
   */
  getBaseEdge(clusteredEdgeId) {
    // Just kludge this by returning the first base edge id found
    return this.getBaseEdges(clusteredEdgeId)[0];
  }

  /**
   * Get all regular edges for this clustered edge id.
   * @param {vis.Edge.id} clusteredEdgeId
   * @returns {Array.<vis.Edge.id>} all baseEdgeId's under this clustered edge
   */
  getBaseEdges(clusteredEdgeId) {
    const IdsToHandle = [clusteredEdgeId];
    const doneIds = [];
    const foundIds = [];
    const max = 100;
    let counter = 0;
    while (IdsToHandle.length > 0 && counter < max) {
      const nextId = IdsToHandle.pop();
      if (nextId === undefined) continue; // Paranoia here and onwards
      const nextEdge = this.body.edges[nextId];
      if (nextEdge === undefined) continue;
      counter++;
      const replacingIds = nextEdge.clusteringEdgeReplacingIds;
      if (replacingIds === undefined) {
        // nextId is a base id
        foundIds.push(nextId);
      } else {
        // Another cluster edge, unravel this one as well
        for (let i = 0; i < replacingIds.length; ++i) {
          const replacingId = replacingIds[i];

          // Don't add if already handled
          // TODO: never triggers; find a test-case which does
          if (_indexOfInstanceProperty(IdsToHandle).call(IdsToHandle, replacingIds) !== -1 || _indexOfInstanceProperty(doneIds).call(doneIds, replacingIds) !== -1) {
            continue;
          }
          IdsToHandle.push(replacingId);
        }
      }
      doneIds.push(nextId);
    }
    return foundIds;
  }

  /**
   * Get the Id the node is connected to
   * @param {vis.Edge} edge
   * @param {Node.id} nodeId
   * @returns {*}
   * @private
   */
  _getConnectedId(edge, nodeId) {
    if (edge.toId != nodeId) {
      return edge.toId;
    } else if (edge.fromId != nodeId) {
      return edge.fromId;
    } else {
      return edge.fromId;
    }
  }

  /**
   * We determine how many connections denote an important hub.
   * We take the mean + 2*std as the important hub size. (Assuming a normal distribution of data, ~2.2%)
   * @returns {number}
   * @private
   */
  _getHubSize() {
    let average = 0;
    let averageSquared = 0;
    let hubCounter = 0;
    let largestHub = 0;
    for (let i = 0; i < this.body.nodeIndices.length; i++) {
      const node = this.body.nodes[this.body.nodeIndices[i]];
      if (node.edges.length > largestHub) {
        largestHub = node.edges.length;
      }
      average += node.edges.length;
      averageSquared += Math.pow(node.edges.length, 2);
      hubCounter += 1;
    }
    average = average / hubCounter;
    averageSquared = averageSquared / hubCounter;
    const variance = averageSquared - Math.pow(average, 2);
    const standardDeviation = Math.sqrt(variance);
    let hubThreshold = Math.floor(average + 2 * standardDeviation);

    // always have at least one to cluster
    if (hubThreshold > largestHub) {
      hubThreshold = largestHub;
    }
    return hubThreshold;
  }

  /**
   * Create an edge for the cluster representation.
   * @param {Node.id} fromId
   * @param {Node.id} toId
   * @param {vis.Edge} baseEdge
   * @param {object} clusterEdgeProperties
   * @param {object} extraOptions
   * @returns {Edge} newly created clustered edge
   * @private
   */
  _createClusteredEdge(fromId, toId, baseEdge, clusterEdgeProperties, extraOptions) {
    // copy the options of the edge we will replace
    const clonedOptions = NetworkUtil.cloneOptions(baseEdge, "edge");
    // make sure the properties of clusterEdges are superimposed on it
    deepExtend(clonedOptions, clusterEdgeProperties);

    // set up the edge
    clonedOptions.from = fromId;
    clonedOptions.to = toId;
    clonedOptions.id = "clusterEdge:" + v4();

    // apply the edge specific options to it if specified
    if (extraOptions !== undefined) {
      deepExtend(clonedOptions, extraOptions);
    }
    const newEdge = this.body.functions.createEdge(clonedOptions);
    newEdge.clusteringEdgeReplacingIds = [baseEdge.id];
    newEdge.connect();

    // Register the new edge
    this.body.edges[newEdge.id] = newEdge;
    return newEdge;
  }

  /**
   * Add the passed child nodes and edges to the given cluster node.
   * @param {object | Node} childNodes  hash of nodes or single node to add in cluster
   * @param {object | Edge} childEdges  hash of edges or single edge to take into account when clustering
   * @param {Node} clusterNode  cluster node to add nodes and edges to
   * @param {object} [clusterEdgeProperties]
   * @private
   */
  _clusterEdges(childNodes, childEdges, clusterNode, clusterEdgeProperties) {
    if (childEdges instanceof Edge) {
      const edge = childEdges;
      const obj = {};
      obj[edge.id] = edge;
      childEdges = obj;
    }
    if (childNodes instanceof Node) {
      const node = childNodes;
      const obj = {};
      obj[node.id] = node;
      childNodes = obj;
    }
    if (clusterNode === undefined || clusterNode === null) {
      throw new Error("_clusterEdges: parameter clusterNode required");
    }
    if (clusterEdgeProperties === undefined) {
      // Take the required properties from the cluster node
      clusterEdgeProperties = clusterNode.clusterEdgeProperties;
    }

    // create the new edges that will connect to the cluster.
    // All self-referencing edges will be added to childEdges here.
    this._createClusterEdges(childNodes, childEdges, clusterNode, clusterEdgeProperties);

    // disable the childEdges
    for (const edgeId in childEdges) {
      if (Object.prototype.hasOwnProperty.call(childEdges, edgeId)) {
        if (this.body.edges[edgeId] !== undefined) {
          const edge = this.body.edges[edgeId];
          // cache the options before changing
          this._backupEdgeOptions(edge);
          // disable physics and hide the edge
          edge.setOptions({
            physics: false
          });
        }
      }
    }

    // disable the childNodes
    for (const nodeId in childNodes) {
      if (Object.prototype.hasOwnProperty.call(childNodes, nodeId)) {
        this.clusteredNodes[nodeId] = {
          clusterId: clusterNode.id,
          node: this.body.nodes[nodeId]
        };
        this.body.nodes[nodeId].setOptions({
          physics: false
        });
      }
    }
  }

  /**
   * Determine in which cluster given nodeId resides.
   *
   * If not in cluster, return undefined.
   *
   * NOTE: If you know a cleaner way to do this, please enlighten me (wimrijnders).
   * @param {Node.id} nodeId
   * @returns {Node|undefined} Node instance for cluster, if present
   * @private
   */
  _getClusterNodeForNode(nodeId) {
    if (nodeId === undefined) return undefined;
    const clusteredNode = this.clusteredNodes[nodeId];

    // NOTE: If no cluster info found, it should actually be an error
    if (clusteredNode === undefined) return undefined;
    const clusterId = clusteredNode.clusterId;
    if (clusterId === undefined) return undefined;
    return this.body.nodes[clusterId];
  }

  /**
   * Internal helper function for conditionally removing items in array
   *
   * Done like this because Array.filter() is not fully supported by all IE's.
   * @param {Array} arr
   * @param {Function} callback
   * @returns {Array}
   * @private
   */
  _filter(arr, callback) {
    const ret = [];
    forEach$1(arr, item => {
      if (callback(item)) {
        ret.push(item);
      }
    });
    return ret;
  }

  /**
   * Scan all edges for changes in clustering and adjust this if necessary.
   *
   * Call this (internally) after there has been a change in node or edge data.
   *
   * Pre: States of this.body.nodes and this.body.edges consistent
   * Pre: this.clusteredNodes and this.clusteredEdge consistent with containedNodes and containedEdges
   *      of cluster nodes.
   */
  _updateState() {
    let nodeId;
    const deletedNodeIds = [];
    const deletedEdgeIds = {};

    /**
     * Utility function to iterate over clustering nodes only
     * @param {Function} callback  function to call for each cluster node
     */
    const eachClusterNode = callback => {
      forEach$1(this.body.nodes, node => {
        if (node.isCluster === true) {
          callback(node);
        }
      });
    };

    //
    // Remove deleted regular nodes from clustering
    //

    // Determine the deleted nodes
    for (nodeId in this.clusteredNodes) {
      if (!Object.prototype.hasOwnProperty.call(this.clusteredNodes, nodeId)) continue;
      const node = this.body.nodes[nodeId];
      if (node === undefined) {
        deletedNodeIds.push(nodeId);
      }
    }

    // Remove nodes from cluster nodes
    eachClusterNode(function (clusterNode) {
      for (let n = 0; n < deletedNodeIds.length; n++) {
        delete clusterNode.containedNodes[deletedNodeIds[n]];
      }
    });

    // Remove nodes from cluster list
    for (let n = 0; n < deletedNodeIds.length; n++) {
      delete this.clusteredNodes[deletedNodeIds[n]];
    }

    //
    // Remove deleted edges from clustering
    //

    // Add the deleted clustered edges to the list
    forEach$1(this.clusteredEdges, edgeId => {
      const edge = this.body.edges[edgeId];
      if (edge === undefined || !edge.endPointsValid()) {
        deletedEdgeIds[edgeId] = edgeId;
      }
    });

    // Cluster nodes can also contain edges which are not clustered,
    // i.e. nodes 1-2 within cluster with an edge in between.
    // So the cluster nodes also need to be scanned for invalid edges
    eachClusterNode(function (clusterNode) {
      forEach$1(clusterNode.containedEdges, (edge, edgeId) => {
        if (!edge.endPointsValid() && !deletedEdgeIds[edgeId]) {
          deletedEdgeIds[edgeId] = edgeId;
        }
      });
    });

    // Also scan for cluster edges which need to be removed in the active list.
    // Regular edges have been removed beforehand, so this only picks up the cluster edges.
    forEach$1(this.body.edges, (edge, edgeId) => {
      // Explicitly scan the contained edges for validity
      let isValid = true;
      const replacedIds = edge.clusteringEdgeReplacingIds;
      if (replacedIds !== undefined) {
        let numValid = 0;
        forEach$1(replacedIds, containedEdgeId => {
          const containedEdge = this.body.edges[containedEdgeId];
          if (containedEdge !== undefined && containedEdge.endPointsValid()) {
            numValid += 1;
          }
        });
        isValid = numValid > 0;
      }
      if (!edge.endPointsValid() || !isValid) {
        deletedEdgeIds[edgeId] = edgeId;
      }
    });

    // Remove edges from cluster nodes
    eachClusterNode(clusterNode => {
      forEach$1(deletedEdgeIds, deletedEdgeId => {
        delete clusterNode.containedEdges[deletedEdgeId];
        forEach$1(clusterNode.edges, (edge, m) => {
          if (edge.id === deletedEdgeId) {
            clusterNode.edges[m] = null; // Don't want to directly delete here, because in the loop
            return;
          }
          edge.clusteringEdgeReplacingIds = this._filter(edge.clusteringEdgeReplacingIds, function (id) {
            return !deletedEdgeIds[id];
          });
        });

        // Clean up the nulls
        clusterNode.edges = this._filter(clusterNode.edges, function (item) {
          return item !== null;
        });
      });
    });

    // Remove from cluster list
    forEach$1(deletedEdgeIds, edgeId => {
      delete this.clusteredEdges[edgeId];
    });

    // Remove cluster edges from active list (this.body.edges).
    // deletedEdgeIds still contains id of regular edges, but these should all
    // be gone when you reach here.
    forEach$1(deletedEdgeIds, edgeId => {
      delete this.body.edges[edgeId];
    });

    //
    // Check changed cluster state of edges
    //

    // Iterating over keys here, because edges may be removed in the loop
    const ids = _Object$keys(this.body.edges);
    forEach$1(ids, edgeId => {
      const edge = this.body.edges[edgeId];
      const shouldBeClustered = this._isClusteredNode(edge.fromId) || this._isClusteredNode(edge.toId);
      if (shouldBeClustered === this._isClusteredEdge(edge.id)) {
        return; // all is well
      }

      if (shouldBeClustered) {
        // add edge to clustering
        const clusterFrom = this._getClusterNodeForNode(edge.fromId);
        if (clusterFrom !== undefined) {
          this._clusterEdges(this.body.nodes[edge.fromId], edge, clusterFrom);
        }
        const clusterTo = this._getClusterNodeForNode(edge.toId);
        if (clusterTo !== undefined) {
          this._clusterEdges(this.body.nodes[edge.toId], edge, clusterTo);
        }

        // TODO: check that it works for both edges clustered
        //       (This might be paranoia)
      } else {
        delete this._clusterEdges[edgeId];
        this._restoreEdge(edge);
        // This should not be happening, the state should
        // be properly updated at this point.
        //
        // If it *is* reached during normal operation, then we have to implement
        // undo clustering for this edge here.
        // throw new Error('remove edge from clustering not implemented!')
      }
    });

    // Clusters may be nested to any level. Keep on opening until nothing to open
    let changed = false;
    let continueLoop = true;
    while (continueLoop) {
      const clustersToOpen = [];

      // Determine the id's of clusters that need opening
      eachClusterNode(function (clusterNode) {
        const numNodes = _Object$keys(clusterNode.containedNodes).length;
        const allowSingle = clusterNode.options.allowSingleNodeCluster === true;
        if (allowSingle && numNodes < 1 || !allowSingle && numNodes < 2) {
          clustersToOpen.push(clusterNode.id);
        }
      });

      // Open them
      for (let n = 0; n < clustersToOpen.length; ++n) {
        this.openCluster(clustersToOpen[n], {}, false /* Don't refresh, we're in an refresh/update already */);
      }

      continueLoop = clustersToOpen.length > 0;
      changed = changed || continueLoop;
    }
    if (changed) {
      this._updateState(); // Redo this method (recursion possible! should be safe)
    }
  }

  /**
   * Determine if node with given id is part of a cluster.
   * @param {Node.id} nodeId
   * @returns {boolean} true if part of a cluster.
   */
  _isClusteredNode(nodeId) {
    return this.clusteredNodes[nodeId] !== undefined;
  }

  /**
   * Determine if edge with given id is not visible due to clustering.
   *
   * An edge is considered clustered if:
   * - it is directly replaced by a clustering edge
   * - any of its connecting nodes is in a cluster
   * @param {vis.Edge.id} edgeId
   * @returns {boolean} true if part of a cluster.
   */
  _isClusteredEdge(edgeId) {
    return this.clusteredEdges[edgeId] !== undefined;
  }
}

/**
 * Initializes window.requestAnimationFrame() to a usable form.
 *
 * Specifically, set up this method for the case of running on node.js with jsdom enabled.
 *
 * NOTES:
 *
 * On node.js, when calling this directly outside of this class, `window` is not defined.
 * This happens even if jsdom is used.
 * For node.js + jsdom, `window` is available at the moment the constructor is called.
 * For this reason, the called is placed within the constructor.
 * Even then, `window.requestAnimationFrame()` is not defined, so it still needs to be added.
 * During unit testing, it happens that the window object is reset during execution, causing
 * a runtime error due to missing `requestAnimationFrame()`. This needs to be compensated for,
 * see `_requestNextFrame()`.
 * Since this is a global object, it may affect other modules besides `Network`. With normal
 * usage, this does not cause any problems. During unit testing, errors may occur. These have
 * been compensated for, see comment block in _requestNextFrame().
 * @private
 */
function _initRequestAnimationFrame() {
  let func;
  if (window !== undefined) {
    func = window.requestAnimationFrame || window.mozRequestAnimationFrame || window.webkitRequestAnimationFrame || window.msRequestAnimationFrame;
  }
  if (func === undefined) {
    // window or method not present, setting mock requestAnimationFrame
    window.requestAnimationFrame = function (callback) {
      //console.log("Called mock requestAnimationFrame");
      callback();
    };
  } else {
    window.requestAnimationFrame = func;
  }
}

/**
 * The canvas renderer
 */
class CanvasRenderer {
  /**
   * @param {object} body
   * @param {Canvas} canvas
   */
  constructor(body, canvas) {
    _initRequestAnimationFrame();
    this.body = body;
    this.canvas = canvas;
    this.redrawRequested = false;
    this.renderTimer = undefined;
    this.requiresTimeout = true;
    this.renderingActive = false;
    this.renderRequests = 0;
    this.allowRedraw = true;
    this.dragging = false;
    this.zooming = false;
    this.options = {};
    this.defaultOptions = {
      hideEdgesOnDrag: false,
      hideEdgesOnZoom: false,
      hideNodesOnDrag: false
    };
    _Object$assign(this.options, this.defaultOptions);
    this._determineBrowserMethod();
    this.bindEventListeners();
  }

  /**
   * Binds event listeners
   */
  bindEventListeners() {
    var _context2;
    this.body.emitter.on("dragStart", () => {
      this.dragging = true;
    });
    this.body.emitter.on("dragEnd", () => {
      this.dragging = false;
    });
    this.body.emitter.on("zoom", () => {
      this.zooming = true;
      window.clearTimeout(this.zoomTimeoutId);
      this.zoomTimeoutId = _setTimeout(() => {
        var _context;
        this.zooming = false;
        _bindInstanceProperty(_context = this._requestRedraw).call(_context, this)();
      }, 250);
    });
    this.body.emitter.on("_resizeNodes", () => {
      this._resizeNodes();
    });
    this.body.emitter.on("_redraw", () => {
      if (this.renderingActive === false) {
        this._redraw();
      }
    });
    this.body.emitter.on("_blockRedraw", () => {
      this.allowRedraw = false;
    });
    this.body.emitter.on("_allowRedraw", () => {
      this.allowRedraw = true;
      this.redrawRequested = false;
    });
    this.body.emitter.on("_requestRedraw", _bindInstanceProperty(_context2 = this._requestRedraw).call(_context2, this));
    this.body.emitter.on("_startRendering", () => {
      this.renderRequests += 1;
      this.renderingActive = true;
      this._startRendering();
    });
    this.body.emitter.on("_stopRendering", () => {
      this.renderRequests -= 1;
      this.renderingActive = this.renderRequests > 0;
      this.renderTimer = undefined;
    });
    this.body.emitter.on("destroy", () => {
      this.renderRequests = 0;
      this.allowRedraw = false;
      this.renderingActive = false;
      if (this.requiresTimeout === true) {
        clearTimeout(this.renderTimer);
      } else {
        window.cancelAnimationFrame(this.renderTimer);
      }
      this.body.emitter.off();
    });
  }

  /**
   *
   * @param {object} options
   */
  setOptions(options) {
    if (options !== undefined) {
      const fields = ["hideEdgesOnDrag", "hideEdgesOnZoom", "hideNodesOnDrag"];
      selectiveDeepExtend(fields, this.options, options);
    }
  }

  /**
   * Prepare the drawing of the next frame.
   *
   * Calls the callback when the next frame can or will be drawn.
   * @param {Function} callback
   * @param {number} delay - timeout case only, wait this number of milliseconds
   * @returns {Function | undefined}
   * @private
   */
  _requestNextFrame(callback, delay) {
    // During unit testing, it happens that the mock window object is reset while
    // the next frame is still pending. Then, either 'window' is not present, or
    // 'requestAnimationFrame()' is not present because it is not defined on the
    // mock window object.
    //
    // As a consequence, unrelated unit tests may appear to fail, even if the problem
    // described happens in the current unit test.
    //
    // This is not something that will happen in normal operation, but we still need
    // to take it into account.
    //
    if (typeof window === "undefined") return; // Doing `if (window === undefined)` does not work here!

    let timer;
    const myWindow = window; // Grab a reference to reduce the possibility that 'window' is reset
    // while running this method.

    if (this.requiresTimeout === true) {
      // wait given number of milliseconds and perform the animation step function
      timer = _setTimeout(callback, delay);
    } else {
      if (myWindow.requestAnimationFrame) {
        timer = myWindow.requestAnimationFrame(callback);
      }
    }
    return timer;
  }

  /**
   *
   * @private
   */
  _startRendering() {
    if (this.renderingActive === true) {
      if (this.renderTimer === undefined) {
        var _context3;
        this.renderTimer = this._requestNextFrame(_bindInstanceProperty(_context3 = this._renderStep).call(_context3, this), this.simulationInterval);
      }
    }
  }

  /**
   *
   * @private
   */
  _renderStep() {
    if (this.renderingActive === true) {
      // reset the renderTimer so a new scheduled animation step can be set
      this.renderTimer = undefined;
      if (this.requiresTimeout === true) {
        // this schedules a new simulation step
        this._startRendering();
      }
      this._redraw();
      if (this.requiresTimeout === false) {
        // this schedules a new simulation step
        this._startRendering();
      }
    }
  }

  /**
   * Redraw the network with the current data
   * chart will be resized too.
   */
  redraw() {
    this.body.emitter.emit("setSize");
    this._redraw();
  }

  /**
   * Redraw the network with the current data
   * @private
   */
  _requestRedraw() {
    if (this.redrawRequested !== true && this.renderingActive === false && this.allowRedraw === true) {
      this.redrawRequested = true;
      this._requestNextFrame(() => {
        this._redraw(false);
      }, 0);
    }
  }

  /**
   * Redraw the network with the current data
   * @param {boolean} [hidden] | Used to get the first estimate of the node sizes.
   *                                   Only the nodes are drawn after which they are quickly drawn over.
   * @private
   */
  _redraw() {
    let hidden = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
    if (this.allowRedraw === true) {
      this.body.emitter.emit("initRedraw");
      this.redrawRequested = false;
      const drawLater = {
        drawExternalLabels: null
      };

      // when the container div was hidden, this fixes it back up!
      if (this.canvas.frame.canvas.width === 0 || this.canvas.frame.canvas.height === 0) {
        this.canvas.setSize();
      }
      this.canvas.setTransform();
      const ctx = this.canvas.getContext();

      // clear the canvas
      const w = this.canvas.frame.canvas.clientWidth;
      const h = this.canvas.frame.canvas.clientHeight;
      ctx.clearRect(0, 0, w, h);

      // if the div is hidden, we stop the redraw here for performance.
      if (this.canvas.frame.clientWidth === 0) {
        return;
      }

      // set scaling and translation
      ctx.save();
      ctx.translate(this.body.view.translation.x, this.body.view.translation.y);
      ctx.scale(this.body.view.scale, this.body.view.scale);
      ctx.beginPath();
      this.body.emitter.emit("beforeDrawing", ctx);
      ctx.closePath();
      if (hidden === false) {
        if ((this.dragging === false || this.dragging === true && this.options.hideEdgesOnDrag === false) && (this.zooming === false || this.zooming === true && this.options.hideEdgesOnZoom === false)) {
          this._drawEdges(ctx);
        }
      }
      if (this.dragging === false || this.dragging === true && this.options.hideNodesOnDrag === false) {
        const {
          drawExternalLabels
        } = this._drawNodes(ctx, hidden);
        drawLater.drawExternalLabels = drawExternalLabels;
      }

      // draw the arrows last so they will be at the top
      if (hidden === false) {
        if ((this.dragging === false || this.dragging === true && this.options.hideEdgesOnDrag === false) && (this.zooming === false || this.zooming === true && this.options.hideEdgesOnZoom === false)) {
          this._drawArrows(ctx);
        }
      }
      if (drawLater.drawExternalLabels != null) {
        drawLater.drawExternalLabels();
      }
      if (hidden === false) {
        this._drawSelectionBox(ctx);
      }
      ctx.beginPath();
      this.body.emitter.emit("afterDrawing", ctx);
      ctx.closePath();

      // restore original scaling and translation
      ctx.restore();
      if (hidden === true) {
        ctx.clearRect(0, 0, w, h);
      }
    }
  }

  /**
   * Redraw all nodes
   * @param {CanvasRenderingContext2D}   ctx
   * @param {boolean} [alwaysShow]
   * @private
   */
  _resizeNodes() {
    this.canvas.setTransform();
    const ctx = this.canvas.getContext();
    ctx.save();
    ctx.translate(this.body.view.translation.x, this.body.view.translation.y);
    ctx.scale(this.body.view.scale, this.body.view.scale);
    const nodes = this.body.nodes;
    let node;

    // resize all nodes
    for (const nodeId in nodes) {
      if (Object.prototype.hasOwnProperty.call(nodes, nodeId)) {
        node = nodes[nodeId];
        node.resize(ctx);
        node.updateBoundingBox(ctx, node.selected);
      }
    }

    // restore original scaling and translation
    ctx.restore();
  }

  /**
   * Redraw all nodes
   * @param {CanvasRenderingContext2D} ctx  2D context of a HTML canvas
   * @param {boolean} [alwaysShow]
   * @private
   * @returns {object} Callbacks to draw later on higher layers.
   */
  _drawNodes(ctx) {
    let alwaysShow = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
    const nodes = this.body.nodes;
    const nodeIndices = this.body.nodeIndices;
    let node;
    const selected = [];
    const hovered = [];
    const margin = 20;
    const topLeft = this.canvas.DOMtoCanvas({
      x: -margin,
      y: -margin
    });
    const bottomRight = this.canvas.DOMtoCanvas({
      x: this.canvas.frame.canvas.clientWidth + margin,
      y: this.canvas.frame.canvas.clientHeight + margin
    });
    const viewableArea = {
      top: topLeft.y,
      left: topLeft.x,
      bottom: bottomRight.y,
      right: bottomRight.x
    };
    const drawExternalLabels = [];

    // draw unselected nodes;
    for (let i = 0; i < nodeIndices.length; i++) {
      node = nodes[nodeIndices[i]];
      // set selected and hovered nodes aside
      if (node.hover) {
        hovered.push(nodeIndices[i]);
      } else if (node.isSelected()) {
        selected.push(nodeIndices[i]);
      } else {
        if (alwaysShow === true) {
          const drawLater = node.draw(ctx);
          if (drawLater.drawExternalLabel != null) {
            drawExternalLabels.push(drawLater.drawExternalLabel);
          }
        } else if (node.isBoundingBoxOverlappingWith(viewableArea) === true) {
          const drawLater = node.draw(ctx);
          if (drawLater.drawExternalLabel != null) {
            drawExternalLabels.push(drawLater.drawExternalLabel);
          }
        } else {
          node.updateBoundingBox(ctx, node.selected);
        }
      }
    }
    let i;
    const selectedLength = selected.length;
    const hoveredLength = hovered.length;

    // draw the selected nodes on top
    for (i = 0; i < selectedLength; i++) {
      node = nodes[selected[i]];
      const drawLater = node.draw(ctx);
      if (drawLater.drawExternalLabel != null) {
        drawExternalLabels.push(drawLater.drawExternalLabel);
      }
    }

    // draw hovered nodes above everything else: fixes https://github.com/visjs/vis-network/issues/226
    for (i = 0; i < hoveredLength; i++) {
      node = nodes[hovered[i]];
      const drawLater = node.draw(ctx);
      if (drawLater.drawExternalLabel != null) {
        drawExternalLabels.push(drawLater.drawExternalLabel);
      }
    }
    return {
      drawExternalLabels: () => {
        for (const draw of drawExternalLabels) {
          draw();
        }
      }
    };
  }

  /**
   * Redraw all edges
   * @param {CanvasRenderingContext2D} ctx  2D context of a HTML canvas
   * @private
   */
  _drawEdges(ctx) {
    const edges = this.body.edges;
    const edgeIndices = this.body.edgeIndices;
    for (let i = 0; i < edgeIndices.length; i++) {
      const edge = edges[edgeIndices[i]];
      if (edge.connected === true) {
        edge.draw(ctx);
      }
    }
  }

  /**
   * Redraw all arrows
   * @param {CanvasRenderingContext2D} ctx  2D context of a HTML canvas
   * @private
   */
  _drawArrows(ctx) {
    const edges = this.body.edges;
    const edgeIndices = this.body.edgeIndices;
    for (let i = 0; i < edgeIndices.length; i++) {
      const edge = edges[edgeIndices[i]];
      if (edge.connected === true) {
        edge.drawArrows(ctx);
      }
    }
  }

  /**
   * Determine if the browser requires a setTimeout or a requestAnimationFrame. This was required because
   * some implementations (safari and IE9) did not support requestAnimationFrame
   * @private
   */
  _determineBrowserMethod() {
    if (typeof window !== "undefined") {
      const browserType = navigator.userAgent.toLowerCase();
      this.requiresTimeout = false;
      if (_indexOfInstanceProperty(browserType).call(browserType, "msie 9.0") != -1) {
        // IE 9
        this.requiresTimeout = true;
      } else if (_indexOfInstanceProperty(browserType).call(browserType, "safari") != -1) {
        // safari
        if (_indexOfInstanceProperty(browserType).call(browserType, "chrome") <= -1) {
          this.requiresTimeout = true;
        }
      }
    } else {
      this.requiresTimeout = true;
    }
  }

  /**
   * Redraw selection box
   * @param {CanvasRenderingContext2D} ctx  2D context of a HTML canvas
   * @private
   */
  _drawSelectionBox(ctx) {
    if (this.body.selectionBox.show) {
      ctx.beginPath();
      const width = this.body.selectionBox.position.end.x - this.body.selectionBox.position.start.x;
      const height = this.body.selectionBox.position.end.y - this.body.selectionBox.position.start.y;
      ctx.rect(this.body.selectionBox.position.start.x, this.body.selectionBox.position.start.y, width, height);
      ctx.fillStyle = "rgba(151, 194, 252, 0.2)";
      ctx.fillRect(this.body.selectionBox.position.start.x, this.body.selectionBox.position.start.y, width, height);
      ctx.strokeStyle = "rgba(151, 194, 252, 1)";
      ctx.stroke();
    } else {
      ctx.closePath();
    }
  }
}

var path$2 = path$s;

var setInterval$1 = path$2.setInterval;

var setInterval = setInterval$1;

var _setInterval = /*@__PURE__*/getDefaultExportFromCjs(setInterval);

/**
 * Register a touch event, taking place before a gesture
 * @param {Hammer} hammer       A hammer instance
 * @param {Function} callback   Callback, called as callback(event)
 */
function onTouch(hammer, callback) {
  callback.inputHandler = function (event) {
    if (event.isFirst) {
      callback(event);
    }
  };
  hammer.on("hammer.input", callback.inputHandler);
}

/**
 * Register a release event, taking place after a gesture
 * @param {Hammer} hammer       A hammer instance
 * @param {Function} callback   Callback, called as callback(event)
 * @returns {*}
 */
function onRelease(hammer, callback) {
  callback.inputHandler = function (event) {
    if (event.isFinal) {
      callback(event);
    }
  };
  return hammer.on("hammer.input", callback.inputHandler);
}

/**
 * Create the main frame for the Network.
 * This function is executed once when a Network object is created. The frame
 * contains a canvas, and this canvas contains all objects like the axis and
 * nodes.
 */
class Canvas {
  /**
   * @param {object} body
   */
  constructor(body) {
    this.body = body;
    this.pixelRatio = 1;
    this.cameraState = {};
    this.initialized = false;
    this.canvasViewCenter = {};
    this._cleanupCallbacks = [];
    this.options = {};
    this.defaultOptions = {
      autoResize: true,
      height: "100%",
      width: "100%"
    };
    _Object$assign(this.options, this.defaultOptions);
    this.bindEventListeners();
  }

  /**
   * Binds event listeners
   */
  bindEventListeners() {
    var _context;
    // bind the events
    this.body.emitter.once("resize", obj => {
      if (obj.width !== 0) {
        this.body.view.translation.x = obj.width * 0.5;
      }
      if (obj.height !== 0) {
        this.body.view.translation.y = obj.height * 0.5;
      }
    });
    this.body.emitter.on("setSize", _bindInstanceProperty(_context = this.setSize).call(_context, this));
    this.body.emitter.on("destroy", () => {
      this.hammerFrame.destroy();
      this.hammer.destroy();
      this._cleanUp();
    });
  }

  /**
   * @param {object} options
   */
  setOptions(options) {
    if (options !== undefined) {
      const fields = ["width", "height", "autoResize"];
      selectiveDeepExtend(fields, this.options, options);
    }

    // Automatically adapt to changing size of the container element.
    this._cleanUp();
    if (this.options.autoResize === true) {
      var _context2;
      if (window.ResizeObserver) {
        // decent browsers, immediate reactions
        const observer = new ResizeObserver(() => {
          const changed = this.setSize();
          if (changed === true) {
            this.body.emitter.emit("_requestRedraw");
          }
        });
        const {
          frame
        } = this;
        observer.observe(frame);
        this._cleanupCallbacks.push(() => {
          observer.unobserve(frame);
        });
      } else {
        // IE11, continous polling
        const resizeTimer = _setInterval(() => {
          const changed = this.setSize();
          if (changed === true) {
            this.body.emitter.emit("_requestRedraw");
          }
        }, 1000);
        this._cleanupCallbacks.push(() => {
          clearInterval(resizeTimer);
        });
      }

      // Automatically adapt to changing size of the browser.
      const resizeFunction = _bindInstanceProperty(_context2 = this._onResize).call(_context2, this);
      window.addEventListener("resize", resizeFunction);
      this._cleanupCallbacks.push(() => {
        window.removeEventListener("resize", resizeFunction);
      });
    }
  }

  /**
   * @private
   */
  _cleanUp() {
    var _context3, _context4, _context5;
    _forEachInstanceProperty(_context3 = _reverseInstanceProperty(_context4 = _spliceInstanceProperty(_context5 = this._cleanupCallbacks).call(_context5, 0)).call(_context4)).call(_context3, callback => {
      try {
        callback();
      } catch (error) {
        console.error(error);
      }
    });
  }

  /**
   * @private
   */
  _onResize() {
    this.setSize();
    this.body.emitter.emit("_redraw");
  }

  /**
   * Get and store the cameraState
   * @param {number} [pixelRatio]
   * @private
   */
  _getCameraState() {
    let pixelRatio = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.pixelRatio;
    if (this.initialized === true) {
      this.cameraState.previousWidth = this.frame.canvas.width / pixelRatio;
      this.cameraState.previousHeight = this.frame.canvas.height / pixelRatio;
      this.cameraState.scale = this.body.view.scale;
      this.cameraState.position = this.DOMtoCanvas({
        x: 0.5 * this.frame.canvas.width / pixelRatio,
        y: 0.5 * this.frame.canvas.height / pixelRatio
      });
    }
  }

  /**
   * Set the cameraState
   * @private
   */
  _setCameraState() {
    if (this.cameraState.scale !== undefined && this.frame.canvas.clientWidth !== 0 && this.frame.canvas.clientHeight !== 0 && this.pixelRatio !== 0 && this.cameraState.previousWidth > 0 && this.cameraState.previousHeight > 0) {
      const widthRatio = this.frame.canvas.width / this.pixelRatio / this.cameraState.previousWidth;
      const heightRatio = this.frame.canvas.height / this.pixelRatio / this.cameraState.previousHeight;
      let newScale = this.cameraState.scale;
      if (widthRatio != 1 && heightRatio != 1) {
        newScale = this.cameraState.scale * 0.5 * (widthRatio + heightRatio);
      } else if (widthRatio != 1) {
        newScale = this.cameraState.scale * widthRatio;
      } else if (heightRatio != 1) {
        newScale = this.cameraState.scale * heightRatio;
      }
      this.body.view.scale = newScale;
      // this comes from the view module.
      const currentViewCenter = this.DOMtoCanvas({
        x: 0.5 * this.frame.canvas.clientWidth,
        y: 0.5 * this.frame.canvas.clientHeight
      });
      const distanceFromCenter = {
        // offset from view, distance view has to change by these x and y to center the node
        x: currentViewCenter.x - this.cameraState.position.x,
        y: currentViewCenter.y - this.cameraState.position.y
      };
      this.body.view.translation.x += distanceFromCenter.x * this.body.view.scale;
      this.body.view.translation.y += distanceFromCenter.y * this.body.view.scale;
    }
  }

  /**
   *
   * @param {number|string} value
   * @returns {string}
   * @private
   */
  _prepareValue(value) {
    if (typeof value === "number") {
      return value + "px";
    } else if (typeof value === "string") {
      if (_indexOfInstanceProperty(value).call(value, "%") !== -1 || _indexOfInstanceProperty(value).call(value, "px") !== -1) {
        return value;
      } else if (_indexOfInstanceProperty(value).call(value, "%") === -1) {
        return value + "px";
      }
    }
    throw new Error("Could not use the value supplied for width or height:" + value);
  }

  /**
   * Create the HTML
   */
  _create() {
    // remove all elements from the container element.
    while (this.body.container.hasChildNodes()) {
      this.body.container.removeChild(this.body.container.firstChild);
    }
    this.frame = document.createElement("div");
    this.frame.className = "vis-network";
    this.frame.style.position = "relative";
    this.frame.style.overflow = "hidden";
    this.frame.tabIndex = 0; // tab index is required for keycharm to bind keystrokes to the div instead of the window

    //////////////////////////////////////////////////////////////////

    this.frame.canvas = document.createElement("canvas");
    this.frame.canvas.style.position = "relative";
    this.frame.appendChild(this.frame.canvas);
    if (!this.frame.canvas.getContext) {
      const noCanvas = document.createElement("DIV");
      noCanvas.style.color = "red";
      noCanvas.style.fontWeight = "bold";
      noCanvas.style.padding = "10px";
      noCanvas.innerText = "Error: your browser does not support HTML canvas";
      this.frame.canvas.appendChild(noCanvas);
    } else {
      this._setPixelRatio();
      this.setTransform();
    }

    // add the frame to the container element
    this.body.container.appendChild(this.frame);
    this.body.view.scale = 1;
    this.body.view.translation = {
      x: 0.5 * this.frame.canvas.clientWidth,
      y: 0.5 * this.frame.canvas.clientHeight
    };
    this._bindHammer();
  }

  /**
   * This function binds hammer, it can be repeated over and over due to the uniqueness check.
   * @private
   */
  _bindHammer() {
    if (this.hammer !== undefined) {
      this.hammer.destroy();
    }
    this.drag = {};
    this.pinch = {};

    // init hammer
    this.hammer = new Hammer(this.frame.canvas);
    this.hammer.get("pinch").set({
      enable: true
    });
    // enable to get better response, todo: test on mobile.
    this.hammer.get("pan").set({
      threshold: 5,
      direction: Hammer.DIRECTION_ALL
    });
    onTouch(this.hammer, event => {
      this.body.eventListeners.onTouch(event);
    });
    this.hammer.on("tap", event => {
      this.body.eventListeners.onTap(event);
    });
    this.hammer.on("doubletap", event => {
      this.body.eventListeners.onDoubleTap(event);
    });
    this.hammer.on("press", event => {
      this.body.eventListeners.onHold(event);
    });
    this.hammer.on("panstart", event => {
      this.body.eventListeners.onDragStart(event);
    });
    this.hammer.on("panmove", event => {
      this.body.eventListeners.onDrag(event);
    });
    this.hammer.on("panend", event => {
      this.body.eventListeners.onDragEnd(event);
    });
    this.hammer.on("pinch", event => {
      this.body.eventListeners.onPinch(event);
    });

    // TODO: neatly cleanup these handlers when re-creating the Canvas, IF these are done with hammer, event.stopPropagation will not work?
    this.frame.canvas.addEventListener("wheel", event => {
      this.body.eventListeners.onMouseWheel(event);
    });
    this.frame.canvas.addEventListener("mousemove", event => {
      this.body.eventListeners.onMouseMove(event);
    });
    this.frame.canvas.addEventListener("contextmenu", event => {
      this.body.eventListeners.onContext(event);
    });
    this.hammerFrame = new Hammer(this.frame);
    onRelease(this.hammerFrame, event => {
      this.body.eventListeners.onRelease(event);
    });
  }

  /**
   * Set a new size for the network
   * @param {string} width   Width in pixels or percentage (for example '800px'
   *                         or '50%')
   * @param {string} height  Height in pixels or percentage  (for example '400px'
   *                         or '30%')
   * @returns {boolean}
   */
  setSize() {
    let width = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.options.width;
    let height = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.options.height;
    width = this._prepareValue(width);
    height = this._prepareValue(height);
    let emitEvent = false;
    const oldWidth = this.frame.canvas.width;
    const oldHeight = this.frame.canvas.height;

    // update the pixel ratio
    //
    // NOTE: Comment in following is rather inconsistent; this is the ONLY place in the code
    //       where it is assumed that the pixel ratio could change at runtime.
    //       The only way I can think of this happening is a rotating screen or tablet; but then
    //       there should be a mechanism for reloading the data (TODO: check if this is present).
    //
    //       If the assumption is true (i.e. pixel ratio can change at runtime), then *all* usage
    //       of pixel ratio must be overhauled for this.
    //
    //       For the time being, I will humor the assumption here, and in the rest of the code assume it is
    //       constant.
    const previousRatio = this.pixelRatio; // we cache this because the camera state storage needs the old value
    this._setPixelRatio();
    if (width != this.options.width || height != this.options.height || this.frame.style.width != width || this.frame.style.height != height) {
      this._getCameraState(previousRatio);
      this.frame.style.width = width;
      this.frame.style.height = height;
      this.frame.canvas.style.width = "100%";
      this.frame.canvas.style.height = "100%";
      this.frame.canvas.width = Math.round(this.frame.canvas.clientWidth * this.pixelRatio);
      this.frame.canvas.height = Math.round(this.frame.canvas.clientHeight * this.pixelRatio);
      this.options.width = width;
      this.options.height = height;
      this.canvasViewCenter = {
        x: 0.5 * this.frame.clientWidth,
        y: 0.5 * this.frame.clientHeight
      };
      emitEvent = true;
    } else {
      // this would adapt the width of the canvas to the width from 100% if and only if
      // there is a change.

      const newWidth = Math.round(this.frame.canvas.clientWidth * this.pixelRatio);
      const newHeight = Math.round(this.frame.canvas.clientHeight * this.pixelRatio);

      // store the camera if there is a change in size.
      if (this.frame.canvas.width !== newWidth || this.frame.canvas.height !== newHeight) {
        this._getCameraState(previousRatio);
      }
      if (this.frame.canvas.width !== newWidth) {
        this.frame.canvas.width = newWidth;
        emitEvent = true;
      }
      if (this.frame.canvas.height !== newHeight) {
        this.frame.canvas.height = newHeight;
        emitEvent = true;
      }
    }
    if (emitEvent === true) {
      this.body.emitter.emit("resize", {
        width: Math.round(this.frame.canvas.width / this.pixelRatio),
        height: Math.round(this.frame.canvas.height / this.pixelRatio),
        oldWidth: Math.round(oldWidth / this.pixelRatio),
        oldHeight: Math.round(oldHeight / this.pixelRatio)
      });

      // restore the camera on change.
      this._setCameraState();
    }

    // set initialized so the get and set camera will work from now on.
    this.initialized = true;
    return emitEvent;
  }

  /**
   *
   * @returns {CanvasRenderingContext2D}
   */
  getContext() {
    return this.frame.canvas.getContext("2d");
  }

  /**
   * Determine the pixel ratio for various browsers.
   * @returns {number}
   * @private
   */
  _determinePixelRatio() {
    const ctx = this.getContext();
    if (ctx === undefined) {
      throw new Error("Could not get canvax context");
    }
    let numerator = 1;
    if (typeof window !== "undefined") {
      // (window !== undefined) doesn't work here!
      // Protection during unit tests, where 'window' can be missing
      numerator = window.devicePixelRatio || 1;
    }
    const denominator = ctx.webkitBackingStorePixelRatio || ctx.mozBackingStorePixelRatio || ctx.msBackingStorePixelRatio || ctx.oBackingStorePixelRatio || ctx.backingStorePixelRatio || 1;
    return numerator / denominator;
  }

  /**
   * Lazy determination of pixel ratio.
   * @private
   */
  _setPixelRatio() {
    this.pixelRatio = this._determinePixelRatio();
  }

  /**
   * Set the transform in the contained context, based on its pixelRatio
   */
  setTransform() {
    const ctx = this.getContext();
    if (ctx === undefined) {
      throw new Error("Could not get canvax context");
    }
    ctx.setTransform(this.pixelRatio, 0, 0, this.pixelRatio, 0, 0);
  }

  /**
   * Convert the X coordinate in DOM-space (coordinate point in browser relative to the container div) to
   * the X coordinate in canvas-space (the simulation sandbox, which the camera looks upon)
   * @param {number} x
   * @returns {number}
   * @private
   */
  _XconvertDOMtoCanvas(x) {
    return (x - this.body.view.translation.x) / this.body.view.scale;
  }

  /**
   * Convert the X coordinate in canvas-space (the simulation sandbox, which the camera looks upon) to
   * the X coordinate in DOM-space (coordinate point in browser relative to the container div)
   * @param {number} x
   * @returns {number}
   * @private
   */
  _XconvertCanvasToDOM(x) {
    return x * this.body.view.scale + this.body.view.translation.x;
  }

  /**
   * Convert the Y coordinate in DOM-space (coordinate point in browser relative to the container div) to
   * the Y coordinate in canvas-space (the simulation sandbox, which the camera looks upon)
   * @param {number} y
   * @returns {number}
   * @private
   */
  _YconvertDOMtoCanvas(y) {
    return (y - this.body.view.translation.y) / this.body.view.scale;
  }

  /**
   * Convert the Y coordinate in canvas-space (the simulation sandbox, which the camera looks upon) to
   * the Y coordinate in DOM-space (coordinate point in browser relative to the container div)
   * @param {number} y
   * @returns {number}
   * @private
   */
  _YconvertCanvasToDOM(y) {
    return y * this.body.view.scale + this.body.view.translation.y;
  }

  /**
   * @param {point} pos
   * @returns {point}
   */
  canvasToDOM(pos) {
    return {
      x: this._XconvertCanvasToDOM(pos.x),
      y: this._YconvertCanvasToDOM(pos.y)
    };
  }

  /**
   *
   * @param {point} pos
   * @returns {point}
   */
  DOMtoCanvas(pos) {
    return {
      x: this._XconvertDOMtoCanvas(pos.x),
      y: this._YconvertDOMtoCanvas(pos.y)
    };
  }
}

/**
 * Validate the fit options, replace missing optional values by defaults etc.
 * @param rawOptions - The raw options.
 * @param allNodeIds - All node ids that will be used if nodes are omitted in
 * the raw options.
 * @returns Options with everything filled in and validated.
 */
function normalizeFitOptions(rawOptions, allNodeIds) {
  const options = _Object$assign({
    nodes: allNodeIds,
    minZoomLevel: Number.MIN_VALUE,
    maxZoomLevel: 1
  }, rawOptions !== null && rawOptions !== void 0 ? rawOptions : {});
  if (!_Array$isArray(options.nodes)) {
    throw new TypeError("Nodes has to be an array of ids.");
  }
  if (options.nodes.length === 0) {
    options.nodes = allNodeIds;
  }
  if (!(typeof options.minZoomLevel === "number" && options.minZoomLevel > 0)) {
    throw new TypeError("Min zoom level has to be a number higher than zero.");
  }
  if (!(typeof options.maxZoomLevel === "number" && options.minZoomLevel <= options.maxZoomLevel)) {
    throw new TypeError("Max zoom level has to be a number higher than min zoom level.");
  }
  return options;
}

/**
 * The view
 */
class View {
  /**
   * @param {object} body
   * @param {Canvas} canvas
   */
  constructor(body, canvas) {
    var _context, _context2;
    this.body = body;
    this.canvas = canvas;
    this.animationSpeed = 1 / this.renderRefreshRate;
    this.animationEasingFunction = "easeInOutQuint";
    this.easingTime = 0;
    this.sourceScale = 0;
    this.targetScale = 0;
    this.sourceTranslation = 0;
    this.targetTranslation = 0;
    this.lockedOnNodeId = undefined;
    this.lockedOnNodeOffset = undefined;
    this.touchTime = 0;
    this.viewFunction = undefined;
    this.body.emitter.on("fit", _bindInstanceProperty(_context = this.fit).call(_context, this));
    this.body.emitter.on("animationFinished", () => {
      this.body.emitter.emit("_stopRendering");
    });
    this.body.emitter.on("unlockNode", _bindInstanceProperty(_context2 = this.releaseNode).call(_context2, this));
  }

  /**
   *
   * @param {object} [options]
   */
  setOptions() {
    let options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    this.options = options;
  }

  /**
   * This function zooms out to fit all data on screen based on amount of nodes
   * @param {object} [options={{nodes=Array}}]
   * @param options
   * @param {boolean} [initialZoom]  | zoom based on fitted formula or range, true = fitted, default = false;
   */
  fit(options) {
    let initialZoom = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
    options = normalizeFitOptions(options, this.body.nodeIndices);
    const canvasWidth = this.canvas.frame.canvas.clientWidth;
    const canvasHeight = this.canvas.frame.canvas.clientHeight;
    let range;
    let zoomLevel;
    if (canvasWidth === 0 || canvasHeight === 0) {
      // There's no point in trying to fit into zero sized canvas. This could
      // potentially even result in invalid values being computed. For example
      // for network without nodes and zero sized canvas the zoom level would
      // end up being computed as 0/0 which results in NaN. In any other case
      // this would be 0/something which is again pointless to compute.
      zoomLevel = 1;
      range = NetworkUtil.getRange(this.body.nodes, options.nodes);
    } else if (initialZoom === true) {
      // check if more than half of the nodes have a predefined position. If so, we use the range, not the approximation.
      let positionDefined = 0;
      for (const nodeId in this.body.nodes) {
        if (Object.prototype.hasOwnProperty.call(this.body.nodes, nodeId)) {
          const node = this.body.nodes[nodeId];
          if (node.predefinedPosition === true) {
            positionDefined += 1;
          }
        }
      }
      if (positionDefined > 0.5 * this.body.nodeIndices.length) {
        this.fit(options, false);
        return;
      }
      range = NetworkUtil.getRange(this.body.nodes, options.nodes);
      const numberOfNodes = this.body.nodeIndices.length;
      zoomLevel = 12.662 / (numberOfNodes + 7.4147) + 0.0964822; // this is obtained from fitting a dataset from 5 points with scale levels that looked good.

      // correct for larger canvasses.
      const factor = Math.min(canvasWidth / 600, canvasHeight / 600);
      zoomLevel *= factor;
    } else {
      this.body.emitter.emit("_resizeNodes");
      range = NetworkUtil.getRange(this.body.nodes, options.nodes);
      const xDistance = Math.abs(range.maxX - range.minX) * 1.1;
      const yDistance = Math.abs(range.maxY - range.minY) * 1.1;
      const xZoomLevel = canvasWidth / xDistance;
      const yZoomLevel = canvasHeight / yDistance;
      zoomLevel = xZoomLevel <= yZoomLevel ? xZoomLevel : yZoomLevel;
    }
    if (zoomLevel > options.maxZoomLevel) {
      zoomLevel = options.maxZoomLevel;
    } else if (zoomLevel < options.minZoomLevel) {
      zoomLevel = options.minZoomLevel;
    }
    const center = NetworkUtil.findCenter(range);
    const animationOptions = {
      position: center,
      scale: zoomLevel,
      animation: options.animation
    };
    this.moveTo(animationOptions);
  }

  // animation

  /**
   * Center a node in view.
   * @param {number} nodeId
   * @param {number} [options]
   */
  focus(nodeId) {
    let options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    if (this.body.nodes[nodeId] !== undefined) {
      const nodePosition = {
        x: this.body.nodes[nodeId].x,
        y: this.body.nodes[nodeId].y
      };
      options.position = nodePosition;
      options.lockedOnNode = nodeId;
      this.moveTo(options);
    } else {
      console.error("Node: " + nodeId + " cannot be found.");
    }
  }

  /**
   *
   * @param {object} options  |  options.offset   = {x:number, y:number}   // offset from the center in DOM pixels
   *                          |  options.scale    = number                 // scale to move to
   *                          |  options.position = {x:number, y:number}   // position to move to
   *                          |  options.animation = {duration:number, easingFunction:String} || Boolean   // position to move to
   */
  moveTo(options) {
    if (options === undefined) {
      options = {};
      return;
    }
    if (options.offset != null) {
      if (options.offset.x != null) {
        // Coerce and verify that x is valid.
        options.offset.x = +options.offset.x;
        if (!_Number$isFinite(options.offset.x)) {
          throw new TypeError('The option "offset.x" has to be a finite number.');
        }
      } else {
        options.offset.x = 0;
      }
      if (options.offset.y != null) {
        // Coerce and verify that y is valid.
        options.offset.y = +options.offset.y;
        if (!_Number$isFinite(options.offset.y)) {
          throw new TypeError('The option "offset.y" has to be a finite number.');
        }
      } else {
        options.offset.x = 0;
      }
    } else {
      options.offset = {
        x: 0,
        y: 0
      };
    }
    if (options.position != null) {
      if (options.position.x != null) {
        // Coerce and verify that x is valid.
        options.position.x = +options.position.x;
        if (!_Number$isFinite(options.position.x)) {
          throw new TypeError('The option "position.x" has to be a finite number.');
        }
      } else {
        options.position.x = 0;
      }
      if (options.position.y != null) {
        // Coerce and verify that y is valid.
        options.position.y = +options.position.y;
        if (!_Number$isFinite(options.position.y)) {
          throw new TypeError('The option "position.y" has to be a finite number.');
        }
      } else {
        options.position.x = 0;
      }
    } else {
      options.position = this.getViewPosition();
    }
    if (options.scale != null) {
      // Coerce and verify that the scale is valid.
      options.scale = +options.scale;
      if (!(options.scale > 0)) {
        throw new TypeError('The option "scale" has to be a number greater than zero.');
      }
    } else {
      options.scale = this.body.view.scale;
    }
    if (options.animation === undefined) {
      options.animation = {
        duration: 0
      };
    }
    if (options.animation === false) {
      options.animation = {
        duration: 0
      };
    }
    if (options.animation === true) {
      options.animation = {};
    }
    if (options.animation.duration === undefined) {
      options.animation.duration = 1000;
    } // default duration
    if (options.animation.easingFunction === undefined) {
      options.animation.easingFunction = "easeInOutQuad";
    } // default easing function

    this.animateView(options);
  }

  /**
   *
   * @param {object} options  |  options.offset   = {x:number, y:number}   // offset from the center in DOM pixels
   *                          |  options.time     = number                 // animation time in milliseconds
   *                          |  options.scale    = number                 // scale to animate to
   *                          |  options.position = {x:number, y:number}   // position to animate to
   *                          |  options.easingFunction = String           // linear, easeInQuad, easeOutQuad, easeInOutQuad,
   *                                                                       // easeInCubic, easeOutCubic, easeInOutCubic,
   *                                                                       // easeInQuart, easeOutQuart, easeInOutQuart,
   *                                                                       // easeInQuint, easeOutQuint, easeInOutQuint
   */
  animateView(options) {
    if (options === undefined) {
      return;
    }
    this.animationEasingFunction = options.animation.easingFunction;
    // release if something focussed on the node
    this.releaseNode();
    if (options.locked === true) {
      this.lockedOnNodeId = options.lockedOnNode;
      this.lockedOnNodeOffset = options.offset;
    }

    // forcefully complete the old animation if it was still running
    if (this.easingTime != 0) {
      this._transitionRedraw(true); // by setting easingtime to 1, we finish the animation.
    }

    this.sourceScale = this.body.view.scale;
    this.sourceTranslation = this.body.view.translation;
    this.targetScale = options.scale;

    // set the scale so the viewCenter is based on the correct zoom level. This is overridden in the transitionRedraw
    // but at least then we'll have the target transition
    this.body.view.scale = this.targetScale;
    const viewCenter = this.canvas.DOMtoCanvas({
      x: 0.5 * this.canvas.frame.canvas.clientWidth,
      y: 0.5 * this.canvas.frame.canvas.clientHeight
    });
    const distanceFromCenter = {
      // offset from view, distance view has to change by these x and y to center the node
      x: viewCenter.x - options.position.x,
      y: viewCenter.y - options.position.y
    };
    this.targetTranslation = {
      x: this.sourceTranslation.x + distanceFromCenter.x * this.targetScale + options.offset.x,
      y: this.sourceTranslation.y + distanceFromCenter.y * this.targetScale + options.offset.y
    };

    // if the time is set to 0, don't do an animation
    if (options.animation.duration === 0) {
      if (this.lockedOnNodeId != undefined) {
        var _context3;
        this.viewFunction = _bindInstanceProperty(_context3 = this._lockedRedraw).call(_context3, this);
        this.body.emitter.on("initRedraw", this.viewFunction);
      } else {
        this.body.view.scale = this.targetScale;
        this.body.view.translation = this.targetTranslation;
        this.body.emitter.emit("_requestRedraw");
      }
    } else {
      var _context4;
      this.animationSpeed = 1 / (60 * options.animation.duration * 0.001) || 1 / 60; // 60 for 60 seconds, 0.001 for milli's
      this.animationEasingFunction = options.animation.easingFunction;
      this.viewFunction = _bindInstanceProperty(_context4 = this._transitionRedraw).call(_context4, this);
      this.body.emitter.on("initRedraw", this.viewFunction);
      this.body.emitter.emit("_startRendering");
    }
  }

  /**
   * used to animate smoothly by hijacking the redraw function.
   * @private
   */
  _lockedRedraw() {
    const nodePosition = {
      x: this.body.nodes[this.lockedOnNodeId].x,
      y: this.body.nodes[this.lockedOnNodeId].y
    };
    const viewCenter = this.canvas.DOMtoCanvas({
      x: 0.5 * this.canvas.frame.canvas.clientWidth,
      y: 0.5 * this.canvas.frame.canvas.clientHeight
    });
    const distanceFromCenter = {
      // offset from view, distance view has to change by these x and y to center the node
      x: viewCenter.x - nodePosition.x,
      y: viewCenter.y - nodePosition.y
    };
    const sourceTranslation = this.body.view.translation;
    const targetTranslation = {
      x: sourceTranslation.x + distanceFromCenter.x * this.body.view.scale + this.lockedOnNodeOffset.x,
      y: sourceTranslation.y + distanceFromCenter.y * this.body.view.scale + this.lockedOnNodeOffset.y
    };
    this.body.view.translation = targetTranslation;
  }

  /**
   * Resets state of a locked on Node
   */
  releaseNode() {
    if (this.lockedOnNodeId !== undefined && this.viewFunction !== undefined) {
      this.body.emitter.off("initRedraw", this.viewFunction);
      this.lockedOnNodeId = undefined;
      this.lockedOnNodeOffset = undefined;
    }
  }

  /**
   * @param {boolean} [finished]
   * @private
   */
  _transitionRedraw() {
    let finished = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
    this.easingTime += this.animationSpeed;
    this.easingTime = finished === true ? 1.0 : this.easingTime;
    const progress = easingFunctions[this.animationEasingFunction](this.easingTime);
    this.body.view.scale = this.sourceScale + (this.targetScale - this.sourceScale) * progress;
    this.body.view.translation = {
      x: this.sourceTranslation.x + (this.targetTranslation.x - this.sourceTranslation.x) * progress,
      y: this.sourceTranslation.y + (this.targetTranslation.y - this.sourceTranslation.y) * progress
    };

    // cleanup
    if (this.easingTime >= 1.0) {
      this.body.emitter.off("initRedraw", this.viewFunction);
      this.easingTime = 0;
      if (this.lockedOnNodeId != undefined) {
        var _context5;
        this.viewFunction = _bindInstanceProperty(_context5 = this._lockedRedraw).call(_context5, this);
        this.body.emitter.on("initRedraw", this.viewFunction);
      }
      this.body.emitter.emit("animationFinished");
    }
  }

  /**
   *
   * @returns {number}
   */
  getScale() {
    return this.body.view.scale;
  }

  /**
   *
   * @returns {{x: number, y: number}}
   */
  getViewPosition() {
    return this.canvas.DOMtoCanvas({
      x: 0.5 * this.canvas.frame.canvas.clientWidth,
      y: 0.5 * this.canvas.frame.canvas.clientHeight
    });
  }
}

/**
 * Created by Alex on 11/6/2014.
 */
function keycharm(options) {
  var preventDefault = options && options.preventDefault || false;

  var container = options && options.container || window;

  var _exportFunctions = {};
  var _bound = {keydown:{}, keyup:{}};
  var _keys = {};
  var i;

  // a - z
  for (i = 97; i <= 122; i++) {_keys[String.fromCharCode(i)] = {code:65 + (i - 97), shift: false};}
  // A - Z
  for (i = 65; i <= 90; i++) {_keys[String.fromCharCode(i)] = {code:i, shift: true};}
  // 0 - 9
  for (i = 0;  i <= 9;   i++) {_keys['' + i] = {code:48 + i, shift: false};}
  // F1 - F12
  for (i = 1;  i <= 12;   i++) {_keys['F' + i] = {code:111 + i, shift: false};}
  // num0 - num9
  for (i = 0;  i <= 9;   i++) {_keys['num' + i] = {code:96 + i, shift: false};}

  // numpad misc
  _keys['num*'] = {code:106, shift: false};
  _keys['num+'] = {code:107, shift: false};
  _keys['num-'] = {code:109, shift: false};
  _keys['num/'] = {code:111, shift: false};
  _keys['num.'] = {code:110, shift: false};
  // arrows
  _keys['left']  = {code:37, shift: false};
  _keys['up']    = {code:38, shift: false};
  _keys['right'] = {code:39, shift: false};
  _keys['down']  = {code:40, shift: false};
  // extra keys
  _keys['space'] = {code:32, shift: false};
  _keys['enter'] = {code:13, shift: false};
  _keys['shift'] = {code:16, shift: undefined};
  _keys['esc']   = {code:27, shift: false};
  _keys['backspace'] = {code:8, shift: false};
  _keys['tab']       = {code:9, shift: false};
  _keys['ctrl']      = {code:17, shift: false};
  _keys['alt']       = {code:18, shift: false};
  _keys['delete']    = {code:46, shift: false};
  _keys['pageup']    = {code:33, shift: false};
  _keys['pagedown']  = {code:34, shift: false};
  // symbols
  _keys['=']     = {code:187, shift: false};
  _keys['-']     = {code:189, shift: false};
  _keys[']']     = {code:221, shift: false};
  _keys['[']     = {code:219, shift: false};



  var down = function(event) {handleEvent(event,'keydown');};
  var up = function(event) {handleEvent(event,'keyup');};

  // handle the actualy bound key with the event
  var handleEvent = function(event,type) {
    if (_bound[type][event.keyCode] !== undefined) {
      var bound = _bound[type][event.keyCode];
      for (var i = 0; i < bound.length; i++) {
        if (bound[i].shift === undefined) {
          bound[i].fn(event);
        }
        else if (bound[i].shift == true && event.shiftKey == true) {
          bound[i].fn(event);
        }
        else if (bound[i].shift == false && event.shiftKey == false) {
          bound[i].fn(event);
        }
      }

      if (preventDefault == true) {
        event.preventDefault();
      }
    }
  };

  // bind a key to a callback
  _exportFunctions.bind = function(key, callback, type) {
    if (type === undefined) {
      type = 'keydown';
    }
    if (_keys[key] === undefined) {
      throw new Error("unsupported key: " + key);
    }
    if (_bound[type][_keys[key].code] === undefined) {
      _bound[type][_keys[key].code] = [];
    }
    _bound[type][_keys[key].code].push({fn:callback, shift:_keys[key].shift});
  };


  // bind all keys to a call back (demo purposes)
  _exportFunctions.bindAll = function(callback, type) {
    if (type === undefined) {
      type = 'keydown';
    }
    for (var key in _keys) {
      if (_keys.hasOwnProperty(key)) {
        _exportFunctions.bind(key,callback,type);
      }
    }
  };

  // get the key label from an event
  _exportFunctions.getKey = function(event) {
    for (var key in _keys) {
      if (_keys.hasOwnProperty(key)) {
        if (event.shiftKey == true && _keys[key].shift == true && event.keyCode == _keys[key].code) {
          return key;
        }
        else if (event.shiftKey == false && _keys[key].shift == false && event.keyCode == _keys[key].code) {
          return key;
        }
        else if (event.keyCode == _keys[key].code && key == 'shift') {
          return key;
        }
      }
    }
    return "unknown key, currently not supported";
  };

  // unbind either a specific callback from a key or all of them (by leaving callback undefined)
  _exportFunctions.unbind = function(key, callback, type) {
    if (type === undefined) {
      type = 'keydown';
    }
    if (_keys[key] === undefined) {
      throw new Error("unsupported key: " + key);
    }
    if (callback !== undefined) {
      var newBindings = [];
      var bound = _bound[type][_keys[key].code];
      if (bound !== undefined) {
        for (var i = 0; i < bound.length; i++) {
          if (!(bound[i].fn == callback && bound[i].shift == _keys[key].shift)) {
            newBindings.push(_bound[type][_keys[key].code][i]);
          }
        }
      }
      _bound[type][_keys[key].code] = newBindings;
    }
    else {
      _bound[type][_keys[key].code] = [];
    }
  };

  // reset all bound variables.
  _exportFunctions.reset = function() {
    _bound = {keydown:{}, keyup:{}};
  };

  // unbind all listeners and reset all variables.
  _exportFunctions.destroy = function() {
    _bound = {keydown:{}, keyup:{}};
    container.removeEventListener('keydown', down, true);
    container.removeEventListener('keyup', up, true);
  };

  // create listeners.
  container.addEventListener('keydown',down,true);
  container.addEventListener('keyup',up,true);

  // return the public functions.
  return _exportFunctions;
}

/**
 * Navigation Handler
 */
class NavigationHandler {
  /**
   * @param {object} body
   * @param {Canvas} canvas
   */
  constructor(body, canvas) {
    this.body = body;
    this.canvas = canvas;
    this.iconsCreated = false;
    this.navigationHammers = [];
    this.boundFunctions = {};
    this.touchTime = 0;
    this.activated = false;
    this.body.emitter.on("activate", () => {
      this.activated = true;
      this.configureKeyboardBindings();
    });
    this.body.emitter.on("deactivate", () => {
      this.activated = false;
      this.configureKeyboardBindings();
    });
    this.body.emitter.on("destroy", () => {
      if (this.keycharm !== undefined) {
        this.keycharm.destroy();
      }
    });
    this.options = {};
  }

  /**
   *
   * @param {object} options
   */
  setOptions(options) {
    if (options !== undefined) {
      this.options = options;
      this.create();
    }
  }

  /**
   * Creates or refreshes navigation and sets key bindings
   */
  create() {
    if (this.options.navigationButtons === true) {
      if (this.iconsCreated === false) {
        this.loadNavigationElements();
      }
    } else if (this.iconsCreated === true) {
      this.cleanNavigation();
    }
    this.configureKeyboardBindings();
  }

  /**
   * Cleans up previous navigation items
   */
  cleanNavigation() {
    // clean hammer bindings
    if (this.navigationHammers.length != 0) {
      for (let i = 0; i < this.navigationHammers.length; i++) {
        this.navigationHammers[i].destroy();
      }
      this.navigationHammers = [];
    }

    // clean up previous navigation items
    if (this.navigationDOM && this.navigationDOM["wrapper"] && this.navigationDOM["wrapper"].parentNode) {
      this.navigationDOM["wrapper"].parentNode.removeChild(this.navigationDOM["wrapper"]);
    }
    this.iconsCreated = false;
  }

  /**
   * Creation of the navigation controls nodes. They are drawn over the rest of the nodes and are not affected by scale and translation
   * they have a triggerFunction which is called on click. If the position of the navigation controls is dependent
   * on this.frame.canvas.clientWidth or this.frame.canvas.clientHeight, we flag horizontalAlignLeft and verticalAlignTop false.
   * This means that the location will be corrected by the _relocateNavigation function on a size change of the canvas.
   * @private
   */
  loadNavigationElements() {
    this.cleanNavigation();
    this.navigationDOM = {};
    const navigationDivs = ["up", "down", "left", "right", "zoomIn", "zoomOut", "zoomExtends"];
    const navigationDivActions = ["_moveUp", "_moveDown", "_moveLeft", "_moveRight", "_zoomIn", "_zoomOut", "_fit"];
    this.navigationDOM["wrapper"] = document.createElement("div");
    this.navigationDOM["wrapper"].className = "vis-navigation";
    this.canvas.frame.appendChild(this.navigationDOM["wrapper"]);
    for (let i = 0; i < navigationDivs.length; i++) {
      this.navigationDOM[navigationDivs[i]] = document.createElement("div");
      this.navigationDOM[navigationDivs[i]].className = "vis-button vis-" + navigationDivs[i];
      this.navigationDOM["wrapper"].appendChild(this.navigationDOM[navigationDivs[i]]);
      const hammer = new Hammer(this.navigationDOM[navigationDivs[i]]);
      if (navigationDivActions[i] === "_fit") {
        var _context;
        onTouch(hammer, _bindInstanceProperty(_context = this._fit).call(_context, this));
      } else {
        var _context2;
        onTouch(hammer, _bindInstanceProperty(_context2 = this.bindToRedraw).call(_context2, this, navigationDivActions[i]));
      }
      this.navigationHammers.push(hammer);
    }

    // use a hammer for the release so we do not require the one used in the rest of the network
    // the one the rest uses can be overloaded by the manipulation system.
    const hammerFrame = new Hammer(this.canvas.frame);
    onRelease(hammerFrame, () => {
      this._stopMovement();
    });
    this.navigationHammers.push(hammerFrame);
    this.iconsCreated = true;
  }

  /**
   *
   * @param {string} action
   */
  bindToRedraw(action) {
    if (this.boundFunctions[action] === undefined) {
      var _context3;
      this.boundFunctions[action] = _bindInstanceProperty(_context3 = this[action]).call(_context3, this);
      this.body.emitter.on("initRedraw", this.boundFunctions[action]);
      this.body.emitter.emit("_startRendering");
    }
  }

  /**
   *
   * @param {string} action
   */
  unbindFromRedraw(action) {
    if (this.boundFunctions[action] !== undefined) {
      this.body.emitter.off("initRedraw", this.boundFunctions[action]);
      this.body.emitter.emit("_stopRendering");
      delete this.boundFunctions[action];
    }
  }

  /**
   * this stops all movement induced by the navigation buttons
   * @private
   */
  _fit() {
    if (new Date().valueOf() - this.touchTime > 700) {
      // TODO: fix ugly hack to avoid hammer's double fireing of event (because we use release?)
      this.body.emitter.emit("fit", {
        duration: 700
      });
      this.touchTime = new Date().valueOf();
    }
  }

  /**
   * this stops all movement induced by the navigation buttons
   * @private
   */
  _stopMovement() {
    for (const boundAction in this.boundFunctions) {
      if (Object.prototype.hasOwnProperty.call(this.boundFunctions, boundAction)) {
        this.body.emitter.off("initRedraw", this.boundFunctions[boundAction]);
        this.body.emitter.emit("_stopRendering");
      }
    }
    this.boundFunctions = {};
  }
  /**
   *
   * @private
   */
  _moveUp() {
    this.body.view.translation.y += this.options.keyboard.speed.y;
  }
  /**
   *
   * @private
   */
  _moveDown() {
    this.body.view.translation.y -= this.options.keyboard.speed.y;
  }
  /**
   *
   * @private
   */
  _moveLeft() {
    this.body.view.translation.x += this.options.keyboard.speed.x;
  }
  /**
   *
   * @private
   */
  _moveRight() {
    this.body.view.translation.x -= this.options.keyboard.speed.x;
  }
  /**
   *
   * @private
   */
  _zoomIn() {
    const scaleOld = this.body.view.scale;
    const scale = this.body.view.scale * (1 + this.options.keyboard.speed.zoom);
    const translation = this.body.view.translation;
    const scaleFrac = scale / scaleOld;
    const tx = (1 - scaleFrac) * this.canvas.canvasViewCenter.x + translation.x * scaleFrac;
    const ty = (1 - scaleFrac) * this.canvas.canvasViewCenter.y + translation.y * scaleFrac;
    this.body.view.scale = scale;
    this.body.view.translation = {
      x: tx,
      y: ty
    };
    this.body.emitter.emit("zoom", {
      direction: "+",
      scale: this.body.view.scale,
      pointer: null
    });
  }

  /**
   *
   * @private
   */
  _zoomOut() {
    const scaleOld = this.body.view.scale;
    const scale = this.body.view.scale / (1 + this.options.keyboard.speed.zoom);
    const translation = this.body.view.translation;
    const scaleFrac = scale / scaleOld;
    const tx = (1 - scaleFrac) * this.canvas.canvasViewCenter.x + translation.x * scaleFrac;
    const ty = (1 - scaleFrac) * this.canvas.canvasViewCenter.y + translation.y * scaleFrac;
    this.body.view.scale = scale;
    this.body.view.translation = {
      x: tx,
      y: ty
    };
    this.body.emitter.emit("zoom", {
      direction: "-",
      scale: this.body.view.scale,
      pointer: null
    });
  }

  /**
   * bind all keys using keycharm.
   */
  configureKeyboardBindings() {
    if (this.keycharm !== undefined) {
      this.keycharm.destroy();
    }
    if (this.options.keyboard.enabled === true) {
      if (this.options.keyboard.bindToWindow === true) {
        this.keycharm = keycharm({
          container: window,
          preventDefault: true
        });
      } else {
        this.keycharm = keycharm({
          container: this.canvas.frame,
          preventDefault: true
        });
      }
      this.keycharm.reset();
      if (this.activated === true) {
        var _context4, _context5, _context6, _context7, _context8, _context9, _context10, _context11, _context12, _context13, _context14, _context15, _context16, _context17, _context18, _context19, _context20, _context21, _context22, _context23, _context24, _context25, _context26, _context27;
        _bindInstanceProperty(_context4 = this.keycharm).call(_context4, "up", () => {
          this.bindToRedraw("_moveUp");
        }, "keydown");
        _bindInstanceProperty(_context5 = this.keycharm).call(_context5, "down", () => {
          this.bindToRedraw("_moveDown");
        }, "keydown");
        _bindInstanceProperty(_context6 = this.keycharm).call(_context6, "left", () => {
          this.bindToRedraw("_moveLeft");
        }, "keydown");
        _bindInstanceProperty(_context7 = this.keycharm).call(_context7, "right", () => {
          this.bindToRedraw("_moveRight");
        }, "keydown");
        _bindInstanceProperty(_context8 = this.keycharm).call(_context8, "=", () => {
          this.bindToRedraw("_zoomIn");
        }, "keydown");
        _bindInstanceProperty(_context9 = this.keycharm).call(_context9, "num+", () => {
          this.bindToRedraw("_zoomIn");
        }, "keydown");
        _bindInstanceProperty(_context10 = this.keycharm).call(_context10, "num-", () => {
          this.bindToRedraw("_zoomOut");
        }, "keydown");
        _bindInstanceProperty(_context11 = this.keycharm).call(_context11, "-", () => {
          this.bindToRedraw("_zoomOut");
        }, "keydown");
        _bindInstanceProperty(_context12 = this.keycharm).call(_context12, "[", () => {
          this.bindToRedraw("_zoomOut");
        }, "keydown");
        _bindInstanceProperty(_context13 = this.keycharm).call(_context13, "]", () => {
          this.bindToRedraw("_zoomIn");
        }, "keydown");
        _bindInstanceProperty(_context14 = this.keycharm).call(_context14, "pageup", () => {
          this.bindToRedraw("_zoomIn");
        }, "keydown");
        _bindInstanceProperty(_context15 = this.keycharm).call(_context15, "pagedown", () => {
          this.bindToRedraw("_zoomOut");
        }, "keydown");
        _bindInstanceProperty(_context16 = this.keycharm).call(_context16, "up", () => {
          this.unbindFromRedraw("_moveUp");
        }, "keyup");
        _bindInstanceProperty(_context17 = this.keycharm).call(_context17, "down", () => {
          this.unbindFromRedraw("_moveDown");
        }, "keyup");
        _bindInstanceProperty(_context18 = this.keycharm).call(_context18, "left", () => {
          this.unbindFromRedraw("_moveLeft");
        }, "keyup");
        _bindInstanceProperty(_context19 = this.keycharm).call(_context19, "right", () => {
          this.unbindFromRedraw("_moveRight");
        }, "keyup");
        _bindInstanceProperty(_context20 = this.keycharm).call(_context20, "=", () => {
          this.unbindFromRedraw("_zoomIn");
        }, "keyup");
        _bindInstanceProperty(_context21 = this.keycharm).call(_context21, "num+", () => {
          this.unbindFromRedraw("_zoomIn");
        }, "keyup");
        _bindInstanceProperty(_context22 = this.keycharm).call(_context22, "num-", () => {
          this.unbindFromRedraw("_zoomOut");
        }, "keyup");
        _bindInstanceProperty(_context23 = this.keycharm).call(_context23, "-", () => {
          this.unbindFromRedraw("_zoomOut");
        }, "keyup");
        _bindInstanceProperty(_context24 = this.keycharm).call(_context24, "[", () => {
          this.unbindFromRedraw("_zoomOut");
        }, "keyup");
        _bindInstanceProperty(_context25 = this.keycharm).call(_context25, "]", () => {
          this.unbindFromRedraw("_zoomIn");
        }, "keyup");
        _bindInstanceProperty(_context26 = this.keycharm).call(_context26, "pageup", () => {
          this.unbindFromRedraw("_zoomIn");
        }, "keyup");
        _bindInstanceProperty(_context27 = this.keycharm).call(_context27, "pagedown", () => {
          this.unbindFromRedraw("_zoomOut");
        }, "keyup");
      }
    }
  }
}

/**
 * Handler for interactions
 */
class InteractionHandler {
  /**
   * @param {object} body
   * @param {Canvas} canvas
   * @param {SelectionHandler} selectionHandler
   */
  constructor(body, canvas, selectionHandler) {
    var _context, _context2, _context3, _context4, _context5, _context6, _context7, _context8, _context9, _context10, _context11, _context12, _context13;
    this.body = body;
    this.canvas = canvas;
    this.selectionHandler = selectionHandler;
    this.navigationHandler = new NavigationHandler(body, canvas);

    // bind the events from hammer to functions in this object
    this.body.eventListeners.onTap = _bindInstanceProperty(_context = this.onTap).call(_context, this);
    this.body.eventListeners.onTouch = _bindInstanceProperty(_context2 = this.onTouch).call(_context2, this);
    this.body.eventListeners.onDoubleTap = _bindInstanceProperty(_context3 = this.onDoubleTap).call(_context3, this);
    this.body.eventListeners.onHold = _bindInstanceProperty(_context4 = this.onHold).call(_context4, this);
    this.body.eventListeners.onDragStart = _bindInstanceProperty(_context5 = this.onDragStart).call(_context5, this);
    this.body.eventListeners.onDrag = _bindInstanceProperty(_context6 = this.onDrag).call(_context6, this);
    this.body.eventListeners.onDragEnd = _bindInstanceProperty(_context7 = this.onDragEnd).call(_context7, this);
    this.body.eventListeners.onMouseWheel = _bindInstanceProperty(_context8 = this.onMouseWheel).call(_context8, this);
    this.body.eventListeners.onPinch = _bindInstanceProperty(_context9 = this.onPinch).call(_context9, this);
    this.body.eventListeners.onMouseMove = _bindInstanceProperty(_context10 = this.onMouseMove).call(_context10, this);
    this.body.eventListeners.onRelease = _bindInstanceProperty(_context11 = this.onRelease).call(_context11, this);
    this.body.eventListeners.onContext = _bindInstanceProperty(_context12 = this.onContext).call(_context12, this);
    this.touchTime = 0;
    this.drag = {};
    this.pinch = {};
    this.popup = undefined;
    this.popupObj = undefined;
    this.popupTimer = undefined;
    this.body.functions.getPointer = _bindInstanceProperty(_context13 = this.getPointer).call(_context13, this);
    this.options = {};
    this.defaultOptions = {
      dragNodes: true,
      dragView: true,
      hover: false,
      keyboard: {
        enabled: false,
        speed: {
          x: 10,
          y: 10,
          zoom: 0.02
        },
        bindToWindow: true,
        autoFocus: true
      },
      navigationButtons: false,
      tooltipDelay: 300,
      zoomView: true,
      zoomSpeed: 1
    };
    _Object$assign(this.options, this.defaultOptions);
    this.bindEventListeners();
  }

  /**
   * Binds event listeners
   */
  bindEventListeners() {
    this.body.emitter.on("destroy", () => {
      clearTimeout(this.popupTimer);
      delete this.body.functions.getPointer;
    });
  }

  /**
   *
   * @param {object} options
   */
  setOptions(options) {
    if (options !== undefined) {
      // extend all but the values in fields
      const fields = ["hideEdgesOnDrag", "hideEdgesOnZoom", "hideNodesOnDrag", "keyboard", "multiselect", "selectable", "selectConnectedEdges"];
      selectiveNotDeepExtend(fields, this.options, options);

      // merge the keyboard options in.
      mergeOptions(this.options, options, "keyboard");
      if (options.tooltip) {
        _Object$assign(this.options.tooltip, options.tooltip);
        if (options.tooltip.color) {
          this.options.tooltip.color = parseColor(options.tooltip.color);
        }
      }
    }
    this.navigationHandler.setOptions(this.options);
  }

  /**
   * Get the pointer location from a touch location
   * @param {{x: number, y: number}} touch
   * @returns {{x: number, y: number}} pointer
   * @private
   */
  getPointer(touch) {
    return {
      x: touch.x - getAbsoluteLeft(this.canvas.frame.canvas),
      y: touch.y - getAbsoluteTop(this.canvas.frame.canvas)
    };
  }

  /**
   * On start of a touch gesture, store the pointer
   * @param {Event}  event   The event
   * @private
   */
  onTouch(event) {
    if (new Date().valueOf() - this.touchTime > 50) {
      this.drag.pointer = this.getPointer(event.center);
      this.drag.pinched = false;
      this.pinch.scale = this.body.view.scale;
      // to avoid double fireing of this event because we have two hammer instances. (on canvas and on frame)
      this.touchTime = new Date().valueOf();
    }
  }

  /**
   * handle tap/click event: select/unselect a node
   * @param {Event} event
   * @private
   */
  onTap(event) {
    const pointer = this.getPointer(event.center);
    const multiselect = this.selectionHandler.options.multiselect && (event.changedPointers[0].ctrlKey || event.changedPointers[0].metaKey);
    this.checkSelectionChanges(pointer, multiselect);
    this.selectionHandler.commitAndEmit(pointer, event);
    this.selectionHandler.generateClickEvent("click", event, pointer);
  }

  /**
   * handle doubletap event
   * @param {Event} event
   * @private
   */
  onDoubleTap(event) {
    const pointer = this.getPointer(event.center);
    this.selectionHandler.generateClickEvent("doubleClick", event, pointer);
  }

  /**
   * handle long tap event: multi select nodes
   * @param {Event} event
   * @private
   */
  onHold(event) {
    const pointer = this.getPointer(event.center);
    const multiselect = this.selectionHandler.options.multiselect;
    this.checkSelectionChanges(pointer, multiselect);
    this.selectionHandler.commitAndEmit(pointer, event);
    this.selectionHandler.generateClickEvent("click", event, pointer);
    this.selectionHandler.generateClickEvent("hold", event, pointer);
  }

  /**
   * handle the release of the screen
   * @param {Event} event
   * @private
   */
  onRelease(event) {
    if (new Date().valueOf() - this.touchTime > 10) {
      const pointer = this.getPointer(event.center);
      this.selectionHandler.generateClickEvent("release", event, pointer);
      // to avoid double fireing of this event because we have two hammer instances. (on canvas and on frame)
      this.touchTime = new Date().valueOf();
    }
  }

  /**
   *
   * @param {Event} event
   */
  onContext(event) {
    const pointer = this.getPointer({
      x: event.clientX,
      y: event.clientY
    });
    this.selectionHandler.generateClickEvent("oncontext", event, pointer);
  }

  /**
   * Select and deselect nodes depending current selection change.
   * @param {{x: number, y: number}} pointer
   * @param {boolean} [add]
   */
  checkSelectionChanges(pointer) {
    let add = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
    if (add === true) {
      this.selectionHandler.selectAdditionalOnPoint(pointer);
    } else {
      this.selectionHandler.selectOnPoint(pointer);
    }
  }

  /**
   * Remove all node and edge id's from the first set that are present in the second one.
   * @param {{nodes: Array.<Node>, edges: Array.<vis.Edge>}} firstSet
   * @param {{nodes: Array.<Node>, edges: Array.<vis.Edge>}} secondSet
   * @returns {{nodes: Array.<Node>, edges: Array.<vis.Edge>}}
   * @private
   */
  _determineDifference(firstSet, secondSet) {
    const arrayDiff = function (firstArr, secondArr) {
      const result = [];
      for (let i = 0; i < firstArr.length; i++) {
        const value = firstArr[i];
        if (_indexOfInstanceProperty(secondArr).call(secondArr, value) === -1) {
          result.push(value);
        }
      }
      return result;
    };
    return {
      nodes: arrayDiff(firstSet.nodes, secondSet.nodes),
      edges: arrayDiff(firstSet.edges, secondSet.edges)
    };
  }

  /**
   * This function is called by onDragStart.
   * It is separated out because we can then overload it for the datamanipulation system.
   * @param {Event} event
   * @private
   */
  onDragStart(event) {
    // if already dragging, do not start
    // this can happen on touch screens with multiple fingers
    if (this.drag.dragging) {
      return;
    }

    //in case the touch event was triggered on an external div, do the initial touch now.
    if (this.drag.pointer === undefined) {
      this.onTouch(event);
    }

    // note: drag.pointer is set in onTouch to get the initial touch location
    const node = this.selectionHandler.getNodeAt(this.drag.pointer);
    this.drag.dragging = true;
    this.drag.selection = [];
    this.drag.translation = _Object$assign({}, this.body.view.translation); // copy the object
    this.drag.nodeId = undefined;
    if (event.srcEvent.shiftKey) {
      this.body.selectionBox.show = true;
      const pointer = this.getPointer(event.center);
      this.body.selectionBox.position.start = {
        x: this.canvas._XconvertDOMtoCanvas(pointer.x),
        y: this.canvas._YconvertDOMtoCanvas(pointer.y)
      };
      this.body.selectionBox.position.end = {
        x: this.canvas._XconvertDOMtoCanvas(pointer.x),
        y: this.canvas._YconvertDOMtoCanvas(pointer.y)
      };
    } else if (node !== undefined && this.options.dragNodes === true) {
      this.drag.nodeId = node.id;
      // select the clicked node if not yet selected
      if (node.isSelected() === false) {
        this.selectionHandler.setSelection({
          nodes: [node.id]
        });
      }

      // after select to contain the node
      this.selectionHandler.generateClickEvent("dragStart", event, this.drag.pointer);

      // create an array with the selected nodes and their original location and status
      for (const node of this.selectionHandler.getSelectedNodes()) {
        const s = {
          id: node.id,
          node: node,
          // store original x, y, xFixed and yFixed, make the node temporarily Fixed
          x: node.x,
          y: node.y,
          xFixed: node.options.fixed.x,
          yFixed: node.options.fixed.y
        };
        node.options.fixed.x = true;
        node.options.fixed.y = true;
        this.drag.selection.push(s);
      }
    } else {
      // fallback if no node is selected and thus the view is dragged.
      this.selectionHandler.generateClickEvent("dragStart", event, this.drag.pointer, undefined, true);
    }
  }

  /**
   * handle drag event
   * @param {Event} event
   * @private
   */
  onDrag(event) {
    if (this.drag.pinched === true) {
      return;
    }

    // remove the focus on node if it is focussed on by the focusOnNode
    this.body.emitter.emit("unlockNode");
    const pointer = this.getPointer(event.center);
    const selection = this.drag.selection;
    if (selection && selection.length && this.options.dragNodes === true) {
      this.selectionHandler.generateClickEvent("dragging", event, pointer);

      // calculate delta's and new location
      const deltaX = pointer.x - this.drag.pointer.x;
      const deltaY = pointer.y - this.drag.pointer.y;

      // update position of all selected nodes
      _forEachInstanceProperty(selection).call(selection, selection => {
        const node = selection.node;
        // only move the node if it was not fixed initially
        if (selection.xFixed === false) {
          node.x = this.canvas._XconvertDOMtoCanvas(this.canvas._XconvertCanvasToDOM(selection.x) + deltaX);
        }
        // only move the node if it was not fixed initially
        if (selection.yFixed === false) {
          node.y = this.canvas._YconvertDOMtoCanvas(this.canvas._YconvertCanvasToDOM(selection.y) + deltaY);
        }
      });

      // start the simulation of the physics
      this.body.emitter.emit("startSimulation");
    } else {
      // create selection box
      if (event.srcEvent.shiftKey) {
        this.selectionHandler.generateClickEvent("dragging", event, pointer, undefined, true);

        // if the drag was not started properly because the click started outside the network div, start it now.
        if (this.drag.pointer === undefined) {
          this.onDragStart(event);
          return;
        }
        this.body.selectionBox.position.end = {
          x: this.canvas._XconvertDOMtoCanvas(pointer.x),
          y: this.canvas._YconvertDOMtoCanvas(pointer.y)
        };
        this.body.emitter.emit("_requestRedraw");
      }

      // move the network
      if (this.options.dragView === true && !event.srcEvent.shiftKey) {
        this.selectionHandler.generateClickEvent("dragging", event, pointer, undefined, true);

        // if the drag was not started properly because the click started outside the network div, start it now.
        if (this.drag.pointer === undefined) {
          this.onDragStart(event);
          return;
        }
        const diffX = pointer.x - this.drag.pointer.x;
        const diffY = pointer.y - this.drag.pointer.y;
        this.body.view.translation = {
          x: this.drag.translation.x + diffX,
          y: this.drag.translation.y + diffY
        };
        this.body.emitter.emit("_requestRedraw");
      }
    }
  }

  /**
   * handle drag start event
   * @param {Event} event
   * @private
   */
  onDragEnd(event) {
    this.drag.dragging = false;
    if (this.body.selectionBox.show) {
      var _context14;
      this.body.selectionBox.show = false;
      const selectionBoxPosition = this.body.selectionBox.position;
      const selectionBoxPositionMinMax = {
        minX: Math.min(selectionBoxPosition.start.x, selectionBoxPosition.end.x),
        minY: Math.min(selectionBoxPosition.start.y, selectionBoxPosition.end.y),
        maxX: Math.max(selectionBoxPosition.start.x, selectionBoxPosition.end.x),
        maxY: Math.max(selectionBoxPosition.start.y, selectionBoxPosition.end.y)
      };
      const toBeSelectedNodes = _filterInstanceProperty(_context14 = this.body.nodeIndices).call(_context14, nodeId => {
        const node = this.body.nodes[nodeId];
        return node.x >= selectionBoxPositionMinMax.minX && node.x <= selectionBoxPositionMinMax.maxX && node.y >= selectionBoxPositionMinMax.minY && node.y <= selectionBoxPositionMinMax.maxY;
      });
      _forEachInstanceProperty(toBeSelectedNodes).call(toBeSelectedNodes, nodeId => this.selectionHandler.selectObject(this.body.nodes[nodeId]));
      const pointer = this.getPointer(event.center);
      this.selectionHandler.commitAndEmit(pointer, event);
      this.selectionHandler.generateClickEvent("dragEnd", event, this.getPointer(event.center), undefined, true);
      this.body.emitter.emit("_requestRedraw");
    } else {
      const selection = this.drag.selection;
      if (selection && selection.length) {
        _forEachInstanceProperty(selection).call(selection, function (s) {
          // restore original xFixed and yFixed
          s.node.options.fixed.x = s.xFixed;
          s.node.options.fixed.y = s.yFixed;
        });
        this.selectionHandler.generateClickEvent("dragEnd", event, this.getPointer(event.center));
        this.body.emitter.emit("startSimulation");
      } else {
        this.selectionHandler.generateClickEvent("dragEnd", event, this.getPointer(event.center), undefined, true);
        this.body.emitter.emit("_requestRedraw");
      }
    }
  }

  /**
   * Handle pinch event
   * @param {Event}  event   The event
   * @private
   */
  onPinch(event) {
    const pointer = this.getPointer(event.center);
    this.drag.pinched = true;
    if (this.pinch["scale"] === undefined) {
      this.pinch.scale = 1;
    }

    // TODO: enabled moving while pinching?
    const scale = this.pinch.scale * event.scale;
    this.zoom(scale, pointer);
  }

  /**
   * Zoom the network in or out
   * @param {number} scale a number around 1, and between 0.01 and 10
   * @param {{x: number, y: number}} pointer    Position on screen
   * @private
   */
  zoom(scale, pointer) {
    if (this.options.zoomView === true) {
      const scaleOld = this.body.view.scale;
      if (scale < 0.00001) {
        scale = 0.00001;
      }
      if (scale > 10) {
        scale = 10;
      }
      let preScaleDragPointer = undefined;
      if (this.drag !== undefined) {
        if (this.drag.dragging === true) {
          preScaleDragPointer = this.canvas.DOMtoCanvas(this.drag.pointer);
        }
      }
      // + this.canvas.frame.canvas.clientHeight / 2
      const translation = this.body.view.translation;
      const scaleFrac = scale / scaleOld;
      const tx = (1 - scaleFrac) * pointer.x + translation.x * scaleFrac;
      const ty = (1 - scaleFrac) * pointer.y + translation.y * scaleFrac;
      this.body.view.scale = scale;
      this.body.view.translation = {
        x: tx,
        y: ty
      };
      if (preScaleDragPointer != undefined) {
        const postScaleDragPointer = this.canvas.canvasToDOM(preScaleDragPointer);
        this.drag.pointer.x = postScaleDragPointer.x;
        this.drag.pointer.y = postScaleDragPointer.y;
      }
      this.body.emitter.emit("_requestRedraw");
      if (scaleOld < scale) {
        this.body.emitter.emit("zoom", {
          direction: "+",
          scale: this.body.view.scale,
          pointer: pointer
        });
      } else {
        this.body.emitter.emit("zoom", {
          direction: "-",
          scale: this.body.view.scale,
          pointer: pointer
        });
      }
    }
  }

  /**
   * Event handler for mouse wheel event, used to zoom the timeline
   * See http://adomas.org/javascript-mouse-wheel/
   * https://github.com/EightMedia/hammer.js/issues/256
   * @param {MouseEvent}  event
   * @private
   */
  onMouseWheel(event) {
    if (this.options.zoomView === true) {
      // If delta is nonzero, handle it.
      // Basically, delta is now positive if wheel was scrolled up,
      // and negative, if wheel was scrolled down.
      if (event.deltaY !== 0) {
        // calculate the new scale
        let scale = this.body.view.scale;
        scale *= 1 + (event.deltaY < 0 ? 1 : -1) * (this.options.zoomSpeed * 0.1);

        // calculate the pointer location
        const pointer = this.getPointer({
          x: event.clientX,
          y: event.clientY
        });

        // apply the new scale
        this.zoom(scale, pointer);
      }

      // Prevent default actions caused by mouse wheel.
      event.preventDefault();
    }
  }

  /**
   * Mouse move handler for checking whether the title moves over a node with a title.
   * @param  {Event} event
   * @private
   */
  onMouseMove(event) {
    const pointer = this.getPointer({
      x: event.clientX,
      y: event.clientY
    });
    let popupVisible = false;

    // check if the previously selected node is still selected
    if (this.popup !== undefined) {
      if (this.popup.hidden === false) {
        this._checkHidePopup(pointer);
      }

      // if the popup was not hidden above
      if (this.popup.hidden === false) {
        popupVisible = true;
        this.popup.setPosition(pointer.x + 3, pointer.y - 5);
        this.popup.show();
      }
    }

    // if we bind the keyboard to the div, we have to highlight it to use it. This highlights it on mouse over.
    if (this.options.keyboard.autoFocus && this.options.keyboard.bindToWindow === false && this.options.keyboard.enabled === true) {
      this.canvas.frame.focus();
    }

    // start a timeout that will check if the mouse is positioned above an element
    if (popupVisible === false) {
      if (this.popupTimer !== undefined) {
        clearInterval(this.popupTimer); // stop any running calculationTimer
        this.popupTimer = undefined;
      }
      if (!this.drag.dragging) {
        this.popupTimer = _setTimeout(() => this._checkShowPopup(pointer), this.options.tooltipDelay);
      }
    }

    // adding hover highlights
    if (this.options.hover === true) {
      this.selectionHandler.hoverObject(event, pointer);
    }
  }

  /**
   * Check if there is an element on the given position in the network
   * (a node or edge). If so, and if this element has a title,
   * show a popup window with its title.
   * @param {{x:number, y:number}} pointer
   * @private
   */
  _checkShowPopup(pointer) {
    const x = this.canvas._XconvertDOMtoCanvas(pointer.x);
    const y = this.canvas._YconvertDOMtoCanvas(pointer.y);
    const pointerObj = {
      left: x,
      top: y,
      right: x,
      bottom: y
    };
    const previousPopupObjId = this.popupObj === undefined ? undefined : this.popupObj.id;
    let nodeUnderCursor = false;
    let popupType = "node";

    // check if a node is under the cursor.
    if (this.popupObj === undefined) {
      // search the nodes for overlap, select the top one in case of multiple nodes
      const nodeIndices = this.body.nodeIndices;
      const nodes = this.body.nodes;
      let node;
      const overlappingNodes = [];
      for (let i = 0; i < nodeIndices.length; i++) {
        node = nodes[nodeIndices[i]];
        if (node.isOverlappingWith(pointerObj) === true) {
          nodeUnderCursor = true;
          if (node.getTitle() !== undefined) {
            overlappingNodes.push(nodeIndices[i]);
          }
        }
      }
      if (overlappingNodes.length > 0) {
        // if there are overlapping nodes, select the last one, this is the one which is drawn on top of the others
        this.popupObj = nodes[overlappingNodes[overlappingNodes.length - 1]];
        // if you hover over a node, the title of the edge is not supposed to be shown.
        nodeUnderCursor = true;
      }
    }
    if (this.popupObj === undefined && nodeUnderCursor === false) {
      // search the edges for overlap
      const edgeIndices = this.body.edgeIndices;
      const edges = this.body.edges;
      let edge;
      const overlappingEdges = [];
      for (let i = 0; i < edgeIndices.length; i++) {
        edge = edges[edgeIndices[i]];
        if (edge.isOverlappingWith(pointerObj) === true) {
          if (edge.connected === true && edge.getTitle() !== undefined) {
            overlappingEdges.push(edgeIndices[i]);
          }
        }
      }
      if (overlappingEdges.length > 0) {
        this.popupObj = edges[overlappingEdges[overlappingEdges.length - 1]];
        popupType = "edge";
      }
    }
    if (this.popupObj !== undefined) {
      // show popup message window
      if (this.popupObj.id !== previousPopupObjId) {
        if (this.popup === undefined) {
          this.popup = new Popup(this.canvas.frame);
        }
        this.popup.popupTargetType = popupType;
        this.popup.popupTargetId = this.popupObj.id;

        // adjust a small offset such that the mouse cursor is located in the
        // bottom left location of the popup, and you can easily move over the
        // popup area
        this.popup.setPosition(pointer.x + 3, pointer.y - 5);
        this.popup.setText(this.popupObj.getTitle());
        this.popup.show();
        this.body.emitter.emit("showPopup", this.popupObj.id);
      }
    } else {
      if (this.popup !== undefined) {
        this.popup.hide();
        this.body.emitter.emit("hidePopup");
      }
    }
  }

  /**
   * Check if the popup must be hidden, which is the case when the mouse is no
   * longer hovering on the object
   * @param {{x:number, y:number}} pointer
   * @private
   */
  _checkHidePopup(pointer) {
    const pointerObj = this.selectionHandler._pointerToPositionObject(pointer);
    let stillOnObj = false;
    if (this.popup.popupTargetType === "node") {
      if (this.body.nodes[this.popup.popupTargetId] !== undefined) {
        stillOnObj = this.body.nodes[this.popup.popupTargetId].isOverlappingWith(pointerObj);

        // if the mouse is still one the node, we have to check if it is not also on one that is drawn on top of it.
        // we initially only check stillOnObj because this is much faster.
        if (stillOnObj === true) {
          const overNode = this.selectionHandler.getNodeAt(pointer);
          stillOnObj = overNode === undefined ? false : overNode.id === this.popup.popupTargetId;
        }
      }
    } else {
      if (this.selectionHandler.getNodeAt(pointer) === undefined) {
        if (this.body.edges[this.popup.popupTargetId] !== undefined) {
          stillOnObj = this.body.edges[this.popup.popupTargetId].isOverlappingWith(pointerObj);
        }
      }
    }
    if (stillOnObj === false) {
      this.popupObj = undefined;
      this.popup.hide();
      this.body.emitter.emit("hidePopup");
    }
  }
}

var collection$1 = collection$3;
var collectionStrong = collectionStrong$2;

// `Set` constructor
// https://tc39.es/ecma262/#sec-set-objects
collection$1('Set', function (init) {
  return function Set() { return init(this, arguments.length ? arguments[0] : undefined); };
}, collectionStrong);

var path$1 = path$s;

var set$2 = path$1.Set;

var parent$4 = set$2;


var set$1 = parent$4;

var set = set$1;

var _Set = /*@__PURE__*/getDefaultExportFromCjs(set);

var uncurryThis$2 = functionUncurryThis;
var defineBuiltIns$1 = defineBuiltIns$3;
var getWeakData = internalMetadataExports.getWeakData;
var anInstance = anInstance$3;
var anObject = anObject$9;
var isNullOrUndefined = isNullOrUndefined$6;
var isObject$1 = isObject$h;
var iterate = iterate$3;
var ArrayIterationModule = arrayIteration;
var hasOwn = hasOwnProperty_1;
var InternalStateModule = internalState;

var setInternalState = InternalStateModule.set;
var internalStateGetterFor = InternalStateModule.getterFor;
var find = ArrayIterationModule.find;
var findIndex = ArrayIterationModule.findIndex;
var splice = uncurryThis$2([].splice);
var id = 0;

// fallback for uncaught frozen keys
var uncaughtFrozenStore = function (state) {
  return state.frozen || (state.frozen = new UncaughtFrozenStore());
};

var UncaughtFrozenStore = function () {
  this.entries = [];
};

var findUncaughtFrozen = function (store, key) {
  return find(store.entries, function (it) {
    return it[0] === key;
  });
};

UncaughtFrozenStore.prototype = {
  get: function (key) {
    var entry = findUncaughtFrozen(this, key);
    if (entry) return entry[1];
  },
  has: function (key) {
    return !!findUncaughtFrozen(this, key);
  },
  set: function (key, value) {
    var entry = findUncaughtFrozen(this, key);
    if (entry) entry[1] = value;
    else this.entries.push([key, value]);
  },
  'delete': function (key) {
    var index = findIndex(this.entries, function (it) {
      return it[0] === key;
    });
    if (~index) splice(this.entries, index, 1);
    return !!~index;
  }
};

var collectionWeak$1 = {
  getConstructor: function (wrapper, CONSTRUCTOR_NAME, IS_MAP, ADDER) {
    var Constructor = wrapper(function (that, iterable) {
      anInstance(that, Prototype);
      setInternalState(that, {
        type: CONSTRUCTOR_NAME,
        id: id++,
        frozen: undefined
      });
      if (!isNullOrUndefined(iterable)) iterate(iterable, that[ADDER], { that: that, AS_ENTRIES: IS_MAP });
    });

    var Prototype = Constructor.prototype;

    var getInternalState = internalStateGetterFor(CONSTRUCTOR_NAME);

    var define = function (that, key, value) {
      var state = getInternalState(that);
      var data = getWeakData(anObject(key), true);
      if (data === true) uncaughtFrozenStore(state).set(key, value);
      else data[state.id] = value;
      return that;
    };

    defineBuiltIns$1(Prototype, {
      // `{ WeakMap, WeakSet }.prototype.delete(key)` methods
      // https://tc39.es/ecma262/#sec-weakmap.prototype.delete
      // https://tc39.es/ecma262/#sec-weakset.prototype.delete
      'delete': function (key) {
        var state = getInternalState(this);
        if (!isObject$1(key)) return false;
        var data = getWeakData(key);
        if (data === true) return uncaughtFrozenStore(state)['delete'](key);
        return data && hasOwn(data, state.id) && delete data[state.id];
      },
      // `{ WeakMap, WeakSet }.prototype.has(key)` methods
      // https://tc39.es/ecma262/#sec-weakmap.prototype.has
      // https://tc39.es/ecma262/#sec-weakset.prototype.has
      has: function has(key) {
        var state = getInternalState(this);
        if (!isObject$1(key)) return false;
        var data = getWeakData(key);
        if (data === true) return uncaughtFrozenStore(state).has(key);
        return data && hasOwn(data, state.id);
      }
    });

    defineBuiltIns$1(Prototype, IS_MAP ? {
      // `WeakMap.prototype.get(key)` method
      // https://tc39.es/ecma262/#sec-weakmap.prototype.get
      get: function get(key) {
        var state = getInternalState(this);
        if (isObject$1(key)) {
          var data = getWeakData(key);
          if (data === true) return uncaughtFrozenStore(state).get(key);
          return data ? data[state.id] : undefined;
        }
      },
      // `WeakMap.prototype.set(key, value)` method
      // https://tc39.es/ecma262/#sec-weakmap.prototype.set
      set: function set(key, value) {
        return define(this, key, value);
      }
    } : {
      // `WeakSet.prototype.add(value)` method
      // https://tc39.es/ecma262/#sec-weakset.prototype.add
      add: function add(value) {
        return define(this, value, true);
      }
    });

    return Constructor;
  }
};

var FREEZING = freezing;
var global$2 = global$n;
var uncurryThis$1 = functionUncurryThis;
var defineBuiltIns = defineBuiltIns$3;
var InternalMetadataModule = internalMetadataExports;
var collection = collection$3;
var collectionWeak = collectionWeak$1;
var isObject = isObject$h;
var enforceInternalState = internalState.enforce;
var fails$1 = fails$u;
var NATIVE_WEAK_MAP = weakMapBasicDetection;

var $Object = Object;
// eslint-disable-next-line es/no-array-isarray -- safe
var isArray = Array.isArray;
// eslint-disable-next-line es/no-object-isextensible -- safe
var isExtensible = $Object.isExtensible;
// eslint-disable-next-line es/no-object-isfrozen -- safe
var isFrozen = $Object.isFrozen;
// eslint-disable-next-line es/no-object-issealed -- safe
var isSealed = $Object.isSealed;
// eslint-disable-next-line es/no-object-freeze -- safe
var freeze = $Object.freeze;
// eslint-disable-next-line es/no-object-seal -- safe
var seal = $Object.seal;

var FROZEN = {};
var SEALED = {};
var IS_IE11 = !global$2.ActiveXObject && 'ActiveXObject' in global$2;
var InternalWeakMap;

var wrapper = function (init) {
  return function WeakMap() {
    return init(this, arguments.length ? arguments[0] : undefined);
  };
};

// `WeakMap` constructor
// https://tc39.es/ecma262/#sec-weakmap-constructor
var $WeakMap = collection('WeakMap', wrapper, collectionWeak);
var WeakMapPrototype = $WeakMap.prototype;
var nativeSet = uncurryThis$1(WeakMapPrototype.set);

// Chakra Edge bug: adding frozen arrays to WeakMap unfreeze them
var hasMSEdgeFreezingBug = function () {
  return FREEZING && fails$1(function () {
    var frozenArray = freeze([]);
    nativeSet(new $WeakMap(), frozenArray, 1);
    return !isFrozen(frozenArray);
  });
};

// IE11 WeakMap frozen keys fix
// We can't use feature detection because it crash some old IE builds
// https://github.com/zloirock/core-js/issues/485
if (NATIVE_WEAK_MAP) if (IS_IE11) {
  InternalWeakMap = collectionWeak.getConstructor(wrapper, 'WeakMap', true);
  InternalMetadataModule.enable();
  var nativeDelete = uncurryThis$1(WeakMapPrototype['delete']);
  var nativeHas = uncurryThis$1(WeakMapPrototype.has);
  var nativeGet = uncurryThis$1(WeakMapPrototype.get);
  defineBuiltIns(WeakMapPrototype, {
    'delete': function (key) {
      if (isObject(key) && !isExtensible(key)) {
        var state = enforceInternalState(this);
        if (!state.frozen) state.frozen = new InternalWeakMap();
        return nativeDelete(this, key) || state.frozen['delete'](key);
      } return nativeDelete(this, key);
    },
    has: function has(key) {
      if (isObject(key) && !isExtensible(key)) {
        var state = enforceInternalState(this);
        if (!state.frozen) state.frozen = new InternalWeakMap();
        return nativeHas(this, key) || state.frozen.has(key);
      } return nativeHas(this, key);
    },
    get: function get(key) {
      if (isObject(key) && !isExtensible(key)) {
        var state = enforceInternalState(this);
        if (!state.frozen) state.frozen = new InternalWeakMap();
        return nativeHas(this, key) ? nativeGet(this, key) : state.frozen.get(key);
      } return nativeGet(this, key);
    },
    set: function set(key, value) {
      if (isObject(key) && !isExtensible(key)) {
        var state = enforceInternalState(this);
        if (!state.frozen) state.frozen = new InternalWeakMap();
        nativeHas(this, key) ? nativeSet(this, key, value) : state.frozen.set(key, value);
      } else nativeSet(this, key, value);
      return this;
    }
  });
// Chakra Edge frozen keys fix
} else if (hasMSEdgeFreezingBug()) {
  defineBuiltIns(WeakMapPrototype, {
    set: function set(key, value) {
      var arrayIntegrityLevel;
      if (isArray(key)) {
        if (isFrozen(key)) arrayIntegrityLevel = FROZEN;
        else if (isSealed(key)) arrayIntegrityLevel = SEALED;
      }
      nativeSet(this, key, value);
      if (arrayIntegrityLevel === FROZEN) freeze(key);
      if (arrayIntegrityLevel === SEALED) seal(key);
      return this;
    }
  });
}

var path = path$s;

var weakMap$2 = path.WeakMap;

var parent$3 = weakMap$2;


var weakMap$1 = parent$3;

var weakMap = weakMap$1;

var _WeakMap = /*@__PURE__*/getDefaultExportFromCjs(weakMap);

/******************************************************************************
Copyright (c) Microsoft Corporation.

Permission to use, copy, modify, and/or distribute this software for any
purpose with or without fee is hereby granted.

THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
PERFORMANCE OF THIS SOFTWARE.
***************************************************************************** */
/* global Reflect, Promise, SuppressedError, Symbol */


function __classPrivateFieldGet(receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
}

function __classPrivateFieldSet(receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
}

typeof SuppressedError === "function" ? SuppressedError : function (error, suppressed, message) {
    var e = new Error(message);
    return e.name = "SuppressedError", e.error = error, e.suppressed = suppressed, e;
};

var _SingleTypeSelectionAccumulator_previousSelection, _SingleTypeSelectionAccumulator_selection, _SelectionAccumulator_nodes, _SelectionAccumulator_edges, _SelectionAccumulator_commitHandler;
/**
 * @param prev
 * @param next
 */
function diffSets(prev, next) {
  const diff = new _Set();
  for (const item of next) {
    if (!prev.has(item)) {
      diff.add(item);
    }
  }
  return diff;
}
class SingleTypeSelectionAccumulator {
  constructor() {
    _SingleTypeSelectionAccumulator_previousSelection.set(this, new _Set());
    _SingleTypeSelectionAccumulator_selection.set(this, new _Set());
  }
  get size() {
    return __classPrivateFieldGet(this, _SingleTypeSelectionAccumulator_selection, "f").size;
  }
  add() {
    for (var _len = arguments.length, items = new Array(_len), _key = 0; _key < _len; _key++) {
      items[_key] = arguments[_key];
    }
    for (const item of items) {
      __classPrivateFieldGet(this, _SingleTypeSelectionAccumulator_selection, "f").add(item);
    }
  }
  delete() {
    for (var _len2 = arguments.length, items = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
      items[_key2] = arguments[_key2];
    }
    for (const item of items) {
      __classPrivateFieldGet(this, _SingleTypeSelectionAccumulator_selection, "f").delete(item);
    }
  }
  clear() {
    __classPrivateFieldGet(this, _SingleTypeSelectionAccumulator_selection, "f").clear();
  }
  getSelection() {
    return [...__classPrivateFieldGet(this, _SingleTypeSelectionAccumulator_selection, "f")];
  }
  getChanges() {
    return {
      added: [...diffSets(__classPrivateFieldGet(this, _SingleTypeSelectionAccumulator_previousSelection, "f"), __classPrivateFieldGet(this, _SingleTypeSelectionAccumulator_selection, "f"))],
      deleted: [...diffSets(__classPrivateFieldGet(this, _SingleTypeSelectionAccumulator_selection, "f"), __classPrivateFieldGet(this, _SingleTypeSelectionAccumulator_previousSelection, "f"))],
      previous: [...new _Set(__classPrivateFieldGet(this, _SingleTypeSelectionAccumulator_previousSelection, "f"))],
      current: [...new _Set(__classPrivateFieldGet(this, _SingleTypeSelectionAccumulator_selection, "f"))]
    };
  }
  commit() {
    const changes = this.getChanges();
    __classPrivateFieldSet(this, _SingleTypeSelectionAccumulator_previousSelection, __classPrivateFieldGet(this, _SingleTypeSelectionAccumulator_selection, "f"), "f");
    __classPrivateFieldSet(this, _SingleTypeSelectionAccumulator_selection, new _Set(__classPrivateFieldGet(this, _SingleTypeSelectionAccumulator_previousSelection, "f")), "f");
    for (const item of changes.added) {
      item.select();
    }
    for (const item of changes.deleted) {
      item.unselect();
    }
    return changes;
  }
}
_SingleTypeSelectionAccumulator_previousSelection = new _WeakMap(), _SingleTypeSelectionAccumulator_selection = new _WeakMap();
class SelectionAccumulator {
  constructor() {
    let commitHandler = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : () => {};
    _SelectionAccumulator_nodes.set(this, new SingleTypeSelectionAccumulator());
    _SelectionAccumulator_edges.set(this, new SingleTypeSelectionAccumulator());
    _SelectionAccumulator_commitHandler.set(this, void 0);
    __classPrivateFieldSet(this, _SelectionAccumulator_commitHandler, commitHandler, "f");
  }
  get sizeNodes() {
    return __classPrivateFieldGet(this, _SelectionAccumulator_nodes, "f").size;
  }
  get sizeEdges() {
    return __classPrivateFieldGet(this, _SelectionAccumulator_edges, "f").size;
  }
  getNodes() {
    return __classPrivateFieldGet(this, _SelectionAccumulator_nodes, "f").getSelection();
  }
  getEdges() {
    return __classPrivateFieldGet(this, _SelectionAccumulator_edges, "f").getSelection();
  }
  addNodes() {
    __classPrivateFieldGet(this, _SelectionAccumulator_nodes, "f").add(...arguments);
  }
  addEdges() {
    __classPrivateFieldGet(this, _SelectionAccumulator_edges, "f").add(...arguments);
  }
  deleteNodes(node) {
    __classPrivateFieldGet(this, _SelectionAccumulator_nodes, "f").delete(node);
  }
  deleteEdges(edge) {
    __classPrivateFieldGet(this, _SelectionAccumulator_edges, "f").delete(edge);
  }
  clear() {
    __classPrivateFieldGet(this, _SelectionAccumulator_nodes, "f").clear();
    __classPrivateFieldGet(this, _SelectionAccumulator_edges, "f").clear();
  }
  commit() {
    const summary = {
      nodes: __classPrivateFieldGet(this, _SelectionAccumulator_nodes, "f").commit(),
      edges: __classPrivateFieldGet(this, _SelectionAccumulator_edges, "f").commit()
    };
    for (var _len3 = arguments.length, rest = new Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
      rest[_key3] = arguments[_key3];
    }
    __classPrivateFieldGet(this, _SelectionAccumulator_commitHandler, "f").call(this, summary, ...rest);
    return summary;
  }
}
_SelectionAccumulator_nodes = new _WeakMap(), _SelectionAccumulator_edges = new _WeakMap(), _SelectionAccumulator_commitHandler = new _WeakMap();

/**
 * The handler for selections
 */
class SelectionHandler {
  /**
   * @param {object} body
   * @param {Canvas} canvas
   */
  constructor(body, canvas) {
    this.body = body;
    this.canvas = canvas;
    // TODO: Consider firing an event on any change to the selection, not
    // only those caused by clicks and taps. It would be easy to implement
    // now and (at least to me) it seems like something that could be
    // quite useful.
    this._selectionAccumulator = new SelectionAccumulator();
    this.hoverObj = {
      nodes: {},
      edges: {}
    };
    this.options = {};
    this.defaultOptions = {
      multiselect: false,
      selectable: true,
      selectConnectedEdges: true,
      hoverConnectedEdges: true
    };
    _Object$assign(this.options, this.defaultOptions);
    this.body.emitter.on("_dataChanged", () => {
      this.updateSelection();
    });
  }

  /**
   *
   * @param {object} [options]
   */
  setOptions(options) {
    if (options !== undefined) {
      const fields = ["multiselect", "hoverConnectedEdges", "selectable", "selectConnectedEdges"];
      selectiveDeepExtend(fields, this.options, options);
    }
  }

  /**
   * handles the selection part of the tap;
   * @param {{x: number, y: number}} pointer
   * @returns {boolean}
   */
  selectOnPoint(pointer) {
    let selected = false;
    if (this.options.selectable === true) {
      const obj = this.getNodeAt(pointer) || this.getEdgeAt(pointer);

      // unselect after getting the objects in order to restore width and height.
      this.unselectAll();
      if (obj !== undefined) {
        selected = this.selectObject(obj);
      }
      this.body.emitter.emit("_requestRedraw");
    }
    return selected;
  }

  /**
   *
   * @param {{x: number, y: number}} pointer
   * @returns {boolean}
   */
  selectAdditionalOnPoint(pointer) {
    let selectionChanged = false;
    if (this.options.selectable === true) {
      const obj = this.getNodeAt(pointer) || this.getEdgeAt(pointer);
      if (obj !== undefined) {
        selectionChanged = true;
        if (obj.isSelected() === true) {
          this.deselectObject(obj);
        } else {
          this.selectObject(obj);
        }
        this.body.emitter.emit("_requestRedraw");
      }
    }
    return selectionChanged;
  }

  /**
   * Create an object containing the standard fields for an event.
   * @param {Event} event
   * @param {{x: number, y: number}} pointer Object with the x and y screen coordinates of the mouse
   * @returns {{}}
   * @private
   */
  _initBaseEvent(event, pointer) {
    const properties = {};
    properties["pointer"] = {
      DOM: {
        x: pointer.x,
        y: pointer.y
      },
      canvas: this.canvas.DOMtoCanvas(pointer)
    };
    properties["event"] = event;
    return properties;
  }

  /**
   * Generate an event which the user can catch.
   *
   * This adds some extra data to the event with respect to cursor position and
   * selected nodes and edges.
   * @param {string} eventType                          Name of event to send
   * @param {Event}  event
   * @param {{x: number, y: number}} pointer            Object with the x and y screen coordinates of the mouse
   * @param {object | undefined} oldSelection             If present, selection state before event occured
   * @param {boolean|undefined} [emptySelection]  Indicate if selection data should be passed
   */
  generateClickEvent(eventType, event, pointer, oldSelection) {
    let emptySelection = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : false;
    const properties = this._initBaseEvent(event, pointer);
    if (emptySelection === true) {
      properties.nodes = [];
      properties.edges = [];
    } else {
      const tmp = this.getSelection();
      properties.nodes = tmp.nodes;
      properties.edges = tmp.edges;
    }
    if (oldSelection !== undefined) {
      properties["previousSelection"] = oldSelection;
    }
    if (eventType == "click") {
      // For the time being, restrict this functionality to
      // just the click event.
      properties.items = this.getClickedItems(pointer);
    }
    if (event.controlEdge !== undefined) {
      properties.controlEdge = event.controlEdge;
    }
    this.body.emitter.emit(eventType, properties);
  }

  /**
   *
   * @param {object} obj
   * @param {boolean} [highlightEdges]
   * @returns {boolean}
   */
  selectObject(obj) {
    let highlightEdges = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.options.selectConnectedEdges;
    if (obj !== undefined) {
      if (obj instanceof Node) {
        if (highlightEdges === true) {
          this._selectionAccumulator.addEdges(...obj.edges);
        }
        this._selectionAccumulator.addNodes(obj);
      } else {
        this._selectionAccumulator.addEdges(obj);
      }
      return true;
    }
    return false;
  }

  /**
   *
   * @param {object} obj
   */
  deselectObject(obj) {
    if (obj.isSelected() === true) {
      obj.selected = false;
      this._removeFromSelection(obj);
    }
  }

  /**
   * retrieve all nodes overlapping with given object
   * @param {object} object  An object with parameters left, top, right, bottom
   * @returns {number[]}   An array with id's of the overlapping nodes
   * @private
   */
  _getAllNodesOverlappingWith(object) {
    const overlappingNodes = [];
    const nodes = this.body.nodes;
    for (let i = 0; i < this.body.nodeIndices.length; i++) {
      const nodeId = this.body.nodeIndices[i];
      if (nodes[nodeId].isOverlappingWith(object)) {
        overlappingNodes.push(nodeId);
      }
    }
    return overlappingNodes;
  }

  /**
   * Return a position object in canvasspace from a single point in screenspace
   * @param {{x: number, y: number}} pointer
   * @returns {{left: number, top: number, right: number, bottom: number}}
   * @private
   */
  _pointerToPositionObject(pointer) {
    const canvasPos = this.canvas.DOMtoCanvas(pointer);
    return {
      left: canvasPos.x - 1,
      top: canvasPos.y + 1,
      right: canvasPos.x + 1,
      bottom: canvasPos.y - 1
    };
  }

  /**
   * Get the top node at the passed point (like a click)
   * @param {{x: number, y: number}} pointer
   * @param {boolean} [returnNode]
   * @returns {Node | undefined} node
   */
  getNodeAt(pointer) {
    let returnNode = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
    // we first check if this is an navigation controls element
    const positionObject = this._pointerToPositionObject(pointer);
    const overlappingNodes = this._getAllNodesOverlappingWith(positionObject);
    // if there are overlapping nodes, select the last one, this is the
    // one which is drawn on top of the others
    if (overlappingNodes.length > 0) {
      if (returnNode === true) {
        return this.body.nodes[overlappingNodes[overlappingNodes.length - 1]];
      } else {
        return overlappingNodes[overlappingNodes.length - 1];
      }
    } else {
      return undefined;
    }
  }

  /**
   * retrieve all edges overlapping with given object, selector is around center
   * @param {object} object  An object with parameters left, top, right, bottom
   * @param {number[]} overlappingEdges An array with id's of the overlapping nodes
   * @private
   */
  _getEdgesOverlappingWith(object, overlappingEdges) {
    const edges = this.body.edges;
    for (let i = 0; i < this.body.edgeIndices.length; i++) {
      const edgeId = this.body.edgeIndices[i];
      if (edges[edgeId].isOverlappingWith(object)) {
        overlappingEdges.push(edgeId);
      }
    }
  }

  /**
   * retrieve all nodes overlapping with given object
   * @param {object} object  An object with parameters left, top, right, bottom
   * @returns {number[]}   An array with id's of the overlapping nodes
   * @private
   */
  _getAllEdgesOverlappingWith(object) {
    const overlappingEdges = [];
    this._getEdgesOverlappingWith(object, overlappingEdges);
    return overlappingEdges;
  }

  /**
   * Get the edges nearest to the passed point (like a click)
   * @param {{x: number, y: number}} pointer
   * @param {boolean} [returnEdge]
   * @returns {Edge | undefined} node
   */
  getEdgeAt(pointer) {
    let returnEdge = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
    // Iterate over edges, pick closest within 10
    const canvasPos = this.canvas.DOMtoCanvas(pointer);
    let mindist = 10;
    let overlappingEdge = null;
    const edges = this.body.edges;
    for (let i = 0; i < this.body.edgeIndices.length; i++) {
      const edgeId = this.body.edgeIndices[i];
      const edge = edges[edgeId];
      if (edge.connected) {
        const xFrom = edge.from.x;
        const yFrom = edge.from.y;
        const xTo = edge.to.x;
        const yTo = edge.to.y;
        const dist = edge.edgeType.getDistanceToEdge(xFrom, yFrom, xTo, yTo, canvasPos.x, canvasPos.y);
        if (dist < mindist) {
          overlappingEdge = edgeId;
          mindist = dist;
        }
      }
    }
    if (overlappingEdge !== null) {
      if (returnEdge === true) {
        return this.body.edges[overlappingEdge];
      } else {
        return overlappingEdge;
      }
    } else {
      return undefined;
    }
  }

  /**
   * Add object to the selection array.
   * @param {object} obj
   * @private
   */
  _addToHover(obj) {
    if (obj instanceof Node) {
      this.hoverObj.nodes[obj.id] = obj;
    } else {
      this.hoverObj.edges[obj.id] = obj;
    }
  }

  /**
   * Remove a single option from selection.
   * @param {object} obj
   * @private
   */
  _removeFromSelection(obj) {
    if (obj instanceof Node) {
      this._selectionAccumulator.deleteNodes(obj);
      this._selectionAccumulator.deleteEdges(...obj.edges);
    } else {
      this._selectionAccumulator.deleteEdges(obj);
    }
  }

  /**
   * Unselect all nodes and edges.
   */
  unselectAll() {
    this._selectionAccumulator.clear();
  }

  /**
   * return the number of selected nodes
   * @returns {number}
   */
  getSelectedNodeCount() {
    return this._selectionAccumulator.sizeNodes;
  }

  /**
   * return the number of selected edges
   * @returns {number}
   */
  getSelectedEdgeCount() {
    return this._selectionAccumulator.sizeEdges;
  }

  /**
   * select the edges connected to the node that is being selected
   * @param {Node} node
   * @private
   */
  _hoverConnectedEdges(node) {
    for (let i = 0; i < node.edges.length; i++) {
      const edge = node.edges[i];
      edge.hover = true;
      this._addToHover(edge);
    }
  }

  /**
   * Remove the highlight from a node or edge, in response to mouse movement
   * @param {Event}  event
   * @param {{x: number, y: number}} pointer object with the x and y screen coordinates of the mouse
   * @param {Node|vis.Edge} object
   * @private
   */
  emitBlurEvent(event, pointer, object) {
    const properties = this._initBaseEvent(event, pointer);
    if (object.hover === true) {
      object.hover = false;
      if (object instanceof Node) {
        properties.node = object.id;
        this.body.emitter.emit("blurNode", properties);
      } else {
        properties.edge = object.id;
        this.body.emitter.emit("blurEdge", properties);
      }
    }
  }

  /**
   * Create the highlight for a node or edge, in response to mouse movement
   * @param {Event}  event
   * @param {{x: number, y: number}} pointer object with the x and y screen coordinates of the mouse
   * @param {Node|vis.Edge} object
   * @returns {boolean} hoverChanged
   * @private
   */
  emitHoverEvent(event, pointer, object) {
    const properties = this._initBaseEvent(event, pointer);
    let hoverChanged = false;
    if (object.hover === false) {
      object.hover = true;
      this._addToHover(object);
      hoverChanged = true;
      if (object instanceof Node) {
        properties.node = object.id;
        this.body.emitter.emit("hoverNode", properties);
      } else {
        properties.edge = object.id;
        this.body.emitter.emit("hoverEdge", properties);
      }
    }
    return hoverChanged;
  }

  /**
   * Perform actions in response to a mouse movement.
   * @param {Event}  event
   * @param {{x: number, y: number}} pointer | object with the x and y screen coordinates of the mouse
   */
  hoverObject(event, pointer) {
    let object = this.getNodeAt(pointer);
    if (object === undefined) {
      object = this.getEdgeAt(pointer);
    }
    let hoverChanged = false;
    // remove all node hover highlights
    for (const nodeId in this.hoverObj.nodes) {
      if (Object.prototype.hasOwnProperty.call(this.hoverObj.nodes, nodeId)) {
        if (object === undefined || object instanceof Node && object.id != nodeId || object instanceof Edge) {
          this.emitBlurEvent(event, pointer, this.hoverObj.nodes[nodeId]);
          delete this.hoverObj.nodes[nodeId];
          hoverChanged = true;
        }
      }
    }

    // removing all edge hover highlights
    for (const edgeId in this.hoverObj.edges) {
      if (Object.prototype.hasOwnProperty.call(this.hoverObj.edges, edgeId)) {
        // if the hover has been changed here it means that the node has been hovered over or off
        // we then do not use the emitBlurEvent method here.
        if (hoverChanged === true) {
          this.hoverObj.edges[edgeId].hover = false;
          delete this.hoverObj.edges[edgeId];
        }
        // if the blur remains the same and the object is undefined (mouse off) or another
        // edge has been hovered, or another node has been hovered we blur the edge.
        else if (object === undefined || object instanceof Edge && object.id != edgeId || object instanceof Node && !object.hover) {
          this.emitBlurEvent(event, pointer, this.hoverObj.edges[edgeId]);
          delete this.hoverObj.edges[edgeId];
          hoverChanged = true;
        }
      }
    }
    if (object !== undefined) {
      const hoveredEdgesCount = _Object$keys(this.hoverObj.edges).length;
      const hoveredNodesCount = _Object$keys(this.hoverObj.nodes).length;
      const newOnlyHoveredEdge = object instanceof Edge && hoveredEdgesCount === 0 && hoveredNodesCount === 0;
      const newOnlyHoveredNode = object instanceof Node && hoveredEdgesCount === 0 && hoveredNodesCount === 0;
      if (hoverChanged || newOnlyHoveredEdge || newOnlyHoveredNode) {
        hoverChanged = this.emitHoverEvent(event, pointer, object);
      }
      if (object instanceof Node && this.options.hoverConnectedEdges === true) {
        this._hoverConnectedEdges(object);
      }
    }
    if (hoverChanged === true) {
      this.body.emitter.emit("_requestRedraw");
    }
  }

  /**
   * Commit the selection changes but don't emit any events.
   */
  commitWithoutEmitting() {
    this._selectionAccumulator.commit();
  }

  /**
   * Select and deselect nodes depending current selection change.
   *
   * For changing nodes, select/deselect events are fired.
   *
   * NOTE: For a given edge, if one connecting node is deselected and with the
   * same click the other node is selected, no events for the edge will fire. It
   * was selected and it will remain selected.
   * @param {{x: number, y: number}} pointer - The x and y coordinates of the
   * click, tap, dragend… that triggered this.
   * @param {UIEvent} event - The event that triggered this.
   */
  commitAndEmit(pointer, event) {
    let selected = false;
    const selectionChanges = this._selectionAccumulator.commit();
    const previousSelection = {
      nodes: selectionChanges.nodes.previous,
      edges: selectionChanges.edges.previous
    };
    if (selectionChanges.edges.deleted.length > 0) {
      this.generateClickEvent("deselectEdge", event, pointer, previousSelection);
      selected = true;
    }
    if (selectionChanges.nodes.deleted.length > 0) {
      this.generateClickEvent("deselectNode", event, pointer, previousSelection);
      selected = true;
    }
    if (selectionChanges.nodes.added.length > 0) {
      this.generateClickEvent("selectNode", event, pointer);
      selected = true;
    }
    if (selectionChanges.edges.added.length > 0) {
      this.generateClickEvent("selectEdge", event, pointer);
      selected = true;
    }

    // fire the select event if anything has been selected or deselected
    if (selected === true) {
      // select or unselect
      this.generateClickEvent("select", event, pointer);
    }
  }

  /**
   * Retrieve the currently selected node and edge ids.
   * @returns {{nodes: Array.<string>, edges: Array.<string>}} Arrays with the
   * ids of the selected nodes and edges.
   */
  getSelection() {
    return {
      nodes: this.getSelectedNodeIds(),
      edges: this.getSelectedEdgeIds()
    };
  }

  /**
   * Retrieve the currently selected nodes.
   * @returns {Array} An array with selected nodes.
   */
  getSelectedNodes() {
    return this._selectionAccumulator.getNodes();
  }

  /**
   * Retrieve the currently selected edges.
   * @returns {Array} An array with selected edges.
   */
  getSelectedEdges() {
    return this._selectionAccumulator.getEdges();
  }

  /**
   * Retrieve the currently selected node ids.
   * @returns {Array} An array with the ids of the selected nodes.
   */
  getSelectedNodeIds() {
    var _context;
    return _mapInstanceProperty(_context = this._selectionAccumulator.getNodes()).call(_context, node => node.id);
  }

  /**
   * Retrieve the currently selected edge ids.
   * @returns {Array} An array with the ids of the selected edges.
   */
  getSelectedEdgeIds() {
    var _context2;
    return _mapInstanceProperty(_context2 = this._selectionAccumulator.getEdges()).call(_context2, edge => edge.id);
  }

  /**
   * Updates the current selection
   * @param {{nodes: Array.<string>, edges: Array.<string>}} selection
   * @param {object} options                                 Options
   */
  setSelection(selection) {
    let options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    if (!selection || !selection.nodes && !selection.edges) {
      throw new TypeError("Selection must be an object with nodes and/or edges properties");
    }

    // first unselect any selected node, if option is true or undefined
    if (options.unselectAll || options.unselectAll === undefined) {
      this.unselectAll();
    }
    if (selection.nodes) {
      for (const id of selection.nodes) {
        const node = this.body.nodes[id];
        if (!node) {
          throw new RangeError('Node with id "' + id + '" not found');
        }
        // don't select edges with it
        this.selectObject(node, options.highlightEdges);
      }
    }
    if (selection.edges) {
      for (const id of selection.edges) {
        const edge = this.body.edges[id];
        if (!edge) {
          throw new RangeError('Edge with id "' + id + '" not found');
        }
        this.selectObject(edge);
      }
    }
    this.body.emitter.emit("_requestRedraw");
    this._selectionAccumulator.commit();
  }

  /**
   * select zero or more nodes with the option to highlight edges
   * @param {number[] | string[]} selection     An array with the ids of the
   *                                            selected nodes.
   * @param {boolean} [highlightEdges]
   */
  selectNodes(selection) {
    let highlightEdges = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
    if (!selection || selection.length === undefined) throw "Selection must be an array with ids";
    this.setSelection({
      nodes: selection
    }, {
      highlightEdges: highlightEdges
    });
  }

  /**
   * select zero or more edges
   * @param {number[] | string[]} selection     An array with the ids of the
   *                                            selected nodes.
   */
  selectEdges(selection) {
    if (!selection || selection.length === undefined) throw "Selection must be an array with ids";
    this.setSelection({
      edges: selection
    });
  }

  /**
   * Validate the selection: remove ids of nodes which no longer exist
   * @private
   */
  updateSelection() {
    for (const node in this._selectionAccumulator.getNodes()) {
      if (!Object.prototype.hasOwnProperty.call(this.body.nodes, node.id)) {
        this._selectionAccumulator.deleteNodes(node);
      }
    }
    for (const edge in this._selectionAccumulator.getEdges()) {
      if (!Object.prototype.hasOwnProperty.call(this.body.edges, edge.id)) {
        this._selectionAccumulator.deleteEdges(edge);
      }
    }
  }

  /**
   * Determine all the visual elements clicked which are on the given point.
   *
   * All elements are returned; this includes nodes, edges and their labels.
   * The order returned is from highest to lowest, i.e. element 0 of the return
   * value is the topmost item clicked on.
   *
   * The return value consists of an array of the following possible elements:
   *
   * - `{nodeId:number}`             - node with given id clicked on
   * - `{nodeId:number, labelId:0}`  - label of node with given id clicked on
   * - `{edgeId:number}`             - edge with given id clicked on
   * - `{edge:number, labelId:0}`    - label of edge with given id clicked on
   *
   * ## NOTES
   *
   * - Currently, there is only one label associated with a node or an edge,
   * but this is expected to change somewhere in the future.
   * - Since there is no z-indexing yet, it is not really possible to set the nodes and
   * edges in the correct order. For the time being, nodes come first.
   * @param {point} pointer  mouse position in screen coordinates
   * @returns {Array.<nodeClickItem|nodeLabelClickItem|edgeClickItem|edgeLabelClickItem>}
   * @private
   */
  getClickedItems(pointer) {
    const point = this.canvas.DOMtoCanvas(pointer);
    const items = [];

    // Note reverse order; we want the topmost clicked items to be first in the array
    // Also note that selected nodes are disregarded here; these normally display on top
    const nodeIndices = this.body.nodeIndices;
    const nodes = this.body.nodes;
    for (let i = nodeIndices.length - 1; i >= 0; i--) {
      const node = nodes[nodeIndices[i]];
      const ret = node.getItemsOnPoint(point);
      items.push.apply(items, ret); // Append the return value to the running list.
    }

    const edgeIndices = this.body.edgeIndices;
    const edges = this.body.edges;
    for (let i = edgeIndices.length - 1; i >= 0; i--) {
      const edge = edges[edgeIndices[i]];
      const ret = edge.getItemsOnPoint(point);
      items.push.apply(items, ret); // Append the return value to the running list.
    }

    return items;
  }
}

var arraySlice = arraySliceSimple;

var floor = Math.floor;

var mergeSort = function (array, comparefn) {
  var length = array.length;
  var middle = floor(length / 2);
  return length < 8 ? insertionSort(array, comparefn) : merge(
    array,
    mergeSort(arraySlice(array, 0, middle), comparefn),
    mergeSort(arraySlice(array, middle), comparefn),
    comparefn
  );
};

var insertionSort = function (array, comparefn) {
  var length = array.length;
  var i = 1;
  var element, j;

  while (i < length) {
    j = i;
    element = array[i];
    while (j && comparefn(array[j - 1], element) > 0) {
      array[j] = array[--j];
    }
    if (j !== i++) array[j] = element;
  } return array;
};

var merge = function (array, left, right, comparefn) {
  var llength = left.length;
  var rlength = right.length;
  var lindex = 0;
  var rindex = 0;

  while (lindex < llength || rindex < rlength) {
    array[lindex + rindex] = (lindex < llength && rindex < rlength)
      ? comparefn(left[lindex], right[rindex]) <= 0 ? left[lindex++] : right[rindex++]
      : lindex < llength ? left[lindex++] : right[rindex++];
  } return array;
};

var arraySort = mergeSort;

var userAgent$1 = engineUserAgent;

var firefox = userAgent$1.match(/firefox\/(\d+)/i);

var engineFfVersion = !!firefox && +firefox[1];

var UA = engineUserAgent;

var engineIsIeOrEdge = /MSIE|Trident/.test(UA);

var userAgent = engineUserAgent;

var webkit = userAgent.match(/AppleWebKit\/(\d+)\./);

var engineWebkitVersion = !!webkit && +webkit[1];

var $$2 = _export;
var uncurryThis = functionUncurryThis;
var aCallable$1 = aCallable$6;
var toObject$1 = toObject$c;
var lengthOfArrayLike$1 = lengthOfArrayLike$a;
var deletePropertyOrThrow = deletePropertyOrThrow$2;
var toString = toString$a;
var fails = fails$u;
var internalSort = arraySort;
var arrayMethodIsStrict$2 = arrayMethodIsStrict$6;
var FF = engineFfVersion;
var IE_OR_EDGE = engineIsIeOrEdge;
var V8 = engineV8Version;
var WEBKIT = engineWebkitVersion;

var test = [];
var nativeSort = uncurryThis(test.sort);
var push = uncurryThis(test.push);

// IE8-
var FAILS_ON_UNDEFINED = fails(function () {
  test.sort(undefined);
});
// V8 bug
var FAILS_ON_NULL = fails(function () {
  test.sort(null);
});
// Old WebKit
var STRICT_METHOD$1 = arrayMethodIsStrict$2('sort');

var STABLE_SORT = !fails(function () {
  // feature detection can be too slow, so check engines versions
  if (V8) return V8 < 70;
  if (FF && FF > 3) return;
  if (IE_OR_EDGE) return true;
  if (WEBKIT) return WEBKIT < 603;

  var result = '';
  var code, chr, value, index;

  // generate an array with more 512 elements (Chakra and old V8 fails only in this case)
  for (code = 65; code < 76; code++) {
    chr = String.fromCharCode(code);

    switch (code) {
      case 66: case 69: case 70: case 72: value = 3; break;
      case 68: case 71: value = 4; break;
      default: value = 2;
    }

    for (index = 0; index < 47; index++) {
      test.push({ k: chr + index, v: value });
    }
  }

  test.sort(function (a, b) { return b.v - a.v; });

  for (index = 0; index < test.length; index++) {
    chr = test[index].k.charAt(0);
    if (result.charAt(result.length - 1) !== chr) result += chr;
  }

  return result !== 'DGBEFHACIJK';
});

var FORCED$1 = FAILS_ON_UNDEFINED || !FAILS_ON_NULL || !STRICT_METHOD$1 || !STABLE_SORT;

var getSortCompare = function (comparefn) {
  return function (x, y) {
    if (y === undefined) return -1;
    if (x === undefined) return 1;
    if (comparefn !== undefined) return +comparefn(x, y) || 0;
    return toString(x) > toString(y) ? 1 : -1;
  };
};

// `Array.prototype.sort` method
// https://tc39.es/ecma262/#sec-array.prototype.sort
$$2({ target: 'Array', proto: true, forced: FORCED$1 }, {
  sort: function sort(comparefn) {
    if (comparefn !== undefined) aCallable$1(comparefn);

    var array = toObject$1(this);

    if (STABLE_SORT) return comparefn === undefined ? nativeSort(array) : nativeSort(array, comparefn);

    var items = [];
    var arrayLength = lengthOfArrayLike$1(array);
    var itemsLength, index;

    for (index = 0; index < arrayLength; index++) {
      if (index in array) push(items, array[index]);
    }

    internalSort(items, getSortCompare(comparefn));

    itemsLength = lengthOfArrayLike$1(items);
    index = 0;

    while (index < itemsLength) array[index] = items[index++];
    while (index < arrayLength) deletePropertyOrThrow(array, index++);

    return array;
  }
});

var entryVirtual$2 = entryVirtual$h;

var sort$3 = entryVirtual$2('Array').sort;

var isPrototypeOf$2 = objectIsPrototypeOf;
var method$2 = sort$3;

var ArrayPrototype$2 = Array.prototype;

var sort$2 = function (it) {
  var own = it.sort;
  return it === ArrayPrototype$2 || (isPrototypeOf$2(ArrayPrototype$2, it) && own === ArrayPrototype$2.sort) ? method$2 : own;
};

var parent$2 = sort$2;

var sort$1 = parent$2;

var sort = sort$1;

var _sortInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(sort);

var aCallable = aCallable$6;
var toObject = toObject$c;
var IndexedObject = indexedObject;
var lengthOfArrayLike = lengthOfArrayLike$a;

var $TypeError = TypeError;

// `Array.prototype.{ reduce, reduceRight }` methods implementation
var createMethod = function (IS_RIGHT) {
  return function (that, callbackfn, argumentsLength, memo) {
    aCallable(callbackfn);
    var O = toObject(that);
    var self = IndexedObject(O);
    var length = lengthOfArrayLike(O);
    var index = IS_RIGHT ? length - 1 : 0;
    var i = IS_RIGHT ? -1 : 1;
    if (argumentsLength < 2) while (true) {
      if (index in self) {
        memo = self[index];
        index += i;
        break;
      }
      index += i;
      if (IS_RIGHT ? index < 0 : length <= index) {
        throw new $TypeError('Reduce of empty array with no initial value');
      }
    }
    for (;IS_RIGHT ? index >= 0 : length > index; index += i) if (index in self) {
      memo = callbackfn(memo, self[index], index, O);
    }
    return memo;
  };
};

var arrayReduce = {
  // `Array.prototype.reduce` method
  // https://tc39.es/ecma262/#sec-array.prototype.reduce
  left: createMethod(false),
  // `Array.prototype.reduceRight` method
  // https://tc39.es/ecma262/#sec-array.prototype.reduceright
  right: createMethod(true)
};

var global$1 = global$n;
var classof = classofRaw$2;

var engineIsNode = classof(global$1.process) === 'process';

var $$1 = _export;
var $reduce = arrayReduce.left;
var arrayMethodIsStrict$1 = arrayMethodIsStrict$6;
var CHROME_VERSION = engineV8Version;
var IS_NODE = engineIsNode;

// Chrome 80-82 has a critical bug
// https://bugs.chromium.org/p/chromium/issues/detail?id=1049982
var CHROME_BUG = !IS_NODE && CHROME_VERSION > 79 && CHROME_VERSION < 83;
var FORCED = CHROME_BUG || !arrayMethodIsStrict$1('reduce');

// `Array.prototype.reduce` method
// https://tc39.es/ecma262/#sec-array.prototype.reduce
$$1({ target: 'Array', proto: true, forced: FORCED }, {
  reduce: function reduce(callbackfn /* , initialValue */) {
    var length = arguments.length;
    return $reduce(this, callbackfn, length, length > 1 ? arguments[1] : undefined);
  }
});

var entryVirtual$1 = entryVirtual$h;

var reduce$3 = entryVirtual$1('Array').reduce;

var isPrototypeOf$1 = objectIsPrototypeOf;
var method$1 = reduce$3;

var ArrayPrototype$1 = Array.prototype;

var reduce$2 = function (it) {
  var own = it.reduce;
  return it === ArrayPrototype$1 || (isPrototypeOf$1(ArrayPrototype$1, it) && own === ArrayPrototype$1.reduce) ? method$1 : own;
};

var parent$1 = reduce$2;

var reduce$1 = parent$1;

var reduce = reduce$1;

var _reduceInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(reduce);

/**
 * Helper classes for LayoutEngine.
 *
 * Strategy pattern for usage of direction methods for hierarchical layouts.
 */

/**
 * Interface definition for direction strategy classes.
 *
 * This class describes the interface for the Strategy
 * pattern classes used to differentiate horizontal and vertical
 * direction of hierarchical results.
 *
 * For a given direction, one coordinate will be 'fixed', meaning that it is
 * determined by level.
 * The other coordinate is 'unfixed', meaning that the nodes on a given level
 * can still move along that coordinate. So:
 *
 * - `vertical` layout: `x` unfixed, `y` fixed per level
 * - `horizontal` layout: `x` fixed per level, `y` unfixed
 *
 * The local methods are stubs and should be regarded as abstract.
 * Derived classes **must** implement all the methods themselves.
 * @private
 */
class DirectionInterface {
  /**
   * @ignore
   */
  abstract() {
    throw new Error("Can't instantiate abstract class!");
  }

  /**
   * This is a dummy call which is used to suppress the jsdoc errors of type:
   *
   * "'param' is assigned a value but never used"
   * @ignore
   */
  fake_use() {
    // Do nothing special
  }

  /**
   * Type to use to translate dynamic curves to, in the case of hierarchical layout.
   * Dynamic curves do not work for these.
   *
   * The value should be perpendicular to the actual direction of the layout.
   * @returns {string} Direction, either 'vertical' or 'horizontal'
   */
  curveType() {
    return this.abstract();
  }

  /**
   * Return the value of the coordinate that is not fixed for this direction.
   * @param {Node} node The node to read
   * @returns {number} Value of the unfixed coordinate
   */
  getPosition(node) {
    this.fake_use(node);
    return this.abstract();
  }

  /**
   * Set the value of the coordinate that is not fixed for this direction.
   * @param {Node} node The node to adjust
   * @param {number} position
   * @param {number} [level] if specified, the hierarchy level that this node should be fixed to
   */
  setPosition(node, position) {
    let level = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : undefined;
    this.fake_use(node, position, level);
    this.abstract();
  }

  /**
   * Get the width of a tree.
   *
   * A `tree` here is a subset of nodes within the network which are not connected to other nodes,
   * only among themselves. In essence, it is a sub-network.
   * @param {number} index The index number of a tree
   * @returns {number} the width of a tree in the view coordinates
   */
  getTreeSize(index) {
    this.fake_use(index);
    return this.abstract();
  }

  /**
   * Sort array of nodes on the unfixed coordinates.
   *
   * Note:** chrome has non-stable sorting implementation, which
   * has a tendency to change the order of the array items,
   * even if the custom sort function returns 0.
   *
   * For this reason, an external sort implementation is used,
   * which has the added benefit of being faster than the standard
   * platforms implementation. This has been verified on `node.js`,
   * `firefox` and `chrome` (all linux).
   * @param {Array.<Node>} nodeArray array of nodes to sort
   */
  sort(nodeArray) {
    this.fake_use(nodeArray);
    this.abstract();
  }

  /**
   * Assign the fixed coordinate of the node to the given level
   * @param {Node} node The node to adjust
   * @param {number} level The level to fix to
   */
  fix(node, level) {
    this.fake_use(node, level);
    this.abstract();
  }

  /**
   * Add an offset to the unfixed coordinate of the given node.
   * @param {NodeId} nodeId Id of the node to adjust
   * @param {number} diff Offset to add to the unfixed coordinate
   */
  shift(nodeId, diff) {
    this.fake_use(nodeId, diff);
    this.abstract();
  }
}

/**
 * Vertical Strategy
 *
 * Coordinate `y` is fixed on levels, coordinate `x` is unfixed.
 * @augments DirectionInterface
 * @private
 */
class VerticalStrategy extends DirectionInterface {
  /**
   * Constructor
   * @param {object} layout reference to the parent LayoutEngine instance.
   */
  constructor(layout) {
    super();
    this.layout = layout;
  }

  /** @inheritDoc */
  curveType() {
    return "horizontal";
  }

  /** @inheritDoc */
  getPosition(node) {
    return node.x;
  }

  /** @inheritDoc */
  setPosition(node, position) {
    let level = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : undefined;
    if (level !== undefined) {
      this.layout.hierarchical.addToOrdering(node, level);
    }
    node.x = position;
  }

  /** @inheritDoc */
  getTreeSize(index) {
    const res = this.layout.hierarchical.getTreeSize(this.layout.body.nodes, index);
    return {
      min: res.min_x,
      max: res.max_x
    };
  }

  /** @inheritDoc */
  sort(nodeArray) {
    _sortInstanceProperty(nodeArray).call(nodeArray, function (a, b) {
      return a.x - b.x;
    });
  }

  /** @inheritDoc */
  fix(node, level) {
    node.y = this.layout.options.hierarchical.levelSeparation * level;
    node.options.fixed.y = true;
  }

  /** @inheritDoc */
  shift(nodeId, diff) {
    this.layout.body.nodes[nodeId].x += diff;
  }
}

/**
 * Horizontal Strategy
 *
 * Coordinate `x` is fixed on levels, coordinate `y` is unfixed.
 * @augments DirectionInterface
 * @private
 */
class HorizontalStrategy extends DirectionInterface {
  /**
   * Constructor
   * @param {object} layout reference to the parent LayoutEngine instance.
   */
  constructor(layout) {
    super();
    this.layout = layout;
  }

  /** @inheritDoc */
  curveType() {
    return "vertical";
  }

  /** @inheritDoc */
  getPosition(node) {
    return node.y;
  }

  /** @inheritDoc */
  setPosition(node, position) {
    let level = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : undefined;
    if (level !== undefined) {
      this.layout.hierarchical.addToOrdering(node, level);
    }
    node.y = position;
  }

  /** @inheritDoc */
  getTreeSize(index) {
    const res = this.layout.hierarchical.getTreeSize(this.layout.body.nodes, index);
    return {
      min: res.min_y,
      max: res.max_y
    };
  }

  /** @inheritDoc */
  sort(nodeArray) {
    _sortInstanceProperty(nodeArray).call(nodeArray, function (a, b) {
      return a.y - b.y;
    });
  }

  /** @inheritDoc */
  fix(node, level) {
    node.x = this.layout.options.hierarchical.levelSeparation * level;
    node.options.fixed.x = true;
  }

  /** @inheritDoc */
  shift(nodeId, diff) {
    this.layout.body.nodes[nodeId].y += diff;
  }
}

var $ = _export;
var $every = arrayIteration.every;
var arrayMethodIsStrict = arrayMethodIsStrict$6;

var STRICT_METHOD = arrayMethodIsStrict('every');

// `Array.prototype.every` method
// https://tc39.es/ecma262/#sec-array.prototype.every
$({ target: 'Array', proto: true, forced: !STRICT_METHOD }, {
  every: function every(callbackfn /* , thisArg */) {
    return $every(this, callbackfn, arguments.length > 1 ? arguments[1] : undefined);
  }
});

var entryVirtual = entryVirtual$h;

var every$3 = entryVirtual('Array').every;

var isPrototypeOf = objectIsPrototypeOf;
var method = every$3;

var ArrayPrototype = Array.prototype;

var every$2 = function (it) {
  var own = it.every;
  return it === ArrayPrototype || (isPrototypeOf(ArrayPrototype, it) && own === ArrayPrototype.every) ? method : own;
};

var parent = every$2;

var every$1 = parent;

var every = every$1;

var _everyInstanceProperty = /*@__PURE__*/getDefaultExportFromCjs(every);

/**
 * Try to assign levels to nodes according to their positions in the cyclic “hierarchy”.
 * @param nodes - Visible nodes of the graph.
 * @param levels - If present levels will be added to it, if not a new object will be created.
 * @returns Populated node levels.
 */
function fillLevelsByDirectionCyclic(nodes, levels) {
  const edges = new _Set();
  _forEachInstanceProperty(nodes).call(nodes, node => {
    var _context;
    _forEachInstanceProperty(_context = node.edges).call(_context, edge => {
      if (edge.connected) {
        edges.add(edge);
      }
    });
  });
  _forEachInstanceProperty(edges).call(edges, edge => {
    const fromId = edge.from.id;
    const toId = edge.to.id;
    if (levels[fromId] == null) {
      levels[fromId] = 0;
    }
    if (levels[toId] == null || levels[fromId] >= levels[toId]) {
      levels[toId] = levels[fromId] + 1;
    }
  });
  return levels;
}
/**
 * Assign levels to nodes according to their positions in the hierarchy. Leaves will be lined up at the bottom and all other nodes as close to their children as possible.
 * @param nodes - Visible nodes of the graph.
 * @returns Populated node levels.
 */
function fillLevelsByDirectionLeaves(nodes) {
  return fillLevelsByDirection(
  // Pick only leaves (nodes without children).
  node => {
    var _context2, _context3;
    return _everyInstanceProperty(_context2 = _filterInstanceProperty(_context3 = node.edges
    // Take only visible nodes into account.
    ).call(_context3, edge => nodes.has(edge.toId))
    // Check that all edges lead to this node (leaf).
    ).call(_context2, edge => edge.to === node);
  },
  // Use the lowest level.
  (newLevel, oldLevel) => oldLevel > newLevel,
  // Go against the direction of the edges.
  "from", nodes);
}
/**
 * Assign levels to nodes according to their positions in the hierarchy. Roots will be lined up at the top and all nodes as close to their parents as possible.
 * @param nodes - Visible nodes of the graph.
 * @returns Populated node levels.
 */
function fillLevelsByDirectionRoots(nodes) {
  return fillLevelsByDirection(
  // Pick only roots (nodes without parents).
  node => {
    var _context4, _context5;
    return _everyInstanceProperty(_context4 = _filterInstanceProperty(_context5 = node.edges
    // Take only visible nodes into account.
    ).call(_context5, edge => nodes.has(edge.toId))
    // Check that all edges lead from this node (root).
    ).call(_context4, edge => edge.from === node);
  },
  // Use the highest level.
  (newLevel, oldLevel) => oldLevel < newLevel,
  // Go in the direction of the edges.
  "to", nodes);
}
/**
 * Assign levels to nodes according to their positions in the hierarchy.
 * @param isEntryNode - Checks and return true if the graph should be traversed from this node.
 * @param shouldLevelBeReplaced - Checks and returns true if the level of given node should be updated to the new value.
 * @param direction - Wheter the graph should be traversed in the direction of the edges `"to"` or in the other way `"from"`.
 * @param nodes - Visible nodes of the graph.
 * @returns Populated node levels.
 */
function fillLevelsByDirection(isEntryNode, shouldLevelBeReplaced, direction, nodes) {
  var _context6;
  const levels = _Object$create(null);
  // If acyclic, the graph can be walked through with (most likely way) fewer
  // steps than the number bellow. The exact value isn't too important as long
  // as it's quick to compute (doesn't impact acyclic graphs too much), is
  // higher than the number of steps actually needed (doesn't cut off before
  // acyclic graph is walked through) and prevents infinite loops (cuts off for
  // cyclic graphs).
  const limit = _reduceInstanceProperty(_context6 = [..._valuesInstanceProperty(nodes).call(nodes)]).call(_context6, (acc, node) => acc + 1 + node.edges.length, 0);
  const edgeIdProp = direction + "Id";
  const newLevelDiff = direction === "to" ? 1 : -1;
  for (const [entryNodeId, entryNode] of nodes) {
    if (
    // Skip if the node is not visible.
    !nodes.has(entryNodeId) ||
    // Skip if the node is not an entry node.
    !isEntryNode(entryNode)) {
      continue;
    }
    // Line up all the entry nodes on level 0.
    levels[entryNodeId] = 0;
    const stack = [entryNode];
    let done = 0;
    let node;
    while (node = stack.pop()) {
      var _context7, _context8;
      if (!nodes.has(entryNodeId)) {
        // Skip if the node is not visible.
        continue;
      }
      const newLevel = levels[node.id] + newLevelDiff;
      _forEachInstanceProperty(_context7 = _filterInstanceProperty(_context8 = node.edges).call(_context8, edge =>
      // Ignore disconnected edges.
      edge.connected &&
      // Ignore circular edges.
      edge.to !== edge.from &&
      // Ignore edges leading to the node that's currently being processed.
      edge[direction] !== node &&
      // Ignore edges connecting to an invisible node.
      nodes.has(edge.toId) &&
      // Ignore edges connecting from an invisible node.
      nodes.has(edge.fromId))).call(_context7, edge => {
        const targetNodeId = edge[edgeIdProp];
        const oldLevel = levels[targetNodeId];
        if (oldLevel == null || shouldLevelBeReplaced(newLevel, oldLevel)) {
          levels[targetNodeId] = newLevel;
          stack.push(edge[direction]);
        }
      });
      if (done > limit) {
        // This would run forever on a cyclic graph.
        return fillLevelsByDirectionCyclic(nodes, levels);
      } else {
        ++done;
      }
    }
  }
  return levels;
}

/**
 * There's a mix-up with terms in the code. Following are the formal definitions:
 *
 *   tree   - a strict hierarchical network, i.e. every node has at most one parent
 *   forest - a collection of trees. These distinct trees are thus not connected.
 *
 * So:
 * - in a network that is not a tree, there exist nodes with multiple parents.
 * - a network consisting of unconnected sub-networks, of which at least one
 *   is not a tree, is not a forest.
 *
 * In the code, the definitions are:
 *
 *   tree   - any disconnected sub-network, strict hierarchical or not.
 *   forest - a bunch of these sub-networks
 *
 * The difference between tree and not-tree is important in the code, notably within
 * to the block-shifting algorithm. The algorithm assumes formal trees and fails
 * for not-trees, often in a spectacular manner (search for 'exploding network' in the issues).
 *
 * In order to distinguish the definitions in the following code, the adjective 'formal' is
 * used. If 'formal' is absent, you must assume the non-formal definition.
 *
 * ----------------------------------------------------------------------------------
 * NOTES
 * =====
 *
 * A hierarchical layout is a different thing from a hierarchical network.
 * The layout is a way to arrange the nodes in the view; this can be done
 * on non-hierarchical networks as well. The converse is also possible.
 */

/**
 * Container for derived data on current network, relating to hierarchy.
 * @private
 */
class HierarchicalStatus {
  /**
   * @ignore
   */
  constructor() {
    this.childrenReference = {}; // child id's per node id
    this.parentReference = {}; // parent id's per node id
    this.trees = {}; // tree id per node id; i.e. to which tree does given node id belong

    this.distributionOrdering = {}; // The nodes per level, in the display order
    this.levels = {}; // hierarchy level per node id
    this.distributionIndex = {}; // The position of the node in the level sorting order, per node id.

    this.isTree = false; // True if current network is a formal tree
    this.treeIndex = -1; // Highest tree id in current network.
  }

  /**
   * Add the relation between given nodes to the current state.
   * @param {Node.id} parentNodeId
   * @param {Node.id} childNodeId
   */
  addRelation(parentNodeId, childNodeId) {
    if (this.childrenReference[parentNodeId] === undefined) {
      this.childrenReference[parentNodeId] = [];
    }
    this.childrenReference[parentNodeId].push(childNodeId);
    if (this.parentReference[childNodeId] === undefined) {
      this.parentReference[childNodeId] = [];
    }
    this.parentReference[childNodeId].push(parentNodeId);
  }

  /**
   * Check if the current state is for a formal tree or formal forest.
   *
   * This is the case if every node has at most one parent.
   *
   * Pre: parentReference init'ed properly for current network
   */
  checkIfTree() {
    for (const i in this.parentReference) {
      if (this.parentReference[i].length > 1) {
        this.isTree = false;
        return;
      }
    }
    this.isTree = true;
  }

  /**
   * Return the number of separate trees in the current network.
   * @returns {number}
   */
  numTrees() {
    return this.treeIndex + 1; // This assumes the indexes are assigned consecitively
  }

  /**
   * Assign a tree id to a node
   * @param {Node} node
   * @param {string|number} treeId
   */
  setTreeIndex(node, treeId) {
    if (treeId === undefined) return; // Don't bother

    if (this.trees[node.id] === undefined) {
      this.trees[node.id] = treeId;
      this.treeIndex = Math.max(treeId, this.treeIndex);
    }
  }

  /**
   * Ensure level for given id is defined.
   *
   * Sets level to zero for given node id if not already present
   * @param {Node.id} nodeId
   */
  ensureLevel(nodeId) {
    if (this.levels[nodeId] === undefined) {
      this.levels[nodeId] = 0;
    }
  }

  /**
   * get the maximum level of a branch.
   *
   * TODO: Never entered; find a test case to test this!
   * @param {Node.id} nodeId
   * @returns {number}
   */
  getMaxLevel(nodeId) {
    const accumulator = {};
    const _getMaxLevel = nodeId => {
      if (accumulator[nodeId] !== undefined) {
        return accumulator[nodeId];
      }
      let level = this.levels[nodeId];
      if (this.childrenReference[nodeId]) {
        const children = this.childrenReference[nodeId];
        if (children.length > 0) {
          for (let i = 0; i < children.length; i++) {
            level = Math.max(level, _getMaxLevel(children[i]));
          }
        }
      }
      accumulator[nodeId] = level;
      return level;
    };
    return _getMaxLevel(nodeId);
  }

  /**
   *
   * @param {Node} nodeA
   * @param {Node} nodeB
   */
  levelDownstream(nodeA, nodeB) {
    if (this.levels[nodeB.id] === undefined) {
      // set initial level
      if (this.levels[nodeA.id] === undefined) {
        this.levels[nodeA.id] = 0;
      }
      // set level
      this.levels[nodeB.id] = this.levels[nodeA.id] + 1;
    }
  }

  /**
   * Small util method to set the minimum levels of the nodes to zero.
   * @param {Array.<Node>} nodes
   */
  setMinLevelToZero(nodes) {
    let minLevel = 1e9;
    // get the minimum level
    for (const nodeId in nodes) {
      if (Object.prototype.hasOwnProperty.call(nodes, nodeId)) {
        if (this.levels[nodeId] !== undefined) {
          minLevel = Math.min(this.levels[nodeId], minLevel);
        }
      }
    }

    // subtract the minimum from the set so we have a range starting from 0
    for (const nodeId in nodes) {
      if (Object.prototype.hasOwnProperty.call(nodes, nodeId)) {
        if (this.levels[nodeId] !== undefined) {
          this.levels[nodeId] -= minLevel;
        }
      }
    }
  }

  /**
   * Get the min and max xy-coordinates of a given tree
   * @param {Array.<Node>} nodes
   * @param {number} index
   * @returns {{min_x: number, max_x: number, min_y: number, max_y: number}}
   */
  getTreeSize(nodes, index) {
    let min_x = 1e9;
    let max_x = -1e9;
    let min_y = 1e9;
    let max_y = -1e9;
    for (const nodeId in this.trees) {
      if (Object.prototype.hasOwnProperty.call(this.trees, nodeId)) {
        if (this.trees[nodeId] === index) {
          const node = nodes[nodeId];
          min_x = Math.min(node.x, min_x);
          max_x = Math.max(node.x, max_x);
          min_y = Math.min(node.y, min_y);
          max_y = Math.max(node.y, max_y);
        }
      }
    }
    return {
      min_x: min_x,
      max_x: max_x,
      min_y: min_y,
      max_y: max_y
    };
  }

  /**
   * Check if two nodes have the same parent(s)
   * @param {Node} node1
   * @param {Node} node2
   * @returns {boolean} true if the two nodes have a same ancestor node, false otherwise
   */
  hasSameParent(node1, node2) {
    const parents1 = this.parentReference[node1.id];
    const parents2 = this.parentReference[node2.id];
    if (parents1 === undefined || parents2 === undefined) {
      return false;
    }
    for (let i = 0; i < parents1.length; i++) {
      for (let j = 0; j < parents2.length; j++) {
        if (parents1[i] == parents2[j]) {
          return true;
        }
      }
    }
    return false;
  }

  /**
   * Check if two nodes are in the same tree.
   * @param {Node} node1
   * @param {Node} node2
   * @returns {boolean} true if this is so, false otherwise
   */
  inSameSubNetwork(node1, node2) {
    return this.trees[node1.id] === this.trees[node2.id];
  }

  /**
   * Get a list of the distinct levels in the current network
   * @returns {Array}
   */
  getLevels() {
    return _Object$keys(this.distributionOrdering);
  }

  /**
   * Add a node to the ordering per level
   * @param {Node} node
   * @param {number} level
   */
  addToOrdering(node, level) {
    if (this.distributionOrdering[level] === undefined) {
      this.distributionOrdering[level] = [];
    }
    let isPresent = false;
    const curLevel = this.distributionOrdering[level];
    for (const n in curLevel) {
      //if (curLevel[n].id === node.id) {
      if (curLevel[n] === node) {
        isPresent = true;
        break;
      }
    }
    if (!isPresent) {
      this.distributionOrdering[level].push(node);
      this.distributionIndex[node.id] = this.distributionOrdering[level].length - 1;
    }
  }
}

/**
 * The Layout Engine
 */
class LayoutEngine {
  /**
   * @param {object} body
   */
  constructor(body) {
    this.body = body;

    // Make sure there always is some RNG because the setOptions method won't
    // set it unless there's a seed for it.
    this._resetRNG(Math.random() + ":" + _Date$now());
    this.setPhysics = false;
    this.options = {};
    this.optionsBackup = {
      physics: {}
    };
    this.defaultOptions = {
      randomSeed: undefined,
      improvedLayout: true,
      clusterThreshold: 150,
      hierarchical: {
        enabled: false,
        levelSeparation: 150,
        nodeSpacing: 100,
        treeSpacing: 200,
        blockShifting: true,
        edgeMinimization: true,
        parentCentralization: true,
        direction: "UD",
        // UD, DU, LR, RL
        sortMethod: "hubsize" // hubsize, directed
      }
    };

    _Object$assign(this.options, this.defaultOptions);
    this.bindEventListeners();
  }

  /**
   * Binds event listeners
   */
  bindEventListeners() {
    this.body.emitter.on("_dataChanged", () => {
      this.setupHierarchicalLayout();
    });
    this.body.emitter.on("_dataLoaded", () => {
      this.layoutNetwork();
    });
    this.body.emitter.on("_resetHierarchicalLayout", () => {
      this.setupHierarchicalLayout();
    });
    this.body.emitter.on("_adjustEdgesForHierarchicalLayout", () => {
      if (this.options.hierarchical.enabled !== true) {
        return;
      }
      // get the type of static smooth curve in case it is required
      const type = this.direction.curveType();

      // force all edges into static smooth curves.
      this.body.emitter.emit("_forceDisableDynamicCurves", type, false);
    });
  }

  /**
   *
   * @param {object} options
   * @param {object} allOptions
   * @returns {object}
   */
  setOptions(options, allOptions) {
    if (options !== undefined) {
      const hierarchical = this.options.hierarchical;
      const prevHierarchicalState = hierarchical.enabled;
      selectiveDeepExtend(["randomSeed", "improvedLayout", "clusterThreshold"], this.options, options);
      mergeOptions(this.options, options, "hierarchical");
      if (options.randomSeed !== undefined) {
        this._resetRNG(options.randomSeed);
      }
      if (hierarchical.enabled === true) {
        if (prevHierarchicalState === true) {
          // refresh the overridden options for nodes and edges.
          this.body.emitter.emit("refresh", true);
        }

        // make sure the level separation is the right way up
        if (hierarchical.direction === "RL" || hierarchical.direction === "DU") {
          if (hierarchical.levelSeparation > 0) {
            hierarchical.levelSeparation *= -1;
          }
        } else {
          if (hierarchical.levelSeparation < 0) {
            hierarchical.levelSeparation *= -1;
          }
        }
        this.setDirectionStrategy();
        this.body.emitter.emit("_resetHierarchicalLayout");
        // because the hierarchical system needs it's own physics and smooth curve settings,
        // we adapt the other options if needed.
        return this.adaptAllOptionsForHierarchicalLayout(allOptions);
      } else {
        if (prevHierarchicalState === true) {
          // refresh the overridden options for nodes and edges.
          this.body.emitter.emit("refresh");
          return deepExtend(allOptions, this.optionsBackup);
        }
      }
    }
    return allOptions;
  }

  /**
   * Reset the random number generator with given seed.
   * @param {any} seed - The seed that will be forwarded the the RNG.
   */
  _resetRNG(seed) {
    this.initialRandomSeed = seed;
    this._rng = Alea(this.initialRandomSeed);
  }

  /**
   *
   * @param {object} allOptions
   * @returns {object}
   */
  adaptAllOptionsForHierarchicalLayout(allOptions) {
    if (this.options.hierarchical.enabled === true) {
      const backupPhysics = this.optionsBackup.physics;

      // set the physics
      if (allOptions.physics === undefined || allOptions.physics === true) {
        allOptions.physics = {
          enabled: backupPhysics.enabled === undefined ? true : backupPhysics.enabled,
          solver: "hierarchicalRepulsion"
        };
        backupPhysics.enabled = backupPhysics.enabled === undefined ? true : backupPhysics.enabled;
        backupPhysics.solver = backupPhysics.solver || "barnesHut";
      } else if (typeof allOptions.physics === "object") {
        backupPhysics.enabled = allOptions.physics.enabled === undefined ? true : allOptions.physics.enabled;
        backupPhysics.solver = allOptions.physics.solver || "barnesHut";
        allOptions.physics.solver = "hierarchicalRepulsion";
      } else if (allOptions.physics !== false) {
        backupPhysics.solver = "barnesHut";
        allOptions.physics = {
          solver: "hierarchicalRepulsion"
        };
      }

      // get the type of static smooth curve in case it is required
      let type = this.direction.curveType();

      // disable smooth curves if nothing is defined. If smooth curves have been turned on,
      // turn them into static smooth curves.
      if (allOptions.edges === undefined) {
        this.optionsBackup.edges = {
          smooth: {
            enabled: true,
            type: "dynamic"
          }
        };
        allOptions.edges = {
          smooth: false
        };
      } else if (allOptions.edges.smooth === undefined) {
        this.optionsBackup.edges = {
          smooth: {
            enabled: true,
            type: "dynamic"
          }
        };
        allOptions.edges.smooth = false;
      } else {
        if (typeof allOptions.edges.smooth === "boolean") {
          this.optionsBackup.edges = {
            smooth: allOptions.edges.smooth
          };
          allOptions.edges.smooth = {
            enabled: allOptions.edges.smooth,
            type: type
          };
        } else {
          const smooth = allOptions.edges.smooth;

          // allow custom types except for dynamic
          if (smooth.type !== undefined && smooth.type !== "dynamic") {
            type = smooth.type;
          }

          // TODO: this is options merging; see if the standard routines can be used here.
          this.optionsBackup.edges = {
            smooth: {
              enabled: smooth.enabled === undefined ? true : smooth.enabled,
              type: smooth.type === undefined ? "dynamic" : smooth.type,
              roundness: smooth.roundness === undefined ? 0.5 : smooth.roundness,
              forceDirection: smooth.forceDirection === undefined ? false : smooth.forceDirection
            }
          };

          // NOTE: Copying an object to self; this is basically setting defaults for undefined variables
          allOptions.edges.smooth = {
            enabled: smooth.enabled === undefined ? true : smooth.enabled,
            type: type,
            roundness: smooth.roundness === undefined ? 0.5 : smooth.roundness,
            forceDirection: smooth.forceDirection === undefined ? false : smooth.forceDirection
          };
        }
      }

      // Force all edges into static smooth curves.
      // Only applies to edges that do not use the global options for smooth.
      this.body.emitter.emit("_forceDisableDynamicCurves", type);
    }
    return allOptions;
  }

  /**
   *
   * @param {Array.<Node>} nodesArray
   */
  positionInitially(nodesArray) {
    if (this.options.hierarchical.enabled !== true) {
      this._resetRNG(this.initialRandomSeed);
      const radius = nodesArray.length + 50;
      for (let i = 0; i < nodesArray.length; i++) {
        const node = nodesArray[i];
        const angle = 2 * Math.PI * this._rng();
        if (node.x === undefined) {
          node.x = radius * Math.cos(angle);
        }
        if (node.y === undefined) {
          node.y = radius * Math.sin(angle);
        }
      }
    }
  }

  /**
   * Use Kamada Kawai to position nodes. This is quite a heavy algorithm so if there are a lot of nodes we
   * cluster them first to reduce the amount.
   */
  layoutNetwork() {
    if (this.options.hierarchical.enabled !== true && this.options.improvedLayout === true) {
      const indices = this.body.nodeIndices;

      // first check if we should Kamada Kawai to layout. The threshold is if less than half of the visible
      // nodes have predefined positions we use this.
      let positionDefined = 0;
      for (let i = 0; i < indices.length; i++) {
        const node = this.body.nodes[indices[i]];
        if (node.predefinedPosition === true) {
          positionDefined += 1;
        }
      }

      // if less than half of the nodes have a predefined position we continue
      if (positionDefined < 0.5 * indices.length) {
        const MAX_LEVELS = 10;
        let level = 0;
        const clusterThreshold = this.options.clusterThreshold;

        //
        // Define the options for the hidden cluster nodes
        // These options don't propagate outside the clustering phase.
        //
        // Some options are explicitly disabled, because they may be set in group or default node options.
        // The clusters are never displayed, so most explicit settings here serve as performance optimizations.
        //
        // The explicit setting of 'shape' is to avoid `shape: 'image'`; images are not passed to the hidden
        // cluster nodes, leading to an exception on creation.
        //
        // All settings here are performance related, except when noted otherwise.
        //
        const clusterOptions = {
          clusterNodeProperties: {
            shape: "ellipse",
            // Bugfix: avoid type 'image', no images supplied
            label: "",
            // avoid label handling
            group: "",
            // avoid group handling
            font: {
              multi: false
            } // avoid font propagation
          },

          clusterEdgeProperties: {
            label: "",
            // avoid label handling
            font: {
              multi: false
            },
            // avoid font propagation
            smooth: {
              enabled: false // avoid drawing penalty for complex edges
            }
          }
        };

        // if there are a lot of nodes, we cluster before we run the algorithm.
        // NOTE: this part fails to find clusters for large scale-free networks, which should
        //       be easily clusterable.
        // TODO: examine why this is so
        if (indices.length > clusterThreshold) {
          const startLength = indices.length;
          while (indices.length > clusterThreshold && level <= MAX_LEVELS) {
            //console.time("clustering")
            level += 1;
            const before = indices.length;
            // if there are many nodes we do a hubsize cluster
            if (level % 3 === 0) {
              this.body.modules.clustering.clusterBridges(clusterOptions);
            } else {
              this.body.modules.clustering.clusterOutliers(clusterOptions);
            }
            const after = indices.length;
            if (before == after && level % 3 !== 0) {
              this._declusterAll();
              this.body.emitter.emit("_layoutFailed");
              console.info("This network could not be positioned by this version of the improved layout algorithm." + " Please disable improvedLayout for better performance.");
              return;
            }
            //console.timeEnd("clustering")
            //console.log(before,level,after);
          }
          // increase the size of the edges
          this.body.modules.kamadaKawai.setOptions({
            springLength: Math.max(150, 2 * startLength)
          });
        }
        if (level > MAX_LEVELS) {
          console.info("The clustering didn't succeed within the amount of interations allowed," + " progressing with partial result.");
        }

        // position the system for these nodes and edges
        this.body.modules.kamadaKawai.solve(indices, this.body.edgeIndices, true);

        // shift to center point
        this._shiftToCenter();

        // perturb the nodes a little bit to force the physics to kick in
        const offset = 70;
        for (let i = 0; i < indices.length; i++) {
          // Only perturb the nodes that aren't fixed
          const node = this.body.nodes[indices[i]];
          if (node.predefinedPosition === false) {
            node.x += (0.5 - this._rng()) * offset;
            node.y += (0.5 - this._rng()) * offset;
          }
        }

        // uncluster all clusters
        this._declusterAll();

        // reposition all bezier nodes.
        this.body.emitter.emit("_repositionBezierNodes");
      }
    }
  }

  /**
   * Move all the nodes towards to the center so gravitational pull wil not move the nodes away from view
   * @private
   */
  _shiftToCenter() {
    const range = NetworkUtil.getRangeCore(this.body.nodes, this.body.nodeIndices);
    const center = NetworkUtil.findCenter(range);
    for (let i = 0; i < this.body.nodeIndices.length; i++) {
      const node = this.body.nodes[this.body.nodeIndices[i]];
      node.x -= center.x;
      node.y -= center.y;
    }
  }

  /**
   * Expands all clusters
   * @private
   */
  _declusterAll() {
    let clustersPresent = true;
    while (clustersPresent === true) {
      clustersPresent = false;
      for (let i = 0; i < this.body.nodeIndices.length; i++) {
        if (this.body.nodes[this.body.nodeIndices[i]].isCluster === true) {
          clustersPresent = true;
          this.body.modules.clustering.openCluster(this.body.nodeIndices[i], {}, false);
        }
      }
      if (clustersPresent === true) {
        this.body.emitter.emit("_dataChanged");
      }
    }
  }

  /**
   *
   * @returns {number|*}
   */
  getSeed() {
    return this.initialRandomSeed;
  }

  /**
   * This is the main function to layout the nodes in a hierarchical way.
   * It checks if the node details are supplied correctly
   * @private
   */
  setupHierarchicalLayout() {
    if (this.options.hierarchical.enabled === true && this.body.nodeIndices.length > 0) {
      // get the size of the largest hubs and check if the user has defined a level for a node.
      let node, nodeId;
      let definedLevel = false;
      let undefinedLevel = false;
      this.lastNodeOnLevel = {};
      this.hierarchical = new HierarchicalStatus();
      for (nodeId in this.body.nodes) {
        if (Object.prototype.hasOwnProperty.call(this.body.nodes, nodeId)) {
          node = this.body.nodes[nodeId];
          if (node.options.level !== undefined) {
            definedLevel = true;
            this.hierarchical.levels[nodeId] = node.options.level;
          } else {
            undefinedLevel = true;
          }
        }
      }

      // if the user defined some levels but not all, alert and run without hierarchical layout
      if (undefinedLevel === true && definedLevel === true) {
        throw new Error("To use the hierarchical layout, nodes require either no predefined levels" + " or levels have to be defined for all nodes.");
      } else {
        // define levels if undefined by the users. Based on hubsize.
        if (undefinedLevel === true) {
          const sortMethod = this.options.hierarchical.sortMethod;
          if (sortMethod === "hubsize") {
            this._determineLevelsByHubsize();
          } else if (sortMethod === "directed") {
            this._determineLevelsDirected();
          } else if (sortMethod === "custom") {
            this._determineLevelsCustomCallback();
          }
        }

        // fallback for cases where there are nodes but no edges
        for (const nodeId in this.body.nodes) {
          if (Object.prototype.hasOwnProperty.call(this.body.nodes, nodeId)) {
            this.hierarchical.ensureLevel(nodeId);
          }
        }
        // check the distribution of the nodes per level.
        const distribution = this._getDistribution();

        // get the parent children relations.
        this._generateMap();

        // place the nodes on the canvas.
        this._placeNodesByHierarchy(distribution);

        // condense the whitespace.
        this._condenseHierarchy();

        // shift to center so gravity does not have to do much
        this._shiftToCenter();
      }
    }
  }

  /**
   * @private
   */
  _condenseHierarchy() {
    var _this = this;
    // Global var in this scope to define when the movement has stopped.
    let stillShifting = false;
    const branches = {};
    // first we have some methods to help shifting trees around.
    // the main method to shift the trees
    const shiftTrees = () => {
      const treeSizes = getTreeSizes();
      let shiftBy = 0;
      for (let i = 0; i < treeSizes.length - 1; i++) {
        const diff = treeSizes[i].max - treeSizes[i + 1].min;
        shiftBy += diff + this.options.hierarchical.treeSpacing;
        shiftTree(i + 1, shiftBy);
      }
    };

    // shift a single tree by an offset
    const shiftTree = (index, offset) => {
      const trees = this.hierarchical.trees;
      for (const nodeId in trees) {
        if (Object.prototype.hasOwnProperty.call(trees, nodeId)) {
          if (trees[nodeId] === index) {
            this.direction.shift(nodeId, offset);
          }
        }
      }
    };

    // get the width of all trees
    const getTreeSizes = () => {
      const treeWidths = [];
      for (let i = 0; i < this.hierarchical.numTrees(); i++) {
        treeWidths.push(this.direction.getTreeSize(i));
      }
      return treeWidths;
    };

    // get a map of all nodes in this branch
    const getBranchNodes = (source, map) => {
      if (map[source.id]) {
        return;
      }
      map[source.id] = true;
      if (this.hierarchical.childrenReference[source.id]) {
        const children = this.hierarchical.childrenReference[source.id];
        if (children.length > 0) {
          for (let i = 0; i < children.length; i++) {
            getBranchNodes(this.body.nodes[children[i]], map);
          }
        }
      }
    };

    // get a min max width as well as the maximum movement space it has on either sides
    // we use min max terminology because width and height can interchange depending on the direction of the layout
    const getBranchBoundary = function (branchMap) {
      let maxLevel = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 1e9;
      let minSpace = 1e9;
      let maxSpace = 1e9;
      let min = 1e9;
      let max = -1e9;
      for (const branchNode in branchMap) {
        if (Object.prototype.hasOwnProperty.call(branchMap, branchNode)) {
          const node = _this.body.nodes[branchNode];
          const level = _this.hierarchical.levels[node.id];
          const position = _this.direction.getPosition(node);

          // get the space around the node.
          const [minSpaceNode, maxSpaceNode] = _this._getSpaceAroundNode(node, branchMap);
          minSpace = Math.min(minSpaceNode, minSpace);
          maxSpace = Math.min(maxSpaceNode, maxSpace);

          // the width is only relevant for the levels two nodes have in common. This is why we filter on this.
          if (level <= maxLevel) {
            min = Math.min(position, min);
            max = Math.max(position, max);
          }
        }
      }
      return [min, max, minSpace, maxSpace];
    };

    // check what the maximum level is these nodes have in common.
    const getCollisionLevel = (node1, node2) => {
      const maxLevel1 = this.hierarchical.getMaxLevel(node1.id);
      const maxLevel2 = this.hierarchical.getMaxLevel(node2.id);
      return Math.min(maxLevel1, maxLevel2);
    };

    /**
     * Condense elements. These can be nodes or branches depending on the callback.
     * @param {Function} callback
     * @param {Array.<number>} levels
     * @param {*} centerParents
     */
    const shiftElementsCloser = (callback, levels, centerParents) => {
      const hier = this.hierarchical;
      for (let i = 0; i < levels.length; i++) {
        const level = levels[i];
        const levelNodes = hier.distributionOrdering[level];
        if (levelNodes.length > 1) {
          for (let j = 0; j < levelNodes.length - 1; j++) {
            const node1 = levelNodes[j];
            const node2 = levelNodes[j + 1];

            // NOTE: logic maintained as it was; if nodes have same ancestor,
            //       then of course they are in the same sub-network.
            if (hier.hasSameParent(node1, node2) && hier.inSameSubNetwork(node1, node2)) {
              callback(node1, node2, centerParents);
            }
          }
        }
      }
    };

    // callback for shifting branches
    const branchShiftCallback = function (node1, node2) {
      let centerParent = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
      //window.CALLBACKS.push(() => {
      const pos1 = _this.direction.getPosition(node1);
      const pos2 = _this.direction.getPosition(node2);
      const diffAbs = Math.abs(pos2 - pos1);
      const nodeSpacing = _this.options.hierarchical.nodeSpacing;
      //console.log("NOW CHECKING:", node1.id, node2.id, diffAbs);
      if (diffAbs > nodeSpacing) {
        const branchNodes1 = {};
        const branchNodes2 = {};
        getBranchNodes(node1, branchNodes1);
        getBranchNodes(node2, branchNodes2);

        // check the largest distance between the branches
        const maxLevel = getCollisionLevel(node1, node2);
        const branchNodeBoundary1 = getBranchBoundary(branchNodes1, maxLevel);
        const branchNodeBoundary2 = getBranchBoundary(branchNodes2, maxLevel);
        const max1 = branchNodeBoundary1[1];
        const min2 = branchNodeBoundary2[0];
        const minSpace2 = branchNodeBoundary2[2];

        //console.log(node1.id, getBranchBoundary(branchNodes1, maxLevel), node2.id,
        //            getBranchBoundary(branchNodes2, maxLevel), maxLevel);
        const diffBranch = Math.abs(max1 - min2);
        if (diffBranch > nodeSpacing) {
          let offset = max1 - min2 + nodeSpacing;
          if (offset < -minSpace2 + nodeSpacing) {
            offset = -minSpace2 + nodeSpacing;
            //console.log("RESETTING OFFSET", max1 - min2 + this.options.hierarchical.nodeSpacing, -minSpace2, offset);
          }

          if (offset < 0) {
            //console.log("SHIFTING", node2.id, offset);
            _this._shiftBlock(node2.id, offset);
            stillShifting = true;
            if (centerParent === true) _this._centerParent(node2);
          }
        }
      }
      //this.body.emitter.emit("_redraw");})
    };

    const minimizeEdgeLength = (iterations, node) => {
      //window.CALLBACKS.push(() => {
      //  console.log("ts",node.id);
      const nodeId = node.id;
      const allEdges = node.edges;
      const nodeLevel = this.hierarchical.levels[node.id];

      // gather constants
      const C2 = this.options.hierarchical.levelSeparation * this.options.hierarchical.levelSeparation;
      const referenceNodes = {};
      const aboveEdges = [];
      for (let i = 0; i < allEdges.length; i++) {
        const edge = allEdges[i];
        if (edge.toId != edge.fromId) {
          const otherNode = edge.toId == nodeId ? edge.from : edge.to;
          referenceNodes[allEdges[i].id] = otherNode;
          if (this.hierarchical.levels[otherNode.id] < nodeLevel) {
            aboveEdges.push(edge);
          }
        }
      }

      // differentiated sum of lengths based on only moving one node over one axis
      const getFx = (point, edges) => {
        let sum = 0;
        for (let i = 0; i < edges.length; i++) {
          if (referenceNodes[edges[i].id] !== undefined) {
            const a = this.direction.getPosition(referenceNodes[edges[i].id]) - point;
            sum += a / Math.sqrt(a * a + C2);
          }
        }
        return sum;
      };

      // doubly differentiated sum of lengths based on only moving one node over one axis
      const getDFx = (point, edges) => {
        let sum = 0;
        for (let i = 0; i < edges.length; i++) {
          if (referenceNodes[edges[i].id] !== undefined) {
            const a = this.direction.getPosition(referenceNodes[edges[i].id]) - point;
            sum -= C2 * Math.pow(a * a + C2, -1.5);
          }
        }
        return sum;
      };
      const getGuess = (iterations, edges) => {
        let guess = this.direction.getPosition(node);
        // Newton's method for optimization
        const guessMap = {};
        for (let i = 0; i < iterations; i++) {
          const fx = getFx(guess, edges);
          const dfx = getDFx(guess, edges);

          // we limit the movement to avoid instability.
          const limit = 40;
          const ratio = Math.max(-limit, Math.min(limit, Math.round(fx / dfx)));
          guess = guess - ratio;
          // reduce duplicates
          if (guessMap[guess] !== undefined) {
            break;
          }
          guessMap[guess] = i;
        }
        return guess;
      };
      const moveBranch = guess => {
        // position node if there is space
        const nodePosition = this.direction.getPosition(node);

        // check movable area of the branch
        if (branches[node.id] === undefined) {
          const branchNodes = {};
          getBranchNodes(node, branchNodes);
          branches[node.id] = branchNodes;
        }
        const branchBoundary = getBranchBoundary(branches[node.id]);
        const minSpaceBranch = branchBoundary[2];
        const maxSpaceBranch = branchBoundary[3];
        const diff = guess - nodePosition;

        // check if we are allowed to move the node:
        let branchOffset = 0;
        if (diff > 0) {
          branchOffset = Math.min(diff, maxSpaceBranch - this.options.hierarchical.nodeSpacing);
        } else if (diff < 0) {
          branchOffset = -Math.min(-diff, minSpaceBranch - this.options.hierarchical.nodeSpacing);
        }
        if (branchOffset != 0) {
          //console.log("moving branch:",branchOffset, maxSpaceBranch, minSpaceBranch)
          this._shiftBlock(node.id, branchOffset);
          //this.body.emitter.emit("_redraw");
          stillShifting = true;
        }
      };
      const moveNode = guess => {
        const nodePosition = this.direction.getPosition(node);

        // position node if there is space
        const [minSpace, maxSpace] = this._getSpaceAroundNode(node);
        const diff = guess - nodePosition;
        // check if we are allowed to move the node:
        let newPosition = nodePosition;
        if (diff > 0) {
          newPosition = Math.min(nodePosition + (maxSpace - this.options.hierarchical.nodeSpacing), guess);
        } else if (diff < 0) {
          newPosition = Math.max(nodePosition - (minSpace - this.options.hierarchical.nodeSpacing), guess);
        }
        if (newPosition !== nodePosition) {
          //console.log("moving Node:",diff, minSpace, maxSpace);
          this.direction.setPosition(node, newPosition);
          //this.body.emitter.emit("_redraw");
          stillShifting = true;
        }
      };
      let guess = getGuess(iterations, aboveEdges);
      moveBranch(guess);
      guess = getGuess(iterations, allEdges);
      moveNode(guess);
      //})
    };

    // method to remove whitespace between branches. Because we do bottom up, we can center the parents.
    const minimizeEdgeLengthBottomUp = iterations => {
      let levels = this.hierarchical.getLevels();
      levels = _reverseInstanceProperty(levels).call(levels);
      for (let i = 0; i < iterations; i++) {
        stillShifting = false;
        for (let j = 0; j < levels.length; j++) {
          const level = levels[j];
          const levelNodes = this.hierarchical.distributionOrdering[level];
          for (let k = 0; k < levelNodes.length; k++) {
            minimizeEdgeLength(1000, levelNodes[k]);
          }
        }
        if (stillShifting !== true) {
          //console.log("FINISHED minimizeEdgeLengthBottomUp IN " + i);
          break;
        }
      }
    };

    // method to remove whitespace between branches. Because we do bottom up, we can center the parents.
    const shiftBranchesCloserBottomUp = iterations => {
      let levels = this.hierarchical.getLevels();
      levels = _reverseInstanceProperty(levels).call(levels);
      for (let i = 0; i < iterations; i++) {
        stillShifting = false;
        shiftElementsCloser(branchShiftCallback, levels, true);
        if (stillShifting !== true) {
          //console.log("FINISHED shiftBranchesCloserBottomUp IN " + (i+1));
          break;
        }
      }
    };

    // center all parents
    const centerAllParents = () => {
      for (const nodeId in this.body.nodes) {
        if (Object.prototype.hasOwnProperty.call(this.body.nodes, nodeId)) this._centerParent(this.body.nodes[nodeId]);
      }
    };

    // center all parents
    const centerAllParentsBottomUp = () => {
      let levels = this.hierarchical.getLevels();
      levels = _reverseInstanceProperty(levels).call(levels);
      for (let i = 0; i < levels.length; i++) {
        const level = levels[i];
        const levelNodes = this.hierarchical.distributionOrdering[level];
        for (let j = 0; j < levelNodes.length; j++) {
          this._centerParent(levelNodes[j]);
        }
      }
    };

    // the actual work is done here.
    if (this.options.hierarchical.blockShifting === true) {
      shiftBranchesCloserBottomUp(5);
      centerAllParents();
    }

    // minimize edge length
    if (this.options.hierarchical.edgeMinimization === true) {
      minimizeEdgeLengthBottomUp(20);
    }
    if (this.options.hierarchical.parentCentralization === true) {
      centerAllParentsBottomUp();
    }
    shiftTrees();
  }

  /**
   * This gives the space around the node. IF a map is supplied, it will only check against nodes NOT in the map.
   * This is used to only get the distances to nodes outside of a branch.
   * @param {Node} node
   * @param {{Node.id: vis.Node}} map
   * @returns {number[]}
   * @private
   */
  _getSpaceAroundNode(node, map) {
    let useMap = true;
    if (map === undefined) {
      useMap = false;
    }
    const level = this.hierarchical.levels[node.id];
    if (level !== undefined) {
      const index = this.hierarchical.distributionIndex[node.id];
      const position = this.direction.getPosition(node);
      const ordering = this.hierarchical.distributionOrdering[level];
      let minSpace = 1e9;
      let maxSpace = 1e9;
      if (index !== 0) {
        const prevNode = ordering[index - 1];
        if (useMap === true && map[prevNode.id] === undefined || useMap === false) {
          const prevPos = this.direction.getPosition(prevNode);
          minSpace = position - prevPos;
        }
      }
      if (index != ordering.length - 1) {
        const nextNode = ordering[index + 1];
        if (useMap === true && map[nextNode.id] === undefined || useMap === false) {
          const nextPos = this.direction.getPosition(nextNode);
          maxSpace = Math.min(maxSpace, nextPos - position);
        }
      }
      return [minSpace, maxSpace];
    } else {
      return [0, 0];
    }
  }

  /**
   * We use this method to center a parent node and check if it does not cross other nodes when it does.
   * @param {Node} node
   * @private
   */
  _centerParent(node) {
    if (this.hierarchical.parentReference[node.id]) {
      const parents = this.hierarchical.parentReference[node.id];
      for (let i = 0; i < parents.length; i++) {
        const parentId = parents[i];
        const parentNode = this.body.nodes[parentId];
        const children = this.hierarchical.childrenReference[parentId];
        if (children !== undefined) {
          // get the range of the children
          const newPosition = this._getCenterPosition(children);
          const position = this.direction.getPosition(parentNode);
          const [minSpace, maxSpace] = this._getSpaceAroundNode(parentNode);
          const diff = position - newPosition;
          if (diff < 0 && Math.abs(diff) < maxSpace - this.options.hierarchical.nodeSpacing || diff > 0 && Math.abs(diff) < minSpace - this.options.hierarchical.nodeSpacing) {
            this.direction.setPosition(parentNode, newPosition);
          }
        }
      }
    }
  }

  /**
   * This function places the nodes on the canvas based on the hierarchial distribution.
   * @param {object} distribution | obtained by the function this._getDistribution()
   * @private
   */
  _placeNodesByHierarchy(distribution) {
    this.positionedNodes = {};
    // start placing all the level 0 nodes first. Then recursively position their branches.
    for (const level in distribution) {
      if (Object.prototype.hasOwnProperty.call(distribution, level)) {
        var _context;
        // sort nodes in level by position:
        let nodeArray = _Object$keys(distribution[level]);
        nodeArray = this._indexArrayToNodes(nodeArray);
        _sortInstanceProperty(_context = this.direction).call(_context, nodeArray);
        let handledNodeCount = 0;
        for (let i = 0; i < nodeArray.length; i++) {
          const node = nodeArray[i];
          if (this.positionedNodes[node.id] === undefined) {
            const spacing = this.options.hierarchical.nodeSpacing;
            let pos = spacing * handledNodeCount;
            // We get the X or Y values we need and store them in pos and previousPos.
            // The get and set make sure we get X or Y
            if (handledNodeCount > 0) {
              pos = this.direction.getPosition(nodeArray[i - 1]) + spacing;
            }
            this.direction.setPosition(node, pos, level);
            this._validatePositionAndContinue(node, level, pos);
            handledNodeCount++;
          }
        }
      }
    }
  }

  /**
   * This is a recursively called function to enumerate the branches from the largest hubs and place the nodes
   * on a X position that ensures there will be no overlap.
   * @param {Node.id} parentId
   * @param {number} parentLevel
   * @private
   */
  _placeBranchNodes(parentId, parentLevel) {
    var _context2;
    const childRef = this.hierarchical.childrenReference[parentId];

    // if this is not a parent, cancel the placing. This can happen with multiple parents to one child.
    if (childRef === undefined) {
      return;
    }

    // get a list of childNodes
    const childNodes = [];
    for (let i = 0; i < childRef.length; i++) {
      childNodes.push(this.body.nodes[childRef[i]]);
    }

    // use the positions to order the nodes.
    _sortInstanceProperty(_context2 = this.direction).call(_context2, childNodes);

    // position the childNodes
    for (let i = 0; i < childNodes.length; i++) {
      const childNode = childNodes[i];
      const childNodeLevel = this.hierarchical.levels[childNode.id];
      // check if the child node is below the parent node and if it has already been positioned.
      if (childNodeLevel > parentLevel && this.positionedNodes[childNode.id] === undefined) {
        // get the amount of space required for this node. If parent the width is based on the amount of children.
        const spacing = this.options.hierarchical.nodeSpacing;
        let pos;

        // we get the X or Y values we need and store them in pos and previousPos.
        // The get and set make sure we get X or Y
        if (i === 0) {
          pos = this.direction.getPosition(this.body.nodes[parentId]);
        } else {
          pos = this.direction.getPosition(childNodes[i - 1]) + spacing;
        }
        this.direction.setPosition(childNode, pos, childNodeLevel);
        this._validatePositionAndContinue(childNode, childNodeLevel, pos);
      } else {
        return;
      }
    }

    // center the parent nodes.
    const center = this._getCenterPosition(childNodes);
    this.direction.setPosition(this.body.nodes[parentId], center, parentLevel);
  }

  /**
   * This method checks for overlap and if required shifts the branch. It also keeps records of positioned nodes.
   * Finally it will call _placeBranchNodes to place the branch nodes.
   * @param {Node} node
   * @param {number} level
   * @param {number} pos
   * @private
   */
  _validatePositionAndContinue(node, level, pos) {
    // This method only works for formal trees and formal forests
    // Early exit if this is not the case
    if (!this.hierarchical.isTree) return;

    // if overlap has been detected, we shift the branch
    if (this.lastNodeOnLevel[level] !== undefined) {
      const previousPos = this.direction.getPosition(this.body.nodes[this.lastNodeOnLevel[level]]);
      if (pos - previousPos < this.options.hierarchical.nodeSpacing) {
        const diff = previousPos + this.options.hierarchical.nodeSpacing - pos;
        const sharedParent = this._findCommonParent(this.lastNodeOnLevel[level], node.id);
        this._shiftBlock(sharedParent.withChild, diff);
      }
    }
    this.lastNodeOnLevel[level] = node.id; // store change in position.
    this.positionedNodes[node.id] = true;
    this._placeBranchNodes(node.id, level);
  }

  /**
   * Receives an array with node indices and returns an array with the actual node references.
   * Used for sorting based on node properties.
   * @param {Array.<Node.id>} idArray
   * @returns {Array.<Node>}
   */
  _indexArrayToNodes(idArray) {
    const array = [];
    for (let i = 0; i < idArray.length; i++) {
      array.push(this.body.nodes[idArray[i]]);
    }
    return array;
  }

  /**
   * This function get the distribution of levels based on hubsize
   * @returns {object}
   * @private
   */
  _getDistribution() {
    const distribution = {};
    let nodeId, node;

    // we fix Y because the hierarchy is vertical,
    // we fix X so we do not give a node an x position for a second time.
    // the fix of X is removed after the x value has been set.
    for (nodeId in this.body.nodes) {
      if (Object.prototype.hasOwnProperty.call(this.body.nodes, nodeId)) {
        node = this.body.nodes[nodeId];
        const level = this.hierarchical.levels[nodeId] === undefined ? 0 : this.hierarchical.levels[nodeId];
        this.direction.fix(node, level);
        if (distribution[level] === undefined) {
          distribution[level] = {};
        }
        distribution[level][nodeId] = node;
      }
    }
    return distribution;
  }

  /**
   * Return the active (i.e. visible) edges for this node
   * @param {Node} node
   * @returns {Array.<vis.Edge>} Array of edge instances
   * @private
   */
  _getActiveEdges(node) {
    const result = [];
    forEach$1(node.edges, edge => {
      var _context3;
      if (_indexOfInstanceProperty(_context3 = this.body.edgeIndices).call(_context3, edge.id) !== -1) {
        result.push(edge);
      }
    });
    return result;
  }

  /**
   * Get the hubsizes for all active nodes.
   * @returns {number}
   * @private
   */
  _getHubSizes() {
    const hubSizes = {};
    const nodeIds = this.body.nodeIndices;
    forEach$1(nodeIds, nodeId => {
      const node = this.body.nodes[nodeId];
      const hubSize = this._getActiveEdges(node).length;
      hubSizes[hubSize] = true;
    });

    // Make an array of the size sorted descending
    const result = [];
    forEach$1(hubSizes, size => {
      result.push(Number(size));
    });
    _sortInstanceProperty(result).call(result, function (a, b) {
      return b - a;
    });
    return result;
  }

  /**
   * this function allocates nodes in levels based on the recursive branching from the largest hubs.
   * @private
   */
  _determineLevelsByHubsize() {
    const levelDownstream = (nodeA, nodeB) => {
      this.hierarchical.levelDownstream(nodeA, nodeB);
    };
    const hubSizes = this._getHubSizes();
    for (let i = 0; i < hubSizes.length; ++i) {
      const hubSize = hubSizes[i];
      if (hubSize === 0) break;
      forEach$1(this.body.nodeIndices, nodeId => {
        const node = this.body.nodes[nodeId];
        if (hubSize === this._getActiveEdges(node).length) {
          this._crawlNetwork(levelDownstream, nodeId);
        }
      });
    }
  }

  /**
   * TODO: release feature
   * TODO: Determine if this feature is needed at all
   * @private
   */
  _determineLevelsCustomCallback() {
    const minLevel = 100000;

    // TODO: this should come from options.
    // eslint-disable-next-line no-unused-vars -- This should eventually be implemented with these parameters used.
    const customCallback = function (nodeA, nodeB, edge) {};

    // TODO: perhaps move to HierarchicalStatus.
    //       But I currently don't see the point, this method is not used.
    const levelByDirection = (nodeA, nodeB, edge) => {
      let levelA = this.hierarchical.levels[nodeA.id];
      // set initial level
      if (levelA === undefined) {
        levelA = this.hierarchical.levels[nodeA.id] = minLevel;
      }
      const diff = customCallback(NetworkUtil.cloneOptions(nodeA, "node"), NetworkUtil.cloneOptions(nodeB, "node"), NetworkUtil.cloneOptions(edge, "edge"));
      this.hierarchical.levels[nodeB.id] = levelA + diff;
    };
    this._crawlNetwork(levelByDirection);
    this.hierarchical.setMinLevelToZero(this.body.nodes);
  }

  /**
   * Allocate nodes in levels based on the direction of the edges.
   * @private
   */
  _determineLevelsDirected() {
    var _context4;
    const nodes = _reduceInstanceProperty(_context4 = this.body.nodeIndices).call(_context4, (acc, id) => {
      acc.set(id, this.body.nodes[id]);
      return acc;
    }, new _Map());
    if (this.options.hierarchical.shakeTowards === "roots") {
      this.hierarchical.levels = fillLevelsByDirectionRoots(nodes);
    } else {
      this.hierarchical.levels = fillLevelsByDirectionLeaves(nodes);
    }
    this.hierarchical.setMinLevelToZero(this.body.nodes);
  }

  /**
   * Update the bookkeeping of parent and child.
   * @private
   */
  _generateMap() {
    const fillInRelations = (parentNode, childNode) => {
      if (this.hierarchical.levels[childNode.id] > this.hierarchical.levels[parentNode.id]) {
        this.hierarchical.addRelation(parentNode.id, childNode.id);
      }
    };
    this._crawlNetwork(fillInRelations);
    this.hierarchical.checkIfTree();
  }

  /**
   * Crawl over the entire network and use a callback on each node couple that is connected to each other.
   * @param {Function} [callback]          | will receive nodeA, nodeB and the connecting edge. A and B are distinct.
   * @param {Node.id} startingNodeId
   * @private
   */
  _crawlNetwork() {
    let callback = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : function () {};
    let startingNodeId = arguments.length > 1 ? arguments[1] : undefined;
    const progress = {};
    const crawler = (node, tree) => {
      if (progress[node.id] === undefined) {
        this.hierarchical.setTreeIndex(node, tree);
        progress[node.id] = true;
        let childNode;
        const edges = this._getActiveEdges(node);
        for (let i = 0; i < edges.length; i++) {
          const edge = edges[i];
          if (edge.connected === true) {
            if (edge.toId == node.id) {
              // Not '===' because id's can be string and numeric
              childNode = edge.from;
            } else {
              childNode = edge.to;
            }
            if (node.id != childNode.id) {
              // Not '!==' because id's can be string and numeric
              callback(node, childNode, edge);
              crawler(childNode, tree);
            }
          }
        }
      }
    };
    if (startingNodeId === undefined) {
      // Crawl over all nodes
      let treeIndex = 0; // Serves to pass a unique id for the current distinct tree

      for (let i = 0; i < this.body.nodeIndices.length; i++) {
        const nodeId = this.body.nodeIndices[i];
        if (progress[nodeId] === undefined) {
          const node = this.body.nodes[nodeId];
          crawler(node, treeIndex);
          treeIndex += 1;
        }
      }
    } else {
      // Crawl from the given starting node
      const node = this.body.nodes[startingNodeId];
      if (node === undefined) {
        console.error("Node not found:", startingNodeId);
        return;
      }
      crawler(node);
    }
  }

  /**
   * Shift a branch a certain distance
   * @param {Node.id} parentId
   * @param {number} diff
   * @private
   */
  _shiftBlock(parentId, diff) {
    const progress = {};
    const shifter = parentId => {
      if (progress[parentId]) {
        return;
      }
      progress[parentId] = true;
      this.direction.shift(parentId, diff);
      const childRef = this.hierarchical.childrenReference[parentId];
      if (childRef !== undefined) {
        for (let i = 0; i < childRef.length; i++) {
          shifter(childRef[i]);
        }
      }
    };
    shifter(parentId);
  }

  /**
   * Find a common parent between branches.
   * @param {Node.id} childA
   * @param {Node.id} childB
   * @returns {{foundParent, withChild}}
   * @private
   */
  _findCommonParent(childA, childB) {
    const parents = {};
    const iterateParents = (parents, child) => {
      const parentRef = this.hierarchical.parentReference[child];
      if (parentRef !== undefined) {
        for (let i = 0; i < parentRef.length; i++) {
          const parent = parentRef[i];
          parents[parent] = true;
          iterateParents(parents, parent);
        }
      }
    };
    const findParent = (parents, child) => {
      const parentRef = this.hierarchical.parentReference[child];
      if (parentRef !== undefined) {
        for (let i = 0; i < parentRef.length; i++) {
          const parent = parentRef[i];
          if (parents[parent] !== undefined) {
            return {
              foundParent: parent,
              withChild: child
            };
          }
          const branch = findParent(parents, parent);
          if (branch.foundParent !== null) {
            return branch;
          }
        }
      }
      return {
        foundParent: null,
        withChild: child
      };
    };
    iterateParents(parents, childA);
    return findParent(parents, childB);
  }

  /**
   * Set the strategy pattern for handling the coordinates given the current direction.
   *
   * The individual instances contain all the operations and data specific to a layout direction.
   * @param {Node} node
   * @param {{x: number, y: number}} position
   * @param {number} level
   * @param {boolean} [doNotUpdate]
   * @private
   */
  setDirectionStrategy() {
    const isVertical = this.options.hierarchical.direction === "UD" || this.options.hierarchical.direction === "DU";
    if (isVertical) {
      this.direction = new VerticalStrategy(this);
    } else {
      this.direction = new HorizontalStrategy(this);
    }
  }

  /**
   * Determine the center position of a branch from the passed list of child nodes
   *
   * This takes into account the positions of all the child nodes.
   * @param {Array.<Node|vis.Node.id>} childNodes  Array of either child nodes or node id's
   * @returns {number}
   * @private
   */
  _getCenterPosition(childNodes) {
    let minPos = 1e9;
    let maxPos = -1e9;
    for (let i = 0; i < childNodes.length; i++) {
      let childNode;
      if (childNodes[i].id !== undefined) {
        childNode = childNodes[i];
      } else {
        const childNodeId = childNodes[i];
        childNode = this.body.nodes[childNodeId];
      }
      const position = this.direction.getPosition(childNode);
      minPos = Math.min(minPos, position);
      maxPos = Math.max(maxPos, position);
    }
    return 0.5 * (minPos + maxPos);
  }
}

/**
 * Clears the toolbar div element of children
 * @private
 */
class ManipulationSystem {
  /**
   * @param {object} body
   * @param {Canvas} canvas
   * @param {SelectionHandler} selectionHandler
   * @param {InteractionHandler} interactionHandler
   */
  constructor(body, canvas, selectionHandler, interactionHandler) {
    var _context, _context2;
    this.body = body;
    this.canvas = canvas;
    this.selectionHandler = selectionHandler;
    this.interactionHandler = interactionHandler;
    this.editMode = false;
    this.manipulationDiv = undefined;
    this.editModeDiv = undefined;
    this.closeDiv = undefined;
    this._domEventListenerCleanupQueue = [];
    this.temporaryUIFunctions = {};
    this.temporaryEventFunctions = [];
    this.touchTime = 0;
    this.temporaryIds = {
      nodes: [],
      edges: []
    };
    this.guiEnabled = false;
    this.inMode = false;
    this.selectedControlNode = undefined;
    this.options = {};
    this.defaultOptions = {
      enabled: false,
      initiallyActive: false,
      addNode: true,
      addEdge: true,
      editNode: undefined,
      editEdge: true,
      deleteNode: true,
      deleteEdge: true,
      controlNodeStyle: {
        shape: "dot",
        size: 6,
        color: {
          background: "#ff0000",
          border: "#3c3c3c",
          highlight: {
            background: "#07f968",
            border: "#3c3c3c"
          }
        },
        borderWidth: 2,
        borderWidthSelected: 2
      }
    };
    _Object$assign(this.options, this.defaultOptions);
    this.body.emitter.on("destroy", () => {
      this._clean();
    });
    this.body.emitter.on("_dataChanged", _bindInstanceProperty(_context = this._restore).call(_context, this));
    this.body.emitter.on("_resetData", _bindInstanceProperty(_context2 = this._restore).call(_context2, this));
  }

  /**
   * If something changes in the data during editing, switch back to the initial datamanipulation state and close all edit modes.
   * @private
   */
  _restore() {
    if (this.inMode !== false) {
      if (this.options.initiallyActive === true) {
        this.enableEditMode();
      } else {
        this.disableEditMode();
      }
    }
  }

  /**
   * Set the Options
   * @param {object} options
   * @param {object} allOptions
   * @param {object} globalOptions
   */
  setOptions(options, allOptions, globalOptions) {
    if (allOptions !== undefined) {
      if (allOptions.locale !== undefined) {
        this.options.locale = allOptions.locale;
      } else {
        this.options.locale = globalOptions.locale;
      }
      if (allOptions.locales !== undefined) {
        this.options.locales = allOptions.locales;
      } else {
        this.options.locales = globalOptions.locales;
      }
    }
    if (options !== undefined) {
      if (typeof options === "boolean") {
        this.options.enabled = options;
      } else {
        this.options.enabled = true;
        deepExtend(this.options, options);
      }
      if (this.options.initiallyActive === true) {
        this.editMode = true;
      }
      this._setup();
    }
  }

  /**
   * Enable or disable edit-mode. Draws the DOM required and cleans up after itself.
   * @private
   */
  toggleEditMode() {
    if (this.editMode === true) {
      this.disableEditMode();
    } else {
      this.enableEditMode();
    }
  }

  /**
   * Enables Edit Mode
   */
  enableEditMode() {
    this.editMode = true;
    this._clean();
    if (this.guiEnabled === true) {
      this.manipulationDiv.style.display = "block";
      this.closeDiv.style.display = "block";
      this.editModeDiv.style.display = "none";
      this.showManipulatorToolbar();
    }
  }

  /**
   * Disables Edit Mode
   */
  disableEditMode() {
    this.editMode = false;
    this._clean();
    if (this.guiEnabled === true) {
      this.manipulationDiv.style.display = "none";
      this.closeDiv.style.display = "none";
      this.editModeDiv.style.display = "block";
      this._createEditButton();
    }
  }

  /**
   * Creates the main toolbar. Removes functions bound to the select event. Binds all the buttons of the toolbar.
   * @private
   */
  showManipulatorToolbar() {
    // restore the state of any bound functions or events, remove control nodes, restore physics
    this._clean();

    // reset global variables
    this.manipulationDOM = {};

    // if the gui is enabled, draw all elements.
    if (this.guiEnabled === true) {
      var _context3, _context4;
      // a _restore will hide these menus
      this.editMode = true;
      this.manipulationDiv.style.display = "block";
      this.closeDiv.style.display = "block";
      const selectedNodeCount = this.selectionHandler.getSelectedNodeCount();
      const selectedEdgeCount = this.selectionHandler.getSelectedEdgeCount();
      const selectedTotalCount = selectedNodeCount + selectedEdgeCount;
      const locale = this.options.locales[this.options.locale];
      let needSeperator = false;
      if (this.options.addNode !== false) {
        this._createAddNodeButton(locale);
        needSeperator = true;
      }
      if (this.options.addEdge !== false) {
        if (needSeperator === true) {
          this._createSeperator(1);
        } else {
          needSeperator = true;
        }
        this._createAddEdgeButton(locale);
      }
      if (selectedNodeCount === 1 && typeof this.options.editNode === "function") {
        if (needSeperator === true) {
          this._createSeperator(2);
        } else {
          needSeperator = true;
        }
        this._createEditNodeButton(locale);
      } else if (selectedEdgeCount === 1 && selectedNodeCount === 0 && this.options.editEdge !== false) {
        if (needSeperator === true) {
          this._createSeperator(3);
        } else {
          needSeperator = true;
        }
        this._createEditEdgeButton(locale);
      }

      // remove buttons
      if (selectedTotalCount !== 0) {
        if (selectedNodeCount > 0 && this.options.deleteNode !== false) {
          if (needSeperator === true) {
            this._createSeperator(4);
          }
          this._createDeleteButton(locale);
        } else if (selectedNodeCount === 0 && this.options.deleteEdge !== false) {
          if (needSeperator === true) {
            this._createSeperator(4);
          }
          this._createDeleteButton(locale);
        }
      }

      // bind the close button
      this._bindElementEvents(this.closeDiv, _bindInstanceProperty(_context3 = this.toggleEditMode).call(_context3, this));

      // refresh this bar based on what has been selected
      this._temporaryBindEvent("select", _bindInstanceProperty(_context4 = this.showManipulatorToolbar).call(_context4, this));
    }

    // redraw to show any possible changes
    this.body.emitter.emit("_redraw");
  }

  /**
   * Create the toolbar for adding Nodes
   */
  addNodeMode() {
    var _context6;
    // when using the gui, enable edit mode if it wasnt already.
    if (this.editMode !== true) {
      this.enableEditMode();
    }

    // restore the state of any bound functions or events, remove control nodes, restore physics
    this._clean();
    this.inMode = "addNode";
    if (this.guiEnabled === true) {
      var _context5;
      const locale = this.options.locales[this.options.locale];
      this.manipulationDOM = {};
      this._createBackButton(locale);
      this._createSeperator();
      this._createDescription(locale["addDescription"] || this.options.locales["en"]["addDescription"]);

      // bind the close button
      this._bindElementEvents(this.closeDiv, _bindInstanceProperty(_context5 = this.toggleEditMode).call(_context5, this));
    }
    this._temporaryBindEvent("click", _bindInstanceProperty(_context6 = this._performAddNode).call(_context6, this));
  }

  /**
   * call the bound function to handle the editing of the node. The node has to be selected.
   */
  editNode() {
    // when using the gui, enable edit mode if it wasnt already.
    if (this.editMode !== true) {
      this.enableEditMode();
    }

    // restore the state of any bound functions or events, remove control nodes, restore physics
    this._clean();
    const node = this.selectionHandler.getSelectedNodes()[0];
    if (node !== undefined) {
      this.inMode = "editNode";
      if (typeof this.options.editNode === "function") {
        if (node.isCluster !== true) {
          const data = deepExtend({}, node.options, false);
          data.x = node.x;
          data.y = node.y;
          if (this.options.editNode.length === 2) {
            this.options.editNode(data, finalizedData => {
              if (finalizedData !== null && finalizedData !== undefined && this.inMode === "editNode") {
                // if for whatever reason the mode has changes (due to dataset change) disregard the callback) {
                this.body.data.nodes.getDataSet().update(finalizedData);
              }
              this.showManipulatorToolbar();
            });
          } else {
            throw new Error("The function for edit does not support two arguments (data, callback)");
          }
        } else {
          alert(this.options.locales[this.options.locale]["editClusterError"] || this.options.locales["en"]["editClusterError"]);
        }
      } else {
        throw new Error("No function has been configured to handle the editing of nodes.");
      }
    } else {
      this.showManipulatorToolbar();
    }
  }

  /**
   * create the toolbar to connect nodes
   */
  addEdgeMode() {
    var _context8, _context9, _context10, _context11, _context12;
    // when using the gui, enable edit mode if it wasnt already.
    if (this.editMode !== true) {
      this.enableEditMode();
    }

    // restore the state of any bound functions or events, remove control nodes, restore physics
    this._clean();
    this.inMode = "addEdge";
    if (this.guiEnabled === true) {
      var _context7;
      const locale = this.options.locales[this.options.locale];
      this.manipulationDOM = {};
      this._createBackButton(locale);
      this._createSeperator();
      this._createDescription(locale["edgeDescription"] || this.options.locales["en"]["edgeDescription"]);

      // bind the close button
      this._bindElementEvents(this.closeDiv, _bindInstanceProperty(_context7 = this.toggleEditMode).call(_context7, this));
    }

    // temporarily overload functions
    this._temporaryBindUI("onTouch", _bindInstanceProperty(_context8 = this._handleConnect).call(_context8, this));
    this._temporaryBindUI("onDragEnd", _bindInstanceProperty(_context9 = this._finishConnect).call(_context9, this));
    this._temporaryBindUI("onDrag", _bindInstanceProperty(_context10 = this._dragControlNode).call(_context10, this));
    this._temporaryBindUI("onRelease", _bindInstanceProperty(_context11 = this._finishConnect).call(_context11, this));
    this._temporaryBindUI("onDragStart", _bindInstanceProperty(_context12 = this._dragStartEdge).call(_context12, this));
    this._temporaryBindUI("onHold", () => {});
  }

  /**
   * create the toolbar to edit edges
   */
  editEdgeMode() {
    // when using the gui, enable edit mode if it wasn't already.
    if (this.editMode !== true) {
      this.enableEditMode();
    }

    // restore the state of any bound functions or events, remove control nodes, restore physics
    this._clean();
    this.inMode = "editEdge";
    if (typeof this.options.editEdge === "object" && typeof this.options.editEdge.editWithoutDrag === "function") {
      this.edgeBeingEditedId = this.selectionHandler.getSelectedEdgeIds()[0];
      if (this.edgeBeingEditedId !== undefined) {
        const edge = this.body.edges[this.edgeBeingEditedId];
        this._performEditEdge(edge.from.id, edge.to.id);
        return;
      }
    }
    if (this.guiEnabled === true) {
      var _context13;
      const locale = this.options.locales[this.options.locale];
      this.manipulationDOM = {};
      this._createBackButton(locale);
      this._createSeperator();
      this._createDescription(locale["editEdgeDescription"] || this.options.locales["en"]["editEdgeDescription"]);

      // bind the close button
      this._bindElementEvents(this.closeDiv, _bindInstanceProperty(_context13 = this.toggleEditMode).call(_context13, this));
    }
    this.edgeBeingEditedId = this.selectionHandler.getSelectedEdgeIds()[0];
    if (this.edgeBeingEditedId !== undefined) {
      var _context14, _context15, _context16, _context17;
      const edge = this.body.edges[this.edgeBeingEditedId];

      // create control nodes
      const controlNodeFrom = this._getNewTargetNode(edge.from.x, edge.from.y);
      const controlNodeTo = this._getNewTargetNode(edge.to.x, edge.to.y);
      this.temporaryIds.nodes.push(controlNodeFrom.id);
      this.temporaryIds.nodes.push(controlNodeTo.id);
      this.body.nodes[controlNodeFrom.id] = controlNodeFrom;
      this.body.nodeIndices.push(controlNodeFrom.id);
      this.body.nodes[controlNodeTo.id] = controlNodeTo;
      this.body.nodeIndices.push(controlNodeTo.id);

      // temporarily overload UI functions, cleaned up automatically because of _temporaryBindUI
      this._temporaryBindUI("onTouch", _bindInstanceProperty(_context14 = this._controlNodeTouch).call(_context14, this)); // used to get the position
      this._temporaryBindUI("onTap", () => {}); // disabled
      this._temporaryBindUI("onHold", () => {}); // disabled
      this._temporaryBindUI("onDragStart", _bindInstanceProperty(_context15 = this._controlNodeDragStart).call(_context15, this)); // used to select control node
      this._temporaryBindUI("onDrag", _bindInstanceProperty(_context16 = this._controlNodeDrag).call(_context16, this)); // used to drag control node
      this._temporaryBindUI("onDragEnd", _bindInstanceProperty(_context17 = this._controlNodeDragEnd).call(_context17, this)); // used to connect or revert control nodes
      this._temporaryBindUI("onMouseMove", () => {}); // disabled

      // create function to position control nodes correctly on movement
      // automatically cleaned up because we use the temporary bind
      this._temporaryBindEvent("beforeDrawing", ctx => {
        const positions = edge.edgeType.findBorderPositions(ctx);
        if (controlNodeFrom.selected === false) {
          controlNodeFrom.x = positions.from.x;
          controlNodeFrom.y = positions.from.y;
        }
        if (controlNodeTo.selected === false) {
          controlNodeTo.x = positions.to.x;
          controlNodeTo.y = positions.to.y;
        }
      });
      this.body.emitter.emit("_redraw");
    } else {
      this.showManipulatorToolbar();
    }
  }

  /**
   * delete everything in the selection
   */
  deleteSelected() {
    // when using the gui, enable edit mode if it wasnt already.
    if (this.editMode !== true) {
      this.enableEditMode();
    }

    // restore the state of any bound functions or events, remove control nodes, restore physics
    this._clean();
    this.inMode = "delete";
    const selectedNodes = this.selectionHandler.getSelectedNodeIds();
    const selectedEdges = this.selectionHandler.getSelectedEdgeIds();
    let deleteFunction = undefined;
    if (selectedNodes.length > 0) {
      for (let i = 0; i < selectedNodes.length; i++) {
        if (this.body.nodes[selectedNodes[i]].isCluster === true) {
          alert(this.options.locales[this.options.locale]["deleteClusterError"] || this.options.locales["en"]["deleteClusterError"]);
          return;
        }
      }
      if (typeof this.options.deleteNode === "function") {
        deleteFunction = this.options.deleteNode;
      }
    } else if (selectedEdges.length > 0) {
      if (typeof this.options.deleteEdge === "function") {
        deleteFunction = this.options.deleteEdge;
      }
    }
    if (typeof deleteFunction === "function") {
      const data = {
        nodes: selectedNodes,
        edges: selectedEdges
      };
      if (deleteFunction.length === 2) {
        deleteFunction(data, finalizedData => {
          if (finalizedData !== null && finalizedData !== undefined && this.inMode === "delete") {
            // if for whatever reason the mode has changes (due to dataset change) disregard the callback) {
            this.body.data.edges.getDataSet().remove(finalizedData.edges);
            this.body.data.nodes.getDataSet().remove(finalizedData.nodes);
            this.body.emitter.emit("startSimulation");
            this.showManipulatorToolbar();
          } else {
            this.body.emitter.emit("startSimulation");
            this.showManipulatorToolbar();
          }
        });
      } else {
        throw new Error("The function for delete does not support two arguments (data, callback)");
      }
    } else {
      this.body.data.edges.getDataSet().remove(selectedEdges);
      this.body.data.nodes.getDataSet().remove(selectedNodes);
      this.body.emitter.emit("startSimulation");
      this.showManipulatorToolbar();
    }
  }

  //********************************************** PRIVATE ***************************************//

  /**
   * draw or remove the DOM
   * @private
   */
  _setup() {
    if (this.options.enabled === true) {
      // Enable the GUI
      this.guiEnabled = true;
      this._createWrappers();
      if (this.editMode === false) {
        this._createEditButton();
      } else {
        this.showManipulatorToolbar();
      }
    } else {
      this._removeManipulationDOM();

      // disable the gui
      this.guiEnabled = false;
    }
  }

  /**
   * create the div overlays that contain the DOM
   * @private
   */
  _createWrappers() {
    // load the manipulator HTML elements. All styling done in css.
    if (this.manipulationDiv === undefined) {
      this.manipulationDiv = document.createElement("div");
      this.manipulationDiv.className = "vis-manipulation";
      if (this.editMode === true) {
        this.manipulationDiv.style.display = "block";
      } else {
        this.manipulationDiv.style.display = "none";
      }
      this.canvas.frame.appendChild(this.manipulationDiv);
    }

    // container for the edit button.
    if (this.editModeDiv === undefined) {
      this.editModeDiv = document.createElement("div");
      this.editModeDiv.className = "vis-edit-mode";
      if (this.editMode === true) {
        this.editModeDiv.style.display = "none";
      } else {
        this.editModeDiv.style.display = "block";
      }
      this.canvas.frame.appendChild(this.editModeDiv);
    }

    // container for the close div button
    if (this.closeDiv === undefined) {
      var _this$options$locales, _this$options$locales2;
      this.closeDiv = document.createElement("button");
      this.closeDiv.className = "vis-close";
      this.closeDiv.setAttribute("aria-label", (_this$options$locales = (_this$options$locales2 = this.options.locales[this.options.locale]) === null || _this$options$locales2 === void 0 ? void 0 : _this$options$locales2["close"]) !== null && _this$options$locales !== void 0 ? _this$options$locales : this.options.locales["en"]["close"]);
      this.closeDiv.style.display = this.manipulationDiv.style.display;
      this.canvas.frame.appendChild(this.closeDiv);
    }
  }

  /**
   * generate a new target node. Used for creating new edges and editing edges
   * @param {number} x
   * @param {number} y
   * @returns {Node}
   * @private
   */
  _getNewTargetNode(x, y) {
    const controlNodeStyle = deepExtend({}, this.options.controlNodeStyle);
    controlNodeStyle.id = "targetNode" + v4();
    controlNodeStyle.hidden = false;
    controlNodeStyle.physics = false;
    controlNodeStyle.x = x;
    controlNodeStyle.y = y;

    // we have to define the bounding box in order for the nodes to be drawn immediately
    const node = this.body.functions.createNode(controlNodeStyle);
    node.shape.boundingBox = {
      left: x,
      right: x,
      top: y,
      bottom: y
    };
    return node;
  }

  /**
   * Create the edit button
   */
  _createEditButton() {
    var _context18;
    // restore everything to it's original state (if applicable)
    this._clean();

    // reset the manipulationDOM
    this.manipulationDOM = {};

    // empty the editModeDiv
    recursiveDOMDelete(this.editModeDiv);

    // create the contents for the editMode button
    const locale = this.options.locales[this.options.locale];
    const button = this._createButton("editMode", "vis-edit vis-edit-mode", locale["edit"] || this.options.locales["en"]["edit"]);
    this.editModeDiv.appendChild(button);

    // bind a hammer listener to the button, calling the function toggleEditMode.
    this._bindElementEvents(button, _bindInstanceProperty(_context18 = this.toggleEditMode).call(_context18, this));
  }

  /**
   * this function cleans up after everything this module does. Temporary elements, functions and events are removed, physics restored, hammers removed.
   * @private
   */
  _clean() {
    // not in mode
    this.inMode = false;

    // _clean the divs
    if (this.guiEnabled === true) {
      recursiveDOMDelete(this.editModeDiv);
      recursiveDOMDelete(this.manipulationDiv);

      // removes all the bindings and overloads
      this._cleanupDOMEventListeners();
    }

    // remove temporary nodes and edges
    this._cleanupTemporaryNodesAndEdges();

    // restore overloaded UI functions
    this._unbindTemporaryUIs();

    // remove the temporaryEventFunctions
    this._unbindTemporaryEvents();

    // restore the physics if required
    this.body.emitter.emit("restorePhysics");
  }

  /**
   * Each dom element has it's own hammer. They are stored in this.manipulationHammers. This cleans them up.
   * @private
   */
  _cleanupDOMEventListeners() {
    // _clean DOM event listener bindings
    for (const callback of _spliceInstanceProperty(_context19 = this._domEventListenerCleanupQueue).call(_context19, 0)) {
      var _context19;
      callback();
    }
  }

  /**
   * Remove all DOM elements created by this module.
   * @private
   */
  _removeManipulationDOM() {
    // removes all the bindings and overloads
    this._clean();

    // empty the manipulation divs
    recursiveDOMDelete(this.manipulationDiv);
    recursiveDOMDelete(this.editModeDiv);
    recursiveDOMDelete(this.closeDiv);

    // remove the manipulation divs
    if (this.manipulationDiv) {
      this.canvas.frame.removeChild(this.manipulationDiv);
    }
    if (this.editModeDiv) {
      this.canvas.frame.removeChild(this.editModeDiv);
    }
    if (this.closeDiv) {
      this.canvas.frame.removeChild(this.closeDiv);
    }

    // set the references to undefined
    this.manipulationDiv = undefined;
    this.editModeDiv = undefined;
    this.closeDiv = undefined;
  }

  /**
   * create a seperator line. the index is to differentiate in the manipulation dom
   * @param {number} [index]
   * @private
   */
  _createSeperator() {
    let index = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 1;
    this.manipulationDOM["seperatorLineDiv" + index] = document.createElement("div");
    this.manipulationDOM["seperatorLineDiv" + index].className = "vis-separator-line";
    this.manipulationDiv.appendChild(this.manipulationDOM["seperatorLineDiv" + index]);
  }

  // ----------------------    DOM functions for buttons    --------------------------//

  /**
   *
   * @param {Locale} locale
   * @private
   */
  _createAddNodeButton(locale) {
    var _context20;
    const button = this._createButton("addNode", "vis-add", locale["addNode"] || this.options.locales["en"]["addNode"]);
    this.manipulationDiv.appendChild(button);
    this._bindElementEvents(button, _bindInstanceProperty(_context20 = this.addNodeMode).call(_context20, this));
  }

  /**
   *
   * @param {Locale} locale
   * @private
   */
  _createAddEdgeButton(locale) {
    var _context21;
    const button = this._createButton("addEdge", "vis-connect", locale["addEdge"] || this.options.locales["en"]["addEdge"]);
    this.manipulationDiv.appendChild(button);
    this._bindElementEvents(button, _bindInstanceProperty(_context21 = this.addEdgeMode).call(_context21, this));
  }

  /**
   *
   * @param {Locale} locale
   * @private
   */
  _createEditNodeButton(locale) {
    var _context22;
    const button = this._createButton("editNode", "vis-edit", locale["editNode"] || this.options.locales["en"]["editNode"]);
    this.manipulationDiv.appendChild(button);
    this._bindElementEvents(button, _bindInstanceProperty(_context22 = this.editNode).call(_context22, this));
  }

  /**
   *
   * @param {Locale} locale
   * @private
   */
  _createEditEdgeButton(locale) {
    var _context23;
    const button = this._createButton("editEdge", "vis-edit", locale["editEdge"] || this.options.locales["en"]["editEdge"]);
    this.manipulationDiv.appendChild(button);
    this._bindElementEvents(button, _bindInstanceProperty(_context23 = this.editEdgeMode).call(_context23, this));
  }

  /**
   *
   * @param {Locale} locale
   * @private
   */
  _createDeleteButton(locale) {
    var _context24;
    let deleteBtnClass;
    if (this.options.rtl) {
      deleteBtnClass = "vis-delete-rtl";
    } else {
      deleteBtnClass = "vis-delete";
    }
    const button = this._createButton("delete", deleteBtnClass, locale["del"] || this.options.locales["en"]["del"]);
    this.manipulationDiv.appendChild(button);
    this._bindElementEvents(button, _bindInstanceProperty(_context24 = this.deleteSelected).call(_context24, this));
  }

  /**
   *
   * @param {Locale} locale
   * @private
   */
  _createBackButton(locale) {
    var _context25;
    const button = this._createButton("back", "vis-back", locale["back"] || this.options.locales["en"]["back"]);
    this.manipulationDiv.appendChild(button);
    this._bindElementEvents(button, _bindInstanceProperty(_context25 = this.showManipulatorToolbar).call(_context25, this));
  }

  /**
   *
   * @param {number|string} id
   * @param {string} className
   * @param {label} label
   * @param {string} labelClassName
   * @returns {HTMLElement}
   * @private
   */
  _createButton(id, className, label) {
    let labelClassName = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : "vis-label";
    this.manipulationDOM[id + "Div"] = document.createElement("button");
    this.manipulationDOM[id + "Div"].className = "vis-button " + className;
    this.manipulationDOM[id + "Label"] = document.createElement("div");
    this.manipulationDOM[id + "Label"].className = labelClassName;
    this.manipulationDOM[id + "Label"].innerText = label;
    this.manipulationDOM[id + "Div"].appendChild(this.manipulationDOM[id + "Label"]);
    return this.manipulationDOM[id + "Div"];
  }

  /**
   *
   * @param {Label} label
   * @private
   */
  _createDescription(label) {
    this.manipulationDOM["descriptionLabel"] = document.createElement("div");
    this.manipulationDOM["descriptionLabel"].className = "vis-none";
    this.manipulationDOM["descriptionLabel"].innerText = label;
    this.manipulationDiv.appendChild(this.manipulationDOM["descriptionLabel"]);
  }

  // -------------------------- End of DOM functions for buttons ------------------------------//

  /**
   * this binds an event until cleanup by the clean functions.
   * @param {Event}  event   The event
   * @param {Function} newFunction
   * @private
   */
  _temporaryBindEvent(event, newFunction) {
    this.temporaryEventFunctions.push({
      event: event,
      boundFunction: newFunction
    });
    this.body.emitter.on(event, newFunction);
  }

  /**
   * this overrides an UI function until cleanup by the clean function
   * @param {string} UIfunctionName
   * @param {Function} newFunction
   * @private
   */
  _temporaryBindUI(UIfunctionName, newFunction) {
    if (this.body.eventListeners[UIfunctionName] !== undefined) {
      this.temporaryUIFunctions[UIfunctionName] = this.body.eventListeners[UIfunctionName];
      this.body.eventListeners[UIfunctionName] = newFunction;
    } else {
      throw new Error("This UI function does not exist. Typo? You tried: " + UIfunctionName + " possible are: " + _JSON$stringify(_Object$keys(this.body.eventListeners)));
    }
  }

  /**
   * Restore the overridden UI functions to their original state.
   * @private
   */
  _unbindTemporaryUIs() {
    for (const functionName in this.temporaryUIFunctions) {
      if (Object.prototype.hasOwnProperty.call(this.temporaryUIFunctions, functionName)) {
        this.body.eventListeners[functionName] = this.temporaryUIFunctions[functionName];
        delete this.temporaryUIFunctions[functionName];
      }
    }
    this.temporaryUIFunctions = {};
  }

  /**
   * Unbind the events created by _temporaryBindEvent
   * @private
   */
  _unbindTemporaryEvents() {
    for (let i = 0; i < this.temporaryEventFunctions.length; i++) {
      const eventName = this.temporaryEventFunctions[i].event;
      const boundFunction = this.temporaryEventFunctions[i].boundFunction;
      this.body.emitter.off(eventName, boundFunction);
    }
    this.temporaryEventFunctions = [];
  }

  /**
   * Bind an hammer instance to a DOM element.
   * @param {Element} domElement
   * @param {Function} boundFunction
   */
  _bindElementEvents(domElement, boundFunction) {
    // Bind touch events.
    const hammer = new Hammer(domElement, {});
    onTouch(hammer, boundFunction);
    this._domEventListenerCleanupQueue.push(() => {
      hammer.destroy();
    });

    // Bind keyboard events.
    const keyupListener = _ref => {
      let {
        keyCode,
        key
      } = _ref;
      if (key === "Enter" || key === " " || keyCode === 13 || keyCode === 32) {
        boundFunction();
      }
    };
    domElement.addEventListener("keyup", keyupListener, false);
    this._domEventListenerCleanupQueue.push(() => {
      domElement.removeEventListener("keyup", keyupListener, false);
    });
  }

  /**
   * Neatly clean up temporary edges and nodes
   * @private
   */
  _cleanupTemporaryNodesAndEdges() {
    // _clean temporary edges
    for (let i = 0; i < this.temporaryIds.edges.length; i++) {
      var _context26;
      this.body.edges[this.temporaryIds.edges[i]].disconnect();
      delete this.body.edges[this.temporaryIds.edges[i]];
      const indexTempEdge = _indexOfInstanceProperty(_context26 = this.body.edgeIndices).call(_context26, this.temporaryIds.edges[i]);
      if (indexTempEdge !== -1) {
        var _context27;
        _spliceInstanceProperty(_context27 = this.body.edgeIndices).call(_context27, indexTempEdge, 1);
      }
    }

    // _clean temporary nodes
    for (let i = 0; i < this.temporaryIds.nodes.length; i++) {
      var _context28;
      delete this.body.nodes[this.temporaryIds.nodes[i]];
      const indexTempNode = _indexOfInstanceProperty(_context28 = this.body.nodeIndices).call(_context28, this.temporaryIds.nodes[i]);
      if (indexTempNode !== -1) {
        var _context29;
        _spliceInstanceProperty(_context29 = this.body.nodeIndices).call(_context29, indexTempNode, 1);
      }
    }
    this.temporaryIds = {
      nodes: [],
      edges: []
    };
  }

  // ------------------------------------------ EDIT EDGE FUNCTIONS -----------------------------------------//

  /**
   * the touch is used to get the position of the initial click
   * @param {Event}  event   The event
   * @private
   */
  _controlNodeTouch(event) {
    this.selectionHandler.unselectAll();
    this.lastTouch = this.body.functions.getPointer(event.center);
    this.lastTouch.translation = _Object$assign({}, this.body.view.translation); // copy the object
  }

  /**
   * the drag start is used to mark one of the control nodes as selected.
   * @private
   */
  _controlNodeDragStart() {
    const pointer = this.lastTouch;
    const pointerObj = this.selectionHandler._pointerToPositionObject(pointer);
    const from = this.body.nodes[this.temporaryIds.nodes[0]];
    const to = this.body.nodes[this.temporaryIds.nodes[1]];
    const edge = this.body.edges[this.edgeBeingEditedId];
    this.selectedControlNode = undefined;
    const fromSelect = from.isOverlappingWith(pointerObj);
    const toSelect = to.isOverlappingWith(pointerObj);
    if (fromSelect === true) {
      this.selectedControlNode = from;
      edge.edgeType.from = from;
    } else if (toSelect === true) {
      this.selectedControlNode = to;
      edge.edgeType.to = to;
    }

    // we use the selection to find the node that is being dragged. We explicitly select it here.
    if (this.selectedControlNode !== undefined) {
      this.selectionHandler.selectObject(this.selectedControlNode);
    }
    this.body.emitter.emit("_redraw");
  }

  /**
   * dragging the control nodes or the canvas
   * @param {Event}  event   The event
   * @private
   */
  _controlNodeDrag(event) {
    this.body.emitter.emit("disablePhysics");
    const pointer = this.body.functions.getPointer(event.center);
    const pos = this.canvas.DOMtoCanvas(pointer);
    if (this.selectedControlNode !== undefined) {
      this.selectedControlNode.x = pos.x;
      this.selectedControlNode.y = pos.y;
    } else {
      this.interactionHandler.onDrag(event);
    }
    this.body.emitter.emit("_redraw");
  }

  /**
   * connecting or restoring the control nodes.
   * @param {Event}  event   The event
   * @private
   */
  _controlNodeDragEnd(event) {
    const pointer = this.body.functions.getPointer(event.center);
    const pointerObj = this.selectionHandler._pointerToPositionObject(pointer);
    const edge = this.body.edges[this.edgeBeingEditedId];
    // if the node that was dragged is not a control node, return
    if (this.selectedControlNode === undefined) {
      return;
    }

    // we use the selection to find the node that is being dragged. We explicitly DEselect the control node here.
    this.selectionHandler.unselectAll();
    const overlappingNodeIds = this.selectionHandler._getAllNodesOverlappingWith(pointerObj);
    let node = undefined;
    for (let i = overlappingNodeIds.length - 1; i >= 0; i--) {
      if (overlappingNodeIds[i] !== this.selectedControlNode.id) {
        node = this.body.nodes[overlappingNodeIds[i]];
        break;
      }
    }
    // perform the connection
    if (node !== undefined && this.selectedControlNode !== undefined) {
      if (node.isCluster === true) {
        alert(this.options.locales[this.options.locale]["createEdgeError"] || this.options.locales["en"]["createEdgeError"]);
      } else {
        const from = this.body.nodes[this.temporaryIds.nodes[0]];
        if (this.selectedControlNode.id === from.id) {
          this._performEditEdge(node.id, edge.to.id);
        } else {
          this._performEditEdge(edge.from.id, node.id);
        }
      }
    } else {
      edge.updateEdgeType();
      this.body.emitter.emit("restorePhysics");
    }
    this.body.emitter.emit("_redraw");
  }

  // ------------------------------------ END OF EDIT EDGE FUNCTIONS -----------------------------------------//

  // ------------------------------------------- ADD EDGE FUNCTIONS -----------------------------------------//
  /**
   * the function bound to the selection event. It checks if you want to connect a cluster and changes the description
   * to walk the user through the process.
   * @param {Event} event
   * @private
   */
  _handleConnect(event) {
    // check to avoid double fireing of this function.
    if (new Date().valueOf() - this.touchTime > 100) {
      this.lastTouch = this.body.functions.getPointer(event.center);
      this.lastTouch.translation = _Object$assign({}, this.body.view.translation); // copy the object

      this.interactionHandler.drag.pointer = this.lastTouch; // Drag pointer is not updated when adding edges
      this.interactionHandler.drag.translation = this.lastTouch.translation;
      const pointer = this.lastTouch;
      const node = this.selectionHandler.getNodeAt(pointer);
      if (node !== undefined) {
        if (node.isCluster === true) {
          alert(this.options.locales[this.options.locale]["createEdgeError"] || this.options.locales["en"]["createEdgeError"]);
        } else {
          // create a node the temporary line can look at
          const targetNode = this._getNewTargetNode(node.x, node.y);
          this.body.nodes[targetNode.id] = targetNode;
          this.body.nodeIndices.push(targetNode.id);

          // create a temporary edge
          const connectionEdge = this.body.functions.createEdge({
            id: "connectionEdge" + v4(),
            from: node.id,
            to: targetNode.id,
            physics: false,
            smooth: {
              enabled: true,
              type: "continuous",
              roundness: 0.5
            }
          });
          this.body.edges[connectionEdge.id] = connectionEdge;
          this.body.edgeIndices.push(connectionEdge.id);
          this.temporaryIds.nodes.push(targetNode.id);
          this.temporaryIds.edges.push(connectionEdge.id);
        }
      }
      this.touchTime = new Date().valueOf();
    }
  }

  /**
   *
   * @param {Event} event
   * @private
   */
  _dragControlNode(event) {
    const pointer = this.body.functions.getPointer(event.center);
    const pointerObj = this.selectionHandler._pointerToPositionObject(pointer);
    // remember the edge id
    let connectFromId = undefined;
    if (this.temporaryIds.edges[0] !== undefined) {
      connectFromId = this.body.edges[this.temporaryIds.edges[0]].fromId;
    }

    // get the overlapping node but NOT the temporary node;
    const overlappingNodeIds = this.selectionHandler._getAllNodesOverlappingWith(pointerObj);
    let node = undefined;
    for (let i = overlappingNodeIds.length - 1; i >= 0; i--) {
      var _context30;
      // if the node id is NOT a temporary node, accept the node.
      if (_indexOfInstanceProperty(_context30 = this.temporaryIds.nodes).call(_context30, overlappingNodeIds[i]) === -1) {
        node = this.body.nodes[overlappingNodeIds[i]];
        break;
      }
    }
    event.controlEdge = {
      from: connectFromId,
      to: node ? node.id : undefined
    };
    this.selectionHandler.generateClickEvent("controlNodeDragging", event, pointer);
    if (this.temporaryIds.nodes[0] !== undefined) {
      const targetNode = this.body.nodes[this.temporaryIds.nodes[0]]; // there is only one temp node in the add edge mode.
      targetNode.x = this.canvas._XconvertDOMtoCanvas(pointer.x);
      targetNode.y = this.canvas._YconvertDOMtoCanvas(pointer.y);
      this.body.emitter.emit("_redraw");
    } else {
      this.interactionHandler.onDrag(event);
    }
  }

  /**
   * Connect the new edge to the target if one exists, otherwise remove temp line
   * @param {Event}  event   The event
   * @private
   */
  _finishConnect(event) {
    const pointer = this.body.functions.getPointer(event.center);
    const pointerObj = this.selectionHandler._pointerToPositionObject(pointer);

    // remember the edge id
    let connectFromId = undefined;
    if (this.temporaryIds.edges[0] !== undefined) {
      connectFromId = this.body.edges[this.temporaryIds.edges[0]].fromId;
    }

    // get the overlapping node but NOT the temporary node;
    const overlappingNodeIds = this.selectionHandler._getAllNodesOverlappingWith(pointerObj);
    let node = undefined;
    for (let i = overlappingNodeIds.length - 1; i >= 0; i--) {
      var _context31;
      // if the node id is NOT a temporary node, accept the node.
      if (_indexOfInstanceProperty(_context31 = this.temporaryIds.nodes).call(_context31, overlappingNodeIds[i]) === -1) {
        node = this.body.nodes[overlappingNodeIds[i]];
        break;
      }
    }

    // clean temporary nodes and edges.
    this._cleanupTemporaryNodesAndEdges();

    // perform the connection
    if (node !== undefined) {
      if (node.isCluster === true) {
        alert(this.options.locales[this.options.locale]["createEdgeError"] || this.options.locales["en"]["createEdgeError"]);
      } else {
        if (this.body.nodes[connectFromId] !== undefined && this.body.nodes[node.id] !== undefined) {
          this._performAddEdge(connectFromId, node.id);
        }
      }
    }
    event.controlEdge = {
      from: connectFromId,
      to: node ? node.id : undefined
    };
    this.selectionHandler.generateClickEvent("controlNodeDragEnd", event, pointer);

    // No need to do _generateclickevent('dragEnd') here, the regular dragEnd event fires.
    this.body.emitter.emit("_redraw");
  }

  /**
   *
   * @param {Event} event
   * @private
   */
  _dragStartEdge(event) {
    const pointer = this.lastTouch;
    this.selectionHandler.generateClickEvent("dragStart", event, pointer, undefined, true);
  }

  // --------------------------------------- END OF ADD EDGE FUNCTIONS -------------------------------------//

  // ------------------------------ Performing all the actual data manipulation ------------------------//

  /**
   * Adds a node on the specified location
   * @param {object} clickData
   * @private
   */
  _performAddNode(clickData) {
    const defaultData = {
      id: v4(),
      x: clickData.pointer.canvas.x,
      y: clickData.pointer.canvas.y,
      label: "new"
    };
    if (typeof this.options.addNode === "function") {
      if (this.options.addNode.length === 2) {
        this.options.addNode(defaultData, finalizedData => {
          if (finalizedData !== null && finalizedData !== undefined && this.inMode === "addNode") {
            // if for whatever reason the mode has changes (due to dataset change) disregard the callback
            this.body.data.nodes.getDataSet().add(finalizedData);
          }
          this.showManipulatorToolbar();
        });
      } else {
        this.showManipulatorToolbar();
        throw new Error("The function for add does not support two arguments (data,callback)");
      }
    } else {
      this.body.data.nodes.getDataSet().add(defaultData);
      this.showManipulatorToolbar();
    }
  }

  /**
   * connect two nodes with a new edge.
   * @param {Node.id} sourceNodeId
   * @param {Node.id} targetNodeId
   * @private
   */
  _performAddEdge(sourceNodeId, targetNodeId) {
    const defaultData = {
      from: sourceNodeId,
      to: targetNodeId
    };
    if (typeof this.options.addEdge === "function") {
      if (this.options.addEdge.length === 2) {
        this.options.addEdge(defaultData, finalizedData => {
          if (finalizedData !== null && finalizedData !== undefined && this.inMode === "addEdge") {
            // if for whatever reason the mode has changes (due to dataset change) disregard the callback
            this.body.data.edges.getDataSet().add(finalizedData);
            this.sel