/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.eclipse.californium.core.CoapResource;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.config.CoapConfig;
import org.eclipse.californium.core.network.CoapEndpoint;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.core.network.EndpointObserver;
import org.eclipse.californium.core.observe.ObserveHealth;
import org.eclipse.californium.core.server.MessageDeliverer;
import org.eclipse.californium.core.server.ServerInterface;
import org.eclipse.californium.core.server.ServerMessageDeliverer;
import org.eclipse.californium.core.server.resources.CoapExchange;
import org.eclipse.californium.core.server.resources.DiscoveryResource;
import org.eclipse.californium.core.server.resources.Resource;
import org.eclipse.californium.elements.Connector;
import org.eclipse.californium.elements.PersistentComponent;
import org.eclipse.californium.elements.PersistentComponentProvider;
import org.eclipse.californium.elements.config.BasicDefinition;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.californium.elements.util.CounterStatisticManager;
import org.eclipse.californium.elements.util.ExecutorsUtil;
import org.eclipse.californium.elements.util.NamedThreadFactory;
import org.eclipse.californium.elements.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoapServer
implements ServerInterface,
PersistentComponentProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(CoapServer.class);
    private final Resource root;
    private final Configuration config;
    private MessageDeliverer deliverer;
    private ObserveHealth observeHealth;
    private final List<Endpoint> endpoints = new CopyOnWriteArrayList<Endpoint>();
    private final List<EndpointObserver> defaultObservers = new CopyOnWriteArrayList<EndpointObserver>();
    private final List<CounterStatisticManager> statistics = new CopyOnWriteArrayList<CounterStatisticManager>();
    private ScheduledExecutorService executor;
    private ScheduledExecutorService secondaryExecutor;
    private boolean detachExecutor;
    private volatile boolean running;
    private volatile String tag;

    public CoapServer() {
        this(Configuration.getStandard(), new int[0]);
    }

    public CoapServer(int ... ports) {
        this(Configuration.getStandard(), ports);
    }

    public CoapServer(Configuration config, int ... ports) {
        this.config = config != null ? config : Configuration.getStandard();
        this.setTag(null);
        this.root = this.createRoot();
        this.deliverer = new ServerMessageDeliverer(this.root, config);
        CoapResource wellKnown = new CoapResource(".well-known");
        wellKnown.setVisible(false);
        wellKnown.add((CoapResource)new DiscoveryResource(this.root));
        this.root.add(wellKnown);
        if (ports != null) {
            for (int port : ports) {
                CoapEndpoint.Builder builder = new CoapEndpoint.Builder();
                builder.setPort(port);
                builder.setConfiguration(config);
                this.addEndpoint(builder.build());
            }
        }
    }

    public void setVersion(String version) {
        if (this.root instanceof RootResource) {
            ((RootResource)this.root).setVersion(version);
        }
    }

    public synchronized void setExecutors(ScheduledExecutorService mainExecutor, ScheduledExecutorService secondaryExecutor, boolean detach) {
        if (mainExecutor == null || secondaryExecutor == null) {
            throw new NullPointerException("executors must not be null");
        }
        if (this.executor == mainExecutor && this.secondaryExecutor == secondaryExecutor) {
            return;
        }
        if (this.running) {
            throw new IllegalStateException("executor service can not be set on running server");
        }
        if (!this.detachExecutor) {
            if (this.executor != null) {
                this.executor.shutdownNow();
            }
            if (this.secondaryExecutor != null) {
                this.secondaryExecutor.shutdownNow();
            }
        }
        this.executor = mainExecutor;
        this.secondaryExecutor = secondaryExecutor;
        this.detachExecutor = detach;
        for (Endpoint ep : this.endpoints) {
            ep.setExecutors(this.executor, this.secondaryExecutor);
        }
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    @Override
    public synchronized void start() {
        if (this.running) {
            return;
        }
        LOGGER.info("{}Starting server", (Object)this.getTag());
        if (this.executor == null) {
            this.setExecutors(ExecutorsUtil.newScheduledThreadPool((int)((Integer)this.config.get((BasicDefinition)CoapConfig.PROTOCOL_STAGE_THREAD_COUNT)), (ThreadFactory)new NamedThreadFactory("CoapServer(main)#")), ExecutorsUtil.newDefaultSecondaryScheduler((String)"CoapServer(secondary)#"), false);
        }
        if (this.endpoints.isEmpty()) {
            int port = (Integer)this.config.get((BasicDefinition)CoapConfig.COAP_PORT);
            LOGGER.info("{}no endpoints have been defined for server, setting up server endpoint on default port {}", (Object)this.getTag(), (Object)port);
            CoapEndpoint.Builder builder = new CoapEndpoint.Builder();
            builder.setPort(port);
            builder.setConfiguration(this.config);
            this.addEndpoint(builder.build());
        }
        int started = 0;
        for (Endpoint ep : this.endpoints) {
            try {
                ep.start();
                ++started;
            }
            catch (IOException e) {
                LOGGER.error("{}cannot start server endpoint [{}]", new Object[]{this.getTag(), ep.getAddress(), e});
            }
        }
        if (started == 0) {
            throw new IllegalStateException("None of the server endpoints could be started");
        }
        this.running = true;
    }

    @Override
    public synchronized void stop() {
        if (this.running) {
            this.running = false;
            LOGGER.info("{}Stopping server ...", (Object)this.getTag());
            for (Endpoint ep : this.endpoints) {
                ep.stop();
            }
            LOGGER.info("{}Stopped server.", (Object)this.getTag());
        }
    }

    @Override
    public synchronized void destroy() {
        LOGGER.info("{}Destroying server", (Object)this.getTag());
        try {
            if (!this.detachExecutor) {
                if (this.running) {
                    ExecutorsUtil.shutdownExecutorGracefully((long)2000L, (ExecutorService[])new ExecutorService[]{this.executor, this.secondaryExecutor});
                } else {
                    if (this.executor != null) {
                        this.executor.shutdownNow();
                    }
                    if (this.secondaryExecutor != null) {
                        this.secondaryExecutor.shutdownNow();
                    }
                }
            }
        }
        finally {
            for (Endpoint ep : this.endpoints) {
                ep.destroy();
            }
            LOGGER.info("{}CoAP server has been destroyed", (Object)this.getTag());
            this.running = false;
        }
    }

    public void setMessageDeliverer(MessageDeliverer deliverer) {
        if (this.deliverer instanceof ServerMessageDeliverer && this.deliverer != deliverer) {
            ((ServerMessageDeliverer)this.deliverer).setObserveHealth(null);
        }
        this.deliverer = deliverer;
        for (Endpoint endpoint : this.endpoints) {
            endpoint.setMessageDeliverer(deliverer);
        }
        this.setObserveHealth(this.observeHealth);
    }

    public MessageDeliverer getMessageDeliverer() {
        return this.deliverer;
    }

    public void setObserveHealth(ObserveHealth observeHealth) {
        this.observeHealth = observeHealth;
        if (this.deliverer instanceof ServerMessageDeliverer) {
            ((ServerMessageDeliverer)this.deliverer).setObserveHealth(observeHealth);
        }
    }

    @Override
    public void addEndpoint(Endpoint endpoint) {
        endpoint.setMessageDeliverer(this.deliverer);
        if (this.executor != null && this.secondaryExecutor != null) {
            endpoint.setExecutors(this.executor, this.secondaryExecutor);
        }
        for (EndpointObserver observer : this.defaultObservers) {
            endpoint.addObserver(observer);
        }
        this.endpoints.add(endpoint);
    }

    @Override
    public List<Endpoint> getEndpoints() {
        return this.endpoints;
    }

    @Override
    public Endpoint getEndpoint(int port) {
        Endpoint endpoint = null;
        for (Endpoint ep : this.endpoints) {
            if (ep.getAddress().getPort() != port) continue;
            endpoint = ep;
        }
        return endpoint;
    }

    @Override
    public Endpoint getEndpoint(URI uri) {
        Endpoint endpoint = null;
        for (Endpoint ep : this.endpoints) {
            if (!uri.equals(ep.getUri())) continue;
            endpoint = ep;
            break;
        }
        return endpoint;
    }

    @Override
    public Endpoint getEndpoint(InetSocketAddress address) {
        Endpoint endpoint = null;
        for (Endpoint ep : this.endpoints) {
            if (!address.equals(ep.getAddress())) continue;
            endpoint = ep;
            break;
        }
        return endpoint;
    }

    public Collection<PersistentComponent> getComponents() {
        ArrayList<PersistentComponent> components = new ArrayList<PersistentComponent>();
        for (Endpoint endpoint : this.endpoints) {
            Connector connector;
            if (!(endpoint instanceof CoapEndpoint) || !((connector = ((CoapEndpoint)endpoint).getConnector()) instanceof PersistentComponent)) continue;
            components.add((PersistentComponent)connector);
        }
        return components;
    }

    @Override
    public CoapServer add(Resource ... resources) {
        for (Resource r : resources) {
            this.root.add(r);
        }
        return this;
    }

    @Override
    public boolean remove(Resource resource) {
        return this.root.delete(resource);
    }

    public void addDefaultEndpointObserver(EndpointObserver observer) {
        this.defaultObservers.add(observer);
        for (Endpoint ep : this.getEndpoints()) {
            ep.addObserver(observer);
        }
    }

    public void removeDefaultEndpointObserver(EndpointObserver observer) {
        this.defaultObservers.remove(observer);
        for (Endpoint ep : this.getEndpoints()) {
            ep.removeObserver(observer);
        }
    }

    public void add(CounterStatisticManager statistic) {
        this.statistics.add(statistic);
    }

    public void remove(CounterStatisticManager statistic) {
        this.statistics.remove(statistic);
    }

    public void dump() {
        for (CounterStatisticManager statistic : this.statistics) {
            statistic.dump();
        }
    }

    public void setTag(String tag) {
        this.tag = StringUtil.normalizeLoggingTag((String)tag);
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    public Resource getRoot() {
        return this.root;
    }

    public Configuration getConfig() {
        return this.config;
    }

    protected Resource createRoot() {
        return new RootResource();
    }

    private class RootResource
    extends CoapResource {
        private volatile String msg;

        public RootResource() {
            super("");
            this.setVersion(StringUtil.CALIFORNIUM_VERSION);
        }

        private void setVersion(String version) {
            String title = "CoAP RFC 7252";
            if (version != null && !version.isEmpty()) {
                title = String.format("%s %50s", title, "Cf " + version);
            }
            title = title + "\n";
            StringBuilder builder = new StringBuilder().append("****************************************************************\n").append(title).append("****************************************************************\n").append("This server is using the Eclipse Californium (Cf) CoAP framework\n").append("published under EPL+EDL: http://www.eclipse.org/californium/\n\n");
            String note = StringUtil.getConfiguration((String)"COAP_ROOT_RESOURCE_NOTE");
            if (note != null) {
                builder.append(note).append("\n\n");
            }
            builder.append("(c) 2014-2023 Institute for Pervasive Computing, ETH Zurich\n              and others\n");
            String footer = StringUtil.getConfiguration((String)"COAP_ROOT_RESOURCE_FOOTER");
            if (footer != null) {
                builder.append(footer).append("\n");
            }
            builder.append("****************************************************************");
            this.msg = builder.toString();
        }

        @Override
        public void handleGET(CoapExchange exchange) {
            exchange.respond(CoAP.ResponseCode.CONTENT, this.msg);
        }
    }
}

