/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.transport.mqtt;

import java.nio.charset.StandardCharsets;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault
public class MqttWillAndTestament {
    private static final int DFL_QOS = 0;
    private static final boolean DFL_RETAIN = false;
    private final String topic;
    private final byte @Nullable [] payload;
    private final int qos;
    private final boolean retain;

    public static @Nullable MqttWillAndTestament fromString(@Nullable String string) {
        return MqttWillAndTestament.fromString(string, null, null, null, null);
    }

    public static @Nullable MqttWillAndTestament fromString(@Nullable String string, @Nullable String topic, byte @Nullable [] payload, @Nullable Integer qos, @Nullable Boolean retain) {
        String tmpTopic = null;
        byte[] tmpPayload = null;
        int tmpQos = 0;
        boolean tmpRetain = false;
        if (string != null) {
            String[] components = string.split(":");
            int i = 0;
            while (i < Math.min(components.length, 4)) {
                String component = components[i];
                String value = component == null ? "" : component.trim();
                switch (i) {
                    case 0: {
                        tmpTopic = value;
                        break;
                    }
                    case 1: {
                        tmpPayload = value.getBytes(StandardCharsets.UTF_8);
                        break;
                    }
                    case 2: {
                        int tmp;
                        if ("".equals(value) || (tmp = Integer.parseInt(value)) < 0 || tmp > 2) break;
                        tmpQos = tmp;
                        break;
                    }
                    case 3: {
                        tmpRetain = Boolean.parseBoolean(value);
                    }
                }
                ++i;
            }
        }
        if (topic != null) {
            tmpTopic = topic;
        }
        if (payload != null) {
            tmpPayload = payload;
        }
        if (qos != null) {
            tmpQos = qos;
        }
        if (retain != null) {
            tmpRetain = retain;
        }
        if (tmpTopic == null || tmpTopic.isEmpty()) {
            return null;
        }
        return new MqttWillAndTestament(tmpTopic, tmpPayload, tmpQos, tmpRetain);
    }

    public MqttWillAndTestament(String topic, byte @Nullable [] payload, int qos, boolean retain) {
        if (topic == null || topic.isBlank()) {
            throw new IllegalArgumentException("Topic must be set");
        }
        this.topic = topic;
        this.payload = payload;
        this.qos = qos;
        this.retain = retain;
    }

    public String getTopic() {
        return this.topic;
    }

    public byte @Nullable [] getPayload() {
        return this.payload;
    }

    public int getQos() {
        return this.qos;
    }

    public boolean isRetain() {
        return this.retain;
    }

    public String toString() {
        Object object;
        byte[] localPayload = this.payload;
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(this.getClass());
        sb.append("] Send '");
        if (localPayload == null) {
            object = localPayload;
        } else {
            String string;
            object = string;
            string = new String(localPayload);
        }
        sb.append(object);
        sb.append("' to topic '");
        sb.append(this.topic);
        sb.append("'");
        if (this.retain) {
            sb.append(" retained");
        }
        sb.append(" using qos mode ").append(this.qos);
        return sb.toString();
    }
}

