/*
 * Decompiled with CFR 0.152.
 */
package io.methvin.watcher.changeset;

import io.methvin.watcher.changeset.ChangeSet;
import io.methvin.watcher.changeset.ChangeSetEntry;
import io.methvin.watcher.changeset.ChangeSetImpl;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

final class ChangeSetBuilder {
    private final Map<Path, ChangeSetEntry> createdMap = new HashMap<Path, ChangeSetEntry>();
    private final Map<Path, ChangeSetEntry> modifiedMap = new HashMap<Path, ChangeSetEntry>();
    private final Map<Path, ChangeSetEntry> deletedMap = new HashMap<Path, ChangeSetEntry>();

    ChangeSetBuilder() {
    }

    void addCreated(ChangeSetEntry changeSetEntry) {
        Path path = changeSetEntry.path();
        this.modifiedMap.remove(path);
        if (this.deletedMap.remove(path) == null) {
            this.createdMap.put(path, changeSetEntry);
        } else {
            this.modifiedMap.put(path, changeSetEntry);
        }
    }

    void addModified(ChangeSetEntry changeSetEntry) {
        Path path = changeSetEntry.path();
        if (this.createdMap.containsKey(path)) {
            this.createdMap.put(path, changeSetEntry);
        } else {
            this.modifiedMap.put(path, changeSetEntry);
        }
    }

    void addDeleted(ChangeSetEntry changeSetEntry) {
        boolean bl;
        Path path = changeSetEntry.path();
        boolean bl2 = bl = this.createdMap.remove(path) != null;
        if (!bl) {
            this.modifiedMap.remove(path);
            this.deletedMap.put(path, changeSetEntry);
        }
    }

    ChangeSet toChangeSet() {
        return new ChangeSetImpl(new HashSet<ChangeSetEntry>(this.createdMap.values()), new HashSet<ChangeSetEntry>(this.modifiedMap.values()), new HashSet<ChangeSetEntry>(this.deletedMap.values()));
    }
}

