/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.jollyday.core.parser.predicates;

import de.focus_shift.jollyday.core.spi.Limited;
import java.time.Period;
import java.time.Year;
import java.util.function.Predicate;

public class ValidCycle
implements Predicate<Limited> {
    private final Year year;

    public ValidCycle(Year year) {
        this.year = year;
    }

    @Override
    public boolean test(Limited limited) {
        switch (limited.cycle()) {
            case EVERY_YEAR: {
                return true;
            }
            case ODD_YEARS: {
                return this.year.getValue() % 2 != 0;
            }
            case EVEN_YEARS: {
                return this.year.getValue() % 2 == 0;
            }
            case TWO_YEARS: {
                return this.isValidWithReferenceYear(limited, Period.ofYears(2));
            }
            case THREE_YEARS: {
                return this.isValidWithReferenceYear(limited, Period.ofYears(3));
            }
            case FOUR_YEARS: {
                return this.isValidWithReferenceYear(limited, Period.ofYears(4));
            }
            case FIVE_YEARS: {
                return this.isValidWithReferenceYear(limited, Period.ofYears(5));
            }
            case SIX_YEARS: {
                return this.isValidWithReferenceYear(limited, Period.ofYears(6));
            }
        }
        throw new IllegalArgumentException("Cannot handle unknown cycle type '" + String.valueOf((Object)limited.cycle()) + "'.");
    }

    private boolean isValidWithReferenceYear(Limited limited, Period cycleYears) {
        if (limited.validFrom() != null) {
            return this.year.minusYears(limited.validFrom().getValue()).getValue() % cycleYears.getYears() == 0;
        }
        if (limited.validTo() != null) {
            return limited.validTo().minusYears(this.year.getValue()).getValue() % cycleYears.getYears() == 0;
        }
        throw new IllegalArgumentException("Cannot handle cycle type '" + String.valueOf((Object)limited.cycle()) + "' without any reference year.");
    }
}

