/*
 * Decompiled with CFR 0.152.
 */
package de.focus_shift.jollyday.core;

import de.focus_shift.jollyday.core.HolidayType;
import de.focus_shift.jollyday.core.util.ResourceUtil;
import java.time.LocalDate;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;

public final class Holiday
implements Comparable<Holiday> {
    private int hashCode;
    private final LocalDate actualDate;
    private final LocalDate observedDate;
    private final String propertiesKey;
    private final HolidayType type;

    public Holiday(LocalDate actualDate, String propertiesKey, HolidayType type) {
        this(actualDate, null, propertiesKey, type);
    }

    public Holiday(LocalDate actualDate, LocalDate observedDate, String propertiesKey, HolidayType type) {
        this.type = type;
        this.actualDate = actualDate;
        this.observedDate = observedDate;
        this.propertiesKey = propertiesKey == null ? "" : propertiesKey;
    }

    public LocalDate getDate() {
        return Optional.ofNullable(this.observedDate).orElse(this.actualDate);
    }

    public LocalDate getActualDate() {
        return this.actualDate;
    }

    public Optional<LocalDate> getObservedDate() {
        return Optional.ofNullable(this.observedDate);
    }

    public String getPropertiesKey() {
        return this.propertiesKey;
    }

    public String getDescription() {
        return ResourceUtil.getHolidayDescription(this.getPropertiesKey());
    }

    public String getDescription(Locale locale) {
        return ResourceUtil.getHolidayDescription(locale, this.getPropertiesKey());
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Holiday holiday = (Holiday)obj;
        return Objects.equals(this.getDate(), holiday.getDate()) && Objects.equals(this.propertiesKey, holiday.propertiesKey) && this.type == holiday.type;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Objects.hash(new Object[]{this.getDate(), this.propertiesKey, this.type});
        }
        return this.hashCode;
    }

    public String toString() {
        return this.getDate().toString() + " (" + this.getDescription() + ")";
    }

    public HolidayType getType() {
        return this.type;
    }

    @Override
    public int compareTo(Holiday other) {
        return this.getDate().compareTo(other.getDate());
    }
}

