/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.transport.spi;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.jupnp.model.ServerClientTokens;
import org.jupnp.transport.spi.StreamClientConfiguration;

public abstract class AbstractStreamClientConfiguration
implements StreamClientConfiguration {
    protected ExecutorService requestExecutorService;
    protected int timeoutSeconds = 10;
    protected int logWarningSeconds = 5;
    protected int retryAfterSeconds = (int)TimeUnit.MINUTES.toSeconds(10L);
    protected int retryIterations = 5;

    protected AbstractStreamClientConfiguration(ExecutorService requestExecutorService) {
        this.requestExecutorService = requestExecutorService;
    }

    protected AbstractStreamClientConfiguration(ExecutorService requestExecutorService, int timeoutSeconds) {
        this.requestExecutorService = requestExecutorService;
        this.timeoutSeconds = timeoutSeconds;
    }

    protected AbstractStreamClientConfiguration(ExecutorService requestExecutorService, int timeoutSeconds, int logWarningSeconds) {
        this.requestExecutorService = requestExecutorService;
        this.timeoutSeconds = timeoutSeconds;
        this.logWarningSeconds = logWarningSeconds;
    }

    protected AbstractStreamClientConfiguration(ExecutorService requestExecutorService, int timeoutSeconds, int logWarningSeconds, int retryAfterSeconds, int retryIterations) {
        this.requestExecutorService = requestExecutorService;
        this.timeoutSeconds = timeoutSeconds;
        this.logWarningSeconds = logWarningSeconds;
        this.retryAfterSeconds = retryAfterSeconds;
        this.retryIterations = retryIterations;
    }

    @Override
    public ExecutorService getRequestExecutorService() {
        return this.requestExecutorService;
    }

    @Override
    public int getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    @Override
    public int getRetryIterations() {
        return this.retryIterations;
    }

    @Override
    public int getLogWarningSeconds() {
        return this.logWarningSeconds;
    }

    @Override
    public int getRetryAfterSeconds() {
        return this.retryAfterSeconds;
    }

    @Override
    public String getUserAgentValue(int majorVersion, int minorVersion) {
        return new ServerClientTokens(majorVersion, minorVersion).toString();
    }
}

