/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.websocket.log;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.openhab.core.common.ThreadPoolManager;
import org.openhab.core.io.websocket.log.LogDTO;
import org.openhab.core.io.websocket.log.LogFilterDTO;
import org.openhab.core.io.websocket.log.LogWebSocketAdapter;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebSocket
@NonNullByDefault
public class LogWebSocket
implements LogListener {
    private static final TypeToken<List<String>> STRING_LIST_TYPE = TypeToken.getParameterized(List.class, (Type[])new Type[]{String.class});
    private static final int SEND_PERIOD = 100;
    private static final long FIRST_SEQUENCE = 0L;
    private final Logger logger = LoggerFactory.getLogger(LogWebSocket.class);
    private final LogWebSocketAdapter wsAdapter;
    private final Gson gson;
    private @Nullable Session session;
    private @Nullable RemoteEndpoint remoteEndpoint;
    private final ScheduledExecutorService scheduledExecutorService;
    private @Nullable ScheduledFuture<?> commitScheduledFuture;
    private long lastSentTime = 0L;
    private List<LogDTO> deferredLogs = new ArrayList<LogDTO>();
    private boolean enabled = false;
    private long lastSequence = 0L;
    private List<Pattern> loggerPatterns = List.of();

    public LogWebSocket(Gson gson, LogWebSocketAdapter wsAdapter) {
        this.wsAdapter = wsAdapter;
        this.gson = gson;
        this.scheduledExecutorService = ThreadPoolManager.getScheduledPool((String)"LogWebSocket");
    }

    @OnWebSocketClose
    public void onClose(int statusCode, String reason) {
        if (this.enabled) {
            this.wsAdapter.unregisterListener(this);
        }
        this.stopDeferredScheduledFuture();
        this.session = null;
        this.remoteEndpoint = null;
    }

    @OnWebSocketConnect
    public void onConnect(Session session) {
        RemoteEndpoint remoteEndpoint;
        this.session = session;
        this.remoteEndpoint = remoteEndpoint = session.getRemote();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnWebSocketMessage
    public void onText(String message) {
        LogFilterDTO logFilterDto;
        if ("{}".equals(message)) {
            return;
        }
        this.lastSentTime = Long.MAX_VALUE;
        this.stopDeferredScheduledFuture();
        if (!this.enabled) {
            this.wsAdapter.registerListener(this);
            this.enabled = true;
        }
        RemoteEndpoint remoteEndpoint = this.remoteEndpoint;
        if (this.session == null || remoteEndpoint == null) {
            return;
        }
        try {
            logFilterDto = (LogFilterDTO)this.gson.fromJson(message, LogFilterDTO.class);
        }
        catch (JsonParseException e) {
            this.logger.warn("Failed to parse '{}' to a valid log filter object", (Object)message);
            return;
        }
        this.loggerPatterns = logFilterDto.loggerNames == null ? List.of() : logFilterDto.loggerNames.stream().map(Pattern::compile).toList();
        Long timeStart = logFilterDto.timeStart != null ? logFilterDto.timeStart : Long.valueOf(Long.MIN_VALUE);
        Long timeStop = logFilterDto.timeStop != null ? logFilterDto.timeStop : Long.valueOf(Long.MAX_VALUE);
        Long sequenceStart = logFilterDto.sequenceStart != null ? logFilterDto.sequenceStart : Long.valueOf(this.lastSequence);
        ArrayList<LogEntry> logs = new ArrayList<LogEntry>();
        Enumeration<LogEntry> history = this.wsAdapter.getLog();
        while (history.hasMoreElements()) {
            logs.add(history.nextElement());
        }
        if (logs.isEmpty()) {
            this.lastSentTime = 0L;
            return;
        }
        Predicate<LogEntry> withinTimeRange = log -> log.getTime() >= timeStart && log.getTime() <= timeStop;
        Predicate<LogEntry> withinSequence = log -> log.getSequence() > sequenceStart;
        Predicate<LogEntry> nameMatchesAnyPattern = log -> this.loggerPatterns.stream().anyMatch(pattern -> pattern.matcher(log.getLoggerName()).matches());
        List filteredEvents = logs.stream().filter(withinTimeRange.and(withinSequence)).collect(Collectors.toList());
        List dtoList = filteredEvents.stream().map(this::map).collect(Collectors.toList());
        Collections.sort(dtoList);
        try {
            this.sendMessage(this.gson.toJson(dtoList));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.lastSentTime = System.currentTimeMillis();
        long newestSequence = ((LogEntry)logs.getFirst()).getSequence();
        List<LogDTO> list = this.deferredLogs;
        synchronized (list) {
            Iterator<LogDTO> iterator = this.deferredLogs.iterator();
            while (iterator.hasNext()) {
                LogDTO value = iterator.next();
                if (value.sequence > newestSequence) continue;
                iterator.remove();
            }
        }
        this.flush();
    }

    @OnWebSocketError
    public void onError(Session session, @Nullable Throwable error) {
        if (session != null) {
            session.close();
        }
        String message = error == null ? "<null>" : Objects.requireNonNullElse(error.getMessage(), "<null>");
        this.logger.info("WebSocket error: {}", (Object)message);
        this.onClose(1005, message);
    }

    private synchronized void sendMessage(String message) throws IOException {
        RemoteEndpoint remoteEndpoint = this.remoteEndpoint;
        if (remoteEndpoint == null) {
            return;
        }
        remoteEndpoint.sendString(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logged(@NonNullByDefault(value={}) LogEntry logEntry) {
        if (!this.loggerPatterns.isEmpty() && this.loggerPatterns.stream().noneMatch(LogWebSocket.logPatternMatch(logEntry))) {
            return;
        }
        LogDTO logDTO = this.map(logEntry);
        this.lastSequence = logEntry.getSequence();
        if (this.lastSentTime > System.currentTimeMillis() - 100L) {
            List<LogDTO> list = this.deferredLogs;
            synchronized (list) {
                if (this.deferredLogs.isEmpty()) {
                    this.commitScheduledFuture = this.scheduledExecutorService.schedule(this::flush, this.lastSentTime + 100L - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
                }
                this.deferredLogs.add(logDTO);
            }
        }
        this.lastSentTime = System.currentTimeMillis();
        try {
            this.sendMessage(this.gson.toJson((Object)logDTO));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static Predicate<Pattern> logPatternMatch(LogEntry logEntry) {
        return pattern -> pattern.matcher(logEntry.getLoggerName()).matches();
    }

    private LogDTO map(LogEntry logEntry) {
        String stackTrace;
        if (logEntry.getException() != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            logEntry.getException().printStackTrace(pw);
            stackTrace = sw.toString();
        } else {
            stackTrace = "";
        }
        return new LogDTO(logEntry.getSequence(), logEntry.getLoggerName(), logEntry.getLogLevel(), logEntry.getTime(), logEntry.getMessage(), stackTrace);
    }

    private void stopDeferredScheduledFuture() {
        ScheduledFuture<?> commitScheduledFuture = this.commitScheduledFuture;
        if (commitScheduledFuture != null) {
            commitScheduledFuture.cancel(false);
            commitScheduledFuture = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void flush() {
        this.stopDeferredScheduledFuture();
        List<LogDTO> list = this.deferredLogs;
        synchronized (list) {
            if (!this.deferredLogs.isEmpty()) {
                try {
                    this.sendMessage(this.gson.toJson(this.deferredLogs));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.deferredLogs.clear();
            }
        }
    }
}

