/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.config.discovery.usbserial.windowsregistry.internal;

import com.sun.jna.Platform;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinReg;
import java.time.Duration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.common.ThreadFactoryBuilder;
import org.openhab.core.config.discovery.usbserial.UsbSerialDeviceInformation;
import org.openhab.core.config.discovery.usbserial.UsbSerialDiscovery;
import org.openhab.core.config.discovery.usbserial.UsbSerialDiscoveryListener;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(service={UsbSerialDiscovery.class}, name="usb-serial-discovery-windows")
public class WindowsUsbSerialDiscovery
implements UsbSerialDiscovery {
    protected static final String SERVICE_NAME = "usb-serial-discovery-windows";
    private static final String USB_REGISTRY_ROOT = "SYSTEM\\CurrentControlSet\\Enum\\USB";
    private static final String BACKSLASH = "\\";
    private static final String PREFIX_PID = "PID_";
    private static final String PREFIX_VID = "VID_";
    private static final String PREFIX_HEX = "0x";
    private static final String SPLIT_IDS = "&";
    private static final String SPLIT_VALUES = ";";
    private static final String KEY_MANUFACTURER = "Mfg";
    private static final String KEY_PRODUCT = "DeviceDesc";
    private static final String KEY_DEVICE_PARAMETERS = "Device Parameters";
    private static final String KEY_SERIAL_PORT = "PortName";
    private final Logger logger = LoggerFactory.getLogger(WindowsUsbSerialDiscovery.class);
    private final Set<UsbSerialDiscoveryListener> discoveryListeners = new CopyOnWriteArraySet<UsbSerialDiscoveryListener>();
    private final Duration scanInterval = Duration.ofSeconds(15L);
    private final ScheduledExecutorService scheduler;
    private Set<UsbSerialDeviceInformation> lastScanResult = new HashSet<UsbSerialDeviceInformation>();
    private @Nullable ScheduledFuture<?> scanTask;

    @Activate
    public WindowsUsbSerialDiscovery() {
        this.scheduler = Executors.newSingleThreadScheduledExecutor(ThreadFactoryBuilder.create().withName(SERVICE_NAME).withDaemonThreads(true).build());
    }

    private void announceAddedDevice(UsbSerialDeviceInformation deviceInfo) {
        for (UsbSerialDiscoveryListener listener : this.discoveryListeners) {
            listener.usbSerialDeviceDiscovered(deviceInfo);
        }
    }

    private void announceRemovedDevice(UsbSerialDeviceInformation deviceInfo) {
        for (UsbSerialDiscoveryListener listener : this.discoveryListeners) {
            listener.usbSerialDeviceRemoved(deviceInfo);
        }
    }

    @Deactivate
    public void deactivate() {
        this.stopBackgroundScanning();
        this.lastScanResult.clear();
    }

    public synchronized void doSingleScan() {
        Set<UsbSerialDeviceInformation> scanResult = this.scanAllUsbDevicesInformation();
        Set<UsbSerialDeviceInformation> added = this.setDifference(scanResult, this.lastScanResult);
        Set<UsbSerialDeviceInformation> removed = this.setDifference(this.lastScanResult, scanResult);
        Set<UsbSerialDeviceInformation> unchanged = this.setDifference(scanResult, added);
        this.lastScanResult = scanResult;
        removed.forEach(this::announceRemovedDevice);
        added.forEach(this::announceAddedDevice);
        unchanged.forEach(this::announceAddedDevice);
    }

    private <T> Set<T> setDifference(Set<T> set1, Set<T> set2) {
        HashSet<T> result = new HashSet<T>(set1);
        result.removeAll(set2);
        return result;
    }

    public void registerDiscoveryListener(UsbSerialDiscoveryListener listener) {
        this.discoveryListeners.add(listener);
        for (UsbSerialDeviceInformation deviceInfo : this.lastScanResult) {
            listener.usbSerialDeviceDiscovered(deviceInfo);
        }
    }

    public void unregisterDiscoveryListener(UsbSerialDiscoveryListener listener) {
        this.discoveryListeners.remove(listener);
    }

    public Set<UsbSerialDeviceInformation> scanAllUsbDevicesInformation() {
        String[] deviceKeys;
        if (!Platform.isWindows()) {
            return new HashSet<UsbSerialDeviceInformation>();
        }
        HashSet<UsbSerialDeviceInformation> result = new HashSet<UsbSerialDeviceInformation>();
        try {
            deviceKeys = Advapi32Util.registryGetKeys((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)USB_REGISTRY_ROOT);
        }
        catch (Win32Exception e) {
            this.logger.debug("registryGetKeys failed for {}", (Object)USB_REGISTRY_ROOT, (Object)e);
            return result;
        }
        String[] stringArray = deviceKeys;
        int n = deviceKeys.length;
        int n2 = 0;
        while (n2 < n) {
            block22: {
                String[] ids;
                String deviceKey = stringArray[n2];
                this.logger.trace("{}", (Object)deviceKey);
                if (deviceKey.startsWith(PREFIX_VID) && (ids = deviceKey.split(SPLIT_IDS)).length >= 2 && ids[1].startsWith(PREFIX_PID)) {
                    String[] interfaceNames;
                    int productId;
                    int vendorId;
                    try {
                        vendorId = Integer.decode(PREFIX_HEX + ids[0].substring(4));
                        productId = Integer.decode(PREFIX_HEX + ids[1].substring(4));
                    }
                    catch (NumberFormatException e) {
                        break block22;
                    }
                    String serialNumber = ids.length > 2 ? ids[2] : null;
                    String devicePath = "SYSTEM\\CurrentControlSet\\Enum\\USB\\" + deviceKey;
                    try {
                        interfaceNames = Advapi32Util.registryGetKeys((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)devicePath);
                    }
                    catch (Win32Exception e) {
                        this.logger.debug("registryGetKeys failed for {}", (Object)devicePath, (Object)e);
                        break block22;
                    }
                    int interfaceId = 0;
                    String[] stringArray2 = interfaceNames;
                    int n3 = interfaceNames.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        block23: {
                            String manufacturerString;
                            String[] manufacturerData;
                            Object manufacturerValue;
                            TreeMap values;
                            String interfaceName = stringArray2[n4];
                            this.logger.trace("  interfaceId:{}, interfaceName:{}", (Object)interfaceId, (Object)interfaceName);
                            String interfacePath = devicePath + BACKSLASH + interfaceName;
                            try {
                                values = Advapi32Util.registryGetValues((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)interfacePath);
                            }
                            catch (Win32Exception e) {
                                this.logger.debug("registryGetValues failed for {}", (Object)interfacePath, (Object)e);
                                break block23;
                            }
                            if (this.logger.isTraceEnabled()) {
                                for (Map.Entry value : values.entrySet()) {
                                    this.logger.trace("    {}={}", value.getKey(), value.getValue());
                                }
                            }
                            if ((manufacturerValue = values.get(KEY_MANUFACTURER)) instanceof String && (manufacturerData = (manufacturerString = (String)manufacturerValue).split(SPLIT_VALUES)).length >= 2) {
                                String productString;
                                String[] productData;
                                String manufacturer = manufacturerData[1];
                                Object productValue = values.get(KEY_PRODUCT);
                                if (productValue instanceof String && (productData = (productString = (String)productValue).split(SPLIT_VALUES)).length >= 2) {
                                    String[] interfaceSubKeys;
                                    String product = productData[1];
                                    String serialPort = "";
                                    try {
                                        interfaceSubKeys = Advapi32Util.registryGetKeys((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)interfacePath);
                                    }
                                    catch (Win32Exception e) {
                                        this.logger.debug("registryGetKeys failed for {}", (Object)interfacePath, (Object)e);
                                        break block23;
                                    }
                                    String[] stringArray3 = interfaceSubKeys;
                                    int n5 = interfaceSubKeys.length;
                                    int n6 = 0;
                                    while (n6 < n5) {
                                        block24: {
                                            String interfaceSubKey = stringArray3[n6];
                                            if (KEY_DEVICE_PARAMETERS.equals(interfaceSubKey)) {
                                                String serialPortString;
                                                TreeMap deviceParameterValues;
                                                String deviceParametersPath = interfacePath + BACKSLASH + interfaceSubKey;
                                                try {
                                                    deviceParameterValues = Advapi32Util.registryGetValues((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)deviceParametersPath);
                                                }
                                                catch (Win32Exception e) {
                                                    this.logger.debug("registryGetValues failed for {}", (Object)deviceParametersPath, (Object)e);
                                                    break block24;
                                                }
                                                Object serialPortValue = deviceParameterValues.get(KEY_SERIAL_PORT);
                                                if (!(serialPortValue instanceof String)) break;
                                                serialPort = serialPortString = (String)serialPortValue;
                                                break;
                                            }
                                        }
                                        ++n6;
                                    }
                                    UsbSerialDeviceInformation usbSerialDeviceInformation = new UsbSerialDeviceInformation(vendorId, productId, serialNumber, manufacturer, product, interfaceId, interfaceName, serialPort);
                                    this.logger.debug("Add {}", (Object)usbSerialDeviceInformation);
                                    result.add(usbSerialDeviceInformation);
                                    ++interfaceId;
                                }
                            }
                        }
                        ++n4;
                    }
                }
            }
            ++n2;
        }
        return result;
    }

    public synchronized void startBackgroundScanning() {
        ScheduledFuture<?> scanTask;
        if (Platform.isWindows() && ((scanTask = this.scanTask) == null || scanTask.isDone())) {
            this.scanTask = this.scheduler.scheduleWithFixedDelay(this::doSingleScan, 0L, this.scanInterval.toSeconds(), TimeUnit.SECONDS);
        }
    }

    public synchronized void stopBackgroundScanning() {
        ScheduledFuture<?> scanTask = this.scanTask;
        if (scanTask != null) {
            scanTask.cancel(false);
        }
        this.scanTask = null;
    }
}

