/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.library.items;

import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.items.GenericItem;
import org.openhab.core.library.types.NextPreviousType;
import org.openhab.core.library.types.PlayPauseType;
import org.openhab.core.library.types.RewindFastforwardType;
import org.openhab.core.types.Command;
import org.openhab.core.types.RefreshType;
import org.openhab.core.types.State;
import org.openhab.core.types.TimeSeries;
import org.openhab.core.types.UnDefType;

@NonNullByDefault
public class PlayerItem
extends GenericItem {
    private static final List<Class<? extends State>> ACCEPTED_DATA_TYPES = List.of(PlayPauseType.class, RewindFastforwardType.class, UnDefType.class);
    private static final List<Class<? extends Command>> ACCEPTED_COMMAND_TYPES = List.of(PlayPauseType.class, RewindFastforwardType.class, NextPreviousType.class, RefreshType.class);

    public PlayerItem(String name) {
        super("Player", name);
    }

    PlayerItem(String type, String name) {
        super(type, name);
    }

    @Override
    public List<Class<? extends State>> getAcceptedDataTypes() {
        return ACCEPTED_DATA_TYPES;
    }

    @Override
    public List<Class<? extends Command>> getAcceptedCommandTypes() {
        return ACCEPTED_COMMAND_TYPES;
    }

    public void send(PlayPauseType command) {
        this.internalSend(command);
    }

    public void send(RewindFastforwardType command) {
        this.internalSend(command);
    }

    public void send(NextPreviousType command) {
        this.internalSend(command);
    }

    @Override
    public void setState(State state) {
        if (this.isAcceptedState(ACCEPTED_DATA_TYPES, state)) {
            this.applyState(state);
        } else {
            this.logSetTypeError(state);
        }
    }

    @Override
    public void setTimeSeries(TimeSeries timeSeries) {
        if (timeSeries.getStates().allMatch(s -> s.state() instanceof PlayPauseType || s.state() instanceof RewindFastforwardType)) {
            this.applyTimeSeries(timeSeries);
        } else {
            this.logSetTypeError(timeSeries);
        }
    }
}

