/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.events;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.events.Event;
import org.openhab.core.events.EventFactory;

@NonNullByDefault
public abstract class AbstractEventFactory
implements EventFactory {
    private final Set<String> supportedEventTypes;
    private static final Gson JSONCONVERTER = new GsonBuilder().registerTypeAdapter(ZonedDateTime.class, (Object)new ZonedDateTimeAdapter()).create();

    protected AbstractEventFactory(Set<String> supportedEventTypes) {
        this.supportedEventTypes = Set.copyOf(supportedEventTypes);
    }

    @Override
    public Event createEvent(String eventType, String topic, String payload, @Nullable String source) throws Exception {
        this.assertValidArguments(eventType, topic, payload);
        if (!this.getSupportedEventTypes().contains(eventType)) {
            throw new IllegalArgumentException("The event type '" + eventType + "' is not supported by this factory.");
        }
        return this.createEventByType(eventType, topic, payload, source);
    }

    @Override
    public Set<String> getSupportedEventTypes() {
        return this.supportedEventTypes;
    }

    private void assertValidArguments(String eventType, String topic, String payload) {
        AbstractEventFactory.checkNotNullOrEmpty(eventType, "eventType");
        AbstractEventFactory.checkNotNullOrEmpty(topic, "topic");
        AbstractEventFactory.checkNotNullOrEmpty(payload, "payload");
    }

    protected abstract Event createEventByType(String var1, String var2, String var3, @Nullable String var4) throws Exception;

    protected static String serializePayload(Object payloadObject) {
        return JSONCONVERTER.toJson(payloadObject);
    }

    protected static <T> T deserializePayload(String payload, Class<T> classOfPayload) {
        return (T)JSONCONVERTER.fromJson(payload, classOfPayload);
    }

    protected String[] getTopicElements(String topic) {
        return topic.split("/");
    }

    protected static void checkNotNull(@Nullable Object object, String argumentName) {
        if (object == null) {
            throw new IllegalArgumentException("The argument '" + argumentName + "' must not be null.");
        }
    }

    protected static void checkNotNullOrEmpty(@Nullable String string, String argumentName) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("The argument '" + argumentName + "' must not be null or empty.");
        }
    }

    public static class ZonedDateTimeAdapter
    extends TypeAdapter<ZonedDateTime> {
        public void write(JsonWriter out, @Nullable ZonedDateTime value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                out.value(value.format(DateTimeFormatter.ISO_ZONED_DATE_TIME));
            }
        }

        public @Nullable ZonedDateTime read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            return ZonedDateTime.parse(in.nextString(), DateTimeFormatter.ISO_ZONED_DATE_TIME);
        }
    }
}

