/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.classfile.builder;

import aQute.bnd.classfile.ClassFile;
import aQute.bnd.classfile.ModuleAttribute;
import aQute.bnd.classfile.ModuleMainClassAttribute;
import aQute.bnd.classfile.ModulePackagesAttribute;
import aQute.bnd.classfile.builder.ClassFileBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Set;

public class ModuleInfoBuilder
extends ClassFileBuilder {
    static final ModuleAttribute.Require[] EMPTY_REQUIRE_ARRAY = new ModuleAttribute.Require[0];
    static final ModuleAttribute.Export[] EMPTY_EXPORT_ARRAY = new ModuleAttribute.Export[0];
    static final ModuleAttribute.Open[] EMPTY_OPEN_ARRAY = new ModuleAttribute.Open[0];
    static final ModuleAttribute.Provide[] EMPTY_PROVIDE_ARRAY = new ModuleAttribute.Provide[0];
    private String module_name;
    private int module_flags;
    private String module_version;
    private final List<ModuleAttribute.Require> requires = new ArrayList<ModuleAttribute.Require>();
    private final List<ModuleAttribute.Export> exports = new ArrayList<ModuleAttribute.Export>();
    private final List<ModuleAttribute.Open> opens = new ArrayList<ModuleAttribute.Open>();
    private final List<String> uses = new ArrayList<String>();
    private final List<ModuleAttribute.Provide> provides = new ArrayList<ModuleAttribute.Provide>();
    private String mainClass;
    private final List<String> packages = new ArrayList<String>();

    public ModuleInfoBuilder() {
        super(32768, 53, 0, "module-info", null);
        this.requires.add(new ModuleAttribute.Require("java.base", 32768, null));
    }

    public String module_name() {
        return this.module_name;
    }

    public ModuleInfoBuilder module_name(String module_name) {
        this.module_name = Objects.requireNonNull(module_name);
        return this;
    }

    public String module_version() {
        return this.module_version;
    }

    public ModuleInfoBuilder module_version(String module_version) {
        this.module_version = module_version;
        return this;
    }

    public int module_flags() {
        return this.module_flags;
    }

    public ModuleInfoBuilder module_flags(int module_flags) {
        this.module_flags = module_flags;
        return this;
    }

    public List<ModuleAttribute.Require> requires() {
        return this.requires;
    }

    public ModuleInfoBuilder requires(String moduleName, int flags) {
        return this.requires(moduleName, flags, null);
    }

    public ModuleInfoBuilder requires(String moduleName, int flags, String moduleVersion) {
        Objects.requireNonNull(moduleName);
        ListIterator<ModuleAttribute.Require> iter = this.requires.listIterator();
        while (iter.hasNext()) {
            ModuleAttribute.Require entry = iter.next();
            if (!entry.requires.equals(moduleName)) continue;
            iter.remove();
            break;
        }
        ModuleAttribute.Require require = new ModuleAttribute.Require(moduleName, flags, moduleVersion);
        this.requires.add(require);
        return this;
    }

    public List<ModuleAttribute.Export> exports() {
        return this.exports;
    }

    public ModuleInfoBuilder exports(String binaryPackageName, int flags, Collection<String> toModules) {
        Objects.requireNonNull(binaryPackageName);
        toModules.forEach(Objects::requireNonNull);
        ListIterator<ModuleAttribute.Export> iter = this.exports.listIterator();
        while (iter.hasNext()) {
            ModuleAttribute.Export entry = iter.next();
            if (!entry.exports.equals(binaryPackageName)) continue;
            iter.remove();
            break;
        }
        if (!(toModules instanceof Set)) {
            toModules = new LinkedHashSet<String>(toModules);
        }
        ModuleAttribute.Export export = new ModuleAttribute.Export(binaryPackageName, flags, toModules.toArray(EMPTY_STRING_ARRAY));
        this.exports.add(export);
        this.packages(binaryPackageName);
        return this;
    }

    public ModuleInfoBuilder exports(String binaryPackageName, int flags) {
        return this.exports(binaryPackageName, flags, Collections.emptySet());
    }

    public ModuleInfoBuilder exports(String binaryPackageName, int flags, String toModule) {
        return this.exports(binaryPackageName, flags, Collections.singleton(toModule));
    }

    public ModuleInfoBuilder exports(String binaryPackageName, int flags, String ... toModules) {
        return this.exports(binaryPackageName, flags, Arrays.asList(toModules));
    }

    public List<ModuleAttribute.Open> opens() {
        return this.opens;
    }

    public ModuleInfoBuilder opens(String binaryPackageName, int flags, Collection<String> toModules) {
        Objects.requireNonNull(binaryPackageName);
        toModules.forEach(Objects::requireNonNull);
        ListIterator<ModuleAttribute.Open> iter = this.opens.listIterator();
        while (iter.hasNext()) {
            ModuleAttribute.Open entry = iter.next();
            if (!entry.opens.equals(binaryPackageName)) continue;
            iter.remove();
            break;
        }
        if (!(toModules instanceof Set)) {
            toModules = new LinkedHashSet<String>(toModules);
        }
        ModuleAttribute.Open open = new ModuleAttribute.Open(binaryPackageName, flags, toModules.toArray(EMPTY_STRING_ARRAY));
        this.opens.add(open);
        this.packages(binaryPackageName);
        return this;
    }

    public ModuleInfoBuilder opens(String binaryPackageName, int flags) {
        return this.opens(binaryPackageName, flags, Collections.emptySet());
    }

    public ModuleInfoBuilder opens(String binaryPackageName, int flags, String toModule) {
        return this.opens(binaryPackageName, flags, Collections.singleton(toModule));
    }

    public ModuleInfoBuilder opens(String binaryPackageName, int flags, String ... toModules) {
        return this.opens(binaryPackageName, flags, Arrays.asList(toModules));
    }

    public List<String> uses() {
        return this.uses;
    }

    public ModuleInfoBuilder uses(String binaryClassName) {
        Objects.requireNonNull(binaryClassName);
        if (!this.uses.contains(binaryClassName)) {
            this.uses.add(binaryClassName);
        }
        return this;
    }

    public ModuleInfoBuilder uses(Collection<String> binaryClassNames) {
        for (String u : binaryClassNames) {
            this.uses(u);
        }
        return this;
    }

    public ModuleInfoBuilder uses(String[] binaryClassNames) {
        for (String u : binaryClassNames) {
            this.uses(u);
        }
        return this;
    }

    public ModuleInfoBuilder uses(String binaryClassName, String ... binaryClassNames) {
        this.uses(binaryClassName);
        this.uses(binaryClassNames);
        return this;
    }

    public List<ModuleAttribute.Provide> provides() {
        return this.provides;
    }

    public ModuleInfoBuilder provides(String binaryClassName, Collection<String> binaryWithClassNames) {
        Objects.requireNonNull(binaryClassName);
        if (binaryWithClassNames.isEmpty()) {
            throw new IllegalArgumentException("No module names specified");
        }
        binaryWithClassNames.forEach(Objects::requireNonNull);
        ListIterator<ModuleAttribute.Provide> iter = this.provides.listIterator();
        while (iter.hasNext()) {
            ModuleAttribute.Provide entry = iter.next();
            if (!entry.provides.equals(binaryClassName)) continue;
            iter.remove();
            break;
        }
        if (!(binaryWithClassNames instanceof Set)) {
            binaryWithClassNames = new LinkedHashSet<String>(binaryWithClassNames);
        }
        ModuleAttribute.Provide provide = new ModuleAttribute.Provide(binaryClassName, binaryWithClassNames.toArray(EMPTY_STRING_ARRAY));
        this.provides.add(provide);
        binaryWithClassNames.forEach(c -> {
            int i = c.lastIndexOf(47);
            if (i > 0) {
                String binaryPackageName = c.substring(0, i);
                this.packages(binaryPackageName);
            }
        });
        return this;
    }

    public ModuleInfoBuilder provides(String binaryClassName, String binaryWithClassName) {
        return this.provides(binaryClassName, Collections.singleton(binaryWithClassName));
    }

    public ModuleInfoBuilder provides(String binaryClassName, String ... binaryWithClassNames) {
        return this.provides(binaryClassName, Arrays.asList(binaryWithClassNames));
    }

    public String mainClass() {
        return this.mainClass;
    }

    public ModuleInfoBuilder mainClass(String binaryClassName) {
        this.mainClass = Objects.requireNonNull(binaryClassName);
        return this;
    }

    public List<String> packages() {
        return this.packages;
    }

    public ModuleInfoBuilder packages(String binaryPackageName) {
        Objects.requireNonNull(binaryPackageName);
        if (!this.packages.contains(binaryPackageName)) {
            this.packages.add(binaryPackageName);
        }
        return this;
    }

    public ModuleInfoBuilder packages(Collection<String> binaryPackageNames) {
        for (String p : binaryPackageNames) {
            this.packages(p);
        }
        return this;
    }

    public ModuleInfoBuilder packages(String[] binaryPackageNames) {
        for (String p : binaryPackageNames) {
            this.packages(p);
        }
        return this;
    }

    public ModuleInfoBuilder packages(String binaryPackageName, String ... binaryPackageNames) {
        this.packages(binaryPackageName);
        this.packages(binaryPackageNames);
        return this;
    }

    @Override
    public ClassFile build() {
        this.attributes(new ModuleAttribute(this.module_name(), this.module_flags(), this.module_version(), this.requires().toArray(EMPTY_REQUIRE_ARRAY), this.exports().toArray(EMPTY_EXPORT_ARRAY), this.opens().toArray(EMPTY_OPEN_ARRAY), this.uses().toArray(EMPTY_STRING_ARRAY), this.provides().toArray(EMPTY_PROVIDE_ARRAY)));
        if (!this.packages().isEmpty()) {
            this.attributes(new ModulePackagesAttribute(this.packages().toArray(EMPTY_STRING_ARRAY)));
        }
        if (this.mainClass() != null) {
            this.attributes(new ModuleMainClassAttribute(this.mainClass()));
        }
        return super.build();
    }
}

