/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.ui.internal.chart.defaultchartprovider;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.knowm.xchart.XYChart;
import org.knowm.xchart.XYChartBuilder;
import org.knowm.xchart.XYSeries;
import org.knowm.xchart.style.AxesChartStyler;
import org.knowm.xchart.style.Styler;
import org.knowm.xchart.style.XYStyler;
import org.knowm.xchart.style.markers.None;
import org.openhab.core.items.GroupItem;
import org.openhab.core.items.Item;
import org.openhab.core.items.ItemNotFoundException;
import org.openhab.core.library.types.DecimalType;
import org.openhab.core.library.types.OnOffType;
import org.openhab.core.library.types.OpenClosedType;
import org.openhab.core.library.types.QuantityType;
import org.openhab.core.persistence.FilterCriteria;
import org.openhab.core.persistence.HistoricItem;
import org.openhab.core.persistence.PersistenceService;
import org.openhab.core.persistence.PersistenceServiceRegistry;
import org.openhab.core.persistence.QueryablePersistenceService;
import org.openhab.core.persistence.registry.PersistenceServiceConfiguration;
import org.openhab.core.persistence.registry.PersistenceServiceConfigurationRegistry;
import org.openhab.core.types.State;
import org.openhab.core.ui.chart.ChartProvider;
import org.openhab.core.ui.internal.chart.defaultchartprovider.ChartTheme;
import org.openhab.core.ui.internal.chart.defaultchartprovider.ChartThemeBlack;
import org.openhab.core.ui.internal.chart.defaultchartprovider.ChartThemeBlackTransparent;
import org.openhab.core.ui.internal.chart.defaultchartprovider.ChartThemeBright;
import org.openhab.core.ui.internal.chart.defaultchartprovider.ChartThemeBrightTransparent;
import org.openhab.core.ui.internal.chart.defaultchartprovider.ChartThemeDark;
import org.openhab.core.ui.internal.chart.defaultchartprovider.ChartThemeDarkTransparent;
import org.openhab.core.ui.internal.chart.defaultchartprovider.ChartThemeWhite;
import org.openhab.core.ui.internal.chart.defaultchartprovider.ChartThemeWhiteTransparent;
import org.openhab.core.ui.items.ItemUIRegistry;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(immediate=true)
public class DefaultChartProvider
implements ChartProvider {
    private static final Duration TEN_MINUTES = Duration.ofMinutes(10L);
    private static final Duration ONE_DAY = Duration.ofDays(1L);
    private static final Duration ONE_WEEK = Duration.ofDays(7L);
    private static final ChartTheme CHART_THEME_DEFAULT = new ChartThemeBright();
    private static final Map<String, ChartTheme> CHART_THEMES = Stream.of(CHART_THEME_DEFAULT, new ChartThemeBrightTransparent(), new ChartThemeWhite(), new ChartThemeWhiteTransparent(), new ChartThemeDark(), new ChartThemeDarkTransparent(), new ChartThemeBlack(), new ChartThemeBlackTransparent()).collect(Collectors.toMap(ChartTheme::getThemeName, Function.identity()));
    private static final int DPI_DEFAULT = 96;
    private static final String INTERPOLATION_LINEAR = "linear";
    private static final String INTERPOLATION_STEP = "step";
    private final Logger logger = LoggerFactory.getLogger(DefaultChartProvider.class);
    private final ItemUIRegistry itemUIRegistry;
    private final PersistenceServiceRegistry persistenceServiceRegistry;
    private final PersistenceServiceConfigurationRegistry persistenceServiceConfigurationRegistry;

    @Activate
    public DefaultChartProvider(@Reference ItemUIRegistry itemUIRegistry, @Reference PersistenceServiceRegistry persistenceServiceRegistry, @Reference PersistenceServiceConfigurationRegistry persistenceServiceConfigurationRegistry) {
        this.itemUIRegistry = itemUIRegistry;
        this.persistenceServiceRegistry = persistenceServiceRegistry;
        this.persistenceServiceConfigurationRegistry = persistenceServiceConfigurationRegistry;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Available themes for default chart provider: {}", (Object)String.join((CharSequence)", ", CHART_THEMES.keySet()));
        }
    }

    @Override
    public String getName() {
        return "default";
    }

    @Override
    public BufferedImage createChart(@Nullable String serviceId, @Nullable String theme, ZonedDateTime startTime, ZonedDateTime endTime, int height, int width, @Nullable String items, @Nullable String groups, @Nullable Integer dpiValue, @Nullable String interpolation, @Nullable Boolean legend) throws ItemNotFoundException, IllegalArgumentException {
        return this.createChart(serviceId, theme, startTime, endTime, height, width, items, groups, dpiValue, null, interpolation, legend);
    }

    @Override
    public BufferedImage createChart(@Nullable String serviceId, @Nullable String theme, ZonedDateTime startTime, ZonedDateTime endTime, int height, int width, @Nullable String items, @Nullable String groups, @Nullable Integer dpiValue, @Nullable String yAxisDecimalPattern, @Nullable String interpolation, @Nullable Boolean legend) throws ItemNotFoundException, IllegalArgumentException {
        Item item;
        int n;
        int n2;
        String[] stringArray;
        QueryablePersistenceService qps;
        this.logger.debug("Rendering chart: service: '{}', theme: '{}', startTime: '{}', endTime: '{}', width: '{}', height: '{}', items: '{}', groups: '{}', dpi: '{}', yAxisDecimalPattern: '{}', interpolation: '{}', legend: '{}'", new Object[]{serviceId, theme, startTime, endTime, width, height, items, groups, dpiValue, yAxisDecimalPattern, interpolation, legend});
        PersistenceService service = serviceId == null ? this.persistenceServiceRegistry.getDefault() : this.persistenceServiceRegistry.get(serviceId);
        QueryablePersistenceService persistenceService = service instanceof QueryablePersistenceService ? (qps = (QueryablePersistenceService)service) : (QueryablePersistenceService)this.persistenceServiceRegistry.getAll().stream().filter(QueryablePersistenceService.class::isInstance).findFirst().orElseThrow(() -> new IllegalArgumentException("No Persistence service found."));
        int seriesCounter = 0;
        ChartTheme chartTheme = theme == null ? CHART_THEME_DEFAULT : CHART_THEMES.getOrDefault(theme, CHART_THEME_DEFAULT);
        int dpi = dpiValue != null && dpiValue > 0 ? dpiValue : 96;
        XYChart chart = ((XYChartBuilder)((XYChartBuilder)new XYChartBuilder().width(width)).height(height)).build();
        Duration period = Duration.between(startTime, endTime);
        String pattern = period.compareTo(TEN_MINUTES) <= 0 ? "mm:ss" : (period.compareTo(ONE_DAY) <= 0 ? "HH:mm" : (period.compareTo(ONE_WEEK) <= 0 ? "EEE d" : "d MMM"));
        XYStyler styler = (XYStyler)chart.getStyler();
        styler.setDatePattern(pattern);
        styler.setAxisTickLabelsFont(chartTheme.getAxisTickLabelsFont(dpi));
        styler.setAxisTickLabelsColor(chartTheme.getAxisTickLabelsColor());
        styler.setXAxisMin(Double.valueOf(startTime.toInstant().toEpochMilli()));
        styler.setXAxisMax(Double.valueOf(endTime.toInstant().toEpochMilli()));
        int yAxisSpacing = Math.max(height / 10, chartTheme.getAxisTickLabelsFont(dpi).getSize());
        if (yAxisDecimalPattern != null) {
            styler.setYAxisDecimalPattern(yAxisDecimalPattern);
        }
        styler.setYAxisTickMarkSpacingHint(yAxisSpacing);
        styler.setYAxisLabelAlignment(AxesChartStyler.TextAlignment.Right);
        int xAxisSpacing = Math.max(width / 15, chartTheme.getAxisTickLabelsFont(dpi).getSize() * pattern.length() * 4 / 3);
        styler.setXAxisTickMarkSpacingHint(xAxisSpacing);
        styler.setChartBackgroundColor(chartTheme.getChartBackgroundColor());
        styler.setChartFontColor(chartTheme.getChartFontColor());
        styler.setChartPadding(chartTheme.getChartPadding(dpi));
        styler.setPlotBackgroundColor(chartTheme.getPlotBackgroundColor());
        float plotGridLinesDash = (float)chartTheme.getPlotGridLinesDash(dpi);
        float[] plotGridLinesDashArray = new float[]{plotGridLinesDash, plotGridLinesDash};
        styler.setPlotGridLinesStroke(new BasicStroke((float)chartTheme.getPlotGridLinesWidth(dpi), 0, 2, 10.0f, plotGridLinesDashArray, 0.0f));
        styler.setPlotGridLinesColor(chartTheme.getPlotGridLinesColor());
        styler.setLegendBackgroundColor(chartTheme.getLegendBackgroundColor());
        styler.setLegendFont(chartTheme.getLegendFont(dpi));
        styler.setLegendSeriesLineLength(chartTheme.getLegendSeriesLineLength(dpi));
        LegendPositionDecider legendPositionDecider = new LegendPositionDecider();
        if (items != null) {
            String[] itemNames;
            stringArray = itemNames = items.split(",");
            n2 = itemNames.length;
            n = 0;
            while (n < n2) {
                String itemName = stringArray[n];
                item = this.itemUIRegistry.getItem(itemName);
                if (this.addItem(chart, persistenceService, startTime, endTime, item, seriesCounter, chartTheme, dpi, interpolation, legendPositionDecider)) {
                    ++seriesCounter;
                }
                ++n;
            }
        }
        if (groups != null) {
            String[] groupNames;
            stringArray = groupNames = groups.split(",");
            n2 = groupNames.length;
            n = 0;
            while (n < n2) {
                String groupName = stringArray[n];
                item = this.itemUIRegistry.getItem(groupName);
                if (item instanceof GroupItem) {
                    GroupItem groupItem = (GroupItem)item;
                    for (Item member : groupItem.getMembers()) {
                        if (!this.addItem(chart, persistenceService, startTime, endTime, member, seriesCounter, chartTheme, dpi, interpolation, legendPositionDecider)) continue;
                        ++seriesCounter;
                    }
                } else {
                    throw new ItemNotFoundException("Item '" + item.getName() + "' defined in groups is not a group.");
                }
                ++n;
            }
        }
        Boolean showLegend = null;
        if (seriesCounter == 0) {
            showLegend = false;
            ArrayList<Date> xData = new ArrayList<Date>();
            ArrayList<Integer> yData = new ArrayList<Integer>();
            xData.add(Date.from(startTime.toInstant()));
            yData.add(0);
            xData.add(Date.from(endTime.toInstant()));
            yData.add(0);
            XYSeries series = chart.addSeries("NONE", xData, yData);
            series.setMarker(new None());
            series.setLineStyle(new BasicStroke(0.0f));
        }
        if (showLegend == null) {
            showLegend = legend == null ? Boolean.valueOf(seriesCounter > 1) : legend;
        }
        if (showLegend.booleanValue()) {
            styler.setLegendPosition(legendPositionDecider.getLegendPosition());
        } else {
            styler.setLegendVisible(false);
        }
        BufferedImage lBufferedImage = new BufferedImage(chart.getWidth(), chart.getHeight(), 2);
        Graphics2D lGraphics2D = lBufferedImage.createGraphics();
        chart.paint(lGraphics2D, chart.getWidth(), chart.getHeight());
        return lBufferedImage;
    }

    private double convertData(State state) {
        if (state instanceof DecimalType) {
            DecimalType type = (DecimalType)state;
            return type.doubleValue();
        }
        if (state instanceof QuantityType) {
            QuantityType type = (QuantityType)state;
            return type.doubleValue();
        }
        if (state instanceof OnOffType) {
            return state != OnOffType.OFF ? 1 : 0;
        }
        if (state instanceof OpenClosedType) {
            return state != OpenClosedType.CLOSED ? 1 : 0;
        }
        this.logger.debug("Unsupported item type in chart: {}", state.getClass());
        return 0.0;
    }

    private boolean addItem(XYChart chart, QueryablePersistenceService service, ZonedDateTime timeBegin, ZonedDateTime timeEnd, Item item, int seriesCounter, ChartTheme chartTheme, int dpi, @Nullable String interpolation, LegendPositionDecider legendPositionDecider) {
        Color color = chartTheme.getLineColor(seriesCounter);
        String label = this.itemUIRegistry.getLabel(item.getName());
        if (label == null) {
            label = item.getName();
        } else if (label.contains("[") && label.contains("]")) {
            label = label.substring(0, label.indexOf(91));
        }
        ArrayList<Date> xData = new ArrayList<Date>();
        ArrayList<Number> yData = new ArrayList<Number>();
        State state = null;
        FilterCriteria filter = new FilterCriteria();
        filter.setEndDate(timeBegin);
        String itemName = item.getName();
        PersistenceServiceConfiguration config = (PersistenceServiceConfiguration)this.persistenceServiceConfigurationRegistry.get((Object)service.getId());
        String alias = config != null ? (String)config.getAliases().get(itemName) : null;
        filter.setItemName(itemName);
        filter.setPageSize(1);
        filter.setOrdering(FilterCriteria.Ordering.DESCENDING);
        Iterable result = service.query(filter, alias);
        if (result.iterator().hasNext()) {
            HistoricItem historicItem = (HistoricItem)result.iterator().next();
            state = historicItem.getState();
            xData.add(Date.from(timeBegin.toInstant()));
            yData.add(this.convertData(state));
        }
        filter.setBeginDate(timeBegin);
        filter.setEndDate(timeEnd);
        filter.setPageSize(Integer.MAX_VALUE);
        filter.setOrdering(FilterCriteria.Ordering.ASCENDING);
        result = service.query(filter, alias);
        for (HistoricItem historicItem : result) {
            if (state != null && INTERPOLATION_STEP.equals(interpolation) || (state instanceof OnOffType || state instanceof OpenClosedType) && !INTERPOLATION_LINEAR.equals(interpolation)) {
                xData.add(Date.from(historicItem.getInstant().minus(1L, ChronoUnit.MILLIS)));
                yData.add(this.convertData(state));
            }
            state = historicItem.getState();
            xData.add(Date.from(historicItem.getInstant()));
            yData.add(this.convertData(state));
        }
        if (state != null) {
            xData.add(Date.from(timeEnd.toInstant()));
            yData.add(this.convertData(state));
        }
        if (xData.isEmpty()) {
            return false;
        }
        if (xData.size() == 1) {
            xData.add((Date)xData.getFirst());
            yData.add((Number)yData.getFirst());
        }
        XYSeries series = chart.addSeries(label, xData, yData);
        float lineWidth = (float)chartTheme.getLineWidth(dpi);
        series.setLineStyle(new BasicStroke(lineWidth, 1, 0));
        series.setMarker(new None());
        series.setLineColor(color);
        legendPositionDecider.addData(series, yData);
        return true;
    }

    @Override
    public ChartProvider.ImageType getChartType() {
        return ChartProvider.ImageType.png;
    }

    private static class LegendPositionDecider {
        private int counter = 0;

        private LegendPositionDecider() {
        }

        private void addData(XYSeries series, List<Number> yData) {
            this.counter = (double)yData.getFirst().floatValue() > (series.getYMax() - series.getYMin()) / 2.0 + series.getYMin() ? ++this.counter : --this.counter;
        }

        private Styler.LegendPosition getLegendPosition() {
            return this.counter < 0 ? Styler.LegendPosition.InsideNW : Styler.LegendPosition.InsideSW;
        }
    }
}

