/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.controlpoint;

import java.net.URL;
import org.jupnp.controlpoint.ControlPoint;
import org.jupnp.model.action.ActionException;
import org.jupnp.model.action.ActionInvocation;
import org.jupnp.model.message.UpnpResponse;
import org.jupnp.model.message.control.IncomingActionResponseMessage;
import org.jupnp.model.meta.LocalService;
import org.jupnp.model.meta.RemoteDevice;
import org.jupnp.model.meta.RemoteService;
import org.jupnp.protocol.sync.SendingAction;

public abstract class ActionCallback
implements Runnable {
    protected final ActionInvocation actionInvocation;
    protected ControlPoint controlPoint;

    protected ActionCallback(ActionInvocation actionInvocation, ControlPoint controlPoint) {
        this.actionInvocation = actionInvocation;
        this.controlPoint = controlPoint;
    }

    protected ActionCallback(ActionInvocation actionInvocation) {
        this.actionInvocation = actionInvocation;
    }

    public ActionInvocation getActionInvocation() {
        return this.actionInvocation;
    }

    public synchronized ControlPoint getControlPoint() {
        return this.controlPoint;
    }

    public synchronized ActionCallback setControlPoint(ControlPoint controlPoint) {
        this.controlPoint = controlPoint;
        return this;
    }

    @Override
    public void run() {
        Object service = this.actionInvocation.getAction().getService();
        if (service instanceof LocalService) {
            LocalService localService = (LocalService)service;
            localService.getExecutor(this.actionInvocation.getAction()).execute(this.actionInvocation);
            if (this.actionInvocation.getFailure() != null) {
                this.failure(this.actionInvocation, null);
            } else {
                this.success(this.actionInvocation);
            }
        } else if (service instanceof RemoteService) {
            URL controLURL;
            if (this.getControlPoint() == null) {
                throw new IllegalStateException("Callback must be executed through ControlPoint");
            }
            RemoteService remoteService = (RemoteService)service;
            try {
                controLURL = ((RemoteDevice)remoteService.getDevice()).normalizeURI(remoteService.getControlURI());
            }
            catch (IllegalArgumentException e) {
                this.failure(this.actionInvocation, null, "bad control URL: " + String.valueOf(remoteService.getControlURI()));
                return;
            }
            SendingAction prot = this.getControlPoint().getProtocolFactory().createSendingAction(this.actionInvocation, controLURL);
            prot.run();
            IncomingActionResponseMessage response = (IncomingActionResponseMessage)prot.getOutputMessage();
            if (response == null) {
                this.failure(this.actionInvocation, null);
            } else if (((UpnpResponse)response.getOperation()).isFailed()) {
                this.failure(this.actionInvocation, (UpnpResponse)response.getOperation());
            } else {
                this.success(this.actionInvocation);
            }
        }
    }

    protected String createDefaultFailureMessage(ActionInvocation invocation, UpnpResponse operation) {
        Object message = "Error: ";
        ActionException exception = invocation.getFailure();
        if (exception != null) {
            message = (String)message + exception.getMessage();
        }
        if (operation != null) {
            message = (String)message + " (HTTP response was: " + operation.getResponseDetails() + ")";
        }
        return message;
    }

    protected void failure(ActionInvocation invocation, UpnpResponse operation) {
        this.failure(invocation, operation, this.createDefaultFailureMessage(invocation, operation));
    }

    public abstract void success(ActionInvocation var1);

    public abstract void failure(ActionInvocation var1, UpnpResponse var2, String var3);

    public String toString() {
        return "(ActionCallback) " + String.valueOf(this.actionInvocation);
    }

    public static final class Default
    extends ActionCallback {
        public Default(ActionInvocation actionInvocation, ControlPoint controlPoint) {
            super(actionInvocation, controlPoint);
        }

        @Override
        public void success(ActionInvocation invocation) {
        }

        @Override
        public void failure(ActionInvocation invocation, UpnpResponse operation, String defaultMsg) {
        }
    }
}

