/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.items;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ModelGroupFunction implements Enumerator
{
    EQUALITY(0, "EQUALITY", "EQUALITY"),
    AND(1, "AND", "AND"),
    OR(2, "OR", "OR"),
    NAND(3, "NAND", "NAND"),
    NOR(4, "NOR", "NOR"),
    XOR(5, "XOR", "XOR"),
    AVG(6, "AVG", "AVG"),
    MEDIAN(7, "MEDIAN", "MEDIAN"),
    SUM(8, "SUM", "SUM"),
    MAX(9, "MAX", "MAX"),
    MIN(10, "MIN", "MIN"),
    COUNT(11, "COUNT", "COUNT"),
    LATEST(12, "LATEST", "LATEST"),
    EARLIEST(13, "EARLIEST", "EARLIEST");

    public static final int EQUALITY_VALUE = 0;
    public static final int AND_VALUE = 1;
    public static final int OR_VALUE = 2;
    public static final int NAND_VALUE = 3;
    public static final int NOR_VALUE = 4;
    public static final int XOR_VALUE = 5;
    public static final int AVG_VALUE = 6;
    public static final int MEDIAN_VALUE = 7;
    public static final int SUM_VALUE = 8;
    public static final int MAX_VALUE = 9;
    public static final int MIN_VALUE = 10;
    public static final int COUNT_VALUE = 11;
    public static final int LATEST_VALUE = 12;
    public static final int EARLIEST_VALUE = 13;
    private static final ModelGroupFunction[] VALUES_ARRAY;
    public static final List<ModelGroupFunction> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ModelGroupFunction[]{EQUALITY, AND, OR, NAND, NOR, XOR, AVG, MEDIAN, SUM, MAX, MIN, COUNT, LATEST, EARLIEST};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ModelGroupFunction get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ModelGroupFunction result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ModelGroupFunction getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ModelGroupFunction result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ModelGroupFunction get(int value) {
        switch (value) {
            case 0: {
                return EQUALITY;
            }
            case 1: {
                return AND;
            }
            case 2: {
                return OR;
            }
            case 3: {
                return NAND;
            }
            case 4: {
                return NOR;
            }
            case 5: {
                return XOR;
            }
            case 6: {
                return AVG;
            }
            case 7: {
                return MEDIAN;
            }
            case 8: {
                return SUM;
            }
            case 9: {
                return MAX;
            }
            case 10: {
                return MIN;
            }
            case 11: {
                return COUNT;
            }
            case 12: {
                return LATEST;
            }
            case 13: {
                return EARLIEST;
            }
        }
        return null;
    }

    private ModelGroupFunction(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

