/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.deployer.features;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.felix.fileinstall.ArtifactUrlTransformer;
import org.apache.felix.utils.version.VersionRange;
import org.apache.karaf.features.FeaturesNamespaces;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.Repository;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureDeploymentListener
implements ArtifactUrlTransformer,
BundleListener {
    public static final String FEATURE_PATH = "org.apache.karaf.shell.features";
    private final Logger logger = LoggerFactory.getLogger(FeatureDeploymentListener.class);
    private XMLInputFactory xif;
    private FeaturesService featuresService;
    private BundleContext bundleContext;
    private Properties properties = new Properties();

    public void setFeaturesService(FeaturesService featuresService) {
        this.featuresService = featuresService;
    }

    public FeaturesService getFeaturesService() {
        return this.featuresService;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void init() throws Exception {
        this.bundleContext.addBundleListener((BundleListener)this);
        this.loadProperties();
        for (Bundle bundle : this.bundleContext.getBundles()) {
            if (bundle.getState() != 4 && bundle.getState() != 8 && bundle.getState() != 32) continue;
            this.bundleChanged(new BundleEvent(32, bundle));
        }
    }

    public void destroy() {
        this.bundleContext.removeBundleListener((BundleListener)this);
    }

    private boolean isKnownFeaturesURI(String uri) {
        if (uri == null) {
            return false;
        }
        for (String ns : FeaturesNamespaces.SUPPORTED_URIS) {
            if (!ns.equalsIgnoreCase(uri)) continue;
            return true;
        }
        return false;
    }

    private void loadProperties() throws IOException {
        File file = this.getPropertiesFile();
        if (file != null && file.exists()) {
            try (FileInputStream input = new FileInputStream(file);){
                this.properties.load(input);
            }
        }
    }

    private void saveProperties() throws IOException {
        File file = this.getPropertiesFile();
        if (file != null) {
            try (FileOutputStream output = new FileOutputStream(file);){
                this.properties.store(output, null);
            }
        }
    }

    private File getPropertiesFile() {
        try {
            return this.bundleContext.getDataFile("FeatureDeploymentListener.cfg");
        }
        catch (Exception e) {
            this.logger.debug("Unable to get FeatureDeploymentListener.cfg", (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canHandle(File artifact) {
        try {
            if (artifact.isFile() && artifact.getName().endsWith(".json")) {
                try (BufferedReader reader = new BufferedReader(new FileReader(artifact));){
                    String line;
                    do {
                        if ((line = reader.readLine()) == null) return false;
                    } while (!line.contains("\"feature\""));
                    boolean bl = true;
                    return bl;
                }
            }
            if (!artifact.isFile()) return false;
            if (!artifact.getName().endsWith(".xml")) return false;
            QName qname = this.getRootElementName(artifact);
            String name = qname.getLocalPart();
            String uri = qname.getNamespaceURI();
            if (!"features".equals(name)) return false;
            if (this.isKnownFeaturesURI(uri)) {
                return true;
            }
            this.logger.error("unknown features uri", (Throwable)new Exception("" + uri));
            return false;
        }
        catch (Exception e) {
            this.logger.error("Unable to parse deployed file " + artifact.getAbsolutePath(), (Throwable)e);
        }
        return false;
    }

    public URL transform(URL artifact) {
        try {
            return new URL("feature", null, artifact.toString());
        }
        catch (Exception e) {
            this.logger.error("Unable to build feature bundle", (Throwable)e);
            return null;
        }
    }

    public synchronized void bundleChanged(BundleEvent bundleEvent) {
        if (bundleEvent.getType() != 32 && bundleEvent.getType() != 16) {
            return;
        }
        Bundle bundle = bundleEvent.getBundle();
        try {
            int i;
            int count;
            ArrayList<URI> repsToRemove = new ArrayList<URI>();
            ArrayList<String> reqsToRemove = new ArrayList<String>();
            String prefix = "bundle." + bundle.getBundleId();
            String countStr = (String)this.properties.remove(prefix + ".reps.count");
            if (countStr != null) {
                count = Integer.parseInt(countStr);
                for (i = 0; i < count; ++i) {
                    String rep = (String)this.properties.remove(prefix + ".reps.item" + i);
                    repsToRemove.add(URI.create(rep));
                }
            }
            if ((countStr = (String)this.properties.remove(prefix + ".reqs.count")) != null) {
                count = Integer.parseInt(countStr);
                for (i = 0; i < count; ++i) {
                    String req = (String)this.properties.remove(prefix + ".reqs.item" + i);
                    reqsToRemove.add(req);
                }
            }
            this.saveProperties();
            ArrayList<URI> repsToAdd = new ArrayList<URI>();
            ArrayList reqsToAdd = new ArrayList();
            if (bundleEvent.getType() == 32) {
                Enumeration featuresUrlEnumeration = bundle.findEntries("/META-INF/org.apache.karaf.shell.features/", "*.xml", false);
                while (featuresUrlEnumeration != null && featuresUrlEnumeration.hasMoreElements()) {
                    URL url = (URL)featuresUrlEnumeration.nextElement();
                    URI uri = url.toURI();
                    repsToAdd.add(uri);
                    Repository rep = this.featuresService.createRepository(uri);
                    Stream.of(rep.getFeatures()).filter(f -> f.getInstall() == null || "auto".equals(f.getInstall())).map(f -> "feature:" + f.getName() + "/" + new VersionRange(f.getVersion(), true)).forEach(reqsToAdd::add);
                }
                if (!repsToAdd.isEmpty()) {
                    int i2;
                    this.properties.put(prefix + ".reps.count", Integer.toString(repsToAdd.size()));
                    for (i2 = 0; i2 < repsToAdd.size(); ++i2) {
                        this.properties.put(prefix + ".reps.item" + i2, ((URI)repsToAdd.get(i2)).toASCIIString());
                    }
                    this.properties.put(prefix + ".reqs.count", Integer.toString(reqsToAdd.size()));
                    for (i2 = 0; i2 < reqsToAdd.size(); ++i2) {
                        this.properties.put(prefix + ".reqs.item" + i2, reqsToAdd.get(i2));
                    }
                }
            }
            this.saveProperties();
            List<Repository> requiredRepos = Arrays.asList(this.featuresService.listRequiredRepositories());
            Set requiredReposUris = requiredRepos.stream().map(Repository::getURI).collect(Collectors.toSet());
            requiredReposUris.removeAll(repsToRemove);
            requiredReposUris.addAll(repsToAdd);
            Map requirements = this.featuresService.listRequirements();
            ((Set)requirements.get("root")).removeAll(reqsToRemove);
            ((Set)requirements.get("root")).addAll(reqsToAdd);
            if (!reqsToRemove.isEmpty() || !reqsToAdd.isEmpty()) {
                this.featuresService.updateReposAndRequirements(requiredReposUris, requirements, EnumSet.noneOf(FeaturesService.Option.class));
            }
        }
        catch (Exception e) {
            this.logger.error("Unable to update deployed features for bundle: " + bundle.getSymbolicName() + " - " + bundle.getVersion(), (Throwable)e);
        }
    }

    private QName getRootElementName(File artifact) throws Exception {
        if (this.xif == null) {
            this.xif = XMLInputFactory.newFactory();
            this.xif.setProperty("javax.xml.stream.supportDTD", false);
            this.xif.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
            this.xif.setProperty("javax.xml.stream.isNamespaceAware", true);
        }
        try (FileInputStream is = new FileInputStream(artifact);){
            XMLStreamReader sr = this.xif.createXMLStreamReader(is);
            sr.nextTag();
            QName qName = sr.getName();
            return qName;
        }
    }
}

