/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements;

import java.net.InetSocketAddress;
import java.security.Principal;
import org.eclipse.californium.elements.Definition;
import org.eclipse.californium.elements.MapBasedEndpointContext;
import org.eclipse.californium.elements.util.StringUtil;

public class TcpEndpointContext
extends MapBasedEndpointContext {
    public static final Definition<String> KEY_CONNECTION_ID = new Definition<String>("CONNECTION_ID", String.class, ATTRIBUTE_DEFINITIONS);
    public static final Definition<Long> KEY_CONNECTION_TIMESTAMP = new Definition<Long>("CONNECTION_TIMESTAMP", Long.class, ATTRIBUTE_DEFINITIONS);

    public TcpEndpointContext(InetSocketAddress peerAddress, String connectionId, long timestamp) {
        this(peerAddress, null, new MapBasedEndpointContext.Attributes().add(KEY_CONNECTION_ID, connectionId).add(KEY_CONNECTION_TIMESTAMP, timestamp));
    }

    protected TcpEndpointContext(InetSocketAddress peerAddress, Principal peerIdentity, MapBasedEndpointContext.Attributes attributes) {
        super(peerAddress, peerIdentity, attributes);
        if (null == this.getConnectionId()) {
            throw new IllegalArgumentException("Missing " + KEY_CONNECTION_ID + " attribute!");
        }
    }

    public String getConnectionId() {
        return this.get(KEY_CONNECTION_ID);
    }

    public final Number getConnectionTimestamp() {
        return this.get(KEY_CONNECTION_TIMESTAMP);
    }

    @Override
    public String toString() {
        return String.format("TCP(%s,ID:%s)", this.getPeerAddressAsString(), StringUtil.trunc(this.getConnectionId(), 10));
    }
}

