/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.console.karaf.internal;

import java.io.PrintStream;
import java.util.List;
import org.apache.felix.service.command.Process;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.api.console.Completer;
import org.apache.karaf.shell.api.console.Parser;
import org.apache.karaf.shell.api.console.Registry;
import org.apache.karaf.shell.api.console.Session;
import org.openhab.core.io.console.Console;
import org.openhab.core.io.console.ConsoleInterpreter;
import org.openhab.core.io.console.extensions.ConsoleCommandExtension;
import org.openhab.core.io.console.karaf.OSGiConsole;
import org.openhab.core.io.console.karaf.internal.CompleterWrapper;

@Service
@Command(name="help", scope="openhab", description="Print the full usage information of the 'openhab' commands.")
public class CommandWrapper
implements org.apache.karaf.shell.api.console.Command,
Action {
    public static final String SCOPE = "openhab";
    private final ConsoleCommandExtension command;
    @Reference
    private Registry registry;

    public CommandWrapper() {
        this(null);
    }

    public CommandWrapper(ConsoleCommandExtension command) {
        this.command = command;
    }

    public Object execute(Session session, List<Object> argList) throws Exception {
        String[] args = (String[])argList.stream().map(Object::toString).toArray(String[]::new);
        PrintStream out = Process.Utils.current().out();
        OSGiConsole console = new OSGiConsole(this.getScope(), out, session);
        if (args.length == 1 && "--help".equals(args[0])) {
            for (String usage : this.command.getUsages()) {
                console.printUsage(usage);
            }
        } else {
            ConsoleInterpreter.execute((Console)console, (ConsoleCommandExtension)this.command, (String[])args);
        }
        return null;
    }

    public Completer getCompleter(boolean scoped) {
        return new CompleterWrapper(this.command, scoped);
    }

    public String getDescription() {
        return this.command.getDescription();
    }

    public String getName() {
        return this.command.getCommand();
    }

    public Parser getParser() {
        return null;
    }

    public String getScope() {
        return SCOPE;
    }

    public Object execute() throws Exception {
        List commands = this.registry.getCommands();
        for (org.apache.karaf.shell.api.console.Command command : commands) {
            if (!SCOPE.equals(command.getScope()) || !(command instanceof CommandWrapper)) continue;
            command.execute(null, List.of("--help"));
        }
        return null;
    }
}

