/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jbbp.model;

import com.igormaznitsa.jbbp.compiler.JBBPNamedFieldInfo;
import com.igormaznitsa.jbbp.model.JBBPAbstractField;
import com.igormaznitsa.jbbp.model.JBBPFieldInt;
import com.igormaznitsa.jbbp.model.JBBPNumericField;

public strictfp final class JBBPFieldFloat
extends JBBPAbstractField
implements JBBPNumericField {
    public static final String TYPE_NAME = "floatj";
    private static final long serialVersionUID = 5493764792942829316L;
    private final float value;

    public JBBPFieldFloat(JBBPNamedFieldInfo name, float value) {
        super(name);
        this.value = value;
    }

    @Override
    public float getAsFloat() {
        return this.value;
    }

    @Override
    public double getAsDouble() {
        return this.value;
    }

    @Override
    public int getAsInt() {
        return Math.round(this.value);
    }

    @Override
    public long getAsLong() {
        return this.getAsInt();
    }

    @Override
    public boolean getAsBool() {
        return this.value != 0.0f;
    }

    @Override
    public long getAsInvertedBitOrder() {
        return JBBPFieldInt.reverseBits(Float.floatToIntBits(this.value));
    }

    @Override
    public String getTypeAsString() {
        return TYPE_NAME;
    }
}

