/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jsr356.decoders;

import java.nio.ByteBuffer;
import javax.websocket.DecodeException;
import javax.websocket.Decoder;
import javax.websocket.PongMessage;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.websocket.jsr356.decoders.AbstractDecoder;

public class PongMessageDecoder
extends AbstractDecoder
implements Decoder.Binary<PongMessage> {
    public PongMessage decode(ByteBuffer bytes) throws DecodeException {
        return new PongMsg(bytes);
    }

    public boolean willDecode(ByteBuffer bytes) {
        return true;
    }

    private static class PongMsg
    implements PongMessage {
        private final ByteBuffer bytes;

        public PongMsg(ByteBuffer buf) {
            int len = buf.remaining();
            this.bytes = ByteBuffer.allocate(len);
            BufferUtil.put((ByteBuffer)buf, (ByteBuffer)this.bytes);
            BufferUtil.flipToFlush((ByteBuffer)this.bytes, (int)0);
        }

        public ByteBuffer getApplicationData() {
            return this.bytes;
        }
    }
}

