/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.module.handler;

import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.Action;
import org.openhab.core.automation.handler.BaseActionModuleHandler;
import org.openhab.core.config.core.Configuration;
import org.openhab.core.events.Event;
import org.openhab.core.events.EventPublisher;
import org.openhab.core.items.Item;
import org.openhab.core.items.ItemNotFoundException;
import org.openhab.core.items.ItemRegistry;
import org.openhab.core.items.events.ItemEventFactory;
import org.openhab.core.items.events.ItemStateEvent;
import org.openhab.core.types.State;
import org.openhab.core.types.TypeParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class ItemStateUpdateActionHandler
extends BaseActionModuleHandler {
    public static final String ITEM_STATE_UPDATE_ACTION = "core.ItemStateUpdateAction";
    public static final String ITEM_NAME = "itemName";
    public static final String STATE = "state";
    private final Logger logger = LoggerFactory.getLogger(ItemStateUpdateActionHandler.class);
    private final EventPublisher eventPublisher;
    private final ItemRegistry itemRegistry;

    public ItemStateUpdateActionHandler(Action module, EventPublisher eventPublisher, ItemRegistry itemRegistry) {
        super(module);
        this.eventPublisher = eventPublisher;
        this.itemRegistry = itemRegistry;
    }

    @Override
    public @Nullable Map<String, Object> execute(Map<String, Object> inputs) {
        block9: {
            Configuration config = ((Action)this.module).getConfiguration();
            String itemName = (String)config.get(ITEM_NAME);
            String state = (String)config.get(STATE);
            if (itemName != null) {
                try {
                    Item item = this.itemRegistry.getItem(itemName);
                    State stateObj = null;
                    if (state != null) {
                        stateObj = TypeParser.parseState((List)item.getAcceptedDataTypes(), (String)state);
                    } else {
                        Object st = inputs.get(STATE);
                        if (st instanceof State) {
                            State state1 = (State)st;
                            if (item.getAcceptedDataTypes().contains(st.getClass())) {
                                stateObj = state1;
                            }
                        }
                    }
                    if (stateObj != null) {
                        ItemStateEvent itemStateEvent = (ItemStateEvent)ItemEventFactory.createStateEvent((String)itemName, (State)stateObj);
                        this.logger.debug("Executing ItemStateEvent on Item {} with State {}", (Object)itemStateEvent.getItemName(), (Object)itemStateEvent.getItemState());
                        this.eventPublisher.post((Event)itemStateEvent);
                        break block9;
                    }
                    this.logger.debug("State '{}' is not valid for item '{}'.", (Object)state, (Object)itemName);
                }
                catch (ItemNotFoundException e) {
                    this.logger.error("Item with name {} not found in ItemRegistry.", (Object)itemName);
                }
            } else {
                this.logger.error("Item state was not updated because the configuration was not correct: ItemName: {}, State: {}", (Object)itemName, (Object)state);
            }
        }
        return null;
    }
}

