/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.commands;

import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.Rule;
import org.openhab.core.automation.RuleRegistry;
import org.openhab.core.automation.RuleStatus;
import org.openhab.core.automation.internal.commands.AutomationCommand;
import org.openhab.core.automation.internal.commands.CommandlineModuleTypeProvider;
import org.openhab.core.automation.internal.commands.CommandlineRuleImporter;
import org.openhab.core.automation.internal.commands.CommandlineTemplateProvider;
import org.openhab.core.automation.template.RuleTemplate;
import org.openhab.core.automation.template.Template;
import org.openhab.core.automation.template.TemplateRegistry;
import org.openhab.core.automation.type.ModuleType;
import org.openhab.core.automation.type.ModuleTypeRegistry;
import org.osgi.framework.BundleContext;

@NonNullByDefault
public abstract class AutomationCommands {
    protected static final int RULE_PROVIDER = 1;
    protected static final int TEMPLATE_PROVIDER = 2;
    protected static final int MODULE_TYPE_PROVIDER = 3;
    protected static final String IMPORT_MODULE_TYPES = "importModuleTypes";
    protected static final String IMPORT_MODULE_TYPES_SHORT = "imt";
    protected static final String IMPORT_TEMPLATES = "importTemplates";
    protected static final String IMPORT_TEMPLATES_SHORT = "it";
    protected static final String IMPORT_RULES = "importRules";
    protected static final String IMPORT_RULES_SHORT = "ir";
    protected static final String EXPORT_MODULE_TYPES = "exportModuleTypes";
    protected static final String EXPORT_MODULE_TYPES_SHORT = "emt";
    protected static final String EXPORT_TEMPLATES = "exportTemplates";
    protected static final String EXPORT_TEMPLATES_SHORT = "et";
    protected static final String EXPORT_RULES = "exportRules";
    protected static final String EXPORT_RULES_SHORT = "er";
    protected static final String REMOVE_RULE = "removeRule";
    protected static final String REMOVE_RULE_SHORT = "rmr";
    protected static final String REMOVE_RULES = "removeRules";
    protected static final String REMOVE_RULES_SHORT = "rmrs";
    protected static final String REMOVE_TEMPLATES = "removeTemplates";
    protected static final String REMOVE_TEMPLATES_SHORT = "rmts";
    protected static final String REMOVE_MODULE_TYPES = "removeModuleTypes";
    protected static final String REMOVE_MODULE_TYPES_SHORT = "rmmts";
    protected static final String LIST_MODULE_TYPES = "listModuleTypes";
    protected static final String LIST_MODULE_TYPES_SHORT = "lsmt";
    protected static final String LIST_TEMPLATES = "listTemplates";
    protected static final String LIST_TEMPLATES_SHORT = "lst";
    protected static final String LIST_RULES = "listRules";
    protected static final String LIST_RULES_SHORT = "lsr";
    protected static final String ENABLE_RULE = "enableRule";
    protected static final String ENABLE_RULE_SHORT = "enr";
    @NonNullByDefault(value={})
    protected CommandlineModuleTypeProvider moduleTypeProvider;
    @NonNullByDefault(value={})
    protected CommandlineTemplateProvider templateProvider;
    @NonNullByDefault(value={})
    protected CommandlineRuleImporter ruleImporter;

    public abstract @Nullable Rule getRule(String var1);

    public abstract Collection<Rule> getRules();

    public abstract @Nullable RuleStatus getRuleStatus(String var1);

    public abstract void setEnabled(String var1, boolean var2);

    public abstract @Nullable Template getTemplate(String var1, @Nullable Locale var2);

    public abstract Collection<RuleTemplate> getTemplates(@Nullable Locale var1);

    public abstract @Nullable ModuleType getModuleType(String var1, @Nullable Locale var2);

    public abstract <T extends ModuleType> Collection<T> getTriggers(@Nullable Locale var1);

    public abstract <T extends ModuleType> Collection<T> getConditions(@Nullable Locale var1);

    public abstract <T extends ModuleType> Collection<T> getActions(@Nullable Locale var1);

    public abstract String removeRule(String var1);

    public abstract String removeRules(String var1);

    protected abstract @Nullable AutomationCommand parseCommand(String var1, String[] var2);

    public void initialize(BundleContext bundleContext, ModuleTypeRegistry moduleTypeRegistry, TemplateRegistry<RuleTemplate> templateRegistry, RuleRegistry ruleRegistry) {
        this.moduleTypeProvider = new CommandlineModuleTypeProvider(bundleContext, moduleTypeRegistry);
        this.templateProvider = new CommandlineTemplateProvider(bundleContext, templateRegistry);
        this.ruleImporter = new CommandlineRuleImporter(bundleContext, ruleRegistry);
    }

    public void dispose() {
        this.moduleTypeProvider.close();
        this.templateProvider.close();
        this.ruleImporter.close();
        this.moduleTypeProvider = null;
        this.templateProvider = null;
        this.ruleImporter = null;
    }

    public String exportModuleTypes(String parserType, Set<ModuleType> set, File file) throws Exception {
        return this.moduleTypeProvider.exportModuleTypes(parserType, set, file);
    }

    public String exportTemplates(String parserType, Set<RuleTemplate> set, File file) throws Exception {
        return this.templateProvider.exportTemplates(parserType, set, file);
    }

    public String exportRules(String parserType, Set<Rule> set, File file) throws Exception {
        return this.ruleImporter.exportRules(parserType, set, file);
    }

    public Set<ModuleType> importModuleTypes(String parserType, URL url) throws Exception {
        return this.moduleTypeProvider.importModuleTypes(parserType, url);
    }

    public Set<RuleTemplate> importTemplates(String parserType, URL url) throws Exception {
        return this.templateProvider.importTemplates(parserType, url);
    }

    public Set<Rule> importRules(String parserType, URL url) throws Exception {
        return this.ruleImporter.importRules(parserType, url);
    }

    public String remove(int providerType, URL url) {
        switch (providerType) {
            case 3: {
                if (this.moduleTypeProvider == null) break;
                return this.moduleTypeProvider.remove(url);
            }
            case 2: {
                if (this.templateProvider == null) break;
                return this.templateProvider.remove(url);
            }
        }
        return "FAIL";
    }

    public String executeCommand(String command, String[] parameterValues) {
        AutomationCommand commandInst = this.parseCommand(command, parameterValues);
        if (commandInst != null) {
            return commandInst.execute();
        }
        return String.format("Command \"%s\" is not supported!", command);
    }
}

