/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.dto;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.automation.Rule;
import org.openhab.core.automation.dto.ActionDTOMapper;
import org.openhab.core.automation.dto.ConditionDTOMapper;
import org.openhab.core.automation.dto.RuleDTO;
import org.openhab.core.automation.dto.TriggerDTOMapper;
import org.openhab.core.automation.util.RuleBuilder;
import org.openhab.core.config.core.Configuration;
import org.openhab.core.config.core.dto.ConfigDescriptionDTOMapper;

@NonNullByDefault
public class RuleDTOMapper {
    public static RuleDTO map(Rule rule) {
        RuleDTO ruleDto = new RuleDTO();
        RuleDTOMapper.fillProperties(rule, ruleDto);
        return ruleDto;
    }

    public static Rule map(RuleDTO ruleDto) {
        RuleBuilder builder = RuleBuilder.create(ruleDto.uid).withActions(ActionDTOMapper.mapDto(ruleDto.actions)).withConditions(ConditionDTOMapper.mapDto(ruleDto.conditions)).withTriggers(TriggerDTOMapper.mapDto(ruleDto.triggers)).withConfiguration(new Configuration(ruleDto.configuration)).withConfigurationDescriptions(ConfigDescriptionDTOMapper.map(ruleDto.configDescriptions)).withTemplateUID(ruleDto.templateUID).withVisibility(ruleDto.visibility).withTags(ruleDto.tags).withName(ruleDto.name).withDescription(ruleDto.description);
        if (ruleDto.templateState == null) {
            builder.withTemplateState(ruleDto.templateUID == null ? Rule.TemplateState.NO_TEMPLATE : Rule.TemplateState.PENDING);
        } else {
            builder.withTemplateState(Rule.TemplateState.typeOf(ruleDto.templateState));
        }
        return builder.build();
    }

    protected static void fillProperties(Rule from, RuleDTO to) {
        to.triggers = TriggerDTOMapper.map(from.getTriggers());
        to.conditions = ConditionDTOMapper.map(from.getConditions());
        to.actions = ActionDTOMapper.map(from.getActions());
        to.configuration = from.getConfiguration().getProperties();
        to.configDescriptions = ConfigDescriptionDTOMapper.mapParameters(from.getConfigurationDescriptions());
        to.templateUID = from.getTemplateUID();
        to.templateState = from.getTemplateState().toString();
        to.uid = from.getUID();
        to.name = from.getName();
        to.tags = from.getTags();
        to.visibility = from.getVisibility();
        to.description = from.getDescription();
    }
}

