/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.observe;

import org.eclipse.californium.core.observe.ObserveHealth;
import org.eclipse.californium.elements.util.CounterStatisticManager;
import org.eclipse.californium.elements.util.SimpleCounterStatistic;
import org.eclipse.californium.elements.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObserveStatisticLogger
extends CounterStatisticManager
implements ObserveHealth {
    private static final Logger LOGGER = LoggerFactory.getLogger(ObserveStatisticLogger.class);
    private final SimpleCounterStatistic observes;
    private final SimpleCounterStatistic endpoints;
    private final SimpleCounterStatistic observeRequests;
    private final SimpleCounterStatistic cancelRequests;
    private final SimpleCounterStatistic rejectedNotifies;

    public ObserveStatisticLogger(String tag) {
        super(tag);
        this.observes = new SimpleCounterStatistic("observes", this.align);
        this.endpoints = new SimpleCounterStatistic("observing-endpoints", this.align);
        this.observeRequests = new SimpleCounterStatistic("observe-request", this.align);
        this.cancelRequests = new SimpleCounterStatistic("cancel-request", this.align);
        this.rejectedNotifies = new SimpleCounterStatistic("rejected-notifies", this.align);
        this.init();
    }

    private void init() {
        this.add(this.observes);
        this.add(this.endpoints);
        this.add(this.observeRequests);
        this.add(this.cancelRequests);
        this.add(this.rejectedNotifies);
    }

    public boolean isEnabled() {
        return LOGGER.isInfoEnabled();
    }

    public void dump() {
        try {
            if (this.isEnabled()) {
                if (LOGGER.isDebugEnabled() && this.observeRequests.isUsed()) {
                    StringBuilder log = new StringBuilder();
                    String eol = StringUtil.lineSeparator();
                    String head = "   " + this.tag;
                    log.append(this.tag).append("observe-statistic:").append(eol);
                    log.append(head).append(this.observes).append(eol);
                    log.append(head).append(this.endpoints).append(eol);
                    log.append(head).append(this.observeRequests).append(eol);
                    log.append(head).append(this.cancelRequests).append(eol);
                    log.append(head).append(this.rejectedNotifies);
                    LOGGER.debug("{}", (Object)log);
                }
                this.transferCounter();
            }
        }
        catch (Throwable e) {
            LOGGER.error("{}", (Object)this.tag, (Object)e);
        }
    }

    @Override
    public void setObserveRelations(int observeRelations) {
        this.observes.set((long)observeRelations);
    }

    @Override
    public void setObserveEndpoints(int observeEndpoints) {
        this.endpoints.set((long)observeEndpoints);
    }

    @Override
    public void receivingObserveRequest() {
        this.observeRequests.increment();
    }

    @Override
    public void receivingCancelRequest() {
        this.cancelRequests.increment();
    }

    @Override
    public void receivingReject() {
        this.rejectedNotifies.increment();
    }
}

