/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.type;

import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault
public class Input {
    @NonNullByDefault(value={})
    private String name;
    @NonNullByDefault(value={})
    private String type;
    private @Nullable String label;
    private @Nullable String description;
    private boolean required = false;
    private @Nullable Set<String> tags;
    private @Nullable String reference;
    private @Nullable String defaultValue;

    protected Input() {
    }

    public Input(String name, String type) {
        this(name, type, null, null, null, false, null, null);
    }

    public Input(String name, String type, @Nullable String label, @Nullable String description, @Nullable Set<String> tags, boolean required, @Nullable String reference, @Nullable String defaultValue) {
        if (name == null) {
            throw new IllegalArgumentException("The name of the input must not be NULL!");
        }
        if (type == null) {
            throw new IllegalArgumentException("The type of the input must not be NULL!");
        }
        this.name = name;
        this.type = type;
        this.label = label;
        this.description = description;
        this.tags = tags;
        this.required = required;
        this.reference = reference;
        this.defaultValue = defaultValue;
    }

    public String getName() {
        return this.name;
    }

    public @Nullable String getLabel() {
        return this.label;
    }

    public @Nullable String getDescription() {
        return this.description;
    }

    public boolean isRequired() {
        return this.required;
    }

    public String getType() {
        return this.type;
    }

    public Set<String> getTags() {
        Set<String> tags = this.tags;
        return tags != null ? tags : Set.of();
    }

    public @Nullable String getReference() {
        return this.reference;
    }

    public @Nullable String getDefaultValue() {
        return this.defaultValue;
    }

    public String toString() {
        return "Input " + this.name;
    }
}

