/**
This IndexedDB API interface represents a cursor for traversing or iterating over multiple records in a database.

@returns {IDBCursor}
*/
IDBCursor = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {("next" | "nextunique" | "prev" | "prevunique")} IDBCursorDirection
**/
IDBCursor.prototype.direction = new Object();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Number | String | Date | ArrayBufferView | ArrayBuffer | IDBValidKey[])} IDBValidKey
**/
IDBCursor.prototype.key = new Object();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(Number | String | Date | ArrayBufferView | ArrayBuffer | IDBValidKey[])} IDBValidKey
**/
IDBCursor.prototype.primaryKey = new Object();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {IDBRequest}
**/
IDBCursor.prototype.request = new IDBRequest();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**


@returns {(IDBObjectStore | IDBIndex)} IDBObjectStore | IDBIndex
**/
IDBCursor.prototype.source = new Object();

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Advances the cursor through the next count records in range.

@param {Number} count
@returns {undefined}
**/
IDBCursor.prototype.advance = function(count) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Advances the cursor to the next record in range.

@param {(Number | String | Date | ArrayBufferView | ArrayBuffer | IDBValidKey[])} [key] IDBValidKey
@returns {undefined}
**/
IDBCursor.prototype.continue = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Advances the cursor to the next record in range matching or after key and primaryKey. Throws an "InvalidAccessError" DOMException if the source is not an index.

@param {(Number | String | Date | ArrayBufferView | ArrayBuffer | IDBValidKey[])} key IDBValidKey
@param {(Number | String | Date | ArrayBufferView | ArrayBuffer | IDBValidKey[])} primaryKey IDBValidKey
@returns {undefined}
**/
IDBCursor.prototype.continuePrimaryKey = function(key, primaryKey) {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Delete the record pointed at by the cursor with a new value.

If successful, request's result will be undefined.

@returns {IDBRequest}
**/
IDBCursor.prototype.delete = function() {};

//Source: /home/matthias/src/netbeans-tools/jsstub-generator/node_modules/typescript/lib/lib.dom.d.ts
/**
Updated the record pointed at by the cursor with a new value.

Throws a "DataError" DOMException if the effective object store uses in-line keys and the key would have changed.

If successful, request's result will be the record's key.

@param {Object} value
@returns {IDBRequest}
**/
IDBCursor.prototype.update = function(value) {};

