/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.dd.api.application;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.j2ee.dd.api.application.Application;
import org.netbeans.modules.j2ee.dd.api.common.CommonDDBean;
import org.netbeans.modules.j2ee.dd.impl.application.ApplicationProxy;
import org.netbeans.modules.schema2beans.BaseBean;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class DDProvider {
    private static final String APP_13_DOCTYPE = "-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN";
    private static final DDProvider ddProvider = new DDProvider();
    private final Map<FileObject, ApplicationProxy> ddMap;
    private static final Logger LOGGER = Logger.getLogger(DDProvider.class.getName());
    ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/j2ee/dd/Bundle");

    private DDProvider() {
        this.ddMap = new HashMap<FileObject, ApplicationProxy>(5);
    }

    public static DDProvider getDefault() {
        return ddProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Application getDDRoot(FileObject fo) throws IOException {
        Map<FileObject, ApplicationProxy> map;
        ApplicationProxy applicationProxy;
        block12: {
            if (fo == null) {
                return null;
            }
            applicationProxy = null;
            map = this.ddMap;
            synchronized (map) {
                applicationProxy = this.getFromCache(fo);
                if (applicationProxy != null) {
                    return applicationProxy;
                }
            }
            fo.addFileChangeListener((FileChangeListener)new FileChangeAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void fileChanged(FileEvent evt) {
                    FileObject fo = evt.getFile();
                    try {
                        Map map = DDProvider.this.ddMap;
                        synchronized (map) {
                            ApplicationProxy applicationProxy = DDProvider.this.getFromCache(fo);
                            String version = null;
                            if (applicationProxy != null) {
                                try {
                                    DDParse parseResult = DDProvider.this.parseDD(fo);
                                    version = parseResult.getVersion();
                                    DDProvider.setProxyErrorStatus(applicationProxy, parseResult);
                                    Application newValue = DDProvider.createApplication(parseResult);
                                    if (!version.equals(applicationProxy.getVersion().toString())) {
                                        applicationProxy.setOriginal(newValue);
                                    } else if (applicationProxy.getOriginal() == null) {
                                        applicationProxy.setOriginal(newValue);
                                    } else {
                                        applicationProxy.getOriginal().merge(newValue, 3);
                                    }
                                }
                                catch (SAXException ex) {
                                    if (ex instanceof SAXParseException) {
                                        applicationProxy.setError((SAXParseException)ex);
                                    } else if (ex.getException() instanceof SAXParseException) {
                                        applicationProxy.setError((SAXParseException)ex.getException());
                                    }
                                    applicationProxy.setStatus(2);
                                    applicationProxy.setProxyVersion(version);
                                }
                            }
                        }
                    }
                    catch (IOException ex) {
                        LOGGER.log(Level.INFO, "Merging of Application graphs failed", ex);
                    }
                }
            });
            try {
                DDParse parseResult = this.parseDD(fo);
                Application original = DDProvider.createApplication(parseResult);
                applicationProxy = new ApplicationProxy(original, parseResult.getVersion());
                DDProvider.setProxyErrorStatus(applicationProxy, parseResult);
            }
            catch (SAXException ex) {
                applicationProxy = new ApplicationProxy(org.netbeans.modules.j2ee.dd.impl.application.model_1_4.Application.createGraph(), "2.0");
                applicationProxy.setStatus(2);
                if (ex instanceof SAXParseException) {
                    applicationProxy.setError((SAXParseException)ex);
                }
                if (!(ex.getException() instanceof SAXParseException)) break block12;
                applicationProxy.setError((SAXParseException)ex.getException());
            }
        }
        map = this.ddMap;
        synchronized (map) {
            ApplicationProxy cached = this.getFromCache(fo);
            if (cached != null) {
                return cached;
            }
            this.ddMap.put(fo, applicationProxy);
        }
        return applicationProxy;
    }

    public Application getDDRootCopy(FileObject fo) throws IOException {
        return (Application)this.getDDRoot(fo).clone();
    }

    private ApplicationProxy getFromCache(FileObject fo) {
        return this.ddMap.get(fo);
    }

    public Application getDDRoot(InputSource is) throws IOException, SAXException {
        DDParse parse = this.parseDD(is);
        Application application = DDProvider.createApplication(parse);
        ApplicationProxy proxy = new ApplicationProxy(application, application.getVersion().toString());
        DDProvider.setProxyErrorStatus(proxy, parse);
        return proxy;
    }

    public BaseBean getBaseBean(CommonDDBean bean) {
        if (bean instanceof BaseBean) {
            return (BaseBean)bean;
        }
        if (bean instanceof ApplicationProxy) {
            return (BaseBean)((ApplicationProxy)bean).getOriginal();
        }
        return null;
    }

    private static void setProxyErrorStatus(ApplicationProxy applicationProxy, DDParse parse) {
        SAXParseException error = parse.getWarning();
        applicationProxy.setError(error);
        if (error != null) {
            applicationProxy.setStatus(1);
        } else {
            applicationProxy.setStatus(0);
        }
    }

    private static Application createApplication(DDParse parse) {
        Application jar = null;
        String version = parse.getVersion();
        if ("1.4".equals(version)) {
            return new org.netbeans.modules.j2ee.dd.impl.application.model_1_4.Application(parse.getDocument(), 1);
        }
        if ("5".equals(version)) {
            return new org.netbeans.modules.j2ee.dd.impl.application.model_5.Application(parse.getDocument(), 1);
        }
        if ("6".equals(version)) {
            return new org.netbeans.modules.j2ee.dd.impl.application.model_6.Application(parse.getDocument(), 1);
        }
        if ("7".equals(version)) {
            return new org.netbeans.modules.j2ee.dd.impl.application.model_7.Application(parse.getDocument(), 1);
        }
        if ("8".equals(version)) {
            return new org.netbeans.modules.j2ee.dd.impl.application.model_8.Application(parse.getDocument(), 1);
        }
        if ("9".equals(version)) {
            return new org.netbeans.modules.j2ee.dd.impl.application.model_9.Application(parse.getDocument(), 1);
        }
        if ("10".equals(version)) {
            return new org.netbeans.modules.j2ee.dd.impl.application.model_10.Application(parse.getDocument(), 1);
        }
        if ("11".equals(version)) {
            return new org.netbeans.modules.j2ee.dd.impl.application.model_11.Application(parse.getDocument(), 1);
        }
        return jar;
    }

    public SAXParseException parse(FileObject fo) throws SAXException, IOException {
        DDParse parseResult = this.parseDD(fo);
        return parseResult.getWarning();
    }

    private DDParse parseDD(FileObject fo) throws SAXException, IOException {
        try (InputStream inputStream = fo.getInputStream();){
            DDParse dDParse = this.parseDD(inputStream);
            return dDParse;
        }
    }

    private DDParse parseDD(InputStream is) throws SAXException, IOException {
        return this.parseDD(new InputSource(is));
    }

    private DDParse parseDD(InputSource is) throws SAXException, IOException {
        ErrorHandler errorHandler = new ErrorHandler();
        DocumentBuilder parser = null;
        try {
            DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
            parser = fact.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new SAXException(ex.getMessage());
        }
        parser.setErrorHandler(errorHandler);
        parser.setEntityResolver(DDResolver.getInstance());
        Document d = parser.parse(is);
        SAXParseException error = errorHandler.getError();
        return new DDParse(d, error);
    }

    private static class DDParse {
        private final Document document;
        private final SAXParseException saxException;
        private String version;

        public DDParse(Document d, SAXParseException saxEx) {
            this.document = d;
            this.saxException = saxEx;
            this.extractVersion();
        }

        public Document getDocument() {
            return this.document;
        }

        private void extractVersion() {
            Node appNode;
            NamedNodeMap attrs;
            Node vNode;
            NodeList nl;
            this.version = "7";
            DocumentType dt = this.document.getDoctype();
            if (dt == null && (nl = this.document.getElementsByTagName("application")) != null && nl.getLength() > 0 && (vNode = (attrs = (appNode = nl.item(0)).getAttributes()).getNamedItem("version")) != null) {
                String versionValue = vNode.getNodeValue();
                this.version = "11".equals(versionValue) ? "11" : ("10".equals(versionValue) ? "10" : ("9".equals(versionValue) ? "9" : ("8".equals(versionValue) ? "8" : ("7".equals(versionValue) ? "7" : ("6".equals(versionValue) ? "6" : ("5".equals(versionValue) ? "5" : ("1.4".equals(versionValue) ? "1.4" : "7")))))));
            }
        }

        public String getVersion() {
            return this.version;
        }

        public SAXParseException getWarning() {
            return this.saxException;
        }
    }

    private static class ErrorHandler
    implements org.xml.sax.ErrorHandler {
        private int errorType = -1;
        SAXParseException error;

        private ErrorHandler() {
        }

        @Override
        public void warning(SAXParseException sAXParseException) throws SAXException {
            if (this.errorType < 0) {
                this.errorType = 0;
                this.error = sAXParseException;
            }
        }

        @Override
        public void error(SAXParseException sAXParseException) throws SAXException {
            if (this.errorType < 1) {
                this.errorType = 1;
                this.error = sAXParseException;
            }
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.errorType = 2;
            throw sAXParseException;
        }

        public int getErrorType() {
            return this.errorType;
        }

        public SAXParseException getError() {
            return this.error;
        }
    }

    private static class DDResolver
    implements EntityResolver {
        static DDResolver resolver;

        private DDResolver() {
        }

        static synchronized DDResolver getInstance() {
            if (resolver == null) {
                resolver = new DDResolver();
            }
            return resolver;
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            if ("http://java.sun.com/xml/ns/j2ee/application_1_4.xsd".equals(systemId)) {
                return new InputSource("nbres:/org/netbeans/modules/j2ee/dd/impl/resources/application_1_4.xsd");
            }
            if ("http://java.sun.com/xml/ns/javaee/application_5.xsd".equals(systemId)) {
                return new InputSource("nbres:/org/netbeans/modules/javaee/dd/impl/resources/application_5.xsd");
            }
            if ("http://java.sun.com/xml/ns/javaee/application_6.xsd".equals(systemId)) {
                return new InputSource("nbres:/org/netbeans/modules/javaee/dd/impl/resources/application_6.xsd");
            }
            if ("http://xmlns.jcp.org/xml/ns/javaee/application_7.xsd".equals(systemId)) {
                return new InputSource("nbres:/org/netbeans/modules/javaee/dd/impl/resources/application_7.xsd");
            }
            if ("http://xmlns.jcp.org/xml/ns/javaee/application_8.xsd".equals(systemId)) {
                return new InputSource("nbres:/org/netbeans/modules/javaee/dd/impl/resources/application_8.xsd");
            }
            if ("https://jakarta.ee/xml/ns/jakartaee/application_9.xsd".equals(systemId)) {
                return new InputSource("nbres:/org/netbeans/modules/javaee/dd/impl/resources/application_9.xsd");
            }
            if ("https://jakarta.ee/xml/ns/jakartaee/application_10.xsd".equals(systemId)) {
                return new InputSource("nbres:/org/netbeans/modules/javaee/dd/impl/resources/application_10.xsd");
            }
            if ("https://jakarta.ee/xml/ns/jakartaee/application_11.xsd".equals(systemId)) {
                return new InputSource("nbres:/org/netbeans/modules/javaee/dd/impl/resources/application_11.xsd");
            }
            return null;
        }
    }
}

