/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.util;

import java.util.ArrayList;
import org.netbeans.modules.versioning.util.CollectionUtils;
import org.openide.util.lookup.AbstractLookup;

public class SimpleLookup
extends AbstractLookup {
    protected final Object dataSetLock = new Object();

    public void setData(Object ... data) {
        this.validateData(data);
        data = this.rectifyData(data);
        if (data == null) {
            throw new IllegalArgumentException("null");
        }
        this.setValidatedData(data);
    }

    protected void validateData(Object[] data) throws IllegalArgumentException {
        if (data == null) {
            throw new IllegalArgumentException("null");
        }
    }

    protected Object[] rectifyData(Object[] data) {
        return CollectionUtils.removeItem(CollectionUtils.removeDuplicates(data), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setValidatedData(Object[] data) {
        Object object = this.dataSetLock;
        synchronized (object) {
            this.setDataImpl(data);
        }
    }

    protected final void setDataImpl(Object[] data) {
        if (!Thread.holdsLock(this.dataSetLock)) {
            throw new IllegalStateException("This method must be called with the dataSetLock held being held by the current thread.");
        }
        if (data == null) {
            throw new IllegalArgumentException("null");
        }
        ArrayList<SimpleItem<Object>> pairs = new ArrayList<SimpleItem<Object>>(data.length);
        for (Object d : data) {
            pairs.add(new SimpleItem<Object>(d));
        }
        this.setPairs(pairs);
    }

    private static final class SimpleItem<T>
    extends AbstractLookup.Pair<T> {
        private T obj;

        public SimpleItem(T obj) {
            if (obj == null) {
                throw new NullPointerException();
            }
            this.obj = obj;
        }

        public boolean instanceOf(Class<?> c) {
            return c.isInstance(this.obj);
        }

        public T getInstance() {
            return this.obj;
        }

        public boolean equals(Object o) {
            if (o instanceof SimpleItem) {
                return this.obj.equals(((SimpleItem)((Object)o)).obj);
            }
            return false;
        }

        public int hashCode() {
            return this.obj.hashCode();
        }

        public String getId() {
            return "IL[" + this.obj.toString();
        }

        public String getDisplayName() {
            return this.obj.toString();
        }

        protected boolean creatorOf(Object obj) {
            return obj == this.obj;
        }

        public Class<? extends T> getType() {
            return this.obj.getClass();
        }
    }
}

