/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.timers;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.util.Utilities;

public class InstanceWatcher {
    private final Map<Reference<Object>, Boolean> references = new IdentityHashMap<Reference<Object>, Boolean>();
    private transient List<WeakReference<ChangeListener>> changeListenerList;

    private Map<Reference<Object>, Boolean> getReferences() {
        assert (Thread.holdsLock(this));
        return this.references;
    }

    public synchronized void add(Object instance) {
        if (!this.contains(instance)) {
            this.getReferences().put(new CleanableWeakReference(instance), true);
        }
    }

    private synchronized boolean contains(Object o) {
        for (Reference<Object> r : this.getReferences().keySet()) {
            if (r.get() != o) continue;
            return true;
        }
        return false;
    }

    public synchronized int size() {
        return this.getReferences().size();
    }

    public synchronized Collection<?> getInstances() {
        ArrayList<Object> l = new ArrayList<Object>(this.getReferences().size());
        for (Reference<Object> wr : this.getReferences().keySet()) {
            Object inst = wr.get();
            if (inst == null) continue;
            l.add(inst);
        }
        return l;
    }

    public synchronized void addChangeListener(ChangeListener listener) {
        if (this.changeListenerList == null) {
            this.changeListenerList = new ArrayList<WeakReference<ChangeListener>>();
        }
        this.changeListenerList.add(new WeakReference<ChangeListener>(listener));
    }

    public synchronized void removeChangeListener(ChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeListenerList != null) {
            for (WeakReference<ChangeListener> r : this.changeListenerList) {
                if (!listener.equals(r.get())) continue;
                this.changeListenerList.remove(r);
            }
        }
    }

    private static <T> void cleanAndCopy(List<? extends Reference<T>> src, List<? super T> dest) {
        for (int i = src.size() - 1; i >= 0; --i) {
            T o = src.get(i).get();
            if (o == null) {
                src.remove(i);
                continue;
            }
            if (dest == null) continue;
            dest.add(0, o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChangeListenerStateChanged() {
        LinkedList list = new LinkedList();
        InstanceWatcher instanceWatcher = this;
        synchronized (instanceWatcher) {
            if (this.changeListenerList == null) {
                return;
            }
            InstanceWatcher.cleanAndCopy(this.changeListenerList, list);
        }
        ChangeEvent e = new ChangeEvent(this);
        for (ChangeListener ch : list) {
            ch.stateChanged(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void cleanUp(CleanableWeakReference cwr) {
        InstanceWatcher instanceWatcher = this;
        synchronized (instanceWatcher) {
            this.getReferences().remove(cwr);
        }
        this.fireChangeListenerStateChanged();
    }

    private final class CleanableWeakReference
    extends WeakReference<Object>
    implements Runnable {
        public CleanableWeakReference(Object i) {
            super(i, Utilities.activeReferenceQueue());
        }

        @Override
        public void run() {
            InstanceWatcher.this.cleanUp(this);
        }
    }
}

