/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.tasks.cache;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class StorageUtils {
    public static void deleteRecursively(File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                StorageUtils.deleteRecursively(files[i]);
            }
        }
        file.delete();
    }

    static class FileLocks {
        private static FileLocks instance;
        private final Map<String, FileLock> locks = new HashMap<String, FileLock>();

        FileLocks() {
        }

        private static synchronized FileLocks getInstance() {
            if (instance == null) {
                instance = new FileLocks();
            }
            return instance;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static FileLock getLock(File file) {
            Map<String, FileLock> map = FileLocks.getInstance().locks;
            synchronized (map) {
                FileLock fl = FileLocks.getInstance().locks.get(file.getAbsolutePath());
                if (fl == null) {
                    FileLocks fileLocks = FileLocks.getInstance();
                    Objects.requireNonNull(fileLocks);
                    fl = fileLocks.new FileLock(file);
                }
                FileLocks.getInstance().locks.put(file.getAbsolutePath(), fl);
                return fl;
            }
        }

        class FileLock {
            private final File file;

            public FileLock(File file) {
                this.file = file;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void release() {
                Map map = FileLocks.getInstance().locks;
                synchronized (map) {
                    FileLocks.getInstance().locks.remove(this.file.getAbsolutePath());
                }
            }
        }
    }
}

