/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.analysis.ui.analyzer;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.concurrent.TimeUnit;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.netbeans.modules.analysis.spi.Analyzer;
import org.netbeans.modules.php.analysis.options.AnalysisOptions;
import org.netbeans.modules.php.analysis.options.AnalysisOptionsValidator;
import org.netbeans.modules.php.analysis.options.ValidatorPsalmParameter;
import org.netbeans.modules.php.analysis.ui.AnalysisDefaultDocumentListener;
import org.netbeans.modules.php.analysis.util.AnalysisUiUtils;
import org.netbeans.modules.php.api.validation.ValidationResult;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class PsalmCustomizerPanel
extends JPanel {
    public static final String ENABLED = "psalm.enabled";
    public static final String PATH = "psalm.path";
    public static final String LEVEL = "psalm.level";
    public static final String CONFIGURATION = "psalm.configuration";
    public static final String MEMORY_LIMIT = "psalm.memory.limit";
    private static final RequestProcessor RP = new RequestProcessor(PsalmCustomizerPanel.class);
    private static final long serialVersionUID = -3450253368766485405L;
    final Analyzer.CustomizerContext<Void, PsalmCustomizerPanel> context;
    final Preferences settings;
    private JButton psalmBrowseButton;
    private JButton psalmConfigurationBrowseButton;
    private JLabel psalmConfigurationLabel;
    private JTextField psalmConfigurationTextField;
    private JCheckBox psalmEnabledCheckBox;
    private JLabel psalmLabel;
    private JComboBox<String> psalmLevelComboBox;
    private JLabel psalmLevelLabel;
    private JLabel psalmMemoryLimitLabel;
    private JTextField psalmMemoryLimitTextField;
    private JButton psalmSearchButton;
    private JTextField psalmTextField;

    public PsalmCustomizerPanel(Analyzer.CustomizerContext<Void, PsalmCustomizerPanel> context) {
        assert (EventQueue.isDispatchThread());
        assert (context != null);
        this.context = context;
        this.settings = context.getSettings();
        this.initComponents();
        this.init();
    }

    private void init() {
        this.initEnabledCheckBox();
        this.initPsalmField();
        this.initLevelComboBox();
        this.initConfigurationTextField();
        this.initMemoryLimitTextField();
        RP.schedule(() -> EventQueue.invokeLater(() -> {
            this.context.setError(null);
            if (this.psalmEnabledCheckBox.isSelected()) {
                this.validateData();
            }
        }), 1000L, TimeUnit.MILLISECONDS);
    }

    private void initEnabledCheckBox() {
        assert (EventQueue.isDispatchThread());
        this.psalmEnabledCheckBox.addItemListener(e -> {
            this.setAllComponetsEnabled(this.psalmEnabledCheckBox.isSelected());
            this.setPsalmEnabled();
        });
        boolean isEnabled = this.settings.getBoolean(ENABLED, false);
        this.psalmEnabledCheckBox.setSelected(isEnabled);
        this.setAllComponetsEnabled(isEnabled);
        this.psalmEnabledCheckBox.addItemListener(e -> {
            if (!this.psalmEnabledCheckBox.isSelected()) {
                this.context.setError(null);
            } else {
                this.validateData();
            }
        });
    }

    private void initPsalmField() {
        assert (EventQueue.isDispatchThread());
        this.psalmTextField.setText(this.settings.get(PATH, AnalysisOptions.getInstance().getPsalmPath()));
        this.psalmTextField.getDocument().addDocumentListener(new AnalysisDefaultDocumentListener(() -> this.setPsalmPath()));
    }

    private void initLevelComboBox() {
        assert (EventQueue.isDispatchThread());
        this.psalmLevelComboBox.removeAllItems();
        this.psalmLevelComboBox.addItem("");
        for (int i = AnalysisOptions.PSALM_MIN_LEVEL; i <= AnalysisOptions.PSALM_MAX_LEVEL; ++i) {
            this.psalmLevelComboBox.addItem(String.valueOf(i));
        }
        this.psalmLevelComboBox.setSelectedItem(this.getValidLevel());
        this.psalmLevelComboBox.addItemListener(e -> this.setLevel());
    }

    private String getValidLevel() {
        String level = this.settings.get(LEVEL, AnalysisOptions.getInstance().getPsalmLevel());
        return AnalysisOptions.getValidPsalmLevel(level);
    }

    private void initConfigurationTextField() {
        assert (EventQueue.isDispatchThread());
        this.psalmConfigurationTextField.setText(this.settings.get(CONFIGURATION, AnalysisOptions.getInstance().getPsalmConfigurationPath()));
        this.psalmConfigurationTextField.getDocument().addDocumentListener(new AnalysisDefaultDocumentListener(() -> this.setConfiguration()));
    }

    private void initMemoryLimitTextField() {
        assert (EventQueue.isDispatchThread());
        this.psalmMemoryLimitTextField.setText(this.settings.get(MEMORY_LIMIT, AnalysisOptions.getInstance().getPsalmMemoryLimit()));
        this.psalmMemoryLimitTextField.getDocument().addDocumentListener(new AnalysisDefaultDocumentListener(() -> this.setMemoryLimit()));
    }

    public String getPsalmPath() {
        return this.psalmTextField.getText().trim();
    }

    public String getLevel() {
        return (String)this.psalmLevelComboBox.getSelectedItem();
    }

    public String getConfiguration() {
        return this.psalmConfigurationTextField.getText().trim();
    }

    public String getMemoryLimit() {
        return this.psalmMemoryLimitTextField.getText().trim();
    }

    private void setPsalmEnabled() {
        this.settings.putBoolean(ENABLED, this.psalmEnabledCheckBox.isSelected());
    }

    private void setPsalmPath() {
        if (this.validateData()) {
            this.settings.put(PATH, this.getPsalmPath());
        }
    }

    private void setLevel() {
        this.settings.put(LEVEL, this.getLevel());
    }

    private void setConfiguration() {
        if (this.validateData()) {
            this.settings.put(CONFIGURATION, this.getConfiguration());
        }
    }

    private void setMemoryLimit() {
        if (this.validateData()) {
            this.settings.put(MEMORY_LIMIT, this.getMemoryLimit());
        }
    }

    private boolean validateData() {
        ValidatorPsalmParameter param = ValidatorPsalmParameter.create(this);
        ValidationResult result = new AnalysisOptionsValidator().validatePsalm(param).getResult();
        if (result.hasErrors()) {
            this.context.setError(((ValidationResult.Message)result.getErrors().get(0)).getMessage());
            return false;
        }
        if (result.hasWarnings()) {
            this.context.setError(((ValidationResult.Message)result.getWarnings().get(0)).getMessage());
            return false;
        }
        this.context.setError(null);
        return true;
    }

    private void setAllComponetsEnabled(boolean isEnabled) {
        Component[] components;
        for (Component component : components = this.getComponents()) {
            if (component == this.psalmEnabledCheckBox) continue;
            component.setEnabled(isEnabled);
        }
    }

    private void initComponents() {
        this.psalmEnabledCheckBox = new JCheckBox();
        this.psalmConfigurationLabel = new JLabel();
        this.psalmConfigurationTextField = new JTextField();
        this.psalmConfigurationBrowseButton = new JButton();
        this.psalmLevelLabel = new JLabel();
        this.psalmLevelComboBox = new JComboBox();
        this.psalmMemoryLimitLabel = new JLabel();
        this.psalmMemoryLimitTextField = new JTextField();
        this.psalmLabel = new JLabel();
        this.psalmTextField = new JTextField();
        this.psalmBrowseButton = new JButton();
        this.psalmSearchButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.psalmEnabledCheckBox, (String)NbBundle.getMessage(PsalmCustomizerPanel.class, (String)"PsalmCustomizerPanel.psalmEnabledCheckBox.text"));
        this.psalmConfigurationLabel.setLabelFor(this.psalmConfigurationTextField);
        Mnemonics.setLocalizedText((JLabel)this.psalmConfigurationLabel, (String)NbBundle.getMessage(PsalmCustomizerPanel.class, (String)"PsalmCustomizerPanel.psalmConfigurationLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.psalmConfigurationBrowseButton, (String)NbBundle.getMessage(PsalmCustomizerPanel.class, (String)"PsalmCustomizerPanel.psalmConfigurationBrowseButton.text"));
        this.psalmConfigurationBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PsalmCustomizerPanel.this.psalmConfigurationBrowseButtonActionPerformed(evt);
            }
        });
        this.psalmLevelLabel.setLabelFor(this.psalmLevelComboBox);
        Mnemonics.setLocalizedText((JLabel)this.psalmLevelLabel, (String)NbBundle.getMessage(PsalmCustomizerPanel.class, (String)"PsalmCustomizerPanel.psalmLevelLabel.text"));
        this.psalmLevelComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"0", "1", "2", "3", "4", "5", "6", "7"}));
        this.psalmMemoryLimitLabel.setLabelFor(this.psalmMemoryLimitTextField);
        Mnemonics.setLocalizedText((JLabel)this.psalmMemoryLimitLabel, (String)NbBundle.getMessage(PsalmCustomizerPanel.class, (String)"PsalmCustomizerPanel.psalmMemoryLimitLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.psalmLabel, (String)NbBundle.getMessage(PsalmCustomizerPanel.class, (String)"PsalmCustomizerPanel.psalmLabel.text"));
        this.psalmLabel.setRequestFocusEnabled(false);
        this.psalmTextField.setText(NbBundle.getMessage(PsalmCustomizerPanel.class, (String)"PsalmCustomizerPanel.psalmTextField.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.psalmBrowseButton, (String)NbBundle.getMessage(PsalmCustomizerPanel.class, (String)"PsalmCustomizerPanel.psalmBrowseButton.text"));
        this.psalmBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PsalmCustomizerPanel.this.psalmBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.psalmSearchButton, (String)NbBundle.getMessage(PsalmCustomizerPanel.class, (String)"PsalmCustomizerPanel.psalmSearchButton.text"));
        this.psalmSearchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PsalmCustomizerPanel.this.psalmSearchButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.psalmEnabledCheckBox).addContainerGap(-1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.psalmLabel, GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.psalmConfigurationLabel).addComponent(this.psalmLevelLabel).addComponent(this.psalmMemoryLimitLabel))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.psalmLevelComboBox, -2, -1, -2).addComponent(this.psalmMemoryLimitTextField, -2, 100, -2)).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.psalmConfigurationTextField).addComponent(this.psalmTextField)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.psalmBrowseButton, GroupLayout.Alignment.TRAILING).addComponent(this.psalmConfigurationBrowseButton, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.psalmSearchButton)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.psalmEnabledCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.psalmLabel).addComponent(this.psalmTextField, -2, -1, -2).addComponent(this.psalmBrowseButton).addComponent(this.psalmSearchButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.psalmConfigurationLabel).addComponent(this.psalmConfigurationTextField, -2, -1, -2).addComponent(this.psalmConfigurationBrowseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.psalmLevelLabel).addComponent(this.psalmLevelComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.psalmMemoryLimitLabel).addComponent(this.psalmMemoryLimitTextField, -2, -1, -2))));
        this.psalmLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PsalmCustomizerPanel.class, (String)"PsalmCustomizerPanel.psalmLabel.AccessibleContext.accessibleName"));
    }

    private void psalmConfigurationBrowseButtonActionPerformed(ActionEvent evt) {
        File file = AnalysisUiUtils.browsePsalmConfiguration();
        if (file != null) {
            this.psalmConfigurationTextField.setText(file.getAbsolutePath());
        }
    }

    private void psalmBrowseButtonActionPerformed(ActionEvent evt) {
        File file = AnalysisUiUtils.browsePsalm();
        if (file != null) {
            this.psalmTextField.setText(file.getAbsolutePath());
        }
    }

    private void psalmSearchButtonActionPerformed(ActionEvent evt) {
        String psalm = AnalysisUiUtils.searchPsalm();
        if (psalm != null) {
            this.psalmTextField.setText(psalm);
        }
    }
}

