/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.navigation;

import java.awt.Image;
import java.io.IOException;
import javax.swing.Action;
import org.netbeans.modules.web.jsf.navigation.Page;
import org.netbeans.modules.web.jsf.navigation.graph.PageFlowSceneElement;
import org.netbeans.modules.web.jsf.navigation.pagecontentmodel.PageContentItem;
import org.openide.ErrorManager;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class Pin
extends PageFlowSceneElement {
    private final Page page;
    private boolean bDefault = true;
    private PageContentItem pageContentItem;
    private Node pinNode;

    public Pin(Page page) {
        this.page = page;
    }

    public Pin(Page page, PageContentItem pageContentItem) {
        this(page);
        assert (pageContentItem != null);
        this.pageContentItem = pageContentItem;
        this.bDefault = false;
    }

    public boolean isDefault() {
        return this.bDefault;
    }

    public String toString() {
        return new String("Pin[pagename=" + this.page.getDisplayName() + " isDefault=" + this.isDefault() + "] ");
    }

    @Override
    public Image getIcon(int type) {
        if (this.pageContentItem != null) {
            return this.pageContentItem.getBufferedIcon();
        }
        return null;
    }

    @Override
    public String getName() {
        if (this.pageContentItem != null) {
            return this.pageContentItem.getName();
        }
        return null;
    }

    public String getFromAction() {
        if (this.pageContentItem != null) {
            return this.pageContentItem.getFromAction();
        }
        return null;
    }

    public String getFromOutcome() {
        if (!this.bDefault) {
            return this.pageContentItem.getFromOutcome();
        }
        return null;
    }

    public void setFromOutcome(String fromOutcome) {
        if (this.pageContentItem != null) {
            this.pageContentItem.setFromOutcome(fromOutcome);
        }
    }

    public void setFromAction(String fromAction) {
        if (this.pageContentItem != null) {
            this.pageContentItem.setFromAction(fromAction);
        }
    }

    public Page getPage() {
        return this.page;
    }

    public Action[] getActions() {
        if (this.pageContentItem != null) {
            return this.pageContentItem.getActions();
        }
        return new Action[0];
    }

    public <T extends Node.Cookie> T getCookie(Class<T> type) {
        return this.pageContentItem.getCookie(type);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public HelpCtx getHelpCtx() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void destroy() throws IOException {
        if (this.pinNode != null) {
            this.pinNode.destroy();
        }
    }

    @Override
    public boolean canDestroy() {
        return false;
    }

    @Override
    public boolean canRename() {
        return false;
    }

    @Override
    public Node getNode() {
        if (this.pinNode == null) {
            this.pinNode = new PinNode();
        }
        return this.pinNode;
    }

    private final Pin getInstance() {
        return this;
    }

    private class PinNode
    extends AbstractNode {
        public PinNode() {
            super(Children.LEAF);
        }

        public <T extends Node.Cookie> T getCookie(Class<T> type) {
            T cookie = Pin.this.getInstance().getCookie(type);
            if (cookie != null) {
                return cookie;
            }
            return Pin.this.page.getCookie(type);
        }

        protected Sheet createSheet() {
            Sheet s = Sheet.createDefault();
            Sheet.Set ss = s.get("general");
            if (ss == null) {
                ss = new Sheet.Set();
                ss.setName("general");
                ss.setDisplayName(NbBundle.getMessage(Pin.class, (String)"General"));
                ss.setShortDescription(NbBundle.getMessage(Pin.class, (String)"GeneralHint"));
                s.put(ss);
            }
            Sheet.Set gs = ss;
            try {
                PropertySupport.Reflection p = new PropertySupport.Reflection((Object)Pin.this.pageContentItem, String.class, "getName", "setName");
                p.setName("fromView");
                p.setDisplayName(NbBundle.getMessage(Pin.class, (String)"FromView"));
                p.setShortDescription(NbBundle.getMessage(Pin.class, (String)"FromViewHint"));
                ss.put((Node.Property)p);
                p = new PropertySupport.Reflection((Object)Pin.this.pageContentItem, String.class, "getFromOutcome", "setFromOutcome");
                p.setName("fromOutcome");
                p.setDisplayName(NbBundle.getMessage(Pin.class, (String)"Outcome"));
                p.setShortDescription(NbBundle.getMessage(Pin.class, (String)"OutcomeHint"));
                ss.put((Node.Property)p);
            }
            catch (NoSuchMethodException nsme) {
                ErrorManager.getDefault().notify((Throwable)nsme);
            }
            return s;
        }
    }
}

