/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.hcl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.netbeans.api.editor.fold.FoldType;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.csl.spi.DefaultError;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.languages.hcl.HCLLanguage;
import org.netbeans.modules.languages.hcl.SourceRef;
import org.netbeans.modules.languages.hcl.ast.HCLBlockFactory;
import org.netbeans.modules.languages.hcl.ast.HCLDocument;
import org.netbeans.modules.languages.hcl.ast.HCLElement;
import org.netbeans.modules.languages.hcl.grammar.HCLLexer;
import org.netbeans.modules.languages.hcl.grammar.HCLParser;
import org.netbeans.modules.languages.hcl.grammar.HCLParserBaseListener;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.spi.lexer.antlr4.AntlrTokenSequence;
import org.openide.filesystems.FileObject;

public class HCLParserResult
extends ParserResult {
    protected final List<DefaultError> errors = new ArrayList<DefaultError>();
    protected volatile boolean finished;
    public final Map<String, List<OffsetRange>> folds = new HashMap<String, List<OffsetRange>>();
    private HCLDocument document;
    private final SourceRef references;

    public HCLParserResult(Snapshot snapshot) {
        super(snapshot);
        this.references = new SourceRef(snapshot);
    }

    protected final FileObject getFileObject() {
        return this.getSnapshot().getSource().getFileObject();
    }

    public void compute() {
        if (!this.finished) {
            CodePointCharStream source = CharStreams.fromString((String)this.getSnapshot().getText().toString());
            HCLLexer lexer = new HCLLexer((CharStream)source);
            lexer.removeErrorListeners();
            this.collectCommentFolds(lexer);
            HCLParser parser = new HCLParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
            this.configureParser(parser);
            HCLBlockFactory bf = new HCLBlockFactory(this.references::elementCreated);
            this.document = bf.process(parser.configFile());
            lexer.reset();
        }
        this.processDocument(this.document, this.references);
        this.finished = true;
    }

    private void collectCommentFolds(HCLLexer lexer) {
        boolean firstComment = true;
        AntlrTokenSequence tokens = new AntlrTokenSequence((TokenSource)lexer);
        while (tokens.hasNext()) {
            Token token = (Token)tokens.next().get();
            if (token.getChannel() == 1) continue;
            if (token.getType() == 1 && token.getText().contains("\n")) {
                this.addFold(firstComment ? FoldType.INITIAL_COMMENT : FoldType.COMMENT, token);
            }
            firstComment = false;
        }
        lexer.reset();
    }

    protected boolean processingFinished() {
        return this.finished;
    }

    public List<? extends Error> getDiagnostics() {
        return this.errors;
    }

    public final HCLDocument getDocument() {
        return this.document;
    }

    public final SourceRef getReferences() {
        return this.references;
    }

    protected void invalidate() {
    }

    protected void configureParser(HCLParser parser) {
        parser.removeErrorListeners();
        parser.addErrorListener(this.createErrorListener());
        parser.addParseListener(this.createFoldListener());
    }

    protected void processDocument(HCLDocument doc, SourceRef references) {
    }

    protected void addError(HCLElement e, String message) {
        this.references.getOffsetRange(e).ifPresent(range -> this.addError(message, (OffsetRange)range));
    }

    private void addError(String message, OffsetRange range) {
        DefaultError error = new DefaultError(null, message, null, this.getFileObject(), range.getStart(), range.getEnd(), false, Severity.ERROR);
        this.errors.add(error);
    }

    private void addFold(FoldType ft, Token token) {
        if (token.getText().contains("\n") && token.getStartIndex() < token.getStopIndex()) {
            List foldBag = this.folds.computeIfAbsent(ft.code(), t -> new ArrayList());
            OffsetRange range = new OffsetRange(token.getStartIndex(), token.getStopIndex() + 1);
            foldBag.add(range);
        }
    }

    private void addFold(FoldType ft, Token start, Token stop) {
        int stopPos;
        int startPos;
        if (start.getLine() < stop.getLine() && (startPos = start.getStartIndex()) < (stopPos = stop.getStopIndex() + 1)) {
            List foldBag = this.folds.computeIfAbsent(ft.code(), t -> new ArrayList());
            OffsetRange range = new OffsetRange(startPos, stopPos);
            foldBag.add(range);
        }
    }

    private void addFold(FoldType ft, TerminalNode start, TerminalNode stop) {
        if (start != null && stop != null) {
            this.addFold(ft, start.getSymbol(), stop.getSymbol());
        }
    }

    private ANTLRErrorListener createErrorListener() {
        return new BaseErrorListener(){

            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                int errorStart = 0;
                int errorEnd = 0;
                if (offendingSymbol instanceof Token) {
                    Token offendingToken = (Token)offendingSymbol;
                    errorStart = offendingToken.getStartIndex();
                    errorEnd = offendingToken.getStopIndex() + 1;
                }
                HCLParserResult.this.errors.add(new DefaultError(null, msg, null, HCLParserResult.this.getFileObject(), errorStart, errorEnd, errorStart == errorEnd, Severity.ERROR));
            }
        };
    }

    private ParseTreeListener createFoldListener() {
        return new HCLParserBaseListener(){

            @Override
            public void exitHeredoc(HCLParser.HeredocContext ctx) {
                HCLParserResult.this.addFold(HCLLanguage.HCLFold.HEREDOC, ctx.HEREDOC_START(), ctx.HEREDOC_END());
            }

            @Override
            public void exitBlock(HCLParser.BlockContext ctx) {
                HCLParserResult.this.addFold(FoldType.CODE_BLOCK, ctx.LBRACE(), ctx.RBRACE());
            }

            @Override
            public void exitForObjectExpr(HCLParser.ForObjectExprContext ctx) {
                HCLParserResult.this.addFold(HCLLanguage.HCLFold.OBJECT, ctx.LBRACE(), ctx.RBRACE());
            }

            @Override
            public void exitForTupleExpr(HCLParser.ForTupleExprContext ctx) {
                HCLParserResult.this.addFold(HCLLanguage.HCLFold.TUPLE, ctx.LBRACK(), ctx.RBRACK());
            }

            @Override
            public void exitObject(HCLParser.ObjectContext ctx) {
                HCLParserResult.this.addFold(HCLLanguage.HCLFold.OBJECT, ctx.LBRACE(), ctx.RBRACE());
            }

            @Override
            public void exitTuple(HCLParser.TupleContext ctx) {
                HCLParserResult.this.addFold(HCLLanguage.HCLFold.TUPLE, ctx.LBRACK(), ctx.RBRACK());
            }
        };
    }
}

