/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.monitoring.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Suppression
extends ExplicitlySetBmcModel {
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="timeSuppressFrom")
    private final Date timeSuppressFrom;
    @JsonProperty(value="timeSuppressUntil")
    private final Date timeSuppressUntil;

    @Deprecated
    @ConstructorProperties(value={"description", "timeSuppressFrom", "timeSuppressUntil"})
    public Suppression(String description, Date timeSuppressFrom, Date timeSuppressUntil) {
        this.description = description;
        this.timeSuppressFrom = timeSuppressFrom;
        this.timeSuppressUntil = timeSuppressUntil;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDescription() {
        return this.description;
    }

    public Date getTimeSuppressFrom() {
        return this.timeSuppressFrom;
    }

    public Date getTimeSuppressUntil() {
        return this.timeSuppressUntil;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Suppression(");
        sb.append("super=").append(super.toString());
        sb.append("description=").append(String.valueOf(this.description));
        sb.append(", timeSuppressFrom=").append(String.valueOf(this.timeSuppressFrom));
        sb.append(", timeSuppressUntil=").append(String.valueOf(this.timeSuppressUntil));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Suppression)) {
            return false;
        }
        Suppression other = (Suppression)((Object)o);
        return Objects.equals(this.description, other.description) && Objects.equals(this.timeSuppressFrom, other.timeSuppressFrom) && Objects.equals(this.timeSuppressUntil, other.timeSuppressUntil) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.timeSuppressFrom == null ? 43 : this.timeSuppressFrom.hashCode());
        result = result * 59 + (this.timeSuppressUntil == null ? 43 : this.timeSuppressUntil.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="timeSuppressFrom")
        private Date timeSuppressFrom;
        @JsonProperty(value="timeSuppressUntil")
        private Date timeSuppressUntil;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder timeSuppressFrom(Date timeSuppressFrom) {
            this.timeSuppressFrom = timeSuppressFrom;
            this.__explicitlySet__.add("timeSuppressFrom");
            return this;
        }

        public Builder timeSuppressUntil(Date timeSuppressUntil) {
            this.timeSuppressUntil = timeSuppressUntil;
            this.__explicitlySet__.add("timeSuppressUntil");
            return this;
        }

        public Suppression build() {
            Suppression model = new Suppression(this.description, this.timeSuppressFrom, this.timeSuppressUntil);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Suppression model) {
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("timeSuppressFrom")) {
                this.timeSuppressFrom(model.getTimeSuppressFrom());
            }
            if (model.wasPropertyExplicitlySet("timeSuppressUntil")) {
                this.timeSuppressUntil(model.getTimeSuppressUntil());
            }
            return this;
        }
    }
}

