/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.developer;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.netbeans.modules.cloud.oracle.adm.URLProvider;
import org.netbeans.modules.cloud.oracle.items.OCID;
import org.netbeans.modules.cloud.oracle.items.OCIItem;
import org.openide.util.Exceptions;

public final class ContainerTagItem
extends OCIItem
implements URLProvider {
    private String digest;
    private String version;
    private String namespace;
    private String repositoryName;

    public ContainerTagItem(OCID id, String compartmentId, String repositoryName, String regionCode, String namespace, String version, String digest, String tenancyId) {
        super(id, compartmentId, version != null ? version : digest, tenancyId, regionCode);
        this.version = version;
        this.digest = digest;
        this.repositoryName = repositoryName;
        this.namespace = namespace;
    }

    public ContainerTagItem() {
    }

    public String getUrl() {
        if (this.version != null) {
            return String.format("%s.ocir.io/%s/%s:%s", this.getRegionCode(), this.namespace, this.repositoryName, this.version);
        }
        return String.format("%s.ocir.io/%s/%s@%s", this.getRegionCode(), this.namespace, this.repositoryName, this.digest);
    }

    public String getDigest() {
        return this.digest;
    }

    public String getVersion() {
        if (this.version == null) {
            return "";
        }
        return this.version;
    }

    @Override
    public URL getURL() {
        if (this.getKey().getValue() != null && this.getRegion() != null) {
            try {
                URI uri = new URI(String.format("https://cloud.oracle.com/compute/registry/containers?region=%s", this.getRegion()));
                return uri.toURL();
            }
            catch (MalformedURLException | URISyntaxException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }
}

