/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.testng;

import java.util.MissingResourceException;
import org.netbeans.modules.testng.Bundle;
import org.openide.ErrorManager;

final class TestabilityResult {
    private long reason;
    public static final TestabilityResult OK = new TestabilityResult(0L);
    public static final TestabilityResult PACKAGE_PRIVATE_CLASS = new TestabilityResult(1L);
    public static final TestabilityResult NO_TESTEABLE_METHODS = new TestabilityResult(2L);
    public static final TestabilityResult TEST_CLASS = new TestabilityResult(4L);
    public static final TestabilityResult ABSTRACT_CLASS = new TestabilityResult(8L);
    public static final TestabilityResult NONSTATIC_INNER_CLASS = new TestabilityResult(16L);
    public static final TestabilityResult EXCEPTION_CLASS = new TestabilityResult(32L);
    public static final TestabilityResult PRIVATE_CLASS = new TestabilityResult(64L);
    private static final String[] reasonBundleKeys = new String[]{Bundle.TestabilityResult_PkgPrivate(), Bundle.TestabilityResult_NoTestableMethods(), Bundle.TestabilityResult_TestClass(), Bundle.TestabilityResult_AbstractClass(), Bundle.TestabilityResult_NonstaticInnerClass(), Bundle.TestabilityResult_ExceptionClass(), Bundle.TestabilityResult_Private()};

    private TestabilityResult(long reason) {
        this.reason = reason;
    }

    public static TestabilityResult combine(TestabilityResult lhs, TestabilityResult rhs) {
        return new TestabilityResult(lhs.reason | rhs.reason);
    }

    public static TestabilityResult filter(TestabilityResult tr, long mask) {
        return new TestabilityResult(tr.reason & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public boolean isTestable() {
        return this.reason == 0L;
    }

    public boolean isFailed() {
        return this.reason != 0L;
    }

    public long getReasonValue() {
        return this.reason;
    }

    public String getReason() {
        return this.getReason(", ", ", ");
    }

    public String toString() {
        return this.getReason(", ", ", ");
    }

    public String getReason(String separ, String terminalSepar) {
        try {
            if (this.reason == 0L) {
                return Bundle.TestabilityResult_OK();
            }
            Object str = "";
            boolean lastPrep = true;
            long i = 0L;
            long r = this.reason;
            while (r > 0L) {
                if ((r & 1L) != 0L) {
                    if (((String)str).length() > 0) {
                        if (lastPrep) {
                            str = terminalSepar + (String)str;
                            lastPrep = false;
                        } else {
                            str = separ + (String)str;
                        }
                    }
                    str = reasonBundleKeys[(int)i] + (String)str;
                }
                r >>= 1;
                ++i;
            }
            return str;
        }
        catch (MissingResourceException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
            return "";
        }
    }

    static final class SkippedClass {
        final String clsName;
        final TestabilityResult reason;

        SkippedClass(String clsName, TestabilityResult reason) {
            this.clsName = clsName;
            this.reason = reason;
        }
    }
}

