/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common.status;

import java.util.logging.Logger;
import org.netbeans.modules.glassfish.common.GlassFishLogger;
import org.netbeans.modules.glassfish.common.GlassfishInstance;
import org.netbeans.modules.glassfish.common.status.BasicStateListener;
import org.netbeans.modules.glassfish.common.ui.GlassFishCredentials;
import org.netbeans.modules.glassfish.tooling.GlassFishStatus;
import org.netbeans.modules.glassfish.tooling.data.GlassFishServer;
import org.netbeans.modules.glassfish.tooling.data.GlassFishStatusTask;
import org.openide.util.NbBundle;

public class AuthFailureStateListener
extends BasicStateListener {
    private static final Logger LOGGER = GlassFishLogger.get(AuthFailureStateListener.class);
    private static final long POPUP_DELAY = 30000L;
    private volatile boolean popUpLock = false;
    private long lastTm = 0L;
    private final boolean allowPopup;

    public AuthFailureStateListener(boolean allowPopup) {
        this.allowPopup = allowPopup;
    }

    public void currentState(GlassFishServer server, GlassFishStatus status, GlassFishStatusTask task) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newState(GlassFishServer server, GlassFishStatus status, GlassFishStatusTask task) {
        if (this.popUpLock) {
            AuthFailureStateListener authFailureStateListener = this;
            synchronized (authFailureStateListener) {
                if (this.popUpLock) {
                    this.popUpLock = false;
                }
            }
        }
    }

    public void error(GlassFishServer server, GlassFishStatusTask task) {
        block0 : switch (task.getType()) {
            case LOCATIONS: 
            case VERSION: {
                switch (task.getEvent()) {
                    case AUTH_FAILED_HTTP: {
                        GlassFishStatus.suspend((GlassFishServer)server);
                        break block0;
                    }
                    case AUTH_FAILED: {
                        if (this.allowPopup) {
                            if (!this.popUpLock) {
                                this.updateCredentials(server);
                                break block0;
                            }
                        } else {
                            GlassFishStatus.suspend((GlassFishServer)server);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCredentials(GlassFishServer server) {
        boolean update = true;
        AuthFailureStateListener authFailureStateListener = this;
        synchronized (authFailureStateListener) {
            if (!this.popUpLock && this.lastTm + 30000L < System.currentTimeMillis()) {
                this.popUpLock = true;
                if (server instanceof GlassfishInstance) {
                    try {
                        GlassfishInstance instance = (GlassfishInstance)server;
                        String message = NbBundle.getMessage(AuthFailureStateListener.class, (String)"AuthFailureStateListener.message", (Object)instance.getDisplayName());
                        update = GlassFishCredentials.setCredentials(instance, message);
                        this.popUpLock = !update;
                    }
                    catch (Throwable throwable) {
                        this.popUpLock = !update;
                        this.lastTm = System.currentTimeMillis();
                        throw throwable;
                    }
                    this.lastTm = System.currentTimeMillis();
                }
            }
        }
        if (!update) {
            GlassFishStatus.suspend((GlassFishServer)server);
        }
    }
}

