/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.queries;

import java.net.URI;
import java.net.URL;
import java.util.LinkedHashSet;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.spi.queries.JavaLikeRootProvider;
import org.netbeans.spi.java.queries.JavadocForBinaryQueryImplementation;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation2;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

abstract class AbstractMavenForBinaryQueryImpl
implements SourceForBinaryQueryImplementation2,
JavadocForBinaryQueryImplementation {
    protected AbstractMavenForBinaryQueryImpl() {
    }

    public SourceForBinaryQuery.Result findSourceRoots(URL url) {
        return this.findSourceRoots2(url);
    }

    @CheckForNull
    static String jarify(@NullAllowed String path) {
        return path != null ? path.replaceFirst("[.][^./]+$", ".jar") : null;
    }

    @NonNull
    static FileObject[] getProjectSrcRoots(Project p) {
        NbMavenProjectImpl project = (NbMavenProjectImpl)p.getLookup().lookup(NbMavenProjectImpl.class);
        LinkedHashSet<FileObject> toReturn = new LinkedHashSet<FileObject>();
        for (String item : project.getOriginalMavenProject().getCompileSourceRoots()) {
            FileObject fo = FileUtilities.convertStringToFileObject(item);
            if (fo == null) continue;
            toReturn.add(fo);
        }
        for (URI genRoot : project.getGeneratedSourceRoots(false)) {
            FileObject fo = FileUtilities.convertURItoFileObject(genRoot);
            if (fo == null) continue;
            toReturn.add(fo);
        }
        for (JavaLikeRootProvider rp : project.getLookup().lookupAll(JavaLikeRootProvider.class)) {
            FileObject fo = project.getProjectDirectory().getFileObject("src/main/" + rp.kind());
            if (fo == null) continue;
            toReturn.add(fo);
        }
        URI[] res = project.getResources(false);
        for (int i = 0; i < res.length; ++i) {
            FileObject fo = FileUtilities.convertURItoFileObject(res[i]);
            if (fo == null) continue;
            boolean ok = true;
            for (FileObject form : toReturn) {
                if (!FileUtil.isParentOf((FileObject)fo, (FileObject)form)) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            toReturn.add(fo);
        }
        return toReturn.toArray(new FileObject[0]);
    }

    @NonNull
    static FileObject[] getProjectTestSrcRoots(Project p) {
        NbMavenProjectImpl project = (NbMavenProjectImpl)p.getLookup().lookup(NbMavenProjectImpl.class);
        LinkedHashSet<FileObject> toReturn = new LinkedHashSet<FileObject>();
        for (String item : project.getOriginalMavenProject().getTestCompileSourceRoots()) {
            FileObject fo = FileUtilities.convertStringToFileObject(item);
            if (fo == null) continue;
            toReturn.add(fo);
        }
        for (URI genRoot : project.getGeneratedSourceRoots(true)) {
            FileObject fo = FileUtilities.convertURItoFileObject(genRoot);
            if (fo == null) continue;
            toReturn.add(fo);
        }
        for (JavaLikeRootProvider rp : project.getLookup().lookupAll(JavaLikeRootProvider.class)) {
            FileObject fo = project.getProjectDirectory().getFileObject("src/test/" + rp.kind());
            if (fo == null) continue;
            toReturn.add(fo);
        }
        URI[] res = project.getResources(true);
        for (int i = 0; i < res.length; ++i) {
            FileObject fo = FileUtilities.convertURItoFileObject(res[i]);
            if (fo == null) continue;
            boolean ok = true;
            for (FileObject form : toReturn) {
                if (!FileUtil.isParentOf((FileObject)fo, (FileObject)form)) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            toReturn.add(fo);
        }
        return toReturn.toArray(new FileObject[0]);
    }
}

