/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gsf.testrunner.api;

import java.net.URI;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public final class UnitTestsUsage {
    private static UnitTestsUsage INSTANCE;
    private HashMap<URI, String> projectsAlreadyLogged = new HashMap();

    private UnitTestsUsage() {
    }

    public static UnitTestsUsage getInstance() {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        return new UnitTestsUsage();
    }

    public void logUnitTestUsage(URI projectURI, String unitTestLibrary) {
        assert (projectURI != null) : "Project's URI cannot be null";
        assert (unitTestLibrary != null) : "Unit test's library cannot be null";
        Logger logger = Logger.getLogger("org.netbeans.ui.metrics.unittestslibrary");
        LogRecord rec = new LogRecord(Level.INFO, "USG_UNIT_TESTS_LIBRARY");
        if (unitTestLibrary.isEmpty()) {
            return;
        }
        if (!this.projectsAlreadyLogged.containsKey(projectURI)) {
            this.projectsAlreadyLogged.put(projectURI, unitTestLibrary.toString());
        } else {
            String unitTestLibrariesUsed = this.projectsAlreadyLogged.get(projectURI);
            if (unitTestLibrariesUsed.equals(unitTestLibrary)) {
                return;
            }
            this.projectsAlreadyLogged.put(projectURI, unitTestLibrary);
        }
        rec.setParameters(new Object[]{unitTestLibrary.toString()});
        rec.setLoggerName(logger.getName());
        logger.log(rec);
    }
}

