/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.search.api;

import java.util.Objects;
import org.apache.maven.search.api.request.Paging;
import org.apache.maven.search.api.request.Query;

public final class SearchRequest {
    private final Paging paging;
    private final Query query;

    public SearchRequest(Query query) {
        this(new Paging(50), query);
    }

    public SearchRequest(Paging paging, Query query) {
        this.paging = Objects.requireNonNull(paging);
        this.query = Objects.requireNonNull(query);
    }

    public Paging getPaging() {
        return this.paging;
    }

    public Query getQuery() {
        return this.query;
    }

    public SearchRequest nextPage() {
        return new SearchRequest(this.paging.nextPage(), this.query);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{paging=" + String.valueOf(this.paging) + ", query=" + String.valueOf(this.query) + "}";
    }
}

