/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.opengl.shaders;

import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.test.opengl.shaders.Shader;
import org.lwjgl.test.opengl.shaders.ShadersTest;

final class ShaderFSH
extends Shader {
    final String vshFile;
    final String vshSource;
    final int vshID;
    final String fshFile;
    final String fshSource;
    final int fshID;
    final int programID;
    final int uniformLocation;

    ShaderFSH(String vshFile, String fshFile) {
        this.vshFile = vshFile;
        this.vshSource = ShaderFSH.getShaderText(vshFile);
        this.vshID = ARBShaderObjects.glCreateShaderObjectARB((int)35633);
        ARBShaderObjects.glShaderSourceARB((int)this.vshID, (CharSequence)this.vshSource);
        ARBShaderObjects.glCompileShaderARB((int)this.vshID);
        ShaderFSH.printShaderObjectInfoLog(this.vshFile, this.vshID);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)this.vshID, (int)35713) == 0) {
            ShadersTest.kill("A compilation error occured in a vertex shader.");
        }
        this.fshFile = fshFile;
        this.fshSource = ShaderFSH.getShaderText(fshFile);
        this.fshID = ARBShaderObjects.glCreateShaderObjectARB((int)35632);
        ARBShaderObjects.glShaderSourceARB((int)this.fshID, (CharSequence)this.fshSource);
        ARBShaderObjects.glCompileShaderARB((int)this.fshID);
        ShaderFSH.printShaderObjectInfoLog(this.fshFile, this.fshID);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)this.fshID, (int)35713) == 0) {
            ShadersTest.kill("A compilation error occured in a fragment shader.");
        }
        this.programID = ARBShaderObjects.glCreateProgramObjectARB();
        ARBShaderObjects.glAttachObjectARB((int)this.programID, (int)this.vshID);
        ARBShaderObjects.glAttachObjectARB((int)this.programID, (int)this.fshID);
        ARBShaderObjects.glLinkProgramARB((int)this.programID);
        ShaderFSH.printShaderProgramInfoLog(this.programID);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)this.programID, (int)35714) == 0) {
            ShadersTest.kill("A linking error occured in a shader program.");
        }
        this.uniformLocation = ShaderFSH.getUniformLocation(this.programID, "UNIFORMS");
    }

    @Override
    void render() {
        ARBShaderObjects.glUseProgramObjectARB((int)this.programID);
        ARBShaderObjects.glUniform4fARB((int)this.uniformLocation, (float)ShadersTest.getSin(), (float)((float)ShadersTest.getSpecularity() * 8.0f), (float)((float)(-ShadersTest.getDisplayWidth()) * 0.5f), (float)((float)(-ShadersTest.getDisplayHeight()) * 0.5f));
        ShadersTest.renderObject();
        ARBShaderObjects.glUseProgramObjectARB((int)0);
    }

    @Override
    void cleanup() {
        ARBShaderObjects.glDetachObjectARB((int)this.programID, (int)this.vshID);
        ARBShaderObjects.glDetachObjectARB((int)this.programID, (int)this.fshID);
        ARBShaderObjects.glDeleteObjectARB((int)this.vshID);
        ARBShaderObjects.glDeleteObjectARB((int)this.fshID);
        ARBShaderObjects.glDeleteObjectARB((int)this.programID);
    }
}

