/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.github.dmlloyd.classfile.Annotation;
import io.github.dmlloyd.classfile.AnnotationElement;
import io.github.dmlloyd.classfile.AnnotationValue;
import io.github.dmlloyd.classfile.attribute.RuntimeInvisibleAnnotationsAttribute;
import io.github.dmlloyd.classfile.attribute.RuntimeVisibleAnnotationsAttribute;
import io.quarkus.gizmo2.creator.AnnotatableCreator;
import io.quarkus.gizmo2.creator.AnnotationCreator;
import io.quarkus.gizmo2.impl.AnnotationCreatorImpl;
import io.quarkus.gizmo2.impl.Util;
import io.smallrye.common.constraint.Assert;
import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.constant.ClassDesc;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class AnnotatableCreatorImpl
implements AnnotatableCreator {
    protected final String creationSite = Util.trackCaller();
    Map<ClassDesc, Annotation> invisible;
    Map<ClassDesc, Annotation> visible;

    protected AnnotatableCreatorImpl() {
        this.invisible = Map.of();
        this.visible = Map.of();
    }

    protected AnnotatableCreatorImpl(List<Annotation> visible, List<Annotation> invisible) {
        this.invisible = invisible.isEmpty() ? Map.of() : (Map)invisible.stream().collect(Collectors.toMap(Annotation::classSymbol, Function.identity(), (a, b) -> {
            throw new IllegalStateException();
        }, LinkedHashMap::new));
        this.visible = visible.isEmpty() ? Map.of() : (Map)visible.stream().collect(Collectors.toMap(Annotation::classSymbol, Function.identity(), (a, b) -> {
            throw new IllegalStateException();
        }, LinkedHashMap::new));
    }

    private Map<ClassDesc, Annotation> visibleMap() {
        Map<ClassDesc, Annotation> map = this.visible;
        if (map.isEmpty()) {
            map = this.visible = new LinkedHashMap<ClassDesc, Annotation>(4);
        }
        return map;
    }

    private Map<ClassDesc, Annotation> invisibleMap() {
        Map<ClassDesc, Annotation> map = this.invisible;
        if (map.isEmpty()) {
            map = this.invisible = new LinkedHashMap<ClassDesc, Annotation>(4);
        }
        return map;
    }

    public abstract ElementType annotationTargetType();

    @Override
    public <A extends java.lang.annotation.Annotation> void addAnnotation(Class<A> annotationClass, Consumer<AnnotationCreator<A>> builder) {
        RetentionPolicy retentionPolicy;
        Set<ElementType> elementTypes;
        Assert.checkNotNullParam((String)"annotationClass", annotationClass);
        Assert.checkNotNullParam((String)"builder", builder);
        Target target = annotationClass.getAnnotation(Target.class);
        if (target != null && !(elementTypes = Set.of(target.value())).contains((Object)this.annotationTargetType())) {
            throw new IllegalArgumentException("Annotation %s is not allowed on element type `%s` (the allowed set is %s)".formatted(new Object[]{annotationClass, this.annotationTargetType(), elementTypes}));
        }
        Retention retention = annotationClass.getAnnotation(Retention.class);
        Annotation annotation = AnnotationCreatorImpl.makeAnnotation(annotationClass, builder);
        RetentionPolicy retentionPolicy2 = retentionPolicy = retention == null ? RetentionPolicy.RUNTIME : retention.value();
        if (retentionPolicy == RetentionPolicy.SOURCE) {
            return;
        }
        Repeatable repeatable = annotationClass.getAnnotation(Repeatable.class);
        if (repeatable != null) {
            Map<ClassDesc, Annotation> map = this.getAnnotationMap(retentionPolicy);
            ClassDesc repeatableType = Util.classDesc(repeatable.value());
            if (map.containsKey(annotation.classSymbol())) {
                Annotation old = map.remove(annotation.classSymbol());
                map.put(repeatableType, Annotation.of((ClassDesc)repeatableType, List.of(AnnotationElement.of((String)"value", (AnnotationValue)AnnotationValue.ofArray((AnnotationValue[])new AnnotationValue[]{AnnotationValue.ofAnnotation((Annotation)old), AnnotationValue.ofAnnotation((Annotation)annotation)})))));
            } else if (map.containsKey(repeatableType)) {
                Annotation old = map.get(repeatableType);
                AnnotationValue.OfArray value = old.elements().stream().filter(ae -> ae.name().equalsString("value")).map(AnnotationElement::value).map(AnnotationValue.OfArray.class::cast).findFirst().orElseThrow();
                Annotation replacement = Annotation.of((ClassDesc)repeatableType, List.of(AnnotationElement.of((String)"value", (AnnotationValue)AnnotationValue.ofArray(Stream.concat(value.values().stream(), Stream.of(AnnotationValue.ofAnnotation((Annotation)annotation))).toList()))));
                map.replace(repeatableType, old, replacement);
            } else {
                this.registerAnnotation(retentionPolicy, annotation);
            }
        } else {
            this.registerAnnotation(retentionPolicy, annotation);
        }
    }

    private Map<ClassDesc, Annotation> getAnnotationMap(RetentionPolicy retentionPolicy) {
        return switch (retentionPolicy) {
            default -> throw new IncompatibleClassChangeError();
            case RetentionPolicy.SOURCE -> throw Assert.impossibleSwitchCase((Object)((Object)retentionPolicy));
            case RetentionPolicy.CLASS -> this.invisibleMap();
            case RetentionPolicy.RUNTIME -> this.visibleMap();
        };
    }

    @Override
    public void addAnnotation(ClassDesc annotationClass, RetentionPolicy retentionPolicy, Consumer<AnnotationCreator<java.lang.annotation.Annotation>> builder) {
        Assert.checkNotNullParam((String)"annotationClass", (Object)annotationClass);
        Assert.checkNotNullParam((String)"retentionPolicy", (Object)((Object)retentionPolicy));
        Assert.checkNotNullParam((String)"builder", builder);
        Annotation annotation = AnnotationCreatorImpl.makeAnnotation(annotationClass, builder);
        if (retentionPolicy == RetentionPolicy.SOURCE) {
            return;
        }
        this.registerAnnotation(retentionPolicy, annotation);
    }

    private void registerAnnotation(RetentionPolicy retentionPolicy, Annotation annotation) {
        Annotation existing = this.getAnnotationMap(retentionPolicy).putIfAbsent(annotation.classSymbol(), annotation);
        if (existing != null) {
            throw new IllegalArgumentException("Duplicate annotation %s".formatted(annotation.className().stringValue()));
        }
    }

    void addInvisible(Consumer<? super RuntimeInvisibleAnnotationsAttribute> consumer) {
        if (!this.invisible.isEmpty()) {
            consumer.accept((RuntimeInvisibleAnnotationsAttribute)RuntimeInvisibleAnnotationsAttribute.of(List.copyOf(this.invisible.values())));
        }
    }

    void addVisible(Consumer<? super RuntimeVisibleAnnotationsAttribute> consumer) {
        if (!this.visible.isEmpty()) {
            consumer.accept((RuntimeVisibleAnnotationsAttribute)RuntimeVisibleAnnotationsAttribute.of(List.copyOf(this.visible.values())));
        }
    }

    public List<Annotation> invisible() {
        return List.copyOf(this.invisible.values());
    }

    public List<Annotation> visible() {
        return List.copyOf(this.visible.values());
    }
}

