/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.artifacts.ExternalModuleDependencyBundle;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.provider.DefaultListProperty;
import org.gradle.api.internal.provider.DefaultMapProperty;
import org.gradle.api.internal.provider.DefaultProperty;
import org.gradle.api.internal.provider.DefaultSetProperty;
import org.gradle.api.internal.provider.PropertyFactory;
import org.gradle.api.internal.provider.PropertyHost;
import org.gradle.model.internal.asm.AsmClassGeneratorUtils;

public class DefaultPropertyFactory
implements PropertyFactory {
    private final PropertyHost propertyHost;

    public DefaultPropertyFactory(PropertyHost propertyHost) {
        this.propertyHost = propertyHost;
    }

    @Override
    @Deprecated
    public DefaultProperty<?> propertyWithNoType() {
        return new DefaultProperty(this.propertyHost, null);
    }

    @Override
    @Deprecated
    public <T> DefaultProperty<T> propertyOfAnyType(Class<T> type) {
        return new DefaultProperty<T>(this.propertyHost, DefaultPropertyFactory.maybeAsWrapperType(type));
    }

    @Override
    public <T> DefaultProperty<T> property(Class<T> type) {
        if (List.class.isAssignableFrom(type)) {
            if (!ExternalModuleDependencyBundle.class.isAssignableFrom(type)) {
                throw new InvalidUserCodeException(DefaultPropertyFactory.invalidPropertyCreationError("List<..>", "ListProperty<..>"));
            }
        } else {
            if (Set.class.isAssignableFrom(type)) {
                throw new InvalidUserCodeException(DefaultPropertyFactory.invalidPropertyCreationError("Set<..>", "SetProperty<..>"));
            }
            if (Map.class.isAssignableFrom(type)) {
                throw new InvalidUserCodeException(DefaultPropertyFactory.invalidPropertyCreationError("Map<..>", "MapProperty<..>"));
            }
            if (Directory.class.isAssignableFrom(type)) {
                throw new InvalidUserCodeException(DefaultPropertyFactory.invalidPropertyCreationError("Directory", "DirectoryProperty"));
            }
            if (RegularFile.class.isAssignableFrom(type)) {
                throw new InvalidUserCodeException(DefaultPropertyFactory.invalidPropertyCreationError("RegularFile", "RegularFileProperty"));
            }
        }
        return new DefaultProperty<T>(this.propertyHost, DefaultPropertyFactory.maybeAsWrapperType(type));
    }

    private static String invalidPropertyCreationError(String attemptedType, String correctType) {
        return "Creating a property of type 'Property<" + attemptedType + ">' is unsupported. Use '" + correctType + "' instead.";
    }

    @Override
    public <T> DefaultListProperty<T> listProperty(Class<T> elementType) {
        return new DefaultListProperty<T>(this.propertyHost, DefaultPropertyFactory.maybeAsWrapperType(elementType));
    }

    @Override
    public <T> DefaultSetProperty<T> setProperty(Class<T> elementType) {
        return new DefaultSetProperty<T>(this.propertyHost, DefaultPropertyFactory.maybeAsWrapperType(elementType));
    }

    @Override
    public <V, K> DefaultMapProperty<K, V> mapProperty(Class<K> keyType, Class<V> valueType) {
        return new DefaultMapProperty<K, V>(this.propertyHost, DefaultPropertyFactory.maybeAsWrapperType(keyType), DefaultPropertyFactory.maybeAsWrapperType(valueType));
    }

    private static <T> Class<T> maybeAsWrapperType(Class<T> type) {
        if (type.isPrimitive()) {
            Class wrapper;
            Class castWrapper = wrapper = AsmClassGeneratorUtils.getWrapperTypeForPrimitiveType(type);
            return castWrapper;
        }
        return type;
    }
}

