/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.isolated;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.gradle.api.file.ArchiveOperations;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.problems.internal.InternalProblems;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.api.specs.Spec;
import org.gradle.internal.Cast;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.internal.reflect.Types;
import org.gradle.internal.service.ServiceLookup;
import org.gradle.internal.service.ServiceLookupException;
import org.gradle.internal.service.UnknownServiceException;
import org.gradle.process.ExecOperations;

public class IsolationScheme<IMPLEMENTATION, PARAMS> {
    private final Class<IMPLEMENTATION> interfaceType;
    private final Class<PARAMS> paramsType;
    private final Class<? extends PARAMS> noParamsType;

    public IsolationScheme(Class<IMPLEMENTATION> interfaceType, Class<PARAMS> paramsType, Class<? extends PARAMS> noParamsType) {
        this.interfaceType = interfaceType;
        this.paramsType = paramsType;
        this.noParamsType = noParamsType;
    }

    @Nullable
    public <T extends IMPLEMENTATION, P extends PARAMS> Class<P> parameterTypeFor(Class<T> implementationType) {
        return this.parameterTypeFor(implementationType, 0);
    }

    @Nullable
    public <T extends IMPLEMENTATION, P extends PARAMS> Class<P> parameterTypeFor(Class<T> implementationType, int typeArgumentIndex) {
        if (implementationType == this.interfaceType) {
            return null;
        }
        Class<P> parametersType = this.inferParameterType(implementationType, typeArgumentIndex);
        if (parametersType == this.paramsType) {
            TreeFormatter formatter = new TreeFormatter();
            formatter.node("Could not create the parameters for ");
            formatter.appendType(implementationType);
            formatter.append((CharSequence)": must use a sub-type of ");
            formatter.appendType(parametersType);
            formatter.append((CharSequence)" as the parameters type. Use ");
            formatter.appendType(this.noParamsType);
            formatter.append((CharSequence)" as the parameters type for implementations that do not take parameters.");
            throw new IllegalArgumentException(formatter.toString());
        }
        if (parametersType == this.noParamsType) {
            return null;
        }
        return parametersType;
    }

    @Nonnull
    private <T extends IMPLEMENTATION, P extends PARAMS> Class<P> inferParameterType(Class<T> implementationType, int typeArgumentIndex) {
        AtomicReference foundType = new AtomicReference();
        HashMap collectedTypes = new HashMap();
        Types.walkTypeHierarchy(implementationType, type -> {
            for (Type genericInterface : type.getGenericInterfaces()) {
                if (!this.collectTypeParameters(genericInterface, foundType, collectedTypes, typeArgumentIndex)) continue;
                return Types.TypeVisitResult.TERMINATE;
            }
            Type genericSuperclass = type.getGenericSuperclass();
            if (this.collectTypeParameters(genericSuperclass, foundType, collectedTypes, typeArgumentIndex)) {
                return Types.TypeVisitResult.TERMINATE;
            }
            return Types.TypeVisitResult.CONTINUE;
        });
        Type type2 = this.unwrapTypeVariable((Type)foundType.get());
        return type2 instanceof Class ? (Class)Cast.uncheckedNonnullCast((Object)type2) : (type2 instanceof ParameterizedType ? (Class)Cast.uncheckedNonnullCast((Object)((ParameterizedType)type2).getRawType()) : (Class)Cast.uncheckedNonnullCast(this.paramsType));
    }

    private boolean collectTypeParameters(Type type, AtomicReference<Type> foundType, Map<Type, Type> collectedTypeParameters, int typeArgumentIndex) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            if (parameterizedType.getRawType().equals(this.interfaceType)) {
                Type parameter = parameterizedType.getActualTypeArguments()[typeArgumentIndex];
                foundType.set(collectedTypeParameters.getOrDefault(parameter, parameter));
                return true;
            }
            Type[] actualTypes = parameterizedType.getActualTypeArguments();
            TypeVariable<Class<T>>[] typeParameters = ((Class)parameterizedType.getRawType()).getTypeParameters();
            for (int i = 0; i < typeParameters.length; ++i) {
                Type firstActualInTypeChain = collectedTypeParameters.getOrDefault(actualTypes[i], actualTypes[i]);
                collectedTypeParameters.put(typeParameters[i], firstActualInTypeChain);
            }
        }
        return false;
    }

    private Type unwrapTypeVariable(Type type) {
        if (type instanceof TypeVariable) {
            Type nextType;
            ArrayDeque<Type> queue = new ArrayDeque<Type>();
            queue.add(type);
            while ((nextType = (Type)queue.poll()) != null) {
                for (Type bound : ((TypeVariable)nextType).getBounds()) {
                    if (bound instanceof TypeVariable) {
                        queue.add(bound);
                        continue;
                    }
                    if (!IsolationScheme.isAssignableFromType(this.paramsType, bound)) continue;
                    return bound;
                }
            }
        }
        return type;
    }

    private static boolean isAssignableFromType(Class<?> clazz, Type type) {
        return type instanceof Class && clazz.isAssignableFrom((Class)type) || type instanceof ParameterizedType && clazz.isAssignableFrom((Class)((ParameterizedType)type).getRawType());
    }

    public ServiceLookup servicesForImplementation(@Nullable PARAMS params, ServiceLookup allServices) {
        return this.servicesForImplementation(params, allServices, Collections.emptyList(), c -> false);
    }

    public ServiceLookup servicesForImplementation(@Nullable PARAMS params, ServiceLookup allServices, Collection<? extends Class<?>> additionalWhiteListedServices, Spec<Class<?>> whiteListPolicy) {
        return new ServicesForIsolatedObject(this.interfaceType, this.noParamsType, params, allServices, additionalWhiteListedServices, whiteListPolicy);
    }

    private static class ServicesForIsolatedObject
    implements ServiceLookup {
        private final Class<?> interfaceType;
        private final Class<?> noParamsType;
        private final Collection<? extends Class<?>> additionalWhiteListedServices;
        private final ServiceLookup allServices;
        private final Object params;
        private final Spec<Class<?>> whiteListPolicy;

        public ServicesForIsolatedObject(Class<?> interfaceType, Class<?> noParamsType, @Nullable Object params, ServiceLookup allServices, Collection<? extends Class<?>> additionalWhiteListedServices, Spec<Class<?>> whiteListPolicy) {
            this.interfaceType = interfaceType;
            this.noParamsType = noParamsType;
            this.additionalWhiteListedServices = additionalWhiteListedServices;
            this.allServices = allServices;
            this.params = params;
            this.whiteListPolicy = whiteListPolicy;
        }

        @Nullable
        public Object find(Type serviceType) throws ServiceLookupException {
            if (serviceType instanceof Class) {
                Class serviceClass = (Class)Cast.uncheckedNonnullCast((Object)serviceType);
                if (serviceClass.isInstance(this.params)) {
                    return this.params;
                }
                if (serviceClass.isAssignableFrom(this.noParamsType)) {
                    throw new ServiceLookupException(String.format("Cannot query the parameters of an instance of %s that takes no parameters.", this.interfaceType.getSimpleName()));
                }
                if (serviceClass.isAssignableFrom(ExecOperations.class)) {
                    return this.allServices.find(ExecOperations.class);
                }
                if (serviceClass.isAssignableFrom(FileSystemOperations.class)) {
                    return this.allServices.find(FileSystemOperations.class);
                }
                if (serviceClass.isAssignableFrom(ArchiveOperations.class)) {
                    return this.allServices.find(ArchiveOperations.class);
                }
                if (serviceClass.isAssignableFrom(ObjectFactory.class)) {
                    return this.allServices.find(ObjectFactory.class);
                }
                if (serviceClass.isAssignableFrom(ProviderFactory.class)) {
                    return this.allServices.find(ProviderFactory.class);
                }
                if (serviceClass.isAssignableFrom(BuildServiceRegistry.class)) {
                    return this.allServices.find(BuildServiceRegistry.class);
                }
                if (serviceClass.isAssignableFrom(InternalProblems.class)) {
                    return this.allServices.find(InternalProblems.class);
                }
                for (Class<?> whiteListedService : this.additionalWhiteListedServices) {
                    if (!serviceClass.isAssignableFrom(whiteListedService)) continue;
                    return this.allServices.find(whiteListedService);
                }
                if (this.whiteListPolicy.isSatisfiedBy((Object)serviceClass)) {
                    return this.allServices.find((Type)serviceClass);
                }
            }
            return null;
        }

        public Object get(Type serviceType) throws UnknownServiceException, ServiceLookupException {
            Object result = this.find(serviceType);
            if (result == null) {
                return this.notFound(serviceType);
            }
            return result;
        }

        public Object get(Type serviceType, Class<? extends Annotation> annotatedWith) throws UnknownServiceException, ServiceLookupException {
            return this.notFound(serviceType);
        }

        private Object notFound(Type serviceType) {
            TreeFormatter formatter = new TreeFormatter();
            formatter.node("Services of type ");
            formatter.appendType(serviceType);
            formatter.append((CharSequence)" are not available for injection into instances of type ");
            formatter.appendType(this.interfaceType);
            formatter.append((CharSequence)".");
            throw new UnknownServiceException(serviceType, formatter.toString());
        }
    }
}

